/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.teradata.tpcds.BusinessKeyGenerator;
import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.distribution.ShipModeDistributions;
import com.teradata.tpcds.generator.ShipModeGeneratorColumn;
import com.teradata.tpcds.random.RandomValueGenerator;
import com.teradata.tpcds.row.ShipModeRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;

public class ShipModeRowGenerator
extends AbstractRowGenerator {
    public ShipModeRowGenerator() {
        super(Table.SHIP_MODE);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.SHIP_MODE, this.getRandomNumberStream(ShipModeGeneratorColumn.SM_NULLS));
        long smShipModeSk = rowNumber;
        String smShipModeId = BusinessKeyGenerator.makeBusinessKey(rowNumber);
        long index = rowNumber;
        String smType = ShipModeDistributions.getShipModeTypeForIndexModSize(rowNumber);
        String smCode = ShipModeDistributions.getShipModeCodeForIndexModSize(index /= (long)ShipModeDistributions.SHIP_MODE_TYPE_DISTRIBUTION.getSize());
        String smCarrier = ShipModeDistributions.getShipModeCarrierAtIndex((int)rowNumber - 1);
        String smContract = RandomValueGenerator.generateRandomCharset("abcdefghijklmnopqrstuvxyzABCDEFGHIJKLMNOPQRSTUVXYZ0123456789", 1, 20, this.getRandomNumberStream(ShipModeGeneratorColumn.SM_CONTRACT));
        return new RowGeneratorResult(new ShipModeRow(nullBitMap, smShipModeSk, smShipModeId, smType, smCode, smCarrier, smContract));
    }
}

