/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IntervalColumn;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

public final class PartialBroadcastOrderedIntersectProperty
implements IPartitioningProperty {
    private final List<IntervalColumn> intervalColumns;
    private final RangeMap rangeMap;
    private INodeDomain domain;

    public PartialBroadcastOrderedIntersectProperty(List<IntervalColumn> intervalColumns, INodeDomain domain, RangeMap rangeMap) {
        this.intervalColumns = intervalColumns;
        this.domain = domain;
        this.rangeMap = rangeMap;
    }

    @Override
    public IPartitioningProperty.PartitioningType getPartitioningType() {
        return IPartitioningProperty.PartitioningType.PARTIAL_BROADCAST_ORDERED_INTERSECT;
    }

    public String toString() {
        return this.getPartitioningType().toString() + this.intervalColumns + " domain:" + this.domain + (this.rangeMap != null ? " range-map:" + this.rangeMap : "");
    }

    public List<IntervalColumn> getIntervalColumns() {
        return this.intervalColumns;
    }

    @Override
    public void getColumns(Collection<LogicalVariable> columns) {
        for (IntervalColumn ic : this.intervalColumns) {
            columns.add(ic.getStartColumn());
            columns.add(ic.getEndColumn());
        }
    }

    public RangeMap getRangeMap() {
        return this.rangeMap;
    }

    @Override
    public INodeDomain getNodeDomain() {
        return this.domain;
    }

    @Override
    public void setNodeDomain(INodeDomain domain) {
        this.domain = domain;
    }

    @Override
    public IPartitioningProperty normalize(Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        return this;
    }

    @Override
    public IPartitioningProperty substituteColumnVars(Map<LogicalVariable, LogicalVariable> varMap) {
        boolean applied = false;
        ArrayList<IntervalColumn> newIntervalColumns = new ArrayList<IntervalColumn>(this.intervalColumns.size());
        for (IntervalColumn intervalColumn : this.intervalColumns) {
            LogicalVariable startColumnVar = intervalColumn.getStartColumn();
            LogicalVariable newStartColumnVar = varMap.get(startColumnVar);
            if (newStartColumnVar != null) {
                applied = true;
            } else {
                newStartColumnVar = startColumnVar;
            }
            LogicalVariable endColumnVar = intervalColumn.getEndColumn();
            LogicalVariable newEndColumnVar = varMap.get(endColumnVar);
            if (newEndColumnVar != null) {
                applied = true;
            } else {
                newEndColumnVar = endColumnVar;
            }
            newIntervalColumns.add(new IntervalColumn(newStartColumnVar, newEndColumnVar, intervalColumn.getOrder()));
        }
        return applied ? new PartialBroadcastOrderedIntersectProperty(newIntervalColumns, this.domain, this.rangeMap) : this;
    }

    @Override
    public IPartitioningProperty clonePartitioningProperty() {
        return new PartialBroadcastOrderedIntersectProperty(new ArrayList<IntervalColumn>(this.intervalColumns), this.domain, this.rangeMap);
    }
}

