/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class FixReplicateOperatorOutputsRule
implements IAlgebraicRewriteRule {
    private final Map<AbstractReplicateOperator, MutableInt> replicateOperators;
    private final List<Mutable<ILogicalOperator>> parentsPathToReplicate = new ArrayList<Mutable<ILogicalOperator>>();

    public FixReplicateOperatorOutputsRule() {
        this.replicateOperators = new HashMap<AbstractReplicateOperator, MutableInt>();
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        this.parentsPathToReplicate.add(opRef);
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        this.parentsPathToReplicate.remove(this.parentsPathToReplicate.size() - 1);
        if (op.getOperatorTag() == LogicalOperatorTag.DISTRIBUTE_RESULT || op.getOperatorTag() == LogicalOperatorTag.SINK || op.getOperatorTag() == LogicalOperatorTag.DELEGATE_OPERATOR && ((DelegateOperator)op).getDelegate() instanceof CommitOperator) {
            for (Map.Entry<AbstractReplicateOperator, MutableInt> entry : this.replicateOperators.entrySet()) {
                if (entry.getKey().getOutputs().size() == entry.getValue().getValue().intValue()) continue;
                throw new CompilationException(1054, op.getSourceLocation(), new Serializable[0]);
            }
            return false;
        }
        if (op.getOperatorTag() != LogicalOperatorTag.REPLICATE && op.getOperatorTag() != LogicalOperatorTag.SPLIT || context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        AbstractReplicateOperator replicateOperator = (AbstractReplicateOperator)op;
        this.replicateOperators.putIfAbsent(replicateOperator, new MutableInt(0));
        Mutable<ILogicalOperator> replicateActualParent = this.parentsPathToReplicate.get(this.parentsPathToReplicate.size() - 1);
        if (replicateOperator.getOutputs().contains(replicateActualParent)) {
            this.updateNumberOfParentsDone(replicateOperator);
            if (this.replicateOperators.get(replicateOperator).getValue().intValue() == replicateOperator.getOutputs().size()) {
                context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue());
            }
            return false;
        }
        boolean parentFixed = false;
        for (int oldParentIndex = 0; oldParentIndex < replicateOperator.getOutputs().size(); ++oldParentIndex) {
            if (!this.parentsPathToReplicate.contains(replicateOperator.getOutputs().get(oldParentIndex))) continue;
            replicateOperator.getOutputs().set(oldParentIndex, replicateActualParent);
            parentFixed = true;
            this.updateNumberOfParentsDone(replicateOperator);
            break;
        }
        if (this.replicateOperators.get(replicateOperator).getValue().intValue() == replicateOperator.getOutputs().size()) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue());
        }
        return parentFixed;
    }

    private void updateNumberOfParentsDone(AbstractReplicateOperator replicateOperator) {
        MutableInt numParentsDone = this.replicateOperators.get(replicateOperator);
        Integer newNumParentsDone = numParentsDone.getValue() + 1;
        numParentsDone.setValue((Number)newNumParentsDone);
    }
}

