/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.nonvisitor;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.BooleanPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.VarLengthTypeTrait;
import org.apache.hyracks.util.string.UTF8StringUtil;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class ARecordPointable
extends AbstractPointable {
    public static final ARecordPointableFactory FACTORY = new ARecordPointableFactory();
    private final UTF8StringWriter utf8Writer = new UTF8StringWriter();
    public static final IObjectFactory<IPointable, ATypeTag> ALLOCATOR = type -> new ARecordPointable();
    static final int TAG_SIZE = 1;
    static final int RECORD_LENGTH_SIZE = 4;
    static final int EXPANDED_SIZE = 1;
    static final int OPEN_OFFSET_SIZE = 4;
    static final int CLOSED_COUNT_SIZE = 4;
    static final int FIELD_OFFSET_SIZE = 4;
    static final int OPEN_COUNT_SIZE = 4;
    private static final int OPEN_FIELD_HASH_SIZE = 4;
    private static final int OPEN_FIELD_OFFSET_SIZE = 4;
    private static final int OPEN_FIELD_HEADER = 8;

    private static boolean isOpen(ARecordType recordType) {
        return recordType == null || recordType.isOpen();
    }

    public final int getSchemeFieldCount(ARecordType recordType) {
        return recordType.getFieldNames().length;
    }

    public int getLength() {
        return IntegerPointable.getInteger((byte[])this.bytes, (int)(this.start + 1));
    }

    private boolean isExpanded(ARecordType recordType) {
        return ARecordPointable.isOpen(recordType) && BooleanPointable.getBoolean((byte[])this.bytes, (int)(this.start + 1 + 4));
    }

    private int getOpenPartOffset(ARecordType recordType) {
        return this.start + 1 + 4 + (ARecordPointable.isOpen(recordType) ? 1 : 0);
    }

    private int getNullBitmapOffset(ARecordType recordType) {
        return this.getOpenPartOffset(recordType) + (this.isExpanded(recordType) ? 4 : 0) + 4;
    }

    private int getNullBitmapSize(ARecordType recordType) {
        return RecordUtil.computeNullBitmapSize(recordType);
    }

    public boolean isClosedFieldNull(ARecordType recordType, int fieldId) {
        return this.getNullBitmapSize(recordType) > 0 && RecordUtil.isNull(this.bytes[this.getNullBitmapOffset(recordType) + fieldId / 4], fieldId);
    }

    private boolean isClosedFieldMissing(ARecordType recordType, int fieldId) {
        return this.getNullBitmapSize(recordType) > 0 && RecordUtil.isMissing(this.bytes[this.getNullBitmapOffset(recordType) + fieldId / 4], fieldId);
    }

    public final void getClosedFieldValue(ARecordType recordType, int fieldId, DataOutput dOut) throws IOException {
        if (this.isClosedFieldNull(recordType, fieldId)) {
            dOut.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
        } else if (this.isClosedFieldMissing(recordType, fieldId)) {
            dOut.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
        } else {
            dOut.write(this.getClosedFieldTag(recordType, fieldId));
            dOut.write(this.bytes, this.getClosedFieldOffset(recordType, fieldId), this.getClosedFieldSize(recordType, fieldId));
        }
    }

    public final void getClosedFieldValue(ARecordType recordType, int fieldId, IPointable pointable) throws IOException {
        if (this.isClosedFieldNull(recordType, fieldId) || this.isClosedFieldMissing(recordType, fieldId)) {
            throw new IllegalStateException("Can't read a null or missing field");
        }
        pointable.set(this.bytes, this.getClosedFieldOffset(recordType, fieldId), this.getClosedFieldSize(recordType, fieldId));
    }

    private String getClosedFieldName(ARecordType recordType, int fieldId) {
        return recordType.getFieldNames()[fieldId];
    }

    public final void getClosedFieldName(ARecordType recordType, int fieldId, DataOutput dOut) throws IOException {
        dOut.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        this.utf8Writer.writeUTF8((CharSequence)this.getClosedFieldName(recordType, fieldId), dOut);
    }

    public final byte getClosedFieldTag(ARecordType recordType, int fieldId) {
        return this.getClosedFieldType(recordType, fieldId).getTypeTag().serialize();
    }

    public final IAType getClosedFieldType(ARecordType recordType, int fieldId) {
        IAType aType = recordType.getFieldTypes()[fieldId];
        if (NonTaggedFormatUtil.isOptional(aType)) {
            aType = ((AUnionType)aType).getActualType();
        }
        return aType;
    }

    public final int getClosedFieldSize(ARecordType recordType, int fieldId) throws HyracksDataException {
        if (this.isClosedFieldNull(recordType, fieldId)) {
            return 0;
        }
        return NonTaggedFormatUtil.getFieldValueLength(this.bytes, this.getClosedFieldOffset(recordType, fieldId), this.getClosedFieldType(recordType, fieldId).getTypeTag(), false);
    }

    public final int getClosedFieldOffset(ARecordType recordType, int fieldId) {
        int offset = this.getNullBitmapOffset(recordType) + this.getNullBitmapSize(recordType) + fieldId * 4;
        return this.start + IntegerPointable.getInteger((byte[])this.bytes, (int)offset);
    }

    public final int getOpenFieldCount(ARecordType recordType) {
        return this.isExpanded(recordType) ? IntegerPointable.getInteger((byte[])this.bytes, (int)this.getOpenFieldCountOffset(recordType)) : 0;
    }

    private int getOpenFieldCountSize(ARecordType recordType) {
        return this.isExpanded(recordType) ? 4 : 0;
    }

    private int getOpenFieldCountOffset(ARecordType recordType) {
        return this.start + IntegerPointable.getInteger((byte[])this.bytes, (int)this.getOpenPartOffset(recordType));
    }

    public final void getOpenFieldValue(ARecordType recordType, int fieldId, DataOutput dOut) throws IOException {
        dOut.write(this.bytes, this.getOpenFieldValueOffset(recordType, fieldId), this.getOpenFieldValueSize(recordType, fieldId));
    }

    public final int getOpenFieldValueOffset(ARecordType recordType, int fieldId) {
        return this.getOpenFieldNameOffset(recordType, fieldId) + this.getOpenFieldNameSize(recordType, fieldId);
    }

    public final int getOpenFieldValueSize(ARecordType recordType, int fieldId) throws HyracksDataException {
        int offset = this.getOpenFieldValueOffset(recordType, fieldId);
        ATypeTag tag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.getOpenFieldTag(recordType, fieldId));
        return NonTaggedFormatUtil.getFieldValueLength(this.bytes, offset, tag, true);
    }

    public final void getOpenFieldName(ARecordType recordType, int fieldId, DataOutput dOut) throws IOException {
        dOut.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        dOut.write(this.bytes, this.getOpenFieldNameOffset(recordType, fieldId), this.getOpenFieldNameSize(recordType, fieldId));
    }

    public final String getOpenFieldName(ARecordType recordType, int fieldId) {
        StringBuilder str = new StringBuilder();
        int offset = this.getOpenFieldNameOffset(recordType, fieldId);
        return UTF8StringUtil.toString((StringBuilder)str, (byte[])this.bytes, (int)offset).toString();
    }

    private int getOpenFieldNameSize(ARecordType recordType, int fieldId) {
        int utfleng = UTF8StringUtil.getUTFLength((byte[])this.bytes, (int)this.getOpenFieldNameOffset(recordType, fieldId));
        return utfleng + UTF8StringUtil.getNumBytesToStoreLength((int)utfleng);
    }

    private int getOpenFieldNameOffset(ARecordType recordType, int fieldId) {
        return this.getOpenFieldOffset(recordType, fieldId);
    }

    public final byte getOpenFieldTag(ARecordType recordType, int fieldId) {
        return this.bytes[this.getOpenFieldValueOffset(recordType, fieldId)];
    }

    private int getOpenFieldHashOffset(ARecordType recordType, int fieldId) {
        return this.getOpenFieldCountOffset(recordType) + this.getOpenFieldCountSize(recordType) + fieldId * 8;
    }

    private int getOpenFieldOffset(ARecordType recordType, int fieldId) {
        return this.start + IntegerPointable.getInteger((byte[])this.bytes, (int)this.getOpenFieldOffsetOffset(recordType, fieldId));
    }

    private int getOpenFieldOffsetOffset(ARecordType recordType, int fieldId) {
        return this.getOpenFieldHashOffset(recordType, fieldId) + 4;
    }

    public static final class ARecordPointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        private ARecordPointableFactory() {
        }

        public ARecordPointable createPointable() {
            return new ARecordPointable();
        }

        public ITypeTraits getTypeTraits() {
            return VarLengthTypeTrait.INSTANCE;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

