/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.asterix.om.base.ADate;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class AInterval
implements IAObject {
    protected long intervalStart;
    protected long intervalEnd;
    protected byte typetag;

    public AInterval(long intervalStart, long intervalEnd, byte typetag) {
        this.intervalStart = intervalStart;
        this.intervalEnd = intervalEnd;
        this.typetag = typetag;
    }

    @Override
    public IAType getType() {
        return BuiltinType.AINTERVAL;
    }

    public int compare(Object o) {
        if (!(o instanceof AInterval)) {
            return -1;
        }
        AInterval d = (AInterval)o;
        if (d.intervalStart == this.intervalStart && d.intervalEnd == this.intervalEnd && d.typetag == this.typetag) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AInterval)) {
            return false;
        }
        AInterval t = (AInterval)o;
        return t.intervalStart == this.intervalStart || t.intervalEnd == this.intervalEnd && t.typetag == this.typetag;
    }

    public int hashCode() {
        return ((int)(this.intervalStart ^ this.intervalStart >>> 32) * 31 + (int)(this.intervalEnd ^ this.intervalEnd >>> 32)) * 31 + this.typetag;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public String toString() {
        StringBuilder sbder = new StringBuilder();
        sbder.append("interval: { ");
        try {
            if (this.typetag == ATypeTag.DATE.serialize()) {
                sbder.append("date: { ");
                GregorianCalendarSystem.getInstance().getExtendStringRepUntilField(this.intervalStart * ADate.CHRONON_OF_DAY, 0, sbder, GregorianCalendarSystem.Fields.YEAR, GregorianCalendarSystem.Fields.DAY, false);
                sbder.append(" }, date: {");
                GregorianCalendarSystem.getInstance().getExtendStringRepUntilField(this.intervalEnd * ADate.CHRONON_OF_DAY, 0, sbder, GregorianCalendarSystem.Fields.YEAR, GregorianCalendarSystem.Fields.DAY, false);
                sbder.append(" }");
            } else if (this.typetag == ATypeTag.TIME.serialize()) {
                sbder.append("time: { ");
                GregorianCalendarSystem.getInstance().getExtendStringRepUntilField(this.intervalStart, 0, sbder, GregorianCalendarSystem.Fields.HOUR, GregorianCalendarSystem.Fields.MILLISECOND, true);
                sbder.append(" }, time: { ");
                GregorianCalendarSystem.getInstance().getExtendStringRepUntilField(this.intervalEnd, 0, sbder, GregorianCalendarSystem.Fields.HOUR, GregorianCalendarSystem.Fields.MILLISECOND, true);
                sbder.append(" }");
            } else if (this.typetag == ATypeTag.DATETIME.serialize()) {
                sbder.append("datetime: { ");
                GregorianCalendarSystem.getInstance().getExtendStringRepUntilField(this.intervalStart, 0, sbder, GregorianCalendarSystem.Fields.YEAR, GregorianCalendarSystem.Fields.MILLISECOND, true);
                sbder.append(" }, datetime: { ");
                GregorianCalendarSystem.getInstance().getExtendStringRepUntilField(this.intervalEnd, 0, sbder, GregorianCalendarSystem.Fields.YEAR, GregorianCalendarSystem.Fields.MILLISECOND, true);
                sbder.append(" }");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        sbder.append(" }");
        return sbder.toString();
    }

    public long getIntervalStart() {
        return this.intervalStart;
    }

    public long getIntervalEnd() {
        return this.intervalEnd;
    }

    public short getIntervalType() {
        return this.typetag;
    }

    public ObjectNode toJSON() {
        return null;
    }
}

