// This file was generated by $generator from $template

#pragma once
#include "$prefixDevice.h"

#include "$prefixDeviceObject.h"
#include "$prefixArrayObjects.h"
#include "$prefixFrameObject.h"


#include <cstdio>

$begin_namespaces

/******************************************************************************
   The following code serves illustration purposes and should be replaced.
   Further specializations are provided in $prefixFrameObject.h and
   $prefixArrayObjects.h since frame and array objects have extended
   interfaces.

   Most likely you want to specialize other objects in their own
   headers/implementiation files and just include them here.

   Spezialize objects by inheriting from DefaultObject<T> to get common behavior and
   override only what you need. Don't forget to call the DefaultObject::
   versions of the functions you override where required (commit, set, unset,
   retain, release).
******************************************************************************/


template<>
class Object<RendererDefault> : public DefaultObject<RendererDefault> {
public:
   using base = DefaultObject<RendererDefault>;

   Object(ANARIDevice device, ANARIObject handle)
   : base(device, handle)
   {

   }

   void commit() override {
      base::commit();
      std::printf("Hi, I'm a %s renderer.\n", subtype());

      // read a parameter from current parameter state
      const char *name = nullptr;
      if(current.name.get(ANARI_STRING, &name)) {
         std::printf("My name is %s.\n", name);
      }

      // strings can also be accessed via getString()
      if(const char *name2 = current.name.getString()) {
         std::printf("My name is %s again.\n", name);
      }

   }

   ANARIObject firstOwner = nullptr;
   bool uniqueOwnership = true;

   // override retainInternal/releaseInternal to keep track
   // of who holds references to this object
   void retainInternal(ANARIObject obj) override {
      base::retainInternal(obj);
      if(firstOwner == nullptr) {
         firstOwner = obj;
      } else if(obj != firstOwner) {
         uniqueOwnership = false;
      }
   }
};


$end_namespaces
