\name{N4BiasFieldCorrectionImageFilter}
\alias{N4BiasFieldCorrectionImageFilter}
\title{N4BiasFieldCorrectionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Implementation of the N4 bias field correction algorithm.
N4BiasFieldCorrectionImageFilter}
\details{
The nonparametric nonuniform intensity normalization (N3) algorithm,
as introduced by Sled et al. in 1998 is a method for correcting
nonuniformity associated with MR images. The algorithm assumes a
simple parametric model (Gaussian) for the bias field and does not
require tissue class segmentation. In addition, there are only a
couple of parameters to tune with the default values performing quite
well. N3 has been publicly available as a set of perl scripts ( https://www.bic.mni.mcgill.ca/ServicesSoftwareAdvancedImageProcessingT
ools/HomePage )
The N4 algorithm, encapsulated with this class, is a variation of the
original N3 algorithm with the additional benefits of an improved
B-spline fitting routine which allows for multiple resolutions to be
used during the correction process. We also modify the iterative
update component of algorithm such that the residual bias field is
continually updated
Notes for the user:
Since much of the image manipulation is done in the log space of the
intensities, input images with negative and small values (< 1) can
produce poor results.
The original authors recommend performing the bias field correction on
a downsampled version of the original image.
A binary mask or a weighted image can be supplied. If a binary mask is
specified, those voxels in the input image which correspond to the
voxels in the mask image are used to estimate the bias field. If a
UseMaskLabel value is set to false (the default), all non-zero voxels
in the MaskImage will be masked; otherwise only voxels in the
MaskImage that match the MaskLabel will be used. If a confidence image
is specified, the input voxels are weighted in the b-spline fitting
routine according to the confidence voxel values.
The filter returns the corrected image. If the bias field is wanted,
one can reconstruct it using the class
itkBSplineControlPointImageFilter. See the IJ article and the test
file for an example.
The 'Z' parameter in Sled's 1998 paper is the square root of the class
variable 'm_WienerFilterNoise'.
 The basic algorithm iterates between sharpening the intensity
histogram of the corrected input image and spatially smoothing those
results with a B-spline scalar field estimate of the bias field.
Nicholas J. Tustison
 Contributed by Nicholas J. Tustison, James C. Gee in the Insight
Journal paper: https://www.insight-journal.org/browse/publication/640
REFERENCE
 J.G. Sled, A.P. Zijdenbos and A.C. Evans. "A Nonparametric Method
for Automatic Correction of Intensity Nonuniformity in Data" IEEE
Transactions on Medical Imaging, Vol 17, No 1. Feb 1998.
N.J. Tustison, B.B. Avants, P.A. Cook, Y. Zheng, A. Egan, P.A.
Yushkevich, and J.C. Gee. "N4ITK: Improved N3 Bias Correction" IEEE
Transactions on Medical Imaging, 29(6):1310-1320, June 2010.
See:
N4BiasFieldCorrection for the procedural interface
itk::N4BiasFieldCorrectionImageFilter for the Doxygen on the original ITK class.
N4BiasFieldCorrectionImageFilter}
%C++ includes: sitkN4BiasFieldCorrectionImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image):}{}
\item{Image Execute(const Image &image, const Image &maskImage):}{
Execute the filter on the input image
}
\item{double GetBiasFieldFullWidthAtHalfMaximum() const:}{
Get the full width at half maximum parameter characterizing the width
of the Gaussian deconvolution. Default = 0.15.
}
\item{double GetConvergenceThreshold() const:}{
Get the convergence threshold. Convergence is determined by the
coefficient of variation of the difference image between the current
bias field estimate and the previous estimate. If this value is less
than the specified threshold, the algorithm proceeds to the next
fitting level or terminates if it is at the last level.
}
\item{double GetCurrentConvergenceMeasurement() const:}{
Get the current convergence measurement. This is a helper function for
reporting observations.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{uint32_t GetCurrentLevel() const:}{
Get the current fitting level. This is a helper function for reporting
observations.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{uint32_t GetElapsedIterations() const:}{
Get the number of elapsed iterations. This is a helper function for
reporting observations.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{Image GetLogBiasFieldAsImage(Image referenceImage) const:}{
The computed log bias field correction. Typically, a reduced size
image is used as input to the N4 filter using something like
itkShrinkImageFilter. Since the output is a corrected version of the
input, the user will probably want to apply the bias field correction
to the full resolution image. Returns the b-spline log bias field
reconstructioned onto the space of the referenceImage parameter. An
input image can be corrected by: input/exp(bias_field).
 This is an active measurement. It may be accessed while the  filter
is being executing in command call-backs and can be  accessed after
execution.
}
\item{uint8_t GetMaskLabel() const:}{
Set/Get mask label value. If a binary mask image is specified and if
UseMaskValue is true, only those input image voxels corresponding with
mask image values equal to MaskLabel are used in estimating the bias
field. If a MaskImage is specified and UseMaskLabel is false, all
input image voxels corresponding to non-zero voxels in the MaskImage
are used in estimating the bias field. Default = 1.
}
\item{std::vector< uint32_t > GetMaximumNumberOfIterations() const:}{
Get the maximum number of iterations specified at each fitting level.
Default = 50.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< uint32_t > GetNumberOfControlPoints() const:}{
Get the control point grid size defining the B-spline estimate of the
scalar bias field. In each dimension, the B-spline mesh size is equal
to the number of control points in that dimension minus the spline
order. Default = 4 control points in each dimension for a mesh size of
1 in each dimension.
}
\item{uint32_t GetNumberOfHistogramBins() const:}{
Get number of bins defining the log input intensity histogram. Default
= 200.
}
\item{uint32_t GetSplineOrder() const:}{
Get the spline order defining the bias field estimate. Default = 3.
}
\item{bool GetUseMaskLabel() const:}{
Use a mask label for identifying mask functionality. See SetMaskLabel.
Defaults to true.
}
\item{double GetWienerFilterNoise() const:}{
Get the noise estimate defining the Wiener filter. Default = 0.01.
}
\item{ N4BiasFieldCorrectionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetBiasFieldFullWidthAtHalfMaximum(double BiasFieldFullWidthAtHalfMaximum):}{
Set the full width at half maximum parameter characterizing the width
of the Gaussian deconvolution. Default = 0.15.
}
\item{Self SetConvergenceThreshold(double ConvergenceThreshold):}{
Set the convergence threshold. Convergence is determined by the
coefficient of variation of the difference image between the current
bias field estimate and the previous estimate. If this value is less
than the specified threshold, the algorithm proceeds to the next
fitting level or terminates if it is at the last level.
}
\item{Self SetMaskLabel(uint8_t MaskLabel):}{
Set/Get mask label value. If a binary mask image is specified and if
UseMaskValue is true, only those input image voxels corresponding with
mask image values equal to MaskLabel are used in estimating the bias
field. If a MaskImage is specified and UseMaskLabel is false, all
input image voxels corresponding to non-zero voxels in the MaskImage
are used in estimating the bias field. Default = 1.
}
\item{Self SetMaximumNumberOfIterations(std::vector< uint32_t > MaximumNumberOfIterations):}{
Set the maximum number of iterations specified at each fitting level.
Default = 50.
}
\item{Self SetNumberOfControlPoints(std::vector< uint32_t > NumberOfControlPoints):}{
Set the control point grid size defining the B-spline estimate of the
scalar bias field. In each dimension, the B-spline mesh size is equal
to the number of control points in that dimension minus the spline
order. Default = 4 control points in each dimension for a mesh size of
1 in each dimension.
}
\item{Self SetNumberOfControlPoints(uint32_t value):}{
Set the values of the NumberOfControlPoints vector all to value
}
\item{Self SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins):}{
Set number of bins defining the log input intensity histogram. Default
= 200.
}
\item{Self SetSplineOrder(uint32_t SplineOrder):}{
Set the spline order defining the bias field estimate. Default = 3.
}
\item{Self SetUseMaskLabel(bool UseMaskLabel):}{
Use a mask label for identifying mask functionality. See SetMaskLabel.
Defaults to true.
}
\item{Self SetWienerFilterNoise(double WienerFilterNoise):}{
Set the noise estimate defining the Wiener filter. Default = 0.01.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseMaskLabelOff():}{}
\item{Self UseMaskLabelOn():}{
Set the value of UseMaskLabel to true or false respectfully.
}
\item{ ~N4BiasFieldCorrectionImageFilter():}{
Destructor
}
}
}
