"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.correlationsSavedObjectType = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// @experimental This schema is experimental and might change in future releases.
const correlationsSavedObjectType = exports.correlationsSavedObjectType = {
  name: 'correlations',
  hidden: false,
  namespaceType: 'single',
  management: {
    icon: 'link',
    defaultSearchField: 'correlationType',
    importableAndExportable: true,
    getTitle(obj) {
      return `Correlation ${obj.id}`;
    }
  },
  mappings: {
    properties: {
      correlationType: {
        type: 'keyword'
      },
      version: {
        type: 'keyword'
      },
      entities: {
        type: 'object',
        enabled: false
      }
    }
  },
  migrations: {}
};