/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.scale.searchonly;

import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlock;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.block.ClusterBlocks;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.common.UUIDs;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.index.Index;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.repositories.IndexId;

class ScaleIndexClusterStateBuilder {
    ScaleIndexClusterStateBuilder() {
    }

    ClusterState buildScaleDownState(ClusterState currentState, String index, Map<Index, ClusterBlock> blockedIndices) {
        Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        Index idx = indexMetadata.getIndex();
        ClusterBlock scaleBlock = ScaleIndexClusterStateBuilder.createScaleDownBlock();
        blocksBuilder.addIndexBlock(index, scaleBlock);
        blockedIndices.put(idx, scaleBlock);
        return ClusterState.builder(currentState).metadata(metadataBuilder).blocks(blocksBuilder).routingTable(routingTableBuilder.build()).build();
    }

    ClusterState buildFinalScaleDownState(ClusterState currentState, String index) {
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
        Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        if (indexMetadata == null) {
            throw new IllegalStateException("Index " + index + " not found");
        }
        blocksBuilder.removeIndexBlockWithId(index, 20);
        Settings updatedSettings = Settings.builder().put(indexMetadata.getSettings()).put(IndexMetadata.INDEX_BLOCKS_SEARCH_ONLY_SETTING.getKey(), true).build();
        metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(updatedSettings).settingsVersion(indexMetadata.getSettingsVersion() + 1L));
        blocksBuilder.addIndexBlock(index, IndexMetadata.INDEX_SEARCH_ONLY_BLOCK);
        this.updateRoutingTableForScaleDown(routingTableBuilder, currentState, index);
        return ClusterState.builder(currentState).metadata(metadataBuilder).blocks(blocksBuilder).routingTable(routingTableBuilder.build()).build();
    }

    private void updateRoutingTableForScaleDown(RoutingTable.Builder routingTableBuilder, ClusterState currentState, String index) {
        IndexRoutingTable indexRoutingTable = currentState.routingTable().index(index);
        if (indexRoutingTable != null) {
            IndexRoutingTable.Builder indexBuilder = new IndexRoutingTable.Builder(indexRoutingTable.getIndex());
            for (IndexShardRoutingTable shardTable : indexRoutingTable) {
                IndexShardRoutingTable.Builder shardBuilder = new IndexShardRoutingTable.Builder(shardTable.shardId());
                for (ShardRouting shardRouting : shardTable) {
                    if (!shardRouting.isSearchOnly()) continue;
                    shardBuilder.addShard(shardRouting);
                }
                indexBuilder.addIndexShard(shardBuilder.build());
            }
            routingTableBuilder.add(indexBuilder.build());
        }
    }

    RoutingTable buildScaleUpRoutingTable(ClusterState currentState, String index) {
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
        IndexRoutingTable indexRoutingTable = currentState.routingTable().index(index);
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        if (indexRoutingTable != null && indexMetadata != null) {
            IndexRoutingTable.Builder indexBuilder = new IndexRoutingTable.Builder(indexRoutingTable.getIndex());
            for (IndexShardRoutingTable shardTable : indexRoutingTable) {
                indexBuilder.addIndexShard(this.buildShardTableForScaleUp(shardTable, indexMetadata));
            }
            routingTableBuilder.add(indexBuilder.build());
        }
        return routingTableBuilder.build();
    }

    private IndexShardRoutingTable buildShardTableForScaleUp(IndexShardRoutingTable shardTable, IndexMetadata indexMetadata) {
        IndexShardRoutingTable.Builder shardBuilder = new IndexShardRoutingTable.Builder(shardTable.shardId());
        for (ShardRouting shardRouting : shardTable) {
            if (!shardRouting.isSearchOnly()) continue;
            shardBuilder.addShard(shardRouting);
        }
        RecoverySource.RemoteStoreRecoverySource remoteStoreRecoverySource = new RecoverySource.RemoteStoreRecoverySource(UUID.randomUUID().toString(), Version.CURRENT, new IndexId(shardTable.shardId().getIndex().getName(), shardTable.shardId().getIndex().getUUID()));
        int numberOfReplicas = indexMetadata.getNumberOfReplicas();
        ShardRouting primaryShard = ShardRouting.newUnassigned(shardTable.shardId(), true, remoteStoreRecoverySource, new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, "Restoring primary shard"));
        shardBuilder.addShard(primaryShard);
        for (int i = 0; i < numberOfReplicas; ++i) {
            ShardRouting replicaShard = ShardRouting.newUnassigned(shardTable.shardId(), false, RecoverySource.PeerRecoverySource.INSTANCE, new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, "Restoring replica shard"));
            shardBuilder.addShard(replicaShard);
        }
        return shardBuilder.build();
    }

    static ClusterBlock createScaleDownBlock() {
        return new ClusterBlock(20, UUIDs.randomBase64UUID(), "index preparing to scale down", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE));
    }
}

