/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd1;

import com.google.common.base.Strings;
import com.jthink.brainz.mmd.Artist;
import com.jthink.brainz.mmd.Metadata;
import com.jthink.brainz.mmd.ObjectFactory;
import com.jthink.brainz.mmd.ReleaseList;
import com.jthink.brainz.mmd.Track;
import com.jthink.brainz.mmd.TrackList;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;
import org.musicbrainz.mmd2.ArtistCredit;
import org.musicbrainz.mmd2.Medium;
import org.musicbrainz.mmd2.NameCredit;
import org.musicbrainz.mmd2.Recording;
import org.musicbrainz.mmd2.Release;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.RecordingIndexField;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd1.Mmd1XmlWriter;

public class TrackMmd1XmlWriter
extends Mmd1XmlWriter {
    public Metadata write(Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        Metadata metadata = of.createMetadata();
        TrackList trackList = of.createTrackList();
        for (Result result : results.results) {
            ArtistCredit acv2;
            MbDocument doc = result.getDoc();
            Track track = of.createTrack();
            result.setNormalizedScore(results.getMaxScore());
            track.getOtherAttributes().put(this.getScore(), String.valueOf(result.getNormalizedScore()));
            Recording recordingv2 = (Recording)MMDSerializer.unserialize((String)doc.get((IndexField)RecordingIndexField.RECORDING_STORE), Recording.class);
            track.setId(recordingv2.getId());
            if (!Strings.isNullOrEmpty((String)recordingv2.getTitle())) {
                track.setTitle(recordingv2.getTitle());
            }
            if (recordingv2.getLength() != null) {
                track.setDuration(recordingv2.getLength());
            }
            if ((acv2 = recordingv2.getArtistCredit()) != null && acv2.getNameCredit().size() > 0) {
                Artist artist = of.createArtist();
                artist.setName(((NameCredit)acv2.getNameCredit().get(0)).getArtist().getName());
                artist.setId(((NameCredit)acv2.getNameCredit().get(0)).getArtist().getId());
                artist.setSortName(((NameCredit)acv2.getNameCredit().get(0)).getArtist().getSortName());
                track.setArtist(artist);
            }
            if (recordingv2.getReleaseList() == null) continue;
            ReleaseList releaseList = of.createReleaseList();
            for (Release releasev2 : recordingv2.getReleaseList().getRelease()) {
                com.jthink.brainz.mmd.Release release = of.createRelease();
                release.setId(releasev2.getId());
                release.setTitle(releasev2.getTitle());
                release.getType().add(StringUtils.capitalize((String)releasev2.getReleaseGroup().getType()));
                TrackList releaseTrackList = of.createTrackList();
                releaseTrackList.setOffset(((Medium)releasev2.getMediumList().getMedium().get(0)).getTrackList().getOffset());
                releaseTrackList.setCount(((Medium)releasev2.getMediumList().getMedium().get(0)).getTrackList().getCount());
                release.setTrackList(releaseTrackList);
                releaseList.getRelease().add(release);
            }
            track.setReleaseList(releaseList);
            trackList.getTrack().add(track);
        }
        trackList.setCount(BigInteger.valueOf(results.getTotalHits()));
        trackList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setTrackList(trackList);
        return metadata;
    }
}

