/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: RegexAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.1 $
 * Last Modified: $Date: 2004/08/12 08:42:10 $
 *****************************************************************************/
package org.ten60.ura.util;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;
import java.util.regex.*;
import java.io.*;

import com.ten60.netkernel.urii.aspect.*;
import org.ten60.netkernel.layer1.representation.*;
/**
 *
 * @author  pjr
 */
public class RegexAccessor extends XAccessor
{
	
	/** Creates a new instance of LogAccessor */
	public RegexAccessor()
	{	declareArgument(OPERAND, true, true);
		declareArgument(OPERATOR, true, false);
		declareThreadSafe();
	}
	
	protected com.ten60.netkernel.urii.IURRepresentation source(XAHelper aHelper) throws Exception
	{	String test=aHelper.getOperand().getXDA().getText(".", true);
		IXDAReadOnly opt=aHelper.getOperator().getXDA();
		String pattern=opt.getText("/regex/pattern", true);
		String rewrite=null;
		if(opt.isTrue("/regex/rewrite"))
		{	rewrite=opt.getText("/regex/rewrite", true);
		}
		DOMXDA result=new DOMXDA(XMLUtils.getInstance().newDocument(),false);
		result.appendPath("/", "regex",null);
		Pattern p=Pattern.compile(pattern);
		Matcher m=p.matcher(test);
		result.appendPath("/regex", "matches", m.matches()?"true":"false");
		if(m.matches())
		{	for(int i=1; i<m.groupCount()+1; i++)
			{	try
				{	result.appendPath("/regex", "group", m.group(i));
				}
				catch(Exception e)
				{	result.appendPath("/regex", "group", "Error");
				}
			}
		}
		RegexRewriterRule rrw=new RegexRewriterRule(pattern,rewrite);
		result.appendPath("/regex","rewrite", rrw.map(test));
		return DOMXDAAspect.create(aHelper.getDependencyMeta("text/xml", 8), result);
	}
	
public final class RegexRewriterRule
{
	
	private Matcher mMatcher;
	private Matcher mToMatcher;
	private String mTo;
	
	/** Creates a new instance of RegexRewriterRule.
	 *	Matches are created and cached to reduce wasted objects.
	 */		
	public RegexRewriterRule(String aPattern, String aTo)
	{	Pattern pattern=Pattern.compile(aPattern);
		mMatcher=pattern.matcher("");

		Pattern groupPattern=Pattern.compile("\\$(e?\\d+)");
		mTo=aTo;
		mToMatcher=groupPattern.matcher(aTo);
	}

	/**
	 * Map a URI using the preconfigured Matchers
	 */
	 public String map(String aValue)
	 {	String result = aValue;
		mMatcher=mMatcher.reset(aValue);
		String replace=mTo;
		if(mMatcher.matches())
		{	mToMatcher.reset(replace);
			StringBuffer sb=new StringBuffer(replace.length()*2);
			while (mToMatcher.find())
			{	String toMatch = mToMatcher.group(1);
				char action = ' ';
				if (!Character.isDigit(toMatch.charAt(0)))
				{	action=toMatch.charAt(0);
					toMatch = toMatch.substring(1);
				}
				int j=Integer.parseInt(toMatch);
				String replacement = mMatcher.group(j);
				switch (action)
				{	case 'e':
						replacement = encode(replacement);
						break;
				}
				mToMatcher.appendReplacement(sb, replacement);
			 }
			 mToMatcher.appendTail(sb);			
			
			result = sb.toString();

		}
		return result;
	 }
	
	/** simple test to see if it matches without doing anything
	 */
	public synchronized boolean matches(CharSequence aString)
	{	mMatcher.reset(aString);
		return mMatcher.matches();
	}
	
	public String encode(String aInput)
	{	StringBuffer sb=new StringBuffer(aInput.length()*3/2);
		int length = aInput.length();
		for (int i=0; i<length; i++)
		{	char c = aInput.charAt(i);
			switch (c)
			{	case ' ': sb.append("%20"); break;
				case '%': sb.append("%25"); break;
				case ':': sb.append("%3A"); break;
				case '#': sb.append("%23"); break;
				case '+': sb.append("%2B"); break;
				case '@': sb.append("%40"); break;
				case '=': sb.append("%3D"); break;
				default: sb.append(c);
			}
		}
		return new String(sb);
	}	
	
}
}
