/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: AsyncJoinAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.1 $
 * Last Modified: $Date: 2004/08/12 11:40:31 $
 *****************************************************************************/
package org.ten60.ura.sys;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.urii.IURRepresentation;
import java.util.Iterator;
/**
 * Implements active:async and active:join
 * @author  tab
 */
public class AsyncJoinAccessor extends NKFAccessorImpl
{
	/** Creates a new instance of AsyncJoinAccessor */
	public AsyncJoinAccessor()
	{	super(0,true,URRequest.RQT_ALL);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	INKFRequestReadOnly thisRequest = context.getThisRequest();
		String accessorType=thisRequest.getActiveType();
		int type = thisRequest.getRequestType();
		if (accessorType.equals("async"))
		{	async(context);
		}
		else if (accessorType.equals("join") && type==URRequest.RQT_SOURCE)
		{	join(context);
		}
		else
		{	throw new IllegalArgumentException("Unknown type: "+accessorType);
		}
	}
	
	private void async(INKFConvenienceHelper context) throws Exception
	{	// build request
		INKFRequestReadOnly thisRequest = context.getThisRequest();
		INKFRequest request = context.createSubRequest();
		request.setRequestType(thisRequest.getRequestType());
		request.setURI(thisRequest.getArgument("uri"));
		for (Iterator i=thisRequest.getArguments(); i.hasNext(); )
		{	String arg = (String)i.next();
			if (arg.equals("uri")) continue;
			String uri = thisRequest.getArgument(arg);
			IURRepresentation value = thisRequest.getArgumentValue(uri);
			if (value!=null)
			{	request.addArgument(arg,value);
			}
			else
			{	request.addArgument(arg,uri);
			}
		}
		request.setAspectClass(thisRequest.getAspectClass());
		
		//issue request
		INKFAsyncRequestHandle handle = context.issueAsyncSubRequest(request);
		AsyncRequestAspect aspect = new AsyncRequestAspect(handle);
		INKFResponse response = context.createResponseFrom(aspect);
		context.setResponse(response);
	}
	
	private void join(INKFConvenienceHelper context) throws Exception
	{	AsyncRequestAspect aspect = (AsyncRequestAspect)context.sourceAspect("this:param:operand", AsyncRequestAspect.class);
		IURRepresentation result = aspect.join(0);
		INKFResponse response = context.createResponseFrom(result);
		context.setResponse(response);
	}
}