import java.io.*;
import java.util.*;
import java.lang.reflect.Constructor;
import java.net.*;

import org.ten60.netkernel.protocolhandler.sjar.Handler;

public class BootLoader
{
	public static void main(String[] args)
	{
		try
		{	if (args.length!=1)
			{	System.err.println("usage: Bootloader [installpath]");
				return;
			}
			
			File installPathDir = new File(args[0].replaceAll("#"," "));
			if (!installPathDir.exists())
			{	System.err.println("installpath ["+installPathDir+"] does not exist");
				return;
			}
			
			File bootloaderFile = new File(installPathDir,"etc/bootloader.conf");
			BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(bootloaderFile)));
			String line;
			List urlList = new ArrayList();
			String installPathURLString=installPathDir.toURI().toString();
			if (installPathURLString.contains(" "))
			{	installPathURLString=installPathURLString.replaceAll("\\ ", "%20");
			}
			URL installPathURL=new URL(installPathURLString);
			urlList.add(installPathURL);
			while ((line=r.readLine())!=null)
			{	line=line.trim();
				if (!line.startsWith("#") && line.length()>0)
				{	File be = new File(installPathDir,line);
					urlList.add(be.toURL());
				}
			}
			
			URL[] urls = new URL[urlList.size()];
			for (int i=0; i<urls.length; i++)
			{	urls[i]=(URL)urlList.get(i);
			}
			
			ClassLoader rootClassLoader= BootLoader.class.getClassLoader();
			while(rootClassLoader.getParent()!=null)
			{	rootClassLoader=rootClassLoader.getParent();
			}
	
			URLClassLoader ucl = new BootClassLoader(urls,rootClassLoader);
			Handler.init(ucl);
			Class c=ucl.loadClass("InnerBoot");
			Constructor ctr=c.getConstructor(new Class[]{File.class});
			ctr.newInstance(new Object[]{installPathDir});
		}
		
		catch (Throwable e)
		{	System.err.println(e.toString());
		}			
	}
}
