/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractResponse;

public class FetchResponse
extends AbstractResponse {
    public static final long INVALID_HIGH_WATERMARK = -1L;
    public static final long INVALID_LAST_STABLE_OFFSET = -1L;
    public static final long INVALID_LOG_START_OFFSET = -1L;
    public static final int INVALID_PREFERRED_REPLICA_ID = -1;
    private final FetchResponseData data;

    @Override
    public FetchResponseData data() {
        return this.data;
    }

    public FetchResponse(FetchResponseData fetchResponseData) {
        super(ApiKeys.FETCH);
        this.data = fetchResponseData;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> responseData(Map<Uuid, String> topicNames, short version) {
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        this.data.responses().forEach(topicResponse -> {
            String name = version < 13 ? topicResponse.topic() : (String)topicNames.get(topicResponse.topicId());
            if (name != null) {
                topicResponse.partitions().forEach(partition -> responseData.put(new TopicPartition(name, partition.partitionIndex()), (FetchResponseData.PartitionData)partition));
            }
        });
        return responseData;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public int sessionId() {
        return this.data.sessionId();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.updateErrorCounts(errorCounts, this.error());
        this.data.responses().forEach(topicResponse -> topicResponse.partitions().forEach(partition -> this.updateErrorCounts(errorCounts, Errors.forCode(partition.errorCode()))));
        return errorCounts;
    }

    public static FetchResponse parse(ByteBuffer buffer, short version) {
        return new FetchResponse(new FetchResponseData(new ByteBufferAccessor(buffer), version));
    }

    public Set<Uuid> topicIds() {
        return this.data.responses().stream().map(FetchResponseData.FetchableTopicResponse::topicId).filter(id -> !id.equals(Uuid.ZERO_UUID)).collect(Collectors.toSet());
    }

    public static int sizeOf(short version, Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> partIterator) {
        FetchResponseData data = FetchResponse.toMessage(Errors.NONE, 0, 0, partIterator, Collections.emptyList());
        ObjectSerializationCache cache = new ObjectSerializationCache();
        return 4 + data.size(cache, version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 8;
    }

    public static Optional<FetchResponseData.EpochEndOffset> divergingEpoch(FetchResponseData.PartitionData partitionResponse) {
        return partitionResponse.divergingEpoch().epoch() < 0 ? Optional.empty() : Optional.of(partitionResponse.divergingEpoch());
    }

    public static boolean isDivergingEpoch(FetchResponseData.PartitionData partitionResponse) {
        return partitionResponse.divergingEpoch().epoch() >= 0;
    }

    public static Optional<Integer> preferredReadReplica(FetchResponseData.PartitionData partitionResponse) {
        return partitionResponse.preferredReadReplica() == -1 ? Optional.empty() : Optional.of(partitionResponse.preferredReadReplica());
    }

    public static boolean isPreferredReplica(FetchResponseData.PartitionData partitionResponse) {
        return partitionResponse.preferredReadReplica() != -1;
    }

    public static FetchResponseData.PartitionData partitionResponse(TopicIdPartition topicIdPartition, Errors error) {
        return FetchResponse.partitionResponse(topicIdPartition.topicPartition().partition(), error);
    }

    public static FetchResponseData.PartitionData partitionResponse(int partition, Errors error) {
        return new FetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(error.code()).setHighWatermark(-1L);
    }

    public static Records recordsOrFail(FetchResponseData.PartitionData partition) {
        if (partition.records() == null) {
            return MemoryRecords.EMPTY;
        }
        if (partition.records() instanceof Records) {
            return (Records)partition.records();
        }
        throw new ClassCastException("The record type is " + partition.records().getClass().getSimpleName() + ", which is not a subtype of " + Records.class.getSimpleName() + ". This method is only safe to call if the `FetchResponse` was deserialized from bytes.");
    }

    public static int recordsSize(FetchResponseData.PartitionData partition) {
        return partition.records() == null ? 0 : partition.records().sizeInBytes();
    }

    public static FetchResponse of(Errors error, int throttleTimeMs, int sessionId, LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> responseData) {
        return new FetchResponse(FetchResponse.toMessage(error, throttleTimeMs, sessionId, responseData.entrySet().iterator(), Collections.emptyList()));
    }

    public static FetchResponse of(Errors error, int throttleTimeMs, int sessionId, LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> responseData, List<Node> nodeEndpoints) {
        return new FetchResponse(FetchResponse.toMessage(error, throttleTimeMs, sessionId, responseData.entrySet().iterator(), nodeEndpoints));
    }

    private static boolean matchingTopic(FetchResponseData.FetchableTopicResponse previousTopic, TopicIdPartition currentTopic) {
        if (previousTopic == null) {
            return false;
        }
        if (!previousTopic.topicId().equals(Uuid.ZERO_UUID)) {
            return previousTopic.topicId().equals(currentTopic.topicId());
        }
        return previousTopic.topic().equals(currentTopic.topicPartition().topic());
    }

    private static FetchResponseData toMessage(Errors error, int throttleTimeMs, int sessionId, Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> partIterator, List<Node> nodeEndpoints) {
        ArrayList<FetchResponseData.FetchableTopicResponse> topicResponseList = new ArrayList<FetchResponseData.FetchableTopicResponse>();
        while (partIterator.hasNext()) {
            FetchResponseData.FetchableTopicResponse previousTopic;
            Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> entry = partIterator.next();
            FetchResponseData.PartitionData partitionData = entry.getValue();
            partitionData.setPartitionIndex(entry.getKey().topicPartition().partition());
            FetchResponseData.FetchableTopicResponse fetchableTopicResponse = previousTopic = topicResponseList.isEmpty() ? null : (FetchResponseData.FetchableTopicResponse)topicResponseList.get(topicResponseList.size() - 1);
            if (FetchResponse.matchingTopic(previousTopic, entry.getKey())) {
                previousTopic.partitions().add(partitionData);
                continue;
            }
            ArrayList<FetchResponseData.PartitionData> partitionResponses = new ArrayList<FetchResponseData.PartitionData>();
            partitionResponses.add(partitionData);
            topicResponseList.add(new FetchResponseData.FetchableTopicResponse().setTopic(entry.getKey().topicPartition().topic()).setTopicId(entry.getKey().topicId()).setPartitions(partitionResponses));
        }
        FetchResponseData data = new FetchResponseData();
        nodeEndpoints.forEach(endpoint -> data.nodeEndpoints().add(new FetchResponseData.NodeEndpoint().setNodeId(endpoint.id()).setHost(endpoint.host()).setPort(endpoint.port()).setRack(endpoint.rack())));
        return data.setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setSessionId(sessionId).setResponses(topicResponseList);
    }
}

