# coding: utf-8

"""
    Kubernetes

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: release-1.35
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kubernetes.client.configuration import Configuration


class V1WorkloadReference(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'pod_group': 'str',
        'pod_group_replica_key': 'str'
    }

    attribute_map = {
        'name': 'name',
        'pod_group': 'podGroup',
        'pod_group_replica_key': 'podGroupReplicaKey'
    }

    def __init__(self, name=None, pod_group=None, pod_group_replica_key=None, local_vars_configuration=None):  # noqa: E501
        """V1WorkloadReference - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._pod_group = None
        self._pod_group_replica_key = None
        self.discriminator = None

        self.name = name
        self.pod_group = pod_group
        if pod_group_replica_key is not None:
            self.pod_group_replica_key = pod_group_replica_key

    @property
    def name(self):
        """Gets the name of this V1WorkloadReference.  # noqa: E501

        Name defines the name of the Workload object this Pod belongs to. Workload must be in the same namespace as the Pod. If it doesn't match any existing Workload, the Pod will remain unschedulable until a Workload object is created and observed by the kube-scheduler. It must be a DNS subdomain.  # noqa: E501

        :return: The name of this V1WorkloadReference.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this V1WorkloadReference.

        Name defines the name of the Workload object this Pod belongs to. Workload must be in the same namespace as the Pod. If it doesn't match any existing Workload, the Pod will remain unschedulable until a Workload object is created and observed by the kube-scheduler. It must be a DNS subdomain.  # noqa: E501

        :param name: The name of this V1WorkloadReference.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def pod_group(self):
        """Gets the pod_group of this V1WorkloadReference.  # noqa: E501

        PodGroup is the name of the PodGroup within the Workload that this Pod belongs to. If it doesn't match any existing PodGroup within the Workload, the Pod will remain unschedulable until the Workload object is recreated and observed by the kube-scheduler. It must be a DNS label.  # noqa: E501

        :return: The pod_group of this V1WorkloadReference.  # noqa: E501
        :rtype: str
        """
        return self._pod_group

    @pod_group.setter
    def pod_group(self, pod_group):
        """Sets the pod_group of this V1WorkloadReference.

        PodGroup is the name of the PodGroup within the Workload that this Pod belongs to. If it doesn't match any existing PodGroup within the Workload, the Pod will remain unschedulable until the Workload object is recreated and observed by the kube-scheduler. It must be a DNS label.  # noqa: E501

        :param pod_group: The pod_group of this V1WorkloadReference.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and pod_group is None:  # noqa: E501
            raise ValueError("Invalid value for `pod_group`, must not be `None`")  # noqa: E501

        self._pod_group = pod_group

    @property
    def pod_group_replica_key(self):
        """Gets the pod_group_replica_key of this V1WorkloadReference.  # noqa: E501

        PodGroupReplicaKey specifies the replica key of the PodGroup to which this Pod belongs. It is used to distinguish pods belonging to different replicas of the same pod group. The pod group policy is applied separately to each replica. When set, it must be a DNS label.  # noqa: E501

        :return: The pod_group_replica_key of this V1WorkloadReference.  # noqa: E501
        :rtype: str
        """
        return self._pod_group_replica_key

    @pod_group_replica_key.setter
    def pod_group_replica_key(self, pod_group_replica_key):
        """Sets the pod_group_replica_key of this V1WorkloadReference.

        PodGroupReplicaKey specifies the replica key of the PodGroup to which this Pod belongs. It is used to distinguish pods belonging to different replicas of the same pod group. The pod group policy is applied separately to each replica. When set, it must be a DNS label.  # noqa: E501

        :param pod_group_replica_key: The pod_group_replica_key of this V1WorkloadReference.  # noqa: E501
        :type: str
        """

        self._pod_group_replica_key = pod_group_replica_key

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1WorkloadReference):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1WorkloadReference):
            return True

        return self.to_dict() != other.to_dict()
