/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation;

import java.util.Collections;
import java.util.List;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;

public class ExplanationPreferences {
    private static final String PREFERENCES_SET_KEY_ = "EXPLANATION_PREFS_SET";
    private static final String DEFAULT_EXPLANATION_ID_ = "PREFERRED_PLUGIN_ID";
    private static final String USE_LAST_EXPLANATION_SERVICE_KEY_ = "USE_LAST_EXPLANATION_SERVICE";
    private static final String EXPLANATION_SERVICES_LIST_KEY_ = "EXPLANATION_SERVICES_LIST";
    private static final String DISABLED_EXPLANATION_SERVICES_KEY_ = "DISABLED_EXPLANATION_SERVICES";
    private static final String DEFAULT_DEFAULT_EXPLANATION_ID_ = null;
    private static final boolean DEFAULT_USE_LAST_EXPLANATION_SERVICE_ = true;
    private static final List<String> DEFAULT_EXPLANATION_SERVICES_LIST_ = Collections.emptyList();
    private static final List<String> DEFAULT_DISABLED_EXPLANATION_SERVICES_ = Collections.emptyList();
    public String defaultExplanationService;
    public boolean useLastExplanationService;
    public List<String> explanationServicesList;
    public List<String> disabledExplanationServices;

    private ExplanationPreferences() {
    }

    public static ExplanationPreferences create() {
        return new ExplanationPreferences().reset();
    }

    private static Preferences getPrefs() {
        PreferencesManager prefMan = PreferencesManager.getInstance();
        return prefMan.getPreferencesForSet(PREFERENCES_SET_KEY_, ExplanationPreferences.class);
    }

    public ExplanationPreferences load() {
        Preferences prefs = ExplanationPreferences.getPrefs();
        this.defaultExplanationService = prefs.getString(DEFAULT_EXPLANATION_ID_, DEFAULT_DEFAULT_EXPLANATION_ID_);
        this.useLastExplanationService = prefs.getBoolean(USE_LAST_EXPLANATION_SERVICE_KEY_, true);
        this.explanationServicesList = prefs.getStringList(EXPLANATION_SERVICES_LIST_KEY_, DEFAULT_EXPLANATION_SERVICES_LIST_);
        this.disabledExplanationServices = prefs.getStringList(DISABLED_EXPLANATION_SERVICES_KEY_, DEFAULT_DISABLED_EXPLANATION_SERVICES_);
        return this;
    }

    public ExplanationPreferences save() {
        Preferences prefs = ExplanationPreferences.getPrefs();
        prefs.putString(DEFAULT_EXPLANATION_ID_, this.defaultExplanationService);
        prefs.putBoolean(USE_LAST_EXPLANATION_SERVICE_KEY_, this.useLastExplanationService);
        prefs.putStringList(EXPLANATION_SERVICES_LIST_KEY_, this.explanationServicesList);
        prefs.putStringList(DISABLED_EXPLANATION_SERVICES_KEY_, this.disabledExplanationServices);
        return this;
    }

    public ExplanationPreferences reset() {
        this.defaultExplanationService = DEFAULT_DEFAULT_EXPLANATION_ID_;
        this.useLastExplanationService = true;
        this.explanationServicesList = DEFAULT_EXPLANATION_SERVICES_LIST_;
        this.disabledExplanationServices = DEFAULT_DISABLED_EXPLANATION_SERVICES_;
        return this;
    }
}

