/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.protege.editor.core.OntologyRepository;
import org.protege.editor.core.OntologyRepositoryEntry;

public class RepositoryTableModel
extends AbstractTableModel {
    private OntologyRepository repository;
    private List<OntologyRepositoryEntry> entries;
    public static final int ONTOLOGY_URI_COL = 1;

    public RepositoryTableModel(OntologyRepository repository) {
        this.repository = repository;
        this.entries = new ArrayList<OntologyRepositoryEntry>(repository.getEntries());
        Collections.sort(this.entries, new EntryShortNameURIComparator());
    }

    @Override
    public int getColumnCount() {
        return 2 + this.repository.getMetaDataKeys().size();
    }

    public void sortByColumn(int col) {
        if (col < 0) {
            return;
        }
        if (col >= this.getColumnCount()) {
            return;
        }
        if (col == 0) {
            this.sortByShortName();
        } else if (col == 1) {
            this.sortByOntologyURI();
        }
    }

    public void sortByShortName() {
        Collections.sort(this.entries, new EntryShortNameURIComparator());
        this.fireTableDataChanged();
    }

    public void sortByOntologyURI() {
        Collections.sort(this.entries, new EntryURIComparator());
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Name";
        }
        if (column == 1) {
            return "Ontology URI";
        }
        if (column < this.repository.getMetaDataKeys().size() + 2) {
            return this.repository.getMetaDataKeys().get(column - 2).toString();
        }
        return "";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.entries.get(rowIndex).getOntologyShortName();
        }
        if (columnIndex == 1) {
            return this.entries.get(rowIndex).getOntologyURI();
        }
        return this.entries.get(rowIndex).getMetaData(this.repository.getMetaDataKeys().get(columnIndex - 2));
    }

    public OntologyRepositoryEntry getEntryAt(int selectedRow) {
        if (selectedRow == -1) {
            return null;
        }
        return this.entries.get(selectedRow);
    }

    private class EntryShortNameURIComparator
    implements Comparator<OntologyRepositoryEntry> {
        private EntryShortNameURIComparator() {
        }

        @Override
        public int compare(OntologyRepositoryEntry o1, OntologyRepositoryEntry o2) {
            int diff = o1.getOntologyShortName().compareTo(o2.getOntologyShortName());
            if (diff != 0) {
                return diff;
            }
            return o1.getOntologyURI().compareTo(o2.getOntologyURI());
        }
    }

    private class EntryURIComparator
    implements Comparator<OntologyRepositoryEntry> {
        private EntryURIComparator() {
        }

        @Override
        public int compare(OntologyRepositoryEntry o1, OntologyRepositoryEntry o2) {
            return o1.getOntologyURI().compareTo(o2.getOntologyURI());
        }
    }
}

