/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auth.AuthDomain;
import org.opensearch.security.auth.AuthFailureListener;
import org.opensearch.security.auth.AuthenticationBackend;
import org.opensearch.security.auth.AuthenticationContext;
import org.opensearch.security.auth.AuthorizationBackend;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.auth.ImpersonationBackend;
import org.opensearch.security.auth.UserInjector;
import org.opensearch.security.auth.UserSubjectImpl;
import org.opensearch.security.auth.blocking.ClientBlockRegistry;
import org.opensearch.security.auth.internal.NoOpAuthenticationBackend;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ClusterInfoHolder;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.filter.SecurityRequestChannel;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.http.XFFResolver;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.support.HostAndCidrMatcher;
import org.opensearch.security.support.SecuritySettings;
import org.opensearch.security.user.AuthCredentials;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class BackendRegistry {
    protected static final Logger log = LogManager.getLogger(BackendRegistry.class);
    private SortedSet<AuthDomain> restAuthDomains;
    private Set<AuthorizationBackend> restAuthorizers;
    private List<AuthFailureListener> ipAuthFailureListeners;
    private Multimap<String, AuthFailureListener> authBackendFailureListeners;
    private List<ClientBlockRegistry<InetAddress>> ipClientBlockRegistries;
    private Multimap<String, ClientBlockRegistry<String>> authBackendClientBlockRegistries;
    private String hostResolverMode;
    private volatile boolean initialized;
    private volatile boolean injectedUserEnabled = false;
    private final AdminDNs adminDns;
    private final XFFResolver xffResolver;
    private volatile boolean anonymousAuthEnabled = false;
    private final Settings opensearchSettings;
    private final AuditLog auditLog;
    private final ThreadPool threadPool;
    private final UserInjector userInjector;
    private final ClusterInfoHolder clusterInfoHolder;
    private int ttlInMin;
    private Cache<AuthCredentials, User> userCache;
    private Cache<String, User> restImpersonationCache;
    private Cache<User, Set<String>> restRoleCache;

    private void createCaches() {
        this.userCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<AuthCredentials, User>(this){

            public void onRemoval(RemovalNotification<AuthCredentials, User> notification) {
                log.debug("Clear user cache for {} due to {}", (Object)((AuthCredentials)notification.getKey()).getUsername(), (Object)notification.getCause());
            }
        }).build();
        this.restImpersonationCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, User>(this){

            public void onRemoval(RemovalNotification<String, User> notification) {
                log.debug("Clear user cache for {} due to {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
        this.restRoleCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<User, Set<String>>(this){

            public void onRemoval(RemovalNotification<User, Set<String>> notification) {
                log.debug("Clear user cache for {} due to {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
    }

    public void registerClusterSettingsChangeListener(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(SecuritySettings.CACHE_TTL_SETTING, newTtlInMin -> {
            log.info("Detected change in settings, cluster setting for TTL is {}", newTtlInMin);
            this.ttlInMin = newTtlInMin;
            this.createCaches();
        });
    }

    public BackendRegistry(Settings settings, AdminDNs adminDns, XFFResolver xffResolver, AuditLog auditLog, ThreadPool threadPool, ClusterInfoHolder clusterInfoHolder) {
        this.adminDns = adminDns;
        this.opensearchSettings = settings;
        this.xffResolver = xffResolver;
        this.auditLog = auditLog;
        this.threadPool = threadPool;
        this.clusterInfoHolder = clusterInfoHolder;
        this.userInjector = new UserInjector(settings, threadPool, auditLog, xffResolver);
        this.restAuthDomains = Collections.emptySortedSet();
        this.ipAuthFailureListeners = Collections.emptyList();
        this.ttlInMin = settings.getAsInt("plugins.security.cache.ttl_minutes", Integer.valueOf(60));
        this.initialized = this.injectedUserEnabled = this.opensearchSettings.getAsBoolean("plugins.security.unsupported.inject_user.enabled", Boolean.valueOf(false)).booleanValue();
        this.createCaches();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public int getTtlInMin() {
        return this.ttlInMin;
    }

    public void invalidateCache() {
        this.userCache.invalidateAll();
        this.restImpersonationCache.invalidateAll();
        this.restRoleCache.invalidateAll();
    }

    public void invalidateUserCache(String[] usernames) {
        if (usernames == null || usernames.length == 0) {
            log.warn("No usernames given, not invalidating user cache.");
            return;
        }
        HashSet<String> usernamesAsSet = new HashSet<String>(Arrays.asList(usernames));
        this.userCache.asMap().keySet().stream().filter(authCreds -> usernamesAsSet.contains(authCreds.getUsername())).forEach(arg_0 -> this.userCache.invalidate(arg_0));
        this.restImpersonationCache.invalidateAll(usernamesAsSet);
        this.restRoleCache.asMap().keySet().stream().filter(user -> usernamesAsSet.contains(user.getName())).forEach(arg_0 -> this.restRoleCache.invalidate(arg_0));
        log.debug("Cache invalidated for all valid users from list: {}", (Object)String.join((CharSequence)", ", usernamesAsSet));
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        this.invalidateCache();
        this.anonymousAuthEnabled = dcm.isAnonymousAuthenticationEnabled() && this.opensearchSettings.getAsBoolean("plugins.security.compliance.disable_anonymous_authentication", Boolean.valueOf(false)) == false;
        this.restAuthDomains = Collections.unmodifiableSortedSet(dcm.getRestAuthDomains());
        this.restAuthorizers = Collections.unmodifiableSet(dcm.getRestAuthorizers());
        this.ipAuthFailureListeners = dcm.getIpAuthFailureListeners();
        this.authBackendFailureListeners = dcm.getAuthBackendFailureListeners();
        this.ipClientBlockRegistries = dcm.getIpClientBlockRegistries();
        this.authBackendClientBlockRegistries = dcm.getAuthBackendClientBlockRegistries();
        this.hostResolverMode = dcm.getHostsResolverMode();
        this.initialized = !this.restAuthDomains.isEmpty() || this.anonymousAuthEnabled || this.injectedUserEnabled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean authenticate(SecurityRequestChannel request) {
        boolean isDebugEnabled = log.isDebugEnabled();
        boolean isBlockedBasedOnAddress = request.getRemoteAddress().map(InetSocketAddress::getAddress).map(this::isBlocked).orElse(false);
        if (isBlockedBasedOnAddress) {
            if (isDebugEnabled) {
                InetSocketAddress ipAddress = request.getRemoteAddress().orElse(null);
                log.debug("Rejecting REST request because of blocked address: {}", ipAddress != null ? "/" + ipAddress.getAddress().getHostAddress() : null);
            }
            request.queueForSending(new SecurityResponse(401, "Authentication finally failed"));
            return false;
        }
        org.opensearch.common.util.concurrent.ThreadContext threadContext = this.threadPool.getThreadContext();
        String sslPrincipal = (String)threadContext.getTransient("_opendistro_security_ssl_principal");
        if (this.adminDns.isAdminDN(sslPrincipal)) {
            User superuser = new User(sslPrincipal);
            UserSubjectImpl subject = new UserSubjectImpl(this.threadPool, superuser);
            threadContext.putPersistent("_opendistro_security_authenticated_user", (Object)subject);
            threadContext.putTransient("_opendistro_security_user", (Object)superuser);
            return true;
        }
        if (this.userInjector.injectUser(request)) {
            return true;
        }
        if (!this.isInitialized()) {
            StringBuilder error = new StringBuilder("OpenSearch Security not initialized.");
            if (!this.clusterInfoHolder.hasClusterManager().booleanValue()) {
                error.append(String.format(" %s", "Cluster manager not present"));
            }
            log.error("{} (you may need to run securityadmin)", (Object)error.toString());
            request.queueForSending(new SecurityResponse(503, error.toString()));
            return false;
        }
        TransportAddress remoteAddress = this.xffResolver.resolve(request);
        boolean isTraceEnabled = log.isTraceEnabled();
        if (isTraceEnabled) {
            log.trace("Rest authentication request from {} [original: {}]", (Object)remoteAddress, request.getRemoteAddress().orElse(null));
        }
        this.threadPool.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)remoteAddress);
        boolean authenticated = false;
        User authenticatedUser = null;
        AuthCredentials authCredentials = null;
        Object firstChallengingHttpAuthenticator = null;
        for (AuthDomain authDomain : this.restAuthDomains) {
            AuthCredentials ac;
            block34: {
                Optional<SecurityResponse> restResponse;
                if (isDebugEnabled) {
                    log.debug("Check authdomain for rest {}/{} or {} in total", (Object)authDomain.getBackend().getType(), (Object)authDomain.getOrder(), (Object)this.restAuthDomains.size());
                }
                HTTPAuthenticator httpAuthenticator = authDomain.getHttpAuthenticator();
                if (authDomain.isChallenge() && firstChallengingHttpAuthenticator == null) {
                    firstChallengingHttpAuthenticator = httpAuthenticator;
                }
                if (isTraceEnabled) {
                    log.trace("Try to extract auth creds from {} http authenticator", (Object)httpAuthenticator.getType());
                }
                try {
                    ac = httpAuthenticator.extractCredentials(request, this.threadPool.getThreadContext());
                }
                catch (Exception e1) {
                    if (!isDebugEnabled) continue;
                    log.debug("'{}' extracting credentials from {} http authenticator", (Object)e1.toString(), (Object)httpAuthenticator.getType(), (Object)e1);
                    continue;
                }
                if (ac != null && this.isBlocked(authDomain.getBackend().getClass().getName(), ac.getUsername())) {
                    if (!isDebugEnabled) continue;
                    log.debug("Rejecting REST request because of blocked user: {}, authDomain: {}", (Object)ac.getUsername(), (Object)authDomain);
                    continue;
                }
                authCredentials = ac;
                if (ac == null) {
                    if (this.anonymousAuthEnabled && this.isRequestForAnonymousLogin(request.params(), request.getHeaders())) continue;
                    if (authDomain.isChallenge()) {
                        restResponse = httpAuthenticator.reRequestAuthentication(request, null);
                        if (restResponse.isPresent()) {
                            if (!authDomain.getHttpAuthenticator().getType().equals("saml")) {
                                this.auditLog.logFailedLogin("<NONE>", false, null, request);
                            }
                            if (authDomain.getHttpAuthenticator().getType().equals("basic")) {
                                log.warn("No 'Authorization' header, send 401 and 'WWW-Authenticate Basic'");
                            }
                            this.notifyIpAuthFailureListeners(request, authCredentials);
                            request.queueForSending(restResponse.get());
                            return false;
                        }
                        break block34;
                    } else {
                        if (!isTraceEnabled) continue;
                        log.trace("No 'Authorization' header, send 403");
                        continue;
                    }
                }
                ThreadContext.put((String)"user", (String)ac.getUsername());
                if (!ac.isComplete()) {
                    restResponse = httpAuthenticator.reRequestAuthentication(request, ac);
                    if (!restResponse.isPresent()) continue;
                    this.notifyIpAuthFailureListeners(request, ac);
                    request.queueForSending(restResponse.get());
                    return false;
                }
            }
            if ((authenticatedUser = this.authcz(this.userCache, this.restRoleCache, ac, authDomain.getBackend(), this.restAuthorizers)) == null) {
                if (isDebugEnabled) {
                    log.debug("Cannot authenticate rest user {} (or add roles) with authdomain {}/{} of {}, try next", (Object)ac.getUsername(), (Object)authDomain.getBackend().getType(), (Object)authDomain.getOrder(), this.restAuthDomains);
                }
                for (AuthFailureListener authFailureListener : this.authBackendFailureListeners.get((Object)authDomain.getBackend().getClass().getName())) {
                    authFailureListener.onAuthFailure(request.getRemoteAddress().map(InetSocketAddress::getAddress).orElse(null), ac, request);
                }
                continue;
            }
            if (this.adminDns.isAdmin(authenticatedUser)) {
                log.error("Cannot authenticate rest user because admin user is not permitted to login via HTTP");
                this.auditLog.logFailedLogin(authenticatedUser.getName(), true, null, request);
                request.queueForSending(new SecurityResponse(403, "Cannot authenticate user because admin user is not permitted to login via HTTP"));
                return false;
            }
            String tenant = this.resolveTenantFrom(request);
            if (isDebugEnabled) {
                log.debug("Rest user '{}' is authenticated", (Object)authenticatedUser);
                log.debug("securitytenant '{}'", (Object)tenant);
            }
            if (tenant != null) {
                authenticatedUser = authenticatedUser.withRequestedTenant(tenant);
            }
            authenticated = true;
            break;
        }
        if (authenticated) {
            User impersonatedUser = this.impersonate(request, authenticatedUser);
            User effectiveUser = impersonatedUser == null ? authenticatedUser : impersonatedUser;
            this.threadPool.getThreadContext().putTransient("_opendistro_security_user", (Object)effectiveUser);
            this.threadPool.getThreadContext().putTransient("_opendistro_security__initiating_user", (Object)authenticatedUser.getName());
            UserSubjectImpl subject = new UserSubjectImpl(this.threadPool, effectiveUser);
            this.threadPool.getThreadContext().putPersistent("_opendistro_security_authenticated_user", (Object)subject);
            return authenticated;
        }
        if (isDebugEnabled) {
            log.debug("User still not authenticated after checking {} auth domains", (Object)this.restAuthDomains.size());
        }
        Optional<Object> challengeResponse = Optional.empty();
        if (firstChallengingHttpAuthenticator != null) {
            if (isDebugEnabled) {
                log.debug("Rerequest with {}", firstChallengingHttpAuthenticator.getClass());
            }
            if ((challengeResponse = firstChallengingHttpAuthenticator.reRequestAuthentication(request, null)).isPresent() && isDebugEnabled) {
                log.debug("Rerequest {} failed", firstChallengingHttpAuthenticator.getClass());
            }
        }
        if (authCredentials == null && this.anonymousAuthEnabled && this.isRequestForAnonymousLogin(request.params(), request.getHeaders())) {
            User anonymousUser = User.ANONYMOUS;
            String tenant = this.resolveTenantFrom(request);
            if (tenant != null) {
                anonymousUser = anonymousUser.withRequestedTenant(tenant);
            }
            UserSubjectImpl subject = new UserSubjectImpl(this.threadPool, anonymousUser);
            this.threadPool.getThreadContext().putTransient("_opendistro_security_user", (Object)anonymousUser);
            this.threadPool.getThreadContext().putPersistent("_opendistro_security_authenticated_user", (Object)subject);
            if (!isDebugEnabled) return true;
            log.debug("Anonymous User is authenticated");
            return true;
        }
        log.warn("Authentication finally failed for {} from {}", (Object)(authCredentials == null ? null : authCredentials.getUsername()), (Object)remoteAddress);
        this.auditLog.logFailedLogin(authCredentials == null ? null : authCredentials.getUsername(), false, null, request);
        this.notifyIpAuthFailureListeners(request, authCredentials);
        request.queueForSending(challengeResponse.orElseGet(() -> new SecurityResponse(401, "Authentication finally failed")));
        return false;
    }

    private boolean isRequestForAnonymousLogin(Map<String, String> params, Map<String, List<String>> headers) {
        if (params.containsKey("auth_type")) {
            return params.get("auth_type").equals("anonymous");
        }
        return !headers.containsKey("Authorization");
    }

    private String resolveTenantFrom(SecurityRequest request) {
        return Optional.ofNullable(request.header("securitytenant")).orElse(request.header("security_tenant"));
    }

    private void notifyIpAuthFailureListeners(SecurityRequestChannel request, AuthCredentials authCredentials) {
        this.notifyIpAuthFailureListeners(request.getRemoteAddress().map(InetSocketAddress::getAddress).orElse(null), authCredentials, request);
    }

    private void notifyIpAuthFailureListeners(InetAddress remoteAddress, AuthCredentials authCredentials, Object request) {
        for (AuthFailureListener authFailureListener : this.ipAuthFailureListeners) {
            authFailureListener.onAuthFailure(remoteAddress, authCredentials, request);
        }
    }

    private User checkExistsAndAuthz(Cache<String, User> cache, final User user, final ImpersonationBackend impersonationBackend, final Set<AuthorizationBackend> authorizers) {
        if (user == null) {
            return null;
        }
        final boolean isDebugEnabled = log.isDebugEnabled();
        final boolean isTraceEnabled = log.isTraceEnabled();
        try {
            return (User)cache.get((Object)user.getName(), (Callable)new Callable<User>(){

                @Override
                public User call() throws Exception {
                    Optional<User> impersonatedUser;
                    if (isTraceEnabled) {
                        log.trace("Credentials for user {} not cached, return from {} backend directly", (Object)user.getName(), (Object)impersonationBackend.getType());
                    }
                    if ((impersonatedUser = impersonationBackend.impersonate(user)).isPresent()) {
                        AuthenticationContext context = new AuthenticationContext(new AuthCredentials(user.getName(), new String[0]));
                        return BackendRegistry.this.authz(context, impersonatedUser.get(), null, authorizers);
                    }
                    if (isDebugEnabled) {
                        log.debug("User {} does not exist in {}", (Object)user.getName(), (Object)impersonationBackend.getType());
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("Can not check and authorize {} due to ", (Object)user.getName(), (Object)e);
            }
            return null;
        }
    }

    private User authz(AuthenticationContext context, User authenticatedUser, Cache<User, Set<String>> roleCache, Set<AuthorizationBackend> authorizers) {
        Set cachedBackendRoles;
        if (authenticatedUser == null) {
            return authenticatedUser;
        }
        if (roleCache != null && (cachedBackendRoles = (Set)roleCache.getIfPresent((Object)authenticatedUser)) != null) {
            return authenticatedUser.withRoles(cachedBackendRoles);
        }
        if (authorizers == null || authorizers.isEmpty()) {
            return authenticatedUser;
        }
        boolean isTraceEnabled = log.isTraceEnabled();
        for (AuthorizationBackend ab : authorizers) {
            try {
                if (isTraceEnabled) {
                    log.trace("Backend roles for {} not cached, return from {} backend directly", (Object)authenticatedUser.getName(), (Object)ab.getType());
                }
                authenticatedUser = ab.addRoles(authenticatedUser, context);
            }
            catch (Exception e) {
                log.error("Cannot retrieve roles for {} from {} due to {}", (Object)authenticatedUser, (Object)ab.getType(), (Object)e.toString(), (Object)e);
            }
        }
        if (roleCache != null) {
            roleCache.put((Object)authenticatedUser, new HashSet<String>((Collection<String>)authenticatedUser.getRoles()));
        }
        return authenticatedUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User authcz(Cache<AuthCredentials, User> cache, final Cache<User, Set<String>> roleCache, final AuthCredentials ac, final AuthenticationBackend authBackend, final Set<AuthorizationBackend> authorizers) {
        if (ac == null) {
            return null;
        }
        final AuthenticationContext context = new AuthenticationContext(ac);
        try {
            if (authBackend.getClass() == NoOpAuthenticationBackend.class && authorizers.isEmpty()) {
                User user = authBackend.authenticate(context);
                return user;
            }
            User user = (User)cache.get((Object)ac, (Callable)new Callable<User>(){

                @Override
                public User call() throws Exception {
                    if (log.isTraceEnabled()) {
                        log.trace("Credentials for user {} not cached, return from {} backend directly", (Object)ac.getUsername(), (Object)authBackend.getType());
                    }
                    User authenticatedUser = authBackend.authenticate(context);
                    return BackendRegistry.this.authz(context, authenticatedUser, (Cache<User, Set<String>>)roleCache, authorizers);
                }
            });
            return user;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Can not authenticate {} due to exception", (Object)ac.getUsername(), (Object)e);
            }
            User user = null;
            return user;
        }
        finally {
            ac.clearSecrets();
        }
    }

    private User impersonate(SecurityRequest request, User originalUser) throws OpenSearchSecurityException {
        String impersonatedUserHeader = request.header("opendistro_security_impersonate_as");
        if (Strings.isNullOrEmpty((String)impersonatedUserHeader) || originalUser == null) {
            return null;
        }
        if (!this.isInitialized()) {
            throw new OpenSearchSecurityException("Could not check for impersonation because OpenSearch Security is not yet initialized", new Object[0]);
        }
        if (this.adminDns.isAdminDN(impersonatedUserHeader)) {
            throw new OpenSearchSecurityException("It is not allowed to impersonate as an adminuser  '" + impersonatedUserHeader + "'", RestStatus.FORBIDDEN, new Object[0]);
        }
        if (!this.adminDns.isRestImpersonationAllowed(originalUser.getName(), impersonatedUserHeader)) {
            throw new OpenSearchSecurityException("'" + originalUser.getName() + "' is not allowed to impersonate as '" + impersonatedUserHeader + "'", RestStatus.FORBIDDEN, new Object[0]);
        }
        boolean isDebugEnabled = log.isDebugEnabled();
        for (AuthDomain authDomain : this.restAuthDomains) {
            AuthenticationBackend authenticationBackend = authDomain.getBackend();
            if (!(authenticationBackend instanceof ImpersonationBackend)) continue;
            ImpersonationBackend impersonationBackend = (ImpersonationBackend)((Object)authenticationBackend);
            if (!authDomain.getHttpAuthenticator().supportsImpersonation()) continue;
            User impersonatedUser = this.checkExistsAndAuthz(this.restImpersonationCache, new User(impersonatedUserHeader), impersonationBackend, this.restAuthorizers);
            if (impersonatedUser == null) {
                log.debug("Unable to impersonate rest user from '{}' to '{}' because the impersonated user does not exists in {}, try next ...", (Object)originalUser.getName(), (Object)impersonatedUserHeader, (Object)impersonationBackend.getType());
                continue;
            }
            if (isDebugEnabled) {
                log.debug("Impersonate rest user from '{}' to '{}'", (Object)originalUser.toStringWithAttributes(), (Object)impersonatedUser.toStringWithAttributes());
            }
            if (originalUser.getRequestedTenant() != null) {
                impersonatedUser = impersonatedUser.withRequestedTenant(originalUser.getRequestedTenant());
            }
            return impersonatedUser;
        }
        log.debug("Unable to impersonate rest user from '{}' to '{}' because the impersonated user does not exists", (Object)originalUser.getName(), (Object)impersonatedUserHeader);
        throw new OpenSearchSecurityException("No such user:" + impersonatedUserHeader, RestStatus.FORBIDDEN, new Object[0]);
    }

    private boolean isBlocked(InetAddress address) {
        if (this.ipClientBlockRegistries == null || this.ipClientBlockRegistries.isEmpty()) {
            return false;
        }
        for (ClientBlockRegistry<InetAddress> clientBlockRegistry : this.ipClientBlockRegistries) {
            if (BackendRegistry.matchesIgnoreHostPatterns(clientBlockRegistry, address, this.hostResolverMode)) {
                return false;
            }
            if (!clientBlockRegistry.isBlocked(address)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesIgnoreHostPatterns(ClientBlockRegistry<InetAddress> clientBlockRegistry, InetAddress address, String hostResolverMode) {
        HostAndCidrMatcher ignoreHostsMatcher = ((AuthFailureListener)((Object)clientBlockRegistry)).getIgnoreHostsMatcher();
        if (ignoreHostsMatcher == null || address == null) {
            return false;
        }
        return ignoreHostsMatcher.matches(address, hostResolverMode);
    }

    private boolean isBlocked(String authBackend, String userName) {
        if (this.authBackendClientBlockRegistries == null) {
            return false;
        }
        Collection clientBlockRegistries = this.authBackendClientBlockRegistries.get((Object)authBackend);
        if (clientBlockRegistries.isEmpty()) {
            return false;
        }
        for (ClientBlockRegistry clientBlockRegistry : clientBlockRegistries) {
            if (!clientBlockRegistry.isBlocked(userName)) continue;
            return true;
        }
        return false;
    }
}

