/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Server;
import org.hsqldb.ServerConfiguration;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.resources.BundleHandler;

public class WebServer
extends Server {
    static int webBundleHandle = BundleHandler.getBundleHandle("webserver", null);

    public WebServer() {
        super(0);
    }

    public static void main(String[] stringArray) {
        String string = FileUtil.getDefaultInstance().canonicalOrAbsolutePath("webserver");
        HsqlProperties hsqlProperties = ServerConfiguration.getPropertiesFromFile(string);
        HsqlProperties hsqlProperties2 = hsqlProperties == null ? new HsqlProperties() : hsqlProperties;
        HsqlProperties hsqlProperties3 = null;
        try {
            hsqlProperties3 = HsqlProperties.argArrayToProps(stringArray, "server");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            WebServer.printHelp("webserver.help");
            return;
        }
        if (hsqlProperties3 != null) {
            if (hsqlProperties3.getErrorKeys().length != 0) {
                WebServer.printHelp("webserver.help");
                return;
            }
            hsqlProperties2.addProperties(hsqlProperties3);
        }
        ServerConfiguration.translateDefaultDatabaseProperty(hsqlProperties2);
        ServerConfiguration.translateDefaultNoSystemExitProperty(hsqlProperties2);
        WebServer webServer = new WebServer();
        try {
            webServer.setProperties(hsqlProperties2);
        }
        catch (Exception exception) {
            webServer.printError("Failed to set properties");
            webServer.printStackTrace(exception);
            return;
        }
        webServer.print("Startup sequence initiated from main() method");
        if (hsqlProperties != null) {
            webServer.print("Loaded properties from [" + string + ".properties]");
        } else {
            webServer.print("Could not load properties from file");
            webServer.print("Using cli/default properties only");
        }
        webServer.start();
    }

    @Override
    public String getDefaultWebPage() {
        return this.serverProperties.getProperty("server.default_page");
    }

    @Override
    public String getHelpString() {
        return BundleHandler.getString(serverBundleHandle, "webserver.help");
    }

    @Override
    public String getProductName() {
        return "HSQLDB web server";
    }

    @Override
    public String getProtocol() {
        return this.isTls() ? "HTTPS" : "HTTP";
    }

    @Override
    public String getWebRoot() {
        return this.serverProperties.getProperty("server.root");
    }
}

