/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Flow;

public final class MultiSelectFirstOp<T>
extends AbstractMultiOperator<T, T> {
    private final long numberOfItems;

    public MultiSelectFirstOp(Multi<? extends T> upstream, long numberOfItems) {
        super(upstream);
        this.numberOfItems = ParameterValidation.positiveOrZero(numberOfItems, "numberOfItems");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        ParameterValidation.nonNullNpe(downstream, "subscriber");
        this.upstream.subscribe(new MultiSelectFirstProcessor<T>(downstream, this.numberOfItems));
    }

    static final class MultiSelectFirstProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final long numberOfItems;
        private long remaining;

        MultiSelectFirstProcessor(MultiSubscriber<? super T> downstream, long numberOfItems) {
            super(downstream);
            this.numberOfItems = numberOfItems;
            this.remaining = numberOfItems;
        }

        @Override
        public void onSubscribe(Flow.Subscription s) {
            if (this.compareAndSetUpstreamSubscription(null, s)) {
                if (this.numberOfItems == 0L) {
                    this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED).cancel();
                    Subscriptions.complete(this.downstream);
                } else {
                    this.downstream.onSubscribe(this);
                }
            } else {
                s.cancel();
            }
        }

        @Override
        public void onItem(T t) {
            if (this.getUpstreamSubscription() == Subscriptions.CANCELLED) {
                return;
            }
            MultiSubscriber actual = this.downstream;
            long r = this.remaining;
            if (r == 0L) {
                this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED).cancel();
                actual.onCompletion();
                return;
            }
            this.remaining = --r;
            this.downstream.onItem(t);
            if (r == 0L) {
                this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED).cancel();
                actual.onCompletion();
            }
        }

        @Override
        public void request(long n) {
            Flow.Subscription upstream = this.getUpstreamSubscription();
            if (upstream != Subscriptions.CANCELLED) {
                if (n >= this.numberOfItems) {
                    upstream.request(Long.MAX_VALUE);
                } else {
                    upstream.request(n);
                }
            }
        }
    }
}

