/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.sql.ast;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.MariaDBDialect;
import org.hibernate.dialect.sql.ast.MySQLSqlAstTranslator;
import org.hibernate.dialect.sql.ast.SqlAstTranslatorWithOnDuplicateKeyUpdate;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcOperationQueryInsertImpl;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;
import org.hibernate.sql.model.ast.ColumnValueBinding;

public class MariaDBSqlAstTranslator<T extends JdbcOperation>
extends SqlAstTranslatorWithOnDuplicateKeyUpdate<T> {
    private final MariaDBDialect dialect;

    public MariaDBSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement, MariaDBDialect dialect) {
        super(sessionFactory, statement);
        this.dialect = dialect;
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        if (this.isIntegerDivisionEmulationRequired(arithmeticExpression)) {
            this.appendSql('(');
            this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
            this.appendSql(" div ");
            this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
            this.appendSql(')');
        } else {
            super.visitBinaryArithmeticExpression(arithmeticExpression);
        }
    }

    @Override
    protected void visitInsertSource(InsertSelectStatement statement) {
        if (statement.getSourceSelectStatement() != null) {
            if (statement.getConflictClause() != null) {
                List<ColumnReference> targetColumnReferences = statement.getTargetColumns();
                ArrayList<String> columnNames = new ArrayList<String>(targetColumnReferences.size());
                for (ColumnReference targetColumnReference : targetColumnReferences) {
                    columnNames.add(targetColumnReference.getColumnExpression());
                }
                this.appendSql("select * from ");
                this.emulateQueryPartTableReferenceColumnAliasing(new QueryPartTableReference(new SelectStatement(statement.getSourceSelectStatement()), "excluded", columnNames, false, this.getSessionFactory()));
            } else {
                statement.getSourceSelectStatement().accept(this);
            }
        } else {
            this.visitValuesList(statement.getValuesList());
        }
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        InsertSelectStatement insertSelectStatement;
        Statement statement;
        if ("excluded".equals(columnReference.getQualifier()) && (statement = this.getStatementStack().getCurrent()) instanceof InsertSelectStatement && (insertSelectStatement = (InsertSelectStatement)statement).getSourceSelectStatement() == null) {
            this.appendSql("values(");
            columnReference.appendReadExpression(this, null);
            this.append(')');
        } else {
            super.visitColumnReference(columnReference);
        }
    }

    @Override
    protected void renderDeleteClause(DeleteStatement statement) {
        this.appendSql("delete");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.DELETE);
            this.renderTableReferenceIdentificationVariable(statement.getTargetTable());
            if (statement.getFromClause().getRoots().isEmpty()) {
                this.appendSql(" from ");
                this.renderDmlTargetTableExpression(statement.getTargetTable());
            } else {
                this.visitFromClause(statement.getFromClause());
            }
        }
        finally {
            clauseStack.pop();
        }
    }

    @Override
    protected void renderUpdateClause(UpdateStatement updateStatement) {
        if (updateStatement.getFromClause().getRoots().isEmpty()) {
            super.renderUpdateClause(updateStatement);
        } else {
            this.appendSql("update ");
            this.renderFromClauseSpaces(updateStatement.getFromClause());
        }
    }

    @Override
    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable(tableReference);
        }
    }

    @Override
    protected JdbcOperationQueryInsert translateInsert(InsertSelectStatement sqlAst) {
        this.visitInsertStatement(sqlAst);
        return new JdbcOperationQueryInsertImpl(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), this.getUniqueConstraintNameThatMayFail(sqlAst));
    }

    @Override
    protected void visitConflictClause(ConflictClause conflictClause) {
        this.visitOnDuplicateKeyConflictClause(conflictClause);
    }

    @Override
    protected String determineColumnReferenceQualifier(ColumnReference columnReference) {
        InsertSelectStatement insertSelectStatement;
        String dmlAlias;
        MutationStatement mutationStatement;
        DmlTargetColumnQualifierSupport qualifierSupport = this.getDialect().getDmlTargetColumnQualifierSupport();
        if (this.getClauseStack().getCurrent() != Clause.SET || !((mutationStatement = this.getCurrentDmlStatement()) instanceof InsertSelectStatement) || (dmlAlias = (insertSelectStatement = (InsertSelectStatement)mutationStatement).getTargetTable().getIdentificationVariable()) == null || !dmlAlias.equals(columnReference.getQualifier())) {
            return columnReference.getQualifier();
        }
        if (qualifierSupport != DmlTargetColumnQualifierSupport.NONE || !this.getQueryPartStack().isEmpty()) {
            return this.getCurrentDmlStatement().getTargetTable().getTableExpression();
        }
        return null;
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    protected void visitRecursivePath(Expression recursivePath, int sizeEstimate) {
        if (sizeEstimate == -1) {
            super.visitRecursivePath(recursivePath, sizeEstimate);
        } else {
            this.appendSql("cast(");
            recursivePath.accept(this);
            this.appendSql(" as char(");
            this.appendSql(sizeEstimate);
            this.appendSql("))");
        }
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept(this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.supportsWindowFunctions() && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    @Override
    protected boolean shouldEmulateLateralWithIntersect(QueryPart queryPart) {
        return this.getDialect().supportsSimpleQueryGrouping() || !queryPart.hasOffsetOrFetchClause();
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
    }

    @Override
    protected void renderDerivedTableReferenceIdentificationVariable(DerivedTableReference tableReference) {
        this.renderTableReferenceIdentificationVariable(tableReference);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderCombinedLimitClause(queryPart);
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType != null && lhsExpressionType.getJdbcTypeCount() == 1 && lhsExpressionType.getSingleJdbcMapping().getJdbcType().isJson() && this.getDialect().getVersion().isSameOrAfter(10, 7)) {
            switch (operator) {
                case DISTINCT_FROM: {
                    this.appendSql("case when json_equals(");
                    lhs.accept(this);
                    this.appendSql(',');
                    rhs.accept(this);
                    this.appendSql(")=1 or ");
                    lhs.accept(this);
                    this.appendSql(" is null and ");
                    rhs.accept(this);
                    this.appendSql(" is null then 0 else 1 end=1");
                    break;
                }
                case NOT_DISTINCT_FROM: {
                    this.appendSql("case when json_equals(");
                    lhs.accept(this);
                    this.appendSql(',');
                    rhs.accept(this);
                    this.appendSql(")=1 or ");
                    lhs.accept(this);
                    this.appendSql(" is null and ");
                    rhs.accept(this);
                    this.appendSql(" is null then 0 else 1 end=0");
                    break;
                }
                case NOT_EQUAL: {
                    this.appendSql("json_equals(");
                    lhs.accept(this);
                    this.appendSql(',');
                    rhs.accept(this);
                    this.appendSql(")=0");
                    break;
                }
                case EQUAL: {
                    this.appendSql("json_equals(");
                    lhs.accept(this);
                    this.appendSql(',');
                    rhs.accept(this);
                    this.appendSql(")=1");
                    break;
                }
                default: {
                    this.renderComparisonDistinctOperator(lhs, operator, rhs);
                    break;
                }
            }
        } else {
            this.renderComparisonDistinctOperator(lhs, operator, rhs);
        }
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0'");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(" with ");
            this.appendSql(summarization.getKind().sqlText());
        } else {
            expression.accept(this);
        }
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        if (likePredicate.isCaseSensitive()) {
            likePredicate.getMatchExpression().accept(this);
            if (likePredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" like ");
            this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), this.getDialect().isNoBackslashEscapesEnabled());
        } else {
            this.appendSql(this.getDialect().getLowercaseFunction());
            this.appendSql('(');
            likePredicate.getMatchExpression().accept(this);
            this.appendSql(')');
            if (likePredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" like ");
            this.appendSql(this.getDialect().getLowercaseFunction());
            this.appendSql('(');
            this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), this.getDialect().isNoBackslashEscapesEnabled());
            this.appendSql(')');
        }
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept(this);
        }
    }

    @Override
    public MariaDBDialect getDialect() {
        return this.dialect;
    }

    private boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public void visitCastTarget(CastTarget castTarget) {
        String sqlType = MySQLSqlAstTranslator.getSqlType(castTarget, this.getSessionFactory());
        if (sqlType != null) {
            this.appendSql(sqlType);
        } else {
            super.visitCastTarget(castTarget);
        }
    }

    @Override
    protected void renderStringContainsExactlyPredicate(Expression haystack, Expression needle) {
        haystack.accept(this);
        this.appendSql(" like concat('%',replace(replace(replace(");
        needle.accept(this);
        this.appendSql(",'~','~~'),'?','~?'),'%','~%'),'%') escape '~'");
    }

    @Override
    protected void renderUpdatevalue(ColumnValueBinding columnValueBinding) {
        this.appendSql("values(");
        this.appendSql(columnValueBinding.getColumnReference().getColumnExpression());
        this.appendSql(")");
    }

    @Override
    protected void appendAssignmentColumn(ColumnReference column) {
        column.appendColumnForWrite(this, this.getAffectedTableNames().size() > 1 && !(this.getStatement() instanceof InsertSelectStatement) ? this.determineColumnReferenceQualifier(column) : null);
    }
}

