/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;

public class InstanceVariable
extends AbstractVariable {
    private static final String VALID_NAME = "@([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(VALID_NAME)) {
            return new InstanceVariable(receiver2, name2, javaObject);
        }
        return null;
    }

    private InstanceVariable(RubyObject receiver2, String name2, Object ... javaObjects) {
        super(receiver2, name2, false);
        this.updateByJavaObject(receiver2.getRuntime(), javaObjects);
    }

    public InstanceVariable(IRubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, true, irubyObject);
    }

    InstanceVariable(RubyObject receiver2, String name2, IRubyObject irubyObject) {
        this((IRubyObject)receiver2, name2, irubyObject);
    }

    public static void retrieve(RubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        InstanceVariable.updateInstanceVar(receiver2, vars);
        InstanceVariable.updateInstanceVar(InstanceVariable.getTopSelf(receiver2), vars);
    }

    static void updateInstanceVar(RubyObject receiver2, BiVariableMap vars) {
        receiver2.forEachInstanceVariable((name2, value2) -> InstanceVariable.updateVariable(receiver2, vars, name2, value2));
    }

    private static void updateVariable(RubyObject receiver2, BiVariableMap vars, String key2, IRubyObject value2) {
        BiVariable var = vars.getVariable(receiver2, key2);
        if (var != null) {
            var.setRubyObject(value2);
        } else {
            var = new InstanceVariable(receiver2, key2, value2);
            vars.update(key2, var);
        }
    }

    public static void retrieveByKey(RubyObject receiver2, BiVariableMap vars, String key2) {
        VariableAccessor accessor = receiver2.getMetaClass().getVariableTableManager().getVariableAccessorForRead(key2);
        if (accessor == VariableAccessor.DUMMY_ACCESSOR) {
            return;
        }
        IRubyObject value2 = (IRubyObject)accessor.get(receiver2);
        InstanceVariable.updateVariable(receiver2, vars, key2, value2);
    }

    @Override
    public BiVariable.Type getType() {
        return BiVariable.Type.InstanceVariable;
    }

    public static boolean isValidName(Object name2) {
        return InstanceVariable.isValidName(VALID_NAME, name2);
    }

    @Override
    public void inject() {
        ((RubyObject)this.getReceiver()).setInstanceVariable(this.name, this.getRubyObject());
    }

    @Override
    public void remove() {
        ((RubyObject)this.getReceiver()).removeInstanceVariable(this.name);
    }
}

