/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.SwingUtilities3;
import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUIAccessor;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import sun.swing.MenuItemLayoutHelper;
import sun.swing.SwingUtilities2;

public class WindowsMenuItemUI
extends BasicMenuItemUI {
    final WindowsMenuItemUIAccessor accessor = new WindowsMenuItemUIAccessor(){

        @Override
        public JMenuItem getMenuItem() {
            return WindowsMenuItemUI.this.menuItem;
        }

        @Override
        public TMSchema.State getState(JMenuItem jMenuItem) {
            return WindowsMenuItemUI.getState(this, jMenuItem);
        }

        @Override
        public TMSchema.Part getPart(JMenuItem jMenuItem) {
            return WindowsMenuItemUI.getPart(this, jMenuItem);
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsMenuItemUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String string = this.getPropertyPrefix();
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(string + ".acceleratorSelectionForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(string + ".acceleratorForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(string + ".disabledForeground");
        }
    }

    @Override
    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintMenuItem(this.accessor, graphics, jComponent, icon, icon2, color, color2, this.disabledForeground, this.acceleratorSelectionForeground, this.acceleratorForeground, n, this.menuItem, this.getPropertyPrefix());
            return;
        }
        super.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n);
    }

    static void paintMenuItem(WindowsMenuItemUIAccessor windowsMenuItemUIAccessor, Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, Color color3, Color color4, Color color5, int n, JMenuItem jMenuItem, String string) {
        Rectangle rectangle;
        Font font;
        Font font2 = graphics.getFont();
        Color color6 = graphics.getColor();
        JMenuItem jMenuItem2 = (JMenuItem)jComponent;
        graphics.setFont(jMenuItem2.getFont());
        Rectangle rectangle2 = new Rectangle(0, 0, jMenuItem2.getWidth(), jMenuItem2.getHeight());
        SwingUtilities3.applyInsets(rectangle2, jMenuItem2.getInsets());
        String string2 = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (string2 == null) {
            string2 = "+";
        }
        if ((font = UIManager.getFont("MenuItem.acceleratorFont")) == null) {
            font = UIManager.getFont("MenuItem.font");
        }
        MenuItemLayoutHelper menuItemLayoutHelper = new MenuItemLayoutHelper(jMenuItem2, icon, icon2, rectangle2, n, string2, jMenuItem2.getComponentOrientation().isLeftToRight(), jMenuItem2.getFont(), font, MenuItemLayoutHelper.useCheckAndArrow(jMenuItem), string);
        MenuItemLayoutHelper.LayoutResult layoutResult = menuItemLayoutHelper.layoutMenuItem();
        WindowsMenuItemUI.paintBackground(windowsMenuItemUIAccessor, graphics, jMenuItem2, color);
        SwingUtilities3.paintCheckIcon(graphics, menuItemLayoutHelper, layoutResult, color6, color2);
        SwingUtilities3.paintIcon(graphics, menuItemLayoutHelper, layoutResult, color6);
        if (menuItemLayoutHelper.getCheckIcon() != null && menuItemLayoutHelper.useCheckAndArrow()) {
            rectangle = layoutResult.getTextRect();
            rectangle.x += menuItemLayoutHelper.getAfterCheckIconGap();
            layoutResult.setTextRect(rectangle);
        }
        if (!menuItemLayoutHelper.getText().isEmpty()) {
            if (menuItemLayoutHelper.getHtmlView() != null) {
                menuItemLayoutHelper.getHtmlView().paint(graphics, layoutResult.getTextRect());
            } else {
                WindowsMenuItemUI.paintText(windowsMenuItemUIAccessor, graphics, menuItemLayoutHelper.getMenuItem(), layoutResult.getTextRect(), menuItemLayoutHelper.getText());
            }
        }
        if (menuItemLayoutHelper.getCheckIcon() != null && menuItemLayoutHelper.useCheckAndArrow()) {
            rectangle = layoutResult.getAccRect();
            rectangle.x += menuItemLayoutHelper.getAfterCheckIconGap();
            layoutResult.setAccRect(rectangle);
        }
        SwingUtilities3.paintAccText(graphics, menuItemLayoutHelper, layoutResult, color3, color4, color5);
        SwingUtilities3.paintArrowIcon(graphics, menuItemLayoutHelper, layoutResult, color2);
        graphics.setColor(color6);
        graphics.setFont(font2);
    }

    @Override
    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintText(this.accessor, graphics, jMenuItem, rectangle, string);
            return;
        }
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color = graphics.getColor();
        if (buttonModel.isEnabled() && (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected())) {
            graphics.setColor(this.selectionForeground);
        }
        WindowsGraphicsUtils.paintText(graphics, jMenuItem, rectangle, string, 0);
        graphics.setColor(color);
    }

    @Override
    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintBackground(this.accessor, graphics, jMenuItem, color);
            return;
        }
        super.paintBackground(graphics, jMenuItem, color);
    }

    static void paintBackground(WindowsMenuItemUIAccessor windowsMenuItemUIAccessor, Graphics graphics, JMenuItem jMenuItem, Color color) {
        XPStyle xPStyle = XPStyle.getXP();
        assert (WindowsMenuItemUI.isVistaPainting(xPStyle));
        if (WindowsMenuItemUI.isVistaPainting(xPStyle)) {
            Object object;
            int n = jMenuItem.getWidth();
            int n2 = jMenuItem.getHeight();
            if (jMenuItem.isOpaque()) {
                object = graphics.getColor();
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n, n2);
                graphics.setColor((Color)object);
            }
            object = windowsMenuItemUIAccessor.getPart(jMenuItem);
            XPStyle.Skin skin = xPStyle.getSkin(jMenuItem, (TMSchema.Part)((Object)object));
            skin.paintSkin(graphics, 0, 0, n, n2, windowsMenuItemUIAccessor.getState(jMenuItem));
        }
    }

    static void paintText(WindowsMenuItemUIAccessor windowsMenuItemUIAccessor, Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        assert (WindowsMenuItemUI.isVistaPainting());
        if (WindowsMenuItemUI.isVistaPainting()) {
            TMSchema.State state = windowsMenuItemUIAccessor.getState(jMenuItem);
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)jMenuItem, graphics);
            int n = jMenuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                n = -1;
            }
            WindowsGraphicsUtils.paintXPText(jMenuItem, windowsMenuItemUIAccessor.getPart(jMenuItem), state, graphics, rectangle.x, rectangle.y + fontMetrics.getAscent(), string, n);
        }
    }

    static TMSchema.State getState(WindowsMenuItemUIAccessor windowsMenuItemUIAccessor, JMenuItem jMenuItem) {
        ButtonModel buttonModel = jMenuItem.getModel();
        TMSchema.State state = buttonModel.isArmed() ? (buttonModel.isEnabled() ? TMSchema.State.HOT : TMSchema.State.DISABLEDHOT) : (buttonModel.isEnabled() ? TMSchema.State.NORMAL : TMSchema.State.DISABLED);
        return state;
    }

    static TMSchema.Part getPart(WindowsMenuItemUIAccessor windowsMenuItemUIAccessor, JMenuItem jMenuItem) {
        return TMSchema.Part.MP_POPUPITEM;
    }

    static boolean isVistaPainting(XPStyle xPStyle) {
        return xPStyle != null && xPStyle.isSkinDefined(null, TMSchema.Part.MP_POPUPITEM);
    }

    static boolean isVistaPainting() {
        return WindowsMenuItemUI.isVistaPainting(XPStyle.getXP());
    }
}

