/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import java.util.Map;
import javajs.util.BS;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.adapter.writers.FSG2SCIFConverter;
import org.jmol.adapter.writers.XtlWriter;
import org.jmol.api.Interface;
import org.jmol.api.JmolWriter;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.BSUtil;
import org.jmol.viewer.Viewer;

public class CIFWriter
extends XtlWriter
implements JmolWriter {
    protected Viewer vwr;
    protected OC oc;
    protected Object[] data;
    protected boolean isP1;
    protected boolean isCIF2;
    protected short modelIndex;
    protected boolean haveCustom;
    protected SymmetryInterface uc;
    protected BS bsOut;
    protected Atom[] atoms;
    protected int nops;
    protected String[] atomLabels;
    protected SB jmol_atoms;
    protected Map<String, Object> modelInfo;
    private static final P3 fset0 = P3.new3(555.0f, 555.0f, 1.0f);

    @Override
    public void set(Viewer viewer, OC oc, Object[] data) {
        this.vwr = viewer;
        this.oc = oc == null ? this.vwr.getOutputChannel(null, null) : oc;
        this.data = data;
        this.isP1 = data != null && data.length > 0 && "P1".equals(data[0]);
    }

    @Override
    public String write(BS bs) {
        block8: {
            try {
                CIFWriter writer;
                BS bS = bs = bs == null ? this.vwr.bsA() : BSUtil.copy(bs);
                if (bs.isEmpty()) {
                    return "";
                }
                this.modelInfo = this.vwr.ms.getModelAuxiliaryInfo(this.vwr.ms.at[bs.nextSetBit((int)0)].mi);
                Map info = (Map)this.modelInfo.get("scifInfo");
                if (info == null) {
                    writer = this;
                } else {
                    writer = (FSG2SCIFConverter)Interface.getInterface("org.jmol.adapter.writers.FSG2SCIFConverter", this.vwr, "cifwriter");
                    writer.set(this.vwr, null, new Object[]{this.modelInfo, info});
                    this.isCIF2 = true;
                }
                writer.prepareAtomSet(bs);
                SB sb = new SB();
                if (this.isCIF2) {
                    sb.append("#\\#CIF_2.0\n");
                }
                sb.append("## CIF file created by Jmol " + Viewer.getJmolVersion());
                if (writer.haveCustom) {
                    sb.append(PT.rep("\n" + this.uc.getUnitCellInfo(false), "\n", "\n##Jmol_orig "));
                }
                sb.append("\ndata_global\n\n");
                writer.writeHeader(sb);
                writer.writeParams(sb);
                writer.writeOperations(sb);
                int nAtoms = writer.writeAtomSite(sb);
                if (writer.jmol_atoms != null) {
                    sb.appendSB(writer.jmol_atoms);
                    sb.append("\n_jmol_atom_count   " + nAtoms);
                }
                sb.append("\n_jmol_precision    " + writer.precision + "\n");
                this.oc.append(sb.toString());
            }
            catch (Exception e) {
                if (Viewer.isJS) break block8;
                e.printStackTrace();
            }
        }
        return this.toString();
    }

    protected void prepareAtomSet(BS bs) {
        BS modelAU;
        T3 fset;
        boolean fractionalOffset;
        this.atoms = this.vwr.ms.at;
        this.modelIndex = this.atoms[bs.nextSetBit((int)0)].mi;
        int n0 = bs.cardinality();
        bs.and(this.vwr.getModelUndeletedAtomsBitSet(this.modelIndex));
        if (n0 < bs.cardinality()) {
            System.err.println("CIFWriter Warning: Atoms not in model " + (this.modelIndex + 1) + " ignored");
        }
        this.uc = this.vwr.ms.getUnitCell(this.modelIndex);
        boolean bl = this.haveUnitCell = this.uc != null;
        if (!this.haveUnitCell) {
            this.uc = this.vwr.getSymTemp().setUnitCellFromParams(null, false, 1.0E-5f);
        }
        this.nops = this.isP1 ? 0 : this.uc.getSpaceGroupOperationCount();
        this.slop = this.uc.getPrecision();
        this.precision = (int)(-Math.log10(this.slop));
        this.isHighPrecision = this.slop == 1.0E-12f;
        boolean bl2 = fractionalOffset = this.uc.getFractionalOffset(true) != null;
        this.haveCustom = fractionalOffset || (fset = this.uc.getUnitCellMultiplier()) != null && (fset.z == 1.0f ? !fset.equals(fset0) : fset.z != 0.0f);
        SymmetryInterface ucm = this.uc.getUnitCellMultiplied();
        this.isP1 = this.isP1 || ucm != this.uc || fractionalOffset || this.uc.getSpaceGroupOperationCount() < 2;
        this.uc = ucm;
        BS bS = !this.haveUnitCell ? bs : (modelAU = this.isP1 ? this.uc.removeDuplicates(this.vwr.ms, bs, false) : this.vwr.ms.am[this.modelIndex].bsAsymmetricUnit);
        if (modelAU == null) {
            this.bsOut = bs;
        } else {
            this.bsOut = new BS();
            this.bsOut.or(modelAU);
            this.bsOut.and(bs);
        }
        this.vwr.setErrorMessage(null, " (" + this.bsOut.cardinality() + " atoms)");
    }

    protected void writeHeader(SB sb) {
        String hmName;
        String hallName;
        String ita;
        if (this.isP1) {
            ita = "1";
            hallName = "P 1";
            hmName = "P1";
        } else {
            this.uc.getSpaceGroupInfo(this.vwr.ms, null, this.modelIndex, true, null);
            ita = this.uc.geCIFWriterValue("ita");
            hallName = this.uc.geCIFWriterValue("HallSymbol");
            hmName = this.uc.geCIFWriterValue("HermannMauguinSymbol");
        }
        this.appendKey(sb, "_space_group_IT_number", 27).append(ita == null ? "?" : ita.toString());
        this.appendKey(sb, "_space_group_name_Hall", 27).append(hallName == null || hallName.equals("?") ? "?" : "'" + hallName + "'");
        this.appendKey(sb, "_space_group_name_H-M_alt", 27).append(hmName == null ? "?" : "'" + hmName + "'");
    }

    protected void writeOperations(SB sb) {
        sb.append("\n\nloop_\n_space_group_symop_id\n_space_group_symop_operation_xyz");
        if (this.nops == 0) {
            sb.append("\n1 x,y,z");
        } else {
            SymmetryOperation[] symops = (SymmetryOperation[])this.uc.getSymmetryOperations();
            for (int i = 0; i < this.nops; ++i) {
                String sop = symops[i].getXyz(true);
                sb.append("\n").appendI(i + 1).append("\t").append(sop.replaceAll(" ", ""));
            }
        }
    }

    protected void writeParams(SB sb) {
        float[] params = this.uc.getUnitCellAsArray(false);
        this.appendKey(sb, "_cell_length_a", 27).append(this.cleanT(params[0]));
        this.appendKey(sb, "_cell_length_b", 27).append(this.cleanT(params[1]));
        this.appendKey(sb, "_cell_length_c", 27).append(this.cleanT(params[2]));
        this.appendKey(sb, "_cell_angle_alpha", 27).append(this.cleanT(params[3]));
        this.appendKey(sb, "_cell_angle_beta", 27).append(this.cleanT(params[4]));
        this.appendKey(sb, "_cell_angle_gamma", 27).append(this.cleanT(params[5]));
        sb.append("\n");
    }

    protected int writeAtomSite(SB sb) {
        float[] occ;
        String elements = "";
        boolean haveOccupancy = false;
        float[] fArray = occ = this.haveUnitCell ? this.vwr.ms.occupancies : null;
        if (occ != null) {
            int i = this.bsOut.nextSetBit(0);
            while (i >= 0) {
                if (occ[i] != 1.0f) {
                    haveOccupancy = true;
                    break;
                }
                i = this.bsOut.nextSetBit(i + 1);
            }
        }
        boolean haveAltLoc = false;
        int i = this.bsOut.nextSetBit(0);
        while (i >= 0) {
            if (this.atoms[i].altloc != '\u0000') {
                haveAltLoc = true;
                break;
            }
            i = this.bsOut.nextSetBit(i + 1);
        }
        float[] parts = haveAltLoc ? (float[])this.vwr.getDataObj("property_part", this.bsOut, 1) : null;
        int sbLength = sb.length();
        sb.append("\n\nloop_\n_atom_site_label\n_atom_site_type_symbol\n_atom_site_fract_x\n_atom_site_fract_y\n_atom_site_fract_z");
        if (haveAltLoc) {
            sb.append("\n_atom_site_disorder_group");
        }
        if (haveOccupancy) {
            sb.append("\n_atom_site_occupancy");
        } else if (!this.haveUnitCell) {
            sb.append("\n_atom_site_Cartn_x\n_atom_site_Cartn_y\n_atom_site_Cartn_z");
        }
        sb.append("\n");
        this.jmol_atoms = new SB();
        this.jmol_atoms.append("\n\nloop_\n_jmol_atom_index\n_jmol_atom_name\n_jmol_atom_site_label\n");
        int nAtoms = 0;
        P3 p = new P3();
        int[] elemNums = new int[130];
        this.atomLabels = new String[this.bsOut.cardinality()];
        int pi = 0;
        int labeli = 0;
        int i2 = this.bsOut.nextSetBit(0);
        while (i2 >= 0) {
            Atom a = this.atoms[i2];
            p.setT(a);
            if (this.haveUnitCell) {
                this.uc.toFractional(p, !this.isP1);
            }
            ++nAtoms;
            String name = a.getAtomName();
            String sym = a.getElementSymbol();
            int elemno = a.getElementNumber();
            String key = sym + "\n";
            if (elements.indexOf(key) < 0) {
                elements = elements + key;
            }
            int n = elemno;
            int n2 = elemNums[n] + 1;
            elemNums[n] = n2;
            String label = sym + n2;
            CIFWriter.appendField(sb, label, 5);
            CIFWriter.appendField(sb, sym, 3);
            this.atomLabels[labeli++] = label;
            this.append3(sb, p);
            if (haveAltLoc) {
                int part;
                sb.append(" ");
                String sdis = parts != null ? ((part = (int)parts[pi++]) == 0 ? "." : "" + part) : "" + (a.altloc == '\u0000' ? (char)'.' : (char)a.altloc);
                sb.append(sdis);
            }
            if (haveOccupancy) {
                sb.append(" ").append(this.clean(occ[i2] / 100.0f));
            } else if (!this.haveUnitCell) {
                this.append3(sb, a);
            }
            sb.append("\n");
            CIFWriter.appendField(this.jmol_atoms, "" + a.getIndex(), 3);
            this.writeChecked(this.jmol_atoms, name);
            CIFWriter.appendField(this.jmol_atoms, label, 5);
            this.jmol_atoms.append("\n");
            i2 = this.bsOut.nextSetBit(i2 + 1);
        }
        if (nAtoms > 0) {
            sb.append("\nloop_\n_atom_type_symbol\n").append(elements).append("\n");
        } else {
            sb.setLength(sbLength);
            this.jmol_atoms = null;
        }
        return nAtoms;
    }

    protected static void appendField(SB sb, String val, int width) {
        sb.append(PT.formatS(val, width, 0, true, false)).append(" ");
    }

    protected void append3(SB sb, T3 a) {
        sb.append(this.clean(a.x)).append(this.clean(a.y)).append(this.clean(a.z));
    }

    protected boolean writeChecked(SB output, String val) {
        if (val == null || val.length() == 0) {
            output.append(". ");
            return false;
        }
        boolean escape = val.charAt(0) == '_';
        String escapeCharStart = "'";
        String escapeCharEnd = "' ";
        boolean hasWhitespace = false;
        boolean hasSingle = false;
        boolean hasDouble = false;
        block6: for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': {
                    hasWhitespace = true;
                    continue block6;
                }
                case '\n': {
                    this.writeMultiline(output, val);
                    return true;
                }
                case '\"': {
                    if (hasSingle) {
                        this.writeMultiline(output, val);
                        return true;
                    }
                    hasDouble = true;
                    escape = true;
                    escapeCharStart = "'";
                    escapeCharEnd = "' ";
                    continue block6;
                }
                case '\'': {
                    if (hasDouble) {
                        this.writeMultiline(output, val);
                        return true;
                    }
                    escape = true;
                    hasSingle = true;
                    escapeCharStart = "\"";
                    escapeCharEnd = "\" ";
                }
            }
        }
        char fst = val.charAt(0);
        if (!escape && (fst == '#' || fst == '$' || fst == ';' || fst == '[' || fst == ']' || hasWhitespace)) {
            escapeCharStart = "'";
            escapeCharEnd = "' ";
            escape = true;
        }
        if (escape) {
            output.append(escapeCharStart).append(val).append(escapeCharEnd);
        } else {
            output.append(val).append(" ");
        }
        return false;
    }

    protected void writeMultiline(SB output, String val) {
        output.append("\n;").append(val).append("\n;\n");
    }

    protected SB appendKey(SB sb, String key, int width) {
        return sb.append("\n").append(PT.formatS(key, width, 0, true, false));
    }

    public String toString() {
        return this.oc == null ? "" : this.oc.toString();
    }
}

