/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.compiler;

import sun.jvm.hotspot.code.CompressedReadStream;
import sun.jvm.hotspot.compiler.OopMap;
import sun.jvm.hotspot.compiler.OopMapValue;

public class OopMapStream {
    private CompressedReadStream stream;
    private OopMap oopMap;
    private int mask;
    private int size;
    private int position;
    private OopMapValue omv;
    private boolean omvValid;

    public OopMapStream(OopMap oopMap) {
        this(oopMap, (OopMapValue.OopTypes[])null);
    }

    public OopMapStream(OopMap oopMap, OopMapValue.OopTypes type) {
        this(oopMap, (OopMapValue.OopTypes[])null);
        this.mask = type.getValue();
    }

    public OopMapStream(OopMap oopMap, OopMapValue.OopTypes[] types) {
        this.stream = oopMap.getOMVData() == null ? new CompressedReadStream(oopMap.getWriteStream().getBuffer()) : new CompressedReadStream(oopMap.getOMVData());
        this.mask = this.computeMask(types);
        this.size = (int)oopMap.getOMVCount();
        this.position = 0;
        this.omv = new OopMapValue();
        this.omvValid = false;
    }

    public boolean isDone() {
        if (!this.omvValid) {
            this.findNext();
        }
        return !this.omvValid;
    }

    public void next() {
        this.findNext();
    }

    public OopMapValue getCurrent() {
        return this.omv;
    }

    private int computeMask(OopMapValue.OopTypes[] types) {
        this.mask = 0;
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                this.mask |= types[i].getValue();
            }
        }
        return this.mask;
    }

    private void findNext() {
        while (this.position++ < this.size) {
            this.omv.readFrom(this.stream);
            if ((this.omv.getType().getValue() & this.mask) <= 0) continue;
            this.omvValid = true;
            return;
        }
        this.omvValid = false;
    }
}

