/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.ExpressionFactory;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class CalcValue
extends ExpressionValue {
    private static final long serialVersionUID = 1L;

    public CalcValue() {
    }

    protected CalcValue(CalcValue copied) {
        super(copied);
    }

    @Override
    public String getStringValue() throws DOMException {
        return "calc";
    }

    @Override
    ExpressionFactory createExpressionFactory(LexicalUnit nextLexicalUnit) {
        return new ExpressionFactory(nextLexicalUnit){

            @Override
            protected boolean isCalcValue() {
                return true;
            }

            @Override
            protected boolean isInvalidOperand(CSSPrimitiveValue primi, LexicalUnit.LexicalType lutype, LexicalUnit.LexicalType lastlutype) {
                if (super.isInvalidOperand(primi, lutype, lastlutype)) {
                    return true;
                }
                if (primi.getPrimitiveType() == CSSValue.Type.NUMERIC) {
                    return lastlutype == LexicalUnit.LexicalType.SUB_EXPRESSION;
                }
                return lutype != LexicalUnit.LexicalType.CALC && lutype != LexicalUnit.LexicalType.MATH_FUNCTION && lutype != LexicalUnit.LexicalType.IDENT && lutype != LexicalUnit.LexicalType.ENV && lutype != LexicalUnit.LexicalType.FUNCTION;
            }
        };
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + "calc".hashCode();
        return result;
    }

    @Override
    public String getCssText() {
        String s = this.getExpression().getCssText();
        StringBuilder buf = new StringBuilder(s.length() + 7);
        buf.append("calc(").append(s).append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String pname) {
        String s = this.getExpression().getMinifiedCssText();
        StringBuilder buf = new StringBuilder(s.length() + 6);
        buf.append("calc(").append(s).append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)"calc(");
        wri.write((CharSequence)this.getExpression().getCssText());
        wri.write(')');
    }

    @Override
    public CalcValue clone() {
        return new CalcValue(this);
    }
}

