/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.PackageMatchers;
import java.util.function.Function;

class JavaAccessPackagePredicate
extends DescribedPredicate<JavaAccess<?>> {
    private final Function<JavaAccess<?>, String> getPackageName;
    private final PackageMatchers packageMatchers;

    private JavaAccessPackagePredicate(String[] packageIdentifiers, Function<JavaAccess<?>, String> getPackageName) {
        super(String.format("any package [%s]", Formatters.joinSingleQuoted(packageIdentifiers)), new Object[0]);
        this.getPackageName = getPackageName;
        this.packageMatchers = PackageMatchers.of(packageIdentifiers);
    }

    static Creator forAccessOrigin() {
        return new Creator(input -> input.getOriginOwner().getPackageName());
    }

    static Creator forAccessTarget() {
        return new Creator(input -> input.getTargetOwner().getPackageName());
    }

    @Override
    public boolean test(JavaAccess<?> input) {
        return this.packageMatchers.test(this.getPackageName.apply(input));
    }

    static class Creator {
        private final Function<JavaAccess<?>, String> getPackageName;

        private Creator(Function<JavaAccess<?>, String> getPackageName) {
            this.getPackageName = getPackageName;
        }

        JavaAccessPackagePredicate matching(String ... packageIdentifiers) {
            return new JavaAccessPackagePredicate(packageIdentifiers, this.getPackageName);
        }
    }
}

