/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.edit.DBEObjectWithDependencies;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.Reply;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorObjectsDeleter;
import org.jkiss.dbeaver.ui.navigator.dialogs.NavigatorNodesDeletionConfirmations;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerObjectDelete
extends NavigatorHandlerObjectBase
implements IElementUpdater {
    private static final Log log = Log.getLog(NavigatorHandlerObjectDelete.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        NavigatorHandlerObjectDelete.tryDeleteObjects(window, structuredSelection.toList());
        return null;
    }

    public static boolean tryDeleteObjects(@NotNull IWorkbenchWindow window, @NotNull List<?> objects) {
        if (NavigatorHandlerObjectDelete.containsNodesFromDifferentDataSources(objects)) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.error_deleting_multiple_objects_from_different_datasources_title, UINavigatorMessages.error_deleting_multiple_objects_from_different_datasources_message);
            return false;
        }
        return NavigatorHandlerObjectDelete.tryDeleteObjects(window, objects, NavigatorObjectsDeleter.of(objects, window));
    }

    private static boolean containsNodesFromDifferentDataSources(@NotNull List<?> objects) {
        DBPDataSource dataSource = null;
        for (Object o : objects) {
            if (!(o instanceof DBNDatabaseNode)) continue;
            DBNDatabaseNode databaseNode = (DBNDatabaseNode)o;
            DBPDataSource currentDatasource = databaseNode instanceof DBNDataSource ? null : databaseNode.getDataSource();
            if (dataSource == null) {
                dataSource = currentDatasource;
                continue;
            }
            if (dataSource.equals(currentDatasource)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryDeleteObjects(IWorkbenchWindow window, List<?> selectedObjects, NavigatorObjectsDeleter deleter) {
        Reply reply = NavigatorNodesDeletionConfirmations.confirm(window.getShell(), selectedObjects, deleter);
        if (reply == Reply.YES) {
            return NavigatorHandlerObjectDelete.deleteObjects(window, deleter, selectedObjects);
        }
        if (reply == NavigatorNodesDeletionConfirmations.SHOW_SCRIPT) {
            boolean persistCheck = deleter.showScriptWindow();
            if (persistCheck) {
                return NavigatorHandlerObjectDelete.deleteObjects(window, deleter, selectedObjects);
            }
            return NavigatorHandlerObjectDelete.tryDeleteObjects(window, selectedObjects, deleter);
        }
        return false;
    }

    private static boolean deleteObjects(IWorkbenchWindow window, NavigatorObjectsDeleter deleter, List<?> selectedObjects) {
        if (NavigatorHandlerObjectDelete.confirmDependenciesDelete(window, selectedObjects)) {
            deleter.delete();
            return true;
        }
        return false;
    }

    private static boolean confirmDependenciesDelete(IWorkbenchWindow window, List<?> selectedObjects) {
        ArrayList dependentObjectsListNodes = new ArrayList();
        try {
            UIUtils.runInProgressService(monitor -> {
                for (Object obj : selectedObjects) {
                    DBSObject dbsObject;
                    if (!(obj instanceof DBNDatabaseItem) || !((dbsObject = ((DBNDatabaseItem)obj).getObject()) instanceof DBSEntityAttribute)) continue;
                    DBSEntityAttribute attribute = (DBSEntityAttribute)dbsObject;
                    DBEObjectManager objectManager = DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(attribute.getClass());
                    if (!(objectManager instanceof DBEObjectWithDependencies)) continue;
                    try {
                        List dependentObjectsList = ((DBEObjectWithDependencies)objectManager).getDependentObjectsList(monitor, (DBSObject)attribute);
                        NavigatorHandlerObjectDelete.changeDependentObjectsList(monitor, dependentObjectsList);
                        if (CommonUtils.isEmpty((Collection)dependentObjectsList)) continue;
                        for (Object object : dependentObjectsList) {
                            if (!(object instanceof DBSObject)) continue;
                            DBSObject objToDelete = (DBSObject)object;
                            DBNDatabaseNode node = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)objToDelete, (boolean)false);
                            if (node != null) {
                                dependentObjectsListNodes.add(node);
                                continue;
                            }
                            log.warn((Object)("Node not found for object " + String.valueOf(object)));
                        }
                    }
                    catch (DBException e) {
                        log.debug((Object)"Can't get object dependent list", (Throwable)e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.search_dependencies_error_title, UINavigatorMessages.search_dependencies_error_message, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        if (!CommonUtils.isEmpty(dependentObjectsListNodes)) {
            String confirmMessage;
            NavigatorObjectsDeleter dependentObjectsDeleter = NavigatorObjectsDeleter.of(dependentObjectsListNodes, window);
            if (dependentObjectsListNodes.size() == 1) {
                DBNDatabaseNode node = (DBNDatabaseNode)dependentObjectsListNodes.get(0);
                confirmMessage = NLS.bind((String)UINavigatorMessages.confirm_deleting_dependent_one_object, (Object)node.getNodeTypeLabel(), (Object)node.getNodeDisplayName());
            } else {
                confirmMessage = NLS.bind((String)UINavigatorMessages.confirm_deleting_dependent_objects, (Object)dependentObjectsListNodes.size());
            }
            Reply reply = NavigatorNodesDeletionConfirmations.confirm(window.getShell(), UINavigatorMessages.confirm_deleting_dependent_objects_title, confirmMessage, dependentObjectsListNodes, dependentObjectsDeleter);
            if (reply == Reply.YES) {
                dependentObjectsDeleter.delete();
                return true;
            }
            return false;
        }
        return true;
    }

    private static void changeDependentObjectsList(@NotNull DBRProgressMonitor monitor, List<? extends DBSObject> dependentObjectsList) throws DBException {
        if (!CommonUtils.isEmpty(dependentObjectsList)) {
            List indexList = dependentObjectsList.stream().filter(o -> o instanceof DBSTableIndex).collect(Collectors.toList());
            List constrList = dependentObjectsList.stream().filter(o -> o instanceof DBSTableConstraint).collect(Collectors.toList());
            for (DBSObject constraint : constrList) {
                for (DBSObject index : indexList) {
                    if (!(constraint instanceof DBSEntityReferrer) || !(index instanceof DBSEntityReferrer) || !DBUtils.referrerMatches((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)constraint), (Collection)DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)index)))) continue;
                    dependentObjectsList.remove(index);
                }
            }
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void updateElement(UIElement element, Map parameters) {
    }
}

