/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskCategory;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.model.task.DBTTaskFolderEvent;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskImpl;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIMessages;
import org.jkiss.dbeaver.tasks.ui.registry.TaskUIRegistry;
import org.jkiss.dbeaver.tasks.ui.wizard.NewTaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

class TaskConfigurationWizardPageTask
extends ActiveWizardPage<TaskConfigurationWizard> {
    private static final Log log = Log.getLog(TaskConfigurationWizardPageTask.class);
    private final DBPProject selectedProject;
    private Text taskLabelText;
    private Text taskDescriptionText;
    private Spinner maxExecutionTime;
    private Button maxExecutionTimeBtn;
    private Tree taskCategoryTree;
    private Combo taskFoldersCombo;
    private DBTTaskCategory selectedCategory;
    private DBTTaskType selectedTaskType;
    private String taskName;
    private String taskDescription;
    private String selectedTaskFolderName;
    private Map<String, Object> initialProperties = new LinkedHashMap<String, Object>();
    private TaskImpl task;
    private boolean filterTaskTypes = true;
    private Map<DBTTaskType, TaskConfigurationWizard> taskWizards = new HashMap<DBTTaskType, TaskConfigurationWizard>();

    TaskConfigurationWizardPageTask(DBTTask task) {
        super(task == null ? TaskUIMessages.task_config_wizard_page_settings_create_task : TaskUIMessages.task_config_wizard_page_settings_edit_task);
        this.setTitle(task == null ? TaskUIMessages.task_config_wizard_page_task_title_new_task_prop : TaskUIMessages.task_config_wizard_page_settings_title_task_prop);
        this.setDescription(TaskUIMessages.task_config_wizard_page_settings_descr_set_task);
        this.task = (TaskImpl)task;
        if (this.task != null) {
            this.taskName = this.task.getName();
            this.taskDescription = this.task.getDescription();
            this.selectedTaskFolderName = this.task.getTaskFolder() != null ? this.task.getTaskFolder().getName() : null;
            this.selectedTaskType = this.task.getType();
            this.selectedCategory = this.selectedTaskType.getCategory();
        }
        this.selectedProject = NavigatorUtils.getSelectedProject();
        this.setPageComplete(this.task != null);
    }

    public DBTTaskCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    public DBTTaskType getSelectedTaskType() {
        return this.selectedTaskType;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public Map<String, Object> getInitialProperties() {
        return this.initialProperties;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void createControl(Composite parent) {
        DBTTaskFolder currentSelectedTaskFolder;
        TaskConfigurationWizard wizard;
        boolean taskSaved = this.task != null && !CommonUtils.isEmpty((String)this.task.getId());
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        Group formPanel = UIUtils.createControlGroup((Composite)composite, (String)TaskUIMessages.task_config_wizard_page_task_label_task_type, (int)(this.task == null ? 1 : 2), (int)1808, (int)0);
        formPanel.setLayoutData((Object)new GridData(1808));
        Composite infoPanel = UIUtils.createComposite((Composite)formPanel, (int)2);
        infoPanel.setLayoutData((Object)new GridData(768));
        ModifyListener modifyListener = e -> this.updatePageCompletion();
        this.taskLabelText = UIUtils.createLabelText((Composite)infoPanel, (String)TaskUIMessages.task_config_wizard_page_task_text_label_name, (String)(this.task == null ? "" : CommonUtils.notEmpty((String)this.task.getName())), (int)2048);
        if (taskSaved) {
            this.taskLabelText.setEditable(false);
        }
        this.taskLabelText.addModifyListener(e -> {
            this.taskName = this.taskLabelText.getText();
            modifyListener.modifyText(e);
        });
        UIUtils.createControlLabel((Composite)infoPanel, (String)TaskUIMessages.task_config_wizard_page_task_control_label_descr).setLayoutData((Object)new GridData(2));
        this.taskDescriptionText = new Text(infoPanel, 2050);
        this.taskDescriptionText.setText(this.task == null ? "" : CommonUtils.notEmpty((String)this.task.getDescription()));
        this.taskDescriptionText.setLayoutData((Object)new GridData(768));
        this.taskDescriptionText.addModifyListener(e -> {
            this.taskDescription = this.taskDescriptionText.getText();
            modifyListener.modifyText(e);
        });
        UIUtils.createControlLabel((Composite)infoPanel, (String)TaskUIMessages.task_config_wizard_page_task_create_folder_label);
        this.taskFoldersCombo = new Combo(infoPanel, 12);
        this.taskFoldersCombo.setLayoutData((Object)new GridData(768));
        DBTTaskManager taskManager = this.selectedProject.getTaskManager();
        Object[] tasksFolders = taskManager.getTasksFolders();
        if (!ArrayUtils.isEmpty((Object[])tasksFolders)) {
            this.taskFoldersCombo.add("");
            Object[] objectArray = tasksFolders;
            int n = tasksFolders.length;
            int n2 = 0;
            while (n2 < n) {
                Object taskFolder = objectArray[n2];
                this.taskFoldersCombo.add(taskFolder.getName());
                ++n2;
            }
        }
        if (this.task != null && this.task.getTaskFolder() != null) {
            this.taskFoldersCombo.setText(this.task.getTaskFolder().getName());
        } else if (this.task == null && (wizard = (TaskConfigurationWizard)this.getWizard()) != null && (currentSelectedTaskFolder = wizard.getCurrentSelectedTaskFolder()) != null) {
            this.taskFoldersCombo.setText(currentSelectedTaskFolder.getName());
        }
        if (this.task != null) {
            this.taskFoldersCombo.addModifyListener(e -> {
                String foldersComboText = this.taskFoldersCombo.getText();
                if (this.task.getTaskFolder() == null || !foldersComboText.equals(this.task.getTaskFolder().getName())) {
                    this.selectedTaskFolderName = foldersComboText;
                }
            });
        }
        if (this.task != null && !CommonUtils.isEmpty((String)this.task.getId())) {
            UIUtils.createLabelText((Composite)infoPanel, (String)TaskUIMessages.task_config_wizard_page_task_text_label_task_id, (String)this.task.getId(), (int)2056);
        }
        UIUtils.asyncExec(() -> {
            Text widgetToFocus;
            Text text = widgetToFocus = taskSaved ? this.taskDescriptionText : this.taskLabelText;
            if (widgetToFocus != null && !widgetToFocus.isDisposed()) {
                widgetToFocus.setFocus();
            }
        });
        if (this.task != null) {
            UIUtils.createControlLabel((Composite)infoPanel, (String)TaskUIMessages.task_config_wizard_page_task_control_label_category);
            Composite catPanel = UIUtils.createComposite((Composite)infoPanel, (int)2);
            DBTTaskType taskType = this.task.getType();
            UIUtils.createLabel((Composite)catPanel, (DBPImage)taskType.getCategory().getIcon());
            UIUtils.createLabel((Composite)catPanel, (String)taskType.getCategory().getName());
            UIUtils.createControlLabel((Composite)infoPanel, (String)TaskUIMessages.task_config_wizard_page_task_control_label_type);
            Composite typePanel = UIUtils.createComposite((Composite)infoPanel, (int)2);
            UIUtils.createLabel((Composite)typePanel, (DBPImage)taskType.getIcon());
            UIUtils.createLabel((Composite)typePanel, (String)taskType.getName());
        }
        Group advancedPanel = UIUtils.createControlGroup((Composite)composite, (String)TaskUIMessages.task_config_wizard_page_task_advanced_label, (int)2, (int)768, (int)0);
        this.maxExecutionTimeBtn = UIUtils.createCheckbox((Composite)advancedPanel, (String)TaskUIMessages.task_config_wizard_page_task_max_exec_time, (String)TaskUIMessages.task_config_wizard_page_task_max_exec_time_descr, (boolean)true, (int)1);
        this.maxExecutionTime = UIUtils.createSpinner((Composite)advancedPanel, null, (int)300, (int)1, (int)Integer.MAX_VALUE);
        this.maxExecutionTimeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskConfigurationWizardPageTask.this.maxExecutionTime.setEnabled(TaskConfigurationWizardPageTask.this.maxExecutionTimeBtn.getSelection());
                if (!TaskConfigurationWizardPageTask.this.maxExecutionTimeBtn.getSelection()) {
                    TaskConfigurationWizardPageTask.this.maxExecutionTime.setSelection(0);
                }
            }
        });
        this.maxExecutionTime.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.task != null && this.task.getMaxExecutionTime() != 0) {
            this.maxExecutionTimeBtn.setSelection(true);
            this.maxExecutionTime.setEnabled(true);
            this.maxExecutionTime.setSelection(this.task.getMaxExecutionTime());
        } else {
            this.maxExecutionTimeBtn.setSelection(false);
            this.maxExecutionTime.setEnabled(false);
            this.maxExecutionTime.setSelection(300);
        }
        if (this.task == null) {
            this.taskCategoryTree = new Tree((Composite)formPanel, 67588);
            GridData gd = new GridData(1808);
            gd.heightHint = 100;
            gd.widthHint = 200;
            this.taskCategoryTree.setLayoutData((Object)gd);
            this.taskCategoryTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreeItem[] selection = TaskConfigurationWizardPageTask.this.taskCategoryTree.getSelection();
                    if (selection.length == 1) {
                        Object itemData = selection[0].getData();
                        if (itemData instanceof DBTTaskType) {
                            if (TaskConfigurationWizardPageTask.this.selectedTaskType == itemData) {
                                return;
                            }
                            TaskConfigurationWizardPageTask.this.selectedTaskType = (DBTTaskType)itemData;
                            TaskConfigurationWizardPageTask.this.selectedCategory = TaskConfigurationWizardPageTask.this.selectedTaskType.getCategory();
                        } else {
                            if (TaskConfigurationWizardPageTask.this.selectedCategory == itemData && TaskConfigurationWizardPageTask.this.selectedTaskType == null) {
                                return;
                            }
                            TaskConfigurationWizardPageTask.this.selectedCategory = (DBTTaskCategory)itemData;
                            TaskConfigurationWizardPageTask.this.selectedTaskType = null;
                        }
                        TaskConfigurationWizardPageTask.this.updateTaskTypeSelection();
                    }
                }
            });
            TreeColumn nameColumn = new TreeColumn(this.taskCategoryTree, 16384);
            nameColumn.setText("Task");
            TreeColumn descColumn = new TreeColumn(this.taskCategoryTree, 131072);
            descColumn.setText("Description");
            this.addTaskCategories(null, TaskRegistry.getInstance().getRootCategories());
            this.taskCategoryTree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (TaskConfigurationWizardPageTask.this.canFlipToNextPage()) {
                        ((TaskConfigurationWizard)TaskConfigurationWizardPageTask.this.getWizard()).getContainer().buttonPressed(15);
                    }
                }
            });
            UIUtils.asyncExec(() -> UIUtils.packColumns((Tree)this.taskCategoryTree, (boolean)true, (float[])new float[]{0.3f, 0.7f}));
            this.taskCategoryTree.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    TaskConfigurationWizardPageTask.this.taskCategoryTree.removeControlListener((ControlListener)this);
                    UIUtils.packColumns((Tree)TaskConfigurationWizardPageTask.this.taskCategoryTree, (boolean)true, (float[])new float[]{0.3f, 0.7f});
                }
            });
            this.taskCategoryTree.addPaintListener(e -> {
                if (this.taskCategoryTree.getItemCount() == 0) {
                    UIUtils.drawMessageOverControl((Control)this.taskCategoryTree, (PaintEvent)e, (String)TaskUIMessages.task_config_wizard_page_task_no_task_types_available, (int)0);
                }
            });
        }
        this.updatePageCompletion();
        this.setControl((Control)composite);
    }

    private void updateTaskTypeSelection() {
        if (this.task != null && this.selectedTaskType != null && this.task.getType() != this.selectedTaskType) {
            this.task.setType(this.selectedTaskType);
            this.task.setProperties(new LinkedHashMap());
        }
        this.updatePageCompletion();
        this.getShell().layout(true, true);
        ((TaskConfigurationWizard)this.getWizard()).getContainer().updateButtons();
    }

    private void addTaskCategories(TreeItem parentItem, DBTTaskCategory[] categories) {
        List<DBTTaskCategory> allCats = Arrays.asList(categories);
        allCats.sort(Comparator.comparing(DBTTaskCategory::getName));
        DBTTaskCategory[] dBTTaskCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            DBTTaskCategory cat = dBTTaskCategoryArray[n2];
            if (this.isTaskCategoryApplicable(cat)) {
                TreeItem item = parentItem == null ? new TreeItem(this.taskCategoryTree, 0) : new TreeItem(parentItem, 0);
                item.setText(0, cat.getName());
                item.setImage(0, DBeaverIcons.getImage((DBPImage)(cat.getIcon() == null ? DBIcon.TREE_TASK : cat.getIcon())));
                item.setText(1, CommonUtils.notEmpty((String)cat.getDescription()));
                item.setData((Object)cat);
                this.addTaskCategories(item, cat.getChildren());
                this.addTaskTypes(item, cat);
                item.setExpanded(true);
            }
            ++n2;
        }
    }

    private void addTaskTypes(TreeItem parentItem, DBTTaskCategory category) {
        DBTTaskType[] taskTypes = category.getTaskTypes();
        Arrays.sort(taskTypes, Comparator.comparing(DBTTaskType::getName));
        DBTTaskType[] dBTTaskTypeArray = taskTypes;
        int n = taskTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DBTTaskType type = dBTTaskTypeArray[n2];
            if (this.isTaskTypeApplicable(type)) {
                TreeItem item = new TreeItem(parentItem, 0);
                item.setText(0, type.getName());
                item.setText(1, CommonUtils.notEmpty((String)type.getDescription()));
                if (type.getIcon() != null) {
                    item.setImage(0, DBeaverIcons.getImage((DBPImage)type.getIcon()));
                }
                item.setData((Object)type);
            }
            ++n2;
        }
    }

    private boolean isTaskCategoryApplicable(DBTTaskCategory category) {
        DBTTaskCategory child;
        if (!this.filterTaskTypes) {
            return true;
        }
        DBTTaskCategory[] dBTTaskCategoryArray = category.getChildren();
        int n = dBTTaskCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = dBTTaskCategoryArray[n2];
            if (this.isTaskCategoryApplicable(child)) {
                return true;
            }
            ++n2;
        }
        dBTTaskCategoryArray = category.getTaskTypes();
        n = dBTTaskCategoryArray.length;
        n2 = 0;
        while (n2 < n) {
            child = dBTTaskCategoryArray[n2];
            if (this.isTaskTypeApplicable((DBTTaskType)child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isTaskTypeApplicable(DBTTaskType type) {
        if (!this.filterTaskTypes || this.selectedProject == null || !this.selectedProject.isRegistryLoaded()) {
            return true;
        }
        if (type.isStandalone()) {
            return true;
        }
        for (DBPDataSourceContainer ds : this.selectedProject.getDataSourceRegistry().getDataSources()) {
            if (!type.isDriverApplicable(ds.getDriver())) continue;
            return true;
        }
        return false;
    }

    protected boolean determinePageCompletion() {
        DBTTask task2;
        if (CommonUtils.isEmpty((String)this.taskName)) {
            this.setErrorMessage(TaskUIMessages.task_configuration_wizard_page_task_error_message_enter_task_name);
            return false;
        }
        if (this.task == null && (task2 = this.selectedProject.getTaskManager().getTaskByName(this.taskName)) != null) {
            this.setErrorMessage(NLS.bind((String)TaskUIMessages.task_configuration_wizard_page_task_already_exists, (Object)this.taskName, (Object)this.selectedProject.getName()));
            return false;
        }
        if (this.selectedTaskType == null) {
            this.setErrorMessage(TaskUIMessages.task_configuration_wizard_page_task_enter_type);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public TaskConfigurationWizard getTaskWizard() throws DBException {
        if (!(this.getWizard() instanceof NewTaskConfigurationWizard)) {
            return (TaskConfigurationWizard)this.getWizard();
        }
        TaskConfigurationWizard realWizard = this.taskWizards.get(this.selectedTaskType);
        if (realWizard == null) {
            DBTTaskConfigurator configurator = TaskUIRegistry.getInstance().createConfigurator(this.selectedTaskType);
            String taskFolderName = this.taskFoldersCombo.getText();
            if (this.task == null) {
                this.task = (TaskImpl)this.selectedProject.getTaskManager().createTask(this.selectedTaskType, CommonUtils.notEmpty((String)this.taskName), this.taskDescription, taskFolderName, new LinkedHashMap());
            }
            realWizard = configurator.createTaskConfigWizard((DBTTask)this.task);
            IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
            IWorkbenchPart activePart = workbenchWindow.getActivePage().getActivePart();
            ISelection selection = activePart == null || activePart.getSite() == null || activePart.getSite().getSelectionProvider() == null ? null : activePart.getSite().getSelectionProvider().getSelection();
            realWizard.setContainer(this.getContainer());
            realWizard.init(workbenchWindow.getWorkbench(), selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null);
            this.taskWizards.put(this.selectedTaskType, realWizard);
        }
        return realWizard;
    }

    public void saveSettings() {
        if (this.task != null) {
            this.task.setName(this.taskLabelText.getText());
            this.task.setDescription(this.taskDescriptionText.getText());
            this.task.setType(this.selectedTaskType);
            if (this.selectedTaskFolderName != null) {
                DBTTaskFolder[] tasksFolders = this.selectedProject.getTaskManager().getTasksFolders();
                List<DBTTaskFolder> taskFoldersList = Arrays.asList(tasksFolders != null ? tasksFolders : new DBTTaskFolder[]{});
                DBTTaskFolder folder = (DBTTaskFolder)DBUtils.findObject(taskFoldersList, (String)this.selectedTaskFolderName);
                DBTTaskFolder currentTaskFolder = this.task.getTaskFolder();
                if (folder != null) {
                    this.task.setTaskFolder(folder);
                    folder.addTaskToFolder((DBTTask)this.task);
                } else {
                    this.task.setTaskFolder(null);
                }
                if (currentTaskFolder != null) {
                    currentTaskFolder.removeTaskFromFolder((DBTTask)this.task);
                }
                TaskRegistry.getInstance().notifyTaskFoldersListeners(new DBTTaskFolderEvent(folder, DBTTaskFolderEvent.Action.TASK_FOLDER_REMOVE));
            }
            if (this.maxExecutionTimeBtn.getSelection()) {
                this.task.setMaxExecutionTime(this.maxExecutionTime.getSelection());
            } else {
                this.task.setMaxExecutionTime(0);
            }
        }
    }
}

