/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.util.SimplifiedVisitor;

public class VariableCleaner
extends SimplifiedVisitor
implements AttributeVisitor {
    private LocalVariableTableAttribute localVariableTableAttribute;
    private LocalVariableTypeTableAttribute localVariableTypeTableAttribute;
    private boolean deleteLocalVariableTableAttribute;
    private boolean deleteLocalVariableTypeTableAttribute;

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        AttributesEditor editor;
        this.localVariableTableAttribute = null;
        this.localVariableTypeTableAttribute = null;
        this.deleteLocalVariableTableAttribute = false;
        this.deleteLocalVariableTypeTableAttribute = false;
        codeAttribute.attributesAccept(clazz, method, this);
        if (this.localVariableTableAttribute != null && this.localVariableTypeTableAttribute != null) {
            this.trimLocalVariableTypes(this.localVariableTableAttribute.localVariableTable, this.localVariableTableAttribute.u2localVariableTableLength, this.localVariableTypeTableAttribute.localVariableTypeTable, this.localVariableTypeTableAttribute.u2localVariableTypeTableLength);
        }
        if (this.deleteLocalVariableTableAttribute) {
            editor = new AttributesEditor((ProgramClass)clazz, (ProgramMember)((Object)method), codeAttribute, true);
            editor.deleteAttribute("LocalVariableTable");
        }
        if (this.deleteLocalVariableTypeTableAttribute) {
            editor = new AttributesEditor((ProgramClass)clazz, (ProgramMember)((Object)method), codeAttribute, true);
            editor.deleteAttribute("LocalVariableTypeTable");
        }
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.u2localVariableTableLength = this.removeUnusedLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength, codeAttribute.u2maxLocals);
        this.trimLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength, codeAttribute.u2maxLocals);
        if (localVariableTableAttribute.u2localVariableTableLength == 0) {
            this.deleteLocalVariableTableAttribute = true;
        }
        this.localVariableTableAttribute = localVariableTableAttribute;
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.removeUnusedLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength, codeAttribute.u2maxLocals);
        this.trimLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength, codeAttribute.u2maxLocals);
        if (localVariableTypeTableAttribute.u2localVariableTypeTableLength == 0) {
            this.deleteLocalVariableTypeTableAttribute = true;
        }
        this.localVariableTypeTableAttribute = localVariableTypeTableAttribute;
    }

    private int removeUnusedLocalVariables(LocalVariableInfo[] localVariableInfos, int localVariableInfoCount, int maxLocals) {
        int newIndex = 0;
        for (int index = 0; index < localVariableInfoCount; ++index) {
            LocalVariableInfo localVariableInfo = localVariableInfos[index];
            if (localVariableInfo.u2index < 0 || localVariableInfo.u2index >= maxLocals || localVariableInfo.u2startPC != 0 && localVariableInfo.u2length <= 0) continue;
            localVariableInfos[newIndex++] = localVariableInfos[index];
        }
        Arrays.fill(localVariableInfos, newIndex, localVariableInfoCount, null);
        return newIndex;
    }

    private int removeUnusedLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfos, int localVariableTypeInfoCount, int maxLocals) {
        int newIndex = 0;
        for (int index = 0; index < localVariableTypeInfoCount; ++index) {
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfos[index];
            if (localVariableTypeInfo.u2index < 0 || localVariableTypeInfo.u2index >= maxLocals || localVariableTypeInfo.u2startPC != 0 && localVariableTypeInfo.u2length <= 0) continue;
            localVariableTypeInfos[newIndex++] = localVariableTypeInfos[index];
        }
        Arrays.fill(localVariableTypeInfos, newIndex, localVariableTypeInfoCount, null);
        return newIndex;
    }

    private void trimLocalVariables(LocalVariableInfo[] localVariableInfos, int localVariableInfoCount, int maxLocals) {
        Arrays.sort(localVariableInfos, 0, localVariableInfoCount);
        int[] startPCs = this.createMaxArray(maxLocals);
        for (int index = localVariableInfoCount - 1; index >= 0; --index) {
            LocalVariableInfo localVariableInfo = localVariableInfos[index];
            int maxLength = startPCs[localVariableInfo.u2index] - localVariableInfo.u2startPC;
            if (localVariableInfo.u2length > maxLength) {
                localVariableInfo.u2length = maxLength;
            }
            startPCs[localVariableInfo.u2index] = localVariableInfo.u2startPC;
        }
    }

    private void trimLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfos, int localVariableTypeInfoCount, int maxLocals) {
        Arrays.sort(localVariableTypeInfos, 0, localVariableTypeInfoCount);
        int[] startPCs = this.createMaxArray(maxLocals);
        for (int index = localVariableTypeInfoCount - 1; index >= 0; --index) {
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfos[index];
            int maxLength = startPCs[localVariableTypeInfo.u2index] - localVariableTypeInfo.u2startPC;
            if (localVariableTypeInfo.u2length > maxLength) {
                localVariableTypeInfo.u2length = maxLength;
            }
            startPCs[localVariableTypeInfo.u2index] = localVariableTypeInfo.u2startPC;
        }
    }

    private void trimLocalVariableTypes(LocalVariableInfo[] localVariableInfos, int localVariableInfoCount, LocalVariableTypeInfo[] localVariableTypeInfos, int localVariableTypeInfoCount) {
        int typeIndex = 0;
        for (int index = 0; index < localVariableInfoCount && typeIndex < localVariableTypeInfoCount; ++index) {
            LocalVariableInfo localVariableInfo = localVariableInfos[index];
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfos[typeIndex];
            if (localVariableTypeInfo.u2index != localVariableInfo.u2index || localVariableTypeInfo.u2startPC != localVariableInfo.u2startPC) continue;
            localVariableTypeInfo.u2length = localVariableInfo.u2length;
            ++typeIndex;
        }
    }

    private int[] createMaxArray(int length) {
        int[] startPCs = new int[length];
        for (int index = 0; index < length; ++index) {
            startPCs[index] = Integer.MAX_VALUE;
        }
        return startPCs;
    }
}

