﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {

/**
 * <p>Describes a route table route.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisRouteTableRoute">AWS
 * API Reference</a></p>
 */
class AnalysisRouteTableRoute {
 public:
  AWS_EC2_API AnalysisRouteTableRoute() = default;
  AWS_EC2_API AnalysisRouteTableRoute(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_EC2_API AnalysisRouteTableRoute& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_EC2_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_EC2_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The destination IPv4 address, in CIDR notation.</p>
   */
  inline const Aws::String& GetDestinationCidr() const { return m_destinationCidr; }
  inline bool DestinationCidrHasBeenSet() const { return m_destinationCidrHasBeenSet; }
  template <typename DestinationCidrT = Aws::String>
  void SetDestinationCidr(DestinationCidrT&& value) {
    m_destinationCidrHasBeenSet = true;
    m_destinationCidr = std::forward<DestinationCidrT>(value);
  }
  template <typename DestinationCidrT = Aws::String>
  AnalysisRouteTableRoute& WithDestinationCidr(DestinationCidrT&& value) {
    SetDestinationCidr(std::forward<DestinationCidrT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The prefix of the Amazon Web Services service.</p>
   */
  inline const Aws::String& GetDestinationPrefixListId() const { return m_destinationPrefixListId; }
  inline bool DestinationPrefixListIdHasBeenSet() const { return m_destinationPrefixListIdHasBeenSet; }
  template <typename DestinationPrefixListIdT = Aws::String>
  void SetDestinationPrefixListId(DestinationPrefixListIdT&& value) {
    m_destinationPrefixListIdHasBeenSet = true;
    m_destinationPrefixListId = std::forward<DestinationPrefixListIdT>(value);
  }
  template <typename DestinationPrefixListIdT = Aws::String>
  AnalysisRouteTableRoute& WithDestinationPrefixListId(DestinationPrefixListIdT&& value) {
    SetDestinationPrefixListId(std::forward<DestinationPrefixListIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of an egress-only internet gateway.</p>
   */
  inline const Aws::String& GetEgressOnlyInternetGatewayId() const { return m_egressOnlyInternetGatewayId; }
  inline bool EgressOnlyInternetGatewayIdHasBeenSet() const { return m_egressOnlyInternetGatewayIdHasBeenSet; }
  template <typename EgressOnlyInternetGatewayIdT = Aws::String>
  void SetEgressOnlyInternetGatewayId(EgressOnlyInternetGatewayIdT&& value) {
    m_egressOnlyInternetGatewayIdHasBeenSet = true;
    m_egressOnlyInternetGatewayId = std::forward<EgressOnlyInternetGatewayIdT>(value);
  }
  template <typename EgressOnlyInternetGatewayIdT = Aws::String>
  AnalysisRouteTableRoute& WithEgressOnlyInternetGatewayId(EgressOnlyInternetGatewayIdT&& value) {
    SetEgressOnlyInternetGatewayId(std::forward<EgressOnlyInternetGatewayIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the gateway, such as an internet gateway or virtual private
   * gateway.</p>
   */
  inline const Aws::String& GetGatewayId() const { return m_gatewayId; }
  inline bool GatewayIdHasBeenSet() const { return m_gatewayIdHasBeenSet; }
  template <typename GatewayIdT = Aws::String>
  void SetGatewayId(GatewayIdT&& value) {
    m_gatewayIdHasBeenSet = true;
    m_gatewayId = std::forward<GatewayIdT>(value);
  }
  template <typename GatewayIdT = Aws::String>
  AnalysisRouteTableRoute& WithGatewayId(GatewayIdT&& value) {
    SetGatewayId(std::forward<GatewayIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the instance, such as a NAT instance.</p>
   */
  inline const Aws::String& GetInstanceId() const { return m_instanceId; }
  inline bool InstanceIdHasBeenSet() const { return m_instanceIdHasBeenSet; }
  template <typename InstanceIdT = Aws::String>
  void SetInstanceId(InstanceIdT&& value) {
    m_instanceIdHasBeenSet = true;
    m_instanceId = std::forward<InstanceIdT>(value);
  }
  template <typename InstanceIdT = Aws::String>
  AnalysisRouteTableRoute& WithInstanceId(InstanceIdT&& value) {
    SetInstanceId(std::forward<InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of a NAT gateway.</p>
   */
  inline const Aws::String& GetNatGatewayId() const { return m_natGatewayId; }
  inline bool NatGatewayIdHasBeenSet() const { return m_natGatewayIdHasBeenSet; }
  template <typename NatGatewayIdT = Aws::String>
  void SetNatGatewayId(NatGatewayIdT&& value) {
    m_natGatewayIdHasBeenSet = true;
    m_natGatewayId = std::forward<NatGatewayIdT>(value);
  }
  template <typename NatGatewayIdT = Aws::String>
  AnalysisRouteTableRoute& WithNatGatewayId(NatGatewayIdT&& value) {
    SetNatGatewayId(std::forward<NatGatewayIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of a network interface.</p>
   */
  inline const Aws::String& GetNetworkInterfaceId() const { return m_networkInterfaceId; }
  inline bool NetworkInterfaceIdHasBeenSet() const { return m_networkInterfaceIdHasBeenSet; }
  template <typename NetworkInterfaceIdT = Aws::String>
  void SetNetworkInterfaceId(NetworkInterfaceIdT&& value) {
    m_networkInterfaceIdHasBeenSet = true;
    m_networkInterfaceId = std::forward<NetworkInterfaceIdT>(value);
  }
  template <typename NetworkInterfaceIdT = Aws::String>
  AnalysisRouteTableRoute& WithNetworkInterfaceId(NetworkInterfaceIdT&& value) {
    SetNetworkInterfaceId(std::forward<NetworkInterfaceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Describes how the route was created. The following are the possible
   * values:</p> <ul> <li> <p>CreateRouteTable - The route was automatically created
   * when the route table was created.</p> </li> <li> <p>CreateRoute - The route was
   * manually added to the route table.</p> </li> <li> <p>EnableVgwRoutePropagation -
   * The route was propagated by route propagation.</p> </li> </ul>
   */
  inline const Aws::String& GetOrigin() const { return m_origin; }
  inline bool OriginHasBeenSet() const { return m_originHasBeenSet; }
  template <typename OriginT = Aws::String>
  void SetOrigin(OriginT&& value) {
    m_originHasBeenSet = true;
    m_origin = std::forward<OriginT>(value);
  }
  template <typename OriginT = Aws::String>
  AnalysisRouteTableRoute& WithOrigin(OriginT&& value) {
    SetOrigin(std::forward<OriginT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of a transit gateway.</p>
   */
  inline const Aws::String& GetTransitGatewayId() const { return m_transitGatewayId; }
  inline bool TransitGatewayIdHasBeenSet() const { return m_transitGatewayIdHasBeenSet; }
  template <typename TransitGatewayIdT = Aws::String>
  void SetTransitGatewayId(TransitGatewayIdT&& value) {
    m_transitGatewayIdHasBeenSet = true;
    m_transitGatewayId = std::forward<TransitGatewayIdT>(value);
  }
  template <typename TransitGatewayIdT = Aws::String>
  AnalysisRouteTableRoute& WithTransitGatewayId(TransitGatewayIdT&& value) {
    SetTransitGatewayId(std::forward<TransitGatewayIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of a VPC peering connection.</p>
   */
  inline const Aws::String& GetVpcPeeringConnectionId() const { return m_vpcPeeringConnectionId; }
  inline bool VpcPeeringConnectionIdHasBeenSet() const { return m_vpcPeeringConnectionIdHasBeenSet; }
  template <typename VpcPeeringConnectionIdT = Aws::String>
  void SetVpcPeeringConnectionId(VpcPeeringConnectionIdT&& value) {
    m_vpcPeeringConnectionIdHasBeenSet = true;
    m_vpcPeeringConnectionId = std::forward<VpcPeeringConnectionIdT>(value);
  }
  template <typename VpcPeeringConnectionIdT = Aws::String>
  AnalysisRouteTableRoute& WithVpcPeeringConnectionId(VpcPeeringConnectionIdT&& value) {
    SetVpcPeeringConnectionId(std::forward<VpcPeeringConnectionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The state. The following are the possible values:</p> <ul> <li> <p>active</p>
   * </li> <li> <p>blackhole</p> </li> </ul>
   */
  inline const Aws::String& GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  template <typename StateT = Aws::String>
  void SetState(StateT&& value) {
    m_stateHasBeenSet = true;
    m_state = std::forward<StateT>(value);
  }
  template <typename StateT = Aws::String>
  AnalysisRouteTableRoute& WithState(StateT&& value) {
    SetState(std::forward<StateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of a carrier gateway.</p>
   */
  inline const Aws::String& GetCarrierGatewayId() const { return m_carrierGatewayId; }
  inline bool CarrierGatewayIdHasBeenSet() const { return m_carrierGatewayIdHasBeenSet; }
  template <typename CarrierGatewayIdT = Aws::String>
  void SetCarrierGatewayId(CarrierGatewayIdT&& value) {
    m_carrierGatewayIdHasBeenSet = true;
    m_carrierGatewayId = std::forward<CarrierGatewayIdT>(value);
  }
  template <typename CarrierGatewayIdT = Aws::String>
  AnalysisRouteTableRoute& WithCarrierGatewayId(CarrierGatewayIdT&& value) {
    SetCarrierGatewayId(std::forward<CarrierGatewayIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of a core network.</p>
   */
  inline const Aws::String& GetCoreNetworkArn() const { return m_coreNetworkArn; }
  inline bool CoreNetworkArnHasBeenSet() const { return m_coreNetworkArnHasBeenSet; }
  template <typename CoreNetworkArnT = Aws::String>
  void SetCoreNetworkArn(CoreNetworkArnT&& value) {
    m_coreNetworkArnHasBeenSet = true;
    m_coreNetworkArn = std::forward<CoreNetworkArnT>(value);
  }
  template <typename CoreNetworkArnT = Aws::String>
  AnalysisRouteTableRoute& WithCoreNetworkArn(CoreNetworkArnT&& value) {
    SetCoreNetworkArn(std::forward<CoreNetworkArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of a local gateway.</p>
   */
  inline const Aws::String& GetLocalGatewayId() const { return m_localGatewayId; }
  inline bool LocalGatewayIdHasBeenSet() const { return m_localGatewayIdHasBeenSet; }
  template <typename LocalGatewayIdT = Aws::String>
  void SetLocalGatewayId(LocalGatewayIdT&& value) {
    m_localGatewayIdHasBeenSet = true;
    m_localGatewayId = std::forward<LocalGatewayIdT>(value);
  }
  template <typename LocalGatewayIdT = Aws::String>
  AnalysisRouteTableRoute& WithLocalGatewayId(LocalGatewayIdT&& value) {
    SetLocalGatewayId(std::forward<LocalGatewayIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_destinationCidr;

  Aws::String m_destinationPrefixListId;

  Aws::String m_egressOnlyInternetGatewayId;

  Aws::String m_gatewayId;

  Aws::String m_instanceId;

  Aws::String m_natGatewayId;

  Aws::String m_networkInterfaceId;

  Aws::String m_origin;

  Aws::String m_transitGatewayId;

  Aws::String m_vpcPeeringConnectionId;

  Aws::String m_state;

  Aws::String m_carrierGatewayId;

  Aws::String m_coreNetworkArn;

  Aws::String m_localGatewayId;
  bool m_destinationCidrHasBeenSet = false;
  bool m_destinationPrefixListIdHasBeenSet = false;
  bool m_egressOnlyInternetGatewayIdHasBeenSet = false;
  bool m_gatewayIdHasBeenSet = false;
  bool m_instanceIdHasBeenSet = false;
  bool m_natGatewayIdHasBeenSet = false;
  bool m_networkInterfaceIdHasBeenSet = false;
  bool m_originHasBeenSet = false;
  bool m_transitGatewayIdHasBeenSet = false;
  bool m_vpcPeeringConnectionIdHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_carrierGatewayIdHasBeenSet = false;
  bool m_coreNetworkArnHasBeenSet = false;
  bool m_localGatewayIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
