﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/payment-cryptography-data/PaymentCryptographyData_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace PaymentCryptographyData {
namespace Model {

/**
 * <p>Card data parameters that are required to generate a cardholder verification
 * value for the payment card.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/CardHolderVerificationValue">AWS
 * API Reference</a></p>
 */
class CardHolderVerificationValue {
 public:
  AWS_PAYMENTCRYPTOGRAPHYDATA_API CardHolderVerificationValue() = default;
  AWS_PAYMENTCRYPTOGRAPHYDATA_API CardHolderVerificationValue(Aws::Utils::Json::JsonView jsonValue);
  AWS_PAYMENTCRYPTOGRAPHYDATA_API CardHolderVerificationValue& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PAYMENTCRYPTOGRAPHYDATA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A random number generated by the issuer.</p>
   */
  inline const Aws::String& GetUnpredictableNumber() const { return m_unpredictableNumber; }
  inline bool UnpredictableNumberHasBeenSet() const { return m_unpredictableNumberHasBeenSet; }
  template <typename UnpredictableNumberT = Aws::String>
  void SetUnpredictableNumber(UnpredictableNumberT&& value) {
    m_unpredictableNumberHasBeenSet = true;
    m_unpredictableNumber = std::forward<UnpredictableNumberT>(value);
  }
  template <typename UnpredictableNumberT = Aws::String>
  CardHolderVerificationValue& WithUnpredictableNumber(UnpredictableNumberT&& value) {
    SetUnpredictableNumber(std::forward<UnpredictableNumberT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A number that identifies and differentiates payment cards with the same
   * Primary Account Number (PAN).</p>
   */
  inline const Aws::String& GetPanSequenceNumber() const { return m_panSequenceNumber; }
  inline bool PanSequenceNumberHasBeenSet() const { return m_panSequenceNumberHasBeenSet; }
  template <typename PanSequenceNumberT = Aws::String>
  void SetPanSequenceNumber(PanSequenceNumberT&& value) {
    m_panSequenceNumberHasBeenSet = true;
    m_panSequenceNumber = std::forward<PanSequenceNumberT>(value);
  }
  template <typename PanSequenceNumberT = Aws::String>
  CardHolderVerificationValue& WithPanSequenceNumber(PanSequenceNumberT&& value) {
    SetPanSequenceNumber(std::forward<PanSequenceNumberT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The transaction counter value that comes from a point of sale terminal.</p>
   */
  inline const Aws::String& GetApplicationTransactionCounter() const { return m_applicationTransactionCounter; }
  inline bool ApplicationTransactionCounterHasBeenSet() const { return m_applicationTransactionCounterHasBeenSet; }
  template <typename ApplicationTransactionCounterT = Aws::String>
  void SetApplicationTransactionCounter(ApplicationTransactionCounterT&& value) {
    m_applicationTransactionCounterHasBeenSet = true;
    m_applicationTransactionCounter = std::forward<ApplicationTransactionCounterT>(value);
  }
  template <typename ApplicationTransactionCounterT = Aws::String>
  CardHolderVerificationValue& WithApplicationTransactionCounter(ApplicationTransactionCounterT&& value) {
    SetApplicationTransactionCounter(std::forward<ApplicationTransactionCounterT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_unpredictableNumber;

  Aws::String m_panSequenceNumber;

  Aws::String m_applicationTransactionCounter;
  bool m_unpredictableNumberHasBeenSet = false;
  bool m_panSequenceNumberHasBeenSet = false;
  bool m_applicationTransactionCounterHasBeenSet = false;
};

}  // namespace Model
}  // namespace PaymentCryptographyData
}  // namespace Aws
