﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/oam/OAM_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace OAM {
namespace Model {
class GetSinkPolicyResult {
 public:
  AWS_OAM_API GetSinkPolicyResult() = default;
  AWS_OAM_API GetSinkPolicyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_OAM_API GetSinkPolicyResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The policy that you specified, in JSON format.</p>
   */
  inline const Aws::String& GetPolicy() const { return m_policy; }
  template <typename PolicyT = Aws::String>
  void SetPolicy(PolicyT&& value) {
    m_policyHasBeenSet = true;
    m_policy = std::forward<PolicyT>(value);
  }
  template <typename PolicyT = Aws::String>
  GetSinkPolicyResult& WithPolicy(PolicyT&& value) {
    SetPolicy(std::forward<PolicyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the sink.</p>
   */
  inline const Aws::String& GetSinkArn() const { return m_sinkArn; }
  template <typename SinkArnT = Aws::String>
  void SetSinkArn(SinkArnT&& value) {
    m_sinkArnHasBeenSet = true;
    m_sinkArn = std::forward<SinkArnT>(value);
  }
  template <typename SinkArnT = Aws::String>
  GetSinkPolicyResult& WithSinkArn(SinkArnT&& value) {
    SetSinkArn(std::forward<SinkArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The random ID string that Amazon Web Services generated as part of the sink
   * ARN.</p>
   */
  inline const Aws::String& GetSinkId() const { return m_sinkId; }
  template <typename SinkIdT = Aws::String>
  void SetSinkId(SinkIdT&& value) {
    m_sinkIdHasBeenSet = true;
    m_sinkId = std::forward<SinkIdT>(value);
  }
  template <typename SinkIdT = Aws::String>
  GetSinkPolicyResult& WithSinkId(SinkIdT&& value) {
    SetSinkId(std::forward<SinkIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetSinkPolicyResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_policy;

  Aws::String m_sinkArn;

  Aws::String m_sinkId;

  Aws::String m_requestId;
  bool m_policyHasBeenSet = false;
  bool m_sinkArnHasBeenSet = false;
  bool m_sinkIdHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace OAM
}  // namespace Aws
