﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/license-manager-user-subscriptions/LicenseManagerUserSubscriptions_EXPORTS.h>
#include <aws/license-manager-user-subscriptions/model/IdentityProvider.h>
#include <aws/license-manager-user-subscriptions/model/Settings.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace LicenseManagerUserSubscriptions {
namespace Model {

/**
 * <p>Describes an identity provider.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/IdentityProviderSummary">AWS
 * API Reference</a></p>
 */
class IdentityProviderSummary {
 public:
  AWS_LICENSEMANAGERUSERSUBSCRIPTIONS_API IdentityProviderSummary() = default;
  AWS_LICENSEMANAGERUSERSUBSCRIPTIONS_API IdentityProviderSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_LICENSEMANAGERUSERSUBSCRIPTIONS_API IdentityProviderSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LICENSEMANAGERUSERSUBSCRIPTIONS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The <code>IdentityProvider</code> resource contains information about an
   * identity provider.</p>
   */
  inline const IdentityProvider& GetIdentityProvider() const { return m_identityProvider; }
  inline bool IdentityProviderHasBeenSet() const { return m_identityProviderHasBeenSet; }
  template <typename IdentityProviderT = IdentityProvider>
  void SetIdentityProvider(IdentityProviderT&& value) {
    m_identityProviderHasBeenSet = true;
    m_identityProvider = std::forward<IdentityProviderT>(value);
  }
  template <typename IdentityProviderT = IdentityProvider>
  IdentityProviderSummary& WithIdentityProvider(IdentityProviderT&& value) {
    SetIdentityProvider(std::forward<IdentityProviderT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <code>Settings</code> resource contains details about the registered
   * identity provider’s product related configuration settings, such as the subnets
   * to provision VPC endpoints.</p>
   */
  inline const Settings& GetSettings() const { return m_settings; }
  inline bool SettingsHasBeenSet() const { return m_settingsHasBeenSet; }
  template <typename SettingsT = Settings>
  void SetSettings(SettingsT&& value) {
    m_settingsHasBeenSet = true;
    m_settings = std::forward<SettingsT>(value);
  }
  template <typename SettingsT = Settings>
  IdentityProviderSummary& WithSettings(SettingsT&& value) {
    SetSettings(std::forward<SettingsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the user-based subscription product.</p>
   */
  inline const Aws::String& GetProduct() const { return m_product; }
  inline bool ProductHasBeenSet() const { return m_productHasBeenSet; }
  template <typename ProductT = Aws::String>
  void SetProduct(ProductT&& value) {
    m_productHasBeenSet = true;
    m_product = std::forward<ProductT>(value);
  }
  template <typename ProductT = Aws::String>
  IdentityProviderSummary& WithProduct(ProductT&& value) {
    SetProduct(std::forward<ProductT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the identity provider.</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  IdentityProviderSummary& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the identity provider.</p>
   */
  inline const Aws::String& GetIdentityProviderArn() const { return m_identityProviderArn; }
  inline bool IdentityProviderArnHasBeenSet() const { return m_identityProviderArnHasBeenSet; }
  template <typename IdentityProviderArnT = Aws::String>
  void SetIdentityProviderArn(IdentityProviderArnT&& value) {
    m_identityProviderArnHasBeenSet = true;
    m_identityProviderArn = std::forward<IdentityProviderArnT>(value);
  }
  template <typename IdentityProviderArnT = Aws::String>
  IdentityProviderSummary& WithIdentityProviderArn(IdentityProviderArnT&& value) {
    SetIdentityProviderArn(std::forward<IdentityProviderArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The failure message associated with an identity provider.</p>
   */
  inline const Aws::String& GetFailureMessage() const { return m_failureMessage; }
  inline bool FailureMessageHasBeenSet() const { return m_failureMessageHasBeenSet; }
  template <typename FailureMessageT = Aws::String>
  void SetFailureMessage(FailureMessageT&& value) {
    m_failureMessageHasBeenSet = true;
    m_failureMessage = std::forward<FailureMessageT>(value);
  }
  template <typename FailureMessageT = Aws::String>
  IdentityProviderSummary& WithFailureMessage(FailureMessageT&& value) {
    SetFailureMessage(std::forward<FailureMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The AWS Account ID of the owner of this resource.</p>
   */
  inline const Aws::String& GetOwnerAccountId() const { return m_ownerAccountId; }
  inline bool OwnerAccountIdHasBeenSet() const { return m_ownerAccountIdHasBeenSet; }
  template <typename OwnerAccountIdT = Aws::String>
  void SetOwnerAccountId(OwnerAccountIdT&& value) {
    m_ownerAccountIdHasBeenSet = true;
    m_ownerAccountId = std::forward<OwnerAccountIdT>(value);
  }
  template <typename OwnerAccountIdT = Aws::String>
  IdentityProviderSummary& WithOwnerAccountId(OwnerAccountIdT&& value) {
    SetOwnerAccountId(std::forward<OwnerAccountIdT>(value));
    return *this;
  }
  ///@}
 private:
  IdentityProvider m_identityProvider;

  Settings m_settings;

  Aws::String m_product;

  Aws::String m_status;

  Aws::String m_identityProviderArn;

  Aws::String m_failureMessage;

  Aws::String m_ownerAccountId;
  bool m_identityProviderHasBeenSet = false;
  bool m_settingsHasBeenSet = false;
  bool m_productHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_identityProviderArnHasBeenSet = false;
  bool m_failureMessageHasBeenSet = false;
  bool m_ownerAccountIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LicenseManagerUserSubscriptions
}  // namespace Aws
