﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock/Bedrock_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Bedrock {
namespace Model {

/**
 * <p>Dimensional price rate.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DimensionalPriceRate">AWS
 * API Reference</a></p>
 */
class DimensionalPriceRate {
 public:
  AWS_BEDROCK_API DimensionalPriceRate() = default;
  AWS_BEDROCK_API DimensionalPriceRate(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCK_API DimensionalPriceRate& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCK_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Dimension for the price rate.</p>
   */
  inline const Aws::String& GetDimension() const { return m_dimension; }
  inline bool DimensionHasBeenSet() const { return m_dimensionHasBeenSet; }
  template <typename DimensionT = Aws::String>
  void SetDimension(DimensionT&& value) {
    m_dimensionHasBeenSet = true;
    m_dimension = std::forward<DimensionT>(value);
  }
  template <typename DimensionT = Aws::String>
  DimensionalPriceRate& WithDimension(DimensionT&& value) {
    SetDimension(std::forward<DimensionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Single-dimensional rate information.</p>
   */
  inline const Aws::String& GetPrice() const { return m_price; }
  inline bool PriceHasBeenSet() const { return m_priceHasBeenSet; }
  template <typename PriceT = Aws::String>
  void SetPrice(PriceT&& value) {
    m_priceHasBeenSet = true;
    m_price = std::forward<PriceT>(value);
  }
  template <typename PriceT = Aws::String>
  DimensionalPriceRate& WithPrice(PriceT&& value) {
    SetPrice(std::forward<PriceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Description of the price rate.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DimensionalPriceRate& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Unit associated with the price.</p>
   */
  inline const Aws::String& GetUnit() const { return m_unit; }
  inline bool UnitHasBeenSet() const { return m_unitHasBeenSet; }
  template <typename UnitT = Aws::String>
  void SetUnit(UnitT&& value) {
    m_unitHasBeenSet = true;
    m_unit = std::forward<UnitT>(value);
  }
  template <typename UnitT = Aws::String>
  DimensionalPriceRate& WithUnit(UnitT&& value) {
    SetUnit(std::forward<UnitT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_dimension;

  Aws::String m_price;

  Aws::String m_description;

  Aws::String m_unit;
  bool m_dimensionHasBeenSet = false;
  bool m_priceHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_unitHasBeenSet = false;
};

}  // namespace Model
}  // namespace Bedrock
}  // namespace Aws
