/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.VariantMultipartFormParameters;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpInputStream;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpOutputStream;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.view.View;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiParameter;
import org.zaproxy.zap.extension.api.ApiPersistentConnection;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.api.OptionsParamApi;
import org.zaproxy.zap.extension.api.WebUI;
import org.zaproxy.zap.utils.JsonUtil;
import org.zaproxy.zap.utils.Stats;

public class API {
    public static final String API_DOMAIN = "zap";
    public static final String API_URL = "http://zap/";
    public static final String API_URL_S = "https://zap/";
    public static final String TRANSFER_DIR_TOKEN = "${XFER}";
    public static final String API_KEY_PARAM = "apikey";
    public static final String API_NONCE_PARAM = "apinonce";
    private static Pattern patternParam = Pattern.compile("&", 2);
    private static final String CALL_BACK_URL = "/zapCallBackUrl/";
    private static final String STATUS_OK = "200 OK";
    private static final String STATUS_BAD_REQUEST = "400 Bad Request";
    private static final String STATUS_INTERNAL_SERVER_ERROR = "500 Internal Server Error";
    private static final String STATS_PREFIX = "stats.api.";
    private Map<String, ApiImplementor> implementors = new HashMap<String, ApiImplementor>();
    private static API api = null;
    private WebUI webUI = new WebUI(this);
    private Map<String, ApiImplementor> callBacks = new HashMap<String, ApiImplementor>();
    private Map<String, ApiImplementor> shortcuts = new HashMap<String, ApiImplementor>();
    private Map<String, Nonce> nonces = Collections.synchronizedMap(new HashMap());
    private OptionsParamApi optionsParamApi;
    private ProxyParam proxyParam;
    private Random random = new SecureRandom();
    private static final Logger LOGGER = LogManager.getLogger(API.class);

    private static synchronized API newInstance() {
        if (api == null) {
            api = new API();
        }
        return api;
    }

    public static API getInstance() {
        if (api == null) {
            API.newInstance();
        }
        return api;
    }

    public void registerApiImplementor(ApiImplementor impl) {
        if (this.implementors.get(impl.getPrefix()) != null) {
            LOGGER.error("Second attempt to register API implementor with prefix of {}", (Object)impl.getPrefix());
            return;
        }
        this.implementors.put(impl.getPrefix(), impl);
        for (String shortcut : impl.getApiShortcuts()) {
            LOGGER.debug("Registering API shortcut: {}", (Object)shortcut);
            if (this.shortcuts.containsKey(shortcut)) {
                LOGGER.error("Duplicate API shortcut: {}", (Object)shortcut);
            }
            this.shortcuts.put("/" + shortcut, impl);
        }
    }

    public void removeApiImplementor(ApiImplementor impl) {
        if (!this.implementors.containsKey(impl.getPrefix())) {
            LOGGER.warn("Attempting to remove an API implementor not registered, with prefix: {}", (Object)impl.getPrefix());
            return;
        }
        this.implementors.remove(impl.getPrefix());
        for (String shortcut : impl.getApiShortcuts()) {
            String key = "/" + shortcut;
            if (!this.shortcuts.containsKey(key)) continue;
            LOGGER.debug("Removing registered API shortcut: {}", (Object)shortcut);
            this.shortcuts.remove(key);
        }
        this.removeCallBackUrls(impl);
    }

    public boolean isEnabled() {
        return !View.isInitialised() || this.getOptionsParamApi().isEnabled();
    }

    private OptionsParamApi getOptionsParamApi() {
        if (this.optionsParamApi == null) {
            this.optionsParamApi = Model.getSingleton().getOptionsParam().getApiParam();
        }
        return this.optionsParamApi;
    }

    void setOptionsParamApi(OptionsParamApi optionsParamApi) {
        this.optionsParamApi = optionsParamApi;
    }

    private ProxyParam getProxyParam() {
        if (this.proxyParam == null) {
            this.proxyParam = Model.getSingleton().getOptionsParam().getProxyParam();
        }
        return this.proxyParam;
    }

    void setProxyParam(ProxyParam proxyParam) {
        this.proxyParam = proxyParam;
    }

    public HttpMessage handleApiRequest(HttpRequestHeader requestHeader, HttpInputStream httpIn, HttpOutputStream httpOut) throws IOException {
        return this.handleApiRequest(requestHeader, httpIn, httpOut, false);
    }

    private boolean isPermittedAddr(HttpRequestHeader requestHeader) {
        if (this.getOptionsParamApi().isPermittedAddress(requestHeader.getSenderAddress().getHostAddress())) {
            if (this.getOptionsParamApi().isPermittedAddress(requestHeader.getHostName())) {
                return true;
            }
            LOGGER.warn("Request to API URL {} with host header {} not permitted", (Object)requestHeader.getURI(), (Object)requestHeader.getHostName());
            return false;
        }
        LOGGER.warn("Request to API URL {} from {} not permitted", (Object)requestHeader.getURI(), (Object)requestHeader.getSenderAddress().getHostAddress());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public HttpMessage handleApiRequest(HttpRequestHeader requestHeader, HttpInputStream httpIn, HttpOutputStream httpOut, boolean force) throws IOException {
        void var10_19;
        boolean error;
        String name;
        String response;
        String contentType;
        RequestType reqType;
        ApiImplementor impl;
        ApiImplementor shortcutImpl;
        ApiImplementor callbackImpl;
        Format format;
        block70: {
            String path;
            String url = requestHeader.getURI().toString();
            format = Format.OTHER;
            callbackImpl = null;
            shortcutImpl = null;
            if (url.contains(CALL_BACK_URL)) {
                LOGGER.debug("handleApiRequest Callback: {}", (Object)url);
                for (Map.Entry<String, ApiImplementor> entry : this.callBacks.entrySet()) {
                    if (!url.startsWith(entry.getKey())) continue;
                    callbackImpl = entry.getValue();
                    break;
                }
                if (callbackImpl == null) {
                    for (Map.Entry<String, Object> entry : this.getOptionsParamApi().getPersistentCallBacks().entrySet()) {
                        if (url.startsWith(entry.getKey()) && (callbackImpl = this.getImplementors().get(entry.getValue())) != null) break;
                    }
                }
                if (callbackImpl == null) {
                    LOGGER.warn("Request to callback URL {} from {} not found - this could be a callback url from a previous session or possibly an attempt to attack ZAP", (Object)requestHeader.getURI(), (Object)requestHeader.getSenderAddress().getHostAddress());
                    return new HttpMessage();
                }
            }
            if ((path = requestHeader.getURI().getPath()) != null) {
                for (Map.Entry<String, ApiImplementor> shortcut : this.shortcuts.entrySet()) {
                    if (!path.startsWith(shortcut.getKey())) continue;
                    shortcutImpl = shortcut.getValue();
                    break;
                }
            }
            if (!(callbackImpl != null || url.startsWith(API_URL) || url.startsWith(API_URL_S) || force)) {
                return null;
            }
            if (callbackImpl == null && !this.isPermittedAddr(requestHeader)) {
                return new HttpMessage();
            }
            if (this.getOptionsParamApi().isSecureOnly() && !requestHeader.isSecure()) {
                LOGGER.debug("handleApiRequest rejecting insecure request");
                return new HttpMessage();
            }
            LOGGER.debug("handleApiRequest {}", (Object)url);
            HttpMessage httpMessage = new HttpMessage();
            httpMessage.setRequestHeader(requestHeader);
            if (requestHeader.getContentLength() > 0) {
                httpMessage.setRequestBody(httpIn.readRequestBody(requestHeader));
            }
            String component = null;
            impl = null;
            reqType = null;
            contentType = "text/plain; charset=UTF-8";
            response = "";
            name = null;
            error = false;
            try {
                if (shortcutImpl != null) {
                    if (!(this.getOptionsParamApi().isDisableKey() || this.getOptionsParamApi().isNoKeyForSafeOps() || this.hasValidKey(requestHeader, API.getParams(requestHeader)))) {
                        throw new ApiException(ApiException.Type.BAD_API_KEY);
                    }
                    HttpMessage httpMessage2 = shortcutImpl.handleShortcut(httpMessage);
                    impl = shortcutImpl;
                    break block70;
                }
                if (callbackImpl != null) {
                    response = callbackImpl.handleCallBack(httpMessage);
                    impl = callbackImpl;
                    break block70;
                }
                JSONObject params = API.getParams(requestHeader);
                String[] elements = url.split("/");
                if (elements.length > 3 && elements[3].equalsIgnoreCase("favicon.ico")) {
                    if (!this.getOptionsParamApi().isUiEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    InputStream is = API.class.getResourceAsStream("/resource/zap.ico");
                    byte[] icon = new byte[is.available()];
                    is.read(icon);
                    is.close();
                    httpMessage.setResponseHeader(API.getDefaultResponseHeader(contentType));
                    httpMessage.getResponseHeader().setContentLength(icon.length);
                    httpMessage.getResponseBody().setBody(icon);
                    httpOut.write(httpMessage.getResponseHeader());
                    httpOut.write(icon);
                    httpOut.flush();
                    httpOut.close();
                    httpIn.close();
                    return httpMessage;
                }
                if (elements.length > 3) {
                    try {
                        format = Format.valueOf(elements[3].toUpperCase());
                        switch (format) {
                            case JSONP: {
                                contentType = "application/javascript; charset=UTF-8";
                                break;
                            }
                            case XML: {
                                contentType = "text/xml; charset=UTF-8";
                                break;
                            }
                            case HTML: {
                                contentType = "text/html; charset=UTF-8";
                                break;
                            }
                            case UI: {
                                contentType = "text/html; charset=UTF-8";
                                break;
                            }
                            default: {
                                contentType = "application/json; charset=UTF-8";
                                break;
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        format = Format.HTML;
                        throw new ApiException(ApiException.Type.BAD_FORMAT, (Throwable)e);
                    }
                }
                if (elements.length > 4 && (impl = this.implementors.get(component = elements[4])) == null) {
                    throw new ApiException(ApiException.Type.NO_IMPLEMENTOR);
                }
                if (elements.length > 5) {
                    try {
                        reqType = RequestType.valueOf(elements[5]);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ApiException(ApiException.Type.BAD_TYPE, (Throwable)e);
                    }
                }
                if (elements.length > 6 && (name = elements[6]) != null && name.indexOf("?") > 0) {
                    name = name.substring(0, name.indexOf("?"));
                }
                if (format.equals((Object)Format.UI)) {
                    if (!this.isEnabled() || !this.getOptionsParamApi().isUiEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    response = this.webUI.handleRequest(component, impl, reqType, name);
                    contentType = "text/html; charset=UTF-8";
                } else if (name != null) {
                    if (!this.isEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    if (requestHeader.getMethod().equalsIgnoreCase("POST")) {
                        String contentTypeHeader = requestHeader.getHeader("content-type");
                        if (contentTypeHeader != null && contentTypeHeader.equals("application/x-www-form-urlencoded")) {
                            params = API.getParams(httpMessage.getRequestBody().toString());
                        } else if (contentTypeHeader != null && contentTypeHeader.startsWith("multipart/form-data")) {
                            VariantMultipartFormParameters tmpVarent = new VariantMultipartFormParameters();
                            tmpVarent.setMessage(httpMessage);
                            params = new JSONObject();
                            for (NameValuePair param : tmpVarent.getParamList()) {
                                params.put((Object)param.getName(), (Object)JsonUtil.getJsonFriendlyString(param.getValue()));
                            }
                        } else {
                            throw new ApiException(ApiException.Type.CONTENT_TYPE_NOT_SUPPORTED);
                        }
                    }
                    if (format.equals((Object)Format.JSONP)) {
                        if (!this.getOptionsParamApi().isEnableJSONP()) {
                            throw new ApiException(ApiException.Type.DISABLED);
                        }
                        if (!this.hasValidKey(requestHeader, params)) {
                            throw new ApiException(ApiException.Type.BAD_API_KEY);
                        }
                    }
                    if (reqType == null) {
                        throw new ApiException(ApiException.Type.BAD_TYPE, "Request Type was not provided.");
                    }
                    if (impl == null) {
                        throw new ApiException(ApiException.Type.NO_IMPLEMENTOR, "Implementor was not provided.");
                    }
                    this.incStatistic("call", format, component, reqType, name);
                    switch (reqType) {
                        case action: {
                            if (!this.getOptionsParamApi().isDisableKey() && !this.hasValidKey(requestHeader, params)) {
                                throw new ApiException(ApiException.Type.BAD_API_KEY);
                            }
                            API.validateFormatForViewAction(format);
                            ApiAction action = impl.getApiAction(name);
                            this.validateMandatoryParams(params, action);
                            ApiResponse res = impl.handleApiOptionAction(name, params);
                            if (res == null) {
                                res = impl.handleApiAction(name, params);
                            }
                            response = API.convertViewActionApiResponse(format, name, res);
                            break;
                        }
                        case view: {
                            if (!(this.getOptionsParamApi().isDisableKey() || this.getOptionsParamApi().isNoKeyForSafeOps() || this.hasValidKey(requestHeader, params))) {
                                throw new ApiException(ApiException.Type.BAD_API_KEY);
                            }
                            API.validateFormatForViewAction(format);
                            ApiView view = impl.getApiView(name);
                            this.validateMandatoryParams(params, view);
                            ApiResponse res = impl.handleApiOptionView(name, params);
                            if (res == null) {
                                res = impl.handleApiView(name, params);
                            }
                            response = API.convertViewActionApiResponse(format, name, res);
                            break;
                        }
                        case other: {
                            ApiOther other = impl.getApiOther(name);
                            if (other != null) {
                                if (!(this.getOptionsParamApi().isDisableKey() || this.getOptionsParamApi().isNoKeyForSafeOps() && !other.isRequiresApiKey() || this.hasValidKey(requestHeader, params))) {
                                    throw new ApiException(ApiException.Type.BAD_API_KEY);
                                }
                                this.validateMandatoryParams(params, other);
                            }
                            HttpMessage httpMessage3 = impl.handleApiOther(httpMessage, name, params);
                            break;
                        }
                        case pconn: {
                            ApiPersistentConnection pconn = impl.getApiPersistentConnection(name);
                            if (pconn != null) {
                                if (!(this.getOptionsParamApi().isDisableKey() || this.getOptionsParamApi().isNoKeyForSafeOps() || this.hasValidKey(requestHeader, params))) {
                                    throw new ApiException(ApiException.Type.BAD_API_KEY);
                                }
                                this.validateMandatoryParams(params, pconn);
                            }
                            impl.handleApiPersistentConnection(httpMessage, httpIn, httpOut, name, params);
                            return new HttpMessage();
                        }
                    }
                } else {
                    if (!this.isEnabled() || !this.getOptionsParamApi().isUiEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    response = this.webUI.handleRequest(requestHeader.getURI(), this.isEnabled());
                    format = Format.UI;
                    contentType = "text/html; charset=UTF-8";
                }
            }
            catch (Exception e) {
                if (!this.getOptionsParamApi().isReportPermErrors()) {
                    ApiException exception;
                    if (component != null && format != null && reqType != null && name != null) {
                        this.incStatistic("error", format, component, reqType, name);
                    }
                    if (e instanceof ApiException && ((exception = (ApiException)e).getType().equals((Object)ApiException.Type.DISABLED) || exception.getType().equals((Object)ApiException.Type.BAD_API_KEY))) {
                        return new HttpMessage();
                    }
                }
                this.handleException(httpMessage, reqType, format, contentType, e);
                error = true;
            }
        }
        if (!error && !format.equals((Object)Format.OTHER) && shortcutImpl == null && callbackImpl == null) {
            var10_19.setResponseHeader(API.getDefaultResponseHeader(contentType));
            var10_19.setResponseBody(response);
            var10_19.getResponseHeader().setContentLength(var10_19.getResponseBody().length());
        }
        if (impl != null) {
            impl.addCustomHeaders(name, reqType, (HttpMessage)var10_19);
        }
        httpOut.write(var10_19.getResponseHeader());
        httpOut.write(var10_19.getResponseBody().getBytes());
        httpOut.flush();
        if (!var10_19.isWebSocketUpgrade()) {
            httpOut.close();
            httpIn.close();
        }
        return var10_19;
    }

    private void incStatistic(String type, Format format, String component, RequestType reqType, String name) {
        Stats.incCounter(STATS_PREFIX + type + "." + format.name().toLowerCase(Locale.ROOT) + "." + component + "." + reqType.name() + "." + name);
    }

    private void validateMandatoryParams(JSONObject params, ApiElement element) throws ApiException {
        if (element == null) {
            return;
        }
        for (ApiParameter parameter : element.getParameters()) {
            String name;
            if (!parameter.isRequired() || params.has(name = parameter.getName()) && params.getString(name).length() != 0) continue;
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, name);
        }
    }

    private static String convertViewActionApiResponse(Format format, String name, ApiResponse res) throws ApiException {
        switch (format) {
            case JSON: {
                return res.toJSON().toString();
            }
            case JSONP: {
                return API.getJsonpWrapper(res.toJSON().toString());
            }
            case XML: {
                return API.responseToXml(name, res);
            }
            case HTML: {
                return API.responseToHtml(res);
            }
        }
        LOGGER.error("Unhandled format: {}", (Object)format);
        throw new ApiException(ApiException.Type.INTERNAL_ERROR);
    }

    private static void validateFormatForViewAction(Format format) throws ApiException {
        switch (format) {
            case JSONP: 
            case XML: 
            case HTML: 
            case JSON: {
                return;
            }
        }
        throw new ApiException(ApiException.Type.BAD_FORMAT, "The format OTHER should not be used with views and actions.");
    }

    public String getBaseURL(Format format, String prefix, RequestType type, String name, boolean proxy) {
        String apiPath = format.name() + "/" + prefix + "/" + type.name() + "/" + name + "/";
        if (!RequestType.view.equals((Object)type)) {
            return this.getBaseURL(proxy) + apiPath + "?apinonce=" + this.getOneTimeNonce("/" + apiPath) + "&";
        }
        return this.getBaseURL(proxy) + apiPath;
    }

    public String getBaseURL(boolean proxy) {
        if (proxy) {
            return this.getOptionsParamApi().isSecureOnly() ? API_URL_S : API_URL;
        }
        StringBuilder strBuilder = new StringBuilder(50);
        strBuilder.append("http");
        if (this.getOptionsParamApi().isSecureOnly()) {
            strBuilder.append('s');
        }
        strBuilder.append("://").append(this.getProxyParam().getProxyIp()).append(':').append(this.getProxyParam().getProxyPort()).append('/');
        return strBuilder.toString();
    }

    static String responseToHtml(ApiResponse response) {
        StringBuilder sb = new StringBuilder();
        sb.append("<head>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        response.toHTML(sb);
        sb.append("</body>\n");
        return sb.toString();
    }

    static String responseToXml(String endpointName, ApiResponse response) throws ApiException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement(endpointName);
            doc.appendChild(rootElement);
            response.toXML(doc, rootElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (Exception e) {
            LOGGER.error("Failed to convert API response to XML: {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private static JSONObject getParams(HttpRequestHeader requestHeader) throws ApiException {
        return API.getParams(requestHeader.getURI().getEscapedQuery());
    }

    private static String replaceXferTokens(String key, String value) {
        String keyLc = key.toLowerCase(Locale.ROOT);
        if ((keyLc.contains("file") || keyLc.contains("path") || keyLc.contains("dir")) && value.startsWith(TRANSFER_DIR_TOKEN)) {
            Object relPath = value.substring(TRANSFER_DIR_TOKEN.length());
            if (!((String)relPath).startsWith("/") && !((String)relPath).startsWith("\\")) {
                relPath = "/" + (String)relPath;
            }
            return Model.getSingleton().getOptionsParam().getApiParam().getTransferDir().toString() + (String)relPath;
        }
        return value;
    }

    private static String decodeParam(String param) throws UnsupportedEncodingException {
        return URLDecoder.decode(param, "UTF-8");
    }

    public static JSONObject getParams(String params) throws ApiException {
        JSONObject jp = new JSONObject();
        if (params == null || params.length() == 0) {
            return jp;
        }
        String[] keyValue = patternParam.split(params);
        String key = null;
        String value = null;
        int pos = 0;
        for (int i = 0; i < keyValue.length; ++i) {
            key = null;
            pos = keyValue[i].indexOf(61);
            if (pos > 0) {
                try {
                    key = API.decodeParam(keyValue[i].substring(0, pos));
                    value = API.replaceXferTokens(key, API.decodeParam(keyValue[i].substring(pos + 1)));
                    jp.put((Object)key, (Object)JsonUtil.getJsonFriendlyString(value));
                }
                catch (UnsupportedEncodingException | IllegalArgumentException e) {
                    ApiException apiException = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, params, e);
                    LOGGER.error(apiException.getMessage(), (Throwable)apiException);
                }
                continue;
            }
            ApiException e = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, params);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return jp;
    }

    private static String getJsonpWrapper(String json) {
        return "zapJsonpResult (" + json + " )";
    }

    public Map<String, ApiImplementor> getImplementors() {
        return Collections.unmodifiableMap(this.implementors);
    }

    public String getCallBackUrl(ApiImplementor impl, String site) {
        String url = site + CALL_BACK_URL + this.random.nextLong();
        this.callBacks.put(url, impl);
        LOGGER.debug("Callback {} registered for {}", (Object)url, (Object)impl.getClass().getCanonicalName());
        return url;
    }

    public void removeCallBackUrl(String url) {
        LOGGER.debug("Callback {} removed", (Object)url);
        this.callBacks.remove(url);
    }

    public void removeCallBackUrls(ApiImplementor impl) {
        if (impl == null) {
            throw new IllegalArgumentException("Parameter impl must not be null.");
        }
        LOGGER.debug("All callbacks removed for {}", (Object)impl.getClass().getCanonicalName());
        this.callBacks.values().removeIf(impl::equals);
    }

    public String getPersistentCallBackUrl(ApiImplementor impl, String site) {
        for (Map.Entry<String, String> entry : this.getOptionsParamApi().getPersistentCallBacks().entrySet()) {
            String url = entry.getKey();
            if (!url.startsWith(site) || !entry.getValue().equals(impl.getPrefix())) continue;
            return url;
        }
        String url = site + CALL_BACK_URL + this.random.nextLong();
        this.getOptionsParamApi().addPersistantCallBack(url, impl.getPrefix());
        return url;
    }

    public boolean removePersistentCallBackUrl(String url) {
        return this.getOptionsParamApi().removePersistantCallBack(url) != null;
    }

    public String getOneTimeNonce(String apiUrl) {
        String nonce = Long.toHexString(this.random.nextLong());
        this.nonces.put(nonce, new Nonce(nonce, apiUrl, true));
        return nonce;
    }

    public String getLongLivedNonce(String apiUrl) {
        String nonce = Long.toHexString(this.random.nextLong());
        this.nonces.put(nonce, new Nonce(nonce, apiUrl, false));
        return nonce;
    }

    public boolean hasValidKey(HttpMessage msg) {
        try {
            HttpRequestHeader requestHeader = msg.getRequestHeader();
            return this.hasValidKey(requestHeader, API.getParams(requestHeader));
        }
        catch (ApiException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasValidKey(HttpRequestHeader reqHeader, JSONObject params) {
        try {
            String apiPath;
            try {
                apiPath = reqHeader.getURI().getPath();
            }
            catch (URIException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                boolean bl = false;
                Map<String, Nonce> map = this.nonces;
                synchronized (map) {
                    Iterator<Nonce> it = this.nonces.values().iterator();
                    while (it.hasNext()) {
                        if (it.next().isValid()) continue;
                        it.remove();
                    }
                }
                return bl;
            }
            String nonceParam = reqHeader.getHeader("x-zap-api-nonce");
            if (nonceParam == null && params.has(API_NONCE_PARAM)) {
                nonceParam = params.getString(API_NONCE_PARAM);
            }
            if (nonceParam != null) {
                Nonce nonce = this.nonces.get(nonceParam);
                if (nonce == null) {
                    LOGGER.warn("API nonce {} not found in request from {}", (Object)nonceParam, (Object)reqHeader.getSenderAddress().getHostAddress());
                    boolean bl = false;
                    return bl;
                }
                if (nonce.isOneTime()) {
                    this.nonces.remove(nonceParam);
                }
                if (!nonce.isValid()) {
                    LOGGER.warn("API nonce {} expired at {} in request from {}", (Object)nonce.getNonceKey(), (Object)nonce.getExpires(), (Object)reqHeader.getSenderAddress().getHostAddress());
                    boolean bl = false;
                    return bl;
                }
                if (!apiPath.equals(nonce.getApiPath())) {
                    LOGGER.warn("API nonce path was {} but call was for {} in request from {}", (Object)nonce.getApiPath(), (Object)apiPath, (Object)reqHeader.getSenderAddress().getHostAddress());
                    boolean bl = false;
                    return bl;
                }
            } else {
                String keyParam = reqHeader.getHeader("x-zap-api-key");
                if (keyParam == null && params.has(API_KEY_PARAM)) {
                    keyParam = params.getString(API_KEY_PARAM);
                }
                if (!this.getOptionsParamApi().getKey().equals(keyParam)) {
                    LOGGER.warn("API key incorrect or not supplied: {} in request from {}", (Object)keyParam, (Object)reqHeader.getSenderAddress().getHostAddress());
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Map<String, Nonce> map = this.nonces;
            synchronized (map) {
                Iterator<Nonce> it = this.nonces.values().iterator();
                while (it.hasNext()) {
                    if (it.next().isValid()) continue;
                    it.remove();
                }
            }
        }
    }

    public static String getDefaultResponseHeader(String contentType) {
        return API.getDefaultResponseHeader(contentType, 0);
    }

    public static String getDefaultResponseHeader(String contentType, int contentLength) {
        return API.getDefaultResponseHeader(STATUS_OK, contentType, contentLength, false);
    }

    public static String getDefaultResponseHeader(String contentType, int contentLength, boolean canCache) {
        return API.getDefaultResponseHeader(STATUS_OK, contentType, contentLength, canCache);
    }

    public static String getDefaultResponseHeader(String responseStatus, String contentType, int contentLength) {
        return API.getDefaultResponseHeader(responseStatus, contentType, contentLength, false);
    }

    public static String getDefaultResponseHeader(String responseStatus, String contentType, int contentLength, boolean canCache) {
        StringBuilder sb = new StringBuilder(250);
        sb.append("HTTP/1.1 ").append(responseStatus).append("\r\n");
        if (!canCache) {
            sb.append("Pragma: no-cache\r\n");
            sb.append("Cache-Control: no-cache, no-store, must-revalidate\r\n");
        }
        sb.append("Content-Security-Policy: default-src 'none'; script-src 'self'; connect-src 'self'; child-src 'self'; img-src 'self' data:; font-src 'self' data:; style-src 'self'\r\n");
        sb.append("Referrer-Policy: no-referrer\r\n");
        sb.append("Access-Control-Allow-Methods: GET,POST,OPTIONS\r\n");
        sb.append("Access-Control-Allow-Headers: ZAP-Header\r\n");
        sb.append("X-Frame-Options: DENY\r\n");
        sb.append("X-XSS-Protection: 1; mode=block\r\n");
        sb.append("X-Content-Type-Options: nosniff\r\n");
        sb.append("X-Clacks-Overhead: GNU Terry Pratchett\r\n");
        sb.append("Content-Length: ").append(contentLength).append("\r\n");
        if (contentType != null) {
            sb.append("Content-Type: ").append(contentType).append("\r\n");
        }
        return sb.toString();
    }

    private void handleException(HttpMessage msg, RequestType reqType, Format format, String contentType, Exception cause) {
        String responseStatus = STATUS_INTERNAL_SERVER_ERROR;
        if (reqType == RequestType.other) {
            boolean logError = true;
            if (cause instanceof ApiException) {
                switch (((ApiException)cause).getType()) {
                    case DISABLED: 
                    case BAD_TYPE: 
                    case NO_IMPLEMENTOR: 
                    case BAD_API_KEY: 
                    case MISSING_PARAMETER: 
                    case BAD_ACTION: 
                    case BAD_VIEW: 
                    case BAD_OTHER: {
                        responseStatus = STATUS_BAD_REQUEST;
                        API.logBadRequest(msg, cause);
                        logError = false;
                        break;
                    }
                }
            }
            if (logError) {
                LOGGER.error("API 'other' endpoint didn't handle exception:", (Throwable)cause);
            }
        } else {
            ApiException exception;
            if (cause instanceof ApiException) {
                exception = (ApiException)cause;
                if (!ApiException.Type.INTERNAL_ERROR.equals((Object)exception.getType())) {
                    responseStatus = STATUS_BAD_REQUEST;
                    API.logBadRequest(msg, cause);
                }
            } else {
                exception = new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)cause);
                LOGGER.error("Exception while handling API request:", (Throwable)cause);
            }
            String response = exception.toString(format != Format.OTHER ? format : Format.JSON, this.getOptionsParamApi().isIncErrorDetails());
            msg.getResponseBody().setCharset(API.getCharset(contentType));
            msg.getResponseBody().setBody(response);
        }
        try {
            msg.setResponseHeader(API.getDefaultResponseHeader(responseStatus, contentType, msg.getResponseBody().length()));
        }
        catch (HttpMalformedHeaderException e) {
            LOGGER.warn("Failed to build API error response:", (Throwable)e);
        }
    }

    private static void logBadRequest(HttpMessage msg, Exception cause) {
        LOGGER.warn("Bad request to API endpoint [{}] from [{}]:", (Object)msg.getRequestHeader().getURI().getEscapedPath(), (Object)msg.getRequestHeader().getSenderAddress().getHostAddress(), (Object)cause);
    }

    private static String getCharset(String contentType) {
        int idx = contentType.indexOf("charset=");
        if (idx == -1) {
            return "UTF-8";
        }
        return contentType.substring(idx + 8);
    }

    public static enum Format {
        XML,
        HTML,
        JSON,
        JSONP,
        UI,
        OTHER;

    }

    public static enum RequestType {
        action,
        view,
        other,
        pconn;

    }

    private class Nonce {
        private final String nonceKey;
        private final String apiPath;
        private final boolean oneTime;
        private final Date expires;

        public Nonce(String nonceKey, String apiStr, boolean oneTime) {
            this.nonceKey = nonceKey;
            this.apiPath = apiStr;
            this.oneTime = oneTime;
            this.expires = DateUtils.addSeconds((Date)new Date(), (int)API.this.getOptionsParamApi().getNonceTimeToLiveInSecs());
        }

        public String getNonceKey() {
            return this.nonceKey;
        }

        public String getApiPath() {
            return this.apiPath;
        }

        public boolean isOneTime() {
            return this.oneTime;
        }

        public boolean isValid() {
            return !this.oneTime || this.expires.after(new Date());
        }

        public Date getExpires() {
            return this.expires;
        }
    }
}

