/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityGroupReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityGroupReference> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(SecurityGroupReference.getter(SecurityGroupReference::groupId)).setter(SecurityGroupReference.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final SdkField<String> REFERENCING_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReferencingVpcId").getter(SecurityGroupReference.getter(SecurityGroupReference::referencingVpcId)).setter(SecurityGroupReference.setter(Builder::referencingVpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencingVpcId").unmarshallLocationName("referencingVpcId").build()}).build();
    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcPeeringConnectionId").getter(SecurityGroupReference.getter(SecurityGroupReference::vpcPeeringConnectionId)).setter(SecurityGroupReference.setter(Builder::vpcPeeringConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").unmarshallLocationName("vpcPeeringConnectionId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(SecurityGroupReference.getter(SecurityGroupReference::transitGatewayId)).setter(SecurityGroupReference.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("transitGatewayId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, REFERENCING_VPC_ID_FIELD, VPC_PEERING_CONNECTION_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecurityGroupReference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupId;
    private final String referencingVpcId;
    private final String vpcPeeringConnectionId;
    private final String transitGatewayId;

    private SecurityGroupReference(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.referencingVpcId = builder.referencingVpcId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
        this.transitGatewayId = builder.transitGatewayId;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String referencingVpcId() {
        return this.referencingVpcId;
    }

    public final String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    public final String transitGatewayId() {
        return this.transitGatewayId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.referencingVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupReference)) {
            return false;
        }
        SecurityGroupReference other = (SecurityGroupReference)obj;
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.referencingVpcId(), other.referencingVpcId()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityGroupReference").add("GroupId", (Object)this.groupId()).add("ReferencingVpcId", (Object)this.referencingVpcId()).add("VpcPeeringConnectionId", (Object)this.vpcPeeringConnectionId()).add("TransitGatewayId", (Object)this.transitGatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "ReferencingVpcId": {
                return Optional.ofNullable(clazz.cast(this.referencingVpcId()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringConnectionId()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("ReferencingVpcId", REFERENCING_VPC_ID_FIELD);
        map.put("VpcPeeringConnectionId", VPC_PEERING_CONNECTION_ID_FIELD);
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupReference, T> g) {
        return obj -> g.apply((SecurityGroupReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupId;
        private String referencingVpcId;
        private String vpcPeeringConnectionId;
        private String transitGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupReference model) {
            this.groupId(model.groupId);
            this.referencingVpcId(model.referencingVpcId);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
            this.transitGatewayId(model.transitGatewayId);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getReferencingVpcId() {
            return this.referencingVpcId;
        }

        public final void setReferencingVpcId(String referencingVpcId) {
            this.referencingVpcId = referencingVpcId;
        }

        @Override
        public final Builder referencingVpcId(String referencingVpcId) {
            this.referencingVpcId = referencingVpcId;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public SecurityGroupReference build() {
            return new SecurityGroupReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityGroupReference> {
        public Builder groupId(String var1);

        public Builder referencingVpcId(String var1);

        public Builder vpcPeeringConnectionId(String var1);

        public Builder transitGatewayId(String var1);
    }
}

