/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import jnr.posix.util.Platform;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Check;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"Dir"}, include={"Enumerable"})
public class RubyDir
extends RubyObject
implements Closeable {
    private RubyString path;
    protected FileResource dir;
    private long lastModified = Long.MIN_VALUE;
    private String[] snapshot;
    private int pos;
    private boolean isOpen = true;
    private Encoding encoding;
    private static final String[] BASE_KEYWORDS = new String[]{"base", "sort"};
    private static final String[] BASE_FLAGS_KEYWORDS = new String[]{"base", "sort", "flags"};
    private static final String[] NO_FILES = StringSupport.EMPTY_STRING_ARRAY;
    static final ByteList HOME = new ByteList(new byte[]{72, 79, 77, 69}, false);
    private static final ByteList user_home = new ByteList(new byte[]{117, 115, 101, 114, 46, 104, 111, 109, 101}, false);

    public RubyDir(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public static RubyClass createDirClass(ThreadContext context, RubyClass Object2, RubyModule Enumerable) {
        return (RubyClass)((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "Dir", Object2, RubyDir::new).reifiedClass(RubyDir.class)).classIndex(ClassIndex.DIR)).include(context, Enumerable)).defineMethods(context, RubyDir.class);
    }

    private void checkDir(ThreadContext context) {
        this.checkDirIgnoreClosed(context);
        if (!this.isOpen) {
            throw context.runtime.newIOError("closed directory");
        }
    }

    private void checkDirIgnoreClosed(ThreadContext context) {
        this.testFrozen("Dir");
        if (this.snapshot == null || this.dir.exists() && this.dir.lastModified() > this.lastModified) {
            this.lastModified = this.dir.lastModified();
            this.snapshot = RubyDir.list(this.dir);
        }
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext context, IRubyObject path2) {
        return this.initializeCommon(context, path2, context.nil);
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext context, IRubyObject path2, IRubyObject encOpts) {
        return this.initializeCommon(context, path2, encOpts);
    }

    private RubyDir initializeCommon(ThreadContext context, IRubyObject pathArg, IRubyObject encOpts) {
        RubyString newPath;
        RubyHash opts;
        IRubyObject encodingArg;
        Encoding encoding2 = null;
        if (!encOpts.isNil() && (encodingArg = ArgsUtil.extractKeywordArg(context, opts = encOpts.convertToHash(), "encoding")) != null && !encodingArg.isNil()) {
            encoding2 = Access.encodingService(context).getEncodingFromObject(encodingArg);
        }
        if (encoding2 == null) {
            encoding2 = Access.encodingService(context).getFileSystemEncoding();
        }
        this.path = newPath = Check.checkEmbeddedNulls(context, RubyFile.get_path(context, pathArg));
        this.pos = 0;
        this.encoding = encoding2;
        String adjustedPath = RubyFile.getAdjustedPath(context, newPath);
        RubyDir.checkDirIsTwoSlashesOnWindows(context.runtime, adjustedPath);
        this.dir = JRubyFile.createResource(context, adjustedPath);
        this.snapshot = RubyDir.getEntries(context, this.dir, adjustedPath);
        return this;
    }

    private static ArrayList<ByteList> dirGlobs(ThreadContext context, String cwd, IRubyObject[] args2, int flags2, boolean sort2) {
        ArrayList<ByteList> dirs = new ArrayList<ByteList>();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            dirs.addAll(Dir.push_glob(context.runtime, cwd, RubyDir.globArgumentAsByteList(context, RubyFile.get_path(context, args2[i2])), flags2, sort2));
        }
        return dirs;
    }

    private static RubyArray asRubyStringList(Ruby runtime2, List<ByteList> dirs) {
        int size2 = dirs.size();
        if (size2 == 0) {
            return RubyArray.newEmptyArray(runtime2);
        }
        IRubyObject[] dirStrings = new IRubyObject[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            dirStrings[i2] = RubyString.newStringNoCopy(runtime2, dirs.get(i2));
        }
        return RubyArray.newArrayMayCopy(runtime2, dirStrings);
    }

    private static String getCWD(Ruby runtime2) {
        String cwd = runtime2.getCurrentDirectory();
        if (cwd.startsWith("uri:") || cwd.startsWith("jar:") || cwd.startsWith("file:")) {
            return cwd;
        }
        try {
            return new JRubyFile(cwd).getCanonicalPath();
        }
        catch (IOException e) {
            return cwd;
        }
    }

    private static void globOptions(ThreadContext context, IRubyObject[] args2, String[] keys2, GlobOptions options2) {
        Ruby runtime2 = context.runtime;
        if (args2.length > 1) {
            boolean processFlags;
            IRubyObject tmp = TypeConverter.checkHashType(runtime2, args2[args2.length - 1]);
            boolean bl = processFlags = keys2 == BASE_FLAGS_KEYWORDS;
            if (tmp == context.nil) {
                if (processFlags) {
                    options2.flags = Convert.toInt(context, args2[1]);
                }
            } else {
                IRubyObject[] rets = ArgsUtil.extractKeywordArgs(context, (RubyHash)tmp, keys2);
                if (args2.length == 3 && processFlags) {
                    options2.flags = Convert.toInt(context, args2[1]);
                }
                if (processFlags && rets[2] != null) {
                    options2.flags |= Convert.toInt(context, rets[2]);
                }
                if (rets[1] != null) {
                    if (!(rets[1] instanceof RubyBoolean)) {
                        throw Error.argumentError(context, RubyStringBuilder.str(runtime2, "expected true or false as sort:", rets[1]));
                    }
                    boolean bl2 = options2.sort = !runtime2.getFalse().equals(rets[1]);
                }
                if (rets[0] == null || rets[0].isNil()) {
                    options2.base = "";
                    return;
                }
                RubyString path2 = RubyFile.get_path(context, rets[0]);
                Encoding[] enc = new Encoding[]{path2.getEncoding()};
                String base = path2.getUnicodeValue();
                if (!base.isEmpty()) {
                    base = RubyFile.expandPath(context, base, enc, runtime2.getCurrentDirectory(), true, false);
                }
                options2.base = base;
            }
            if (processFlags) {
                options2.flags &= 0xFFFFFFF7;
            }
        }
    }

    @JRubyMethod(name={"[]"}, rest=true, meta=true, keywords=true)
    public static IRubyObject aref(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        List<ByteList> dirs;
        Ruby runtime2 = context.runtime;
        GlobOptions options2 = new GlobOptions();
        RubyDir.globOptions(context, args2, BASE_KEYWORDS, options2);
        String base = options2.base;
        if (args2.length == 1) {
            String dir = base == null || base.isEmpty() ? runtime2.getCurrentDirectory() : base;
            dirs = Dir.push_glob(runtime2, dir, RubyDir.globArgumentAsByteList(context, args2[0]), 0, options2.sort);
        } else {
            IRubyObject[] arefArgs;
            if (base != null) {
                arefArgs = ArraySupport.newCopy(args2, args2.length - 1);
            } else {
                arefArgs = args2;
                base = "";
            }
            String dir = base.isEmpty() ? runtime2.getCurrentDirectory() : base;
            dirs = RubyDir.dirGlobs(context, dir, arefArgs, 0, options2.sort);
        }
        return RubyDir.asRubyStringList(runtime2, dirs);
    }

    private static ByteList globArgumentAsByteList(ThreadContext context, IRubyObject arg2) {
        RubyString str;
        if (!(arg2 instanceof RubyString)) {
            str = RubyFile.get_path(context, arg2);
        } else {
            if (StringSupport.strNullCheck(arg2)[0] == null) {
                throw Error.argumentError(context, "nul-separated glob pattern is deprecated");
            }
            str = (RubyString)arg2;
            if (!str.getEncoding().isAsciiCompatible()) {
                throw context.runtime.newEncodingCompatibilityError("incompatible character encodings: " + String.valueOf(str.getEncoding()) + " and " + String.valueOf(USASCIIEncoding.INSTANCE));
            }
        }
        return RubyFile.filePathConvert(context, str).getByteList();
    }

    @JRubyMethod(required=1, optional=2, checkArity=false, meta=true)
    public static IRubyObject glob(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        List<ByteList> dirs;
        Arity.checkArgumentCount(context, args2, 1, 3);
        Ruby runtime2 = context.runtime;
        GlobOptions options2 = new GlobOptions();
        RubyDir.globOptions(context, args2, BASE_FLAGS_KEYWORDS, options2);
        String base = options2.base;
        if (base != null && !base.isEmpty() && !JRubyFile.createResource(context, base).exists()) {
            dirs = new ArrayList<ByteList>();
        } else {
            IRubyObject tmp = args2[0].checkArrayType();
            String dir = base == null || base.isEmpty() ? runtime2.getCurrentDirectory() : base;
            dirs = tmp.isNil() ? Dir.push_glob(runtime2, dir, RubyDir.globArgumentAsByteList(context, args2[0]), options2.flags, options2.sort) : RubyDir.dirGlobs(context, dir, ((RubyArray)tmp).toJavaArray(context), options2.flags, options2.sort);
        }
        if (block.isGiven()) {
            for (int i2 = 0; i2 < dirs.size(); ++i2) {
                block.yield(context, Create.newString(context, (ByteList)dirs.get(i2)));
            }
            return context.nil;
        }
        return RubyDir.asRubyStringList(runtime2, dirs);
    }

    @Deprecated(since="10.0")
    public RubyArray entries() {
        return this.entries(this.getCurrentContext());
    }

    @JRubyMethod(name={"entries"})
    public RubyArray entries(ThreadContext context) {
        return RubyDir.newEntryArray(context, this.snapshot, this.encoding, false);
    }

    @JRubyMethod(name={"entries"}, meta=true)
    public static RubyArray entries(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyString path2 = Check.checkEmbeddedNulls(context, RubyFile.get_path(context, arg2));
        return RubyDir.entriesCommon(context, path2, context.runtime.getDefaultFilesystemEncoding(), false);
    }

    @JRubyMethod(name={"entries"}, meta=true)
    public static RubyArray entries(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject opts) {
        RubyString path2 = Check.checkEmbeddedNulls(context, RubyFile.get_path(context, arg2));
        Encoding encoding2 = RubyDir.getEncodingFromOpts(context, opts);
        return RubyDir.entriesCommon(context, path2, encoding2, false);
    }

    private static RubyArray entriesCommon(ThreadContext context, IRubyObject path2, Encoding encoding2, boolean childrenOnly) {
        Ruby runtime2 = context.runtime;
        String adjustedPath = RubyFile.getAdjustedPath(context, path2);
        RubyDir.checkDirIsTwoSlashesOnWindows(runtime2, adjustedPath);
        FileResource directory = JRubyFile.createResource(context, adjustedPath);
        String[] files = RubyDir.getEntries(context, directory, adjustedPath);
        return RubyDir.newEntryArray(context, files, encoding2, childrenOnly);
    }

    private static RubyArray newEntryArray(ThreadContext context, String[] files, Encoding encoding2, boolean childrenOnly) {
        RubyArray<?> result2 = Create.allocArray(context, files.length);
        for (String file2 : files) {
            int len;
            if (childrenOnly && ((len = file2.length()) == 1 && file2.charAt(0) == '.' || len == 2 && file2.charAt(0) == '.' && file2.charAt(1) == '.')) continue;
            result2.append(context, EncodingUtils.newExternalStringWithEncoding(context.runtime, file2, encoding2));
        }
        return result2;
    }

    private static String[] getEntries(ThreadContext context, FileResource dir, String path2) {
        if (!dir.isDirectory()) {
            if (dir.exists()) {
                throw context.runtime.newErrnoENOTDIRError(path2);
            }
            throw context.runtime.newErrnoENOENTError(path2);
        }
        if (!dir.canRead()) {
            throw context.runtime.newErrnoEACCESError(path2);
        }
        String[] list2 = dir.list();
        return list2 == null ? NO_FILES : list2;
    }

    private static void checkDirIsTwoSlashesOnWindows(Ruby runtime2, String path2) {
        if (Platform.IS_WINDOWS && ("//".equals(path2) || "\\\\".equals(path2))) {
            throw runtime2.newErrnoEINVALError("Invalid argument - " + path2);
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject chdir(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        return RubyDir.chdirCommon(context, block, Check.checkEmbeddedNulls(context, RubyFile.get_path(context, path2)), true);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject chdir(ThreadContext context, IRubyObject recv2, Block block) {
        RubyHash env = context.runtime.getENV();
        if (env.op_aref(context, Create.newString(context, "LOG_DIR")).isNil() && env.op_aref(context, Create.newString(context, "HOME")).isNil()) {
            throw Error.argumentError(context, "HOME/LOGDIR not set");
        }
        RubyString path2 = RubyDir.getHomeDirectoryPath(context);
        return RubyDir.chdirCommon(context, block, path2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject chdirCommon(ThreadContext context, Block block, RubyString path2, boolean yieldPath) {
        Ruby runtime2 = context.runtime;
        String adjustedPath = RubyFile.adjustRootPathOnWindows(runtime2, path2.asJavaString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(runtime2, adjustedPath);
        adjustedPath = RubyDir.getExistingDir(runtime2, adjustedPath).canonicalPath();
        if (runtime2.getChdirThread() != null && context.getThread() != runtime2.getChdirThread()) {
            throw Error.runtimeError(context, "conflicting chdir during another chdir block");
        }
        if (!block.isGiven() && runtime2.getChdirThread() != null) {
            RubyStackTraceElement location = runtime2.getChdirLocation();
            Warn.warn(context, "conflicting chdir during another chdir block\n" + location.getFileName() + ":" + location.getLineNumber() + ": note: previous chdir was here");
        }
        if (block.isGiven()) {
            runtime2.setChdirThread(context.getThread());
            String oldCwd = runtime2.getCurrentDirectory();
            runtime2.setCurrentDirectory(adjustedPath);
            try {
                IRubyObject iRubyObject = yieldPath ? block.yield(context, path2) : block.yieldSpecific(context);
                return iRubyObject;
            }
            finally {
                runtime2.setChdirThread(null);
                RubyDir.getExistingDir(runtime2, oldCwd);
                runtime2.setCurrentDirectory(oldCwd);
            }
        }
        runtime2.setCurrentDirectory(adjustedPath);
        return Convert.asFixnum(context, 0);
    }

    @JRubyMethod(name={"fchdir"}, meta=true, notImplemented=true)
    public static IRubyObject fchdir(ThreadContext context, IRubyObject dirClass, IRubyObject ignored) {
        throw Error.notImplementedError(context, "Dir.fchdir");
    }

    @JRubyMethod(name={"chdir"})
    public IRubyObject chdir(ThreadContext context, Block block) {
        return RubyDir.chdirCommon(context, block, Check.checkEmbeddedNulls(context, RubyFile.get_path(context, this.path)), false);
    }

    @Deprecated(since="10.0")
    public static IRubyObject chroot(IRubyObject recv2, IRubyObject path2) {
        return RubyDir.chroot(((RubyBasicObject)recv2).getCurrentContext(), recv2, path2);
    }

    @JRubyMethod(name={"chroot"}, meta=true, notImplemented=true)
    public static IRubyObject chroot(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        throw context.runtime.newNotImplementedError("chroot not implemented: chroot is non-portable and is not supported.");
    }

    @JRubyMethod(name={"children"})
    public RubyArray children(ThreadContext context) {
        return RubyDir.entriesCommon(context, this.path, this.encoding, true);
    }

    @JRubyMethod(name={"children"}, meta=true)
    public static RubyArray children(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyDir.children(context, recv2, arg2, context.nil);
    }

    @JRubyMethod(name={"children"}, meta=true)
    public static RubyArray children(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject opts) {
        RubyDir dir = (RubyDir)((RubyClass)recv2).newInstance(context, arg2, opts, Block.NULL_BLOCK);
        return dir.children(context);
    }

    @Deprecated(since="10.0")
    public static IRubyObject rmdir(IRubyObject recv2, IRubyObject path2) {
        return RubyDir.rmdir(recv2.getRuntime().getCurrentContext(), recv2, path2);
    }

    @Deprecated
    public static IRubyObject rmdir19(IRubyObject recv2, IRubyObject path2) {
        return RubyDir.rmdir(((RubyBasicObject)recv2).getCurrentContext(), recv2, path2);
    }

    @JRubyMethod(name={"rmdir", "unlink", "delete"}, meta=true)
    public static IRubyObject rmdir(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        return RubyDir.rmdirCommon(context, Check.checkEmbeddedNulls(context, RubyFile.get_path(context, path2)).asJavaString());
    }

    private static RubyFixnum rmdirCommon(ThreadContext context, String path2) {
        JRubyFile directory = RubyDir.getDirForRmdir(context.runtime, path2);
        if (context.runtime.getPosix().rmdir(directory.toString()) < 0) {
            throw context.runtime.newErrnoENOTEMPTYError(path2);
        }
        return Convert.asFixnum(context, 0);
    }

    @JRubyMethod(name={"each_child"}, meta=true)
    public static IRubyObject each_child(ThreadContext context, IRubyObject recv2, IRubyObject arg2, Block block) {
        return RubyDir.eachChildCommon(context, recv2, RubyFile.get_path(context, arg2), null, block);
    }

    @JRubyMethod(name={"each_child"}, meta=true)
    public static IRubyObject each_child(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject encOpts, Block block) {
        Encoding encoding2 = RubyDir.getEncodingFromOpts(context, encOpts);
        return RubyDir.eachChildCommon(context, recv2, RubyFile.get_path(context, arg2), encOpts, block);
    }

    @JRubyMethod(name={"foreach"}, meta=true)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        return RubyDir.foreachCommon(context, recv2, RubyFile.get_path(context, path2), null, block);
    }

    @JRubyMethod(name={"foreach"}, meta=true)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject encOpts, Block block) {
        return RubyDir.foreachCommon(context, recv2, RubyFile.get_path(context, path2), encOpts, block);
    }

    private static Encoding getEncodingFromOpts(ThreadContext context, IRubyObject encOpts) {
        Encoding encoding2 = null;
        if (!encOpts.isNil()) {
            IRubyObject opts = ArgsUtil.getOptionsArg(context, encOpts);
            if (opts.isNil()) {
                throw Error.argumentError(context, 2, 1, 1);
            }
            IRubyObject encodingArg = ArgsUtil.extractKeywordArg(context, (RubyHash)opts, "encoding");
            if (encodingArg != null && !encodingArg.isNil()) {
                encoding2 = Access.encodingService(context).getEncodingFromObject(encodingArg);
            }
        }
        if (encoding2 == null) {
            encoding2 = context.runtime.getDefaultEncoding();
        }
        return encoding2;
    }

    private static IRubyObject eachChildCommon(ThreadContext context, IRubyObject recv2, RubyString path2, IRubyObject encOpts, Block block) {
        if (block.isGiven()) {
            Encoding encoding2 = encOpts == null ? context.runtime.getDefaultEncoding() : RubyDir.getEncodingFromOpts(context, encOpts);
            RubyDir dir = (RubyDir)Access.dirClass(context).newInstance(context, path2, Block.NULL_BLOCK);
            dir.each_child(context, encoding2, block);
            return context.nil;
        }
        return encOpts == null ? RubyEnumerator.enumeratorize(context.runtime, recv2, "each_child", (IRubyObject)path2) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each_child", path2, encOpts);
    }

    private static IRubyObject foreachCommon(ThreadContext context, IRubyObject recv2, RubyString path2, IRubyObject encOpts, Block block) {
        if (block.isGiven()) {
            Encoding encoding2 = encOpts == null ? context.runtime.getDefaultEncoding() : RubyDir.getEncodingFromOpts(context, encOpts);
            RubyDir dir = (RubyDir)Access.dirClass(context).newInstance(context, path2, Block.NULL_BLOCK);
            dir.each(context, encoding2, block);
            return context.nil;
        }
        return encOpts == null ? RubyEnumerator.enumeratorize(context.runtime, recv2, "foreach", (IRubyObject)path2) : RubyEnumerator.enumeratorize(context.runtime, recv2, "foreach", path2, encOpts);
    }

    @Deprecated(since="10.0")
    public static RubyString getwd(IRubyObject recv2) {
        return RubyDir.getwd(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"getwd", "pwd"}, meta=true)
    public static RubyString getwd(ThreadContext context, IRubyObject recv2) {
        return RubyDir.newFilesystemString(context, RubyDir.getCWD(context.runtime));
    }

    @JRubyMethod(name={"home"}, meta=true)
    public static IRubyObject home(ThreadContext context, IRubyObject recv2) {
        return RubyDir.getHomeDirectoryPath(context);
    }

    @JRubyMethod(name={"home"}, meta=true)
    public static IRubyObject home(ThreadContext context, IRubyObject recv2, IRubyObject user) {
        if (user == null || user.isNil() || user.toString().isEmpty()) {
            return RubyDir.getHomeDirectoryPath(context);
        }
        RubyString userString = user.convertToString();
        userString.verifyAsciiCompatible();
        return RubyDir.getHomeDirectoryPath(context, userString.toString());
    }

    @JRubyMethod(name={"mkdir"}, required=1, optional=1, checkArity=false, meta=true)
    public static IRubyObject mkdir(ThreadContext context, IRubyObject recv2, IRubyObject ... args2) {
        Arity.checkArgumentCount(context, args2, 1, 2);
        return RubyDir.mkdirCommon(context, RubyFile.get_path(context, args2[0]).asJavaString(), args2);
    }

    @Deprecated
    public static IRubyObject mkdir(IRubyObject recv2, IRubyObject[] args2) {
        return RubyDir.mkdir(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    private static IRubyObject mkdirCommon(ThreadContext context, String path2, IRubyObject[] args2) {
        int mode2;
        if (path2.startsWith("uri:")) {
            throw context.runtime.newErrnoEACCESError(path2);
        }
        FileResource res = JRubyFile.createResource(context.runtime, path2 = RubyDir.dirFromPath(path2, context.runtime));
        if (res.exists()) {
            throw context.runtime.newErrnoEEXISTError(path2);
        }
        String name2 = path2.replace('\\', '/');
        boolean startsWithDriveLetterOnWindows = RubyFile.startsWithDriveLetterOnWindows(name2);
        if (startsWithDriveLetterOnWindows) {
            if (path2.length() == 2) {
                return Convert.asFixnum(context, 0);
            }
            if (path2.length() == 3 && (path2.charAt(0) == '/' || path2.charAt(2) == '/')) {
                return Convert.asFixnum(context, 0);
            }
            if (path2.length() == 4 && path2.charAt(0) == '/' && path2.charAt(3) == '/') {
                return Convert.asFixnum(context, 0);
            }
        }
        File newDir = res.unwrap(File.class);
        if (File.separatorChar == '\\') {
            newDir = new File(newDir.getPath());
        }
        int n = mode2 = args2.length == 2 ? Convert.toInt(context, args2[1]) : 511;
        if (context.runtime.getPosix().mkdir(newDir.getAbsolutePath(), mode2) < 0) {
            throw context.runtime.newSystemCallError("mkdir failed");
        }
        return Convert.asFixnum(context, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        RubyDir directory = (RubyDir)Access.dirClass(context).newInstance(context, path2, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return directory;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, directory);
            return iRubyObject;
        }
        finally {
            directory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject encOpts, Block block) {
        RubyDir directory = (RubyDir)Access.dirClass(context).newInstance(context, path2, encOpts, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return directory;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, directory);
            return iRubyObject;
        }
        finally {
            directory.close();
        }
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close(ThreadContext context) {
        this.checkDirIgnoreClosed(context);
        this.isOpen = false;
        return context.nil;
    }

    @Override
    @Deprecated(since="10.0")
    public final void close() {
        this.close(this.getCurrentContext());
    }

    public IRubyObject each(ThreadContext context, Encoding enc, Block block) {
        this.checkDir(context);
        String[] contents = this.snapshot;
        this.pos = 0;
        while (this.pos < contents.length) {
            block.yield(context, RubyString.newString(context.runtime, contents[this.pos], enc));
            ++this.pos;
        }
        return this;
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext context, Block block) {
        return block.isGiven() ? this.each(context, this.encoding, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each");
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext context, IRubyObject encOpts, Block block) {
        Encoding encoding2 = RubyDir.getEncodingFromOpts(context, encOpts);
        return block.isGiven() ? this.each(context, encoding2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", encOpts);
    }

    public IRubyObject each_child(ThreadContext context, Encoding enc, Block block) {
        this.checkDir(context);
        String[] contents = this.snapshot;
        this.pos = 0;
        while (this.pos < contents.length) {
            if (!StringSupport.contentEquals(contents[this.pos], 46) && !StringSupport.contentEquals(contents[this.pos], 46, 46)) {
                block.yield(context, RubyString.newString(context.runtime, contents[this.pos], enc));
            }
            ++this.pos;
        }
        return this;
    }

    public IRubyObject each_child(ThreadContext context, Block block) {
        return this.each_child(context, this.encoding, block);
    }

    @JRubyMethod(name={"each_child"})
    public IRubyObject rb_each_child(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_child(context, block) : RubyEnumerator.enumeratorize(context.runtime, this.children(context), "each");
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        StringBuilder part = new StringBuilder();
        String cname = this.getMetaClass().getRealClass().getName(context);
        part.append("#<").append(cname).append(':');
        if (this.path != null) {
            part.append(this.path.asJavaString());
        }
        part.append('>');
        return Create.newString(context, part.toString());
    }

    @JRubyMethod(name={"tell", "pos"})
    public RubyInteger tell(ThreadContext context) {
        this.checkDir(context);
        return Convert.asFixnum(context, this.pos);
    }

    @Deprecated
    public RubyInteger tell() {
        return this.tell(this.getCurrentContext());
    }

    @Deprecated(since="10.0")
    public IRubyObject seek(IRubyObject newPos) {
        return this.seek(this.getCurrentContext(), newPos);
    }

    @JRubyMethod(name={"seek"})
    public IRubyObject seek(ThreadContext context, IRubyObject newPos) {
        this.checkDir(context);
        this.set_pos(context, newPos);
        return this;
    }

    @Deprecated(since="10.0")
    public IRubyObject set_pos(IRubyObject newPos) {
        return this.set_pos(this.getCurrentContext(), newPos);
    }

    @JRubyMethod(name={"pos="})
    public IRubyObject set_pos(ThreadContext context, IRubyObject newPos) {
        int pos2 = Convert.toInt(context, newPos);
        if (pos2 >= 0) {
            this.pos = pos2;
        }
        return newPos;
    }

    @JRubyMethod(name={"path", "to_path"})
    public IRubyObject path(ThreadContext context) {
        return this.path == null ? context.nil : this.path.strDup(context.runtime);
    }

    @JRubyMethod
    public IRubyObject to_path(ThreadContext context) {
        return this.path(context);
    }

    public String getPath() {
        return this.path == null ? null : this.path.asJavaString();
    }

    @Deprecated(since="10.0")
    public IRubyObject read() {
        return this.read(this.getCurrentContext());
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context) {
        this.checkDir(context);
        String[] snapshot = this.snapshot;
        if (this.pos >= snapshot.length) {
            return context.nil;
        }
        RubyString result2 = EncodingUtils.newExternalStringWithEncoding(context.runtime, snapshot[this.pos], this.encoding);
        ++this.pos;
        return result2;
    }

    @Deprecated(since="10.0")
    public IRubyObject rewind() {
        return this.rewind(this.getCurrentContext());
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind(ThreadContext context) {
        this.checkDir(context);
        this.pos = 0;
        return this;
    }

    @JRubyMethod(name={"empty?"}, meta=true)
    public static IRubyObject empty_p(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        RubyFileStat fileStat = context.runtime.newFileStat(RubyFile.get_path(context, path2).asJavaString(), false);
        boolean isDirectory = fileStat.directory_p(context).isTrue();
        return Convert.asBoolean(context, isDirectory && RubyDir.entries(context, recv2, path2).getLength() <= 2);
    }

    @JRubyMethod(name={"exist?"}, meta=true)
    public static IRubyObject exist(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        IRubyObject exception2 = context.getErrorInfo();
        RubyString path2 = RubyFile.get_path(context, arg2);
        try {
            return context.runtime.newFileStat(path2.asJavaString(), false).directory_p(context);
        }
        catch (Exception e) {
            context.setErrorInfo(exception2);
            return context.fals;
        }
    }

    @Deprecated(since="10.0")
    public static IRubyObject exists_p(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        if (context.runtime.warningsEnabled()) {
            context.runtime.getWarnings().warnDeprecatedAlternate("Dir.exists?", "Dir.exist?");
        }
        return RubyDir.exist(context, recv2, arg2);
    }

    @JRubyMethod(name={"fileno"}, notImplemented=true)
    public IRubyObject fileno(ThreadContext context) {
        throw context.runtime.newNotImplementedError("Dir#fileno");
    }

    @JRubyMethod(name={"for_fd"}, meta=true, notImplemented=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject recv2, IRubyObject ignored) {
        throw context.runtime.newNotImplementedError("Dir#for_fd");
    }

    protected static FileResource getDir(Ruby runtime2, String path2, boolean mustExist) {
        String dir = RubyDir.dirFromPath(path2, runtime2);
        FileResource result2 = JRubyFile.createResource(runtime2, dir);
        if (mustExist && (result2 == null || !result2.exists())) {
            throw runtime2.newErrnoENOENTError(dir);
        }
        boolean isDirectory = result2.isDirectory();
        if (mustExist && !isDirectory) {
            throw runtime2.newErrnoENOTDIRError(path2);
        }
        if (!mustExist && isDirectory) {
            throw runtime2.newErrnoEEXISTError(dir);
        }
        return result2;
    }

    private static FileResource getExistingDir(Ruby runtime2, String path2) {
        FileResource result2 = JRubyFile.createResource(runtime2, path2);
        if (result2 == null || !result2.exists()) {
            throw runtime2.newErrnoENOENTError(path2);
        }
        if (!result2.isDirectory()) {
            throw runtime2.newErrnoENOTDIRError(path2);
        }
        return result2;
    }

    protected static JRubyFile getDirForRmdir(Ruby runtime2, String path2) {
        String dir = RubyDir.dirFromPath(path2, runtime2);
        JRubyFile directory = JRubyFile.create(runtime2.getCurrentDirectory(), dir);
        File parentFile = directory.getParentFile();
        if (parentFile.exists() && !parentFile.canWrite()) {
            throw runtime2.newErrnoEACCESError(path2);
        }
        FileStat stat2 = runtime2.getPosix().stat(directory.toString());
        if (!stat2.isDirectory()) {
            throw runtime2.newErrnoENOTDIRError(path2);
        }
        return directory;
    }

    private static String dirFromPath(String path2, Ruby runtime2) throws RaiseException {
        String dir = path2;
        String[] pathParts = RubyFile.splitURI(path2);
        if (pathParts != null) {
            if (pathParts[0].startsWith("file:") && pathParts[1].length() > 0 && pathParts[1].indexOf(".jar!/") == -1) {
                dir = pathParts[1];
            } else {
                throw runtime2.newErrnoENOTDIRError(dir);
            }
        }
        return dir;
    }

    private static String[] list(FileResource directory) {
        String[] contents = directory.list();
        return contents == null ? NO_FILES : contents;
    }

    @Deprecated(since="9.4-")
    protected static List<String> getContents(FileResource directory) {
        String[] contents = directory.list();
        return contents != null ? Arrays.asList(contents) : Collections.emptyList();
    }

    @Deprecated(since="9.4-")
    protected static List<RubyString> getContents(FileResource directory, Ruby runtime2) {
        String[] contents = directory.list();
        if (contents == null) {
            return Collections.emptyList();
        }
        ArrayList<RubyString> result2 = new ArrayList<RubyString>(contents.length);
        for (int i2 = 0; i2 < contents.length; ++i2) {
            result2.add(runtime2.newString(contents[i2]));
        }
        return result2;
    }

    public static IRubyObject getHomeDirectoryPath(ThreadContext context, String user) {
        Object passwd22;
        POSIX posix = context.runtime.getNativePosix();
        if (posix != null) {
            try {
                passwd22 = context.runtime.getPosix().getpwnam(user);
                if (passwd22 != null) {
                    return RubyDir.newFilesystemString(context, passwd22.getHome());
                }
            }
            catch (Exception passwd22) {
                // empty catch block
            }
        }
        if (Platform.IS_WINDOWS) {
            if (user.equals(posix.getlogin())) {
                return RubyDir.getHomeDirectoryPath(context);
            }
        } else {
            try {
                FileInputStream stream = new FileInputStream("/etc/passwd");
                int readBytes = stream.available();
                byte[] bytes2 = new byte[readBytes];
                readBytes = stream.read(bytes2);
                stream.close();
                passwd22 = new String(bytes2, 0, readBytes);
            }
            catch (IOException ioe) {
                return context.nil;
            }
            List<String> rows = StringSupport.split((String)passwd22, '\n');
            for (int i2 = 0; i2 < rows.size(); ++i2) {
                List<String> fields2 = StringSupport.split(rows.get(i2), ':');
                if (!fields2.get(0).equals(user)) continue;
                String home2 = fields2.get(5);
                return RubyDir.newFilesystemString(context, home2);
            }
        }
        throw Error.argumentError(context, "user " + user + " doesn't exist");
    }

    private static RubyString newFilesystemString(ThreadContext context, String home2) {
        return EncodingUtils.newExternalStringWithEncoding(context.runtime, home2, context.runtime.getDefaultFilesystemEncoding());
    }

    public static RubyString getHomeDirectoryPath(ThreadContext context) {
        RubyString homeKey = Create.newSharedString(context, HOME);
        IRubyObject home2 = context.runtime.getENV().op_aref(context, homeKey);
        return RubyDir.getHomeDirectoryPath(context, home2);
    }

    public static Optional<String> getHomeFromEnv(Ruby runtime2) {
        RubyString homeKey = Create.newSharedString(runtime2.getCurrentContext(), HOME);
        RubyHash env = runtime2.getENV();
        return !env.hasKey(homeKey) ? Optional.empty() : Optional.of(env.op_aref(runtime2.getCurrentContext(), homeKey).toString());
    }

    static RubyString getHomeDirectoryPath(ThreadContext context, IRubyObject home2) {
        RubyHash env = context.runtime.getENV();
        if (home2 == null || home2 == context.nil) {
            IRubyObject ENV_JAVA = Access.objectClass(context).getConstant(context, "ENV_JAVA");
            home2 = ENV_JAVA.callMethod(context, "[]", Create.newString(context, user_home, (Encoding)RubyString.UTF8));
        }
        if (home2 == null || home2 == context.nil) {
            home2 = env.op_aref(context, Create.newString(context, "LOGDIR"));
        }
        if (home2 == null || home2 == context.nil) {
            throw Error.argumentError(context, "user.home/LOGDIR not set");
        }
        return (RubyString)home2.dup();
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2 == File.class) {
            String path2 = this.getPath();
            return (T)(path2 == null ? null : new File(path2));
        }
        if (target2 == Path.class || target2 == Watchable.class) {
            String path3 = this.getPath();
            return (T)(path3 == null ? null : FileSystems.getDefault().getPath(path3, new String[0]));
        }
        return super.toJava(target2);
    }

    @Deprecated
    public static IRubyObject home(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length > 0 && args2[0] != context.nil) {
            return RubyDir.getHomeDirectoryPath(context, args2[0].toString());
        }
        return RubyDir.getHomeDirectoryPath(context);
    }

    @Deprecated
    public static RubyArray entries(IRubyObject recv2, IRubyObject path2) {
        return RubyDir.entries(((RubyBasicObject)recv2).getCurrentContext(), recv2, path2);
    }

    @Deprecated
    public static RubyArray entries(IRubyObject recv2, IRubyObject path2, IRubyObject arg2, IRubyObject opts) {
        return RubyDir.entries(((RubyBasicObject)recv2).getCurrentContext(), recv2, path2, opts);
    }

    @Deprecated
    public static IRubyObject chdir(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return switch (args2.length) {
            case 0 -> RubyDir.chdir(context, recv2, block);
            case 1 -> RubyDir.chdir(context, recv2, args2[0], block);
            default -> throw Error.argumentError(context, args2.length, 0, 1);
        };
    }

    private static class GlobOptions {
        String base = null;
        int flags = 0;
        boolean sort = true;

        private GlobOptions() {
        }
    }
}

