/*******************************************************
 * Copyright (c) 2014, ArrayFire
 * All rights reserved.
 *
 * This file is distributed under 3-clause BSD license.
 * The complete license agreement can be obtained at:
 * http://arrayfire.com/licenses/BSD-3-Clause
 ********************************************************/

#pragma once

/**

\defgroup c_api_functions C API functions
Categorically divided into groups based on the renderable
they are related to.

\addtogroup c_api_functions
@{
    \defgroup chart_functions Chart
    \defgroup font_functions Font
    \defgroup hist_functions Histogram
    \defgroup image_functions Image
    \defgroup plot_functions Plot
    \defgroup surf_functions Surface
    \defgroup util_functions Utility & Helper Functions
    \defgroup vfield_functions Vector Field
    \defgroup win_functions Window

@}

*/

#include "fg/defines.h"
#include "fg/update_buffer.h"
#include "fg/exception.h"
#include "fg/window.h"
#include "fg/font.h"
#include "fg/image.h"
#include "fg/version.h"
#include "fg/plot.h"
#include "fg/surface.h"
#include "fg/histogram.h"
