/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.ScannerParamFilter;
import org.parosproxy.paros.core.scanner.Util;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.core.scanner.InputVector;
import org.zaproxy.zap.core.scanner.InputVectorBuilder;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.extension.ascan.VariantFactory;

public abstract class AbstractAppParamPlugin
extends AbstractAppPlugin {
    private List<Variant> listVariant;
    private NameValuePair originalPair = null;
    private Variant variant = null;
    private ExtensionAntiCSRF extensionAntiCsrf;

    VariantFactory getVariantFactory() {
        return Model.getSingleton().getVariantFactory();
    }

    @Override
    public void scan() {
        this.listVariant = this.getVariantFactory().createVariants(this.getParent().getScannerParam(), this.getBaseMsg());
        if (this.listVariant.isEmpty()) {
            this.getParent().pluginSkipped(this, Constant.messages.getString("ascan.progress.label.skipped.reason.noinputvectors"));
            return;
        }
        for (int i = 0; i < this.listVariant.size() && !this.isStop(); ++i) {
            HttpMessage msg = this.getNewMsg();
            this.variant = this.listVariant.get(i);
            try {
                this.variant.setMessage(msg);
                this.scan(this.variant.getParamList());
            }
            catch (Exception e) {
                this.getLogger().error("Error occurred while scanning with variant {}", (Object)this.variant.getClass().getCanonicalName(), (Object)e);
            }
            while (this.getParent().isPaused() && !this.isStop()) {
                Util.sleep(500);
            }
        }
    }

    protected void scan(List<NameValuePair> nameValuePairs) {
        for (int i = 0; i < nameValuePairs.size() && !this.isStop(); ++i) {
            this.originalPair = nameValuePairs.get(i);
            if (this.isToExclude(this.originalPair)) continue;
            HttpMessage msg = this.getNewMsg();
            try {
                this.scan(msg, this.originalPair);
                continue;
            }
            catch (Exception e) {
                this.getLogger().error("Error occurred while scanning a message:", (Throwable)e);
            }
        }
    }

    @Override
    protected void decodeResponseBody(HttpMessage message) {
        if (this.variant == null) {
            return;
        }
        this.variant.decodeResponseBody(message);
    }

    private boolean isToExclude(NameValuePair param) {
        if (param.getType() == 2 && this.getParent().getScannerParam().isExcludeAntiCsrfTokens()) {
            if (this.extensionAntiCsrf == null) {
                this.extensionAntiCsrf = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAntiCSRF.class);
            }
            if (this.extensionAntiCsrf != null && this.extensionAntiCsrf.isAntiCsrfToken(param.getName())) {
                return true;
            }
        }
        List<ScannerParamFilter> excludedParameters = this.getParameterExclusionFilters(param);
        HttpMessage msg = this.getBaseMsg();
        for (ScannerParamFilter filter : excludedParameters) {
            if (!filter.isToExclude(msg, param)) continue;
            return true;
        }
        return false;
    }

    private List<ScannerParamFilter> getParameterExclusionFilters(NameValuePair parameter) {
        List<ScannerParamFilter> globalExclusionFilters = this.getParent().getScannerParam().getExcludedParamList(-1);
        List<ScannerParamFilter> exclusionFilters = this.getParent().getScannerParam().getExcludedParamList(parameter.getType());
        if (globalExclusionFilters == null) {
            if (exclusionFilters != null) {
                return exclusionFilters;
            }
            return Collections.emptyList();
        }
        if (exclusionFilters == null) {
            return globalExclusionFilters;
        }
        ArrayList<ScannerParamFilter> allFilters = new ArrayList<ScannerParamFilter>(globalExclusionFilters.size() + exclusionFilters.size());
        allFilters.addAll(globalExclusionFilters);
        allFilters.addAll(exclusionFilters);
        return allFilters;
    }

    public void scan(HttpMessage msg, String param, String value) {
    }

    public void scan(HttpMessage msg, NameValuePair originalParam) {
        this.scan(msg, originalParam.getName(), originalParam.getValue());
    }

    protected String setParameter(HttpMessage message, String param, String value) {
        return this.variant.setParameter(message, this.originalPair, param, value);
    }

    protected String setEscapedParameter(HttpMessage message, String param, String value) {
        return this.variant.setEscapedParameter(message, this.originalPair, param, value);
    }

    protected InputVectorBuilder getBuilder() {
        return new InputVectorBuilder();
    }

    protected void setParameters(HttpMessage message, List<InputVector> inputVectors) {
        this.variant.setParameters(message, inputVectors);
    }

    @Override
    protected AbstractPlugin.AlertBuilder newAlert() {
        AbstractPlugin.AlertBuilder builder = super.newAlert();
        if (this.variant != null) {
            builder.setInputVector(this.variant.getShortName());
        }
        if (this.originalPair != null) {
            builder.setParam(this.originalPair.getName());
        }
        return builder;
    }
}

