/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.template;

import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.command.template.BaseTemplateRenderer;
import schemacrawler.tools.options.OutputOptions;

public final class VelocityRenderer
extends BaseTemplateRenderer {
    private static void setVelocityResourceLoaderProperty(Properties p, String resourceLoaderName, String resourceLoaderPropertyName, String resourceLoaderPropertyValue) {
        p.setProperty(resourceLoaderName + ".resource.loader." + resourceLoaderPropertyName, resourceLoaderPropertyValue);
    }

    @Override
    public void execute() {
        Path templateFileParentPath;
        OutputOptions outputOptions = this.getOutputOptions();
        String templateLocation = this.getResourceFilename();
        Object templatePath = ".";
        Path templateFilePath = Path.of(templateLocation, new String[0]);
        if (Files.exists(templateFilePath, new LinkOption[0]) && (templateFileParentPath = templateFilePath.normalize().getParent()) != null) {
            templatePath = (String)templatePath + "," + String.valueOf(templateFileParentPath.toAbsolutePath());
            templateLocation = templateFilePath.getFileName().toString();
        }
        try {
            VelocityEngine ve = new VelocityEngine();
            String fileResourceLoader = "file";
            String classpathResourceLoader = "classpath";
            Properties p = new Properties();
            p.setProperty("resource.loader", "file,classpath");
            VelocityRenderer.setVelocityResourceLoaderProperty(p, "classpath", "class", ClasspathResourceLoader.class.getName());
            VelocityRenderer.setVelocityResourceLoaderProperty(p, "file", "class", FileResourceLoader.class.getName());
            VelocityRenderer.setVelocityResourceLoaderProperty(p, "file", "path", (String)templatePath);
            ve.init(p);
            VelocityContext context = new VelocityContext(this.getContext());
            try (PrintWriter writer = outputOptions.openNewOutputWriter();){
                String templateEncoding = outputOptions.getInputCharset().name();
                Template template = ve.getTemplate(templateLocation, templateEncoding);
                template.merge((Context)context, (Writer)writer);
            }
            catch (ResourceNotFoundException e) {
                throw new ConfigurationException("Apache Velocity template not found", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException("Exception rendering Apache Velocity template", (Throwable)e);
        }
    }
}

