/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.io.AbstractBufferedIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedRandomBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.BufferedRandomBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.io.IOBaseBuiltins;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBufferedRandom})
public final class BufferedRandomBuiltins
extends AbstractBufferedIOBuiltins {
    public static final TpSlots SLOTS = BufferedRandomBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BufferedRandomBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="BufferedRandom", minNumOfPositionalArgs=2, parameterNames={"self", "raw", "buffer_size"})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonBuiltinNode {
        @Specialization
        static Object doIt(VirtualFrame frame, PBuffered self, Object raw, Object bufferSize, @Bind Node inliningTarget, @Cached AbstractBufferedIOBuiltins.InitBufferSizeNode initBufferSizeNode, @Cached BufferedRandomInit init) {
            int size = initBufferSizeNode.execute(frame, inliningTarget, bufferSize);
            init.execute(frame, inliningTarget, self, raw, size);
            return PNone.NONE;
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class BufferedRandomInit
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, PBuffered var3, Object var4, int var5);

        @Specialization
        static void doInit(VirtualFrame frame, Node inliningTarget, PBuffered self, Object raw, int bufferSize, @Cached IOBaseBuiltins.CheckBoolMethodHelperNode checkSeekableNode, @Cached IOBaseBuiltins.CheckBoolMethodHelperNode checkReadableNode, @Cached IOBaseBuiltins.CheckBoolMethodHelperNode checkWritableNode, @Cached AbstractBufferedIOBuiltins.BufferedInitNode bufferedInitNode, @Cached GetClassNode.GetPythonObjectClassNode getSelfClass, @Cached GetClassNode getRawClass) {
            self.setOK(false);
            self.setDetached(false);
            checkSeekableNode.checkSeekable(frame, inliningTarget, raw);
            checkReadableNode.checkReadable(frame, inliningTarget, raw);
            checkWritableNode.checkWriteable(frame, inliningTarget, raw);
            self.setRaw(raw, AbstractBufferedIOBuiltins.isFileIO(self, raw, PythonBuiltinClassType.PBufferedRandom, inliningTarget, getSelfClass, getRawClass));
            bufferedInitNode.execute(frame, inliningTarget, self, bufferSize);
            self.resetRead();
            self.resetWrite();
            self.setPos(0);
            self.setOK(true);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="BufferedRandom", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class BufferedRandomNode
    extends PythonBuiltinNode {
        @Specialization
        static PBuffered doNew(Object cls, Object arg, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createBufferedRandom(language, cls, getInstanceShape.execute(cls));
        }
    }
}

