/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

public abstract class SequenceStorage {
    protected int length;
    protected int capacity;

    protected SequenceStorage() {
    }

    protected SequenceStorage(int length, int capacity) {
        this.length = length;
        this.capacity = capacity;
    }

    public void setNewLength(int length) {
        this.length = length;
    }

    public final void incLength() {
        ++this.length;
    }

    public final int length() {
        return this.length;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public abstract StorageType getElementType();

    public abstract Object getIndicativeValue();

    public static enum StorageType {
        Uninitialized,
        Empty,
        Boolean,
        Byte,
        Int,
        Long,
        Double,
        Generic;


        public boolean generalizesFrom(StorageType other) {
            return switch (this.ordinal()) {
                case 0, 1 -> false;
                case 2, 3, 4, 6 -> {
                    if (other == Uninitialized || other == Empty || other == Byte) {
                        yield true;
                    }
                    yield false;
                }
                case 5 -> {
                    if (other == Uninitialized || other == Empty || other == Byte || other == Int) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
        }
    }
}

