/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.codecs;

import com.oracle.graal.python.builtins.modules.codecs.ErrorHandlersFactory;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

public final class CodecsRegistry {
    public static void ensureRegistryInitialized(PythonContext context) {
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (!context.isCodecsInitialized() ? 1 : 0) != 0)) {
            CodecsRegistry.doInitialize(context);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void doInitialize(PythonContext context) {
        CodecsRegistry.registerDefaultHandler(context, StringLiterals.T_STRICT, ErrorHandlersFactory.StrictErrorHandlerNodeFactory.getInstance());
        CodecsRegistry.registerDefaultHandler(context, StringLiterals.T_IGNORE, ErrorHandlersFactory.IgnoreErrorHandlerNodeFactory.getInstance());
        CodecsRegistry.registerDefaultHandler(context, StringLiterals.T_REPLACE, ErrorHandlersFactory.ReplaceErrorHandlerNodeFactory.getInstance());
        CodecsRegistry.registerDefaultHandler(context, StringLiterals.T_XMLCHARREFREPLACE, ErrorHandlersFactory.XmlCharRefReplaceErrorHandlerNodeFactory.getInstance());
        CodecsRegistry.registerDefaultHandler(context, StringLiterals.T_BACKSLASHREPLACE, ErrorHandlersFactory.BackslashReplaceErrorHandlerNodeFactory.getInstance());
        CodecsRegistry.registerDefaultHandler(context, StringLiterals.T_NAMEREPLACE, ErrorHandlersFactory.NameReplaceErrorHandlerNodeFactory.getInstance());
        CodecsRegistry.registerDefaultHandler(context, StringLiterals.T_SURROGATEPASS, ErrorHandlersFactory.SurrogatePassErrorHandlerNodeFactory.getInstance());
        CodecsRegistry.registerDefaultHandler(context, StringLiterals.T_SURROGATEESCAPE, ErrorHandlersFactory.SurrogateEscapeErrorHandlerNodeFactory.getInstance());
        AbstractImportNode.importModule(BuiltinNames.T_ENCODINGS);
        context.markCodecsInitialized();
    }

    @CompilerDirectives.TruffleBoundary
    private static void registerDefaultHandler(PythonContext context, TruffleString name, NodeFactory<? extends PythonBuiltinBaseNode> nodeFactory) {
        PBuiltinFunction f = PythonUtils.createMethod(context.getLanguage(), null, nodeFactory, null, 0);
        CodecsRegistry.putErrorHandler(context, name, f);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object getErrorHandler(PythonContext ctx, TruffleString name) {
        return ctx.getCodecErrorRegistry().get(name);
    }

    @CompilerDirectives.TruffleBoundary
    private static void putErrorHandler(PythonContext ctx, TruffleString name, Object handler) {
        ctx.getCodecErrorRegistry().put(name, handler);
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PyCodecRegisterErrorNode
    extends Node {
        public abstract void execute(Node var1, TruffleString var2, Object var3);

        @Specialization(guards={"callableCheckNode.execute(inliningTarget, handler)"})
        static void register(Node inliningTarget, TruffleString name, Object handler, @Cached @Cached.Shared(value="callableCheck") PyCallableCheckNode callableCheckNode) {
            PythonContext context = PythonContext.get(inliningTarget);
            CodecsRegistry.ensureRegistryInitialized(context);
            CodecsRegistry.putErrorHandler(context, name, handler);
        }

        @Specialization(guards={"!callableCheckNode.execute(inliningTarget, handler)"})
        static void registerNoCallable(Node inliningTarget, TruffleString name, Object handler, @Cached @Cached.Shared(value="callableCheck") PyCallableCheckNode callableCheckNode) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.HANDLER_MUST_BE_CALLABLE);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PyCodecLookupErrorNode
    extends Node {
        public abstract Object execute(Node var1, TruffleString var2);

        @Specialization
        static Object lookup(Node inliningTarget, TruffleString name, @Cached InlinedConditionProfile resultProfile, @Cached PRaiseNode raiseNode) {
            Object result;
            PythonContext context = PythonContext.get(inliningTarget);
            CodecsRegistry.ensureRegistryInitialized(context);
            if (name == null) {
                name = StringLiterals.T_STRICT;
            }
            if (resultProfile.profile(inliningTarget, (result = CodecsRegistry.getErrorHandler(context, name)) == null)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.LookupError, ErrorMessages.UNKNOWN_ERROR_HANDLER, name);
            }
            return result;
        }
    }
}

