/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNodeGen;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.bytecode.ContinuationRootNode;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.util.Objects;

@GenerateInline(value=false)
public final class ReadCallerFrameNode
extends Node {
    @CompilerDirectives.CompilationFinal
    private ConditionProfile cachedCallerFrameProfile;
    @Node.Child
    private MaterializeFrameNode materializeNode;

    protected ReadCallerFrameNode() {
    }

    @NeverDefault
    public static ReadCallerFrameNode create() {
        return new ReadCallerFrameNode();
    }

    public PFrame executeWith(VirtualFrame frame, int level) {
        return this.executeWith(PArguments.getCurrentFrameInfo((Frame)frame), (FrameSelector)SkipPythonInternalFramesSelector.INSTANCE, level);
    }

    public PFrame executeWith(VirtualFrame frame, FrameSelector selector, int level) {
        return this.executeWith(PArguments.getCurrentFrameInfo((Frame)frame), selector, level);
    }

    public PFrame executeWith(Frame startFrame, int level) {
        return this.executeWith(PArguments.getCurrentFrameInfo(startFrame), (FrameSelector)SkipPythonInternalFramesSelector.INSTANCE, level);
    }

    public PFrame executeWith(PFrame.Reference startFrameInfo, int level) {
        return this.executeWith(startFrameInfo, (FrameSelector)SkipPythonInternalFramesSelector.INSTANCE, level);
    }

    public PFrame executeWith(PFrame.Reference startFrameInfo, FrameInstance.FrameAccess frameAccess, int level) {
        return this.executeWith(startFrameInfo, frameAccess, SkipPythonInternalFramesSelector.INSTANCE, level);
    }

    public PFrame executeWith(PFrame.Reference startFrameInfo, FrameSelector selector, int level) {
        return this.executeWith(startFrameInfo, FrameInstance.FrameAccess.READ_ONLY, selector, level);
    }

    public PFrame executeWith(PFrame.Reference startFrameInfo, FrameInstance.FrameAccess frameAccess, FrameSelector selector, int level) {
        PFrame.Reference curFrameInfo = startFrameInfo;
        if (this.cachedCallerFrameProfile == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.cachedCallerFrameProfile = ConditionProfile.create();
            int i = 0;
            while (i <= level) {
                PFrame.Reference callerInfo = curFrameInfo.getCallerInfo();
                if (callerInfo == null) {
                    return this.getMaterializedCallerFrame(startFrameInfo, frameAccess, selector, level);
                }
                if (!selector.skip(callerInfo.getRootNode())) {
                    ++i;
                }
                curFrameInfo = callerInfo;
            }
            return curFrameInfo.getPyFrame();
        }
        return this.walkLevels(curFrameInfo, frameAccess, selector, level);
    }

    private PFrame getMaterializedCallerFrame(PFrame.Reference startFrameInfo, FrameInstance.FrameAccess frameAccess, FrameSelector selector, int level) {
        StackWalkResult callerFrameResult = ReadCallerFrameNode.getCallerFrame(startFrameInfo, frameAccess, selector, level);
        if (callerFrameResult != null) {
            PRootNode location = callerFrameResult.rootNode;
            if (location instanceof PBytecodeDSLRootNode) {
                PBytecodeDSLRootNode rootNode = (PBytecodeDSLRootNode)location;
                location = rootNode.getBytecodeNode();
            }
            return this.ensureMaterializeNode().execute((Node)location, false, true, callerFrameResult.frame);
        }
        return null;
    }

    private PFrame walkLevels(PFrame.Reference startFrameInfo, FrameInstance.FrameAccess frameAccess, FrameSelector selector, int level) {
        PFrame.Reference currentFrame = startFrameInfo;
        int i = 0;
        while (i <= level) {
            PFrame.Reference callerInfo = currentFrame.getCallerInfo();
            if (this.cachedCallerFrameProfile.profile(callerInfo == null || callerInfo.getPyFrame() == null)) {
                return this.getMaterializedCallerFrame(startFrameInfo, frameAccess, selector, level);
            }
            if (!selector.skip(callerInfo.getRootNode())) {
                ++i;
            }
            currentFrame = callerInfo;
        }
        return currentFrame.getPyFrame();
    }

    public static Frame getCurrentFrame(Node requestingNode, FrameInstance.FrameAccess frameAccess) {
        StackWalkResult result = ReadCallerFrameNode.getFrame(Objects.requireNonNull(requestingNode), null, frameAccess, AllFramesSelector.INSTANCE, 0);
        if (result != null) {
            return result.frame;
        }
        return null;
    }

    public static StackWalkResult getCallerFrame(PFrame.Reference startFrame, FrameInstance.FrameAccess frameAccess, FrameSelector selector, int level) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return ReadCallerFrameNode.getFrame(null, Objects.requireNonNull(startFrame), frameAccess, selector, level);
    }

    @CompilerDirectives.TruffleBoundary
    private static StackWalkResult getFrame(final Node requestingNode, final PFrame.Reference startFrame, final FrameInstance.FrameAccess frameAccess, final FrameSelector selector, final int level) {
        final StackWalkResult[] result = new StackWalkResult[1];
        Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Object>(){
            int i = -1;

            public StackWalkResult visitFrame(FrameInstance frameInstance) {
                PRootNode pRootNode;
                RootNode rootNode = ReadCallerFrameNode.getRootNode(frameInstance);
                Node callNode = frameInstance.getCallNode();
                boolean didMark = IndirectCallData.setEncapsulatingNeedsToPassCallerFrame(callNode != null ? callNode : requestingNode);
                if (rootNode instanceof PRootNode && (pRootNode = (PRootNode)rootNode).setsUpCalleeContext()) {
                    if (result[0] != null) {
                        return result[0];
                    }
                    boolean needsCallerFrame = true;
                    if (this.i < 0 && startFrame != null) {
                        Frame roFrame = ReadCallerFrameNode.getFrame(frameInstance, FrameInstance.FrameAccess.READ_ONLY);
                        if (PArguments.getCurrentFrameInfo(roFrame) == startFrame) {
                            this.i = 0;
                        }
                    } else if (!selector.skip(pRootNode)) {
                        if (this.i == level || startFrame == null) {
                            Frame frame = ReadCallerFrameNode.getFrame(frameInstance, frameAccess);
                            assert (PArguments.isPythonFrame(frame));
                            result[0] = new StackWalkResult(pRootNode, frame);
                            needsCallerFrame = false;
                        }
                        ++this.i;
                    }
                    if (needsCallerFrame) {
                        pRootNode.setNeedsCallerFrame();
                    }
                }
                if (didMark) {
                    return result[0];
                }
                return null;
            }
        });
        return result[0];
    }

    private static RootNode getRootNode(FrameInstance frameInstance) {
        RootCallTarget target = (RootCallTarget)frameInstance.getCallTarget();
        RootNode rootNode = target.getRootNode();
        if (rootNode instanceof ContinuationRootNode) {
            ContinuationRootNode continuationRoot = (ContinuationRootNode)rootNode;
            return (RootNode)continuationRoot.getSourceRootNode();
        }
        return rootNode;
    }

    private static Frame getFrame(FrameInstance frameInstance, FrameInstance.FrameAccess frameAccess) {
        Frame frame = frameInstance.getFrame(frameAccess);
        RootCallTarget target = (RootCallTarget)frameInstance.getCallTarget();
        if (target.getRootNode() instanceof ContinuationRootNode) {
            return (Frame)frame.getArguments()[0];
        }
        return frame;
    }

    private MaterializeFrameNode ensureMaterializeNode() {
        if (this.materializeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.materializeNode = (MaterializeFrameNode)this.insert(MaterializeFrameNodeGen.create());
        }
        return this.materializeNode;
    }

    public static class SkipPythonInternalFramesSelector
    implements FrameSelector {
        public static final SkipPythonInternalFramesSelector INSTANCE = new SkipPythonInternalFramesSelector();

        @Override
        public boolean skip(RootNode rootNode) {
            return PRootNode.isPythonInternal(rootNode);
        }
    }

    public static interface FrameSelector {
        public boolean skip(RootNode var1);
    }

    public record StackWalkResult(PRootNode rootNode, Frame frame) {
    }

    public static class AllFramesSelector
    implements FrameSelector {
        public static final AllFramesSelector INSTANCE = new AllFramesSelector();

        @Override
        public boolean skip(RootNode rootNode) {
            return false;
        }
    }

    public static class SkipPythonBuiltinFramesSelector
    implements FrameSelector {
        public static final SkipPythonBuiltinFramesSelector INSTANCE = new SkipPythonBuiltinFramesSelector();

        @Override
        public boolean skip(RootNode rootNode) {
            return PRootNode.isPythonBuiltin(rootNode);
        }
    }

    public static class SkipInternalFramesSelector
    implements FrameSelector {
        public static final SkipInternalFramesSelector INSTANCE = new SkipInternalFramesSelector();

        @Override
        public boolean skip(RootNode rootNode) {
            return rootNode != null && rootNode.isInternal() || PRootNode.isPythonInternal(rootNode);
        }
    }
}

