/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.NodeFactoryUtils;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGetFactory;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class TpSlotDescrGet {
    private TpSlotDescrGet() {
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={CallDispatchers.class})
    static abstract class DescrGetPythonSlotDispatcherNode
    extends PythonDispatchers.PythonSlotDispatcherNodeBase {
        DescrGetPythonSlotDispatcherNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4, Object var5, Object var6, Object var7);

        @Specialization(guards={"isSingleContext()", "callee == cachedCallee", "isSimpleSignature(cachedCallee, 3)"}, limit="getCallSiteInlineCacheMaxDepth()", assumptions={"cachedCallee.getCodeStableAssumption()"})
        protected static Object doCachedPFunction(VirtualFrame frame, Node inliningTarget, PFunction callee, Object type, Object self, Object arg1, Object arg2, @Cached(value="callee") PFunction cachedCallee, @Cached.Exclusive @Cached InlinedConditionProfile arg1Profile, @Cached.Exclusive @Cached InlinedConditionProfile arg2Profile, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached CallDispatchers.FunctionDirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(3);
            PArguments.setArgument(arguments, 0, self);
            PArguments.setArgument(arguments, 1, DescrGetPythonSlotDispatcherNode.normalizeNoValue(arg1Profile, inliningTarget, arg1));
            PArguments.setArgument(arguments, 2, DescrGetPythonSlotDispatcherNode.normalizeNoValue(arg2Profile, inliningTarget, arg2));
            return invoke.execute(frame, inliningTarget, callNode, cachedCallee, arguments);
        }

        private static Object normalizeNoValue(InlinedConditionProfile profile, Node inlinintTarget, Object o) {
            return profile.profile(inlinintTarget, o == PNone.NO_VALUE) ? PNone.NONE : o;
        }

        @Specialization(replaces={"doCachedPFunction"})
        @HostCompilerDirectives.InliningCutoff
        static Object doGeneric(VirtualFrame frame, Node inliningTarget, Object callable, Object type, Object self, Object arg1, Object arg2, @Cached @Cached.Exclusive InlinedConditionProfile arg1Profile, @Cached @Cached.Exclusive InlinedConditionProfile arg2Profile, @Cached(inline=false) CallNode callNode) {
            return callNode.execute((Frame)frame, callable, self, DescrGetPythonSlotDispatcherNode.normalizeNoValue(arg1Profile, inliningTarget, arg1), DescrGetPythonSlotDispatcherNode.normalizeNoValue(arg2Profile, inliningTarget, arg2));
        }
    }

    @GenerateCached
    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class CallSlotDescrGet
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "tp_descr_get");

        public abstract Object execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4, Object var5, Object var6);

        public final Object executeCached(VirtualFrame frame, TpSlot slot, Object self, Object obj, Object type) {
            return this.execute(frame, this, slot, self, obj, type);
        }

        public static CallSlotDescrGet create() {
            return TpSlotDescrGetFactory.CallSlotDescrGetNodeGen.create();
        }

        @Specialization(guards={"cachedSlot == slot"}, limit="3")
        static Object callCachedBuiltin(VirtualFrame frame, TpSlotDescrGetBuiltin slot, Object self, Object obj, Object type, @Cached(value="slot") TpSlotDescrGetBuiltin cachedSlot, @Cached(value="cachedSlot.createSlotNode()") DescrGetBuiltinNode slotNode) {
            return slotNode.execute(frame, self, obj, type);
        }

        @Specialization
        static Object callPython(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotPythonSingle slot, Object self, Object obj, Object type, @Cached DescrGetPythonSlotDispatcherNode dispatcherNode) {
            return dispatcherNode.execute(frame, inliningTarget, slot.getCallable(), slot.getType(), self, obj, type);
        }

        @Specialization
        static Object callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotNative slot, Object self, Object obj, Object value, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode selfToNativeNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode objToNativeNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode valueToNativeNode, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached(inline=false) ExternalFunctionNodes.PyObjectCheckFunctionResultNode checkResultNode) {
            PythonContext ctx = PythonContext.get(inliningTarget);
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, ctx);
            Object result = externalInvokeNode.call(frame, inliningTarget, threadState, C_API_TIMING, SpecialMethodNames.T___GET__, slot.callable, selfToNativeNode.execute(self), objToNativeNode.execute(obj), valueToNativeNode.execute(value));
            return checkResultNode.execute(threadState, SpecialMethodNames.T___GET__, toPythonNode.execute(result));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"callCachedBuiltin"})
        static Object callGenericSimpleBuiltin(TpSlotDescrGetBuiltinSimple slot, Object self, Object obj, Object type) {
            return slot.executeUncached(self, obj, type);
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static Object callGenericBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotDescrGetBuiltinComplex slot, Object self, Object obj, Object type, @Cached CallDispatchers.SimpleIndirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(3);
            PArguments.setArgument(arguments, 0, self);
            PArguments.setArgument(arguments, 1, obj);
            PArguments.setArgument(arguments, 2, type);
            RootCallTarget callTarget = PythonLanguage.get(inliningTarget).getBuiltinSlotCallTarget(slot.callTargetIndex);
            return invoke.execute((Frame)frame, inliningTarget, callTarget, arguments);
        }
    }

    public static abstract class DescrGetBuiltinNode
    extends PythonTernaryBuiltinNode {
    }

    static final class DescrGetWrapperNode
    extends PythonTernaryBuiltinNode {
        private final ConditionProfile objIsNoneProfile = ConditionProfile.create();
        private final ConditionProfile typeIsNoneProfile = ConditionProfile.create();
        private final BranchProfile errorProfile = BranchProfile.create();
        @Node.Child
        private DescrGetBuiltinNode wrapped;

        DescrGetWrapperNode(DescrGetBuiltinNode wrapped) {
            this.wrapped = wrapped;
        }

        private static Object normalizeNone(ConditionProfile profile, Object o) {
            return profile.profile(PGuards.isNone(o)) ? PNone.NO_VALUE : o;
        }

        @Override
        public Object execute(VirtualFrame frame, Object self, Object objIn, Object typeIn) {
            Object obj = DescrGetWrapperNode.normalizeNone(this.objIsNoneProfile, objIn);
            Object type = DescrGetWrapperNode.normalizeNone(this.typeIsNoneProfile, typeIn);
            if (obj == PNone.NO_VALUE && type == PNone.NO_VALUE) {
                this.errorProfile.enter();
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.TypeError, ErrorMessages.GET_NONE_NONE_IS_INVALID);
            }
            return this.wrapped.execute(frame, self, obj, type);
        }
    }

    public static abstract class TpSlotDescrGetBuiltinComplex<T extends DescrGetBuiltinNode>
    extends TpSlotDescrGetBuiltin<T> {
        private final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();

        protected TpSlotDescrGetBuiltinComplex(NodeFactory<T> nodeFactory) {
            super(nodeFactory);
        }

        @Override
        public void initialize(PythonLanguage language) {
            RootCallTarget callTarget = TpSlotDescrGetBuiltinComplex.createSlotCallTarget(language, SIGNATURE, this.getNodeFactory(), "__get__");
            language.setBuiltinSlotCallTarget(this.callTargetIndex, callTarget);
        }
    }

    public static abstract class TpSlotDescrGetBuiltinSimple<T extends DescrGetBuiltinNode>
    extends TpSlotDescrGetBuiltin<T> {
        protected TpSlotDescrGetBuiltinSimple(NodeFactory<T> nodeFactory) {
            super(nodeFactory);
        }

        protected abstract Object executeUncached(Object var1, Object var2, Object var3);

        @Override
        public void initialize(PythonLanguage language) {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class TpSlotDescrGetBuiltin<T extends DescrGetBuiltinNode>
    extends TpSlot.TpSlotBuiltin<T> {
        static final BuiltinSlotWrapperSignature SIGNATURE = BuiltinSlotWrapperSignature.of(2, BuiltinSlotWrapperSignature.J_DOLLAR_SELF, "obj", "type");
        static final ExternalFunctionNodes.PExternalFunctionWrapper WRAPPER = ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_GET;

        protected TpSlotDescrGetBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory);
        }

        final DescrGetBuiltinNode createSlotNode() {
            return (DescrGetBuiltinNode)((Object)this.createNode());
        }

        @Override
        public PBuiltinFunction createBuiltin(Python3Core core, Object type, TruffleString tsName, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            if (wrapper != WRAPPER) {
                return null;
            }
            NodeFactoryUtils.WrapperNodeFactory<DescrGetWrapperNode, DescrGetBuiltinNode> factory = NodeFactoryUtils.WrapperNodeFactory.wrap(this.getNodeFactory(), DescrGetWrapperNode.class, DescrGetWrapperNode::new);
            return this.createBuiltin(core, type, tsName, SIGNATURE, wrapper, factory);
        }
    }
}

