/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.LintSeverity;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.CollectionsUtility;
import us.fatehi.utility.property.PropertyName;

class LinterForeignKeyWithNoIndexes
extends BaseLinter {
    public LinterForeignKeyWithNoIndexes(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
        this.setSeverity(LintSeverity.low);
    }

    @Override
    public String getSummary() {
        return "foreign key with no index";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        List<ForeignKey> foreignKeysWithoutIndexes = this.findForeignKeysWithoutIndexes(table);
        for (ForeignKey foreignKey : foreignKeysWithoutIndexes) {
            this.addTableLint(table, this.getSummary(), foreignKey);
        }
    }

    private List<ForeignKey> findForeignKeysWithoutIndexes(Table table) {
        ArrayList<ForeignKey> foreignKeysWithoutIndexes = new ArrayList<ForeignKey>();
        if (!MetaDataUtility.isView((Table)table)) {
            Collection allIndexCoumns = MetaDataUtility.allIndexCoumnNames((Table)table);
            for (ForeignKey foreignKey : table.getImportedForeignKeys()) {
                List foreignKeyColumns = MetaDataUtility.foreignKeyColumnNames((TableReference)foreignKey);
                boolean hasIndex = false;
                for (List indexColumns : allIndexCoumns) {
                    if (!CollectionsUtility.listStartsWith((List)indexColumns, (List)foreignKeyColumns)) continue;
                    hasIndex = true;
                    break;
                }
                if (hasIndex) continue;
                foreignKeysWithoutIndexes.add(foreignKey);
            }
        }
        return foreignKeysWithoutIndexes;
    }
}

