# SPDX-FileCopyrightText: Copyright (c) 2021-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: LicenseRef-NVIDIA-SOFTWARE-LICENSE

# This code was automatically generated with version 13.1.0. Do not modify it directly.
from typing import Any, Optional
from enum import IntEnum
import cython
import ctypes
from libc.stdlib cimport calloc, malloc, free
from libc cimport string
from libc.stdint cimport int32_t, uint32_t, int64_t, uint64_t, uintptr_t
from libc.stddef cimport wchar_t
from libc.limits cimport CHAR_MIN
from libcpp.vector cimport vector
from cpython.buffer cimport PyObject_CheckBuffer, PyObject_GetBuffer, PyBuffer_Release, PyBUF_SIMPLE, PyBUF_ANY_CONTIGUOUS
from cpython.bytes cimport PyBytes_FromStringAndSize
import cuda.bindings.driver
from libcpp.map cimport map

import cuda.bindings.driver as _driver
_driver = _driver.__dict__
include "_lib/utils.pxi"

ctypedef unsigned long long signed_char_ptr
ctypedef unsigned long long unsigned_char_ptr
ctypedef unsigned long long char_ptr
ctypedef unsigned long long short_ptr
ctypedef unsigned long long unsigned_short_ptr
ctypedef unsigned long long int_ptr
ctypedef unsigned long long long_int_ptr
ctypedef unsigned long long long_long_int_ptr
ctypedef unsigned long long unsigned_int_ptr
ctypedef unsigned long long unsigned_long_int_ptr
ctypedef unsigned long long unsigned_long_long_int_ptr
ctypedef unsigned long long uint32_t_ptr
ctypedef unsigned long long uint64_t_ptr
ctypedef unsigned long long int32_t_ptr
ctypedef unsigned long long int64_t_ptr
ctypedef unsigned long long unsigned_ptr
ctypedef unsigned long long unsigned_long_long_ptr
ctypedef unsigned long long long_long_ptr
ctypedef unsigned long long size_t_ptr
ctypedef unsigned long long long_ptr
ctypedef unsigned long long float_ptr
ctypedef unsigned long long double_ptr
ctypedef unsigned long long void_ptr

#: Default page-locked allocation flag
cudaHostAllocDefault = cyruntime.cudaHostAllocDefault

#: Pinned memory accessible by all CUDA contexts
cudaHostAllocPortable = cyruntime.cudaHostAllocPortable

#: Map allocation into device space
cudaHostAllocMapped = cyruntime.cudaHostAllocMapped

#: Write-combined memory
cudaHostAllocWriteCombined = cyruntime.cudaHostAllocWriteCombined

#: Default host memory registration flag
cudaHostRegisterDefault = cyruntime.cudaHostRegisterDefault

#: Pinned memory accessible by all CUDA contexts
cudaHostRegisterPortable = cyruntime.cudaHostRegisterPortable

#: Map registered memory into device space
cudaHostRegisterMapped = cyruntime.cudaHostRegisterMapped

#: Memory-mapped I/O space
cudaHostRegisterIoMemory = cyruntime.cudaHostRegisterIoMemory

#: Memory-mapped read-only
cudaHostRegisterReadOnly = cyruntime.cudaHostRegisterReadOnly

#: Default peer addressing enable flag
cudaPeerAccessDefault = cyruntime.cudaPeerAccessDefault

#: Default stream flag
cudaStreamDefault = cyruntime.cudaStreamDefault

#: Stream does not synchronize with stream 0 (the NULL stream)
cudaStreamNonBlocking = cyruntime.cudaStreamNonBlocking

#: Legacy stream handle
#:
#: Stream handle that can be passed as a cudaStream_t to use an implicit
#: stream with legacy synchronization behavior.
#:
#: See details of the \link_sync_behavior
cudaStreamLegacy = cyruntime.cudaStreamLegacy

#: Per-thread stream handle
#:
#: Stream handle that can be passed as a cudaStream_t to use an implicit
#: stream with per-thread synchronization behavior.
#:
#: See details of the \link_sync_behavior
cudaStreamPerThread = cyruntime.cudaStreamPerThread

#: Default event flag
cudaEventDefault = cyruntime.cudaEventDefault

#: Event uses blocking synchronization
cudaEventBlockingSync = cyruntime.cudaEventBlockingSync

#: Event will not record timing data
cudaEventDisableTiming = cyruntime.cudaEventDisableTiming

#: Event is suitable for interprocess use. cudaEventDisableTiming must be
#: set
cudaEventInterprocess = cyruntime.cudaEventInterprocess

#: Default event record flag
cudaEventRecordDefault = cyruntime.cudaEventRecordDefault

#: Event is captured in the graph as an external event node when performing
#: stream capture
cudaEventRecordExternal = cyruntime.cudaEventRecordExternal

#: Default event wait flag
cudaEventWaitDefault = cyruntime.cudaEventWaitDefault

#: Event is captured in the graph as an external event node when performing
#: stream capture
cudaEventWaitExternal = cyruntime.cudaEventWaitExternal

#: Device flag - Automatic scheduling
cudaDeviceScheduleAuto = cyruntime.cudaDeviceScheduleAuto

#: Device flag - Spin default scheduling
cudaDeviceScheduleSpin = cyruntime.cudaDeviceScheduleSpin

#: Device flag - Yield default scheduling
cudaDeviceScheduleYield = cyruntime.cudaDeviceScheduleYield

#: Device flag - Use blocking synchronization
cudaDeviceScheduleBlockingSync = cyruntime.cudaDeviceScheduleBlockingSync

#: Device flag - Use blocking synchronization [Deprecated]
cudaDeviceBlockingSync = cyruntime.cudaDeviceBlockingSync

#: Device schedule flags mask
cudaDeviceScheduleMask = cyruntime.cudaDeviceScheduleMask

#: Device flag - Support mapped pinned allocations
cudaDeviceMapHost = cyruntime.cudaDeviceMapHost

#: Device flag - Keep local memory allocation after launch
cudaDeviceLmemResizeToMax = cyruntime.cudaDeviceLmemResizeToMax

#: Device flag - Ensure synchronous memory operations on this context will
#: synchronize
cudaDeviceSyncMemops = cyruntime.cudaDeviceSyncMemops

#: Device flags mask
cudaDeviceMask = cyruntime.cudaDeviceMask

#: Default CUDA array allocation flag
cudaArrayDefault = cyruntime.cudaArrayDefault

#: Must be set in cudaMalloc3DArray to create a layered CUDA array
cudaArrayLayered = cyruntime.cudaArrayLayered

#: Must be set in cudaMallocArray or cudaMalloc3DArray in order to bind
#: surfaces to the CUDA array
cudaArraySurfaceLoadStore = cyruntime.cudaArraySurfaceLoadStore

#: Must be set in cudaMalloc3DArray to create a cubemap CUDA array
cudaArrayCubemap = cyruntime.cudaArrayCubemap

#: Must be set in cudaMallocArray or cudaMalloc3DArray in order to perform
#: texture gather operations on the CUDA array
cudaArrayTextureGather = cyruntime.cudaArrayTextureGather

#: Must be set in cudaExternalMemoryGetMappedMipmappedArray if the
#: mipmapped array is used as a color target in a graphics API
cudaArrayColorAttachment = cyruntime.cudaArrayColorAttachment

#: Must be set in cudaMallocArray, cudaMalloc3DArray or
#: cudaMallocMipmappedArray in order to create a sparse CUDA array or CUDA
#: mipmapped array
cudaArraySparse = cyruntime.cudaArraySparse

#: Must be set in cudaMallocArray, cudaMalloc3DArray or
#: cudaMallocMipmappedArray in order to create a deferred mapping CUDA
#: array or CUDA mipmapped array
cudaArrayDeferredMapping = cyruntime.cudaArrayDeferredMapping

#: Automatically enable peer access between remote devices as needed
cudaIpcMemLazyEnablePeerAccess = cyruntime.cudaIpcMemLazyEnablePeerAccess

#: Memory can be accessed by any stream on any device
cudaMemAttachGlobal = cyruntime.cudaMemAttachGlobal

#: Memory cannot be accessed by any stream on any device
cudaMemAttachHost = cyruntime.cudaMemAttachHost

#: Memory can only be accessed by a single stream on the associated device
cudaMemAttachSingle = cyruntime.cudaMemAttachSingle

#: Default behavior
cudaOccupancyDefault = cyruntime.cudaOccupancyDefault

#: Assume global caching is enabled and cannot be automatically turned off
cudaOccupancyDisableCachingOverride = cyruntime.cudaOccupancyDisableCachingOverride

#: Device id that represents the CPU
cudaCpuDeviceId = cyruntime.cudaCpuDeviceId

#: Device id that represents an invalid device
cudaInvalidDeviceId = cyruntime.cudaInvalidDeviceId

#: Tell the CUDA runtime that DeviceFlags is being set in cudaInitDevice
#: call
cudaInitDeviceFlagsAreValid = cyruntime.cudaInitDeviceFlagsAreValid

#: Indicates that the layered sparse CUDA array or CUDA mipmapped array has
#: a single mip tail region for all layers
cudaArraySparsePropertiesSingleMipTail = cyruntime.cudaArraySparsePropertiesSingleMipTail

#: This flag, if set, indicates that the memory will be used as a buffer
#: for hardware accelerated decompression.
cudaMemPoolCreateUsageHwDecompress = cyruntime.cudaMemPoolCreateUsageHwDecompress

#: CUDA IPC Handle Size
CUDA_IPC_HANDLE_SIZE = cyruntime.CUDA_IPC_HANDLE_SIZE

#: Indicates that the external memory object is a dedicated resource
cudaExternalMemoryDedicated = cyruntime.cudaExternalMemoryDedicated

#: When the /p flags parameter of
#: :py:obj:`~.cudaExternalSemaphoreSignalParams` contains this flag, it
#: indicates that signaling an external semaphore object should skip
#: performing appropriate memory synchronization operations over all the
#: external memory objects that are imported as
#: :py:obj:`~.cudaExternalMemoryHandleTypeNvSciBuf`, which otherwise are
#: performed by default to ensure data coherency with other importers of
#: the same NvSciBuf memory objects.
cudaExternalSemaphoreSignalSkipNvSciBufMemSync = cyruntime.cudaExternalSemaphoreSignalSkipNvSciBufMemSync

#: When the /p flags parameter of
#: :py:obj:`~.cudaExternalSemaphoreWaitParams` contains this flag, it
#: indicates that waiting an external semaphore object should skip
#: performing appropriate memory synchronization operations over all the
#: external memory objects that are imported as
#: :py:obj:`~.cudaExternalMemoryHandleTypeNvSciBuf`, which otherwise are
#: performed by default to ensure data coherency with other importers of
#: the same NvSciBuf memory objects.
cudaExternalSemaphoreWaitSkipNvSciBufMemSync = cyruntime.cudaExternalSemaphoreWaitSkipNvSciBufMemSync

#: When /p flags of :py:obj:`~.cudaDeviceGetNvSciSyncAttributes` is set to
#: this, it indicates that application need signaler specific NvSciSyncAttr
#: to be filled by :py:obj:`~.cudaDeviceGetNvSciSyncAttributes`.
cudaNvSciSyncAttrSignal = cyruntime.cudaNvSciSyncAttrSignal

#: When /p flags of :py:obj:`~.cudaDeviceGetNvSciSyncAttributes` is set to
#: this, it indicates that application need waiter specific NvSciSyncAttr
#: to be filled by :py:obj:`~.cudaDeviceGetNvSciSyncAttributes`.
cudaNvSciSyncAttrWait = cyruntime.cudaNvSciSyncAttrWait

#: This port activates when the kernel has finished executing.
cudaGraphKernelNodePortDefault = cyruntime.cudaGraphKernelNodePortDefault

#: This port activates when all blocks of the kernel have performed
#: cudaTriggerProgrammaticLaunchCompletion() or have terminated. It must be
#: used with edge type :py:obj:`~.cudaGraphDependencyTypeProgrammatic`. See
#: also :py:obj:`~.cudaLaunchAttributeProgrammaticEvent`.
cudaGraphKernelNodePortProgrammatic = cyruntime.cudaGraphKernelNodePortProgrammatic

#: This port activates when all blocks of the kernel have begun execution.
#: See also :py:obj:`~.cudaLaunchAttributeLaunchCompletionEvent`.
cudaGraphKernelNodePortLaunchCompletion = cyruntime.cudaGraphKernelNodePortLaunchCompletion

cudaStreamAttributeAccessPolicyWindow = cyruntime.cudaStreamAttributeAccessPolicyWindow

cudaStreamAttributeSynchronizationPolicy = cyruntime.cudaStreamAttributeSynchronizationPolicy

cudaStreamAttributeMemSyncDomainMap = cyruntime.cudaStreamAttributeMemSyncDomainMap

cudaStreamAttributeMemSyncDomain = cyruntime.cudaStreamAttributeMemSyncDomain

cudaStreamAttributePriority = cyruntime.cudaStreamAttributePriority

cudaKernelNodeAttributeAccessPolicyWindow = cyruntime.cudaKernelNodeAttributeAccessPolicyWindow

cudaKernelNodeAttributeCooperative = cyruntime.cudaKernelNodeAttributeCooperative

cudaKernelNodeAttributePriority = cyruntime.cudaKernelNodeAttributePriority

cudaKernelNodeAttributeClusterDimension = cyruntime.cudaKernelNodeAttributeClusterDimension

cudaKernelNodeAttributeClusterSchedulingPolicyPreference = cyruntime.cudaKernelNodeAttributeClusterSchedulingPolicyPreference

cudaKernelNodeAttributeMemSyncDomainMap = cyruntime.cudaKernelNodeAttributeMemSyncDomainMap

cudaKernelNodeAttributeMemSyncDomain = cyruntime.cudaKernelNodeAttributeMemSyncDomain

cudaKernelNodeAttributePreferredSharedMemoryCarveout = cyruntime.cudaKernelNodeAttributePreferredSharedMemoryCarveout

cudaKernelNodeAttributeDeviceUpdatableKernelNode = cyruntime.cudaKernelNodeAttributeDeviceUpdatableKernelNode

cudaKernelNodeAttributeNvlinkUtilCentricScheduling = cyruntime.cudaKernelNodeAttributeNvlinkUtilCentricScheduling

cudaSurfaceType1D = cyruntime.cudaSurfaceType1D

cudaSurfaceType2D = cyruntime.cudaSurfaceType2D

cudaSurfaceType3D = cyruntime.cudaSurfaceType3D

cudaSurfaceTypeCubemap = cyruntime.cudaSurfaceTypeCubemap

cudaSurfaceType1DLayered = cyruntime.cudaSurfaceType1DLayered

cudaSurfaceType2DLayered = cyruntime.cudaSurfaceType2DLayered

cudaSurfaceTypeCubemapLayered = cyruntime.cudaSurfaceTypeCubemapLayered

cudaTextureType1D = cyruntime.cudaTextureType1D

cudaTextureType2D = cyruntime.cudaTextureType2D

cudaTextureType3D = cyruntime.cudaTextureType3D

cudaTextureTypeCubemap = cyruntime.cudaTextureTypeCubemap

cudaTextureType1DLayered = cyruntime.cudaTextureType1DLayered

cudaTextureType2DLayered = cyruntime.cudaTextureType2DLayered

cudaTextureTypeCubemapLayered = cyruntime.cudaTextureTypeCubemapLayered

#: CUDA Runtime API Version
CUDART_VERSION = cyruntime.CUDART_VERSION

__CUDART_API_VERSION = cyruntime.__CUDART_API_VERSION

#: Maximum number of planes per frame
CUDA_EGL_MAX_PLANES = cyruntime.CUDA_EGL_MAX_PLANES

class cudaError_t(IntEnum):
    """
    impl_private CUDA error types
    """

    #: The API call returned with no errors. In the case of query calls,
    #: this also means that the operation being queried is complete (see
    #: :py:obj:`~.cudaEventQuery()` and :py:obj:`~.cudaStreamQuery()`).
    cudaSuccess = cyruntime.cudaError.cudaSuccess

    #: This indicates that one or more of the parameters passed to the API
    #: call is not within an acceptable range of values.
    cudaErrorInvalidValue = cyruntime.cudaError.cudaErrorInvalidValue

    #: The API call failed because it was unable to allocate enough memory
    #: or other resources to perform the requested operation.
    cudaErrorMemoryAllocation = cyruntime.cudaError.cudaErrorMemoryAllocation

    #: The API call failed because the CUDA driver and runtime could not be
    #: initialized.
    cudaErrorInitializationError = cyruntime.cudaError.cudaErrorInitializationError

    #: This indicates that a CUDA Runtime API call cannot be executed
    #: because it is being called during process shut down, at a point in
    #: time after CUDA driver has been unloaded.
    cudaErrorCudartUnloading = cyruntime.cudaError.cudaErrorCudartUnloading

    #: This indicates profiler is not initialized for this run. This can
    #: happen when the application is running with external profiling tools
    #: like visual profiler.
    cudaErrorProfilerDisabled = cyruntime.cudaError.cudaErrorProfilerDisabled

    #: [Deprecated]
    cudaErrorProfilerNotInitialized = cyruntime.cudaError.cudaErrorProfilerNotInitialized

    #: [Deprecated]
    cudaErrorProfilerAlreadyStarted = cyruntime.cudaError.cudaErrorProfilerAlreadyStarted

    #: [Deprecated]
    cudaErrorProfilerAlreadyStopped = cyruntime.cudaError.cudaErrorProfilerAlreadyStopped

    #: This indicates that a kernel launch is requesting resources that can
    #: never be satisfied by the current device. Requesting more shared
    #: memory per block than the device supports will trigger this error,
    #: as will requesting too many threads or blocks. See
    #: :py:obj:`~.cudaDeviceProp` for more device limitations.
    cudaErrorInvalidConfiguration = cyruntime.cudaError.cudaErrorInvalidConfiguration

    #: This indicates that one or more of the pitch-related parameters
    #: passed to the API call is not within the acceptable range for pitch.
    cudaErrorInvalidPitchValue = cyruntime.cudaError.cudaErrorInvalidPitchValue

    #: This indicates that the symbol name/identifier passed to the API
    #: call is not a valid name or identifier.
    cudaErrorInvalidSymbol = cyruntime.cudaError.cudaErrorInvalidSymbol

    #: This indicates that at least one host pointer passed to the API call
    #: is not a valid host pointer. [Deprecated]
    cudaErrorInvalidHostPointer = cyruntime.cudaError.cudaErrorInvalidHostPointer

    #: This indicates that at least one device pointer passed to the API
    #: call is not a valid device pointer. [Deprecated]
    cudaErrorInvalidDevicePointer = cyruntime.cudaError.cudaErrorInvalidDevicePointer

    #: This indicates that the texture passed to the API call is not a
    #: valid texture.
    cudaErrorInvalidTexture = cyruntime.cudaError.cudaErrorInvalidTexture

    #: This indicates that the texture binding is not valid. This occurs if
    #: you call :py:obj:`~.cudaGetTextureAlignmentOffset()` with an unbound
    #: texture.
    cudaErrorInvalidTextureBinding = cyruntime.cudaError.cudaErrorInvalidTextureBinding

    #: This indicates that the channel descriptor passed to the API call is
    #: not valid. This occurs if the format is not one of the formats
    #: specified by :py:obj:`~.cudaChannelFormatKind`, or if one of the
    #: dimensions is invalid.
    cudaErrorInvalidChannelDescriptor = cyruntime.cudaError.cudaErrorInvalidChannelDescriptor

    #: This indicates that the direction of the memcpy passed to the API
    #: call is not one of the types specified by
    #: :py:obj:`~.cudaMemcpyKind`.
    cudaErrorInvalidMemcpyDirection = cyruntime.cudaError.cudaErrorInvalidMemcpyDirection

    #: This indicated that the user has taken the address of a constant
    #: variable, which was forbidden up until the CUDA 3.1 release.
    #: [Deprecated]
    cudaErrorAddressOfConstant = cyruntime.cudaError.cudaErrorAddressOfConstant

    #: This indicated that a texture fetch was not able to be performed.
    #: This was previously used for device emulation of texture operations.
    #: [Deprecated]
    cudaErrorTextureFetchFailed = cyruntime.cudaError.cudaErrorTextureFetchFailed

    #: This indicated that a texture was not bound for access. This was
    #: previously used for device emulation of texture operations.
    #: [Deprecated]
    cudaErrorTextureNotBound = cyruntime.cudaError.cudaErrorTextureNotBound

    #: This indicated that a synchronization operation had failed. This was
    #: previously used for some device emulation functions. [Deprecated]
    cudaErrorSynchronizationError = cyruntime.cudaError.cudaErrorSynchronizationError

    #: This indicates that a non-float texture was being accessed with
    #: linear filtering. This is not supported by CUDA.
    cudaErrorInvalidFilterSetting = cyruntime.cudaError.cudaErrorInvalidFilterSetting

    #: This indicates that an attempt was made to read an unsupported data
    #: type as a normalized float. This is not supported by CUDA.
    cudaErrorInvalidNormSetting = cyruntime.cudaError.cudaErrorInvalidNormSetting

    #: Mixing of device and device emulation code was not allowed.
    #: [Deprecated]
    cudaErrorMixedDeviceExecution = cyruntime.cudaError.cudaErrorMixedDeviceExecution

    #: This indicates that the API call is not yet implemented. Production
    #: releases of CUDA will never return this error. [Deprecated]
    cudaErrorNotYetImplemented = cyruntime.cudaError.cudaErrorNotYetImplemented

    #: This indicated that an emulated device pointer exceeded the 32-bit
    #: address range. [Deprecated]
    cudaErrorMemoryValueTooLarge = cyruntime.cudaError.cudaErrorMemoryValueTooLarge

    #: This indicates that the CUDA driver that the application has loaded
    #: is a stub library. Applications that run with the stub rather than a
    #: real driver loaded will result in CUDA API returning this error.
    cudaErrorStubLibrary = cyruntime.cudaError.cudaErrorStubLibrary

    #: This indicates that the installed NVIDIA CUDA driver is older than
    #: the CUDA runtime library. This is not a supported configuration.
    #: Users should install an updated NVIDIA display driver to allow the
    #: application to run.
    cudaErrorInsufficientDriver = cyruntime.cudaError.cudaErrorInsufficientDriver

    #: This indicates that the API call requires a newer CUDA driver than
    #: the one currently installed. Users should install an updated NVIDIA
    #: CUDA driver to allow the API call to succeed.
    cudaErrorCallRequiresNewerDriver = cyruntime.cudaError.cudaErrorCallRequiresNewerDriver

    #: This indicates that the surface passed to the API call is not a
    #: valid surface.
    cudaErrorInvalidSurface = cyruntime.cudaError.cudaErrorInvalidSurface

    #: This indicates that multiple global or constant variables (across
    #: separate CUDA source files in the application) share the same string
    #: name.
    cudaErrorDuplicateVariableName = cyruntime.cudaError.cudaErrorDuplicateVariableName

    #: This indicates that multiple textures (across separate CUDA source
    #: files in the application) share the same string name.
    cudaErrorDuplicateTextureName = cyruntime.cudaError.cudaErrorDuplicateTextureName

    #: This indicates that multiple surfaces (across separate CUDA source
    #: files in the application) share the same string name.
    cudaErrorDuplicateSurfaceName = cyruntime.cudaError.cudaErrorDuplicateSurfaceName

    #: This indicates that all CUDA devices are busy or unavailable at the
    #: current time. Devices are often busy/unavailable due to use of
    #: :py:obj:`~.cudaComputeModeProhibited`,
    #: :py:obj:`~.cudaComputeModeExclusiveProcess`, or when long running
    #: CUDA kernels have filled up the GPU and are blocking new work from
    #: starting. They can also be unavailable due to memory constraints on
    #: a device that already has active CUDA work being performed.
    cudaErrorDevicesUnavailable = cyruntime.cudaError.cudaErrorDevicesUnavailable

    #: This indicates that the current context is not compatible with this
    #: the CUDA Runtime. This can only occur if you are using CUDA
    #: Runtime/Driver interoperability and have created an existing Driver
    #: context using the driver API. The Driver context may be incompatible
    #: either because the Driver context was created using an older version
    #: of the API, because the Runtime API call expects a primary driver
    #: context and the Driver context is not primary, or because the Driver
    #: context has been destroyed. Please see :py:obj:`~.Interactions`with
    #: the CUDA Driver API" for more information.
    cudaErrorIncompatibleDriverContext = cyruntime.cudaError.cudaErrorIncompatibleDriverContext

    #: The device function being invoked (usually via
    #: :py:obj:`~.cudaLaunchKernel()`) was not previously configured via
    #: the :py:obj:`~.cudaConfigureCall()` function.
    cudaErrorMissingConfiguration = cyruntime.cudaError.cudaErrorMissingConfiguration

    #: This indicated that a previous kernel launch failed. This was
    #: previously used for device emulation of kernel launches.
    #: [Deprecated]
    cudaErrorPriorLaunchFailure = cyruntime.cudaError.cudaErrorPriorLaunchFailure

    #: This error indicates that a device runtime grid launch did not occur
    #: because the depth of the child grid would exceed the maximum
    #: supported number of nested grid launches.
    cudaErrorLaunchMaxDepthExceeded = cyruntime.cudaError.cudaErrorLaunchMaxDepthExceeded

    #: This error indicates that a grid launch did not occur because the
    #: kernel uses file-scoped textures which are unsupported by the device
    #: runtime. Kernels launched via the device runtime only support
    #: textures created with the Texture Object API's.
    cudaErrorLaunchFileScopedTex = cyruntime.cudaError.cudaErrorLaunchFileScopedTex

    #: This error indicates that a grid launch did not occur because the
    #: kernel uses file-scoped surfaces which are unsupported by the device
    #: runtime. Kernels launched via the device runtime only support
    #: surfaces created with the Surface Object API's.
    cudaErrorLaunchFileScopedSurf = cyruntime.cudaError.cudaErrorLaunchFileScopedSurf

    #: This error indicates that a call to
    #: :py:obj:`~.cudaDeviceSynchronize` made from the device runtime
    #: failed because the call was made at grid depth greater than than
    #: either the default (2 levels of grids) or user specified device
    #: limit :py:obj:`~.cudaLimitDevRuntimeSyncDepth`. To be able to
    #: synchronize on launched grids at a greater depth successfully, the
    #: maximum nested depth at which :py:obj:`~.cudaDeviceSynchronize` will
    #: be called must be specified with the
    #: :py:obj:`~.cudaLimitDevRuntimeSyncDepth` limit to the
    #: :py:obj:`~.cudaDeviceSetLimit` api before the host-side launch of a
    #: kernel using the device runtime. Keep in mind that additional levels
    #: of sync depth require the runtime to reserve large amounts of device
    #: memory that cannot be used for user allocations. Note that
    #: :py:obj:`~.cudaDeviceSynchronize` made from device runtime is only
    #: supported on devices of compute capability < 9.0.
    cudaErrorSyncDepthExceeded = cyruntime.cudaError.cudaErrorSyncDepthExceeded

    #: This error indicates that a device runtime grid launch failed
    #: because the launch would exceed the limit
    #: :py:obj:`~.cudaLimitDevRuntimePendingLaunchCount`. For this launch
    #: to proceed successfully, :py:obj:`~.cudaDeviceSetLimit` must be
    #: called to set the :py:obj:`~.cudaLimitDevRuntimePendingLaunchCount`
    #: to be higher than the upper bound of outstanding launches that can
    #: be issued to the device runtime. Keep in mind that raising the limit
    #: of pending device runtime launches will require the runtime to
    #: reserve device memory that cannot be used for user allocations.
    cudaErrorLaunchPendingCountExceeded = cyruntime.cudaError.cudaErrorLaunchPendingCountExceeded

    #: The requested device function does not exist or is not compiled for
    #: the proper device architecture.
    cudaErrorInvalidDeviceFunction = cyruntime.cudaError.cudaErrorInvalidDeviceFunction

    #: This indicates that no CUDA-capable devices were detected by the
    #: installed CUDA driver.
    cudaErrorNoDevice = cyruntime.cudaError.cudaErrorNoDevice

    #: This indicates that the device ordinal supplied by the user does not
    #: correspond to a valid CUDA device or that the action requested is
    #: invalid for the specified device.
    cudaErrorInvalidDevice = cyruntime.cudaError.cudaErrorInvalidDevice

    #: This indicates that the device doesn't have a valid Grid License.
    cudaErrorDeviceNotLicensed = cyruntime.cudaError.cudaErrorDeviceNotLicensed

    #: By default, the CUDA runtime may perform a minimal set of self-
    #: tests, as well as CUDA driver tests, to establish the validity of
    #: both. Introduced in CUDA 11.2, this error return indicates that at
    #: least one of these tests has failed and the validity of either the
    #: runtime or the driver could not be established.
    cudaErrorSoftwareValidityNotEstablished = cyruntime.cudaError.cudaErrorSoftwareValidityNotEstablished

    #: This indicates an internal startup failure in the CUDA runtime.
    cudaErrorStartupFailure = cyruntime.cudaError.cudaErrorStartupFailure

    #: This indicates that the device kernel image is invalid.
    cudaErrorInvalidKernelImage = cyruntime.cudaError.cudaErrorInvalidKernelImage

    #: This most frequently indicates that there is no context bound to the
    #: current thread. This can also be returned if the context passed to
    #: an API call is not a valid handle (such as a context that has had
    #: :py:obj:`~.cuCtxDestroy()` invoked on it). This can also be returned
    #: if a user mixes different API versions (i.e. 3010 context with 3020
    #: API calls). See :py:obj:`~.cuCtxGetApiVersion()` for more details.
    cudaErrorDeviceUninitialized = cyruntime.cudaError.cudaErrorDeviceUninitialized

    #: This indicates that the buffer object could not be mapped.
    cudaErrorMapBufferObjectFailed = cyruntime.cudaError.cudaErrorMapBufferObjectFailed

    #: This indicates that the buffer object could not be unmapped.
    cudaErrorUnmapBufferObjectFailed = cyruntime.cudaError.cudaErrorUnmapBufferObjectFailed

    #: This indicates that the specified array is currently mapped and thus
    #: cannot be destroyed.
    cudaErrorArrayIsMapped = cyruntime.cudaError.cudaErrorArrayIsMapped

    #: This indicates that the resource is already mapped.
    cudaErrorAlreadyMapped = cyruntime.cudaError.cudaErrorAlreadyMapped

    #: This indicates that there is no kernel image available that is
    #: suitable for the device. This can occur when a user specifies code
    #: generation options for a particular CUDA source file that do not
    #: include the corresponding device configuration.
    cudaErrorNoKernelImageForDevice = cyruntime.cudaError.cudaErrorNoKernelImageForDevice

    #: This indicates that a resource has already been acquired.
    cudaErrorAlreadyAcquired = cyruntime.cudaError.cudaErrorAlreadyAcquired

    #: This indicates that a resource is not mapped.
    cudaErrorNotMapped = cyruntime.cudaError.cudaErrorNotMapped

    #: This indicates that a mapped resource is not available for access as
    #: an array.
    cudaErrorNotMappedAsArray = cyruntime.cudaError.cudaErrorNotMappedAsArray

    #: This indicates that a mapped resource is not available for access as
    #: a pointer.
    cudaErrorNotMappedAsPointer = cyruntime.cudaError.cudaErrorNotMappedAsPointer

    #: This indicates that an uncorrectable ECC error was detected during
    #: execution.
    cudaErrorECCUncorrectable = cyruntime.cudaError.cudaErrorECCUncorrectable

    #: This indicates that the :py:obj:`~.cudaLimit` passed to the API call
    #: is not supported by the active device.
    cudaErrorUnsupportedLimit = cyruntime.cudaError.cudaErrorUnsupportedLimit

    #: This indicates that a call tried to access an exclusive-thread
    #: device that is already in use by a different thread.
    cudaErrorDeviceAlreadyInUse = cyruntime.cudaError.cudaErrorDeviceAlreadyInUse

    #: This error indicates that P2P access is not supported across the
    #: given devices.
    cudaErrorPeerAccessUnsupported = cyruntime.cudaError.cudaErrorPeerAccessUnsupported

    #: A PTX compilation failed. The runtime may fall back to compiling PTX
    #: if an application does not contain a suitable binary for the current
    #: device.
    cudaErrorInvalidPtx = cyruntime.cudaError.cudaErrorInvalidPtx

    #: This indicates an error with the OpenGL or DirectX context.
    cudaErrorInvalidGraphicsContext = cyruntime.cudaError.cudaErrorInvalidGraphicsContext

    #: This indicates that an uncorrectable NVLink error was detected
    #: during the execution.
    cudaErrorNvlinkUncorrectable = cyruntime.cudaError.cudaErrorNvlinkUncorrectable

    #: This indicates that the PTX JIT compiler library was not found. The
    #: JIT Compiler library is used for PTX compilation. The runtime may
    #: fall back to compiling PTX if an application does not contain a
    #: suitable binary for the current device.
    cudaErrorJitCompilerNotFound = cyruntime.cudaError.cudaErrorJitCompilerNotFound

    #: This indicates that the provided PTX was compiled with an
    #: unsupported toolchain. The most common reason for this, is the PTX
    #: was generated by a compiler newer than what is supported by the CUDA
    #: driver and PTX JIT compiler.
    cudaErrorUnsupportedPtxVersion = cyruntime.cudaError.cudaErrorUnsupportedPtxVersion

    #: This indicates that the JIT compilation was disabled. The JIT
    #: compilation compiles PTX. The runtime may fall back to compiling PTX
    #: if an application does not contain a suitable binary for the current
    #: device.
    cudaErrorJitCompilationDisabled = cyruntime.cudaError.cudaErrorJitCompilationDisabled

    #: This indicates that the provided execution affinity is not supported
    #: by the device.
    cudaErrorUnsupportedExecAffinity = cyruntime.cudaError.cudaErrorUnsupportedExecAffinity

    #: This indicates that the code to be compiled by the PTX JIT contains
    #: unsupported call to cudaDeviceSynchronize.
    cudaErrorUnsupportedDevSideSync = cyruntime.cudaError.cudaErrorUnsupportedDevSideSync

    #: This indicates that an exception occurred on the device that is now
    #: contained by the GPU's error containment capability. Common causes
    #: are - a. Certain types of invalid accesses of peer GPU memory over
    #: nvlink b. Certain classes of hardware errors This leaves the process
    #: in an inconsistent state and any further CUDA work will return the
    #: same error. To continue using CUDA, the process must be terminated
    #: and relaunched.
    cudaErrorContained = cyruntime.cudaError.cudaErrorContained

    #: This indicates that the device kernel source is invalid.
    cudaErrorInvalidSource = cyruntime.cudaError.cudaErrorInvalidSource

    #: This indicates that the file specified was not found.
    cudaErrorFileNotFound = cyruntime.cudaError.cudaErrorFileNotFound

    #: This indicates that a link to a shared object failed to resolve.
    cudaErrorSharedObjectSymbolNotFound = cyruntime.cudaError.cudaErrorSharedObjectSymbolNotFound

    #: This indicates that initialization of a shared object failed.
    cudaErrorSharedObjectInitFailed = cyruntime.cudaError.cudaErrorSharedObjectInitFailed

    #: This error indicates that an OS call failed.
    cudaErrorOperatingSystem = cyruntime.cudaError.cudaErrorOperatingSystem

    #: This indicates that a resource handle passed to the API call was not
    #: valid. Resource handles are opaque types like
    #: :py:obj:`~.cudaStream_t` and :py:obj:`~.cudaEvent_t`.
    cudaErrorInvalidResourceHandle = cyruntime.cudaError.cudaErrorInvalidResourceHandle

    #: This indicates that a resource required by the API call is not in a
    #: valid state to perform the requested operation.
    cudaErrorIllegalState = cyruntime.cudaError.cudaErrorIllegalState

    #: This indicates an attempt was made to introspect an object in a way
    #: that would discard semantically important information. This is
    #: either due to the object using funtionality newer than the API
    #: version used to introspect it or omission of optional return
    #: arguments.
    cudaErrorLossyQuery = cyruntime.cudaError.cudaErrorLossyQuery

    #: This indicates that a named symbol was not found. Examples of
    #: symbols are global/constant variable names, driver function names,
    #: texture names, and surface names.
    cudaErrorSymbolNotFound = cyruntime.cudaError.cudaErrorSymbolNotFound

    #: This indicates that asynchronous operations issued previously have
    #: not completed yet. This result is not actually an error, but must be
    #: indicated differently than :py:obj:`~.cudaSuccess` (which indicates
    #: completion). Calls that may return this value include
    #: :py:obj:`~.cudaEventQuery()` and :py:obj:`~.cudaStreamQuery()`.
    cudaErrorNotReady = cyruntime.cudaError.cudaErrorNotReady

    #: The device encountered a load or store instruction on an invalid
    #: memory address. This leaves the process in an inconsistent state and
    #: any further CUDA work will return the same error. To continue using
    #: CUDA, the process must be terminated and relaunched.
    cudaErrorIllegalAddress = cyruntime.cudaError.cudaErrorIllegalAddress

    #: This indicates that a launch did not occur because it did not have
    #: appropriate resources. Although this error is similar to
    #: :py:obj:`~.cudaErrorInvalidConfiguration`, this error usually
    #: indicates that the user has attempted to pass too many arguments to
    #: the device kernel, or the kernel launch specifies too many threads
    #: for the kernel's register count.
    cudaErrorLaunchOutOfResources = cyruntime.cudaError.cudaErrorLaunchOutOfResources

    #: This indicates that the device kernel took too long to execute. This
    #: can only occur if timeouts are enabled - see the device attribute
    #: :py:obj:`~.cudaDevAttrKernelExecTimeout` for more information. This
    #: leaves the process in an inconsistent state and any further CUDA
    #: work will return the same error. To continue using CUDA, the process
    #: must be terminated and relaunched.
    cudaErrorLaunchTimeout = cyruntime.cudaError.cudaErrorLaunchTimeout

    #: This error indicates a kernel launch that uses an incompatible
    #: texturing mode.
    cudaErrorLaunchIncompatibleTexturing = cyruntime.cudaError.cudaErrorLaunchIncompatibleTexturing

    #: This error indicates that a call to
    #: :py:obj:`~.cudaDeviceEnablePeerAccess()` is trying to re-enable peer
    #: addressing on from a context which has already had peer addressing
    #: enabled.
    cudaErrorPeerAccessAlreadyEnabled = cyruntime.cudaError.cudaErrorPeerAccessAlreadyEnabled

    #: This error indicates that :py:obj:`~.cudaDeviceDisablePeerAccess()`
    #: is trying to disable peer addressing which has not been enabled yet
    #: via :py:obj:`~.cudaDeviceEnablePeerAccess()`.
    cudaErrorPeerAccessNotEnabled = cyruntime.cudaError.cudaErrorPeerAccessNotEnabled

    #: This indicates that the user has called
    #: :py:obj:`~.cudaSetValidDevices()`, :py:obj:`~.cudaSetDeviceFlags()`,
    #: :py:obj:`~.cudaD3D9SetDirect3DDevice()`,
    #: :py:obj:`~.cudaD3D10SetDirect3DDevice`,
    #: :py:obj:`~.cudaD3D11SetDirect3DDevice()`, or
    #: :py:obj:`~.cudaVDPAUSetVDPAUDevice()` after initializing the CUDA
    #: runtime by calling non-device management operations (allocating
    #: memory and launching kernels are examples of non-device management
    #: operations). This error can also be returned if using runtime/driver
    #: interoperability and there is an existing :py:obj:`~.CUcontext`
    #: active on the host thread.
    cudaErrorSetOnActiveProcess = cyruntime.cudaError.cudaErrorSetOnActiveProcess

    #: This error indicates that the context current to the calling thread
    #: has been destroyed using :py:obj:`~.cuCtxDestroy`, or is a primary
    #: context which has not yet been initialized.
    cudaErrorContextIsDestroyed = cyruntime.cudaError.cudaErrorContextIsDestroyed

    #: An assert triggered in device code during kernel execution. The
    #: device cannot be used again. All existing allocations are invalid.
    #: To continue using CUDA, the process must be terminated and
    #: relaunched.
    cudaErrorAssert = cyruntime.cudaError.cudaErrorAssert

    #: This error indicates that the hardware resources required to enable
    #: peer access have been exhausted for one or more of the devices
    #: passed to :py:obj:`~.cudaEnablePeerAccess()`.
    cudaErrorTooManyPeers = cyruntime.cudaError.cudaErrorTooManyPeers

    #: This error indicates that the memory range passed to
    #: :py:obj:`~.cudaHostRegister()` has already been registered.
    cudaErrorHostMemoryAlreadyRegistered = cyruntime.cudaError.cudaErrorHostMemoryAlreadyRegistered

    #: This error indicates that the pointer passed to
    #: :py:obj:`~.cudaHostUnregister()` does not correspond to any
    #: currently registered memory region.
    cudaErrorHostMemoryNotRegistered = cyruntime.cudaError.cudaErrorHostMemoryNotRegistered

    #: Device encountered an error in the call stack during kernel
    #: execution, possibly due to stack corruption or exceeding the stack
    #: size limit. This leaves the process in an inconsistent state and any
    #: further CUDA work will return the same error. To continue using
    #: CUDA, the process must be terminated and relaunched.
    cudaErrorHardwareStackError = cyruntime.cudaError.cudaErrorHardwareStackError

    #: The device encountered an illegal instruction during kernel
    #: execution This leaves the process in an inconsistent state and any
    #: further CUDA work will return the same error. To continue using
    #: CUDA, the process must be terminated and relaunched.
    cudaErrorIllegalInstruction = cyruntime.cudaError.cudaErrorIllegalInstruction

    #: The device encountered a load or store instruction on a memory
    #: address which is not aligned. This leaves the process in an
    #: inconsistent state and any further CUDA work will return the same
    #: error. To continue using CUDA, the process must be terminated and
    #: relaunched.
    cudaErrorMisalignedAddress = cyruntime.cudaError.cudaErrorMisalignedAddress

    #: While executing a kernel, the device encountered an instruction
    #: which can only operate on memory locations in certain address spaces
    #: (global, shared, or local), but was supplied a memory address not
    #: belonging to an allowed address space. This leaves the process in an
    #: inconsistent state and any further CUDA work will return the same
    #: error. To continue using CUDA, the process must be terminated and
    #: relaunched.
    cudaErrorInvalidAddressSpace = cyruntime.cudaError.cudaErrorInvalidAddressSpace

    #: The device encountered an invalid program counter. This leaves the
    #: process in an inconsistent state and any further CUDA work will
    #: return the same error. To continue using CUDA, the process must be
    #: terminated and relaunched.
    cudaErrorInvalidPc = cyruntime.cudaError.cudaErrorInvalidPc

    #: An exception occurred on the device while executing a kernel. Common
    #: causes include dereferencing an invalid device pointer and accessing
    #: out of bounds shared memory. Less common cases can be system
    #: specific - more information about these cases can be found in the
    #: system specific user guide. This leaves the process in an
    #: inconsistent state and any further CUDA work will return the same
    #: error. To continue using CUDA, the process must be terminated and
    #: relaunched.
    cudaErrorLaunchFailure = cyruntime.cudaError.cudaErrorLaunchFailure

    #: This error indicates that the number of blocks launched per grid for
    #: a kernel that was launched via either
    #: :py:obj:`~.cudaLaunchCooperativeKernel` exceeds the maximum number
    #: of blocks as allowed by
    #: :py:obj:`~.cudaOccupancyMaxActiveBlocksPerMultiprocessor` or
    #: :py:obj:`~.cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags`
    #: times the number of multiprocessors as specified by the device
    #: attribute :py:obj:`~.cudaDevAttrMultiProcessorCount`.
    cudaErrorCooperativeLaunchTooLarge = cyruntime.cudaError.cudaErrorCooperativeLaunchTooLarge

    #: An exception occurred on the device while exiting a kernel using
    #: tensor memory: the tensor memory was not completely deallocated.
    #: This leaves the process in an inconsistent state and any further
    #: CUDA work will return the same error. To continue using CUDA, the
    #: process must be terminated and relaunched.
    cudaErrorTensorMemoryLeak = cyruntime.cudaError.cudaErrorTensorMemoryLeak

    #: This error indicates the attempted operation is not permitted.
    cudaErrorNotPermitted = cyruntime.cudaError.cudaErrorNotPermitted

    #: This error indicates the attempted operation is not supported on the
    #: current system or device.
    cudaErrorNotSupported = cyruntime.cudaError.cudaErrorNotSupported

    #: This error indicates that the system is not yet ready to start any
    #: CUDA work. To continue using CUDA, verify the system configuration
    #: is in a valid state and all required driver daemons are actively
    #: running. More information about this error can be found in the
    #: system specific user guide.
    cudaErrorSystemNotReady = cyruntime.cudaError.cudaErrorSystemNotReady

    #: This error indicates that there is a mismatch between the versions
    #: of the display driver and the CUDA driver. Refer to the
    #: compatibility documentation for supported versions.
    cudaErrorSystemDriverMismatch = cyruntime.cudaError.cudaErrorSystemDriverMismatch

    #: This error indicates that the system was upgraded to run with
    #: forward compatibility but the visible hardware detected by CUDA does
    #: not support this configuration. Refer to the compatibility
    #: documentation for the supported hardware matrix or ensure that only
    #: supported hardware is visible during initialization via the
    #: CUDA_VISIBLE_DEVICES environment variable.
    cudaErrorCompatNotSupportedOnDevice = cyruntime.cudaError.cudaErrorCompatNotSupportedOnDevice

    #: This error indicates that the MPS client failed to connect to the
    #: MPS control daemon or the MPS server.
    cudaErrorMpsConnectionFailed = cyruntime.cudaError.cudaErrorMpsConnectionFailed

    #: This error indicates that the remote procedural call between the MPS
    #: server and the MPS client failed.
    cudaErrorMpsRpcFailure = cyruntime.cudaError.cudaErrorMpsRpcFailure

    #: This error indicates that the MPS server is not ready to accept new
    #: MPS client requests. This error can be returned when the MPS server
    #: is in the process of recovering from a fatal failure.
    cudaErrorMpsServerNotReady = cyruntime.cudaError.cudaErrorMpsServerNotReady

    #: This error indicates that the hardware resources required to create
    #: MPS client have been exhausted.
    cudaErrorMpsMaxClientsReached = cyruntime.cudaError.cudaErrorMpsMaxClientsReached

    #: This error indicates the the hardware resources required to device
    #: connections have been exhausted.
    cudaErrorMpsMaxConnectionsReached = cyruntime.cudaError.cudaErrorMpsMaxConnectionsReached

    #: This error indicates that the MPS client has been terminated by the
    #: server. To continue using CUDA, the process must be terminated and
    #: relaunched.
    cudaErrorMpsClientTerminated = cyruntime.cudaError.cudaErrorMpsClientTerminated

    #: This error indicates, that the program is using CUDA Dynamic
    #: Parallelism, but the current configuration, like MPS, does not
    #: support it.
    cudaErrorCdpNotSupported = cyruntime.cudaError.cudaErrorCdpNotSupported

    #: This error indicates, that the program contains an unsupported
    #: interaction between different versions of CUDA Dynamic Parallelism.
    cudaErrorCdpVersionMismatch = cyruntime.cudaError.cudaErrorCdpVersionMismatch

    #: The operation is not permitted when the stream is capturing.
    cudaErrorStreamCaptureUnsupported = cyruntime.cudaError.cudaErrorStreamCaptureUnsupported

    #: The current capture sequence on the stream has been invalidated due
    #: to a previous error.
    cudaErrorStreamCaptureInvalidated = cyruntime.cudaError.cudaErrorStreamCaptureInvalidated

    #: The operation would have resulted in a merge of two independent
    #: capture sequences.
    cudaErrorStreamCaptureMerge = cyruntime.cudaError.cudaErrorStreamCaptureMerge

    #: The capture was not initiated in this stream.
    cudaErrorStreamCaptureUnmatched = cyruntime.cudaError.cudaErrorStreamCaptureUnmatched

    #: The capture sequence contains a fork that was not joined to the
    #: primary stream.
    cudaErrorStreamCaptureUnjoined = cyruntime.cudaError.cudaErrorStreamCaptureUnjoined

    #: A dependency would have been created which crosses the capture
    #: sequence boundary. Only implicit in-stream ordering dependencies are
    #: allowed to cross the boundary.
    cudaErrorStreamCaptureIsolation = cyruntime.cudaError.cudaErrorStreamCaptureIsolation

    #: The operation would have resulted in a disallowed implicit
    #: dependency on a current capture sequence from cudaStreamLegacy.
    cudaErrorStreamCaptureImplicit = cyruntime.cudaError.cudaErrorStreamCaptureImplicit

    #: The operation is not permitted on an event which was last recorded
    #: in a capturing stream.
    cudaErrorCapturedEvent = cyruntime.cudaError.cudaErrorCapturedEvent

    #: A stream capture sequence not initiated with the
    #: :py:obj:`~.cudaStreamCaptureModeRelaxed` argument to
    #: :py:obj:`~.cudaStreamBeginCapture` was passed to
    #: :py:obj:`~.cudaStreamEndCapture` in a different thread.
    cudaErrorStreamCaptureWrongThread = cyruntime.cudaError.cudaErrorStreamCaptureWrongThread

    #: This indicates that the wait operation has timed out.
    cudaErrorTimeout = cyruntime.cudaError.cudaErrorTimeout

    #: This error indicates that the graph update was not performed because
    #: it included changes which violated constraints specific to
    #: instantiated graph update.
    cudaErrorGraphExecUpdateFailure = cyruntime.cudaError.cudaErrorGraphExecUpdateFailure

    #: This indicates that an async error has occurred in a device outside
    #: of CUDA. If CUDA was waiting for an external device's signal before
    #: consuming shared data, the external device signaled an error
    #: indicating that the data is not valid for consumption. This leaves
    #: the process in an inconsistent state and any further CUDA work will
    #: return the same error. To continue using CUDA, the process must be
    #: terminated and relaunched.
    cudaErrorExternalDevice = cyruntime.cudaError.cudaErrorExternalDevice

    #: This indicates that a kernel launch error has occurred due to
    #: cluster misconfiguration.
    cudaErrorInvalidClusterSize = cyruntime.cudaError.cudaErrorInvalidClusterSize

    #: Indiciates a function handle is not loaded when calling an API that
    #: requires a loaded function.
    cudaErrorFunctionNotLoaded = cyruntime.cudaError.cudaErrorFunctionNotLoaded

    #: This error indicates one or more resources passed in are not valid
    #: resource types for the operation.
    cudaErrorInvalidResourceType = cyruntime.cudaError.cudaErrorInvalidResourceType

    #: This error indicates one or more resources are insufficient or non-
    #: applicable for the operation.
    cudaErrorInvalidResourceConfiguration = cyruntime.cudaError.cudaErrorInvalidResourceConfiguration

    #: This error indicates that the requested operation is not permitted
    #: because the stream is in a detached state. This can occur if the
    #: green context associated with the stream has been destroyed,
    #: limiting the stream's operational capabilities.
    cudaErrorStreamDetached = cyruntime.cudaError.cudaErrorStreamDetached

    #: This indicates that an unknown internal error has occurred.
    cudaErrorUnknown = cyruntime.cudaError.cudaErrorUnknown
    cudaErrorApiFailureBase = cyruntime.cudaError.cudaErrorApiFailureBase

_dict_cudaError_t = dict(((int(v), v) for k, v in cudaError_t.__members__.items()))

class cudaGraphDependencyType(IntEnum):
    """
    Type annotations that can be applied to graph edges as part of
    :py:obj:`~.cudaGraphEdgeData`.
    """

    #: This is an ordinary dependency.
    cudaGraphDependencyTypeDefault = cyruntime.cudaGraphDependencyType_enum.cudaGraphDependencyTypeDefault

    #: This dependency type allows the downstream node to use
    #: `cudaGridDependencySynchronize()`. It may only be used between
    #: kernel nodes, and must be used with either the
    #: :py:obj:`~.cudaGraphKernelNodePortProgrammatic` or
    #: :py:obj:`~.cudaGraphKernelNodePortLaunchCompletion` outgoing port.
    cudaGraphDependencyTypeProgrammatic = cyruntime.cudaGraphDependencyType_enum.cudaGraphDependencyTypeProgrammatic

_dict_cudaGraphDependencyType = dict(((int(v), v) for k, v in cudaGraphDependencyType.__members__.items()))

class cudaGraphInstantiateResult(IntEnum):
    """
    Graph instantiation results
    """

    #: Instantiation succeeded
    cudaGraphInstantiateSuccess = cyruntime.cudaGraphInstantiateResult.cudaGraphInstantiateSuccess

    #: Instantiation failed for an unexpected reason which is described in
    #: the return value of the function
    cudaGraphInstantiateError = cyruntime.cudaGraphInstantiateResult.cudaGraphInstantiateError

    #: Instantiation failed due to invalid structure, such as cycles
    cudaGraphInstantiateInvalidStructure = cyruntime.cudaGraphInstantiateResult.cudaGraphInstantiateInvalidStructure

    #: Instantiation for device launch failed because the graph contained
    #: an unsupported operation
    cudaGraphInstantiateNodeOperationNotSupported = cyruntime.cudaGraphInstantiateResult.cudaGraphInstantiateNodeOperationNotSupported

    #: Instantiation for device launch failed due to the nodes belonging to
    #: different contexts
    cudaGraphInstantiateMultipleDevicesNotSupported = cyruntime.cudaGraphInstantiateResult.cudaGraphInstantiateMultipleDevicesNotSupported

    #: One or more conditional handles are not associated with conditional
    #: nodes
    cudaGraphInstantiateConditionalHandleUnused = cyruntime.cudaGraphInstantiateResult.cudaGraphInstantiateConditionalHandleUnused

_dict_cudaGraphInstantiateResult = dict(((int(v), v) for k, v in cudaGraphInstantiateResult.__members__.items()))

class cudaLaunchMemSyncDomain(IntEnum):
    """
    Memory Synchronization Domain  A kernel can be launched in a
    specified memory synchronization domain that affects all memory
    operations issued by that kernel. A memory barrier issued in one
    domain will only order memory operations in that domain, thus
    eliminating latency increase from memory barriers ordering
    unrelated traffic.  By default, kernels are launched in domain 0.
    Kernel launched with :py:obj:`~.cudaLaunchMemSyncDomainRemote` will
    have a different domain ID. User may also alter the domain ID with
    :py:obj:`~.cudaLaunchMemSyncDomainMap` for a specific stream /
    graph node / kernel launch. See
    :py:obj:`~.cudaLaunchAttributeMemSyncDomain`,
    :py:obj:`~.cudaStreamSetAttribute`, :py:obj:`~.cudaLaunchKernelEx`,
    :py:obj:`~.cudaGraphKernelNodeSetAttribute`.  Memory operations
    done in kernels launched in different domains are considered
    system-scope distanced. In other words, a GPU scoped memory
    synchronization is not sufficient for memory order to be observed
    by kernels in another memory synchronization domain even if they
    are on the same GPU.
    """

    #: Launch kernels in the default domain
    cudaLaunchMemSyncDomainDefault = cyruntime.cudaLaunchMemSyncDomain.cudaLaunchMemSyncDomainDefault

    #: Launch kernels in the remote domain
    cudaLaunchMemSyncDomainRemote = cyruntime.cudaLaunchMemSyncDomain.cudaLaunchMemSyncDomainRemote

_dict_cudaLaunchMemSyncDomain = dict(((int(v), v) for k, v in cudaLaunchMemSyncDomain.__members__.items()))

class cudaLaunchAttributeID(IntEnum):
    """
    Launch attributes enum; used as id field of
    :py:obj:`~.cudaLaunchAttribute`
    """

    #: Ignored entry, for convenient composition
    cudaLaunchAttributeIgnore = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeIgnore

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.accessPolicyWindow`.
    cudaLaunchAttributeAccessPolicyWindow = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeAccessPolicyWindow

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.cooperative`.
    cudaLaunchAttributeCooperative = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeCooperative

    #: Valid for streams. See
    #: :py:obj:`~.cudaLaunchAttributeValue.syncPolicy`.
    cudaLaunchAttributeSynchronizationPolicy = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeSynchronizationPolicy

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.clusterDim`.
    cudaLaunchAttributeClusterDimension = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeClusterDimension

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.clusterSchedulingPolicyPreference`.
    cudaLaunchAttributeClusterSchedulingPolicyPreference = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeClusterSchedulingPolicyPreference

    #: Valid for launches. Setting
    #: :py:obj:`~.cudaLaunchAttributeValue.programmaticStreamSerializationAllowed`
    #: to non-0 signals that the kernel will use programmatic means to
    #: resolve its stream dependency, so that the CUDA runtime should
    #: opportunistically allow the grid's execution to overlap with the
    #: previous kernel in the stream, if that kernel requests the overlap.
    #: The dependent launches can choose to wait on the dependency using
    #: the programmatic sync (cudaGridDependencySynchronize() or equivalent
    #: PTX instructions).
    cudaLaunchAttributeProgrammaticStreamSerialization = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeProgrammaticStreamSerialization

    #: Valid for launches. Set
    #: :py:obj:`~.cudaLaunchAttributeValue.programmaticEvent` to record the
    #: event. Event recorded through this launch attribute is guaranteed to
    #: only trigger after all block in the associated kernel trigger the
    #: event. A block can trigger the event programmatically in a future
    #: CUDA release. A trigger can also be inserted at the beginning of
    #: each block's execution if triggerAtBlockStart is set to non-0. The
    #: dependent launches can choose to wait on the dependency using the
    #: programmatic sync (cudaGridDependencySynchronize() or equivalent PTX
    #: instructions). Note that dependents (including the CPU thread
    #: calling :py:obj:`~.cudaEventSynchronize()`) are not guaranteed to
    #: observe the release precisely when it is released. For example,
    #: :py:obj:`~.cudaEventSynchronize()` may only observe the event
    #: trigger long after the associated kernel has completed. This
    #: recording type is primarily meant for establishing programmatic
    #: dependency between device tasks. Note also this type of dependency
    #: allows, but does not guarantee, concurrent execution of tasks.
    #:  The event supplied must not be an interprocess or interop event.
    #: The event must disable timing (i.e. must be created with the
    #: :py:obj:`~.cudaEventDisableTiming` flag set).
    cudaLaunchAttributeProgrammaticEvent = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeProgrammaticEvent

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.priority`.
    cudaLaunchAttributePriority = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributePriority

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.memSyncDomainMap`.
    cudaLaunchAttributeMemSyncDomainMap = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeMemSyncDomainMap

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.memSyncDomain`.
    cudaLaunchAttributeMemSyncDomain = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeMemSyncDomain

    #: Valid for graph nodes and launches. Set
    #: :py:obj:`~.cudaLaunchAttributeValue.preferredClusterDim` to allow
    #: the kernel launch to specify a preferred substitute cluster
    #: dimension. Blocks may be grouped according to either the dimensions
    #: specified with this attribute (grouped into a "preferred substitute
    #: cluster"), or the one specified with
    #: :py:obj:`~.cudaLaunchAttributeClusterDimension` attribute (grouped
    #: into a "regular cluster"). The cluster dimensions of a "preferred
    #: substitute cluster" shall be an integer multiple greater than zero
    #: of the regular cluster dimensions. The device will attempt - on a
    #: best-effort basis - to group thread blocks into preferred clusters
    #: over grouping them into regular clusters. When it deems necessary
    #: (primarily when the device temporarily runs out of physical
    #: resources to launch the larger preferred clusters), the device may
    #: switch to launch the regular clusters instead to attempt to utilize
    #: as much of the physical device resources as possible.
    #:  Each type of cluster will have its enumeration / coordinate setup
    #: as if the grid consists solely of its type of cluster. For example,
    #: if the preferred substitute cluster dimensions double the regular
    #: cluster dimensions, there might be simultaneously a regular cluster
    #: indexed at (1,0,0), and a preferred cluster indexed at (1,0,0). In
    #: this example, the preferred substitute cluster (1,0,0) replaces
    #: regular clusters (2,0,0) and (3,0,0) and groups their blocks.
    #:  This attribute will only take effect when a regular cluster
    #: dimension has been specified. The preferred substitute cluster
    #: dimension must be an integer multiple greater than zero of the
    #: regular cluster dimension and must divide the grid. It must also be
    #: no more than `maxBlocksPerCluster`, if it is set in the kernel's
    #: `__launch_bounds__`. Otherwise it must be less than the maximum
    #: value the driver can support. Otherwise, setting this attribute to a
    #: value physically unable to fit on any particular device is
    #: permitted.
    cudaLaunchAttributePreferredClusterDimension = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributePreferredClusterDimension

    #: Valid for launches. Set
    #: :py:obj:`~.cudaLaunchAttributeValue.launchCompletionEvent` to record
    #: the event.
    #:  Nominally, the event is triggered once all blocks of the kernel
    #: have begun execution. Currently this is a best effort. If a kernel B
    #: has a launch completion dependency on a kernel A, B may wait until A
    #: is complete. Alternatively, blocks of B may begin before all blocks
    #: of A have begun, for example if B can claim execution resources
    #: unavailable to A (e.g. they run on different GPUs) or if B is a
    #: higher priority than A. Exercise caution if such an ordering
    #: inversion could lead to deadlock.
    #:  A launch completion event is nominally similar to a programmatic
    #: event with `triggerAtBlockStart` set except that it is not visible
    #: to `cudaGridDependencySynchronize()` and can be used with compute
    #: capability less than 9.0.
    #:  The event supplied must not be an interprocess or interop event.
    #: The event must disable timing (i.e. must be created with the
    #: :py:obj:`~.cudaEventDisableTiming` flag set).
    cudaLaunchAttributeLaunchCompletionEvent = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeLaunchCompletionEvent

    #: Valid for graph nodes, launches. This attribute is graphs-only, and
    #: passing it to a launch in a non-capturing stream will result in an
    #: error.
    #: :cudaLaunchAttributeValue::deviceUpdatableKernelNode::deviceUpdatable
    #: can only be set to 0 or 1. Setting the field to 1 indicates that the
    #: corresponding kernel node should be device-updatable. On success, a
    #: handle will be returned via
    #: :py:obj:`~.cudaLaunchAttributeValue`::deviceUpdatableKernelNode::devNode
    #: which can be passed to the various device-side update functions to
    #: update the node's kernel parameters from within another kernel. For
    #: more information on the types of device updates that can be made, as
    #: well as the relevant limitations thereof, see
    #: :py:obj:`~.cudaGraphKernelNodeUpdatesApply`.
    #:  Nodes which are device-updatable have additional restrictions
    #: compared to regular kernel nodes. Firstly, device-updatable nodes
    #: cannot be removed from their graph via
    #: :py:obj:`~.cudaGraphDestroyNode`. Additionally, once opted-in to
    #: this functionality, a node cannot opt out, and any attempt to set
    #: the deviceUpdatable attribute to 0 will result in an error. Device-
    #: updatable kernel nodes also cannot have their attributes copied
    #: to/from another kernel node via
    #: :py:obj:`~.cudaGraphKernelNodeCopyAttributes`. Graphs containing one
    #: or more device-updatable nodes also do not allow multiple
    #: instantiation, and neither the graph nor its instantiated version
    #: can be passed to :py:obj:`~.cudaGraphExecUpdate`.
    #:  If a graph contains device-updatable nodes and updates those nodes
    #: from the device from within the graph, the graph must be uploaded
    #: with :py:obj:`~.cuGraphUpload` before it is launched. For such a
    #: graph, if host-side executable graph updates are made to the device-
    #: updatable nodes, the graph must be uploaded before it is launched
    #: again.
    cudaLaunchAttributeDeviceUpdatableKernelNode = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeDeviceUpdatableKernelNode

    #: Valid for launches. On devices where the L1 cache and shared memory
    #: use the same hardware resources, setting
    #: :py:obj:`~.cudaLaunchAttributeValue.sharedMemCarveout` to a
    #: percentage between 0-100 signals sets the shared memory carveout
    #: preference in percent of the total shared memory for that kernel
    #: launch. This attribute takes precedence over
    #: :py:obj:`~.cudaFuncAttributePreferredSharedMemoryCarveout`. This is
    #: only a hint, and the driver can choose a different configuration if
    #: required for the launch.
    cudaLaunchAttributePreferredSharedMemoryCarveout = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributePreferredSharedMemoryCarveout

    #: Valid for streams, graph nodes, launches. This attribute is a hint
    #: to the CUDA runtime that the launch should attempt to make the
    #: kernel maximize its NVLINK utilization.
    #:
    #:  When possible to honor this hint, CUDA will assume each block in
    #: the grid launch will carry out an even amount of NVLINK traffic, and
    #: make a best-effort attempt to adjust the kernel launch based on that
    #: assumption.
    #:  This attribute is a hint only. CUDA makes no functional or
    #: performance guarantee. Its applicability can be affected by many
    #: different factors, including driver version (i.e. CUDA doesn't
    #: guarantee the performance characteristics will be maintained between
    #: driver versions or a driver update could alter or regress previously
    #: observed perf characteristics.) It also doesn't guarantee a
    #: successful result, i.e. applying the attribute may not improve the
    #: performance of either the targeted kernel or the encapsulating
    #: application.
    #:  Valid values for
    #: :py:obj:`~.cudaLaunchAttributeValue.nvlinkUtilCentricScheduling` are
    #: 0 (disabled) and 1 (enabled).
    cudaLaunchAttributeNvlinkUtilCentricScheduling = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeNvlinkUtilCentricScheduling

_dict_cudaLaunchAttributeID = dict(((int(v), v) for k, v in cudaLaunchAttributeID.__members__.items()))

class cudaAsyncNotificationType(IntEnum):
    """
    Types of async notification that can occur
    """

    #: Sent when the process has exceeded its device memory budget
    cudaAsyncNotificationTypeOverBudget = cyruntime.cudaAsyncNotificationType_enum.cudaAsyncNotificationTypeOverBudget

_dict_cudaAsyncNotificationType = dict(((int(v), v) for k, v in cudaAsyncNotificationType.__members__.items()))

class cudaLogLevel(IntEnum):
    """

    """
    cudaLogLevelError = cyruntime.CUDAlogLevel_enum.cudaLogLevelError
    cudaLogLevelWarning = cyruntime.CUDAlogLevel_enum.cudaLogLevelWarning

_dict_cudaLogLevel = dict(((int(v), v) for k, v in cudaLogLevel.__members__.items()))

class cudaDataType(IntEnum):
    """"""
    CUDA_R_32F = cyruntime.cudaDataType_t.CUDA_R_32F
    CUDA_R_64F = cyruntime.cudaDataType_t.CUDA_R_64F
    CUDA_R_16F = cyruntime.cudaDataType_t.CUDA_R_16F
    CUDA_R_8I = cyruntime.cudaDataType_t.CUDA_R_8I
    CUDA_C_32F = cyruntime.cudaDataType_t.CUDA_C_32F
    CUDA_C_64F = cyruntime.cudaDataType_t.CUDA_C_64F
    CUDA_C_16F = cyruntime.cudaDataType_t.CUDA_C_16F
    CUDA_C_8I = cyruntime.cudaDataType_t.CUDA_C_8I
    CUDA_R_8U = cyruntime.cudaDataType_t.CUDA_R_8U
    CUDA_C_8U = cyruntime.cudaDataType_t.CUDA_C_8U
    CUDA_R_32I = cyruntime.cudaDataType_t.CUDA_R_32I
    CUDA_C_32I = cyruntime.cudaDataType_t.CUDA_C_32I
    CUDA_R_32U = cyruntime.cudaDataType_t.CUDA_R_32U
    CUDA_C_32U = cyruntime.cudaDataType_t.CUDA_C_32U
    CUDA_R_16BF = cyruntime.cudaDataType_t.CUDA_R_16BF
    CUDA_C_16BF = cyruntime.cudaDataType_t.CUDA_C_16BF
    CUDA_R_4I = cyruntime.cudaDataType_t.CUDA_R_4I
    CUDA_C_4I = cyruntime.cudaDataType_t.CUDA_C_4I
    CUDA_R_4U = cyruntime.cudaDataType_t.CUDA_R_4U
    CUDA_C_4U = cyruntime.cudaDataType_t.CUDA_C_4U
    CUDA_R_16I = cyruntime.cudaDataType_t.CUDA_R_16I
    CUDA_C_16I = cyruntime.cudaDataType_t.CUDA_C_16I
    CUDA_R_16U = cyruntime.cudaDataType_t.CUDA_R_16U
    CUDA_C_16U = cyruntime.cudaDataType_t.CUDA_C_16U
    CUDA_R_64I = cyruntime.cudaDataType_t.CUDA_R_64I
    CUDA_C_64I = cyruntime.cudaDataType_t.CUDA_C_64I
    CUDA_R_64U = cyruntime.cudaDataType_t.CUDA_R_64U
    CUDA_C_64U = cyruntime.cudaDataType_t.CUDA_C_64U
    CUDA_R_8F_E4M3 = cyruntime.cudaDataType_t.CUDA_R_8F_E4M3
    CUDA_R_8F_UE4M3 = cyruntime.cudaDataType_t.CUDA_R_8F_UE4M3
    CUDA_R_8F_E5M2 = cyruntime.cudaDataType_t.CUDA_R_8F_E5M2
    CUDA_R_8F_UE8M0 = cyruntime.cudaDataType_t.CUDA_R_8F_UE8M0
    CUDA_R_6F_E2M3 = cyruntime.cudaDataType_t.CUDA_R_6F_E2M3
    CUDA_R_6F_E3M2 = cyruntime.cudaDataType_t.CUDA_R_6F_E3M2
    CUDA_R_4F_E2M1 = cyruntime.cudaDataType_t.CUDA_R_4F_E2M1

_dict_cudaDataType = dict(((int(v), v) for k, v in cudaDataType.__members__.items()))

class cudaEmulationStrategy(IntEnum):
    """"""
    CUDA_EMULATION_STRATEGY_DEFAULT = cyruntime.cudaEmulationStrategy_t.CUDA_EMULATION_STRATEGY_DEFAULT
    CUDA_EMULATION_STRATEGY_PERFORMANT = cyruntime.cudaEmulationStrategy_t.CUDA_EMULATION_STRATEGY_PERFORMANT
    CUDA_EMULATION_STRATEGY_EAGER = cyruntime.cudaEmulationStrategy_t.CUDA_EMULATION_STRATEGY_EAGER

_dict_cudaEmulationStrategy = dict(((int(v), v) for k, v in cudaEmulationStrategy.__members__.items()))

class cudaEmulationMantissaControl(IntEnum):
    """"""
    CUDA_EMULATION_MANTISSA_CONTROL_DYNAMIC = cyruntime.cudaEmulationMantissaControl_t.CUDA_EMULATION_MANTISSA_CONTROL_DYNAMIC
    CUDA_EMULATION_MANTISSA_CONTROL_FIXED = cyruntime.cudaEmulationMantissaControl_t.CUDA_EMULATION_MANTISSA_CONTROL_FIXED

_dict_cudaEmulationMantissaControl = dict(((int(v), v) for k, v in cudaEmulationMantissaControl.__members__.items()))

class cudaEmulationSpecialValuesSupport(IntEnum):
    """"""
    CUDA_EMULATION_SPECIAL_VALUES_SUPPORT_NONE = cyruntime.cudaEmulationSpecialValuesSupport_t.CUDA_EMULATION_SPECIAL_VALUES_SUPPORT_NONE
    CUDA_EMULATION_SPECIAL_VALUES_SUPPORT_INFINITY = cyruntime.cudaEmulationSpecialValuesSupport_t.CUDA_EMULATION_SPECIAL_VALUES_SUPPORT_INFINITY
    CUDA_EMULATION_SPECIAL_VALUES_SUPPORT_NAN = cyruntime.cudaEmulationSpecialValuesSupport_t.CUDA_EMULATION_SPECIAL_VALUES_SUPPORT_NAN
    CUDA_EMULATION_SPECIAL_VALUES_SUPPORT_DEFAULT = cyruntime.cudaEmulationSpecialValuesSupport_t.CUDA_EMULATION_SPECIAL_VALUES_SUPPORT_DEFAULT

_dict_cudaEmulationSpecialValuesSupport = dict(((int(v), v) for k, v in cudaEmulationSpecialValuesSupport.__members__.items()))

class libraryPropertyType(IntEnum):
    """"""
    MAJOR_VERSION = cyruntime.libraryPropertyType_t.MAJOR_VERSION
    MINOR_VERSION = cyruntime.libraryPropertyType_t.MINOR_VERSION
    PATCH_LEVEL = cyruntime.libraryPropertyType_t.PATCH_LEVEL

_dict_libraryPropertyType = dict(((int(v), v) for k, v in libraryPropertyType.__members__.items()))

class cudaEglFrameType(IntEnum):
    """
    CUDA EglFrame type - array or pointer
    """

    #: Frame type CUDA array
    cudaEglFrameTypeArray = cyruntime.cudaEglFrameType_enum.cudaEglFrameTypeArray

    #: Frame type CUDA pointer
    cudaEglFrameTypePitch = cyruntime.cudaEglFrameType_enum.cudaEglFrameTypePitch

_dict_cudaEglFrameType = dict(((int(v), v) for k, v in cudaEglFrameType.__members__.items()))

class cudaEglResourceLocationFlags(IntEnum):
    """
    Resource location flags- sysmem or vidmem  For CUDA context on
    iGPU, since video and system memory are equivalent - these flags
    will not have an effect on the execution.  For CUDA context on
    dGPU, applications can use the flag
    :py:obj:`~.cudaEglResourceLocationFlags` to give a hint about the
    desired location.  :py:obj:`~.cudaEglResourceLocationSysmem` - the
    frame data is made resident on the system memory to be accessed by
    CUDA.  :py:obj:`~.cudaEglResourceLocationVidmem` - the frame data
    is made resident on the dedicated video memory to be accessed by
    CUDA.  There may be an additional latency due to new allocation and
    data migration, if the frame is produced on a different memory.
    """

    #: Resource location sysmem
    cudaEglResourceLocationSysmem = cyruntime.cudaEglResourceLocationFlags_enum.cudaEglResourceLocationSysmem

    #: Resource location vidmem
    cudaEglResourceLocationVidmem = cyruntime.cudaEglResourceLocationFlags_enum.cudaEglResourceLocationVidmem

_dict_cudaEglResourceLocationFlags = dict(((int(v), v) for k, v in cudaEglResourceLocationFlags.__members__.items()))

class cudaEglColorFormat(IntEnum):
    """
    CUDA EGL Color Format - The different planar and multiplanar
    formats currently supported for CUDA_EGL interops.
    """

    #: Y, U, V in three surfaces, each in a separate surface, U/V width =
    #: 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatYUV420Planar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV420Planar

    #: Y, UV in two surfaces (UV as one surface) with VU byte ordering,
    #: width, height ratio same as YUV420Planar.
    cudaEglColorFormatYUV420SemiPlanar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV420SemiPlanar

    #: Y, U, V each in a separate surface, U/V width = 1/2 Y width, U/V
    #: height = Y height.
    cudaEglColorFormatYUV422Planar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV422Planar

    #: Y, UV in two surfaces with VU byte ordering, width, height ratio
    #: same as YUV422Planar.
    cudaEglColorFormatYUV422SemiPlanar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV422SemiPlanar

    #: R/G/B/A four channels in one surface with BGRA byte ordering.
    cudaEglColorFormatARGB = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatARGB

    #: R/G/B/A four channels in one surface with ABGR byte ordering.
    cudaEglColorFormatRGBA = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatRGBA

    #: single luminance channel in one surface.
    cudaEglColorFormatL = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatL

    #: single color channel in one surface.
    cudaEglColorFormatR = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatR

    #: Y, U, V in three surfaces, each in a separate surface, U/V width = Y
    #: width, U/V height = Y height.
    cudaEglColorFormatYUV444Planar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV444Planar

    #: Y, UV in two surfaces (UV as one surface) with VU byte ordering,
    #: width, height ratio same as YUV444Planar.
    cudaEglColorFormatYUV444SemiPlanar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV444SemiPlanar

    #: Y, U, V in one surface, interleaved as UYVY in one channel.
    cudaEglColorFormatYUYV422 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUYV422

    #: Y, U, V in one surface, interleaved as YUYV in one channel.
    cudaEglColorFormatUYVY422 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatUYVY422

    #: R/G/B/A four channels in one surface with RGBA byte ordering.
    cudaEglColorFormatABGR = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatABGR

    #: R/G/B/A four channels in one surface with ARGB byte ordering.
    cudaEglColorFormatBGRA = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBGRA

    #: Alpha color format - one channel in one surface.
    cudaEglColorFormatA = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatA

    #: R/G color format - two channels in one surface with GR byte ordering
    cudaEglColorFormatRG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatRG

    #: Y, U, V, A four channels in one surface, interleaved as VUYA.
    cudaEglColorFormatAYUV = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatAYUV

    #: Y, VU in two surfaces (VU as one surface) with UV byte ordering, U/V
    #: width = Y width, U/V height = Y height.
    cudaEglColorFormatYVU444SemiPlanar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU444SemiPlanar

    #: Y, VU in two surfaces (VU as one surface) with UV byte ordering, U/V
    #: width = 1/2 Y width, U/V height = Y height.
    cudaEglColorFormatYVU422SemiPlanar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU422SemiPlanar

    #: Y, VU in two surfaces (VU as one surface) with UV byte ordering, U/V
    #: width = 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatYVU420SemiPlanar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU420SemiPlanar

    #: Y10, V10U10 in two surfaces (VU as one surface) with UV byte
    #: ordering, U/V width = Y width, U/V height = Y height.
    cudaEglColorFormatY10V10U10_444SemiPlanar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10V10U10_444SemiPlanar

    #: Y10, V10U10 in two surfaces (VU as one surface) with UV byte
    #: ordering, U/V width = 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatY10V10U10_420SemiPlanar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10V10U10_420SemiPlanar

    #: Y12, V12U12 in two surfaces (VU as one surface) with UV byte
    #: ordering, U/V width = Y width, U/V height = Y height.
    cudaEglColorFormatY12V12U12_444SemiPlanar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY12V12U12_444SemiPlanar

    #: Y12, V12U12 in two surfaces (VU as one surface) with UV byte
    #: ordering, U/V width = 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatY12V12U12_420SemiPlanar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY12V12U12_420SemiPlanar

    #: Extended Range Y, U, V in one surface, interleaved as YVYU in one
    #: channel.
    cudaEglColorFormatVYUY_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatVYUY_ER

    #: Extended Range Y, U, V in one surface, interleaved as YUYV in one
    #: channel.
    cudaEglColorFormatUYVY_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatUYVY_ER

    #: Extended Range Y, U, V in one surface, interleaved as UYVY in one
    #: channel.
    cudaEglColorFormatYUYV_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUYV_ER

    #: Extended Range Y, U, V in one surface, interleaved as VYUY in one
    #: channel.
    cudaEglColorFormatYVYU_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVYU_ER

    #: Extended Range Y, U, V, A four channels in one surface, interleaved
    #: as AVUY.
    cudaEglColorFormatYUVA_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUVA_ER

    #: Extended Range Y, U, V, A four channels in one surface, interleaved
    #: as VUYA.
    cudaEglColorFormatAYUV_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatAYUV_ER

    #: Extended Range Y, U, V in three surfaces, U/V width = Y width, U/V
    #: height = Y height.
    cudaEglColorFormatYUV444Planar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV444Planar_ER

    #: Extended Range Y, U, V in three surfaces, U/V width = 1/2 Y width,
    #: U/V height = Y height.
    cudaEglColorFormatYUV422Planar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV422Planar_ER

    #: Extended Range Y, U, V in three surfaces, U/V width = 1/2 Y width,
    #: U/V height = 1/2 Y height.
    cudaEglColorFormatYUV420Planar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV420Planar_ER

    #: Extended Range Y, UV in two surfaces (UV as one surface) with VU
    #: byte ordering, U/V width = Y width, U/V height = Y height.
    cudaEglColorFormatYUV444SemiPlanar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV444SemiPlanar_ER

    #: Extended Range Y, UV in two surfaces (UV as one surface) with VU
    #: byte ordering, U/V width = 1/2 Y width, U/V height = Y height.
    cudaEglColorFormatYUV422SemiPlanar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV422SemiPlanar_ER

    #: Extended Range Y, UV in two surfaces (UV as one surface) with VU
    #: byte ordering, U/V width = 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatYUV420SemiPlanar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV420SemiPlanar_ER

    #: Extended Range Y, V, U in three surfaces, U/V width = Y width, U/V
    #: height = Y height.
    cudaEglColorFormatYVU444Planar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU444Planar_ER

    #: Extended Range Y, V, U in three surfaces, U/V width = 1/2 Y width,
    #: U/V height = Y height.
    cudaEglColorFormatYVU422Planar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU422Planar_ER

    #: Extended Range Y, V, U in three surfaces, U/V width = 1/2 Y width,
    #: U/V height = 1/2 Y height.
    cudaEglColorFormatYVU420Planar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU420Planar_ER

    #: Extended Range Y, VU in two surfaces (VU as one surface) with UV
    #: byte ordering, U/V width = Y width, U/V height = Y height.
    cudaEglColorFormatYVU444SemiPlanar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU444SemiPlanar_ER

    #: Extended Range Y, VU in two surfaces (VU as one surface) with UV
    #: byte ordering, U/V width = 1/2 Y width, U/V height = Y height.
    cudaEglColorFormatYVU422SemiPlanar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU422SemiPlanar_ER

    #: Extended Range Y, VU in two surfaces (VU as one surface) with UV
    #: byte ordering, U/V width = 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatYVU420SemiPlanar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU420SemiPlanar_ER

    #: Bayer format - one channel in one surface with interleaved RGGB
    #: ordering.
    cudaEglColorFormatBayerRGGB = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayerRGGB

    #: Bayer format - one channel in one surface with interleaved BGGR
    #: ordering.
    cudaEglColorFormatBayerBGGR = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayerBGGR

    #: Bayer format - one channel in one surface with interleaved GRBG
    #: ordering.
    cudaEglColorFormatBayerGRBG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayerGRBG

    #: Bayer format - one channel in one surface with interleaved GBRG
    #: ordering.
    cudaEglColorFormatBayerGBRG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayerGBRG

    #: Bayer10 format - one channel in one surface with interleaved RGGB
    #: ordering. Out of 16 bits, 10 bits used 6 bits No-op.
    cudaEglColorFormatBayer10RGGB = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer10RGGB

    #: Bayer10 format - one channel in one surface with interleaved BGGR
    #: ordering. Out of 16 bits, 10 bits used 6 bits No-op.
    cudaEglColorFormatBayer10BGGR = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer10BGGR

    #: Bayer10 format - one channel in one surface with interleaved GRBG
    #: ordering. Out of 16 bits, 10 bits used 6 bits No-op.
    cudaEglColorFormatBayer10GRBG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer10GRBG

    #: Bayer10 format - one channel in one surface with interleaved GBRG
    #: ordering. Out of 16 bits, 10 bits used 6 bits No-op.
    cudaEglColorFormatBayer10GBRG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer10GBRG

    #: Bayer12 format - one channel in one surface with interleaved RGGB
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    cudaEglColorFormatBayer12RGGB = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer12RGGB

    #: Bayer12 format - one channel in one surface with interleaved BGGR
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    cudaEglColorFormatBayer12BGGR = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer12BGGR

    #: Bayer12 format - one channel in one surface with interleaved GRBG
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    cudaEglColorFormatBayer12GRBG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer12GRBG

    #: Bayer12 format - one channel in one surface with interleaved GBRG
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    cudaEglColorFormatBayer12GBRG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer12GBRG

    #: Bayer14 format - one channel in one surface with interleaved RGGB
    #: ordering. Out of 16 bits, 14 bits used 2 bits No-op.
    cudaEglColorFormatBayer14RGGB = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer14RGGB

    #: Bayer14 format - one channel in one surface with interleaved BGGR
    #: ordering. Out of 16 bits, 14 bits used 2 bits No-op.
    cudaEglColorFormatBayer14BGGR = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer14BGGR

    #: Bayer14 format - one channel in one surface with interleaved GRBG
    #: ordering. Out of 16 bits, 14 bits used 2 bits No-op.
    cudaEglColorFormatBayer14GRBG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer14GRBG

    #: Bayer14 format - one channel in one surface with interleaved GBRG
    #: ordering. Out of 16 bits, 14 bits used 2 bits No-op.
    cudaEglColorFormatBayer14GBRG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer14GBRG

    #: Bayer20 format - one channel in one surface with interleaved RGGB
    #: ordering. Out of 32 bits, 20 bits used 12 bits No-op.
    cudaEglColorFormatBayer20RGGB = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer20RGGB

    #: Bayer20 format - one channel in one surface with interleaved BGGR
    #: ordering. Out of 32 bits, 20 bits used 12 bits No-op.
    cudaEglColorFormatBayer20BGGR = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer20BGGR

    #: Bayer20 format - one channel in one surface with interleaved GRBG
    #: ordering. Out of 32 bits, 20 bits used 12 bits No-op.
    cudaEglColorFormatBayer20GRBG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer20GRBG

    #: Bayer20 format - one channel in one surface with interleaved GBRG
    #: ordering. Out of 32 bits, 20 bits used 12 bits No-op.
    cudaEglColorFormatBayer20GBRG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer20GBRG

    #: Y, V, U in three surfaces, each in a separate surface, U/V width = Y
    #: width, U/V height = Y height.
    cudaEglColorFormatYVU444Planar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU444Planar

    #: Y, V, U in three surfaces, each in a separate surface, U/V width =
    #: 1/2 Y width, U/V height = Y height.
    cudaEglColorFormatYVU422Planar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU422Planar

    #: Y, V, U in three surfaces, each in a separate surface, U/V width =
    #: 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatYVU420Planar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU420Planar

    #: Nvidia proprietary Bayer ISP format - one channel in one surface
    #: with interleaved RGGB ordering and mapped to opaque integer
    #: datatype.
    cudaEglColorFormatBayerIspRGGB = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayerIspRGGB

    #: Nvidia proprietary Bayer ISP format - one channel in one surface
    #: with interleaved BGGR ordering and mapped to opaque integer
    #: datatype.
    cudaEglColorFormatBayerIspBGGR = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayerIspBGGR

    #: Nvidia proprietary Bayer ISP format - one channel in one surface
    #: with interleaved GRBG ordering and mapped to opaque integer
    #: datatype.
    cudaEglColorFormatBayerIspGRBG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayerIspGRBG

    #: Nvidia proprietary Bayer ISP format - one channel in one surface
    #: with interleaved GBRG ordering and mapped to opaque integer
    #: datatype.
    cudaEglColorFormatBayerIspGBRG = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayerIspGBRG

    #: Bayer format - one channel in one surface with interleaved BCCR
    #: ordering.
    cudaEglColorFormatBayerBCCR = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayerBCCR

    #: Bayer format - one channel in one surface with interleaved RCCB
    #: ordering.
    cudaEglColorFormatBayerRCCB = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayerRCCB

    #: Bayer format - one channel in one surface with interleaved CRBC
    #: ordering.
    cudaEglColorFormatBayerCRBC = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayerCRBC

    #: Bayer format - one channel in one surface with interleaved CBRC
    #: ordering.
    cudaEglColorFormatBayerCBRC = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayerCBRC

    #: Bayer10 format - one channel in one surface with interleaved CCCC
    #: ordering. Out of 16 bits, 10 bits used 6 bits No-op.
    cudaEglColorFormatBayer10CCCC = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer10CCCC

    #: Bayer12 format - one channel in one surface with interleaved BCCR
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    cudaEglColorFormatBayer12BCCR = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer12BCCR

    #: Bayer12 format - one channel in one surface with interleaved RCCB
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    cudaEglColorFormatBayer12RCCB = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer12RCCB

    #: Bayer12 format - one channel in one surface with interleaved CRBC
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    cudaEglColorFormatBayer12CRBC = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer12CRBC

    #: Bayer12 format - one channel in one surface with interleaved CBRC
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    cudaEglColorFormatBayer12CBRC = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer12CBRC

    #: Bayer12 format - one channel in one surface with interleaved CCCC
    #: ordering. Out of 16 bits, 12 bits used 4 bits No-op.
    cudaEglColorFormatBayer12CCCC = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatBayer12CCCC

    #: Color format for single Y plane.
    cudaEglColorFormatY = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY

    #: Y, UV in two surfaces (UV as one surface) U/V width = 1/2 Y width,
    #: U/V height = 1/2 Y height.
    cudaEglColorFormatYUV420SemiPlanar_2020 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV420SemiPlanar_2020

    #: Y, VU in two surfaces (VU as one surface) U/V width = 1/2 Y width,
    #: U/V height = 1/2 Y height.
    cudaEglColorFormatYVU420SemiPlanar_2020 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU420SemiPlanar_2020

    #: Y, U, V in three surfaces, each in a separate surface, U/V width =
    #: 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatYUV420Planar_2020 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV420Planar_2020

    #: Y, V, U in three surfaces, each in a separate surface, U/V width =
    #: 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatYVU420Planar_2020 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU420Planar_2020

    #: Y, UV in two surfaces (UV as one surface) U/V width = 1/2 Y width,
    #: U/V height = 1/2 Y height.
    cudaEglColorFormatYUV420SemiPlanar_709 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV420SemiPlanar_709

    #: Y, VU in two surfaces (VU as one surface) U/V width = 1/2 Y width,
    #: U/V height = 1/2 Y height.
    cudaEglColorFormatYVU420SemiPlanar_709 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU420SemiPlanar_709

    #: Y, U, V in three surfaces, each in a separate surface, U/V width =
    #: 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatYUV420Planar_709 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUV420Planar_709

    #: Y, V, U in three surfaces, each in a separate surface, U/V width =
    #: 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatYVU420Planar_709 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVU420Planar_709

    #: Y10, V10U10 in two surfaces (VU as one surface) U/V width = 1/2 Y
    #: width, U/V height = 1/2 Y height.
    cudaEglColorFormatY10V10U10_420SemiPlanar_709 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10V10U10_420SemiPlanar_709

    #: Y10, V10U10 in two surfaces (VU as one surface) U/V width = 1/2 Y
    #: width, U/V height = 1/2 Y height.
    cudaEglColorFormatY10V10U10_420SemiPlanar_2020 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10V10U10_420SemiPlanar_2020

    #: Y10, V10U10 in two surfaces (VU as one surface) U/V width = 1/2 Y
    #: width, U/V height = Y height.
    cudaEglColorFormatY10V10U10_422SemiPlanar_2020 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10V10U10_422SemiPlanar_2020

    #: Y10, V10U10 in two surfaces (VU as one surface) U/V width = 1/2 Y
    #: width, U/V height = Y height.
    cudaEglColorFormatY10V10U10_422SemiPlanar = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10V10U10_422SemiPlanar

    #: Y10, V10U10 in two surfaces (VU as one surface) U/V width = 1/2 Y
    #: width, U/V height = Y height.
    cudaEglColorFormatY10V10U10_422SemiPlanar_709 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10V10U10_422SemiPlanar_709

    #: Extended Range Color format for single Y plane.
    cudaEglColorFormatY_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY_ER

    #: Extended Range Color format for single Y plane.
    cudaEglColorFormatY_709_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY_709_ER

    #: Extended Range Color format for single Y10 plane.
    cudaEglColorFormatY10_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10_ER

    #: Extended Range Color format for single Y10 plane.
    cudaEglColorFormatY10_709_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10_709_ER

    #: Extended Range Color format for single Y12 plane.
    cudaEglColorFormatY12_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY12_ER

    #: Extended Range Color format for single Y12 plane.
    cudaEglColorFormatY12_709_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY12_709_ER

    #: Y, U, V, A four channels in one surface, interleaved as AVUY.
    cudaEglColorFormatYUVA = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYUVA

    #: Y, U, V in one surface, interleaved as YVYU in one channel.
    cudaEglColorFormatYVYU = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatYVYU

    #: Y, U, V in one surface, interleaved as VYUY in one channel.
    cudaEglColorFormatVYUY = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatVYUY

    #: Extended Range Y10, V10U10 in two surfaces (VU as one surface) U/V
    #: width = 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatY10V10U10_420SemiPlanar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10V10U10_420SemiPlanar_ER

    #: Extended Range Y10, V10U10 in two surfaces (VU as one surface) U/V
    #: width = 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatY10V10U10_420SemiPlanar_709_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10V10U10_420SemiPlanar_709_ER

    #: Extended Range Y10, V10U10 in two surfaces (VU as one surface) U/V
    #: width = Y width, U/V height = Y height.
    cudaEglColorFormatY10V10U10_444SemiPlanar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10V10U10_444SemiPlanar_ER

    #: Extended Range Y10, V10U10 in two surfaces (VU as one surface) U/V
    #: width = Y width, U/V height = Y height.
    cudaEglColorFormatY10V10U10_444SemiPlanar_709_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY10V10U10_444SemiPlanar_709_ER

    #: Extended Range Y12, V12U12 in two surfaces (VU as one surface) U/V
    #: width = 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatY12V12U12_420SemiPlanar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY12V12U12_420SemiPlanar_ER

    #: Extended Range Y12, V12U12 in two surfaces (VU as one surface) U/V
    #: width = 1/2 Y width, U/V height = 1/2 Y height.
    cudaEglColorFormatY12V12U12_420SemiPlanar_709_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY12V12U12_420SemiPlanar_709_ER

    #: Extended Range Y12, V12U12 in two surfaces (VU as one surface) U/V
    #: width = Y width, U/V height = Y height.
    cudaEglColorFormatY12V12U12_444SemiPlanar_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY12V12U12_444SemiPlanar_ER

    #: Extended Range Y12, V12U12 in two surfaces (VU as one surface) U/V
    #: width = Y width, U/V height = Y height.
    cudaEglColorFormatY12V12U12_444SemiPlanar_709_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatY12V12U12_444SemiPlanar_709_ER

    #: Y, U, V in one surface, interleaved as UYVY in one channel.
    cudaEglColorFormatUYVY709 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatUYVY709

    #: Extended Range Y, U, V in one surface, interleaved as UYVY in one
    #: channel.
    cudaEglColorFormatUYVY709_ER = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatUYVY709_ER

    #: Y, U, V in one surface, interleaved as UYVY in one channel.
    cudaEglColorFormatUYVY2020 = cyruntime.cudaEglColorFormat_enum.cudaEglColorFormatUYVY2020

_dict_cudaEglColorFormat = dict(((int(v), v) for k, v in cudaEglColorFormat.__members__.items()))

class cudaChannelFormatKind(IntEnum):
    """
    Channel format kind
    """

    #: Signed channel format
    cudaChannelFormatKindSigned = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindSigned

    #: Unsigned channel format
    cudaChannelFormatKindUnsigned = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsigned

    #: Float channel format
    cudaChannelFormatKindFloat = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindFloat

    #: No channel format
    cudaChannelFormatKindNone = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindNone

    #: Unsigned 8-bit integers, planar 4:2:0 YUV format
    cudaChannelFormatKindNV12 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindNV12

    #: 1 channel unsigned 8-bit normalized integer
    cudaChannelFormatKindUnsignedNormalized8X1 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedNormalized8X1

    #: 2 channel unsigned 8-bit normalized integer
    cudaChannelFormatKindUnsignedNormalized8X2 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedNormalized8X2

    #: 4 channel unsigned 8-bit normalized integer
    cudaChannelFormatKindUnsignedNormalized8X4 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedNormalized8X4

    #: 1 channel unsigned 16-bit normalized integer
    cudaChannelFormatKindUnsignedNormalized16X1 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedNormalized16X1

    #: 2 channel unsigned 16-bit normalized integer
    cudaChannelFormatKindUnsignedNormalized16X2 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedNormalized16X2

    #: 4 channel unsigned 16-bit normalized integer
    cudaChannelFormatKindUnsignedNormalized16X4 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedNormalized16X4

    #: 1 channel signed 8-bit normalized integer
    cudaChannelFormatKindSignedNormalized8X1 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindSignedNormalized8X1

    #: 2 channel signed 8-bit normalized integer
    cudaChannelFormatKindSignedNormalized8X2 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindSignedNormalized8X2

    #: 4 channel signed 8-bit normalized integer
    cudaChannelFormatKindSignedNormalized8X4 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindSignedNormalized8X4

    #: 1 channel signed 16-bit normalized integer
    cudaChannelFormatKindSignedNormalized16X1 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindSignedNormalized16X1

    #: 2 channel signed 16-bit normalized integer
    cudaChannelFormatKindSignedNormalized16X2 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindSignedNormalized16X2

    #: 4 channel signed 16-bit normalized integer
    cudaChannelFormatKindSignedNormalized16X4 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindSignedNormalized16X4

    #: 4 channel unsigned normalized block-compressed (BC1 compression)
    #: format
    cudaChannelFormatKindUnsignedBlockCompressed1 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedBlockCompressed1

    #: 4 channel unsigned normalized block-compressed (BC1 compression)
    #: format with sRGB encoding
    cudaChannelFormatKindUnsignedBlockCompressed1SRGB = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedBlockCompressed1SRGB

    #: 4 channel unsigned normalized block-compressed (BC2 compression)
    #: format
    cudaChannelFormatKindUnsignedBlockCompressed2 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedBlockCompressed2

    #: 4 channel unsigned normalized block-compressed (BC2 compression)
    #: format with sRGB encoding
    cudaChannelFormatKindUnsignedBlockCompressed2SRGB = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedBlockCompressed2SRGB

    #: 4 channel unsigned normalized block-compressed (BC3 compression)
    #: format
    cudaChannelFormatKindUnsignedBlockCompressed3 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedBlockCompressed3

    #: 4 channel unsigned normalized block-compressed (BC3 compression)
    #: format with sRGB encoding
    cudaChannelFormatKindUnsignedBlockCompressed3SRGB = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedBlockCompressed3SRGB

    #: 1 channel unsigned normalized block-compressed (BC4 compression)
    #: format
    cudaChannelFormatKindUnsignedBlockCompressed4 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedBlockCompressed4

    #: 1 channel signed normalized block-compressed (BC4 compression)
    #: format
    cudaChannelFormatKindSignedBlockCompressed4 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindSignedBlockCompressed4

    #: 2 channel unsigned normalized block-compressed (BC5 compression)
    #: format
    cudaChannelFormatKindUnsignedBlockCompressed5 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedBlockCompressed5

    #: 2 channel signed normalized block-compressed (BC5 compression)
    #: format
    cudaChannelFormatKindSignedBlockCompressed5 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindSignedBlockCompressed5

    #: 3 channel unsigned half-float block-compressed (BC6H compression)
    #: format
    cudaChannelFormatKindUnsignedBlockCompressed6H = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedBlockCompressed6H

    #: 3 channel signed half-float block-compressed (BC6H compression)
    #: format
    cudaChannelFormatKindSignedBlockCompressed6H = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindSignedBlockCompressed6H

    #: 4 channel unsigned normalized block-compressed (BC7 compression)
    #: format
    cudaChannelFormatKindUnsignedBlockCompressed7 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedBlockCompressed7

    #: 4 channel unsigned normalized block-compressed (BC7 compression)
    #: format with sRGB encoding
    cudaChannelFormatKindUnsignedBlockCompressed7SRGB = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedBlockCompressed7SRGB

    #: 4 channel unsigned normalized (10-bit, 10-bit, 10-bit, 2-bit) format
    cudaChannelFormatKindUnsignedNormalized1010102 = cyruntime.cudaChannelFormatKind.cudaChannelFormatKindUnsignedNormalized1010102

_dict_cudaChannelFormatKind = dict(((int(v), v) for k, v in cudaChannelFormatKind.__members__.items()))

class cudaMemoryType(IntEnum):
    """
    CUDA memory types
    """

    #: Unregistered memory
    cudaMemoryTypeUnregistered = cyruntime.cudaMemoryType.cudaMemoryTypeUnregistered

    #: Host memory
    cudaMemoryTypeHost = cyruntime.cudaMemoryType.cudaMemoryTypeHost

    #: Device memory
    cudaMemoryTypeDevice = cyruntime.cudaMemoryType.cudaMemoryTypeDevice

    #: Managed memory
    cudaMemoryTypeManaged = cyruntime.cudaMemoryType.cudaMemoryTypeManaged

_dict_cudaMemoryType = dict(((int(v), v) for k, v in cudaMemoryType.__members__.items()))

class cudaMemcpyKind(IntEnum):
    """
    CUDA memory copy types
    """

    #: Host -> Host
    cudaMemcpyHostToHost = cyruntime.cudaMemcpyKind.cudaMemcpyHostToHost

    #: Host -> Device
    cudaMemcpyHostToDevice = cyruntime.cudaMemcpyKind.cudaMemcpyHostToDevice

    #: Device -> Host
    cudaMemcpyDeviceToHost = cyruntime.cudaMemcpyKind.cudaMemcpyDeviceToHost

    #: Device -> Device
    cudaMemcpyDeviceToDevice = cyruntime.cudaMemcpyKind.cudaMemcpyDeviceToDevice

    #: Direction of the transfer is inferred from the pointer values.
    #: Requires unified virtual addressing
    cudaMemcpyDefault = cyruntime.cudaMemcpyKind.cudaMemcpyDefault

_dict_cudaMemcpyKind = dict(((int(v), v) for k, v in cudaMemcpyKind.__members__.items()))

class cudaAccessProperty(IntEnum):
    """
    Specifies performance hint with :py:obj:`~.cudaAccessPolicyWindow`
    for hitProp and missProp members.
    """

    #: Normal cache persistence.
    cudaAccessPropertyNormal = cyruntime.cudaAccessProperty.cudaAccessPropertyNormal

    #: Streaming access is less likely to persit from cache.
    cudaAccessPropertyStreaming = cyruntime.cudaAccessProperty.cudaAccessPropertyStreaming

    #: Persisting access is more likely to persist in cache.
    cudaAccessPropertyPersisting = cyruntime.cudaAccessProperty.cudaAccessPropertyPersisting

_dict_cudaAccessProperty = dict(((int(v), v) for k, v in cudaAccessProperty.__members__.items()))

class cudaStreamCaptureStatus(IntEnum):
    """
    Possible stream capture statuses returned by
    :py:obj:`~.cudaStreamIsCapturing`
    """

    #: Stream is not capturing
    cudaStreamCaptureStatusNone = cyruntime.cudaStreamCaptureStatus.cudaStreamCaptureStatusNone

    #: Stream is actively capturing
    cudaStreamCaptureStatusActive = cyruntime.cudaStreamCaptureStatus.cudaStreamCaptureStatusActive

    #: Stream is part of a capture sequence that has been invalidated, but
    #: not terminated
    cudaStreamCaptureStatusInvalidated = cyruntime.cudaStreamCaptureStatus.cudaStreamCaptureStatusInvalidated

_dict_cudaStreamCaptureStatus = dict(((int(v), v) for k, v in cudaStreamCaptureStatus.__members__.items()))

class cudaStreamCaptureMode(IntEnum):
    """
    Possible modes for stream capture thread interactions. For more
    details see :py:obj:`~.cudaStreamBeginCapture` and
    :py:obj:`~.cudaThreadExchangeStreamCaptureMode`
    """
    cudaStreamCaptureModeGlobal = cyruntime.cudaStreamCaptureMode.cudaStreamCaptureModeGlobal
    cudaStreamCaptureModeThreadLocal = cyruntime.cudaStreamCaptureMode.cudaStreamCaptureModeThreadLocal
    cudaStreamCaptureModeRelaxed = cyruntime.cudaStreamCaptureMode.cudaStreamCaptureModeRelaxed

_dict_cudaStreamCaptureMode = dict(((int(v), v) for k, v in cudaStreamCaptureMode.__members__.items()))

class cudaSynchronizationPolicy(IntEnum):
    """

    """
    cudaSyncPolicyAuto = cyruntime.cudaSynchronizationPolicy.cudaSyncPolicyAuto
    cudaSyncPolicySpin = cyruntime.cudaSynchronizationPolicy.cudaSyncPolicySpin
    cudaSyncPolicyYield = cyruntime.cudaSynchronizationPolicy.cudaSyncPolicyYield
    cudaSyncPolicyBlockingSync = cyruntime.cudaSynchronizationPolicy.cudaSyncPolicyBlockingSync

_dict_cudaSynchronizationPolicy = dict(((int(v), v) for k, v in cudaSynchronizationPolicy.__members__.items()))

class cudaClusterSchedulingPolicy(IntEnum):
    """
    Cluster scheduling policies. These may be passed to
    :py:obj:`~.cudaFuncSetAttribute`
    """

    #: the default policy
    cudaClusterSchedulingPolicyDefault = cyruntime.cudaClusterSchedulingPolicy.cudaClusterSchedulingPolicyDefault

    #: spread the blocks within a cluster to the SMs
    cudaClusterSchedulingPolicySpread = cyruntime.cudaClusterSchedulingPolicy.cudaClusterSchedulingPolicySpread

    #: allow the hardware to load-balance the blocks in a cluster to the
    #: SMs
    cudaClusterSchedulingPolicyLoadBalancing = cyruntime.cudaClusterSchedulingPolicy.cudaClusterSchedulingPolicyLoadBalancing

_dict_cudaClusterSchedulingPolicy = dict(((int(v), v) for k, v in cudaClusterSchedulingPolicy.__members__.items()))

class cudaStreamUpdateCaptureDependenciesFlags(IntEnum):
    """
    Flags for :py:obj:`~.cudaStreamUpdateCaptureDependencies`
    """

    #: Add new nodes to the dependency set
    cudaStreamAddCaptureDependencies = cyruntime.cudaStreamUpdateCaptureDependenciesFlags.cudaStreamAddCaptureDependencies

    #: Replace the dependency set with the new nodes
    cudaStreamSetCaptureDependencies = cyruntime.cudaStreamUpdateCaptureDependenciesFlags.cudaStreamSetCaptureDependencies

_dict_cudaStreamUpdateCaptureDependenciesFlags = dict(((int(v), v) for k, v in cudaStreamUpdateCaptureDependenciesFlags.__members__.items()))

class cudaUserObjectFlags(IntEnum):
    """
    Flags for user objects for graphs
    """

    #: Indicates the destructor execution is not synchronized by any CUDA
    #: handle.
    cudaUserObjectNoDestructorSync = cyruntime.cudaUserObjectFlags.cudaUserObjectNoDestructorSync

_dict_cudaUserObjectFlags = dict(((int(v), v) for k, v in cudaUserObjectFlags.__members__.items()))

class cudaUserObjectRetainFlags(IntEnum):
    """
    Flags for retaining user object references for graphs
    """

    #: Transfer references from the caller rather than creating new
    #: references.
    cudaGraphUserObjectMove = cyruntime.cudaUserObjectRetainFlags.cudaGraphUserObjectMove

_dict_cudaUserObjectRetainFlags = dict(((int(v), v) for k, v in cudaUserObjectRetainFlags.__members__.items()))

class cudaGraphicsRegisterFlags(IntEnum):
    """
    CUDA graphics interop register flags
    """

    #: Default
    cudaGraphicsRegisterFlagsNone = cyruntime.cudaGraphicsRegisterFlags.cudaGraphicsRegisterFlagsNone

    #: CUDA will not write to this resource
    cudaGraphicsRegisterFlagsReadOnly = cyruntime.cudaGraphicsRegisterFlags.cudaGraphicsRegisterFlagsReadOnly

    #: CUDA will only write to and will not read from this resource
    cudaGraphicsRegisterFlagsWriteDiscard = cyruntime.cudaGraphicsRegisterFlags.cudaGraphicsRegisterFlagsWriteDiscard

    #: CUDA will bind this resource to a surface reference
    cudaGraphicsRegisterFlagsSurfaceLoadStore = cyruntime.cudaGraphicsRegisterFlags.cudaGraphicsRegisterFlagsSurfaceLoadStore

    #: CUDA will perform texture gather operations on this resource
    cudaGraphicsRegisterFlagsTextureGather = cyruntime.cudaGraphicsRegisterFlags.cudaGraphicsRegisterFlagsTextureGather

_dict_cudaGraphicsRegisterFlags = dict(((int(v), v) for k, v in cudaGraphicsRegisterFlags.__members__.items()))

class cudaGraphicsMapFlags(IntEnum):
    """
    CUDA graphics interop map flags
    """

    #: Default; Assume resource can be read/written
    cudaGraphicsMapFlagsNone = cyruntime.cudaGraphicsMapFlags.cudaGraphicsMapFlagsNone

    #: CUDA will not write to this resource
    cudaGraphicsMapFlagsReadOnly = cyruntime.cudaGraphicsMapFlags.cudaGraphicsMapFlagsReadOnly

    #: CUDA will only write to and will not read from this resource
    cudaGraphicsMapFlagsWriteDiscard = cyruntime.cudaGraphicsMapFlags.cudaGraphicsMapFlagsWriteDiscard

_dict_cudaGraphicsMapFlags = dict(((int(v), v) for k, v in cudaGraphicsMapFlags.__members__.items()))

class cudaGraphicsCubeFace(IntEnum):
    """
    CUDA graphics interop array indices for cube maps
    """

    #: Positive X face of cubemap
    cudaGraphicsCubeFacePositiveX = cyruntime.cudaGraphicsCubeFace.cudaGraphicsCubeFacePositiveX

    #: Negative X face of cubemap
    cudaGraphicsCubeFaceNegativeX = cyruntime.cudaGraphicsCubeFace.cudaGraphicsCubeFaceNegativeX

    #: Positive Y face of cubemap
    cudaGraphicsCubeFacePositiveY = cyruntime.cudaGraphicsCubeFace.cudaGraphicsCubeFacePositiveY

    #: Negative Y face of cubemap
    cudaGraphicsCubeFaceNegativeY = cyruntime.cudaGraphicsCubeFace.cudaGraphicsCubeFaceNegativeY

    #: Positive Z face of cubemap
    cudaGraphicsCubeFacePositiveZ = cyruntime.cudaGraphicsCubeFace.cudaGraphicsCubeFacePositiveZ

    #: Negative Z face of cubemap
    cudaGraphicsCubeFaceNegativeZ = cyruntime.cudaGraphicsCubeFace.cudaGraphicsCubeFaceNegativeZ

_dict_cudaGraphicsCubeFace = dict(((int(v), v) for k, v in cudaGraphicsCubeFace.__members__.items()))

class cudaResourceType(IntEnum):
    """
    CUDA resource types
    """

    #: Array resource
    cudaResourceTypeArray = cyruntime.cudaResourceType.cudaResourceTypeArray

    #: Mipmapped array resource
    cudaResourceTypeMipmappedArray = cyruntime.cudaResourceType.cudaResourceTypeMipmappedArray

    #: Linear resource
    cudaResourceTypeLinear = cyruntime.cudaResourceType.cudaResourceTypeLinear

    #: Pitch 2D resource
    cudaResourceTypePitch2D = cyruntime.cudaResourceType.cudaResourceTypePitch2D

_dict_cudaResourceType = dict(((int(v), v) for k, v in cudaResourceType.__members__.items()))

class cudaResourceViewFormat(IntEnum):
    """
    CUDA texture resource view formats
    """

    #: No resource view format (use underlying resource format)
    cudaResViewFormatNone = cyruntime.cudaResourceViewFormat.cudaResViewFormatNone

    #: 1 channel unsigned 8-bit integers
    cudaResViewFormatUnsignedChar1 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedChar1

    #: 2 channel unsigned 8-bit integers
    cudaResViewFormatUnsignedChar2 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedChar2

    #: 4 channel unsigned 8-bit integers
    cudaResViewFormatUnsignedChar4 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedChar4

    #: 1 channel signed 8-bit integers
    cudaResViewFormatSignedChar1 = cyruntime.cudaResourceViewFormat.cudaResViewFormatSignedChar1

    #: 2 channel signed 8-bit integers
    cudaResViewFormatSignedChar2 = cyruntime.cudaResourceViewFormat.cudaResViewFormatSignedChar2

    #: 4 channel signed 8-bit integers
    cudaResViewFormatSignedChar4 = cyruntime.cudaResourceViewFormat.cudaResViewFormatSignedChar4

    #: 1 channel unsigned 16-bit integers
    cudaResViewFormatUnsignedShort1 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedShort1

    #: 2 channel unsigned 16-bit integers
    cudaResViewFormatUnsignedShort2 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedShort2

    #: 4 channel unsigned 16-bit integers
    cudaResViewFormatUnsignedShort4 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedShort4

    #: 1 channel signed 16-bit integers
    cudaResViewFormatSignedShort1 = cyruntime.cudaResourceViewFormat.cudaResViewFormatSignedShort1

    #: 2 channel signed 16-bit integers
    cudaResViewFormatSignedShort2 = cyruntime.cudaResourceViewFormat.cudaResViewFormatSignedShort2

    #: 4 channel signed 16-bit integers
    cudaResViewFormatSignedShort4 = cyruntime.cudaResourceViewFormat.cudaResViewFormatSignedShort4

    #: 1 channel unsigned 32-bit integers
    cudaResViewFormatUnsignedInt1 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedInt1

    #: 2 channel unsigned 32-bit integers
    cudaResViewFormatUnsignedInt2 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedInt2

    #: 4 channel unsigned 32-bit integers
    cudaResViewFormatUnsignedInt4 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedInt4

    #: 1 channel signed 32-bit integers
    cudaResViewFormatSignedInt1 = cyruntime.cudaResourceViewFormat.cudaResViewFormatSignedInt1

    #: 2 channel signed 32-bit integers
    cudaResViewFormatSignedInt2 = cyruntime.cudaResourceViewFormat.cudaResViewFormatSignedInt2

    #: 4 channel signed 32-bit integers
    cudaResViewFormatSignedInt4 = cyruntime.cudaResourceViewFormat.cudaResViewFormatSignedInt4

    #: 1 channel 16-bit floating point
    cudaResViewFormatHalf1 = cyruntime.cudaResourceViewFormat.cudaResViewFormatHalf1

    #: 2 channel 16-bit floating point
    cudaResViewFormatHalf2 = cyruntime.cudaResourceViewFormat.cudaResViewFormatHalf2

    #: 4 channel 16-bit floating point
    cudaResViewFormatHalf4 = cyruntime.cudaResourceViewFormat.cudaResViewFormatHalf4

    #: 1 channel 32-bit floating point
    cudaResViewFormatFloat1 = cyruntime.cudaResourceViewFormat.cudaResViewFormatFloat1

    #: 2 channel 32-bit floating point
    cudaResViewFormatFloat2 = cyruntime.cudaResourceViewFormat.cudaResViewFormatFloat2

    #: 4 channel 32-bit floating point
    cudaResViewFormatFloat4 = cyruntime.cudaResourceViewFormat.cudaResViewFormatFloat4

    #: Block compressed 1
    cudaResViewFormatUnsignedBlockCompressed1 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedBlockCompressed1

    #: Block compressed 2
    cudaResViewFormatUnsignedBlockCompressed2 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedBlockCompressed2

    #: Block compressed 3
    cudaResViewFormatUnsignedBlockCompressed3 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedBlockCompressed3

    #: Block compressed 4 unsigned
    cudaResViewFormatUnsignedBlockCompressed4 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedBlockCompressed4

    #: Block compressed 4 signed
    cudaResViewFormatSignedBlockCompressed4 = cyruntime.cudaResourceViewFormat.cudaResViewFormatSignedBlockCompressed4

    #: Block compressed 5 unsigned
    cudaResViewFormatUnsignedBlockCompressed5 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedBlockCompressed5

    #: Block compressed 5 signed
    cudaResViewFormatSignedBlockCompressed5 = cyruntime.cudaResourceViewFormat.cudaResViewFormatSignedBlockCompressed5

    #: Block compressed 6 unsigned half-float
    cudaResViewFormatUnsignedBlockCompressed6H = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedBlockCompressed6H

    #: Block compressed 6 signed half-float
    cudaResViewFormatSignedBlockCompressed6H = cyruntime.cudaResourceViewFormat.cudaResViewFormatSignedBlockCompressed6H

    #: Block compressed 7
    cudaResViewFormatUnsignedBlockCompressed7 = cyruntime.cudaResourceViewFormat.cudaResViewFormatUnsignedBlockCompressed7

_dict_cudaResourceViewFormat = dict(((int(v), v) for k, v in cudaResourceViewFormat.__members__.items()))

class cudaFuncAttribute(IntEnum):
    """
    CUDA function attributes that can be set using
    :py:obj:`~.cudaFuncSetAttribute`
    """

    #: Maximum dynamic shared memory size
    cudaFuncAttributeMaxDynamicSharedMemorySize = cyruntime.cudaFuncAttribute.cudaFuncAttributeMaxDynamicSharedMemorySize

    #: Preferred shared memory-L1 cache split
    cudaFuncAttributePreferredSharedMemoryCarveout = cyruntime.cudaFuncAttribute.cudaFuncAttributePreferredSharedMemoryCarveout

    #: Indicator to enforce valid cluster dimension specification on kernel
    #: launch
    cudaFuncAttributeClusterDimMustBeSet = cyruntime.cudaFuncAttribute.cudaFuncAttributeClusterDimMustBeSet

    #: Required cluster width
    cudaFuncAttributeRequiredClusterWidth = cyruntime.cudaFuncAttribute.cudaFuncAttributeRequiredClusterWidth

    #: Required cluster height
    cudaFuncAttributeRequiredClusterHeight = cyruntime.cudaFuncAttribute.cudaFuncAttributeRequiredClusterHeight

    #: Required cluster depth
    cudaFuncAttributeRequiredClusterDepth = cyruntime.cudaFuncAttribute.cudaFuncAttributeRequiredClusterDepth

    #: Whether non-portable cluster scheduling policy is supported
    cudaFuncAttributeNonPortableClusterSizeAllowed = cyruntime.cudaFuncAttribute.cudaFuncAttributeNonPortableClusterSizeAllowed

    #: Required cluster scheduling policy preference
    cudaFuncAttributeClusterSchedulingPolicyPreference = cyruntime.cudaFuncAttribute.cudaFuncAttributeClusterSchedulingPolicyPreference
    cudaFuncAttributeMax = cyruntime.cudaFuncAttribute.cudaFuncAttributeMax

_dict_cudaFuncAttribute = dict(((int(v), v) for k, v in cudaFuncAttribute.__members__.items()))

class cudaFuncCache(IntEnum):
    """
    CUDA function cache configurations
    """

    #: Default function cache configuration, no preference
    cudaFuncCachePreferNone = cyruntime.cudaFuncCache.cudaFuncCachePreferNone

    #: Prefer larger shared memory and smaller L1 cache
    cudaFuncCachePreferShared = cyruntime.cudaFuncCache.cudaFuncCachePreferShared

    #: Prefer larger L1 cache and smaller shared memory
    cudaFuncCachePreferL1 = cyruntime.cudaFuncCache.cudaFuncCachePreferL1

    #: Prefer equal size L1 cache and shared memory
    cudaFuncCachePreferEqual = cyruntime.cudaFuncCache.cudaFuncCachePreferEqual

_dict_cudaFuncCache = dict(((int(v), v) for k, v in cudaFuncCache.__members__.items()))

class cudaSharedMemConfig(IntEnum):
    """
    CUDA shared memory configuration [Deprecated]
    """
    cudaSharedMemBankSizeDefault = cyruntime.cudaSharedMemConfig.cudaSharedMemBankSizeDefault
    cudaSharedMemBankSizeFourByte = cyruntime.cudaSharedMemConfig.cudaSharedMemBankSizeFourByte
    cudaSharedMemBankSizeEightByte = cyruntime.cudaSharedMemConfig.cudaSharedMemBankSizeEightByte

_dict_cudaSharedMemConfig = dict(((int(v), v) for k, v in cudaSharedMemConfig.__members__.items()))

class cudaSharedCarveout(IntEnum):
    """
    Shared memory carveout configurations. These may be passed to
    cudaFuncSetAttribute
    """

    #: No preference for shared memory or L1 (default)
    cudaSharedmemCarveoutDefault = cyruntime.cudaSharedCarveout.cudaSharedmemCarveoutDefault

    #: Prefer maximum available L1 cache, minimum shared memory
    cudaSharedmemCarveoutMaxL1 = cyruntime.cudaSharedCarveout.cudaSharedmemCarveoutMaxL1

    #: Prefer maximum available shared memory, minimum L1 cache
    cudaSharedmemCarveoutMaxShared = cyruntime.cudaSharedCarveout.cudaSharedmemCarveoutMaxShared

_dict_cudaSharedCarveout = dict(((int(v), v) for k, v in cudaSharedCarveout.__members__.items()))

class cudaComputeMode(IntEnum):
    """
    CUDA device compute modes
    """

    #: Default compute mode (Multiple threads can use
    #: :py:obj:`~.cudaSetDevice()` with this device)
    cudaComputeModeDefault = cyruntime.cudaComputeMode.cudaComputeModeDefault

    #: Compute-exclusive-thread mode (Only one thread in one process will
    #: be able to use :py:obj:`~.cudaSetDevice()` with this device)
    cudaComputeModeExclusive = cyruntime.cudaComputeMode.cudaComputeModeExclusive

    #: Compute-prohibited mode (No threads can use
    #: :py:obj:`~.cudaSetDevice()` with this device)
    cudaComputeModeProhibited = cyruntime.cudaComputeMode.cudaComputeModeProhibited

    #: Compute-exclusive-process mode (Many threads in one process will be
    #: able to use :py:obj:`~.cudaSetDevice()` with this device)
    cudaComputeModeExclusiveProcess = cyruntime.cudaComputeMode.cudaComputeModeExclusiveProcess

_dict_cudaComputeMode = dict(((int(v), v) for k, v in cudaComputeMode.__members__.items()))

class cudaLimit(IntEnum):
    """
    CUDA Limits
    """

    #: GPU thread stack size
    cudaLimitStackSize = cyruntime.cudaLimit.cudaLimitStackSize

    #: GPU printf FIFO size
    cudaLimitPrintfFifoSize = cyruntime.cudaLimit.cudaLimitPrintfFifoSize

    #: GPU malloc heap size
    cudaLimitMallocHeapSize = cyruntime.cudaLimit.cudaLimitMallocHeapSize

    #: GPU device runtime synchronize depth
    cudaLimitDevRuntimeSyncDepth = cyruntime.cudaLimit.cudaLimitDevRuntimeSyncDepth

    #: GPU device runtime pending launch count
    cudaLimitDevRuntimePendingLaunchCount = cyruntime.cudaLimit.cudaLimitDevRuntimePendingLaunchCount

    #: A value between 0 and 128 that indicates the maximum fetch
    #: granularity of L2 (in Bytes). This is a hint
    cudaLimitMaxL2FetchGranularity = cyruntime.cudaLimit.cudaLimitMaxL2FetchGranularity

    #: A size in bytes for L2 persisting lines cache size
    cudaLimitPersistingL2CacheSize = cyruntime.cudaLimit.cudaLimitPersistingL2CacheSize

_dict_cudaLimit = dict(((int(v), v) for k, v in cudaLimit.__members__.items()))

class cudaMemoryAdvise(IntEnum):
    """
    CUDA Memory Advise values
    """

    #: Data will mostly be read and only occassionally be written to
    cudaMemAdviseSetReadMostly = cyruntime.cudaMemoryAdvise.cudaMemAdviseSetReadMostly

    #: Undo the effect of :py:obj:`~.cudaMemAdviseSetReadMostly`
    cudaMemAdviseUnsetReadMostly = cyruntime.cudaMemoryAdvise.cudaMemAdviseUnsetReadMostly

    #: Set the preferred location for the data as the specified device
    cudaMemAdviseSetPreferredLocation = cyruntime.cudaMemoryAdvise.cudaMemAdviseSetPreferredLocation

    #: Clear the preferred location for the data
    cudaMemAdviseUnsetPreferredLocation = cyruntime.cudaMemoryAdvise.cudaMemAdviseUnsetPreferredLocation

    #: Data will be accessed by the specified device, so prevent page
    #: faults as much as possible
    cudaMemAdviseSetAccessedBy = cyruntime.cudaMemoryAdvise.cudaMemAdviseSetAccessedBy

    #: Let the Unified Memory subsystem decide on the page faulting policy
    #: for the specified device
    cudaMemAdviseUnsetAccessedBy = cyruntime.cudaMemoryAdvise.cudaMemAdviseUnsetAccessedBy

_dict_cudaMemoryAdvise = dict(((int(v), v) for k, v in cudaMemoryAdvise.__members__.items()))

class cudaMemRangeAttribute(IntEnum):
    """
    CUDA range attributes
    """

    #: Whether the range will mostly be read and only occassionally be
    #: written to
    cudaMemRangeAttributeReadMostly = cyruntime.cudaMemRangeAttribute.cudaMemRangeAttributeReadMostly

    #: The preferred location of the range
    cudaMemRangeAttributePreferredLocation = cyruntime.cudaMemRangeAttribute.cudaMemRangeAttributePreferredLocation

    #: Memory range has :py:obj:`~.cudaMemAdviseSetAccessedBy` set for
    #: specified device
    cudaMemRangeAttributeAccessedBy = cyruntime.cudaMemRangeAttribute.cudaMemRangeAttributeAccessedBy

    #: The last location to which the range was prefetched
    cudaMemRangeAttributeLastPrefetchLocation = cyruntime.cudaMemRangeAttribute.cudaMemRangeAttributeLastPrefetchLocation

    #: The preferred location type of the range
    cudaMemRangeAttributePreferredLocationType = cyruntime.cudaMemRangeAttribute.cudaMemRangeAttributePreferredLocationType

    #: The preferred location id of the range
    cudaMemRangeAttributePreferredLocationId = cyruntime.cudaMemRangeAttribute.cudaMemRangeAttributePreferredLocationId

    #: The last location type to which the range was prefetched
    cudaMemRangeAttributeLastPrefetchLocationType = cyruntime.cudaMemRangeAttribute.cudaMemRangeAttributeLastPrefetchLocationType

    #: The last location id to which the range was prefetched
    cudaMemRangeAttributeLastPrefetchLocationId = cyruntime.cudaMemRangeAttribute.cudaMemRangeAttributeLastPrefetchLocationId

_dict_cudaMemRangeAttribute = dict(((int(v), v) for k, v in cudaMemRangeAttribute.__members__.items()))

class cudaFlushGPUDirectRDMAWritesOptions(IntEnum):
    """
    CUDA GPUDirect RDMA flush writes APIs supported on the device
    """

    #: :py:obj:`~.cudaDeviceFlushGPUDirectRDMAWrites()` and its CUDA Driver
    #: API counterpart are supported on the device.
    cudaFlushGPUDirectRDMAWritesOptionHost = cyruntime.cudaFlushGPUDirectRDMAWritesOptions.cudaFlushGPUDirectRDMAWritesOptionHost

    #: The :py:obj:`~.CU_STREAM_WAIT_VALUE_FLUSH` flag and the
    #: :py:obj:`~.CU_STREAM_MEM_OP_FLUSH_REMOTE_WRITES` MemOp are supported
    #: on the CUDA device.
    cudaFlushGPUDirectRDMAWritesOptionMemOps = cyruntime.cudaFlushGPUDirectRDMAWritesOptions.cudaFlushGPUDirectRDMAWritesOptionMemOps

_dict_cudaFlushGPUDirectRDMAWritesOptions = dict(((int(v), v) for k, v in cudaFlushGPUDirectRDMAWritesOptions.__members__.items()))

class cudaGPUDirectRDMAWritesOrdering(IntEnum):
    """
    CUDA GPUDirect RDMA flush writes ordering features of the device
    """

    #: The device does not natively support ordering of GPUDirect RDMA
    #: writes. :py:obj:`~.cudaFlushGPUDirectRDMAWrites()` can be leveraged
    #: if supported.
    cudaGPUDirectRDMAWritesOrderingNone = cyruntime.cudaGPUDirectRDMAWritesOrdering.cudaGPUDirectRDMAWritesOrderingNone

    #: Natively, the device can consistently consume GPUDirect RDMA writes,
    #: although other CUDA devices may not.
    cudaGPUDirectRDMAWritesOrderingOwner = cyruntime.cudaGPUDirectRDMAWritesOrdering.cudaGPUDirectRDMAWritesOrderingOwner

    #: Any CUDA device in the system can consistently consume GPUDirect
    #: RDMA writes to this device.
    cudaGPUDirectRDMAWritesOrderingAllDevices = cyruntime.cudaGPUDirectRDMAWritesOrdering.cudaGPUDirectRDMAWritesOrderingAllDevices

_dict_cudaGPUDirectRDMAWritesOrdering = dict(((int(v), v) for k, v in cudaGPUDirectRDMAWritesOrdering.__members__.items()))

class cudaFlushGPUDirectRDMAWritesScope(IntEnum):
    """
    CUDA GPUDirect RDMA flush writes scopes
    """

    #: Blocks until remote writes are visible to the CUDA device context
    #: owning the data.
    cudaFlushGPUDirectRDMAWritesToOwner = cyruntime.cudaFlushGPUDirectRDMAWritesScope.cudaFlushGPUDirectRDMAWritesToOwner

    #: Blocks until remote writes are visible to all CUDA device contexts.
    cudaFlushGPUDirectRDMAWritesToAllDevices = cyruntime.cudaFlushGPUDirectRDMAWritesScope.cudaFlushGPUDirectRDMAWritesToAllDevices

_dict_cudaFlushGPUDirectRDMAWritesScope = dict(((int(v), v) for k, v in cudaFlushGPUDirectRDMAWritesScope.__members__.items()))

class cudaFlushGPUDirectRDMAWritesTarget(IntEnum):
    """
    CUDA GPUDirect RDMA flush writes targets
    """

    #: Sets the target for :py:obj:`~.cudaDeviceFlushGPUDirectRDMAWrites()`
    #: to the currently active CUDA device context.
    cudaFlushGPUDirectRDMAWritesTargetCurrentDevice = cyruntime.cudaFlushGPUDirectRDMAWritesTarget.cudaFlushGPUDirectRDMAWritesTargetCurrentDevice

_dict_cudaFlushGPUDirectRDMAWritesTarget = dict(((int(v), v) for k, v in cudaFlushGPUDirectRDMAWritesTarget.__members__.items()))

class cudaDeviceAttr(IntEnum):
    """
    CUDA device attributes
    """

    #: Maximum number of threads per block
    cudaDevAttrMaxThreadsPerBlock = cyruntime.cudaDeviceAttr.cudaDevAttrMaxThreadsPerBlock

    #: Maximum block dimension X
    cudaDevAttrMaxBlockDimX = cyruntime.cudaDeviceAttr.cudaDevAttrMaxBlockDimX

    #: Maximum block dimension Y
    cudaDevAttrMaxBlockDimY = cyruntime.cudaDeviceAttr.cudaDevAttrMaxBlockDimY

    #: Maximum block dimension Z
    cudaDevAttrMaxBlockDimZ = cyruntime.cudaDeviceAttr.cudaDevAttrMaxBlockDimZ

    #: Maximum grid dimension X
    cudaDevAttrMaxGridDimX = cyruntime.cudaDeviceAttr.cudaDevAttrMaxGridDimX

    #: Maximum grid dimension Y
    cudaDevAttrMaxGridDimY = cyruntime.cudaDeviceAttr.cudaDevAttrMaxGridDimY

    #: Maximum grid dimension Z
    cudaDevAttrMaxGridDimZ = cyruntime.cudaDeviceAttr.cudaDevAttrMaxGridDimZ

    #: Maximum shared memory available per block in bytes
    cudaDevAttrMaxSharedMemoryPerBlock = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSharedMemoryPerBlock

    #: Memory available on device for constant variables in a CUDA C kernel
    #: in bytes
    cudaDevAttrTotalConstantMemory = cyruntime.cudaDeviceAttr.cudaDevAttrTotalConstantMemory

    #: Warp size in threads
    cudaDevAttrWarpSize = cyruntime.cudaDeviceAttr.cudaDevAttrWarpSize

    #: Maximum pitch in bytes allowed by memory copies
    cudaDevAttrMaxPitch = cyruntime.cudaDeviceAttr.cudaDevAttrMaxPitch

    #: Maximum number of 32-bit registers available per block
    cudaDevAttrMaxRegistersPerBlock = cyruntime.cudaDeviceAttr.cudaDevAttrMaxRegistersPerBlock

    #: Peak clock frequency in kilohertz
    cudaDevAttrClockRate = cyruntime.cudaDeviceAttr.cudaDevAttrClockRate

    #: Alignment requirement for textures
    cudaDevAttrTextureAlignment = cyruntime.cudaDeviceAttr.cudaDevAttrTextureAlignment

    #: Device can possibly copy memory and execute a kernel concurrently
    cudaDevAttrGpuOverlap = cyruntime.cudaDeviceAttr.cudaDevAttrGpuOverlap

    #: Number of multiprocessors on device
    cudaDevAttrMultiProcessorCount = cyruntime.cudaDeviceAttr.cudaDevAttrMultiProcessorCount

    #: Specifies whether there is a run time limit on kernels
    cudaDevAttrKernelExecTimeout = cyruntime.cudaDeviceAttr.cudaDevAttrKernelExecTimeout

    #: Device is integrated with host memory
    cudaDevAttrIntegrated = cyruntime.cudaDeviceAttr.cudaDevAttrIntegrated

    #: Device can map host memory into CUDA address space
    cudaDevAttrCanMapHostMemory = cyruntime.cudaDeviceAttr.cudaDevAttrCanMapHostMemory

    #: Compute mode (See :py:obj:`~.cudaComputeMode` for details)
    cudaDevAttrComputeMode = cyruntime.cudaDeviceAttr.cudaDevAttrComputeMode

    #: Maximum 1D texture width
    cudaDevAttrMaxTexture1DWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture1DWidth

    #: Maximum 2D texture width
    cudaDevAttrMaxTexture2DWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture2DWidth

    #: Maximum 2D texture height
    cudaDevAttrMaxTexture2DHeight = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture2DHeight

    #: Maximum 3D texture width
    cudaDevAttrMaxTexture3DWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture3DWidth

    #: Maximum 3D texture height
    cudaDevAttrMaxTexture3DHeight = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture3DHeight

    #: Maximum 3D texture depth
    cudaDevAttrMaxTexture3DDepth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture3DDepth

    #: Maximum 2D layered texture width
    cudaDevAttrMaxTexture2DLayeredWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture2DLayeredWidth

    #: Maximum 2D layered texture height
    cudaDevAttrMaxTexture2DLayeredHeight = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture2DLayeredHeight

    #: Maximum layers in a 2D layered texture
    cudaDevAttrMaxTexture2DLayeredLayers = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture2DLayeredLayers

    #: Alignment requirement for surfaces
    cudaDevAttrSurfaceAlignment = cyruntime.cudaDeviceAttr.cudaDevAttrSurfaceAlignment

    #: Device can possibly execute multiple kernels concurrently
    cudaDevAttrConcurrentKernels = cyruntime.cudaDeviceAttr.cudaDevAttrConcurrentKernels

    #: Device has ECC support enabled
    cudaDevAttrEccEnabled = cyruntime.cudaDeviceAttr.cudaDevAttrEccEnabled

    #: PCI bus ID of the device
    cudaDevAttrPciBusId = cyruntime.cudaDeviceAttr.cudaDevAttrPciBusId

    #: PCI device ID of the device
    cudaDevAttrPciDeviceId = cyruntime.cudaDeviceAttr.cudaDevAttrPciDeviceId

    #: Device is using TCC driver model
    cudaDevAttrTccDriver = cyruntime.cudaDeviceAttr.cudaDevAttrTccDriver

    #: Peak memory clock frequency in kilohertz
    cudaDevAttrMemoryClockRate = cyruntime.cudaDeviceAttr.cudaDevAttrMemoryClockRate

    #: Global memory bus width in bits
    cudaDevAttrGlobalMemoryBusWidth = cyruntime.cudaDeviceAttr.cudaDevAttrGlobalMemoryBusWidth

    #: Size of L2 cache in bytes
    cudaDevAttrL2CacheSize = cyruntime.cudaDeviceAttr.cudaDevAttrL2CacheSize

    #: Maximum resident threads per multiprocessor
    cudaDevAttrMaxThreadsPerMultiProcessor = cyruntime.cudaDeviceAttr.cudaDevAttrMaxThreadsPerMultiProcessor

    #: Number of asynchronous engines
    cudaDevAttrAsyncEngineCount = cyruntime.cudaDeviceAttr.cudaDevAttrAsyncEngineCount

    #: Device shares a unified address space with the host
    cudaDevAttrUnifiedAddressing = cyruntime.cudaDeviceAttr.cudaDevAttrUnifiedAddressing

    #: Maximum 1D layered texture width
    cudaDevAttrMaxTexture1DLayeredWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture1DLayeredWidth

    #: Maximum layers in a 1D layered texture
    cudaDevAttrMaxTexture1DLayeredLayers = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture1DLayeredLayers

    #: Maximum 2D texture width if cudaArrayTextureGather is set
    cudaDevAttrMaxTexture2DGatherWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture2DGatherWidth

    #: Maximum 2D texture height if cudaArrayTextureGather is set
    cudaDevAttrMaxTexture2DGatherHeight = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture2DGatherHeight

    #: Alternate maximum 3D texture width
    cudaDevAttrMaxTexture3DWidthAlt = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture3DWidthAlt

    #: Alternate maximum 3D texture height
    cudaDevAttrMaxTexture3DHeightAlt = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture3DHeightAlt

    #: Alternate maximum 3D texture depth
    cudaDevAttrMaxTexture3DDepthAlt = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture3DDepthAlt

    #: PCI domain ID of the device
    cudaDevAttrPciDomainId = cyruntime.cudaDeviceAttr.cudaDevAttrPciDomainId

    #: Pitch alignment requirement for textures
    cudaDevAttrTexturePitchAlignment = cyruntime.cudaDeviceAttr.cudaDevAttrTexturePitchAlignment

    #: Maximum cubemap texture width/height
    cudaDevAttrMaxTextureCubemapWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTextureCubemapWidth

    #: Maximum cubemap layered texture width/height
    cudaDevAttrMaxTextureCubemapLayeredWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTextureCubemapLayeredWidth

    #: Maximum layers in a cubemap layered texture
    cudaDevAttrMaxTextureCubemapLayeredLayers = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTextureCubemapLayeredLayers

    #: Maximum 1D surface width
    cudaDevAttrMaxSurface1DWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurface1DWidth

    #: Maximum 2D surface width
    cudaDevAttrMaxSurface2DWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurface2DWidth

    #: Maximum 2D surface height
    cudaDevAttrMaxSurface2DHeight = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurface2DHeight

    #: Maximum 3D surface width
    cudaDevAttrMaxSurface3DWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurface3DWidth

    #: Maximum 3D surface height
    cudaDevAttrMaxSurface3DHeight = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurface3DHeight

    #: Maximum 3D surface depth
    cudaDevAttrMaxSurface3DDepth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurface3DDepth

    #: Maximum 1D layered surface width
    cudaDevAttrMaxSurface1DLayeredWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurface1DLayeredWidth

    #: Maximum layers in a 1D layered surface
    cudaDevAttrMaxSurface1DLayeredLayers = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurface1DLayeredLayers

    #: Maximum 2D layered surface width
    cudaDevAttrMaxSurface2DLayeredWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurface2DLayeredWidth

    #: Maximum 2D layered surface height
    cudaDevAttrMaxSurface2DLayeredHeight = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurface2DLayeredHeight

    #: Maximum layers in a 2D layered surface
    cudaDevAttrMaxSurface2DLayeredLayers = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurface2DLayeredLayers

    #: Maximum cubemap surface width
    cudaDevAttrMaxSurfaceCubemapWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurfaceCubemapWidth

    #: Maximum cubemap layered surface width
    cudaDevAttrMaxSurfaceCubemapLayeredWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurfaceCubemapLayeredWidth

    #: Maximum layers in a cubemap layered surface
    cudaDevAttrMaxSurfaceCubemapLayeredLayers = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSurfaceCubemapLayeredLayers

    #: Maximum 1D linear texture width
    cudaDevAttrMaxTexture1DLinearWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture1DLinearWidth

    #: Maximum 2D linear texture width
    cudaDevAttrMaxTexture2DLinearWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture2DLinearWidth

    #: Maximum 2D linear texture height
    cudaDevAttrMaxTexture2DLinearHeight = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture2DLinearHeight

    #: Maximum 2D linear texture pitch in bytes
    cudaDevAttrMaxTexture2DLinearPitch = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture2DLinearPitch

    #: Maximum mipmapped 2D texture width
    cudaDevAttrMaxTexture2DMipmappedWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture2DMipmappedWidth

    #: Maximum mipmapped 2D texture height
    cudaDevAttrMaxTexture2DMipmappedHeight = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture2DMipmappedHeight

    #: Major compute capability version number
    cudaDevAttrComputeCapabilityMajor = cyruntime.cudaDeviceAttr.cudaDevAttrComputeCapabilityMajor

    #: Minor compute capability version number
    cudaDevAttrComputeCapabilityMinor = cyruntime.cudaDeviceAttr.cudaDevAttrComputeCapabilityMinor

    #: Maximum mipmapped 1D texture width
    cudaDevAttrMaxTexture1DMipmappedWidth = cyruntime.cudaDeviceAttr.cudaDevAttrMaxTexture1DMipmappedWidth

    #: Device supports stream priorities
    cudaDevAttrStreamPrioritiesSupported = cyruntime.cudaDeviceAttr.cudaDevAttrStreamPrioritiesSupported

    #: Device supports caching globals in L1
    cudaDevAttrGlobalL1CacheSupported = cyruntime.cudaDeviceAttr.cudaDevAttrGlobalL1CacheSupported

    #: Device supports caching locals in L1
    cudaDevAttrLocalL1CacheSupported = cyruntime.cudaDeviceAttr.cudaDevAttrLocalL1CacheSupported

    #: Maximum shared memory available per multiprocessor in bytes
    cudaDevAttrMaxSharedMemoryPerMultiprocessor = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSharedMemoryPerMultiprocessor

    #: Maximum number of 32-bit registers available per multiprocessor
    cudaDevAttrMaxRegistersPerMultiprocessor = cyruntime.cudaDeviceAttr.cudaDevAttrMaxRegistersPerMultiprocessor

    #: Device can allocate managed memory on this system
    cudaDevAttrManagedMemory = cyruntime.cudaDeviceAttr.cudaDevAttrManagedMemory

    #: Device is on a multi-GPU board
    cudaDevAttrIsMultiGpuBoard = cyruntime.cudaDeviceAttr.cudaDevAttrIsMultiGpuBoard

    #: Unique identifier for a group of devices on the same multi-GPU board
    cudaDevAttrMultiGpuBoardGroupID = cyruntime.cudaDeviceAttr.cudaDevAttrMultiGpuBoardGroupID

    #: Link between the device and the host supports native atomic
    #: operations
    cudaDevAttrHostNativeAtomicSupported = cyruntime.cudaDeviceAttr.cudaDevAttrHostNativeAtomicSupported

    #: Ratio of single precision performance (in floating-point operations
    #: per second) to double precision performance
    cudaDevAttrSingleToDoublePrecisionPerfRatio = cyruntime.cudaDeviceAttr.cudaDevAttrSingleToDoublePrecisionPerfRatio

    #: Device supports coherently accessing pageable memory without calling
    #: cudaHostRegister on it
    cudaDevAttrPageableMemoryAccess = cyruntime.cudaDeviceAttr.cudaDevAttrPageableMemoryAccess

    #: Device can coherently access managed memory concurrently with the
    #: CPU
    cudaDevAttrConcurrentManagedAccess = cyruntime.cudaDeviceAttr.cudaDevAttrConcurrentManagedAccess

    #: Device supports Compute Preemption
    cudaDevAttrComputePreemptionSupported = cyruntime.cudaDeviceAttr.cudaDevAttrComputePreemptionSupported

    #: Device can access host registered memory at the same virtual address
    #: as the CPU
    cudaDevAttrCanUseHostPointerForRegisteredMem = cyruntime.cudaDeviceAttr.cudaDevAttrCanUseHostPointerForRegisteredMem
    cudaDevAttrReserved92 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved92
    cudaDevAttrReserved93 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved93
    cudaDevAttrReserved94 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved94

    #: Device supports launching cooperative kernels via
    #: :py:obj:`~.cudaLaunchCooperativeKernel`
    cudaDevAttrCooperativeLaunch = cyruntime.cudaDeviceAttr.cudaDevAttrCooperativeLaunch
    cudaDevAttrReserved96 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved96

    #: The maximum optin shared memory per block. This value may vary by
    #: chip. See :py:obj:`~.cudaFuncSetAttribute`
    cudaDevAttrMaxSharedMemoryPerBlockOptin = cyruntime.cudaDeviceAttr.cudaDevAttrMaxSharedMemoryPerBlockOptin

    #: Device supports flushing of outstanding remote writes.
    cudaDevAttrCanFlushRemoteWrites = cyruntime.cudaDeviceAttr.cudaDevAttrCanFlushRemoteWrites

    #: Device supports host memory registration via
    #: :py:obj:`~.cudaHostRegister`.
    cudaDevAttrHostRegisterSupported = cyruntime.cudaDeviceAttr.cudaDevAttrHostRegisterSupported

    #: Device accesses pageable memory via the host's page tables.
    cudaDevAttrPageableMemoryAccessUsesHostPageTables = cyruntime.cudaDeviceAttr.cudaDevAttrPageableMemoryAccessUsesHostPageTables

    #: Host can directly access managed memory on the device without
    #: migration.
    cudaDevAttrDirectManagedMemAccessFromHost = cyruntime.cudaDeviceAttr.cudaDevAttrDirectManagedMemAccessFromHost

    #: Maximum number of blocks per multiprocessor
    cudaDevAttrMaxBlocksPerMultiprocessor = cyruntime.cudaDeviceAttr.cudaDevAttrMaxBlocksPerMultiprocessor

    #: Maximum L2 persisting lines capacity setting in bytes.
    cudaDevAttrMaxPersistingL2CacheSize = cyruntime.cudaDeviceAttr.cudaDevAttrMaxPersistingL2CacheSize

    #: Maximum value of :py:obj:`~.cudaAccessPolicyWindow.num_bytes`.
    cudaDevAttrMaxAccessPolicyWindowSize = cyruntime.cudaDeviceAttr.cudaDevAttrMaxAccessPolicyWindowSize

    #: Shared memory reserved by CUDA driver per block in bytes
    cudaDevAttrReservedSharedMemoryPerBlock = cyruntime.cudaDeviceAttr.cudaDevAttrReservedSharedMemoryPerBlock

    #: Device supports sparse CUDA arrays and sparse CUDA mipmapped arrays
    cudaDevAttrSparseCudaArraySupported = cyruntime.cudaDeviceAttr.cudaDevAttrSparseCudaArraySupported

    #: Device supports using the :py:obj:`~.cudaHostRegister` flag
    #: cudaHostRegisterReadOnly to register memory that must be mapped as
    #: read-only to the GPU
    cudaDevAttrHostRegisterReadOnlySupported = cyruntime.cudaDeviceAttr.cudaDevAttrHostRegisterReadOnlySupported

    #: External timeline semaphore interop is supported on the device
    cudaDevAttrTimelineSemaphoreInteropSupported = cyruntime.cudaDeviceAttr.cudaDevAttrTimelineSemaphoreInteropSupported

    #: Device supports using the :py:obj:`~.cudaMallocAsync` and
    #: :py:obj:`~.cudaMemPool` family of APIs
    cudaDevAttrMemoryPoolsSupported = cyruntime.cudaDeviceAttr.cudaDevAttrMemoryPoolsSupported

    #: Device supports GPUDirect RDMA APIs, like nvidia_p2p_get_pages (see
    #: https://docs.nvidia.com/cuda/gpudirect-rdma for more information)
    cudaDevAttrGPUDirectRDMASupported = cyruntime.cudaDeviceAttr.cudaDevAttrGPUDirectRDMASupported

    #: The returned attribute shall be interpreted as a bitmask, where the
    #: individual bits are listed in the
    #: :py:obj:`~.cudaFlushGPUDirectRDMAWritesOptions` enum
    cudaDevAttrGPUDirectRDMAFlushWritesOptions = cyruntime.cudaDeviceAttr.cudaDevAttrGPUDirectRDMAFlushWritesOptions

    #: GPUDirect RDMA writes to the device do not need to be flushed for
    #: consumers within the scope indicated by the returned attribute. See
    #: :py:obj:`~.cudaGPUDirectRDMAWritesOrdering` for the numerical values
    #: returned here.
    cudaDevAttrGPUDirectRDMAWritesOrdering = cyruntime.cudaDeviceAttr.cudaDevAttrGPUDirectRDMAWritesOrdering

    #: Handle types supported with mempool based IPC
    cudaDevAttrMemoryPoolSupportedHandleTypes = cyruntime.cudaDeviceAttr.cudaDevAttrMemoryPoolSupportedHandleTypes

    #: Indicates device supports cluster launch
    cudaDevAttrClusterLaunch = cyruntime.cudaDeviceAttr.cudaDevAttrClusterLaunch

    #: Device supports deferred mapping CUDA arrays and CUDA mipmapped
    #: arrays
    cudaDevAttrDeferredMappingCudaArraySupported = cyruntime.cudaDeviceAttr.cudaDevAttrDeferredMappingCudaArraySupported
    cudaDevAttrReserved122 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved122
    cudaDevAttrReserved123 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved123
    cudaDevAttrReserved124 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved124

    #: Device supports IPC Events.
    cudaDevAttrIpcEventSupport = cyruntime.cudaDeviceAttr.cudaDevAttrIpcEventSupport

    #: Number of memory synchronization domains the device supports.
    cudaDevAttrMemSyncDomainCount = cyruntime.cudaDeviceAttr.cudaDevAttrMemSyncDomainCount
    cudaDevAttrReserved127 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved127
    cudaDevAttrReserved128 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved128
    cudaDevAttrReserved129 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved129

    #: NUMA configuration of a device: value is of type
    #: :py:obj:`~.cudaDeviceNumaConfig` enum
    cudaDevAttrNumaConfig = cyruntime.cudaDeviceAttr.cudaDevAttrNumaConfig

    #: NUMA node ID of the GPU memory
    cudaDevAttrNumaId = cyruntime.cudaDeviceAttr.cudaDevAttrNumaId
    cudaDevAttrReserved132 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved132

    #: Contexts created on this device will be shared via MPS
    cudaDevAttrMpsEnabled = cyruntime.cudaDeviceAttr.cudaDevAttrMpsEnabled

    #: NUMA ID of the host node closest to the device or -1 when system
    #: does not support NUMA
    cudaDevAttrHostNumaId = cyruntime.cudaDeviceAttr.cudaDevAttrHostNumaId

    #: Device supports CIG with D3D12.
    cudaDevAttrD3D12CigSupported = cyruntime.cudaDeviceAttr.cudaDevAttrD3D12CigSupported

    #: Device supports CIG with Vulkan.
    cudaDevAttrVulkanCigSupported = cyruntime.cudaDeviceAttr.cudaDevAttrVulkanCigSupported

    #: The combined 16-bit PCI device ID and 16-bit PCI vendor ID.
    cudaDevAttrGpuPciDeviceId = cyruntime.cudaDeviceAttr.cudaDevAttrGpuPciDeviceId

    #: The combined 16-bit PCI subsystem ID and 16-bit PCI subsystem vendor
    #: ID.
    cudaDevAttrGpuPciSubsystemId = cyruntime.cudaDeviceAttr.cudaDevAttrGpuPciSubsystemId
    cudaDevAttrReserved141 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved141

    #: Device supports HOST_NUMA location with the
    #: :py:obj:`~.cudaMallocAsync` and :py:obj:`~.cudaMemPool` family of
    #: APIs
    cudaDevAttrHostNumaMemoryPoolsSupported = cyruntime.cudaDeviceAttr.cudaDevAttrHostNumaMemoryPoolsSupported

    #: Device supports HostNuma location IPC between nodes in a multi-node
    #: system.
    cudaDevAttrHostNumaMultinodeIpcSupported = cyruntime.cudaDeviceAttr.cudaDevAttrHostNumaMultinodeIpcSupported

    #: Device suports HOST location with the :py:obj:`~.cuMemAllocAsync`
    #: and :py:obj:`~.cuMemPool` family of APIs
    cudaDevAttrHostMemoryPoolsSupported = cyruntime.cudaDeviceAttr.cudaDevAttrHostMemoryPoolsSupported
    cudaDevAttrReserved145 = cyruntime.cudaDeviceAttr.cudaDevAttrReserved145

    #: Link between the device and the host supports only some native
    #: atomic operations
    cudaDevAttrOnlyPartialHostNativeAtomicSupported = cyruntime.cudaDeviceAttr.cudaDevAttrOnlyPartialHostNativeAtomicSupported
    cudaDevAttrMax = cyruntime.cudaDeviceAttr.cudaDevAttrMax

_dict_cudaDeviceAttr = dict(((int(v), v) for k, v in cudaDeviceAttr.__members__.items()))

class cudaMemPoolAttr(IntEnum):
    """
    CUDA memory pool attributes
    """

    #: (value type = int) Allow cuMemAllocAsync to use memory
    #: asynchronously freed in another streams as long as a stream ordering
    #: dependency of the allocating stream on the free action exists. Cuda
    #: events and null stream interactions can create the required stream
    #: ordered dependencies. (default enabled)
    cudaMemPoolReuseFollowEventDependencies = cyruntime.cudaMemPoolAttr.cudaMemPoolReuseFollowEventDependencies

    #: (value type = int) Allow reuse of already completed frees when there
    #: is no dependency between the free and allocation. (default enabled)
    cudaMemPoolReuseAllowOpportunistic = cyruntime.cudaMemPoolAttr.cudaMemPoolReuseAllowOpportunistic

    #: (value type = int) Allow cuMemAllocAsync to insert new stream
    #: dependencies in order to establish the stream ordering required to
    #: reuse a piece of memory released by cuFreeAsync (default enabled).
    cudaMemPoolReuseAllowInternalDependencies = cyruntime.cudaMemPoolAttr.cudaMemPoolReuseAllowInternalDependencies

    #: (value type = cuuint64_t) Amount of reserved memory in bytes to hold
    #: onto before trying to release memory back to the OS. When more than
    #: the release threshold bytes of memory are held by the memory pool,
    #: the allocator will try to release memory back to the OS on the next
    #: call to stream, event or context synchronize. (default 0)
    cudaMemPoolAttrReleaseThreshold = cyruntime.cudaMemPoolAttr.cudaMemPoolAttrReleaseThreshold

    #: (value type = cuuint64_t) Amount of backing memory currently
    #: allocated for the mempool.
    cudaMemPoolAttrReservedMemCurrent = cyruntime.cudaMemPoolAttr.cudaMemPoolAttrReservedMemCurrent

    #: (value type = cuuint64_t) High watermark of backing memory allocated
    #: for the mempool since the last time it was reset. High watermark can
    #: only be reset to zero.
    cudaMemPoolAttrReservedMemHigh = cyruntime.cudaMemPoolAttr.cudaMemPoolAttrReservedMemHigh

    #: (value type = cuuint64_t) Amount of memory from the pool that is
    #: currently in use by the application.
    cudaMemPoolAttrUsedMemCurrent = cyruntime.cudaMemPoolAttr.cudaMemPoolAttrUsedMemCurrent

    #: (value type = cuuint64_t) High watermark of the amount of memory
    #: from the pool that was in use by the application since the last time
    #: it was reset. High watermark can only be reset to zero.
    cudaMemPoolAttrUsedMemHigh = cyruntime.cudaMemPoolAttr.cudaMemPoolAttrUsedMemHigh

_dict_cudaMemPoolAttr = dict(((int(v), v) for k, v in cudaMemPoolAttr.__members__.items()))

class cudaMemLocationType(IntEnum):
    """
    Specifies the type of location
    """
    cudaMemLocationTypeInvalid = cyruntime.cudaMemLocationType.cudaMemLocationTypeInvalid

    #: Location is unspecified. This is used when creating a managed memory
    #: pool to indicate no preferred location for the pool
    cudaMemLocationTypeNone = cyruntime.cudaMemLocationType.cudaMemLocationTypeNone

    #: Location is a device location, thus id is a device ordinal
    cudaMemLocationTypeDevice = cyruntime.cudaMemLocationType.cudaMemLocationTypeDevice

    #: Location is host, id is ignored
    cudaMemLocationTypeHost = cyruntime.cudaMemLocationType.cudaMemLocationTypeHost

    #: Location is a host NUMA node, thus id is a host NUMA node id
    cudaMemLocationTypeHostNuma = cyruntime.cudaMemLocationType.cudaMemLocationTypeHostNuma

    #: Location is the host NUMA node closest to the current thread's CPU,
    #: id is ignored
    cudaMemLocationTypeHostNumaCurrent = cyruntime.cudaMemLocationType.cudaMemLocationTypeHostNumaCurrent

_dict_cudaMemLocationType = dict(((int(v), v) for k, v in cudaMemLocationType.__members__.items()))

class cudaMemAccessFlags(IntEnum):
    """
    Specifies the memory protection flags for mapping.
    """

    #: Default, make the address range not accessible
    cudaMemAccessFlagsProtNone = cyruntime.cudaMemAccessFlags.cudaMemAccessFlagsProtNone

    #: Make the address range read accessible
    cudaMemAccessFlagsProtRead = cyruntime.cudaMemAccessFlags.cudaMemAccessFlagsProtRead

    #: Make the address range read-write accessible
    cudaMemAccessFlagsProtReadWrite = cyruntime.cudaMemAccessFlags.cudaMemAccessFlagsProtReadWrite

_dict_cudaMemAccessFlags = dict(((int(v), v) for k, v in cudaMemAccessFlags.__members__.items()))

class cudaMemAllocationType(IntEnum):
    """
    Defines the allocation types available
    """
    cudaMemAllocationTypeInvalid = cyruntime.cudaMemAllocationType.cudaMemAllocationTypeInvalid

    #: This allocation type is 'pinned', i.e. cannot migrate from its
    #: current location while the application is actively using it
    cudaMemAllocationTypePinned = cyruntime.cudaMemAllocationType.cudaMemAllocationTypePinned

    #: This allocation type is managed memory
    cudaMemAllocationTypeManaged = cyruntime.cudaMemAllocationType.cudaMemAllocationTypeManaged
    cudaMemAllocationTypeMax = cyruntime.cudaMemAllocationType.cudaMemAllocationTypeMax

_dict_cudaMemAllocationType = dict(((int(v), v) for k, v in cudaMemAllocationType.__members__.items()))

class cudaMemAllocationHandleType(IntEnum):
    """
    Flags for specifying particular handle types
    """

    #: Does not allow any export mechanism. >
    cudaMemHandleTypeNone = cyruntime.cudaMemAllocationHandleType.cudaMemHandleTypeNone

    #: Allows a file descriptor to be used for exporting. Permitted only on
    #: POSIX systems. (int)
    cudaMemHandleTypePosixFileDescriptor = cyruntime.cudaMemAllocationHandleType.cudaMemHandleTypePosixFileDescriptor

    #: Allows a Win32 NT handle to be used for exporting. (HANDLE)
    cudaMemHandleTypeWin32 = cyruntime.cudaMemAllocationHandleType.cudaMemHandleTypeWin32

    #: Allows a Win32 KMT handle to be used for exporting. (D3DKMT_HANDLE)
    cudaMemHandleTypeWin32Kmt = cyruntime.cudaMemAllocationHandleType.cudaMemHandleTypeWin32Kmt

    #: Allows a fabric handle to be used for exporting.
    #: (cudaMemFabricHandle_t)
    cudaMemHandleTypeFabric = cyruntime.cudaMemAllocationHandleType.cudaMemHandleTypeFabric

_dict_cudaMemAllocationHandleType = dict(((int(v), v) for k, v in cudaMemAllocationHandleType.__members__.items()))

class cudaGraphMemAttributeType(IntEnum):
    """
    Graph memory attributes
    """

    #: (value type = cuuint64_t) Amount of memory, in bytes, currently
    #: associated with graphs.
    cudaGraphMemAttrUsedMemCurrent = cyruntime.cudaGraphMemAttributeType.cudaGraphMemAttrUsedMemCurrent

    #: (value type = cuuint64_t) High watermark of memory, in bytes,
    #: associated with graphs since the last time it was reset. High
    #: watermark can only be reset to zero.
    cudaGraphMemAttrUsedMemHigh = cyruntime.cudaGraphMemAttributeType.cudaGraphMemAttrUsedMemHigh

    #: (value type = cuuint64_t) Amount of memory, in bytes, currently
    #: allocated for use by the CUDA graphs asynchronous allocator.
    cudaGraphMemAttrReservedMemCurrent = cyruntime.cudaGraphMemAttributeType.cudaGraphMemAttrReservedMemCurrent

    #: (value type = cuuint64_t) High watermark of memory, in bytes,
    #: currently allocated for use by the CUDA graphs asynchronous
    #: allocator.
    cudaGraphMemAttrReservedMemHigh = cyruntime.cudaGraphMemAttributeType.cudaGraphMemAttrReservedMemHigh

_dict_cudaGraphMemAttributeType = dict(((int(v), v) for k, v in cudaGraphMemAttributeType.__members__.items()))

class cudaMemcpyFlags(IntEnum):
    """
    Flags to specify for copies within a batch. For more details see
    :py:obj:`~.cudaMemcpyBatchAsync`.
    """
    cudaMemcpyFlagDefault = cyruntime.cudaMemcpyFlags.cudaMemcpyFlagDefault

    #: Hint to the driver to try and overlap the copy with compute work on
    #: the SMs.
    cudaMemcpyFlagPreferOverlapWithCompute = cyruntime.cudaMemcpyFlags.cudaMemcpyFlagPreferOverlapWithCompute

_dict_cudaMemcpyFlags = dict(((int(v), v) for k, v in cudaMemcpyFlags.__members__.items()))

class cudaMemcpySrcAccessOrder(IntEnum):
    """

    """

    #: Default invalid.
    cudaMemcpySrcAccessOrderInvalid = cyruntime.cudaMemcpySrcAccessOrder.cudaMemcpySrcAccessOrderInvalid

    #: Indicates that access to the source pointer must be in stream order.
    cudaMemcpySrcAccessOrderStream = cyruntime.cudaMemcpySrcAccessOrder.cudaMemcpySrcAccessOrderStream

    #: Indicates that access to the source pointer can be out of stream
    #: order and all accesses must be complete before the API call returns.
    #: This flag is suited for ephemeral sources (ex., stack variables)
    #: when it's known that no prior operations in the stream can be
    #: accessing the memory and also that the lifetime of the memory is
    #: limited to the scope that the source variable was declared in.
    #: Specifying this flag allows the driver to optimize the copy and
    #: removes the need for the user to synchronize the stream after the
    #: API call.
    cudaMemcpySrcAccessOrderDuringApiCall = cyruntime.cudaMemcpySrcAccessOrder.cudaMemcpySrcAccessOrderDuringApiCall

    #: Indicates that access to the source pointer can be out of stream
    #: order and the accesses can happen even after the API call returns.
    #: This flag is suited for host pointers allocated outside CUDA (ex.,
    #: via malloc) when it's known that no prior operations in the stream
    #: can be accessing the memory. Specifying this flag allows the driver
    #: to optimize the copy on certain platforms.
    cudaMemcpySrcAccessOrderAny = cyruntime.cudaMemcpySrcAccessOrder.cudaMemcpySrcAccessOrderAny
    cudaMemcpySrcAccessOrderMax = cyruntime.cudaMemcpySrcAccessOrder.cudaMemcpySrcAccessOrderMax

_dict_cudaMemcpySrcAccessOrder = dict(((int(v), v) for k, v in cudaMemcpySrcAccessOrder.__members__.items()))

class cudaMemcpy3DOperandType(IntEnum):
    """
    These flags allow applications to convey the operand type for
    individual copies specified in :py:obj:`~.cudaMemcpy3DBatchAsync`.
    """

    #: Memcpy operand is a valid pointer.
    cudaMemcpyOperandTypePointer = cyruntime.cudaMemcpy3DOperandType.cudaMemcpyOperandTypePointer

    #: Memcpy operand is a CUarray.
    cudaMemcpyOperandTypeArray = cyruntime.cudaMemcpy3DOperandType.cudaMemcpyOperandTypeArray
    cudaMemcpyOperandTypeMax = cyruntime.cudaMemcpy3DOperandType.cudaMemcpyOperandTypeMax

_dict_cudaMemcpy3DOperandType = dict(((int(v), v) for k, v in cudaMemcpy3DOperandType.__members__.items()))

class cudaDeviceP2PAttr(IntEnum):
    """
    CUDA device P2P attributes
    """

    #: A relative value indicating the performance of the link between two
    #: devices
    cudaDevP2PAttrPerformanceRank = cyruntime.cudaDeviceP2PAttr.cudaDevP2PAttrPerformanceRank

    #: Peer access is enabled
    cudaDevP2PAttrAccessSupported = cyruntime.cudaDeviceP2PAttr.cudaDevP2PAttrAccessSupported

    #: Native atomic operation over the link supported
    cudaDevP2PAttrNativeAtomicSupported = cyruntime.cudaDeviceP2PAttr.cudaDevP2PAttrNativeAtomicSupported

    #: Accessing CUDA arrays over the link supported
    cudaDevP2PAttrCudaArrayAccessSupported = cyruntime.cudaDeviceP2PAttr.cudaDevP2PAttrCudaArrayAccessSupported

    #: Only some CUDA-valid atomic operations over the link are supported.
    cudaDevP2PAttrOnlyPartialNativeAtomicSupported = cyruntime.cudaDeviceP2PAttr.cudaDevP2PAttrOnlyPartialNativeAtomicSupported

_dict_cudaDeviceP2PAttr = dict(((int(v), v) for k, v in cudaDeviceP2PAttr.__members__.items()))

class cudaAtomicOperation(IntEnum):
    """
    CUDA-valid Atomic Operations
    """
    cudaAtomicOperationIntegerAdd = cyruntime.cudaAtomicOperation.cudaAtomicOperationIntegerAdd
    cudaAtomicOperationIntegerMin = cyruntime.cudaAtomicOperation.cudaAtomicOperationIntegerMin
    cudaAtomicOperationIntegerMax = cyruntime.cudaAtomicOperation.cudaAtomicOperationIntegerMax
    cudaAtomicOperationIntegerIncrement = cyruntime.cudaAtomicOperation.cudaAtomicOperationIntegerIncrement
    cudaAtomicOperationIntegerDecrement = cyruntime.cudaAtomicOperation.cudaAtomicOperationIntegerDecrement
    cudaAtomicOperationAnd = cyruntime.cudaAtomicOperation.cudaAtomicOperationAnd
    cudaAtomicOperationOr = cyruntime.cudaAtomicOperation.cudaAtomicOperationOr
    cudaAtomicOperationXOR = cyruntime.cudaAtomicOperation.cudaAtomicOperationXOR
    cudaAtomicOperationExchange = cyruntime.cudaAtomicOperation.cudaAtomicOperationExchange
    cudaAtomicOperationCAS = cyruntime.cudaAtomicOperation.cudaAtomicOperationCAS
    cudaAtomicOperationFloatAdd = cyruntime.cudaAtomicOperation.cudaAtomicOperationFloatAdd
    cudaAtomicOperationFloatMin = cyruntime.cudaAtomicOperation.cudaAtomicOperationFloatMin
    cudaAtomicOperationFloatMax = cyruntime.cudaAtomicOperation.cudaAtomicOperationFloatMax

_dict_cudaAtomicOperation = dict(((int(v), v) for k, v in cudaAtomicOperation.__members__.items()))

class cudaAtomicOperationCapability(IntEnum):
    """
    CUDA-valid Atomic Operation capabilities
    """








_dict_cudaAtomicOperationCapability = dict(((int(v), v) for k, v in cudaAtomicOperationCapability.__members__.items()))

class cudaExternalMemoryHandleType(IntEnum):
    """
    External memory handle types
    """

    #: Handle is an opaque file descriptor
    cudaExternalMemoryHandleTypeOpaqueFd = cyruntime.cudaExternalMemoryHandleType.cudaExternalMemoryHandleTypeOpaqueFd

    #: Handle is an opaque shared NT handle
    cudaExternalMemoryHandleTypeOpaqueWin32 = cyruntime.cudaExternalMemoryHandleType.cudaExternalMemoryHandleTypeOpaqueWin32

    #: Handle is an opaque, globally shared handle
    cudaExternalMemoryHandleTypeOpaqueWin32Kmt = cyruntime.cudaExternalMemoryHandleType.cudaExternalMemoryHandleTypeOpaqueWin32Kmt

    #: Handle is a D3D12 heap object
    cudaExternalMemoryHandleTypeD3D12Heap = cyruntime.cudaExternalMemoryHandleType.cudaExternalMemoryHandleTypeD3D12Heap

    #: Handle is a D3D12 committed resource
    cudaExternalMemoryHandleTypeD3D12Resource = cyruntime.cudaExternalMemoryHandleType.cudaExternalMemoryHandleTypeD3D12Resource

    #: Handle is a shared NT handle to a D3D11 resource
    cudaExternalMemoryHandleTypeD3D11Resource = cyruntime.cudaExternalMemoryHandleType.cudaExternalMemoryHandleTypeD3D11Resource

    #: Handle is a globally shared handle to a D3D11 resource
    cudaExternalMemoryHandleTypeD3D11ResourceKmt = cyruntime.cudaExternalMemoryHandleType.cudaExternalMemoryHandleTypeD3D11ResourceKmt

    #: Handle is an NvSciBuf object
    cudaExternalMemoryHandleTypeNvSciBuf = cyruntime.cudaExternalMemoryHandleType.cudaExternalMemoryHandleTypeNvSciBuf

_dict_cudaExternalMemoryHandleType = dict(((int(v), v) for k, v in cudaExternalMemoryHandleType.__members__.items()))

class cudaExternalSemaphoreHandleType(IntEnum):
    """
    External semaphore handle types
    """

    #: Handle is an opaque file descriptor
    cudaExternalSemaphoreHandleTypeOpaqueFd = cyruntime.cudaExternalSemaphoreHandleType.cudaExternalSemaphoreHandleTypeOpaqueFd

    #: Handle is an opaque shared NT handle
    cudaExternalSemaphoreHandleTypeOpaqueWin32 = cyruntime.cudaExternalSemaphoreHandleType.cudaExternalSemaphoreHandleTypeOpaqueWin32

    #: Handle is an opaque, globally shared handle
    cudaExternalSemaphoreHandleTypeOpaqueWin32Kmt = cyruntime.cudaExternalSemaphoreHandleType.cudaExternalSemaphoreHandleTypeOpaqueWin32Kmt

    #: Handle is a shared NT handle referencing a D3D12 fence object
    cudaExternalSemaphoreHandleTypeD3D12Fence = cyruntime.cudaExternalSemaphoreHandleType.cudaExternalSemaphoreHandleTypeD3D12Fence

    #: Handle is a shared NT handle referencing a D3D11 fence object
    cudaExternalSemaphoreHandleTypeD3D11Fence = cyruntime.cudaExternalSemaphoreHandleType.cudaExternalSemaphoreHandleTypeD3D11Fence

    #: Opaque handle to NvSciSync Object
    cudaExternalSemaphoreHandleTypeNvSciSync = cyruntime.cudaExternalSemaphoreHandleType.cudaExternalSemaphoreHandleTypeNvSciSync

    #: Handle is a shared NT handle referencing a D3D11 keyed mutex object
    cudaExternalSemaphoreHandleTypeKeyedMutex = cyruntime.cudaExternalSemaphoreHandleType.cudaExternalSemaphoreHandleTypeKeyedMutex

    #: Handle is a shared KMT handle referencing a D3D11 keyed mutex object
    cudaExternalSemaphoreHandleTypeKeyedMutexKmt = cyruntime.cudaExternalSemaphoreHandleType.cudaExternalSemaphoreHandleTypeKeyedMutexKmt

    #: Handle is an opaque handle file descriptor referencing a timeline
    #: semaphore
    cudaExternalSemaphoreHandleTypeTimelineSemaphoreFd = cyruntime.cudaExternalSemaphoreHandleType.cudaExternalSemaphoreHandleTypeTimelineSemaphoreFd

    #: Handle is an opaque handle file descriptor referencing a timeline
    #: semaphore
    cudaExternalSemaphoreHandleTypeTimelineSemaphoreWin32 = cyruntime.cudaExternalSemaphoreHandleType.cudaExternalSemaphoreHandleTypeTimelineSemaphoreWin32

_dict_cudaExternalSemaphoreHandleType = dict(((int(v), v) for k, v in cudaExternalSemaphoreHandleType.__members__.items()))

class cudaDevSmResourceGroup_flags(IntEnum):
    """

    """
    cudaDevSmResourceGroupDefault = cyruntime.cudaDevSmResourceGroup_flags.cudaDevSmResourceGroupDefault
    cudaDevSmResourceGroupBackfill = cyruntime.cudaDevSmResourceGroup_flags.cudaDevSmResourceGroupBackfill

_dict_cudaDevSmResourceGroup_flags = dict(((int(v), v) for k, v in cudaDevSmResourceGroup_flags.__members__.items()))

class cudaDevSmResourceSplitByCount_flags(IntEnum):
    """

    """
    cudaDevSmResourceSplitIgnoreSmCoscheduling = cyruntime.cudaDevSmResourceSplitByCount_flags.cudaDevSmResourceSplitIgnoreSmCoscheduling
    cudaDevSmResourceSplitMaxPotentialClusterSize = cyruntime.cudaDevSmResourceSplitByCount_flags.cudaDevSmResourceSplitMaxPotentialClusterSize

_dict_cudaDevSmResourceSplitByCount_flags = dict(((int(v), v) for k, v in cudaDevSmResourceSplitByCount_flags.__members__.items()))

class cudaDevResourceType(IntEnum):
    """
    Type of resource
    """
    cudaDevResourceTypeInvalid = cyruntime.cudaDevResourceType.cudaDevResourceTypeInvalid

    #: Streaming multiprocessors related information
    cudaDevResourceTypeSm = cyruntime.cudaDevResourceType.cudaDevResourceTypeSm

    #: Workqueue configuration related information
    cudaDevResourceTypeWorkqueueConfig = cyruntime.cudaDevResourceType.cudaDevResourceTypeWorkqueueConfig

    #: Pre-existing workqueue related information
    cudaDevResourceTypeWorkqueue = cyruntime.cudaDevResourceType.cudaDevResourceTypeWorkqueue

_dict_cudaDevResourceType = dict(((int(v), v) for k, v in cudaDevResourceType.__members__.items()))

class cudaDevWorkqueueConfigScope(IntEnum):
    """
    Sharing scope for workqueues
    """

    #: Use all shared workqueue resources on the device. Default driver
    #: behaviour.
    cudaDevWorkqueueConfigScopeDeviceCtx = cyruntime.cudaDevWorkqueueConfigScope.cudaDevWorkqueueConfigScopeDeviceCtx

    #: When possible, use non-overlapping workqueue resources with other
    #: balanced green contexts.
    cudaDevWorkqueueConfigScopeGreenCtxBalanced = cyruntime.cudaDevWorkqueueConfigScope.cudaDevWorkqueueConfigScopeGreenCtxBalanced

_dict_cudaDevWorkqueueConfigScope = dict(((int(v), v) for k, v in cudaDevWorkqueueConfigScope.__members__.items()))

class cudaJitOption(IntEnum):
    """
    Online compiler and linker options
    """

    #: Max number of registers that a thread may use.
    #: Option type: unsigned int
    #: Applies to: compiler only
    cudaJitMaxRegisters = cyruntime.cudaJitOption.cudaJitMaxRegisters

    #: IN: Specifies minimum number of threads per block to target
    #: compilation for
    #: OUT: Returns the number of threads the compiler actually targeted.
    #: This restricts the resource utilization of the compiler (e.g. max
    #: registers) such that a block with the given number of threads should
    #: be able to launch based on register limitations. Note, this option
    #: does not currently take into account any other resource limitations,
    #: such as shared memory utilization.
    #: Option type: unsigned int
    #: Applies to: compiler only
    cudaJitThreadsPerBlock = cyruntime.cudaJitOption.cudaJitThreadsPerBlock

    #: Overwrites the option value with the total wall clock time, in
    #: milliseconds, spent in the compiler and linker
    #: Option type: float
    #: Applies to: compiler and linker
    cudaJitWallTime = cyruntime.cudaJitOption.cudaJitWallTime

    #: Pointer to a buffer in which to print any log messages that are
    #: informational in nature (the buffer size is specified via option
    #: :py:obj:`~.cudaJitInfoLogBufferSizeBytes`)
    #: Option type: char *
    #: Applies to: compiler and linker
    cudaJitInfoLogBuffer = cyruntime.cudaJitOption.cudaJitInfoLogBuffer

    #: IN: Log buffer size in bytes. Log messages will be capped at this
    #: size (including null terminator)
    #: OUT: Amount of log buffer filled with messages
    #: Option type: unsigned int
    #: Applies to: compiler and linker
    cudaJitInfoLogBufferSizeBytes = cyruntime.cudaJitOption.cudaJitInfoLogBufferSizeBytes

    #: Pointer to a buffer in which to print any log messages that reflect
    #: errors (the buffer size is specified via option
    #: :py:obj:`~.cudaJitErrorLogBufferSizeBytes`)
    #: Option type: char *
    #: Applies to: compiler and linker
    cudaJitErrorLogBuffer = cyruntime.cudaJitOption.cudaJitErrorLogBuffer

    #: IN: Log buffer size in bytes. Log messages will be capped at this
    #: size (including null terminator)
    #: OUT: Amount of log buffer filled with messages
    #: Option type: unsigned int
    #: Applies to: compiler and linker
    cudaJitErrorLogBufferSizeBytes = cyruntime.cudaJitOption.cudaJitErrorLogBufferSizeBytes

    #: Level of optimizations to apply to generated code (0 - 4), with 4
    #: being the default and highest level of optimizations.
    #: Option type: unsigned int
    #: Applies to: compiler only
    cudaJitOptimizationLevel = cyruntime.cudaJitOption.cudaJitOptimizationLevel

    #: Specifies choice of fallback strategy if matching cubin is not
    #: found. Choice is based on supplied :py:obj:`~.cudaJit_Fallback`.
    #: Option type: unsigned int for enumerated type
    #: :py:obj:`~.cudaJit_Fallback`
    #: Applies to: compiler only
    cudaJitFallbackStrategy = cyruntime.cudaJitOption.cudaJitFallbackStrategy

    #: Specifies whether to create debug information in output (-g) (0:
    #: false, default)
    #: Option type: int
    #: Applies to: compiler and linker
    cudaJitGenerateDebugInfo = cyruntime.cudaJitOption.cudaJitGenerateDebugInfo

    #: Generate verbose log messages (0: false, default)
    #: Option type: int
    #: Applies to: compiler and linker
    cudaJitLogVerbose = cyruntime.cudaJitOption.cudaJitLogVerbose

    #: Generate line number information (-lineinfo) (0: false, default)
    #: Option type: int
    #: Applies to: compiler only
    cudaJitGenerateLineInfo = cyruntime.cudaJitOption.cudaJitGenerateLineInfo

    #: Specifies whether to enable caching explicitly (-dlcm)
    #: Choice is based on supplied :py:obj:`~.cudaJit_CacheMode`.
    #: Option type: unsigned int for enumerated type
    #: :py:obj:`~.cudaJit_CacheMode`
    #: Applies to: compiler only
    cudaJitCacheMode = cyruntime.cudaJitOption.cudaJitCacheMode

    #: Generate position independent code (0: false)
    #: Option type: int
    #: Applies to: compiler only
    cudaJitPositionIndependentCode = cyruntime.cudaJitOption.cudaJitPositionIndependentCode

    #: This option hints to the JIT compiler the minimum number of CTAs
    #: from the kernel’s grid to be mapped to a SM. This option is ignored
    #: when used together with :py:obj:`~.cudaJitMaxRegisters` or
    #: :py:obj:`~.cudaJitThreadsPerBlock`. Optimizations based on this
    #: option need :py:obj:`~.cudaJitMaxThreadsPerBlock` to be specified as
    #: well. For kernels already using PTX directive .minnctapersm, this
    #: option will be ignored by default. Use
    #: :py:obj:`~.cudaJitOverrideDirectiveValues` to let this option take
    #: precedence over the PTX directive. Option type: unsigned int
    #: Applies to: compiler only
    cudaJitMinCtaPerSm = cyruntime.cudaJitOption.cudaJitMinCtaPerSm

    #: Maximum number threads in a thread block, computed as the product of
    #: the maximum extent specifed for each dimension of the block. This
    #: limit is guaranteed not to be exeeded in any invocation of the
    #: kernel. Exceeding the the maximum number of threads results in
    #: runtime error or kernel launch failure. For kernels already using
    #: PTX directive .maxntid, this option will be ignored by default. Use
    #: :py:obj:`~.cudaJitOverrideDirectiveValues` to let this option take
    #: precedence over the PTX directive. Option type: int
    #: Applies to: compiler only
    cudaJitMaxThreadsPerBlock = cyruntime.cudaJitOption.cudaJitMaxThreadsPerBlock

    #: This option lets the values specified using
    #: :py:obj:`~.cudaJitMaxRegisters`, :py:obj:`~.cudaJitThreadsPerBlock`,
    #: :py:obj:`~.cudaJitMaxThreadsPerBlock` and
    #: :py:obj:`~.cudaJitMinCtaPerSm` take precedence over any PTX
    #: directives. (0: Disable, default; 1: Enable) Option type: int
    #: Applies to: compiler only
    cudaJitOverrideDirectiveValues = cyruntime.cudaJitOption.cudaJitOverrideDirectiveValues

_dict_cudaJitOption = dict(((int(v), v) for k, v in cudaJitOption.__members__.items()))

class cudaLibraryOption(IntEnum):
    """
    Library options to be specified with
    :py:obj:`~.cudaLibraryLoadData()` or
    :py:obj:`~.cudaLibraryLoadFromFile()`
    """
    cudaLibraryHostUniversalFunctionAndDataTable = cyruntime.cudaLibraryOption.cudaLibraryHostUniversalFunctionAndDataTable

    #: Specifes that the argument `code` passed to
    #: :py:obj:`~.cudaLibraryLoadData()` will be preserved. Specifying this
    #: option will let the driver know that `code` can be accessed at any
    #: point until :py:obj:`~.cudaLibraryUnload()`. The default behavior is
    #: for the driver to allocate and maintain its own copy of `code`. Note
    #: that this is only a memory usage optimization hint and the driver
    #: can choose to ignore it if required. Specifying this option with
    #: :py:obj:`~.cudaLibraryLoadFromFile()` is invalid and will return
    #: :py:obj:`~.cudaErrorInvalidValue`.
    cudaLibraryBinaryIsPreserved = cyruntime.cudaLibraryOption.cudaLibraryBinaryIsPreserved

_dict_cudaLibraryOption = dict(((int(v), v) for k, v in cudaLibraryOption.__members__.items()))

class cudaJit_CacheMode(IntEnum):
    """
    Caching modes for dlcm
    """

    #: Compile with no -dlcm flag specified
    cudaJitCacheOptionNone = cyruntime.cudaJit_CacheMode.cudaJitCacheOptionNone

    #: Compile with L1 cache disabled
    cudaJitCacheOptionCG = cyruntime.cudaJit_CacheMode.cudaJitCacheOptionCG

    #: Compile with L1 cache enabled
    cudaJitCacheOptionCA = cyruntime.cudaJit_CacheMode.cudaJitCacheOptionCA

_dict_cudaJit_CacheMode = dict(((int(v), v) for k, v in cudaJit_CacheMode.__members__.items()))

class cudaJit_Fallback(IntEnum):
    """
    Cubin matching fallback strategies
    """

    #: Prefer to compile ptx if exact binary match not found
    cudaPreferPtx = cyruntime.cudaJit_Fallback.cudaPreferPtx

    #: Prefer to fall back to compatible binary code if exact match not
    #: found
    cudaPreferBinary = cyruntime.cudaJit_Fallback.cudaPreferBinary

_dict_cudaJit_Fallback = dict(((int(v), v) for k, v in cudaJit_Fallback.__members__.items()))

class cudaCGScope(IntEnum):
    """
    CUDA cooperative group scope
    """

    #: Invalid cooperative group scope
    cudaCGScopeInvalid = cyruntime.cudaCGScope.cudaCGScopeInvalid

    #: Scope represented by a grid_group
    cudaCGScopeGrid = cyruntime.cudaCGScope.cudaCGScopeGrid

    #: Reserved
    cudaCGScopeReserved = cyruntime.cudaCGScope.cudaCGScopeReserved

_dict_cudaCGScope = dict(((int(v), v) for k, v in cudaCGScope.__members__.items()))

class cudaGraphConditionalHandleFlags(IntEnum):
    """

    """

    #: Apply default handle value when graph is launched.
    cudaGraphCondAssignDefault = cyruntime.cudaGraphConditionalHandleFlags.cudaGraphCondAssignDefault

_dict_cudaGraphConditionalHandleFlags = dict(((int(v), v) for k, v in cudaGraphConditionalHandleFlags.__members__.items()))

class cudaGraphConditionalNodeType(IntEnum):
    """
    CUDA conditional node types
    """

    #: Conditional 'if/else' Node. Body[0] executed if condition is non-
    #: zero. If `size` == 2, an optional ELSE graph is created and this is
    #: executed if the condition is zero.
    cudaGraphCondTypeIf = cyruntime.cudaGraphConditionalNodeType.cudaGraphCondTypeIf

    #: Conditional 'while' Node. Body executed repeatedly while condition
    #: value is non-zero.
    cudaGraphCondTypeWhile = cyruntime.cudaGraphConditionalNodeType.cudaGraphCondTypeWhile

    #: Conditional 'switch' Node. Body[n] is executed once, where 'n' is
    #: the value of the condition. If the condition does not match a body
    #: index, no body is launched.
    cudaGraphCondTypeSwitch = cyruntime.cudaGraphConditionalNodeType.cudaGraphCondTypeSwitch

_dict_cudaGraphConditionalNodeType = dict(((int(v), v) for k, v in cudaGraphConditionalNodeType.__members__.items()))

class cudaGraphNodeType(IntEnum):
    """
    CUDA Graph node types
    """

    #: GPU kernel node
    cudaGraphNodeTypeKernel = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeKernel

    #: Memcpy node
    cudaGraphNodeTypeMemcpy = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeMemcpy

    #: Memset node
    cudaGraphNodeTypeMemset = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeMemset

    #: Host (executable) node
    cudaGraphNodeTypeHost = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeHost

    #: Node which executes an embedded graph
    cudaGraphNodeTypeGraph = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeGraph

    #: Empty (no-op) node
    cudaGraphNodeTypeEmpty = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeEmpty

    #: External event wait node
    cudaGraphNodeTypeWaitEvent = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeWaitEvent

    #: External event record node
    cudaGraphNodeTypeEventRecord = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeEventRecord

    #: External semaphore signal node
    cudaGraphNodeTypeExtSemaphoreSignal = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeExtSemaphoreSignal

    #: External semaphore wait node
    cudaGraphNodeTypeExtSemaphoreWait = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeExtSemaphoreWait

    #: Memory allocation node
    cudaGraphNodeTypeMemAlloc = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeMemAlloc

    #: Memory free node
    cudaGraphNodeTypeMemFree = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeMemFree

    #: Conditional node                                    May be used to
    #: implement a conditional execution path or loop
    #:                                    inside of a graph. The graph(s)
    #: contained within the body of the conditional node
    #:                                    can be selectively executed or
    #: iterated upon based on the value of a conditional
    #:                                    variable.
    #:
    #:                                    Handles must be created in
    #: advance of creating the node
    #:                                    using
    #: :py:obj:`~.cudaGraphConditionalHandleCreate`.
    #:
    #:                                    The following restrictions apply
    #: to graphs which contain conditional nodes:
    #:                                      The graph cannot be used in a
    #: child node.
    #:                                      Only one instantiation of the
    #: graph may exist at any point in time.
    #:                                      The graph cannot be cloned.
    #:
    #:                                    To set the control value, supply
    #: a default value when creating the handle and/or
    #:                                    call
    #: :py:obj:`~.cudaGraphSetConditional` from device code.
    cudaGraphNodeTypeConditional = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeConditional
    cudaGraphNodeTypeCount = cyruntime.cudaGraphNodeType.cudaGraphNodeTypeCount

_dict_cudaGraphNodeType = dict(((int(v), v) for k, v in cudaGraphNodeType.__members__.items()))

class cudaGraphChildGraphNodeOwnership(IntEnum):
    """
    Child graph node ownership
    """

    #: Default behavior for a child graph node. Child graph is cloned into
    #: the parent and memory allocation/free nodes can't be present in the
    #: child graph.
    cudaGraphChildGraphOwnershipClone = cyruntime.cudaGraphChildGraphNodeOwnership.cudaGraphChildGraphOwnershipClone

    #: The child graph is moved to the parent. The handle to the child
    #: graph is owned by the parent and will be destroyed when the parent
    #: is destroyed.
    #:
    #: The following restrictions apply to child graphs after they have
    #: been moved: Cannot be independently instantiated or destroyed;
    #: Cannot be added as a child graph of a separate parent graph; Cannot
    #: be used as an argument to cudaGraphExecUpdate; Cannot have
    #: additional memory allocation or free nodes added.
    cudaGraphChildGraphOwnershipMove = cyruntime.cudaGraphChildGraphNodeOwnership.cudaGraphChildGraphOwnershipMove

_dict_cudaGraphChildGraphNodeOwnership = dict(((int(v), v) for k, v in cudaGraphChildGraphNodeOwnership.__members__.items()))

class cudaGraphExecUpdateResult(IntEnum):
    """
    CUDA Graph Update error types
    """

    #: The update succeeded
    cudaGraphExecUpdateSuccess = cyruntime.cudaGraphExecUpdateResult.cudaGraphExecUpdateSuccess

    #: The update failed for an unexpected reason which is described in the
    #: return value of the function
    cudaGraphExecUpdateError = cyruntime.cudaGraphExecUpdateResult.cudaGraphExecUpdateError

    #: The update failed because the topology changed
    cudaGraphExecUpdateErrorTopologyChanged = cyruntime.cudaGraphExecUpdateResult.cudaGraphExecUpdateErrorTopologyChanged

    #: The update failed because a node type changed
    cudaGraphExecUpdateErrorNodeTypeChanged = cyruntime.cudaGraphExecUpdateResult.cudaGraphExecUpdateErrorNodeTypeChanged

    #: The update failed because the function of a kernel node changed
    #: (CUDA driver < 11.2)
    cudaGraphExecUpdateErrorFunctionChanged = cyruntime.cudaGraphExecUpdateResult.cudaGraphExecUpdateErrorFunctionChanged

    #: The update failed because the parameters changed in a way that is
    #: not supported
    cudaGraphExecUpdateErrorParametersChanged = cyruntime.cudaGraphExecUpdateResult.cudaGraphExecUpdateErrorParametersChanged

    #: The update failed because something about the node is not supported
    cudaGraphExecUpdateErrorNotSupported = cyruntime.cudaGraphExecUpdateResult.cudaGraphExecUpdateErrorNotSupported

    #: The update failed because the function of a kernel node changed in
    #: an unsupported way
    cudaGraphExecUpdateErrorUnsupportedFunctionChange = cyruntime.cudaGraphExecUpdateResult.cudaGraphExecUpdateErrorUnsupportedFunctionChange

    #: The update failed because the node attributes changed in a way that
    #: is not supported
    cudaGraphExecUpdateErrorAttributesChanged = cyruntime.cudaGraphExecUpdateResult.cudaGraphExecUpdateErrorAttributesChanged

_dict_cudaGraphExecUpdateResult = dict(((int(v), v) for k, v in cudaGraphExecUpdateResult.__members__.items()))

class cudaGraphKernelNodeField(IntEnum):
    """
    Specifies the field to update when performing multiple node updates
    from the device
    """

    #: Invalid field
    cudaGraphKernelNodeFieldInvalid = cyruntime.cudaGraphKernelNodeField.cudaGraphKernelNodeFieldInvalid

    #: Grid dimension update
    cudaGraphKernelNodeFieldGridDim = cyruntime.cudaGraphKernelNodeField.cudaGraphKernelNodeFieldGridDim

    #: Kernel parameter update
    cudaGraphKernelNodeFieldParam = cyruntime.cudaGraphKernelNodeField.cudaGraphKernelNodeFieldParam

    #: Node enable/disable
    cudaGraphKernelNodeFieldEnabled = cyruntime.cudaGraphKernelNodeField.cudaGraphKernelNodeFieldEnabled

_dict_cudaGraphKernelNodeField = dict(((int(v), v) for k, v in cudaGraphKernelNodeField.__members__.items()))

class cudaGetDriverEntryPointFlags(IntEnum):
    """
    Flags to specify search options to be used with
    :py:obj:`~.cudaGetDriverEntryPoint` For more details see
    :py:obj:`~.cuGetProcAddress`
    """

    #: Default search mode for driver symbols.
    cudaEnableDefault = cyruntime.cudaGetDriverEntryPointFlags.cudaEnableDefault

    #: Search for legacy versions of driver symbols.
    cudaEnableLegacyStream = cyruntime.cudaGetDriverEntryPointFlags.cudaEnableLegacyStream

    #: Search for per-thread versions of driver symbols.
    cudaEnablePerThreadDefaultStream = cyruntime.cudaGetDriverEntryPointFlags.cudaEnablePerThreadDefaultStream

_dict_cudaGetDriverEntryPointFlags = dict(((int(v), v) for k, v in cudaGetDriverEntryPointFlags.__members__.items()))

class cudaDriverEntryPointQueryResult(IntEnum):
    """
    Enum for status from obtaining driver entry points, used with
    :py:obj:`~.cudaApiGetDriverEntryPoint`
    """

    #: Search for symbol found a match
    cudaDriverEntryPointSuccess = cyruntime.cudaDriverEntryPointQueryResult.cudaDriverEntryPointSuccess

    #: Search for symbol was not found
    cudaDriverEntryPointSymbolNotFound = cyruntime.cudaDriverEntryPointQueryResult.cudaDriverEntryPointSymbolNotFound

    #: Search for symbol was found but version wasn't great enough
    cudaDriverEntryPointVersionNotSufficent = cyruntime.cudaDriverEntryPointQueryResult.cudaDriverEntryPointVersionNotSufficent

_dict_cudaDriverEntryPointQueryResult = dict(((int(v), v) for k, v in cudaDriverEntryPointQueryResult.__members__.items()))

class cudaGraphDebugDotFlags(IntEnum):
    """
    CUDA Graph debug write options
    """

    #: Output all debug data as if every debug flag is enabled
    cudaGraphDebugDotFlagsVerbose = cyruntime.cudaGraphDebugDotFlags.cudaGraphDebugDotFlagsVerbose

    #: Adds :py:obj:`~.cudaKernelNodeParams` to output
    cudaGraphDebugDotFlagsKernelNodeParams = cyruntime.cudaGraphDebugDotFlags.cudaGraphDebugDotFlagsKernelNodeParams

    #: Adds :py:obj:`~.cudaMemcpy3DParms` to output
    cudaGraphDebugDotFlagsMemcpyNodeParams = cyruntime.cudaGraphDebugDotFlags.cudaGraphDebugDotFlagsMemcpyNodeParams

    #: Adds :py:obj:`~.cudaMemsetParams` to output
    cudaGraphDebugDotFlagsMemsetNodeParams = cyruntime.cudaGraphDebugDotFlags.cudaGraphDebugDotFlagsMemsetNodeParams

    #: Adds :py:obj:`~.cudaHostNodeParams` to output
    cudaGraphDebugDotFlagsHostNodeParams = cyruntime.cudaGraphDebugDotFlags.cudaGraphDebugDotFlagsHostNodeParams

    #: Adds cudaEvent_t handle from record and wait nodes to output
    cudaGraphDebugDotFlagsEventNodeParams = cyruntime.cudaGraphDebugDotFlags.cudaGraphDebugDotFlagsEventNodeParams

    #: Adds :py:obj:`~.cudaExternalSemaphoreSignalNodeParams` values to
    #: output
    cudaGraphDebugDotFlagsExtSemasSignalNodeParams = cyruntime.cudaGraphDebugDotFlags.cudaGraphDebugDotFlagsExtSemasSignalNodeParams

    #: Adds :py:obj:`~.cudaExternalSemaphoreWaitNodeParams` to output
    cudaGraphDebugDotFlagsExtSemasWaitNodeParams = cyruntime.cudaGraphDebugDotFlags.cudaGraphDebugDotFlagsExtSemasWaitNodeParams

    #: Adds cudaKernelNodeAttrID values to output
    cudaGraphDebugDotFlagsKernelNodeAttributes = cyruntime.cudaGraphDebugDotFlags.cudaGraphDebugDotFlagsKernelNodeAttributes

    #: Adds node handles and every kernel function handle to output
    cudaGraphDebugDotFlagsHandles = cyruntime.cudaGraphDebugDotFlags.cudaGraphDebugDotFlagsHandles

    #: Adds :py:obj:`~.cudaConditionalNodeParams` to output
    cudaGraphDebugDotFlagsConditionalNodeParams = cyruntime.cudaGraphDebugDotFlags.cudaGraphDebugDotFlagsConditionalNodeParams

_dict_cudaGraphDebugDotFlags = dict(((int(v), v) for k, v in cudaGraphDebugDotFlags.__members__.items()))

class cudaGraphInstantiateFlags(IntEnum):
    """
    Flags for instantiating a graph
    """

    #: Automatically free memory allocated in a graph before relaunching.
    cudaGraphInstantiateFlagAutoFreeOnLaunch = cyruntime.cudaGraphInstantiateFlags.cudaGraphInstantiateFlagAutoFreeOnLaunch

    #: Automatically upload the graph after instantiation. Only supported
    #: by
    #:  :py:obj:`~.cudaGraphInstantiateWithParams`. The upload will be
    #: performed using the
    #:  stream provided in `instantiateParams`.
    cudaGraphInstantiateFlagUpload = cyruntime.cudaGraphInstantiateFlags.cudaGraphInstantiateFlagUpload

    #: Instantiate the graph to be launchable from the device. This flag
    #: can only
    #:  be used on platforms which support unified addressing. This flag
    #: cannot be
    #:  used in conjunction with cudaGraphInstantiateFlagAutoFreeOnLaunch.
    cudaGraphInstantiateFlagDeviceLaunch = cyruntime.cudaGraphInstantiateFlags.cudaGraphInstantiateFlagDeviceLaunch

    #: Run the graph using the per-node priority attributes rather than the
    #: priority of the stream it is launched into.
    cudaGraphInstantiateFlagUseNodePriority = cyruntime.cudaGraphInstantiateFlags.cudaGraphInstantiateFlagUseNodePriority

_dict_cudaGraphInstantiateFlags = dict(((int(v), v) for k, v in cudaGraphInstantiateFlags.__members__.items()))

class cudaDeviceNumaConfig(IntEnum):
    """
    CUDA device NUMA config
    """

    #: The GPU is not a NUMA node
    cudaDeviceNumaConfigNone = cyruntime.cudaDeviceNumaConfig.cudaDeviceNumaConfigNone

    #: The GPU is a NUMA node, cudaDevAttrNumaId contains its NUMA ID
    cudaDeviceNumaConfigNumaNode = cyruntime.cudaDeviceNumaConfig.cudaDeviceNumaConfigNumaNode

_dict_cudaDeviceNumaConfig = dict(((int(v), v) for k, v in cudaDeviceNumaConfig.__members__.items()))

class cudaSurfaceBoundaryMode(IntEnum):
    """
    CUDA Surface boundary modes
    """

    #: Zero boundary mode
    cudaBoundaryModeZero = cyruntime.cudaSurfaceBoundaryMode.cudaBoundaryModeZero

    #: Clamp boundary mode
    cudaBoundaryModeClamp = cyruntime.cudaSurfaceBoundaryMode.cudaBoundaryModeClamp

    #: Trap boundary mode
    cudaBoundaryModeTrap = cyruntime.cudaSurfaceBoundaryMode.cudaBoundaryModeTrap

_dict_cudaSurfaceBoundaryMode = dict(((int(v), v) for k, v in cudaSurfaceBoundaryMode.__members__.items()))

class cudaSurfaceFormatMode(IntEnum):
    """
    CUDA Surface format modes
    """

    #: Forced format mode
    cudaFormatModeForced = cyruntime.cudaSurfaceFormatMode.cudaFormatModeForced

    #: Auto format mode
    cudaFormatModeAuto = cyruntime.cudaSurfaceFormatMode.cudaFormatModeAuto

_dict_cudaSurfaceFormatMode = dict(((int(v), v) for k, v in cudaSurfaceFormatMode.__members__.items()))

class cudaTextureAddressMode(IntEnum):
    """
    CUDA texture address modes
    """

    #: Wrapping address mode
    cudaAddressModeWrap = cyruntime.cudaTextureAddressMode.cudaAddressModeWrap

    #: Clamp to edge address mode
    cudaAddressModeClamp = cyruntime.cudaTextureAddressMode.cudaAddressModeClamp

    #: Mirror address mode
    cudaAddressModeMirror = cyruntime.cudaTextureAddressMode.cudaAddressModeMirror

    #: Border address mode
    cudaAddressModeBorder = cyruntime.cudaTextureAddressMode.cudaAddressModeBorder

_dict_cudaTextureAddressMode = dict(((int(v), v) for k, v in cudaTextureAddressMode.__members__.items()))

class cudaTextureFilterMode(IntEnum):
    """
    CUDA texture filter modes
    """

    #: Point filter mode
    cudaFilterModePoint = cyruntime.cudaTextureFilterMode.cudaFilterModePoint

    #: Linear filter mode
    cudaFilterModeLinear = cyruntime.cudaTextureFilterMode.cudaFilterModeLinear

_dict_cudaTextureFilterMode = dict(((int(v), v) for k, v in cudaTextureFilterMode.__members__.items()))

class cudaTextureReadMode(IntEnum):
    """
    CUDA texture read modes
    """

    #: Read texture as specified element type
    cudaReadModeElementType = cyruntime.cudaTextureReadMode.cudaReadModeElementType

    #: Read texture as normalized float
    cudaReadModeNormalizedFloat = cyruntime.cudaTextureReadMode.cudaReadModeNormalizedFloat

_dict_cudaTextureReadMode = dict(((int(v), v) for k, v in cudaTextureReadMode.__members__.items()))

class cudaRoundMode(IntEnum):
    """"""
    cudaRoundNearest = cyruntime.cudaRoundMode.cudaRoundNearest
    cudaRoundZero = cyruntime.cudaRoundMode.cudaRoundZero
    cudaRoundPosInf = cyruntime.cudaRoundMode.cudaRoundPosInf
    cudaRoundMinInf = cyruntime.cudaRoundMode.cudaRoundMinInf

_dict_cudaRoundMode = dict(((int(v), v) for k, v in cudaRoundMode.__members__.items()))

class cudaGLDeviceList(IntEnum):
    """
    CUDA devices corresponding to the current OpenGL context
    """

    #: The CUDA devices for all GPUs used by the current OpenGL context
    cudaGLDeviceListAll = cyruntime.cudaGLDeviceList.cudaGLDeviceListAll

    #: The CUDA devices for the GPUs used by the current OpenGL context in
    #: its currently rendering frame
    cudaGLDeviceListCurrentFrame = cyruntime.cudaGLDeviceList.cudaGLDeviceListCurrentFrame

    #: The CUDA devices for the GPUs to be used by the current OpenGL
    #: context in the next frame
    cudaGLDeviceListNextFrame = cyruntime.cudaGLDeviceList.cudaGLDeviceListNextFrame

_dict_cudaGLDeviceList = dict(((int(v), v) for k, v in cudaGLDeviceList.__members__.items()))

class cudaGLMapFlags(IntEnum):
    """
    CUDA GL Map Flags
    """

    #: Default; Assume resource can be read/written
    cudaGLMapFlagsNone = cyruntime.cudaGLMapFlags.cudaGLMapFlagsNone

    #: CUDA kernels will not write to this resource
    cudaGLMapFlagsReadOnly = cyruntime.cudaGLMapFlags.cudaGLMapFlagsReadOnly

    #: CUDA kernels will only write to and will not read from this resource
    cudaGLMapFlagsWriteDiscard = cyruntime.cudaGLMapFlags.cudaGLMapFlagsWriteDiscard

_dict_cudaGLMapFlags = dict(((int(v), v) for k, v in cudaGLMapFlags.__members__.items()))

class cudaStreamAttrID(IntEnum):
    """
    Launch attributes enum; used as id field of
    :py:obj:`~.cudaLaunchAttribute`
    """

    #: Ignored entry, for convenient composition
    cudaLaunchAttributeIgnore = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeIgnore

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.accessPolicyWindow`.
    cudaLaunchAttributeAccessPolicyWindow = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeAccessPolicyWindow

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.cooperative`.
    cudaLaunchAttributeCooperative = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeCooperative

    #: Valid for streams. See
    #: :py:obj:`~.cudaLaunchAttributeValue.syncPolicy`.
    cudaLaunchAttributeSynchronizationPolicy = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeSynchronizationPolicy

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.clusterDim`.
    cudaLaunchAttributeClusterDimension = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeClusterDimension

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.clusterSchedulingPolicyPreference`.
    cudaLaunchAttributeClusterSchedulingPolicyPreference = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeClusterSchedulingPolicyPreference

    #: Valid for launches. Setting
    #: :py:obj:`~.cudaLaunchAttributeValue.programmaticStreamSerializationAllowed`
    #: to non-0 signals that the kernel will use programmatic means to
    #: resolve its stream dependency, so that the CUDA runtime should
    #: opportunistically allow the grid's execution to overlap with the
    #: previous kernel in the stream, if that kernel requests the overlap.
    #: The dependent launches can choose to wait on the dependency using
    #: the programmatic sync (cudaGridDependencySynchronize() or equivalent
    #: PTX instructions).
    cudaLaunchAttributeProgrammaticStreamSerialization = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeProgrammaticStreamSerialization

    #: Valid for launches. Set
    #: :py:obj:`~.cudaLaunchAttributeValue.programmaticEvent` to record the
    #: event. Event recorded through this launch attribute is guaranteed to
    #: only trigger after all block in the associated kernel trigger the
    #: event. A block can trigger the event programmatically in a future
    #: CUDA release. A trigger can also be inserted at the beginning of
    #: each block's execution if triggerAtBlockStart is set to non-0. The
    #: dependent launches can choose to wait on the dependency using the
    #: programmatic sync (cudaGridDependencySynchronize() or equivalent PTX
    #: instructions). Note that dependents (including the CPU thread
    #: calling :py:obj:`~.cudaEventSynchronize()`) are not guaranteed to
    #: observe the release precisely when it is released. For example,
    #: :py:obj:`~.cudaEventSynchronize()` may only observe the event
    #: trigger long after the associated kernel has completed. This
    #: recording type is primarily meant for establishing programmatic
    #: dependency between device tasks. Note also this type of dependency
    #: allows, but does not guarantee, concurrent execution of tasks.
    #:  The event supplied must not be an interprocess or interop event.
    #: The event must disable timing (i.e. must be created with the
    #: :py:obj:`~.cudaEventDisableTiming` flag set).
    cudaLaunchAttributeProgrammaticEvent = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeProgrammaticEvent

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.priority`.
    cudaLaunchAttributePriority = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributePriority

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.memSyncDomainMap`.
    cudaLaunchAttributeMemSyncDomainMap = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeMemSyncDomainMap

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.memSyncDomain`.
    cudaLaunchAttributeMemSyncDomain = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeMemSyncDomain

    #: Valid for graph nodes and launches. Set
    #: :py:obj:`~.cudaLaunchAttributeValue.preferredClusterDim` to allow
    #: the kernel launch to specify a preferred substitute cluster
    #: dimension. Blocks may be grouped according to either the dimensions
    #: specified with this attribute (grouped into a "preferred substitute
    #: cluster"), or the one specified with
    #: :py:obj:`~.cudaLaunchAttributeClusterDimension` attribute (grouped
    #: into a "regular cluster"). The cluster dimensions of a "preferred
    #: substitute cluster" shall be an integer multiple greater than zero
    #: of the regular cluster dimensions. The device will attempt - on a
    #: best-effort basis - to group thread blocks into preferred clusters
    #: over grouping them into regular clusters. When it deems necessary
    #: (primarily when the device temporarily runs out of physical
    #: resources to launch the larger preferred clusters), the device may
    #: switch to launch the regular clusters instead to attempt to utilize
    #: as much of the physical device resources as possible.
    #:  Each type of cluster will have its enumeration / coordinate setup
    #: as if the grid consists solely of its type of cluster. For example,
    #: if the preferred substitute cluster dimensions double the regular
    #: cluster dimensions, there might be simultaneously a regular cluster
    #: indexed at (1,0,0), and a preferred cluster indexed at (1,0,0). In
    #: this example, the preferred substitute cluster (1,0,0) replaces
    #: regular clusters (2,0,0) and (3,0,0) and groups their blocks.
    #:  This attribute will only take effect when a regular cluster
    #: dimension has been specified. The preferred substitute cluster
    #: dimension must be an integer multiple greater than zero of the
    #: regular cluster dimension and must divide the grid. It must also be
    #: no more than `maxBlocksPerCluster`, if it is set in the kernel's
    #: `__launch_bounds__`. Otherwise it must be less than the maximum
    #: value the driver can support. Otherwise, setting this attribute to a
    #: value physically unable to fit on any particular device is
    #: permitted.
    cudaLaunchAttributePreferredClusterDimension = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributePreferredClusterDimension

    #: Valid for launches. Set
    #: :py:obj:`~.cudaLaunchAttributeValue.launchCompletionEvent` to record
    #: the event.
    #:  Nominally, the event is triggered once all blocks of the kernel
    #: have begun execution. Currently this is a best effort. If a kernel B
    #: has a launch completion dependency on a kernel A, B may wait until A
    #: is complete. Alternatively, blocks of B may begin before all blocks
    #: of A have begun, for example if B can claim execution resources
    #: unavailable to A (e.g. they run on different GPUs) or if B is a
    #: higher priority than A. Exercise caution if such an ordering
    #: inversion could lead to deadlock.
    #:  A launch completion event is nominally similar to a programmatic
    #: event with `triggerAtBlockStart` set except that it is not visible
    #: to `cudaGridDependencySynchronize()` and can be used with compute
    #: capability less than 9.0.
    #:  The event supplied must not be an interprocess or interop event.
    #: The event must disable timing (i.e. must be created with the
    #: :py:obj:`~.cudaEventDisableTiming` flag set).
    cudaLaunchAttributeLaunchCompletionEvent = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeLaunchCompletionEvent

    #: Valid for graph nodes, launches. This attribute is graphs-only, and
    #: passing it to a launch in a non-capturing stream will result in an
    #: error.
    #: :cudaLaunchAttributeValue::deviceUpdatableKernelNode::deviceUpdatable
    #: can only be set to 0 or 1. Setting the field to 1 indicates that the
    #: corresponding kernel node should be device-updatable. On success, a
    #: handle will be returned via
    #: :py:obj:`~.cudaLaunchAttributeValue`::deviceUpdatableKernelNode::devNode
    #: which can be passed to the various device-side update functions to
    #: update the node's kernel parameters from within another kernel. For
    #: more information on the types of device updates that can be made, as
    #: well as the relevant limitations thereof, see
    #: :py:obj:`~.cudaGraphKernelNodeUpdatesApply`.
    #:  Nodes which are device-updatable have additional restrictions
    #: compared to regular kernel nodes. Firstly, device-updatable nodes
    #: cannot be removed from their graph via
    #: :py:obj:`~.cudaGraphDestroyNode`. Additionally, once opted-in to
    #: this functionality, a node cannot opt out, and any attempt to set
    #: the deviceUpdatable attribute to 0 will result in an error. Device-
    #: updatable kernel nodes also cannot have their attributes copied
    #: to/from another kernel node via
    #: :py:obj:`~.cudaGraphKernelNodeCopyAttributes`. Graphs containing one
    #: or more device-updatable nodes also do not allow multiple
    #: instantiation, and neither the graph nor its instantiated version
    #: can be passed to :py:obj:`~.cudaGraphExecUpdate`.
    #:  If a graph contains device-updatable nodes and updates those nodes
    #: from the device from within the graph, the graph must be uploaded
    #: with :py:obj:`~.cuGraphUpload` before it is launched. For such a
    #: graph, if host-side executable graph updates are made to the device-
    #: updatable nodes, the graph must be uploaded before it is launched
    #: again.
    cudaLaunchAttributeDeviceUpdatableKernelNode = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeDeviceUpdatableKernelNode

    #: Valid for launches. On devices where the L1 cache and shared memory
    #: use the same hardware resources, setting
    #: :py:obj:`~.cudaLaunchAttributeValue.sharedMemCarveout` to a
    #: percentage between 0-100 signals sets the shared memory carveout
    #: preference in percent of the total shared memory for that kernel
    #: launch. This attribute takes precedence over
    #: :py:obj:`~.cudaFuncAttributePreferredSharedMemoryCarveout`. This is
    #: only a hint, and the driver can choose a different configuration if
    #: required for the launch.
    cudaLaunchAttributePreferredSharedMemoryCarveout = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributePreferredSharedMemoryCarveout

    #: Valid for streams, graph nodes, launches. This attribute is a hint
    #: to the CUDA runtime that the launch should attempt to make the
    #: kernel maximize its NVLINK utilization.
    #:
    #:  When possible to honor this hint, CUDA will assume each block in
    #: the grid launch will carry out an even amount of NVLINK traffic, and
    #: make a best-effort attempt to adjust the kernel launch based on that
    #: assumption.
    #:  This attribute is a hint only. CUDA makes no functional or
    #: performance guarantee. Its applicability can be affected by many
    #: different factors, including driver version (i.e. CUDA doesn't
    #: guarantee the performance characteristics will be maintained between
    #: driver versions or a driver update could alter or regress previously
    #: observed perf characteristics.) It also doesn't guarantee a
    #: successful result, i.e. applying the attribute may not improve the
    #: performance of either the targeted kernel or the encapsulating
    #: application.
    #:  Valid values for
    #: :py:obj:`~.cudaLaunchAttributeValue.nvlinkUtilCentricScheduling` are
    #: 0 (disabled) and 1 (enabled).
    cudaLaunchAttributeNvlinkUtilCentricScheduling = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeNvlinkUtilCentricScheduling

_dict_cudaLaunchAttributeID = dict(((int(v), v) for k, v in cudaLaunchAttributeID.__members__.items()))

class cudaKernelNodeAttrID(IntEnum):
    """
    Launch attributes enum; used as id field of
    :py:obj:`~.cudaLaunchAttribute`
    """

    #: Ignored entry, for convenient composition
    cudaLaunchAttributeIgnore = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeIgnore

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.accessPolicyWindow`.
    cudaLaunchAttributeAccessPolicyWindow = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeAccessPolicyWindow

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.cooperative`.
    cudaLaunchAttributeCooperative = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeCooperative

    #: Valid for streams. See
    #: :py:obj:`~.cudaLaunchAttributeValue.syncPolicy`.
    cudaLaunchAttributeSynchronizationPolicy = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeSynchronizationPolicy

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.clusterDim`.
    cudaLaunchAttributeClusterDimension = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeClusterDimension

    #: Valid for graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.clusterSchedulingPolicyPreference`.
    cudaLaunchAttributeClusterSchedulingPolicyPreference = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeClusterSchedulingPolicyPreference

    #: Valid for launches. Setting
    #: :py:obj:`~.cudaLaunchAttributeValue.programmaticStreamSerializationAllowed`
    #: to non-0 signals that the kernel will use programmatic means to
    #: resolve its stream dependency, so that the CUDA runtime should
    #: opportunistically allow the grid's execution to overlap with the
    #: previous kernel in the stream, if that kernel requests the overlap.
    #: The dependent launches can choose to wait on the dependency using
    #: the programmatic sync (cudaGridDependencySynchronize() or equivalent
    #: PTX instructions).
    cudaLaunchAttributeProgrammaticStreamSerialization = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeProgrammaticStreamSerialization

    #: Valid for launches. Set
    #: :py:obj:`~.cudaLaunchAttributeValue.programmaticEvent` to record the
    #: event. Event recorded through this launch attribute is guaranteed to
    #: only trigger after all block in the associated kernel trigger the
    #: event. A block can trigger the event programmatically in a future
    #: CUDA release. A trigger can also be inserted at the beginning of
    #: each block's execution if triggerAtBlockStart is set to non-0. The
    #: dependent launches can choose to wait on the dependency using the
    #: programmatic sync (cudaGridDependencySynchronize() or equivalent PTX
    #: instructions). Note that dependents (including the CPU thread
    #: calling :py:obj:`~.cudaEventSynchronize()`) are not guaranteed to
    #: observe the release precisely when it is released. For example,
    #: :py:obj:`~.cudaEventSynchronize()` may only observe the event
    #: trigger long after the associated kernel has completed. This
    #: recording type is primarily meant for establishing programmatic
    #: dependency between device tasks. Note also this type of dependency
    #: allows, but does not guarantee, concurrent execution of tasks.
    #:  The event supplied must not be an interprocess or interop event.
    #: The event must disable timing (i.e. must be created with the
    #: :py:obj:`~.cudaEventDisableTiming` flag set).
    cudaLaunchAttributeProgrammaticEvent = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeProgrammaticEvent

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.priority`.
    cudaLaunchAttributePriority = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributePriority

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.memSyncDomainMap`.
    cudaLaunchAttributeMemSyncDomainMap = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeMemSyncDomainMap

    #: Valid for streams, graph nodes, launches. See
    #: :py:obj:`~.cudaLaunchAttributeValue.memSyncDomain`.
    cudaLaunchAttributeMemSyncDomain = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeMemSyncDomain

    #: Valid for graph nodes and launches. Set
    #: :py:obj:`~.cudaLaunchAttributeValue.preferredClusterDim` to allow
    #: the kernel launch to specify a preferred substitute cluster
    #: dimension. Blocks may be grouped according to either the dimensions
    #: specified with this attribute (grouped into a "preferred substitute
    #: cluster"), or the one specified with
    #: :py:obj:`~.cudaLaunchAttributeClusterDimension` attribute (grouped
    #: into a "regular cluster"). The cluster dimensions of a "preferred
    #: substitute cluster" shall be an integer multiple greater than zero
    #: of the regular cluster dimensions. The device will attempt - on a
    #: best-effort basis - to group thread blocks into preferred clusters
    #: over grouping them into regular clusters. When it deems necessary
    #: (primarily when the device temporarily runs out of physical
    #: resources to launch the larger preferred clusters), the device may
    #: switch to launch the regular clusters instead to attempt to utilize
    #: as much of the physical device resources as possible.
    #:  Each type of cluster will have its enumeration / coordinate setup
    #: as if the grid consists solely of its type of cluster. For example,
    #: if the preferred substitute cluster dimensions double the regular
    #: cluster dimensions, there might be simultaneously a regular cluster
    #: indexed at (1,0,0), and a preferred cluster indexed at (1,0,0). In
    #: this example, the preferred substitute cluster (1,0,0) replaces
    #: regular clusters (2,0,0) and (3,0,0) and groups their blocks.
    #:  This attribute will only take effect when a regular cluster
    #: dimension has been specified. The preferred substitute cluster
    #: dimension must be an integer multiple greater than zero of the
    #: regular cluster dimension and must divide the grid. It must also be
    #: no more than `maxBlocksPerCluster`, if it is set in the kernel's
    #: `__launch_bounds__`. Otherwise it must be less than the maximum
    #: value the driver can support. Otherwise, setting this attribute to a
    #: value physically unable to fit on any particular device is
    #: permitted.
    cudaLaunchAttributePreferredClusterDimension = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributePreferredClusterDimension

    #: Valid for launches. Set
    #: :py:obj:`~.cudaLaunchAttributeValue.launchCompletionEvent` to record
    #: the event.
    #:  Nominally, the event is triggered once all blocks of the kernel
    #: have begun execution. Currently this is a best effort. If a kernel B
    #: has a launch completion dependency on a kernel A, B may wait until A
    #: is complete. Alternatively, blocks of B may begin before all blocks
    #: of A have begun, for example if B can claim execution resources
    #: unavailable to A (e.g. they run on different GPUs) or if B is a
    #: higher priority than A. Exercise caution if such an ordering
    #: inversion could lead to deadlock.
    #:  A launch completion event is nominally similar to a programmatic
    #: event with `triggerAtBlockStart` set except that it is not visible
    #: to `cudaGridDependencySynchronize()` and can be used with compute
    #: capability less than 9.0.
    #:  The event supplied must not be an interprocess or interop event.
    #: The event must disable timing (i.e. must be created with the
    #: :py:obj:`~.cudaEventDisableTiming` flag set).
    cudaLaunchAttributeLaunchCompletionEvent = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeLaunchCompletionEvent

    #: Valid for graph nodes, launches. This attribute is graphs-only, and
    #: passing it to a launch in a non-capturing stream will result in an
    #: error.
    #: :cudaLaunchAttributeValue::deviceUpdatableKernelNode::deviceUpdatable
    #: can only be set to 0 or 1. Setting the field to 1 indicates that the
    #: corresponding kernel node should be device-updatable. On success, a
    #: handle will be returned via
    #: :py:obj:`~.cudaLaunchAttributeValue`::deviceUpdatableKernelNode::devNode
    #: which can be passed to the various device-side update functions to
    #: update the node's kernel parameters from within another kernel. For
    #: more information on the types of device updates that can be made, as
    #: well as the relevant limitations thereof, see
    #: :py:obj:`~.cudaGraphKernelNodeUpdatesApply`.
    #:  Nodes which are device-updatable have additional restrictions
    #: compared to regular kernel nodes. Firstly, device-updatable nodes
    #: cannot be removed from their graph via
    #: :py:obj:`~.cudaGraphDestroyNode`. Additionally, once opted-in to
    #: this functionality, a node cannot opt out, and any attempt to set
    #: the deviceUpdatable attribute to 0 will result in an error. Device-
    #: updatable kernel nodes also cannot have their attributes copied
    #: to/from another kernel node via
    #: :py:obj:`~.cudaGraphKernelNodeCopyAttributes`. Graphs containing one
    #: or more device-updatable nodes also do not allow multiple
    #: instantiation, and neither the graph nor its instantiated version
    #: can be passed to :py:obj:`~.cudaGraphExecUpdate`.
    #:  If a graph contains device-updatable nodes and updates those nodes
    #: from the device from within the graph, the graph must be uploaded
    #: with :py:obj:`~.cuGraphUpload` before it is launched. For such a
    #: graph, if host-side executable graph updates are made to the device-
    #: updatable nodes, the graph must be uploaded before it is launched
    #: again.
    cudaLaunchAttributeDeviceUpdatableKernelNode = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeDeviceUpdatableKernelNode

    #: Valid for launches. On devices where the L1 cache and shared memory
    #: use the same hardware resources, setting
    #: :py:obj:`~.cudaLaunchAttributeValue.sharedMemCarveout` to a
    #: percentage between 0-100 signals sets the shared memory carveout
    #: preference in percent of the total shared memory for that kernel
    #: launch. This attribute takes precedence over
    #: :py:obj:`~.cudaFuncAttributePreferredSharedMemoryCarveout`. This is
    #: only a hint, and the driver can choose a different configuration if
    #: required for the launch.
    cudaLaunchAttributePreferredSharedMemoryCarveout = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributePreferredSharedMemoryCarveout

    #: Valid for streams, graph nodes, launches. This attribute is a hint
    #: to the CUDA runtime that the launch should attempt to make the
    #: kernel maximize its NVLINK utilization.
    #:
    #:  When possible to honor this hint, CUDA will assume each block in
    #: the grid launch will carry out an even amount of NVLINK traffic, and
    #: make a best-effort attempt to adjust the kernel launch based on that
    #: assumption.
    #:  This attribute is a hint only. CUDA makes no functional or
    #: performance guarantee. Its applicability can be affected by many
    #: different factors, including driver version (i.e. CUDA doesn't
    #: guarantee the performance characteristics will be maintained between
    #: driver versions or a driver update could alter or regress previously
    #: observed perf characteristics.) It also doesn't guarantee a
    #: successful result, i.e. applying the attribute may not improve the
    #: performance of either the targeted kernel or the encapsulating
    #: application.
    #:  Valid values for
    #: :py:obj:`~.cudaLaunchAttributeValue.nvlinkUtilCentricScheduling` are
    #: 0 (disabled) and 1 (enabled).
    cudaLaunchAttributeNvlinkUtilCentricScheduling = cyruntime.cudaLaunchAttributeID.cudaLaunchAttributeNvlinkUtilCentricScheduling

_dict_cudaLaunchAttributeID = dict(((int(v), v) for k, v in cudaLaunchAttributeID.__members__.items()))

cdef class cudaDevResourceDesc_t:
    """

    An opaque descriptor handle. The descriptor encapsulates multiple created and configured resources. Created via ::cudaDeviceResourceGenerateDesc

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaDevResourceDesc_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaDevResourceDesc_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaDevResourceDesc_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaDevResourceDesc_t):
            return False
        return self._pvt_ptr[0] == (<cudaDevResourceDesc_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaExecutionContext_t:
    """

    An opaque handle to a CUDA execution context. It represents an execution context created via CUDA Runtime APIs such as cudaGreenCtxCreate.

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaExecutionContext_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaExecutionContext_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaExecutionContext_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaExecutionContext_t):
            return False
        return self._pvt_ptr[0] == (<cudaExecutionContext_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaArray_t:
    """

    CUDA array

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaArray_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaArray_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaArray_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaArray_t):
            return False
        return self._pvt_ptr[0] == (<cudaArray_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaArray_const_t:
    """

    CUDA array (as source copy argument)

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaArray_const_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaArray_const_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaArray_const_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaArray_const_t):
            return False
        return self._pvt_ptr[0] == (<cudaArray_const_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaMipmappedArray_t:
    """

    CUDA mipmapped array

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaMipmappedArray_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaMipmappedArray_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaMipmappedArray_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaMipmappedArray_t):
            return False
        return self._pvt_ptr[0] == (<cudaMipmappedArray_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaMipmappedArray_const_t:
    """

    CUDA mipmapped array (as source argument)

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaMipmappedArray_const_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaMipmappedArray_const_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaMipmappedArray_const_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaMipmappedArray_const_t):
            return False
        return self._pvt_ptr[0] == (<cudaMipmappedArray_const_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaGraphicsResource_t:
    """

    CUDA graphics resource types

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaGraphicsResource_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaGraphicsResource_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaGraphicsResource_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaGraphicsResource_t):
            return False
        return self._pvt_ptr[0] == (<cudaGraphicsResource_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaExternalMemory_t:
    """

    CUDA external memory

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaExternalMemory_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaExternalMemory_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaExternalMemory_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaExternalMemory_t):
            return False
        return self._pvt_ptr[0] == (<cudaExternalMemory_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaExternalSemaphore_t:
    """

    CUDA external semaphore

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaExternalSemaphore_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaExternalSemaphore_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaExternalSemaphore_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaExternalSemaphore_t):
            return False
        return self._pvt_ptr[0] == (<cudaExternalSemaphore_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaKernel_t:
    """

    CUDA kernel

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaKernel_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaKernel_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaKernel_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaKernel_t):
            return False
        return self._pvt_ptr[0] == (<cudaKernel_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaLibrary_t:
    """

    CUDA library

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaLibrary_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaLibrary_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaLibrary_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaLibrary_t):
            return False
        return self._pvt_ptr[0] == (<cudaLibrary_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaGraphDeviceNode_t:
    """

    CUDA device node handle for device-side node update

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaGraphDeviceNode_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaGraphDeviceNode_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaGraphDeviceNode_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaGraphDeviceNode_t):
            return False
        return self._pvt_ptr[0] == (<cudaGraphDeviceNode_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaAsyncCallbackHandle_t:
    """

    CUDA async callback handle

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaAsyncCallbackHandle_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaAsyncCallbackHandle_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaAsyncCallbackHandle_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaAsyncCallbackHandle_t):
            return False
        return self._pvt_ptr[0] == (<cudaAsyncCallbackHandle_t>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaLogsCallbackHandle:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaLogsCallbackHandle>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaLogsCallbackHandle *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaLogsCallbackHandle ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, cudaLogsCallbackHandle):
            return False
        return self._pvt_ptr[0] == (<cudaLogsCallbackHandle>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class EGLImageKHR:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.EGLImageKHR>init_value
        else:
            self._pvt_ptr = <cyruntime.EGLImageKHR *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<EGLImageKHR ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, EGLImageKHR):
            return False
        return self._pvt_ptr[0] == (<EGLImageKHR>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class EGLStreamKHR:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.EGLStreamKHR>init_value
        else:
            self._pvt_ptr = <cyruntime.EGLStreamKHR *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<EGLStreamKHR ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, EGLStreamKHR):
            return False
        return self._pvt_ptr[0] == (<EGLStreamKHR>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class EGLSyncKHR:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.EGLSyncKHR>init_value
        else:
            self._pvt_ptr = <cyruntime.EGLSyncKHR *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<EGLSyncKHR ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __eq__(self, other):
        if not isinstance(other, EGLSyncKHR):
            return False
        return self._pvt_ptr[0] == (<EGLSyncKHR>other)._pvt_ptr[0]
    def __hash__(self):
        return hash(<uintptr_t><void*>(self._pvt_ptr[0]))
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaHostFn_t:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaHostFn_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaHostFn_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaHostFn_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaAsyncCallback:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaAsyncCallback>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaAsyncCallback *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaAsyncCallback ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaStreamCallback_t:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaStreamCallback_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaStreamCallback_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaStreamCallback_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaLogsCallback_t:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
            self._pvt_ptr[0] = <cyruntime.cudaLogsCallback_t>init_value
        else:
            self._pvt_ptr = <cyruntime.cudaLogsCallback_t *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __repr__(self):
        return '<cudaLogsCallback_t ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class dim3:
    """
    Attributes
    ----------
    x : unsigned int

    y : unsigned int

    z : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.dim3 *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['x : ' + str(self.x)]
            except ValueError:
                str_list += ['x : <ValueError>']
            try:
                str_list += ['y : ' + str(self.y)]
            except ValueError:
                str_list += ['y : <ValueError>']
            try:
                str_list += ['z : ' + str(self.z)]
            except ValueError:
                str_list += ['z : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def x(self):
        return self._pvt_ptr[0].x
    @x.setter
    def x(self, unsigned int x):
        self._pvt_ptr[0].x = x
    @property
    def y(self):
        return self._pvt_ptr[0].y
    @y.setter
    def y(self, unsigned int y):
        self._pvt_ptr[0].y = y
    @property
    def z(self):
        return self._pvt_ptr[0].z
    @z.setter
    def z(self, unsigned int z):
        self._pvt_ptr[0].z = z

cdef class cudaChannelFormatDesc:
    """
    CUDA Channel format descriptor

    Attributes
    ----------
    x : int
        x
    y : int
        y
    z : int
        z
    w : int
        w
    f : cudaChannelFormatKind
        Channel format kind

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaChannelFormatDesc *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['x : ' + str(self.x)]
            except ValueError:
                str_list += ['x : <ValueError>']
            try:
                str_list += ['y : ' + str(self.y)]
            except ValueError:
                str_list += ['y : <ValueError>']
            try:
                str_list += ['z : ' + str(self.z)]
            except ValueError:
                str_list += ['z : <ValueError>']
            try:
                str_list += ['w : ' + str(self.w)]
            except ValueError:
                str_list += ['w : <ValueError>']
            try:
                str_list += ['f : ' + str(self.f)]
            except ValueError:
                str_list += ['f : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def x(self):
        return self._pvt_ptr[0].x
    @x.setter
    def x(self, int x):
        self._pvt_ptr[0].x = x
    @property
    def y(self):
        return self._pvt_ptr[0].y
    @y.setter
    def y(self, int y):
        self._pvt_ptr[0].y = y
    @property
    def z(self):
        return self._pvt_ptr[0].z
    @z.setter
    def z(self, int z):
        self._pvt_ptr[0].z = z
    @property
    def w(self):
        return self._pvt_ptr[0].w
    @w.setter
    def w(self, int w):
        self._pvt_ptr[0].w = w
    @property
    def f(self):
        if self._pvt_ptr[0].f not in _dict_cudaChannelFormatKind:
            return None
        return _dict_cudaChannelFormatKind[self._pvt_ptr[0].f]
    @f.setter
    def f(self, f not None : cudaChannelFormatKind):
        self._pvt_ptr[0].f = f.value

cdef class anon_struct0:
    """
    Attributes
    ----------
    width : unsigned int

    height : unsigned int

    depth : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaArraySparseProperties *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].tileExtent
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            try:
                str_list += ['depth : ' + str(self.depth)]
            except ValueError:
                str_list += ['depth : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def width(self):
        return self._pvt_ptr[0].tileExtent.width
    @width.setter
    def width(self, unsigned int width):
        self._pvt_ptr[0].tileExtent.width = width
    @property
    def height(self):
        return self._pvt_ptr[0].tileExtent.height
    @height.setter
    def height(self, unsigned int height):
        self._pvt_ptr[0].tileExtent.height = height
    @property
    def depth(self):
        return self._pvt_ptr[0].tileExtent.depth
    @depth.setter
    def depth(self, unsigned int depth):
        self._pvt_ptr[0].tileExtent.depth = depth

cdef class cudaArraySparseProperties:
    """
    Sparse CUDA array and CUDA mipmapped array properties

    Attributes
    ----------
    tileExtent : anon_struct0

    miptailFirstLevel : unsigned int
        First mip level at which the mip tail begins
    miptailSize : unsigned long long
        Total size of the mip tail.
    flags : unsigned int
        Flags will either be zero or cudaArraySparsePropertiesSingleMipTail
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaArraySparseProperties *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._tileExtent = anon_struct0(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['tileExtent :\n' + '\n'.join(['    ' + line for line in str(self.tileExtent).splitlines()])]
            except ValueError:
                str_list += ['tileExtent : <ValueError>']
            try:
                str_list += ['miptailFirstLevel : ' + str(self.miptailFirstLevel)]
            except ValueError:
                str_list += ['miptailFirstLevel : <ValueError>']
            try:
                str_list += ['miptailSize : ' + str(self.miptailSize)]
            except ValueError:
                str_list += ['miptailSize : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def tileExtent(self):
        return self._tileExtent
    @tileExtent.setter
    def tileExtent(self, tileExtent not None : anon_struct0):
        string.memcpy(&self._pvt_ptr[0].tileExtent, <cyruntime.anon_struct0*><void_ptr>tileExtent.getPtr(), sizeof(self._pvt_ptr[0].tileExtent))
    @property
    def miptailFirstLevel(self):
        return self._pvt_ptr[0].miptailFirstLevel
    @miptailFirstLevel.setter
    def miptailFirstLevel(self, unsigned int miptailFirstLevel):
        self._pvt_ptr[0].miptailFirstLevel = miptailFirstLevel
    @property
    def miptailSize(self):
        return self._pvt_ptr[0].miptailSize
    @miptailSize.setter
    def miptailSize(self, unsigned long long miptailSize):
        self._pvt_ptr[0].miptailSize = miptailSize
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class cudaArrayMemoryRequirements:
    """
    CUDA array and CUDA mipmapped array memory requirements

    Attributes
    ----------
    size : size_t
        Total size of the array.
    alignment : size_t
        Alignment necessary for mapping the array.
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaArrayMemoryRequirements *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['size : ' + str(self.size)]
            except ValueError:
                str_list += ['size : <ValueError>']
            try:
                str_list += ['alignment : ' + str(self.alignment)]
            except ValueError:
                str_list += ['alignment : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def size(self):
        return self._pvt_ptr[0].size
    @size.setter
    def size(self, size_t size):
        self._pvt_ptr[0].size = size
    @property
    def alignment(self):
        return self._pvt_ptr[0].alignment
    @alignment.setter
    def alignment(self, size_t alignment):
        self._pvt_ptr[0].alignment = alignment
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class cudaPitchedPtr:
    """
    CUDA Pitched memory pointer  ::make_cudaPitchedPtr

    Attributes
    ----------
    ptr : Any
        Pointer to allocated memory
    pitch : size_t
        Pitch of allocated memory in bytes
    xsize : size_t
        Logical width of allocation in elements
    ysize : size_t
        Logical height of allocation in elements

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaPitchedPtr *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['ptr : ' + hex(self.ptr)]
            except ValueError:
                str_list += ['ptr : <ValueError>']
            try:
                str_list += ['pitch : ' + str(self.pitch)]
            except ValueError:
                str_list += ['pitch : <ValueError>']
            try:
                str_list += ['xsize : ' + str(self.xsize)]
            except ValueError:
                str_list += ['xsize : <ValueError>']
            try:
                str_list += ['ysize : ' + str(self.ysize)]
            except ValueError:
                str_list += ['ysize : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def ptr(self):
        return <void_ptr>self._pvt_ptr[0].ptr
    @ptr.setter
    def ptr(self, ptr):
        _cptr = _HelperInputVoidPtr(ptr)
        self._pvt_ptr[0].ptr = <void*><void_ptr>_cptr.cptr
    @property
    def pitch(self):
        return self._pvt_ptr[0].pitch
    @pitch.setter
    def pitch(self, size_t pitch):
        self._pvt_ptr[0].pitch = pitch
    @property
    def xsize(self):
        return self._pvt_ptr[0].xsize
    @xsize.setter
    def xsize(self, size_t xsize):
        self._pvt_ptr[0].xsize = xsize
    @property
    def ysize(self):
        return self._pvt_ptr[0].ysize
    @ysize.setter
    def ysize(self, size_t ysize):
        self._pvt_ptr[0].ysize = ysize

cdef class cudaExtent:
    """
    CUDA extent  ::make_cudaExtent

    Attributes
    ----------
    width : size_t
        Width in elements when referring to array memory, in bytes when
        referring to linear memory
    height : size_t
        Height in elements
    depth : size_t
        Depth in elements

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaExtent *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            try:
                str_list += ['depth : ' + str(self.depth)]
            except ValueError:
                str_list += ['depth : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def width(self):
        return self._pvt_ptr[0].width
    @width.setter
    def width(self, size_t width):
        self._pvt_ptr[0].width = width
    @property
    def height(self):
        return self._pvt_ptr[0].height
    @height.setter
    def height(self, size_t height):
        self._pvt_ptr[0].height = height
    @property
    def depth(self):
        return self._pvt_ptr[0].depth
    @depth.setter
    def depth(self, size_t depth):
        self._pvt_ptr[0].depth = depth

cdef class cudaPos:
    """
    CUDA 3D position  ::make_cudaPos

    Attributes
    ----------
    x : size_t
        x
    y : size_t
        y
    z : size_t
        z

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaPos *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['x : ' + str(self.x)]
            except ValueError:
                str_list += ['x : <ValueError>']
            try:
                str_list += ['y : ' + str(self.y)]
            except ValueError:
                str_list += ['y : <ValueError>']
            try:
                str_list += ['z : ' + str(self.z)]
            except ValueError:
                str_list += ['z : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def x(self):
        return self._pvt_ptr[0].x
    @x.setter
    def x(self, size_t x):
        self._pvt_ptr[0].x = x
    @property
    def y(self):
        return self._pvt_ptr[0].y
    @y.setter
    def y(self, size_t y):
        self._pvt_ptr[0].y = y
    @property
    def z(self):
        return self._pvt_ptr[0].z
    @z.setter
    def z(self, size_t z):
        self._pvt_ptr[0].z = z

cdef class cudaMemcpy3DParms:
    """
    CUDA 3D memory copying parameters

    Attributes
    ----------
    srcArray : cudaArray_t
        Source memory address
    srcPos : cudaPos
        Source position offset
    srcPtr : cudaPitchedPtr
        Pitched source memory address
    dstArray : cudaArray_t
        Destination memory address
    dstPos : cudaPos
        Destination position offset
    dstPtr : cudaPitchedPtr
        Pitched destination memory address
    extent : cudaExtent
        Requested memory copy size
    kind : cudaMemcpyKind
        Type of transfer

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemcpy3DParms *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._srcArray = cudaArray_t(_ptr=<void_ptr>&self._pvt_ptr[0].srcArray)
        self._srcPos = cudaPos(_ptr=<void_ptr>&self._pvt_ptr[0].srcPos)
        self._srcPtr = cudaPitchedPtr(_ptr=<void_ptr>&self._pvt_ptr[0].srcPtr)
        self._dstArray = cudaArray_t(_ptr=<void_ptr>&self._pvt_ptr[0].dstArray)
        self._dstPos = cudaPos(_ptr=<void_ptr>&self._pvt_ptr[0].dstPos)
        self._dstPtr = cudaPitchedPtr(_ptr=<void_ptr>&self._pvt_ptr[0].dstPtr)
        self._extent = cudaExtent(_ptr=<void_ptr>&self._pvt_ptr[0].extent)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['srcArray : ' + str(self.srcArray)]
            except ValueError:
                str_list += ['srcArray : <ValueError>']
            try:
                str_list += ['srcPos :\n' + '\n'.join(['    ' + line for line in str(self.srcPos).splitlines()])]
            except ValueError:
                str_list += ['srcPos : <ValueError>']
            try:
                str_list += ['srcPtr :\n' + '\n'.join(['    ' + line for line in str(self.srcPtr).splitlines()])]
            except ValueError:
                str_list += ['srcPtr : <ValueError>']
            try:
                str_list += ['dstArray : ' + str(self.dstArray)]
            except ValueError:
                str_list += ['dstArray : <ValueError>']
            try:
                str_list += ['dstPos :\n' + '\n'.join(['    ' + line for line in str(self.dstPos).splitlines()])]
            except ValueError:
                str_list += ['dstPos : <ValueError>']
            try:
                str_list += ['dstPtr :\n' + '\n'.join(['    ' + line for line in str(self.dstPtr).splitlines()])]
            except ValueError:
                str_list += ['dstPtr : <ValueError>']
            try:
                str_list += ['extent :\n' + '\n'.join(['    ' + line for line in str(self.extent).splitlines()])]
            except ValueError:
                str_list += ['extent : <ValueError>']
            try:
                str_list += ['kind : ' + str(self.kind)]
            except ValueError:
                str_list += ['kind : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def srcArray(self):
        return self._srcArray
    @srcArray.setter
    def srcArray(self, srcArray):
        cdef cyruntime.cudaArray_t cysrcArray
        if srcArray is None:
            cysrcArray = <cyruntime.cudaArray_t><void_ptr>0
        elif isinstance(srcArray, (cudaArray_t,)):
            psrcArray = int(srcArray)
            cysrcArray = <cyruntime.cudaArray_t><void_ptr>psrcArray
        else:
            psrcArray = int(cudaArray_t(srcArray))
            cysrcArray = <cyruntime.cudaArray_t><void_ptr>psrcArray
        self._srcArray._pvt_ptr[0] = cysrcArray
    @property
    def srcPos(self):
        return self._srcPos
    @srcPos.setter
    def srcPos(self, srcPos not None : cudaPos):
        string.memcpy(&self._pvt_ptr[0].srcPos, <cyruntime.cudaPos*><void_ptr>srcPos.getPtr(), sizeof(self._pvt_ptr[0].srcPos))
    @property
    def srcPtr(self):
        return self._srcPtr
    @srcPtr.setter
    def srcPtr(self, srcPtr not None : cudaPitchedPtr):
        string.memcpy(&self._pvt_ptr[0].srcPtr, <cyruntime.cudaPitchedPtr*><void_ptr>srcPtr.getPtr(), sizeof(self._pvt_ptr[0].srcPtr))
    @property
    def dstArray(self):
        return self._dstArray
    @dstArray.setter
    def dstArray(self, dstArray):
        cdef cyruntime.cudaArray_t cydstArray
        if dstArray is None:
            cydstArray = <cyruntime.cudaArray_t><void_ptr>0
        elif isinstance(dstArray, (cudaArray_t,)):
            pdstArray = int(dstArray)
            cydstArray = <cyruntime.cudaArray_t><void_ptr>pdstArray
        else:
            pdstArray = int(cudaArray_t(dstArray))
            cydstArray = <cyruntime.cudaArray_t><void_ptr>pdstArray
        self._dstArray._pvt_ptr[0] = cydstArray
    @property
    def dstPos(self):
        return self._dstPos
    @dstPos.setter
    def dstPos(self, dstPos not None : cudaPos):
        string.memcpy(&self._pvt_ptr[0].dstPos, <cyruntime.cudaPos*><void_ptr>dstPos.getPtr(), sizeof(self._pvt_ptr[0].dstPos))
    @property
    def dstPtr(self):
        return self._dstPtr
    @dstPtr.setter
    def dstPtr(self, dstPtr not None : cudaPitchedPtr):
        string.memcpy(&self._pvt_ptr[0].dstPtr, <cyruntime.cudaPitchedPtr*><void_ptr>dstPtr.getPtr(), sizeof(self._pvt_ptr[0].dstPtr))
    @property
    def extent(self):
        return self._extent
    @extent.setter
    def extent(self, extent not None : cudaExtent):
        string.memcpy(&self._pvt_ptr[0].extent, <cyruntime.cudaExtent*><void_ptr>extent.getPtr(), sizeof(self._pvt_ptr[0].extent))
    @property
    def kind(self):
        if self._pvt_ptr[0].kind not in _dict_cudaMemcpyKind:
            return None
        return _dict_cudaMemcpyKind[self._pvt_ptr[0].kind]
    @kind.setter
    def kind(self, kind not None : cudaMemcpyKind):
        self._pvt_ptr[0].kind = kind.value

cdef class cudaMemcpyNodeParams:
    """
    Memcpy node parameters

    Attributes
    ----------
    flags : int
        Must be zero
    reserved : int
        Must be zero
    ctx : cudaExecutionContext_t
        Context in which to run the memcpy. If NULL will try to use the
        current context.
    copyParams : cudaMemcpy3DParms
        Parameters for the memory copy

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemcpyNodeParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._ctx = cudaExecutionContext_t(_ptr=<void_ptr>&self._pvt_ptr[0].ctx)
        self._copyParams = cudaMemcpy3DParms(_ptr=<void_ptr>&self._pvt_ptr[0].copyParams)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            try:
                str_list += ['ctx : ' + str(self.ctx)]
            except ValueError:
                str_list += ['ctx : <ValueError>']
            try:
                str_list += ['copyParams :\n' + '\n'.join(['    ' + line for line in str(self.copyParams).splitlines()])]
            except ValueError:
                str_list += ['copyParams : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, int reserved):
        self._pvt_ptr[0].reserved = reserved
    @property
    def ctx(self):
        return self._ctx
    @ctx.setter
    def ctx(self, ctx):
        cdef cyruntime.cudaExecutionContext_t cyctx
        if ctx is None:
            cyctx = <cyruntime.cudaExecutionContext_t><void_ptr>0
        elif isinstance(ctx, (cudaExecutionContext_t,)):
            pctx = int(ctx)
            cyctx = <cyruntime.cudaExecutionContext_t><void_ptr>pctx
        else:
            pctx = int(cudaExecutionContext_t(ctx))
            cyctx = <cyruntime.cudaExecutionContext_t><void_ptr>pctx
        self._ctx._pvt_ptr[0] = cyctx
    @property
    def copyParams(self):
        return self._copyParams
    @copyParams.setter
    def copyParams(self, copyParams not None : cudaMemcpy3DParms):
        string.memcpy(&self._pvt_ptr[0].copyParams, <cyruntime.cudaMemcpy3DParms*><void_ptr>copyParams.getPtr(), sizeof(self._pvt_ptr[0].copyParams))

cdef class cudaMemcpy3DPeerParms:
    """
    CUDA 3D cross-device memory copying parameters

    Attributes
    ----------
    srcArray : cudaArray_t
        Source memory address
    srcPos : cudaPos
        Source position offset
    srcPtr : cudaPitchedPtr
        Pitched source memory address
    srcDevice : int
        Source device
    dstArray : cudaArray_t
        Destination memory address
    dstPos : cudaPos
        Destination position offset
    dstPtr : cudaPitchedPtr
        Pitched destination memory address
    dstDevice : int
        Destination device
    extent : cudaExtent
        Requested memory copy size

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemcpy3DPeerParms *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._srcArray = cudaArray_t(_ptr=<void_ptr>&self._pvt_ptr[0].srcArray)
        self._srcPos = cudaPos(_ptr=<void_ptr>&self._pvt_ptr[0].srcPos)
        self._srcPtr = cudaPitchedPtr(_ptr=<void_ptr>&self._pvt_ptr[0].srcPtr)
        self._dstArray = cudaArray_t(_ptr=<void_ptr>&self._pvt_ptr[0].dstArray)
        self._dstPos = cudaPos(_ptr=<void_ptr>&self._pvt_ptr[0].dstPos)
        self._dstPtr = cudaPitchedPtr(_ptr=<void_ptr>&self._pvt_ptr[0].dstPtr)
        self._extent = cudaExtent(_ptr=<void_ptr>&self._pvt_ptr[0].extent)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['srcArray : ' + str(self.srcArray)]
            except ValueError:
                str_list += ['srcArray : <ValueError>']
            try:
                str_list += ['srcPos :\n' + '\n'.join(['    ' + line for line in str(self.srcPos).splitlines()])]
            except ValueError:
                str_list += ['srcPos : <ValueError>']
            try:
                str_list += ['srcPtr :\n' + '\n'.join(['    ' + line for line in str(self.srcPtr).splitlines()])]
            except ValueError:
                str_list += ['srcPtr : <ValueError>']
            try:
                str_list += ['srcDevice : ' + str(self.srcDevice)]
            except ValueError:
                str_list += ['srcDevice : <ValueError>']
            try:
                str_list += ['dstArray : ' + str(self.dstArray)]
            except ValueError:
                str_list += ['dstArray : <ValueError>']
            try:
                str_list += ['dstPos :\n' + '\n'.join(['    ' + line for line in str(self.dstPos).splitlines()])]
            except ValueError:
                str_list += ['dstPos : <ValueError>']
            try:
                str_list += ['dstPtr :\n' + '\n'.join(['    ' + line for line in str(self.dstPtr).splitlines()])]
            except ValueError:
                str_list += ['dstPtr : <ValueError>']
            try:
                str_list += ['dstDevice : ' + str(self.dstDevice)]
            except ValueError:
                str_list += ['dstDevice : <ValueError>']
            try:
                str_list += ['extent :\n' + '\n'.join(['    ' + line for line in str(self.extent).splitlines()])]
            except ValueError:
                str_list += ['extent : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def srcArray(self):
        return self._srcArray
    @srcArray.setter
    def srcArray(self, srcArray):
        cdef cyruntime.cudaArray_t cysrcArray
        if srcArray is None:
            cysrcArray = <cyruntime.cudaArray_t><void_ptr>0
        elif isinstance(srcArray, (cudaArray_t,)):
            psrcArray = int(srcArray)
            cysrcArray = <cyruntime.cudaArray_t><void_ptr>psrcArray
        else:
            psrcArray = int(cudaArray_t(srcArray))
            cysrcArray = <cyruntime.cudaArray_t><void_ptr>psrcArray
        self._srcArray._pvt_ptr[0] = cysrcArray
    @property
    def srcPos(self):
        return self._srcPos
    @srcPos.setter
    def srcPos(self, srcPos not None : cudaPos):
        string.memcpy(&self._pvt_ptr[0].srcPos, <cyruntime.cudaPos*><void_ptr>srcPos.getPtr(), sizeof(self._pvt_ptr[0].srcPos))
    @property
    def srcPtr(self):
        return self._srcPtr
    @srcPtr.setter
    def srcPtr(self, srcPtr not None : cudaPitchedPtr):
        string.memcpy(&self._pvt_ptr[0].srcPtr, <cyruntime.cudaPitchedPtr*><void_ptr>srcPtr.getPtr(), sizeof(self._pvt_ptr[0].srcPtr))
    @property
    def srcDevice(self):
        return self._pvt_ptr[0].srcDevice
    @srcDevice.setter
    def srcDevice(self, int srcDevice):
        self._pvt_ptr[0].srcDevice = srcDevice
    @property
    def dstArray(self):
        return self._dstArray
    @dstArray.setter
    def dstArray(self, dstArray):
        cdef cyruntime.cudaArray_t cydstArray
        if dstArray is None:
            cydstArray = <cyruntime.cudaArray_t><void_ptr>0
        elif isinstance(dstArray, (cudaArray_t,)):
            pdstArray = int(dstArray)
            cydstArray = <cyruntime.cudaArray_t><void_ptr>pdstArray
        else:
            pdstArray = int(cudaArray_t(dstArray))
            cydstArray = <cyruntime.cudaArray_t><void_ptr>pdstArray
        self._dstArray._pvt_ptr[0] = cydstArray
    @property
    def dstPos(self):
        return self._dstPos
    @dstPos.setter
    def dstPos(self, dstPos not None : cudaPos):
        string.memcpy(&self._pvt_ptr[0].dstPos, <cyruntime.cudaPos*><void_ptr>dstPos.getPtr(), sizeof(self._pvt_ptr[0].dstPos))
    @property
    def dstPtr(self):
        return self._dstPtr
    @dstPtr.setter
    def dstPtr(self, dstPtr not None : cudaPitchedPtr):
        string.memcpy(&self._pvt_ptr[0].dstPtr, <cyruntime.cudaPitchedPtr*><void_ptr>dstPtr.getPtr(), sizeof(self._pvt_ptr[0].dstPtr))
    @property
    def dstDevice(self):
        return self._pvt_ptr[0].dstDevice
    @dstDevice.setter
    def dstDevice(self, int dstDevice):
        self._pvt_ptr[0].dstDevice = dstDevice
    @property
    def extent(self):
        return self._extent
    @extent.setter
    def extent(self, extent not None : cudaExtent):
        string.memcpy(&self._pvt_ptr[0].extent, <cyruntime.cudaExtent*><void_ptr>extent.getPtr(), sizeof(self._pvt_ptr[0].extent))

cdef class cudaMemsetParams:
    """
    CUDA Memset node parameters

    Attributes
    ----------
    dst : Any
        Destination device pointer
    pitch : size_t
        Pitch of destination device pointer. Unused if height is 1
    value : unsigned int
        Value to be set
    elementSize : unsigned int
        Size of each element in bytes. Must be 1, 2, or 4.
    width : size_t
        Width of the row in elements
    height : size_t
        Number of rows

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemsetParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['dst : ' + hex(self.dst)]
            except ValueError:
                str_list += ['dst : <ValueError>']
            try:
                str_list += ['pitch : ' + str(self.pitch)]
            except ValueError:
                str_list += ['pitch : <ValueError>']
            try:
                str_list += ['value : ' + str(self.value)]
            except ValueError:
                str_list += ['value : <ValueError>']
            try:
                str_list += ['elementSize : ' + str(self.elementSize)]
            except ValueError:
                str_list += ['elementSize : <ValueError>']
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def dst(self):
        return <void_ptr>self._pvt_ptr[0].dst
    @dst.setter
    def dst(self, dst):
        _cdst = _HelperInputVoidPtr(dst)
        self._pvt_ptr[0].dst = <void*><void_ptr>_cdst.cptr
    @property
    def pitch(self):
        return self._pvt_ptr[0].pitch
    @pitch.setter
    def pitch(self, size_t pitch):
        self._pvt_ptr[0].pitch = pitch
    @property
    def value(self):
        return self._pvt_ptr[0].value
    @value.setter
    def value(self, unsigned int value):
        self._pvt_ptr[0].value = value
    @property
    def elementSize(self):
        return self._pvt_ptr[0].elementSize
    @elementSize.setter
    def elementSize(self, unsigned int elementSize):
        self._pvt_ptr[0].elementSize = elementSize
    @property
    def width(self):
        return self._pvt_ptr[0].width
    @width.setter
    def width(self, size_t width):
        self._pvt_ptr[0].width = width
    @property
    def height(self):
        return self._pvt_ptr[0].height
    @height.setter
    def height(self, size_t height):
        self._pvt_ptr[0].height = height

cdef class cudaMemsetParamsV2:
    """
    CUDA Memset node parameters

    Attributes
    ----------
    dst : Any
        Destination device pointer
    pitch : size_t
        Pitch of destination device pointer. Unused if height is 1
    value : unsigned int
        Value to be set
    elementSize : unsigned int
        Size of each element in bytes. Must be 1, 2, or 4.
    width : size_t
        Width of the row in elements
    height : size_t
        Number of rows
    ctx : cudaExecutionContext_t
        Context in which to run the memset. If NULL will try to use the
        current context.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemsetParamsV2 *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._ctx = cudaExecutionContext_t(_ptr=<void_ptr>&self._pvt_ptr[0].ctx)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['dst : ' + hex(self.dst)]
            except ValueError:
                str_list += ['dst : <ValueError>']
            try:
                str_list += ['pitch : ' + str(self.pitch)]
            except ValueError:
                str_list += ['pitch : <ValueError>']
            try:
                str_list += ['value : ' + str(self.value)]
            except ValueError:
                str_list += ['value : <ValueError>']
            try:
                str_list += ['elementSize : ' + str(self.elementSize)]
            except ValueError:
                str_list += ['elementSize : <ValueError>']
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            try:
                str_list += ['ctx : ' + str(self.ctx)]
            except ValueError:
                str_list += ['ctx : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def dst(self):
        return <void_ptr>self._pvt_ptr[0].dst
    @dst.setter
    def dst(self, dst):
        _cdst = _HelperInputVoidPtr(dst)
        self._pvt_ptr[0].dst = <void*><void_ptr>_cdst.cptr
    @property
    def pitch(self):
        return self._pvt_ptr[0].pitch
    @pitch.setter
    def pitch(self, size_t pitch):
        self._pvt_ptr[0].pitch = pitch
    @property
    def value(self):
        return self._pvt_ptr[0].value
    @value.setter
    def value(self, unsigned int value):
        self._pvt_ptr[0].value = value
    @property
    def elementSize(self):
        return self._pvt_ptr[0].elementSize
    @elementSize.setter
    def elementSize(self, unsigned int elementSize):
        self._pvt_ptr[0].elementSize = elementSize
    @property
    def width(self):
        return self._pvt_ptr[0].width
    @width.setter
    def width(self, size_t width):
        self._pvt_ptr[0].width = width
    @property
    def height(self):
        return self._pvt_ptr[0].height
    @height.setter
    def height(self, size_t height):
        self._pvt_ptr[0].height = height
    @property
    def ctx(self):
        return self._ctx
    @ctx.setter
    def ctx(self, ctx):
        cdef cyruntime.cudaExecutionContext_t cyctx
        if ctx is None:
            cyctx = <cyruntime.cudaExecutionContext_t><void_ptr>0
        elif isinstance(ctx, (cudaExecutionContext_t,)):
            pctx = int(ctx)
            cyctx = <cyruntime.cudaExecutionContext_t><void_ptr>pctx
        else:
            pctx = int(cudaExecutionContext_t(ctx))
            cyctx = <cyruntime.cudaExecutionContext_t><void_ptr>pctx
        self._ctx._pvt_ptr[0] = cyctx

cdef class cudaAccessPolicyWindow:
    """
    Specifies an access policy for a window, a contiguous extent of
    memory beginning at base_ptr and ending at base_ptr + num_bytes.
    Partition into many segments and assign segments such that. sum of
    "hit segments" / window == approx. ratio. sum of "miss segments" /
    window == approx 1-ratio. Segments and ratio specifications are
    fitted to the capabilities of the architecture. Accesses in a hit
    segment apply the hitProp access policy. Accesses in a miss segment
    apply the missProp access policy.

    Attributes
    ----------
    base_ptr : Any
        Starting address of the access policy window. CUDA driver may align
        it.
    num_bytes : size_t
        Size in bytes of the window policy. CUDA driver may restrict the
        maximum size and alignment.
    hitRatio : float
        hitRatio specifies percentage of lines assigned hitProp, rest are
        assigned missProp.
    hitProp : cudaAccessProperty
        ::CUaccessProperty set for hit.
    missProp : cudaAccessProperty
        ::CUaccessProperty set for miss. Must be either NORMAL or
        STREAMING.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaAccessPolicyWindow *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['base_ptr : ' + hex(self.base_ptr)]
            except ValueError:
                str_list += ['base_ptr : <ValueError>']
            try:
                str_list += ['num_bytes : ' + str(self.num_bytes)]
            except ValueError:
                str_list += ['num_bytes : <ValueError>']
            try:
                str_list += ['hitRatio : ' + str(self.hitRatio)]
            except ValueError:
                str_list += ['hitRatio : <ValueError>']
            try:
                str_list += ['hitProp : ' + str(self.hitProp)]
            except ValueError:
                str_list += ['hitProp : <ValueError>']
            try:
                str_list += ['missProp : ' + str(self.missProp)]
            except ValueError:
                str_list += ['missProp : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def base_ptr(self):
        return <void_ptr>self._pvt_ptr[0].base_ptr
    @base_ptr.setter
    def base_ptr(self, base_ptr):
        _cbase_ptr = _HelperInputVoidPtr(base_ptr)
        self._pvt_ptr[0].base_ptr = <void*><void_ptr>_cbase_ptr.cptr
    @property
    def num_bytes(self):
        return self._pvt_ptr[0].num_bytes
    @num_bytes.setter
    def num_bytes(self, size_t num_bytes):
        self._pvt_ptr[0].num_bytes = num_bytes
    @property
    def hitRatio(self):
        return self._pvt_ptr[0].hitRatio
    @hitRatio.setter
    def hitRatio(self, float hitRatio):
        self._pvt_ptr[0].hitRatio = hitRatio
    @property
    def hitProp(self):
        if self._pvt_ptr[0].hitProp not in _dict_cudaAccessProperty:
            return None
        return _dict_cudaAccessProperty[self._pvt_ptr[0].hitProp]
    @hitProp.setter
    def hitProp(self, hitProp not None : cudaAccessProperty):
        self._pvt_ptr[0].hitProp = hitProp.value
    @property
    def missProp(self):
        if self._pvt_ptr[0].missProp not in _dict_cudaAccessProperty:
            return None
        return _dict_cudaAccessProperty[self._pvt_ptr[0].missProp]
    @missProp.setter
    def missProp(self, missProp not None : cudaAccessProperty):
        self._pvt_ptr[0].missProp = missProp.value

cdef class cudaHostNodeParams:
    """
    CUDA host node parameters

    Attributes
    ----------
    fn : cudaHostFn_t
        The function to call when the node executes
    userData : Any
        Argument to pass to the function

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaHostNodeParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._fn = cudaHostFn_t(_ptr=<void_ptr>&self._pvt_ptr[0].fn)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fn : ' + str(self.fn)]
            except ValueError:
                str_list += ['fn : <ValueError>']
            try:
                str_list += ['userData : ' + hex(self.userData)]
            except ValueError:
                str_list += ['userData : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fn(self):
        return self._fn
    @fn.setter
    def fn(self, fn):
        cdef cyruntime.cudaHostFn_t cyfn
        if fn is None:
            cyfn = <cyruntime.cudaHostFn_t><void_ptr>0
        elif isinstance(fn, (cudaHostFn_t)):
            pfn = int(fn)
            cyfn = <cyruntime.cudaHostFn_t><void_ptr>pfn
        else:
            pfn = int(cudaHostFn_t(fn))
            cyfn = <cyruntime.cudaHostFn_t><void_ptr>pfn
        self._fn._pvt_ptr[0] = cyfn
    @property
    def userData(self):
        return <void_ptr>self._pvt_ptr[0].userData
    @userData.setter
    def userData(self, userData):
        _cuserData = _HelperInputVoidPtr(userData)
        self._pvt_ptr[0].userData = <void*><void_ptr>_cuserData.cptr

cdef class cudaHostNodeParamsV2:
    """
    CUDA host node parameters

    Attributes
    ----------
    fn : cudaHostFn_t
        The function to call when the node executes
    userData : Any
        Argument to pass to the function

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaHostNodeParamsV2 *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._fn = cudaHostFn_t(_ptr=<void_ptr>&self._pvt_ptr[0].fn)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fn : ' + str(self.fn)]
            except ValueError:
                str_list += ['fn : <ValueError>']
            try:
                str_list += ['userData : ' + hex(self.userData)]
            except ValueError:
                str_list += ['userData : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fn(self):
        return self._fn
    @fn.setter
    def fn(self, fn):
        cdef cyruntime.cudaHostFn_t cyfn
        if fn is None:
            cyfn = <cyruntime.cudaHostFn_t><void_ptr>0
        elif isinstance(fn, (cudaHostFn_t)):
            pfn = int(fn)
            cyfn = <cyruntime.cudaHostFn_t><void_ptr>pfn
        else:
            pfn = int(cudaHostFn_t(fn))
            cyfn = <cyruntime.cudaHostFn_t><void_ptr>pfn
        self._fn._pvt_ptr[0] = cyfn
    @property
    def userData(self):
        return <void_ptr>self._pvt_ptr[0].userData
    @userData.setter
    def userData(self, userData):
        _cuserData = _HelperInputVoidPtr(userData)
        self._pvt_ptr[0].userData = <void*><void_ptr>_cuserData.cptr

cdef class anon_struct1:
    """
    Attributes
    ----------
    array : cudaArray_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaResourceDesc *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._array = cudaArray_t(_ptr=<void_ptr>&self._pvt_ptr[0].res.array.array)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].res.array
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['array : ' + str(self.array)]
            except ValueError:
                str_list += ['array : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def array(self):
        return self._array
    @array.setter
    def array(self, array):
        cdef cyruntime.cudaArray_t cyarray
        if array is None:
            cyarray = <cyruntime.cudaArray_t><void_ptr>0
        elif isinstance(array, (cudaArray_t,)):
            parray = int(array)
            cyarray = <cyruntime.cudaArray_t><void_ptr>parray
        else:
            parray = int(cudaArray_t(array))
            cyarray = <cyruntime.cudaArray_t><void_ptr>parray
        self._array._pvt_ptr[0] = cyarray

cdef class anon_struct2:
    """
    Attributes
    ----------
    mipmap : cudaMipmappedArray_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaResourceDesc *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._mipmap = cudaMipmappedArray_t(_ptr=<void_ptr>&self._pvt_ptr[0].res.mipmap.mipmap)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].res.mipmap
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['mipmap : ' + str(self.mipmap)]
            except ValueError:
                str_list += ['mipmap : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def mipmap(self):
        return self._mipmap
    @mipmap.setter
    def mipmap(self, mipmap):
        cdef cyruntime.cudaMipmappedArray_t cymipmap
        if mipmap is None:
            cymipmap = <cyruntime.cudaMipmappedArray_t><void_ptr>0
        elif isinstance(mipmap, (cudaMipmappedArray_t,)):
            pmipmap = int(mipmap)
            cymipmap = <cyruntime.cudaMipmappedArray_t><void_ptr>pmipmap
        else:
            pmipmap = int(cudaMipmappedArray_t(mipmap))
            cymipmap = <cyruntime.cudaMipmappedArray_t><void_ptr>pmipmap
        self._mipmap._pvt_ptr[0] = cymipmap

cdef class anon_struct3:
    """
    Attributes
    ----------
    devPtr : Any

    desc : cudaChannelFormatDesc

    sizeInBytes : size_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaResourceDesc *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._desc = cudaChannelFormatDesc(_ptr=<void_ptr>&self._pvt_ptr[0].res.linear.desc)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].res.linear
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['devPtr : ' + hex(self.devPtr)]
            except ValueError:
                str_list += ['devPtr : <ValueError>']
            try:
                str_list += ['desc :\n' + '\n'.join(['    ' + line for line in str(self.desc).splitlines()])]
            except ValueError:
                str_list += ['desc : <ValueError>']
            try:
                str_list += ['sizeInBytes : ' + str(self.sizeInBytes)]
            except ValueError:
                str_list += ['sizeInBytes : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def devPtr(self):
        return <void_ptr>self._pvt_ptr[0].res.linear.devPtr
    @devPtr.setter
    def devPtr(self, devPtr):
        _cdevPtr = _HelperInputVoidPtr(devPtr)
        self._pvt_ptr[0].res.linear.devPtr = <void*><void_ptr>_cdevPtr.cptr
    @property
    def desc(self):
        return self._desc
    @desc.setter
    def desc(self, desc not None : cudaChannelFormatDesc):
        string.memcpy(&self._pvt_ptr[0].res.linear.desc, <cyruntime.cudaChannelFormatDesc*><void_ptr>desc.getPtr(), sizeof(self._pvt_ptr[0].res.linear.desc))
    @property
    def sizeInBytes(self):
        return self._pvt_ptr[0].res.linear.sizeInBytes
    @sizeInBytes.setter
    def sizeInBytes(self, size_t sizeInBytes):
        self._pvt_ptr[0].res.linear.sizeInBytes = sizeInBytes

cdef class anon_struct4:
    """
    Attributes
    ----------
    devPtr : Any

    desc : cudaChannelFormatDesc

    width : size_t

    height : size_t

    pitchInBytes : size_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaResourceDesc *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._desc = cudaChannelFormatDesc(_ptr=<void_ptr>&self._pvt_ptr[0].res.pitch2D.desc)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].res.pitch2D
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['devPtr : ' + hex(self.devPtr)]
            except ValueError:
                str_list += ['devPtr : <ValueError>']
            try:
                str_list += ['desc :\n' + '\n'.join(['    ' + line for line in str(self.desc).splitlines()])]
            except ValueError:
                str_list += ['desc : <ValueError>']
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            try:
                str_list += ['pitchInBytes : ' + str(self.pitchInBytes)]
            except ValueError:
                str_list += ['pitchInBytes : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def devPtr(self):
        return <void_ptr>self._pvt_ptr[0].res.pitch2D.devPtr
    @devPtr.setter
    def devPtr(self, devPtr):
        _cdevPtr = _HelperInputVoidPtr(devPtr)
        self._pvt_ptr[0].res.pitch2D.devPtr = <void*><void_ptr>_cdevPtr.cptr
    @property
    def desc(self):
        return self._desc
    @desc.setter
    def desc(self, desc not None : cudaChannelFormatDesc):
        string.memcpy(&self._pvt_ptr[0].res.pitch2D.desc, <cyruntime.cudaChannelFormatDesc*><void_ptr>desc.getPtr(), sizeof(self._pvt_ptr[0].res.pitch2D.desc))
    @property
    def width(self):
        return self._pvt_ptr[0].res.pitch2D.width
    @width.setter
    def width(self, size_t width):
        self._pvt_ptr[0].res.pitch2D.width = width
    @property
    def height(self):
        return self._pvt_ptr[0].res.pitch2D.height
    @height.setter
    def height(self, size_t height):
        self._pvt_ptr[0].res.pitch2D.height = height
    @property
    def pitchInBytes(self):
        return self._pvt_ptr[0].res.pitch2D.pitchInBytes
    @pitchInBytes.setter
    def pitchInBytes(self, size_t pitchInBytes):
        self._pvt_ptr[0].res.pitch2D.pitchInBytes = pitchInBytes

cdef class anon_struct5:
    """
    Attributes
    ----------
    reserved : list[int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaResourceDesc *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].res.reserved
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def reserved(self):
        return self._pvt_ptr[0].res.reserved.reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].res.reserved.reserved = reserved

cdef class anon_union0:
    """
    Attributes
    ----------
    array : anon_struct1

    mipmap : anon_struct2

    linear : anon_struct3

    pitch2D : anon_struct4

    reserved : anon_struct5


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaResourceDesc *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._array = anon_struct1(_ptr=<void_ptr>self._pvt_ptr)
        self._mipmap = anon_struct2(_ptr=<void_ptr>self._pvt_ptr)
        self._linear = anon_struct3(_ptr=<void_ptr>self._pvt_ptr)
        self._pitch2D = anon_struct4(_ptr=<void_ptr>self._pvt_ptr)
        self._reserved = anon_struct5(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].res
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['array :\n' + '\n'.join(['    ' + line for line in str(self.array).splitlines()])]
            except ValueError:
                str_list += ['array : <ValueError>']
            try:
                str_list += ['mipmap :\n' + '\n'.join(['    ' + line for line in str(self.mipmap).splitlines()])]
            except ValueError:
                str_list += ['mipmap : <ValueError>']
            try:
                str_list += ['linear :\n' + '\n'.join(['    ' + line for line in str(self.linear).splitlines()])]
            except ValueError:
                str_list += ['linear : <ValueError>']
            try:
                str_list += ['pitch2D :\n' + '\n'.join(['    ' + line for line in str(self.pitch2D).splitlines()])]
            except ValueError:
                str_list += ['pitch2D : <ValueError>']
            try:
                str_list += ['reserved :\n' + '\n'.join(['    ' + line for line in str(self.reserved).splitlines()])]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def array(self):
        return self._array
    @array.setter
    def array(self, array not None : anon_struct1):
        string.memcpy(&self._pvt_ptr[0].res.array, <cyruntime.anon_struct1*><void_ptr>array.getPtr(), sizeof(self._pvt_ptr[0].res.array))
    @property
    def mipmap(self):
        return self._mipmap
    @mipmap.setter
    def mipmap(self, mipmap not None : anon_struct2):
        string.memcpy(&self._pvt_ptr[0].res.mipmap, <cyruntime.anon_struct2*><void_ptr>mipmap.getPtr(), sizeof(self._pvt_ptr[0].res.mipmap))
    @property
    def linear(self):
        return self._linear
    @linear.setter
    def linear(self, linear not None : anon_struct3):
        string.memcpy(&self._pvt_ptr[0].res.linear, <cyruntime.anon_struct3*><void_ptr>linear.getPtr(), sizeof(self._pvt_ptr[0].res.linear))
    @property
    def pitch2D(self):
        return self._pitch2D
    @pitch2D.setter
    def pitch2D(self, pitch2D not None : anon_struct4):
        string.memcpy(&self._pvt_ptr[0].res.pitch2D, <cyruntime.anon_struct4*><void_ptr>pitch2D.getPtr(), sizeof(self._pvt_ptr[0].res.pitch2D))
    @property
    def reserved(self):
        return self._reserved
    @reserved.setter
    def reserved(self, reserved not None : anon_struct5):
        string.memcpy(&self._pvt_ptr[0].res.reserved, <cyruntime.anon_struct5*><void_ptr>reserved.getPtr(), sizeof(self._pvt_ptr[0].res.reserved))

cdef class cudaResourceDesc:
    """
    CUDA resource descriptor

    Attributes
    ----------
    resType : cudaResourceType
        Resource type
    res : anon_union0

    flags : unsigned int
        Flags (must be zero)

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cyruntime.cudaResourceDesc *>calloc(1, sizeof(cyruntime.cudaResourceDesc))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cyruntime.cudaResourceDesc *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._res = anon_union0(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['resType : ' + str(self.resType)]
            except ValueError:
                str_list += ['resType : <ValueError>']
            try:
                str_list += ['res :\n' + '\n'.join(['    ' + line for line in str(self.res).splitlines()])]
            except ValueError:
                str_list += ['res : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def resType(self):
        if self._pvt_ptr[0].resType not in _dict_cudaResourceType:
            return None
        return _dict_cudaResourceType[self._pvt_ptr[0].resType]
    @resType.setter
    def resType(self, resType not None : cudaResourceType):
        self._pvt_ptr[0].resType = resType.value
    @property
    def res(self):
        return self._res
    @res.setter
    def res(self, res not None : anon_union0):
        string.memcpy(&self._pvt_ptr[0].res, <cyruntime.anon_union0*><void_ptr>res.getPtr(), sizeof(self._pvt_ptr[0].res))
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags

cdef class cudaResourceViewDesc:
    """
    CUDA resource view descriptor

    Attributes
    ----------
    format : cudaResourceViewFormat
        Resource view format
    width : size_t
        Width of the resource view
    height : size_t
        Height of the resource view
    depth : size_t
        Depth of the resource view
    firstMipmapLevel : unsigned int
        First defined mipmap level
    lastMipmapLevel : unsigned int
        Last defined mipmap level
    firstLayer : unsigned int
        First layer index
    lastLayer : unsigned int
        Last layer index
    reserved : list[unsigned int]
        Must be zero

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaResourceViewDesc *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['format : ' + str(self.format)]
            except ValueError:
                str_list += ['format : <ValueError>']
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            try:
                str_list += ['depth : ' + str(self.depth)]
            except ValueError:
                str_list += ['depth : <ValueError>']
            try:
                str_list += ['firstMipmapLevel : ' + str(self.firstMipmapLevel)]
            except ValueError:
                str_list += ['firstMipmapLevel : <ValueError>']
            try:
                str_list += ['lastMipmapLevel : ' + str(self.lastMipmapLevel)]
            except ValueError:
                str_list += ['lastMipmapLevel : <ValueError>']
            try:
                str_list += ['firstLayer : ' + str(self.firstLayer)]
            except ValueError:
                str_list += ['firstLayer : <ValueError>']
            try:
                str_list += ['lastLayer : ' + str(self.lastLayer)]
            except ValueError:
                str_list += ['lastLayer : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def format(self):
        if self._pvt_ptr[0].format not in _dict_cudaResourceViewFormat:
            return None
        return _dict_cudaResourceViewFormat[self._pvt_ptr[0].format]
    @format.setter
    def format(self, format not None : cudaResourceViewFormat):
        self._pvt_ptr[0].format = format.value
    @property
    def width(self):
        return self._pvt_ptr[0].width
    @width.setter
    def width(self, size_t width):
        self._pvt_ptr[0].width = width
    @property
    def height(self):
        return self._pvt_ptr[0].height
    @height.setter
    def height(self, size_t height):
        self._pvt_ptr[0].height = height
    @property
    def depth(self):
        return self._pvt_ptr[0].depth
    @depth.setter
    def depth(self, size_t depth):
        self._pvt_ptr[0].depth = depth
    @property
    def firstMipmapLevel(self):
        return self._pvt_ptr[0].firstMipmapLevel
    @firstMipmapLevel.setter
    def firstMipmapLevel(self, unsigned int firstMipmapLevel):
        self._pvt_ptr[0].firstMipmapLevel = firstMipmapLevel
    @property
    def lastMipmapLevel(self):
        return self._pvt_ptr[0].lastMipmapLevel
    @lastMipmapLevel.setter
    def lastMipmapLevel(self, unsigned int lastMipmapLevel):
        self._pvt_ptr[0].lastMipmapLevel = lastMipmapLevel
    @property
    def firstLayer(self):
        return self._pvt_ptr[0].firstLayer
    @firstLayer.setter
    def firstLayer(self, unsigned int firstLayer):
        self._pvt_ptr[0].firstLayer = firstLayer
    @property
    def lastLayer(self):
        return self._pvt_ptr[0].lastLayer
    @lastLayer.setter
    def lastLayer(self, unsigned int lastLayer):
        self._pvt_ptr[0].lastLayer = lastLayer
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class cudaPointerAttributes:
    """
    CUDA pointer attributes

    Attributes
    ----------
    type : cudaMemoryType
        The type of memory - cudaMemoryTypeUnregistered,
        cudaMemoryTypeHost, cudaMemoryTypeDevice or cudaMemoryTypeManaged.
    device : int
        The device against which the memory was allocated or registered. If
        the memory type is cudaMemoryTypeDevice then this identifies the
        device on which the memory referred physically resides. If the
        memory type is cudaMemoryTypeHost or::cudaMemoryTypeManaged then
        this identifies the device which was current when the memory was
        allocated or registered (and if that device is deinitialized then
        this allocation will vanish with that device's state).
    devicePointer : Any
        The address which may be dereferenced on the current device to
        access the memory or NULL if no such address exists.
    hostPointer : Any
        The address which may be dereferenced on the host to access the
        memory or NULL if no such address exists.  CUDA doesn't check if
        unregistered memory is allocated so this field may contain invalid
        pointer if an invalid pointer has been passed to CUDA.
    reserved : list[long]
        Must be zero

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaPointerAttributes *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['device : ' + str(self.device)]
            except ValueError:
                str_list += ['device : <ValueError>']
            try:
                str_list += ['devicePointer : ' + hex(self.devicePointer)]
            except ValueError:
                str_list += ['devicePointer : <ValueError>']
            try:
                str_list += ['hostPointer : ' + hex(self.hostPointer)]
            except ValueError:
                str_list += ['hostPointer : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_cudaMemoryType:
            return None
        return _dict_cudaMemoryType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : cudaMemoryType):
        self._pvt_ptr[0].type = type.value
    @property
    def device(self):
        return self._pvt_ptr[0].device
    @device.setter
    def device(self, int device):
        self._pvt_ptr[0].device = device
    @property
    def devicePointer(self):
        return <void_ptr>self._pvt_ptr[0].devicePointer
    @devicePointer.setter
    def devicePointer(self, devicePointer):
        _cdevicePointer = _HelperInputVoidPtr(devicePointer)
        self._pvt_ptr[0].devicePointer = <void*><void_ptr>_cdevicePointer.cptr
    @property
    def hostPointer(self):
        return <void_ptr>self._pvt_ptr[0].hostPointer
    @hostPointer.setter
    def hostPointer(self, hostPointer):
        _chostPointer = _HelperInputVoidPtr(hostPointer)
        self._pvt_ptr[0].hostPointer = <void*><void_ptr>_chostPointer.cptr
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class cudaFuncAttributes:
    """
    CUDA function attributes

    Attributes
    ----------
    sharedSizeBytes : size_t
        The size in bytes of statically-allocated shared memory per block
        required by this function. This does not include dynamically-
        allocated shared memory requested by the user at runtime.
    constSizeBytes : size_t
        The size in bytes of user-allocated constant memory required by
        this function.
    localSizeBytes : size_t
        The size in bytes of local memory used by each thread of this
        function.
    maxThreadsPerBlock : int
        The maximum number of threads per block, beyond which a launch of
        the function would fail. This number depends on both the function
        and the device on which the function is currently loaded.
    numRegs : int
        The number of registers used by each thread of this function.
    ptxVersion : int
        The PTX virtual architecture version for which the function was
        compiled. This value is the major PTX version * 10 + the minor PTX
        version, so a PTX version 1.3 function would return the value 13.
    binaryVersion : int
        The binary architecture version for which the function was
        compiled. This value is the major binary version * 10 + the minor
        binary version, so a binary version 1.3 function would return the
        value 13.
    cacheModeCA : int
        The attribute to indicate whether the function has been compiled
        with user specified option "-Xptxas --dlcm=ca" set.
    maxDynamicSharedSizeBytes : int
        The maximum size in bytes of dynamic shared memory per block for
        this function. Any launch must have a dynamic shared memory size
        smaller than this value.
    preferredShmemCarveout : int
        On devices where the L1 cache and shared memory use the same
        hardware resources, this sets the shared memory carveout
        preference, in percent of the maximum shared memory. Refer to
        cudaDevAttrMaxSharedMemoryPerMultiprocessor. This is only a hint,
        and the driver can choose a different ratio if required to execute
        the function. See cudaFuncSetAttribute
    clusterDimMustBeSet : int
        If this attribute is set, the kernel must launch with a valid
        cluster dimension specified.
    requiredClusterWidth : int
        The required cluster width/height/depth in blocks. The values must
        either all be 0 or all be positive. The validity of the cluster
        dimensions is otherwise checked at launch time.  If the value is
        set during compile time, it cannot be set at runtime. Setting it at
        runtime should return cudaErrorNotPermitted. See
        cudaFuncSetAttribute
    requiredClusterHeight : int

    requiredClusterDepth : int

    clusterSchedulingPolicyPreference : int
        The block scheduling policy of a function. See cudaFuncSetAttribute
    nonPortableClusterSizeAllowed : int
        Whether the function can be launched with non-portable cluster
        size. 1 is allowed, 0 is disallowed. A non-portable cluster size
        may only function on the specific SKUs the program is tested on.
        The launch might fail if the program is run on a different hardware
        platform.  CUDA API provides cudaOccupancyMaxActiveClusters to
        assist with checking whether the desired size can be launched on
        the current device.  Portable Cluster Size  A portable cluster size
        is guaranteed to be functional on all compute capabilities higher
        than the target compute capability. The portable cluster size for
        sm_90 is 8 blocks per cluster. This value may increase for future
        compute capabilities.  The specific hardware unit may support
        higher cluster sizes that’s not guaranteed to be portable. See
        cudaFuncSetAttribute
    reserved : list[int]
        Reserved for future use.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaFuncAttributes *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['sharedSizeBytes : ' + str(self.sharedSizeBytes)]
            except ValueError:
                str_list += ['sharedSizeBytes : <ValueError>']
            try:
                str_list += ['constSizeBytes : ' + str(self.constSizeBytes)]
            except ValueError:
                str_list += ['constSizeBytes : <ValueError>']
            try:
                str_list += ['localSizeBytes : ' + str(self.localSizeBytes)]
            except ValueError:
                str_list += ['localSizeBytes : <ValueError>']
            try:
                str_list += ['maxThreadsPerBlock : ' + str(self.maxThreadsPerBlock)]
            except ValueError:
                str_list += ['maxThreadsPerBlock : <ValueError>']
            try:
                str_list += ['numRegs : ' + str(self.numRegs)]
            except ValueError:
                str_list += ['numRegs : <ValueError>']
            try:
                str_list += ['ptxVersion : ' + str(self.ptxVersion)]
            except ValueError:
                str_list += ['ptxVersion : <ValueError>']
            try:
                str_list += ['binaryVersion : ' + str(self.binaryVersion)]
            except ValueError:
                str_list += ['binaryVersion : <ValueError>']
            try:
                str_list += ['cacheModeCA : ' + str(self.cacheModeCA)]
            except ValueError:
                str_list += ['cacheModeCA : <ValueError>']
            try:
                str_list += ['maxDynamicSharedSizeBytes : ' + str(self.maxDynamicSharedSizeBytes)]
            except ValueError:
                str_list += ['maxDynamicSharedSizeBytes : <ValueError>']
            try:
                str_list += ['preferredShmemCarveout : ' + str(self.preferredShmemCarveout)]
            except ValueError:
                str_list += ['preferredShmemCarveout : <ValueError>']
            try:
                str_list += ['clusterDimMustBeSet : ' + str(self.clusterDimMustBeSet)]
            except ValueError:
                str_list += ['clusterDimMustBeSet : <ValueError>']
            try:
                str_list += ['requiredClusterWidth : ' + str(self.requiredClusterWidth)]
            except ValueError:
                str_list += ['requiredClusterWidth : <ValueError>']
            try:
                str_list += ['requiredClusterHeight : ' + str(self.requiredClusterHeight)]
            except ValueError:
                str_list += ['requiredClusterHeight : <ValueError>']
            try:
                str_list += ['requiredClusterDepth : ' + str(self.requiredClusterDepth)]
            except ValueError:
                str_list += ['requiredClusterDepth : <ValueError>']
            try:
                str_list += ['clusterSchedulingPolicyPreference : ' + str(self.clusterSchedulingPolicyPreference)]
            except ValueError:
                str_list += ['clusterSchedulingPolicyPreference : <ValueError>']
            try:
                str_list += ['nonPortableClusterSizeAllowed : ' + str(self.nonPortableClusterSizeAllowed)]
            except ValueError:
                str_list += ['nonPortableClusterSizeAllowed : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def sharedSizeBytes(self):
        return self._pvt_ptr[0].sharedSizeBytes
    @sharedSizeBytes.setter
    def sharedSizeBytes(self, size_t sharedSizeBytes):
        self._pvt_ptr[0].sharedSizeBytes = sharedSizeBytes
    @property
    def constSizeBytes(self):
        return self._pvt_ptr[0].constSizeBytes
    @constSizeBytes.setter
    def constSizeBytes(self, size_t constSizeBytes):
        self._pvt_ptr[0].constSizeBytes = constSizeBytes
    @property
    def localSizeBytes(self):
        return self._pvt_ptr[0].localSizeBytes
    @localSizeBytes.setter
    def localSizeBytes(self, size_t localSizeBytes):
        self._pvt_ptr[0].localSizeBytes = localSizeBytes
    @property
    def maxThreadsPerBlock(self):
        return self._pvt_ptr[0].maxThreadsPerBlock
    @maxThreadsPerBlock.setter
    def maxThreadsPerBlock(self, int maxThreadsPerBlock):
        self._pvt_ptr[0].maxThreadsPerBlock = maxThreadsPerBlock
    @property
    def numRegs(self):
        return self._pvt_ptr[0].numRegs
    @numRegs.setter
    def numRegs(self, int numRegs):
        self._pvt_ptr[0].numRegs = numRegs
    @property
    def ptxVersion(self):
        return self._pvt_ptr[0].ptxVersion
    @ptxVersion.setter
    def ptxVersion(self, int ptxVersion):
        self._pvt_ptr[0].ptxVersion = ptxVersion
    @property
    def binaryVersion(self):
        return self._pvt_ptr[0].binaryVersion
    @binaryVersion.setter
    def binaryVersion(self, int binaryVersion):
        self._pvt_ptr[0].binaryVersion = binaryVersion
    @property
    def cacheModeCA(self):
        return self._pvt_ptr[0].cacheModeCA
    @cacheModeCA.setter
    def cacheModeCA(self, int cacheModeCA):
        self._pvt_ptr[0].cacheModeCA = cacheModeCA
    @property
    def maxDynamicSharedSizeBytes(self):
        return self._pvt_ptr[0].maxDynamicSharedSizeBytes
    @maxDynamicSharedSizeBytes.setter
    def maxDynamicSharedSizeBytes(self, int maxDynamicSharedSizeBytes):
        self._pvt_ptr[0].maxDynamicSharedSizeBytes = maxDynamicSharedSizeBytes
    @property
    def preferredShmemCarveout(self):
        return self._pvt_ptr[0].preferredShmemCarveout
    @preferredShmemCarveout.setter
    def preferredShmemCarveout(self, int preferredShmemCarveout):
        self._pvt_ptr[0].preferredShmemCarveout = preferredShmemCarveout
    @property
    def clusterDimMustBeSet(self):
        return self._pvt_ptr[0].clusterDimMustBeSet
    @clusterDimMustBeSet.setter
    def clusterDimMustBeSet(self, int clusterDimMustBeSet):
        self._pvt_ptr[0].clusterDimMustBeSet = clusterDimMustBeSet
    @property
    def requiredClusterWidth(self):
        return self._pvt_ptr[0].requiredClusterWidth
    @requiredClusterWidth.setter
    def requiredClusterWidth(self, int requiredClusterWidth):
        self._pvt_ptr[0].requiredClusterWidth = requiredClusterWidth
    @property
    def requiredClusterHeight(self):
        return self._pvt_ptr[0].requiredClusterHeight
    @requiredClusterHeight.setter
    def requiredClusterHeight(self, int requiredClusterHeight):
        self._pvt_ptr[0].requiredClusterHeight = requiredClusterHeight
    @property
    def requiredClusterDepth(self):
        return self._pvt_ptr[0].requiredClusterDepth
    @requiredClusterDepth.setter
    def requiredClusterDepth(self, int requiredClusterDepth):
        self._pvt_ptr[0].requiredClusterDepth = requiredClusterDepth
    @property
    def clusterSchedulingPolicyPreference(self):
        return self._pvt_ptr[0].clusterSchedulingPolicyPreference
    @clusterSchedulingPolicyPreference.setter
    def clusterSchedulingPolicyPreference(self, int clusterSchedulingPolicyPreference):
        self._pvt_ptr[0].clusterSchedulingPolicyPreference = clusterSchedulingPolicyPreference
    @property
    def nonPortableClusterSizeAllowed(self):
        return self._pvt_ptr[0].nonPortableClusterSizeAllowed
    @nonPortableClusterSizeAllowed.setter
    def nonPortableClusterSizeAllowed(self, int nonPortableClusterSizeAllowed):
        self._pvt_ptr[0].nonPortableClusterSizeAllowed = nonPortableClusterSizeAllowed
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class cudaMemLocation:
    """
    Specifies a memory location.  To specify a gpu, set type =
    cudaMemLocationTypeDevice and set id = the gpu's device ordinal. To
    specify a cpu NUMA node, set type = cudaMemLocationTypeHostNuma and
    set id = host NUMA node id.

    Attributes
    ----------
    type : cudaMemLocationType
        Specifies the location type, which modifies the meaning of id.
    id : int
        identifier for a given this location's ::CUmemLocationType.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemLocation *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['id : ' + str(self.id)]
            except ValueError:
                str_list += ['id : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_cudaMemLocationType:
            return None
        return _dict_cudaMemLocationType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : cudaMemLocationType):
        self._pvt_ptr[0].type = type.value
    @property
    def id(self):
        return self._pvt_ptr[0].id
    @id.setter
    def id(self, int id):
        self._pvt_ptr[0].id = id

cdef class cudaMemAccessDesc:
    """
    Memory access descriptor

    Attributes
    ----------
    location : cudaMemLocation
        Location on which the request is to change it's accessibility
    flags : cudaMemAccessFlags
        ::CUmemProt accessibility flags to set on the request

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemAccessDesc *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._location = cudaMemLocation(_ptr=<void_ptr>&self._pvt_ptr[0].location)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['location :\n' + '\n'.join(['    ' + line for line in str(self.location).splitlines()])]
            except ValueError:
                str_list += ['location : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def location(self):
        return self._location
    @location.setter
    def location(self, location not None : cudaMemLocation):
        string.memcpy(&self._pvt_ptr[0].location, <cyruntime.cudaMemLocation*><void_ptr>location.getPtr(), sizeof(self._pvt_ptr[0].location))
    @property
    def flags(self):
        if self._pvt_ptr[0].flags not in _dict_cudaMemAccessFlags:
            return None
        return _dict_cudaMemAccessFlags[self._pvt_ptr[0].flags]
    @flags.setter
    def flags(self, flags not None : cudaMemAccessFlags):
        self._pvt_ptr[0].flags = flags.value

cdef class cudaMemPoolProps:
    """
    Specifies the properties of allocations made from the pool.

    Attributes
    ----------
    allocType : cudaMemAllocationType
        Allocation type. Currently must be specified as
        cudaMemAllocationTypePinned
    handleTypes : cudaMemAllocationHandleType
        Handle types that will be supported by allocations from the pool.
    location : cudaMemLocation
        Location allocations should reside.
    win32SecurityAttributes : Any
        Windows-specific LPSECURITYATTRIBUTES required when
        cudaMemHandleTypeWin32 is specified. This security attribute
        defines the scope of which exported allocations may be tranferred
        to other processes. In all other cases, this field is required to
        be zero.
    maxSize : size_t
        Maximum pool size. When set to 0, defaults to a system dependent
        value.
    usage : unsigned short
        Bitmask indicating intended usage for the pool.
    reserved : bytes
        reserved for future use, must be 0

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemPoolProps *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._location = cudaMemLocation(_ptr=<void_ptr>&self._pvt_ptr[0].location)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['allocType : ' + str(self.allocType)]
            except ValueError:
                str_list += ['allocType : <ValueError>']
            try:
                str_list += ['handleTypes : ' + str(self.handleTypes)]
            except ValueError:
                str_list += ['handleTypes : <ValueError>']
            try:
                str_list += ['location :\n' + '\n'.join(['    ' + line for line in str(self.location).splitlines()])]
            except ValueError:
                str_list += ['location : <ValueError>']
            try:
                str_list += ['win32SecurityAttributes : ' + hex(self.win32SecurityAttributes)]
            except ValueError:
                str_list += ['win32SecurityAttributes : <ValueError>']
            try:
                str_list += ['maxSize : ' + str(self.maxSize)]
            except ValueError:
                str_list += ['maxSize : <ValueError>']
            try:
                str_list += ['usage : ' + str(self.usage)]
            except ValueError:
                str_list += ['usage : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def allocType(self):
        if self._pvt_ptr[0].allocType not in _dict_cudaMemAllocationType:
            return None
        return _dict_cudaMemAllocationType[self._pvt_ptr[0].allocType]
    @allocType.setter
    def allocType(self, allocType not None : cudaMemAllocationType):
        self._pvt_ptr[0].allocType = allocType.value
    @property
    def handleTypes(self):
        if self._pvt_ptr[0].handleTypes not in _dict_cudaMemAllocationHandleType:
            return None
        return _dict_cudaMemAllocationHandleType[self._pvt_ptr[0].handleTypes]
    @handleTypes.setter
    def handleTypes(self, handleTypes not None : cudaMemAllocationHandleType):
        self._pvt_ptr[0].handleTypes = handleTypes.value
    @property
    def location(self):
        return self._location
    @location.setter
    def location(self, location not None : cudaMemLocation):
        string.memcpy(&self._pvt_ptr[0].location, <cyruntime.cudaMemLocation*><void_ptr>location.getPtr(), sizeof(self._pvt_ptr[0].location))
    @property
    def win32SecurityAttributes(self):
        return <void_ptr>self._pvt_ptr[0].win32SecurityAttributes
    @win32SecurityAttributes.setter
    def win32SecurityAttributes(self, win32SecurityAttributes):
        _cwin32SecurityAttributes = _HelperInputVoidPtr(win32SecurityAttributes)
        self._pvt_ptr[0].win32SecurityAttributes = <void*><void_ptr>_cwin32SecurityAttributes.cptr
    @property
    def maxSize(self):
        return self._pvt_ptr[0].maxSize
    @maxSize.setter
    def maxSize(self, size_t maxSize):
        self._pvt_ptr[0].maxSize = maxSize
    @property
    def usage(self):
        return self._pvt_ptr[0].usage
    @usage.setter
    def usage(self, unsigned short usage):
        self._pvt_ptr[0].usage = usage
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0].reserved, 54)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 54:
            raise ValueError("reserved length must be 54, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            self._pvt_ptr[0].reserved[i] = b

cdef class cudaMemPoolPtrExportData:
    """
    Opaque data for exporting a pool allocation

    Attributes
    ----------
    reserved : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemPoolPtrExportData *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0].reserved, 64)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 64:
            raise ValueError("reserved length must be 64, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            self._pvt_ptr[0].reserved[i] = b

cdef class cudaMemAllocNodeParams:
    """
    Memory allocation node parameters

    Attributes
    ----------
    poolProps : cudaMemPoolProps
        in: location where the allocation should reside (specified in
        ::location). ::handleTypes must be cudaMemHandleTypeNone. IPC is
        not supported. in: array of memory access descriptors. Used to
        describe peer GPU access
    accessDescs : cudaMemAccessDesc
        in: number of memory access descriptors. Must not exceed the number
        of GPUs.
    accessDescCount : size_t
        in: Number of `accessDescs`s
    bytesize : size_t
        in: size in bytes of the requested allocation
    dptr : Any
        out: address of the allocation returned by CUDA

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemAllocNodeParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._poolProps = cudaMemPoolProps(_ptr=<void_ptr>&self._pvt_ptr[0].poolProps)
    def __dealloc__(self):
        pass
        if self._accessDescs is not NULL:
            free(self._accessDescs)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['poolProps :\n' + '\n'.join(['    ' + line for line in str(self.poolProps).splitlines()])]
            except ValueError:
                str_list += ['poolProps : <ValueError>']
            try:
                str_list += ['accessDescs : ' + str(self.accessDescs)]
            except ValueError:
                str_list += ['accessDescs : <ValueError>']
            try:
                str_list += ['accessDescCount : ' + str(self.accessDescCount)]
            except ValueError:
                str_list += ['accessDescCount : <ValueError>']
            try:
                str_list += ['bytesize : ' + str(self.bytesize)]
            except ValueError:
                str_list += ['bytesize : <ValueError>']
            try:
                str_list += ['dptr : ' + hex(self.dptr)]
            except ValueError:
                str_list += ['dptr : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def poolProps(self):
        return self._poolProps
    @poolProps.setter
    def poolProps(self, poolProps not None : cudaMemPoolProps):
        string.memcpy(&self._pvt_ptr[0].poolProps, <cyruntime.cudaMemPoolProps*><void_ptr>poolProps.getPtr(), sizeof(self._pvt_ptr[0].poolProps))
    @property
    def accessDescs(self):
        arrs = [<void_ptr>self._pvt_ptr[0].accessDescs + x*sizeof(cyruntime.cudaMemAccessDesc) for x in range(self._accessDescs_length)]
        return [cudaMemAccessDesc(_ptr=arr) for arr in arrs]
    @accessDescs.setter
    def accessDescs(self, val):
        if len(val) == 0:
            free(self._accessDescs)
            self._accessDescs_length = 0
            self._pvt_ptr[0].accessDescs = NULL
        else:
            if self._accessDescs_length != <size_t>len(val):
                free(self._accessDescs)
                self._accessDescs = <cyruntime.cudaMemAccessDesc*> calloc(len(val), sizeof(cyruntime.cudaMemAccessDesc))
                if self._accessDescs is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cyruntime.cudaMemAccessDesc)))
                self._accessDescs_length = <size_t>len(val)
                self._pvt_ptr[0].accessDescs = self._accessDescs
            for idx in range(len(val)):
                string.memcpy(&self._accessDescs[idx], (<cudaMemAccessDesc>val[idx])._pvt_ptr, sizeof(cyruntime.cudaMemAccessDesc))

    @property
    def accessDescCount(self):
        return self._pvt_ptr[0].accessDescCount
    @accessDescCount.setter
    def accessDescCount(self, size_t accessDescCount):
        self._pvt_ptr[0].accessDescCount = accessDescCount
    @property
    def bytesize(self):
        return self._pvt_ptr[0].bytesize
    @bytesize.setter
    def bytesize(self, size_t bytesize):
        self._pvt_ptr[0].bytesize = bytesize
    @property
    def dptr(self):
        return <void_ptr>self._pvt_ptr[0].dptr
    @dptr.setter
    def dptr(self, dptr):
        _cdptr = _HelperInputVoidPtr(dptr)
        self._pvt_ptr[0].dptr = <void*><void_ptr>_cdptr.cptr

cdef class cudaMemAllocNodeParamsV2:
    """
    Memory allocation node parameters

    Attributes
    ----------
    poolProps : cudaMemPoolProps
        in: location where the allocation should reside (specified in
        ::location). ::handleTypes must be cudaMemHandleTypeNone. IPC is
        not supported. in: array of memory access descriptors. Used to
        describe peer GPU access
    accessDescs : cudaMemAccessDesc
        in: number of memory access descriptors. Must not exceed the number
        of GPUs.
    accessDescCount : size_t
        in: Number of `accessDescs`s
    bytesize : size_t
        in: size in bytes of the requested allocation
    dptr : Any
        out: address of the allocation returned by CUDA

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemAllocNodeParamsV2 *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._poolProps = cudaMemPoolProps(_ptr=<void_ptr>&self._pvt_ptr[0].poolProps)
    def __dealloc__(self):
        pass
        if self._accessDescs is not NULL:
            free(self._accessDescs)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['poolProps :\n' + '\n'.join(['    ' + line for line in str(self.poolProps).splitlines()])]
            except ValueError:
                str_list += ['poolProps : <ValueError>']
            try:
                str_list += ['accessDescs : ' + str(self.accessDescs)]
            except ValueError:
                str_list += ['accessDescs : <ValueError>']
            try:
                str_list += ['accessDescCount : ' + str(self.accessDescCount)]
            except ValueError:
                str_list += ['accessDescCount : <ValueError>']
            try:
                str_list += ['bytesize : ' + str(self.bytesize)]
            except ValueError:
                str_list += ['bytesize : <ValueError>']
            try:
                str_list += ['dptr : ' + hex(self.dptr)]
            except ValueError:
                str_list += ['dptr : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def poolProps(self):
        return self._poolProps
    @poolProps.setter
    def poolProps(self, poolProps not None : cudaMemPoolProps):
        string.memcpy(&self._pvt_ptr[0].poolProps, <cyruntime.cudaMemPoolProps*><void_ptr>poolProps.getPtr(), sizeof(self._pvt_ptr[0].poolProps))
    @property
    def accessDescs(self):
        arrs = [<void_ptr>self._pvt_ptr[0].accessDescs + x*sizeof(cyruntime.cudaMemAccessDesc) for x in range(self._accessDescs_length)]
        return [cudaMemAccessDesc(_ptr=arr) for arr in arrs]
    @accessDescs.setter
    def accessDescs(self, val):
        if len(val) == 0:
            free(self._accessDescs)
            self._accessDescs_length = 0
            self._pvt_ptr[0].accessDescs = NULL
        else:
            if self._accessDescs_length != <size_t>len(val):
                free(self._accessDescs)
                self._accessDescs = <cyruntime.cudaMemAccessDesc*> calloc(len(val), sizeof(cyruntime.cudaMemAccessDesc))
                if self._accessDescs is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cyruntime.cudaMemAccessDesc)))
                self._accessDescs_length = <size_t>len(val)
                self._pvt_ptr[0].accessDescs = self._accessDescs
            for idx in range(len(val)):
                string.memcpy(&self._accessDescs[idx], (<cudaMemAccessDesc>val[idx])._pvt_ptr, sizeof(cyruntime.cudaMemAccessDesc))

    @property
    def accessDescCount(self):
        return self._pvt_ptr[0].accessDescCount
    @accessDescCount.setter
    def accessDescCount(self, size_t accessDescCount):
        self._pvt_ptr[0].accessDescCount = accessDescCount
    @property
    def bytesize(self):
        return self._pvt_ptr[0].bytesize
    @bytesize.setter
    def bytesize(self, size_t bytesize):
        self._pvt_ptr[0].bytesize = bytesize
    @property
    def dptr(self):
        return <void_ptr>self._pvt_ptr[0].dptr
    @dptr.setter
    def dptr(self, dptr):
        _cdptr = _HelperInputVoidPtr(dptr)
        self._pvt_ptr[0].dptr = <void*><void_ptr>_cdptr.cptr

cdef class cudaMemFreeNodeParams:
    """
    Memory free node parameters

    Attributes
    ----------
    dptr : Any
        in: the pointer to free

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemFreeNodeParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['dptr : ' + hex(self.dptr)]
            except ValueError:
                str_list += ['dptr : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def dptr(self):
        return <void_ptr>self._pvt_ptr[0].dptr
    @dptr.setter
    def dptr(self, dptr):
        _cdptr = _HelperInputVoidPtr(dptr)
        self._pvt_ptr[0].dptr = <void*><void_ptr>_cdptr.cptr

cdef class cudaMemcpyAttributes:
    """
    Attributes specific to copies within a batch. For more details on
    usage see cudaMemcpyBatchAsync.

    Attributes
    ----------
    srcAccessOrder : cudaMemcpySrcAccessOrder
        Source access ordering to be observed for copies with this
        attribute.
    srcLocHint : cudaMemLocation
        Hint location for the source operand. Ignored when the pointers are
        not managed memory or memory allocated outside CUDA.
    dstLocHint : cudaMemLocation
        Hint location for the destination operand. Ignored when the
        pointers are not managed memory or memory allocated outside CUDA.
    flags : unsigned int
        Additional flags for copies with this attribute. See
        cudaMemcpyFlags.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemcpyAttributes *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._srcLocHint = cudaMemLocation(_ptr=<void_ptr>&self._pvt_ptr[0].srcLocHint)
        self._dstLocHint = cudaMemLocation(_ptr=<void_ptr>&self._pvt_ptr[0].dstLocHint)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['srcAccessOrder : ' + str(self.srcAccessOrder)]
            except ValueError:
                str_list += ['srcAccessOrder : <ValueError>']
            try:
                str_list += ['srcLocHint :\n' + '\n'.join(['    ' + line for line in str(self.srcLocHint).splitlines()])]
            except ValueError:
                str_list += ['srcLocHint : <ValueError>']
            try:
                str_list += ['dstLocHint :\n' + '\n'.join(['    ' + line for line in str(self.dstLocHint).splitlines()])]
            except ValueError:
                str_list += ['dstLocHint : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def srcAccessOrder(self):
        if self._pvt_ptr[0].srcAccessOrder not in _dict_cudaMemcpySrcAccessOrder:
            return None
        return _dict_cudaMemcpySrcAccessOrder[self._pvt_ptr[0].srcAccessOrder]
    @srcAccessOrder.setter
    def srcAccessOrder(self, srcAccessOrder not None : cudaMemcpySrcAccessOrder):
        self._pvt_ptr[0].srcAccessOrder = srcAccessOrder.value
    @property
    def srcLocHint(self):
        return self._srcLocHint
    @srcLocHint.setter
    def srcLocHint(self, srcLocHint not None : cudaMemLocation):
        string.memcpy(&self._pvt_ptr[0].srcLocHint, <cyruntime.cudaMemLocation*><void_ptr>srcLocHint.getPtr(), sizeof(self._pvt_ptr[0].srcLocHint))
    @property
    def dstLocHint(self):
        return self._dstLocHint
    @dstLocHint.setter
    def dstLocHint(self, dstLocHint not None : cudaMemLocation):
        string.memcpy(&self._pvt_ptr[0].dstLocHint, <cyruntime.cudaMemLocation*><void_ptr>dstLocHint.getPtr(), sizeof(self._pvt_ptr[0].dstLocHint))
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags

cdef class cudaOffset3D:
    """
    Struct representing offset into a cudaArray_t in elements

    Attributes
    ----------
    x : size_t

    y : size_t

    z : size_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaOffset3D *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['x : ' + str(self.x)]
            except ValueError:
                str_list += ['x : <ValueError>']
            try:
                str_list += ['y : ' + str(self.y)]
            except ValueError:
                str_list += ['y : <ValueError>']
            try:
                str_list += ['z : ' + str(self.z)]
            except ValueError:
                str_list += ['z : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def x(self):
        return self._pvt_ptr[0].x
    @x.setter
    def x(self, size_t x):
        self._pvt_ptr[0].x = x
    @property
    def y(self):
        return self._pvt_ptr[0].y
    @y.setter
    def y(self, size_t y):
        self._pvt_ptr[0].y = y
    @property
    def z(self):
        return self._pvt_ptr[0].z
    @z.setter
    def z(self, size_t z):
        self._pvt_ptr[0].z = z

cdef class anon_struct6:
    """
    Attributes
    ----------
    ptr : Any

    rowLength : size_t

    layerHeight : size_t

    locHint : cudaMemLocation


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaMemcpy3DOperand *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._locHint = cudaMemLocation(_ptr=<void_ptr>&self._pvt_ptr[0].op.ptr.locHint)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].op.ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['ptr : ' + hex(self.ptr)]
            except ValueError:
                str_list += ['ptr : <ValueError>']
            try:
                str_list += ['rowLength : ' + str(self.rowLength)]
            except ValueError:
                str_list += ['rowLength : <ValueError>']
            try:
                str_list += ['layerHeight : ' + str(self.layerHeight)]
            except ValueError:
                str_list += ['layerHeight : <ValueError>']
            try:
                str_list += ['locHint :\n' + '\n'.join(['    ' + line for line in str(self.locHint).splitlines()])]
            except ValueError:
                str_list += ['locHint : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def ptr(self):
        return <void_ptr>self._pvt_ptr[0].op.ptr.ptr
    @ptr.setter
    def ptr(self, ptr):
        _cptr = _HelperInputVoidPtr(ptr)
        self._pvt_ptr[0].op.ptr.ptr = <void*><void_ptr>_cptr.cptr
    @property
    def rowLength(self):
        return self._pvt_ptr[0].op.ptr.rowLength
    @rowLength.setter
    def rowLength(self, size_t rowLength):
        self._pvt_ptr[0].op.ptr.rowLength = rowLength
    @property
    def layerHeight(self):
        return self._pvt_ptr[0].op.ptr.layerHeight
    @layerHeight.setter
    def layerHeight(self, size_t layerHeight):
        self._pvt_ptr[0].op.ptr.layerHeight = layerHeight
    @property
    def locHint(self):
        return self._locHint
    @locHint.setter
    def locHint(self, locHint not None : cudaMemLocation):
        string.memcpy(&self._pvt_ptr[0].op.ptr.locHint, <cyruntime.cudaMemLocation*><void_ptr>locHint.getPtr(), sizeof(self._pvt_ptr[0].op.ptr.locHint))

cdef class anon_struct7:
    """
    Attributes
    ----------
    array : cudaArray_t

    offset : cudaOffset3D


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaMemcpy3DOperand *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._array = cudaArray_t(_ptr=<void_ptr>&self._pvt_ptr[0].op.array.array)
        self._offset = cudaOffset3D(_ptr=<void_ptr>&self._pvt_ptr[0].op.array.offset)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].op.array
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['array : ' + str(self.array)]
            except ValueError:
                str_list += ['array : <ValueError>']
            try:
                str_list += ['offset :\n' + '\n'.join(['    ' + line for line in str(self.offset).splitlines()])]
            except ValueError:
                str_list += ['offset : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def array(self):
        return self._array
    @array.setter
    def array(self, array):
        cdef cyruntime.cudaArray_t cyarray
        if array is None:
            cyarray = <cyruntime.cudaArray_t><void_ptr>0
        elif isinstance(array, (cudaArray_t,)):
            parray = int(array)
            cyarray = <cyruntime.cudaArray_t><void_ptr>parray
        else:
            parray = int(cudaArray_t(array))
            cyarray = <cyruntime.cudaArray_t><void_ptr>parray
        self._array._pvt_ptr[0] = cyarray
    @property
    def offset(self):
        return self._offset
    @offset.setter
    def offset(self, offset not None : cudaOffset3D):
        string.memcpy(&self._pvt_ptr[0].op.array.offset, <cyruntime.cudaOffset3D*><void_ptr>offset.getPtr(), sizeof(self._pvt_ptr[0].op.array.offset))

cdef class anon_union1:
    """
    Attributes
    ----------
    ptr : anon_struct6

    array : anon_struct7


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaMemcpy3DOperand *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._ptr = anon_struct6(_ptr=<void_ptr>self._pvt_ptr)
        self._array = anon_struct7(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].op
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['ptr :\n' + '\n'.join(['    ' + line for line in str(self.ptr).splitlines()])]
            except ValueError:
                str_list += ['ptr : <ValueError>']
            try:
                str_list += ['array :\n' + '\n'.join(['    ' + line for line in str(self.array).splitlines()])]
            except ValueError:
                str_list += ['array : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def ptr(self):
        return self._ptr
    @ptr.setter
    def ptr(self, ptr not None : anon_struct6):
        string.memcpy(&self._pvt_ptr[0].op.ptr, <cyruntime.anon_struct6*><void_ptr>ptr.getPtr(), sizeof(self._pvt_ptr[0].op.ptr))
    @property
    def array(self):
        return self._array
    @array.setter
    def array(self, array not None : anon_struct7):
        string.memcpy(&self._pvt_ptr[0].op.array, <cyruntime.anon_struct7*><void_ptr>array.getPtr(), sizeof(self._pvt_ptr[0].op.array))

cdef class cudaMemcpy3DOperand:
    """
    Struct representing an operand for copy with cudaMemcpy3DBatchAsync

    Attributes
    ----------
    type : cudaMemcpy3DOperandType

    op : anon_union1


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cyruntime.cudaMemcpy3DOperand *>calloc(1, sizeof(cyruntime.cudaMemcpy3DOperand))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cyruntime.cudaMemcpy3DOperand *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._op = anon_union1(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['op :\n' + '\n'.join(['    ' + line for line in str(self.op).splitlines()])]
            except ValueError:
                str_list += ['op : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_cudaMemcpy3DOperandType:
            return None
        return _dict_cudaMemcpy3DOperandType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : cudaMemcpy3DOperandType):
        self._pvt_ptr[0].type = type.value
    @property
    def op(self):
        return self._op
    @op.setter
    def op(self, op not None : anon_union1):
        string.memcpy(&self._pvt_ptr[0].op, <cyruntime.anon_union1*><void_ptr>op.getPtr(), sizeof(self._pvt_ptr[0].op))

cdef class cudaMemcpy3DBatchOp:
    """
    Attributes
    ----------
    src : cudaMemcpy3DOperand
        Source memcpy operand.
    dst : cudaMemcpy3DOperand
        Destination memcpy operand.
    extent : cudaExtent
        Extents of the memcpy between src and dst. The width, height and
        depth components must not be 0.
    srcAccessOrder : cudaMemcpySrcAccessOrder
        Source access ordering to be observed for copy from src to dst.
    flags : unsigned int
        Additional flags for copy from src to dst. See cudaMemcpyFlags.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemcpy3DBatchOp *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._src = cudaMemcpy3DOperand(_ptr=<void_ptr>&self._pvt_ptr[0].src)
        self._dst = cudaMemcpy3DOperand(_ptr=<void_ptr>&self._pvt_ptr[0].dst)
        self._extent = cudaExtent(_ptr=<void_ptr>&self._pvt_ptr[0].extent)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['src :\n' + '\n'.join(['    ' + line for line in str(self.src).splitlines()])]
            except ValueError:
                str_list += ['src : <ValueError>']
            try:
                str_list += ['dst :\n' + '\n'.join(['    ' + line for line in str(self.dst).splitlines()])]
            except ValueError:
                str_list += ['dst : <ValueError>']
            try:
                str_list += ['extent :\n' + '\n'.join(['    ' + line for line in str(self.extent).splitlines()])]
            except ValueError:
                str_list += ['extent : <ValueError>']
            try:
                str_list += ['srcAccessOrder : ' + str(self.srcAccessOrder)]
            except ValueError:
                str_list += ['srcAccessOrder : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def src(self):
        return self._src
    @src.setter
    def src(self, src not None : cudaMemcpy3DOperand):
        string.memcpy(&self._pvt_ptr[0].src, <cyruntime.cudaMemcpy3DOperand*><void_ptr>src.getPtr(), sizeof(self._pvt_ptr[0].src))
    @property
    def dst(self):
        return self._dst
    @dst.setter
    def dst(self, dst not None : cudaMemcpy3DOperand):
        string.memcpy(&self._pvt_ptr[0].dst, <cyruntime.cudaMemcpy3DOperand*><void_ptr>dst.getPtr(), sizeof(self._pvt_ptr[0].dst))
    @property
    def extent(self):
        return self._extent
    @extent.setter
    def extent(self, extent not None : cudaExtent):
        string.memcpy(&self._pvt_ptr[0].extent, <cyruntime.cudaExtent*><void_ptr>extent.getPtr(), sizeof(self._pvt_ptr[0].extent))
    @property
    def srcAccessOrder(self):
        if self._pvt_ptr[0].srcAccessOrder not in _dict_cudaMemcpySrcAccessOrder:
            return None
        return _dict_cudaMemcpySrcAccessOrder[self._pvt_ptr[0].srcAccessOrder]
    @srcAccessOrder.setter
    def srcAccessOrder(self, srcAccessOrder not None : cudaMemcpySrcAccessOrder):
        self._pvt_ptr[0].srcAccessOrder = srcAccessOrder.value
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags

cdef class CUuuid_st:
    """
    Attributes
    ----------
    bytes : bytes
        < CUDA definition of UUID

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.CUuuid_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['bytes : ' + str(self.bytes.hex())]
            except ValueError:
                str_list += ['bytes : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def bytes(self):
        return PyBytes_FromStringAndSize(self._pvt_ptr[0].bytes, 16)

cdef class cudaDeviceProp:
    """
    CUDA device properties

    Attributes
    ----------
    name : bytes
        ASCII string identifying device
    uuid : cudaUUID_t
        16-byte unique identifier
    luid : bytes
        8-byte locally unique identifier. Value is undefined on TCC and
        non-Windows platforms
    luidDeviceNodeMask : unsigned int
        LUID device node mask. Value is undefined on TCC and non-Windows
        platforms
    totalGlobalMem : size_t
        Global memory available on device in bytes
    sharedMemPerBlock : size_t
        Shared memory available per block in bytes
    regsPerBlock : int
        32-bit registers available per block
    warpSize : int
        Warp size in threads
    memPitch : size_t
        Maximum pitch in bytes allowed by memory copies
    maxThreadsPerBlock : int
        Maximum number of threads per block
    maxThreadsDim : list[int]
        Maximum size of each dimension of a block
    maxGridSize : list[int]
        Maximum size of each dimension of a grid
    totalConstMem : size_t
        Constant memory available on device in bytes
    major : int
        Major compute capability
    minor : int
        Minor compute capability
    textureAlignment : size_t
        Alignment requirement for textures
    texturePitchAlignment : size_t
        Pitch alignment requirement for texture references bound to pitched
        memory
    multiProcessorCount : int
        Number of multiprocessors on device
    integrated : int
        Device is integrated as opposed to discrete
    canMapHostMemory : int
        Device can map host memory with
        cudaHostAlloc/cudaHostGetDevicePointer
    maxTexture1D : int
        Maximum 1D texture size
    maxTexture1DMipmap : int
        Maximum 1D mipmapped texture size
    maxTexture2D : list[int]
        Maximum 2D texture dimensions
    maxTexture2DMipmap : list[int]
        Maximum 2D mipmapped texture dimensions
    maxTexture2DLinear : list[int]
        Maximum dimensions (width, height, pitch) for 2D textures bound to
        pitched memory
    maxTexture2DGather : list[int]
        Maximum 2D texture dimensions if texture gather operations have to
        be performed
    maxTexture3D : list[int]
        Maximum 3D texture dimensions
    maxTexture3DAlt : list[int]
        Maximum alternate 3D texture dimensions
    maxTextureCubemap : int
        Maximum Cubemap texture dimensions
    maxTexture1DLayered : list[int]
        Maximum 1D layered texture dimensions
    maxTexture2DLayered : list[int]
        Maximum 2D layered texture dimensions
    maxTextureCubemapLayered : list[int]
        Maximum Cubemap layered texture dimensions
    maxSurface1D : int
        Maximum 1D surface size
    maxSurface2D : list[int]
        Maximum 2D surface dimensions
    maxSurface3D : list[int]
        Maximum 3D surface dimensions
    maxSurface1DLayered : list[int]
        Maximum 1D layered surface dimensions
    maxSurface2DLayered : list[int]
        Maximum 2D layered surface dimensions
    maxSurfaceCubemap : int
        Maximum Cubemap surface dimensions
    maxSurfaceCubemapLayered : list[int]
        Maximum Cubemap layered surface dimensions
    surfaceAlignment : size_t
        Alignment requirements for surfaces
    concurrentKernels : int
        Device can possibly execute multiple kernels concurrently
    ECCEnabled : int
        Device has ECC support enabled
    pciBusID : int
        PCI bus ID of the device
    pciDeviceID : int
        PCI device ID of the device
    pciDomainID : int
        PCI domain ID of the device
    tccDriver : int
        1 if device is a Tesla device using TCC driver, 0 otherwise
    asyncEngineCount : int
        Number of asynchronous engines
    unifiedAddressing : int
        Device shares a unified address space with the host
    memoryBusWidth : int
        Global memory bus width in bits
    l2CacheSize : int
        Size of L2 cache in bytes
    persistingL2CacheMaxSize : int
        Device's maximum l2 persisting lines capacity setting in bytes
    maxThreadsPerMultiProcessor : int
        Maximum resident threads per multiprocessor
    streamPrioritiesSupported : int
        Device supports stream priorities
    globalL1CacheSupported : int
        Device supports caching globals in L1
    localL1CacheSupported : int
        Device supports caching locals in L1
    sharedMemPerMultiprocessor : size_t
        Shared memory available per multiprocessor in bytes
    regsPerMultiprocessor : int
        32-bit registers available per multiprocessor
    managedMemory : int
        Device supports allocating managed memory on this system
    isMultiGpuBoard : int
        Device is on a multi-GPU board
    multiGpuBoardGroupID : int
        Unique identifier for a group of devices on the same multi-GPU
        board
    hostNativeAtomicSupported : int
        Link between the device and the host supports native atomic
        operations
    pageableMemoryAccess : int
        Device supports coherently accessing pageable memory without
        calling cudaHostRegister on it
    concurrentManagedAccess : int
        Device can coherently access managed memory concurrently with the
        CPU
    computePreemptionSupported : int
        Device supports Compute Preemption
    canUseHostPointerForRegisteredMem : int
        Device can access host registered memory at the same virtual
        address as the CPU
    cooperativeLaunch : int
        Device supports launching cooperative kernels via
        cudaLaunchCooperativeKernel
    sharedMemPerBlockOptin : size_t
        Per device maximum shared memory per block usable by special opt in
    pageableMemoryAccessUsesHostPageTables : int
        Device accesses pageable memory via the host's page tables
    directManagedMemAccessFromHost : int
        Host can directly access managed memory on the device without
        migration.
    maxBlocksPerMultiProcessor : int
        Maximum number of resident blocks per multiprocessor
    accessPolicyMaxWindowSize : int
        The maximum value of cudaAccessPolicyWindow::num_bytes.
    reservedSharedMemPerBlock : size_t
        Shared memory reserved by CUDA driver per block in bytes
    hostRegisterSupported : int
        Device supports host memory registration via cudaHostRegister.
    sparseCudaArraySupported : int
        1 if the device supports sparse CUDA arrays and sparse CUDA
        mipmapped arrays, 0 otherwise
    hostRegisterReadOnlySupported : int
        Device supports using the cudaHostRegister flag
        cudaHostRegisterReadOnly to register memory that must be mapped as
        read-only to the GPU
    timelineSemaphoreInteropSupported : int
        External timeline semaphore interop is supported on the device
    memoryPoolsSupported : int
        1 if the device supports using the cudaMallocAsync and cudaMemPool
        family of APIs, 0 otherwise
    gpuDirectRDMASupported : int
        1 if the device supports GPUDirect RDMA APIs, 0 otherwise
    gpuDirectRDMAFlushWritesOptions : unsigned int
        Bitmask to be interpreted according to the
        cudaFlushGPUDirectRDMAWritesOptions enum
    gpuDirectRDMAWritesOrdering : int
        See the cudaGPUDirectRDMAWritesOrdering enum for numerical values
    memoryPoolSupportedHandleTypes : unsigned int
        Bitmask of handle types supported with mempool-based IPC
    deferredMappingCudaArraySupported : int
        1 if the device supports deferred mapping CUDA arrays and CUDA
        mipmapped arrays
    ipcEventSupported : int
        Device supports IPC Events.
    clusterLaunch : int
        Indicates device supports cluster launch
    unifiedFunctionPointers : int
        Indicates device supports unified pointers
    deviceNumaConfig : int
        NUMA configuration of a device: value is of type
        cudaDeviceNumaConfig enum
    deviceNumaId : int
        NUMA node ID of the GPU memory
    mpsEnabled : int
        Indicates if contexts created on this device will be shared via MPS
    hostNumaId : int
        NUMA ID of the host node closest to the device or -1 when system
        does not support NUMA
    gpuPciDeviceID : unsigned int
        The combined 16-bit PCI device ID and 16-bit PCI vendor ID
    gpuPciSubsystemID : unsigned int
        The combined 16-bit PCI subsystem ID and 16-bit PCI subsystem
        vendor ID
    hostNumaMultinodeIpcSupported : int
        1 if the device supports HostNuma location IPC between nodes in a
        multi-node system.
    reserved : list[int]
        Reserved for future use

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaDeviceProp *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._uuid = cudaUUID_t(_ptr=<void_ptr>&self._pvt_ptr[0].uuid)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['name : ' + self.name.decode('utf-8')]
            except ValueError:
                str_list += ['name : <ValueError>']
            try:
                str_list += ['uuid :\n' + '\n'.join(['    ' + line for line in str(self.uuid).splitlines()])]
            except ValueError:
                str_list += ['uuid : <ValueError>']
            try:
                str_list += ['luid : ' + self.luid.hex()]
            except ValueError:
                str_list += ['luid : <ValueError>']
            try:
                str_list += ['luidDeviceNodeMask : ' + str(self.luidDeviceNodeMask)]
            except ValueError:
                str_list += ['luidDeviceNodeMask : <ValueError>']
            try:
                str_list += ['totalGlobalMem : ' + str(self.totalGlobalMem)]
            except ValueError:
                str_list += ['totalGlobalMem : <ValueError>']
            try:
                str_list += ['sharedMemPerBlock : ' + str(self.sharedMemPerBlock)]
            except ValueError:
                str_list += ['sharedMemPerBlock : <ValueError>']
            try:
                str_list += ['regsPerBlock : ' + str(self.regsPerBlock)]
            except ValueError:
                str_list += ['regsPerBlock : <ValueError>']
            try:
                str_list += ['warpSize : ' + str(self.warpSize)]
            except ValueError:
                str_list += ['warpSize : <ValueError>']
            try:
                str_list += ['memPitch : ' + str(self.memPitch)]
            except ValueError:
                str_list += ['memPitch : <ValueError>']
            try:
                str_list += ['maxThreadsPerBlock : ' + str(self.maxThreadsPerBlock)]
            except ValueError:
                str_list += ['maxThreadsPerBlock : <ValueError>']
            try:
                str_list += ['maxThreadsDim : ' + str(self.maxThreadsDim)]
            except ValueError:
                str_list += ['maxThreadsDim : <ValueError>']
            try:
                str_list += ['maxGridSize : ' + str(self.maxGridSize)]
            except ValueError:
                str_list += ['maxGridSize : <ValueError>']
            try:
                str_list += ['totalConstMem : ' + str(self.totalConstMem)]
            except ValueError:
                str_list += ['totalConstMem : <ValueError>']
            try:
                str_list += ['major : ' + str(self.major)]
            except ValueError:
                str_list += ['major : <ValueError>']
            try:
                str_list += ['minor : ' + str(self.minor)]
            except ValueError:
                str_list += ['minor : <ValueError>']
            try:
                str_list += ['textureAlignment : ' + str(self.textureAlignment)]
            except ValueError:
                str_list += ['textureAlignment : <ValueError>']
            try:
                str_list += ['texturePitchAlignment : ' + str(self.texturePitchAlignment)]
            except ValueError:
                str_list += ['texturePitchAlignment : <ValueError>']
            try:
                str_list += ['multiProcessorCount : ' + str(self.multiProcessorCount)]
            except ValueError:
                str_list += ['multiProcessorCount : <ValueError>']
            try:
                str_list += ['integrated : ' + str(self.integrated)]
            except ValueError:
                str_list += ['integrated : <ValueError>']
            try:
                str_list += ['canMapHostMemory : ' + str(self.canMapHostMemory)]
            except ValueError:
                str_list += ['canMapHostMemory : <ValueError>']
            try:
                str_list += ['maxTexture1D : ' + str(self.maxTexture1D)]
            except ValueError:
                str_list += ['maxTexture1D : <ValueError>']
            try:
                str_list += ['maxTexture1DMipmap : ' + str(self.maxTexture1DMipmap)]
            except ValueError:
                str_list += ['maxTexture1DMipmap : <ValueError>']
            try:
                str_list += ['maxTexture2D : ' + str(self.maxTexture2D)]
            except ValueError:
                str_list += ['maxTexture2D : <ValueError>']
            try:
                str_list += ['maxTexture2DMipmap : ' + str(self.maxTexture2DMipmap)]
            except ValueError:
                str_list += ['maxTexture2DMipmap : <ValueError>']
            try:
                str_list += ['maxTexture2DLinear : ' + str(self.maxTexture2DLinear)]
            except ValueError:
                str_list += ['maxTexture2DLinear : <ValueError>']
            try:
                str_list += ['maxTexture2DGather : ' + str(self.maxTexture2DGather)]
            except ValueError:
                str_list += ['maxTexture2DGather : <ValueError>']
            try:
                str_list += ['maxTexture3D : ' + str(self.maxTexture3D)]
            except ValueError:
                str_list += ['maxTexture3D : <ValueError>']
            try:
                str_list += ['maxTexture3DAlt : ' + str(self.maxTexture3DAlt)]
            except ValueError:
                str_list += ['maxTexture3DAlt : <ValueError>']
            try:
                str_list += ['maxTextureCubemap : ' + str(self.maxTextureCubemap)]
            except ValueError:
                str_list += ['maxTextureCubemap : <ValueError>']
            try:
                str_list += ['maxTexture1DLayered : ' + str(self.maxTexture1DLayered)]
            except ValueError:
                str_list += ['maxTexture1DLayered : <ValueError>']
            try:
                str_list += ['maxTexture2DLayered : ' + str(self.maxTexture2DLayered)]
            except ValueError:
                str_list += ['maxTexture2DLayered : <ValueError>']
            try:
                str_list += ['maxTextureCubemapLayered : ' + str(self.maxTextureCubemapLayered)]
            except ValueError:
                str_list += ['maxTextureCubemapLayered : <ValueError>']
            try:
                str_list += ['maxSurface1D : ' + str(self.maxSurface1D)]
            except ValueError:
                str_list += ['maxSurface1D : <ValueError>']
            try:
                str_list += ['maxSurface2D : ' + str(self.maxSurface2D)]
            except ValueError:
                str_list += ['maxSurface2D : <ValueError>']
            try:
                str_list += ['maxSurface3D : ' + str(self.maxSurface3D)]
            except ValueError:
                str_list += ['maxSurface3D : <ValueError>']
            try:
                str_list += ['maxSurface1DLayered : ' + str(self.maxSurface1DLayered)]
            except ValueError:
                str_list += ['maxSurface1DLayered : <ValueError>']
            try:
                str_list += ['maxSurface2DLayered : ' + str(self.maxSurface2DLayered)]
            except ValueError:
                str_list += ['maxSurface2DLayered : <ValueError>']
            try:
                str_list += ['maxSurfaceCubemap : ' + str(self.maxSurfaceCubemap)]
            except ValueError:
                str_list += ['maxSurfaceCubemap : <ValueError>']
            try:
                str_list += ['maxSurfaceCubemapLayered : ' + str(self.maxSurfaceCubemapLayered)]
            except ValueError:
                str_list += ['maxSurfaceCubemapLayered : <ValueError>']
            try:
                str_list += ['surfaceAlignment : ' + str(self.surfaceAlignment)]
            except ValueError:
                str_list += ['surfaceAlignment : <ValueError>']
            try:
                str_list += ['concurrentKernels : ' + str(self.concurrentKernels)]
            except ValueError:
                str_list += ['concurrentKernels : <ValueError>']
            try:
                str_list += ['ECCEnabled : ' + str(self.ECCEnabled)]
            except ValueError:
                str_list += ['ECCEnabled : <ValueError>']
            try:
                str_list += ['pciBusID : ' + str(self.pciBusID)]
            except ValueError:
                str_list += ['pciBusID : <ValueError>']
            try:
                str_list += ['pciDeviceID : ' + str(self.pciDeviceID)]
            except ValueError:
                str_list += ['pciDeviceID : <ValueError>']
            try:
                str_list += ['pciDomainID : ' + str(self.pciDomainID)]
            except ValueError:
                str_list += ['pciDomainID : <ValueError>']
            try:
                str_list += ['tccDriver : ' + str(self.tccDriver)]
            except ValueError:
                str_list += ['tccDriver : <ValueError>']
            try:
                str_list += ['asyncEngineCount : ' + str(self.asyncEngineCount)]
            except ValueError:
                str_list += ['asyncEngineCount : <ValueError>']
            try:
                str_list += ['unifiedAddressing : ' + str(self.unifiedAddressing)]
            except ValueError:
                str_list += ['unifiedAddressing : <ValueError>']
            try:
                str_list += ['memoryBusWidth : ' + str(self.memoryBusWidth)]
            except ValueError:
                str_list += ['memoryBusWidth : <ValueError>']
            try:
                str_list += ['l2CacheSize : ' + str(self.l2CacheSize)]
            except ValueError:
                str_list += ['l2CacheSize : <ValueError>']
            try:
                str_list += ['persistingL2CacheMaxSize : ' + str(self.persistingL2CacheMaxSize)]
            except ValueError:
                str_list += ['persistingL2CacheMaxSize : <ValueError>']
            try:
                str_list += ['maxThreadsPerMultiProcessor : ' + str(self.maxThreadsPerMultiProcessor)]
            except ValueError:
                str_list += ['maxThreadsPerMultiProcessor : <ValueError>']
            try:
                str_list += ['streamPrioritiesSupported : ' + str(self.streamPrioritiesSupported)]
            except ValueError:
                str_list += ['streamPrioritiesSupported : <ValueError>']
            try:
                str_list += ['globalL1CacheSupported : ' + str(self.globalL1CacheSupported)]
            except ValueError:
                str_list += ['globalL1CacheSupported : <ValueError>']
            try:
                str_list += ['localL1CacheSupported : ' + str(self.localL1CacheSupported)]
            except ValueError:
                str_list += ['localL1CacheSupported : <ValueError>']
            try:
                str_list += ['sharedMemPerMultiprocessor : ' + str(self.sharedMemPerMultiprocessor)]
            except ValueError:
                str_list += ['sharedMemPerMultiprocessor : <ValueError>']
            try:
                str_list += ['regsPerMultiprocessor : ' + str(self.regsPerMultiprocessor)]
            except ValueError:
                str_list += ['regsPerMultiprocessor : <ValueError>']
            try:
                str_list += ['managedMemory : ' + str(self.managedMemory)]
            except ValueError:
                str_list += ['managedMemory : <ValueError>']
            try:
                str_list += ['isMultiGpuBoard : ' + str(self.isMultiGpuBoard)]
            except ValueError:
                str_list += ['isMultiGpuBoard : <ValueError>']
            try:
                str_list += ['multiGpuBoardGroupID : ' + str(self.multiGpuBoardGroupID)]
            except ValueError:
                str_list += ['multiGpuBoardGroupID : <ValueError>']
            try:
                str_list += ['hostNativeAtomicSupported : ' + str(self.hostNativeAtomicSupported)]
            except ValueError:
                str_list += ['hostNativeAtomicSupported : <ValueError>']
            try:
                str_list += ['pageableMemoryAccess : ' + str(self.pageableMemoryAccess)]
            except ValueError:
                str_list += ['pageableMemoryAccess : <ValueError>']
            try:
                str_list += ['concurrentManagedAccess : ' + str(self.concurrentManagedAccess)]
            except ValueError:
                str_list += ['concurrentManagedAccess : <ValueError>']
            try:
                str_list += ['computePreemptionSupported : ' + str(self.computePreemptionSupported)]
            except ValueError:
                str_list += ['computePreemptionSupported : <ValueError>']
            try:
                str_list += ['canUseHostPointerForRegisteredMem : ' + str(self.canUseHostPointerForRegisteredMem)]
            except ValueError:
                str_list += ['canUseHostPointerForRegisteredMem : <ValueError>']
            try:
                str_list += ['cooperativeLaunch : ' + str(self.cooperativeLaunch)]
            except ValueError:
                str_list += ['cooperativeLaunch : <ValueError>']
            try:
                str_list += ['sharedMemPerBlockOptin : ' + str(self.sharedMemPerBlockOptin)]
            except ValueError:
                str_list += ['sharedMemPerBlockOptin : <ValueError>']
            try:
                str_list += ['pageableMemoryAccessUsesHostPageTables : ' + str(self.pageableMemoryAccessUsesHostPageTables)]
            except ValueError:
                str_list += ['pageableMemoryAccessUsesHostPageTables : <ValueError>']
            try:
                str_list += ['directManagedMemAccessFromHost : ' + str(self.directManagedMemAccessFromHost)]
            except ValueError:
                str_list += ['directManagedMemAccessFromHost : <ValueError>']
            try:
                str_list += ['maxBlocksPerMultiProcessor : ' + str(self.maxBlocksPerMultiProcessor)]
            except ValueError:
                str_list += ['maxBlocksPerMultiProcessor : <ValueError>']
            try:
                str_list += ['accessPolicyMaxWindowSize : ' + str(self.accessPolicyMaxWindowSize)]
            except ValueError:
                str_list += ['accessPolicyMaxWindowSize : <ValueError>']
            try:
                str_list += ['reservedSharedMemPerBlock : ' + str(self.reservedSharedMemPerBlock)]
            except ValueError:
                str_list += ['reservedSharedMemPerBlock : <ValueError>']
            try:
                str_list += ['hostRegisterSupported : ' + str(self.hostRegisterSupported)]
            except ValueError:
                str_list += ['hostRegisterSupported : <ValueError>']
            try:
                str_list += ['sparseCudaArraySupported : ' + str(self.sparseCudaArraySupported)]
            except ValueError:
                str_list += ['sparseCudaArraySupported : <ValueError>']
            try:
                str_list += ['hostRegisterReadOnlySupported : ' + str(self.hostRegisterReadOnlySupported)]
            except ValueError:
                str_list += ['hostRegisterReadOnlySupported : <ValueError>']
            try:
                str_list += ['timelineSemaphoreInteropSupported : ' + str(self.timelineSemaphoreInteropSupported)]
            except ValueError:
                str_list += ['timelineSemaphoreInteropSupported : <ValueError>']
            try:
                str_list += ['memoryPoolsSupported : ' + str(self.memoryPoolsSupported)]
            except ValueError:
                str_list += ['memoryPoolsSupported : <ValueError>']
            try:
                str_list += ['gpuDirectRDMASupported : ' + str(self.gpuDirectRDMASupported)]
            except ValueError:
                str_list += ['gpuDirectRDMASupported : <ValueError>']
            try:
                str_list += ['gpuDirectRDMAFlushWritesOptions : ' + str(self.gpuDirectRDMAFlushWritesOptions)]
            except ValueError:
                str_list += ['gpuDirectRDMAFlushWritesOptions : <ValueError>']
            try:
                str_list += ['gpuDirectRDMAWritesOrdering : ' + str(self.gpuDirectRDMAWritesOrdering)]
            except ValueError:
                str_list += ['gpuDirectRDMAWritesOrdering : <ValueError>']
            try:
                str_list += ['memoryPoolSupportedHandleTypes : ' + str(self.memoryPoolSupportedHandleTypes)]
            except ValueError:
                str_list += ['memoryPoolSupportedHandleTypes : <ValueError>']
            try:
                str_list += ['deferredMappingCudaArraySupported : ' + str(self.deferredMappingCudaArraySupported)]
            except ValueError:
                str_list += ['deferredMappingCudaArraySupported : <ValueError>']
            try:
                str_list += ['ipcEventSupported : ' + str(self.ipcEventSupported)]
            except ValueError:
                str_list += ['ipcEventSupported : <ValueError>']
            try:
                str_list += ['clusterLaunch : ' + str(self.clusterLaunch)]
            except ValueError:
                str_list += ['clusterLaunch : <ValueError>']
            try:
                str_list += ['unifiedFunctionPointers : ' + str(self.unifiedFunctionPointers)]
            except ValueError:
                str_list += ['unifiedFunctionPointers : <ValueError>']
            try:
                str_list += ['deviceNumaConfig : ' + str(self.deviceNumaConfig)]
            except ValueError:
                str_list += ['deviceNumaConfig : <ValueError>']
            try:
                str_list += ['deviceNumaId : ' + str(self.deviceNumaId)]
            except ValueError:
                str_list += ['deviceNumaId : <ValueError>']
            try:
                str_list += ['mpsEnabled : ' + str(self.mpsEnabled)]
            except ValueError:
                str_list += ['mpsEnabled : <ValueError>']
            try:
                str_list += ['hostNumaId : ' + str(self.hostNumaId)]
            except ValueError:
                str_list += ['hostNumaId : <ValueError>']
            try:
                str_list += ['gpuPciDeviceID : ' + str(self.gpuPciDeviceID)]
            except ValueError:
                str_list += ['gpuPciDeviceID : <ValueError>']
            try:
                str_list += ['gpuPciSubsystemID : ' + str(self.gpuPciSubsystemID)]
            except ValueError:
                str_list += ['gpuPciSubsystemID : <ValueError>']
            try:
                str_list += ['hostNumaMultinodeIpcSupported : ' + str(self.hostNumaMultinodeIpcSupported)]
            except ValueError:
                str_list += ['hostNumaMultinodeIpcSupported : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def name(self):
        return self._pvt_ptr[0].name
    @name.setter
    def name(self, name):
        pass
        self._pvt_ptr[0].name = name
    @property
    def uuid(self):
        return self._uuid
    @uuid.setter
    def uuid(self, uuid not None : cudaUUID_t):
        string.memcpy(&self._pvt_ptr[0].uuid, <cyruntime.cudaUUID_t*><void_ptr>uuid.getPtr(), sizeof(self._pvt_ptr[0].uuid))
    @property
    def luid(self):
        return PyBytes_FromStringAndSize(self._pvt_ptr[0].luid, 8)
    @luid.setter
    def luid(self, luid):
        if len(luid) != 8:
            raise ValueError("luid length must be 8, is " + str(len(luid)))
        if CHAR_MIN == 0:
            for i, b in enumerate(luid):
                if b < 0 and b > -129:
                    b = b + 256
                self._pvt_ptr[0].luid[i] = b
        else:
            for i, b in enumerate(luid):
                if b > 127 and b < 256:
                    b = b - 256
                self._pvt_ptr[0].luid[i] = b
    @property
    def luidDeviceNodeMask(self):
        return self._pvt_ptr[0].luidDeviceNodeMask
    @luidDeviceNodeMask.setter
    def luidDeviceNodeMask(self, unsigned int luidDeviceNodeMask):
        self._pvt_ptr[0].luidDeviceNodeMask = luidDeviceNodeMask
    @property
    def totalGlobalMem(self):
        return self._pvt_ptr[0].totalGlobalMem
    @totalGlobalMem.setter
    def totalGlobalMem(self, size_t totalGlobalMem):
        self._pvt_ptr[0].totalGlobalMem = totalGlobalMem
    @property
    def sharedMemPerBlock(self):
        return self._pvt_ptr[0].sharedMemPerBlock
    @sharedMemPerBlock.setter
    def sharedMemPerBlock(self, size_t sharedMemPerBlock):
        self._pvt_ptr[0].sharedMemPerBlock = sharedMemPerBlock
    @property
    def regsPerBlock(self):
        return self._pvt_ptr[0].regsPerBlock
    @regsPerBlock.setter
    def regsPerBlock(self, int regsPerBlock):
        self._pvt_ptr[0].regsPerBlock = regsPerBlock
    @property
    def warpSize(self):
        return self._pvt_ptr[0].warpSize
    @warpSize.setter
    def warpSize(self, int warpSize):
        self._pvt_ptr[0].warpSize = warpSize
    @property
    def memPitch(self):
        return self._pvt_ptr[0].memPitch
    @memPitch.setter
    def memPitch(self, size_t memPitch):
        self._pvt_ptr[0].memPitch = memPitch
    @property
    def maxThreadsPerBlock(self):
        return self._pvt_ptr[0].maxThreadsPerBlock
    @maxThreadsPerBlock.setter
    def maxThreadsPerBlock(self, int maxThreadsPerBlock):
        self._pvt_ptr[0].maxThreadsPerBlock = maxThreadsPerBlock
    @property
    def maxThreadsDim(self):
        return self._pvt_ptr[0].maxThreadsDim
    @maxThreadsDim.setter
    def maxThreadsDim(self, maxThreadsDim):
        self._pvt_ptr[0].maxThreadsDim = maxThreadsDim
    @property
    def maxGridSize(self):
        return self._pvt_ptr[0].maxGridSize
    @maxGridSize.setter
    def maxGridSize(self, maxGridSize):
        self._pvt_ptr[0].maxGridSize = maxGridSize
    @property
    def totalConstMem(self):
        return self._pvt_ptr[0].totalConstMem
    @totalConstMem.setter
    def totalConstMem(self, size_t totalConstMem):
        self._pvt_ptr[0].totalConstMem = totalConstMem
    @property
    def major(self):
        return self._pvt_ptr[0].major
    @major.setter
    def major(self, int major):
        self._pvt_ptr[0].major = major
    @property
    def minor(self):
        return self._pvt_ptr[0].minor
    @minor.setter
    def minor(self, int minor):
        self._pvt_ptr[0].minor = minor
    @property
    def textureAlignment(self):
        return self._pvt_ptr[0].textureAlignment
    @textureAlignment.setter
    def textureAlignment(self, size_t textureAlignment):
        self._pvt_ptr[0].textureAlignment = textureAlignment
    @property
    def texturePitchAlignment(self):
        return self._pvt_ptr[0].texturePitchAlignment
    @texturePitchAlignment.setter
    def texturePitchAlignment(self, size_t texturePitchAlignment):
        self._pvt_ptr[0].texturePitchAlignment = texturePitchAlignment
    @property
    def multiProcessorCount(self):
        return self._pvt_ptr[0].multiProcessorCount
    @multiProcessorCount.setter
    def multiProcessorCount(self, int multiProcessorCount):
        self._pvt_ptr[0].multiProcessorCount = multiProcessorCount
    @property
    def integrated(self):
        return self._pvt_ptr[0].integrated
    @integrated.setter
    def integrated(self, int integrated):
        self._pvt_ptr[0].integrated = integrated
    @property
    def canMapHostMemory(self):
        return self._pvt_ptr[0].canMapHostMemory
    @canMapHostMemory.setter
    def canMapHostMemory(self, int canMapHostMemory):
        self._pvt_ptr[0].canMapHostMemory = canMapHostMemory
    @property
    def maxTexture1D(self):
        return self._pvt_ptr[0].maxTexture1D
    @maxTexture1D.setter
    def maxTexture1D(self, int maxTexture1D):
        self._pvt_ptr[0].maxTexture1D = maxTexture1D
    @property
    def maxTexture1DMipmap(self):
        return self._pvt_ptr[0].maxTexture1DMipmap
    @maxTexture1DMipmap.setter
    def maxTexture1DMipmap(self, int maxTexture1DMipmap):
        self._pvt_ptr[0].maxTexture1DMipmap = maxTexture1DMipmap
    @property
    def maxTexture2D(self):
        return self._pvt_ptr[0].maxTexture2D
    @maxTexture2D.setter
    def maxTexture2D(self, maxTexture2D):
        self._pvt_ptr[0].maxTexture2D = maxTexture2D
    @property
    def maxTexture2DMipmap(self):
        return self._pvt_ptr[0].maxTexture2DMipmap
    @maxTexture2DMipmap.setter
    def maxTexture2DMipmap(self, maxTexture2DMipmap):
        self._pvt_ptr[0].maxTexture2DMipmap = maxTexture2DMipmap
    @property
    def maxTexture2DLinear(self):
        return self._pvt_ptr[0].maxTexture2DLinear
    @maxTexture2DLinear.setter
    def maxTexture2DLinear(self, maxTexture2DLinear):
        self._pvt_ptr[0].maxTexture2DLinear = maxTexture2DLinear
    @property
    def maxTexture2DGather(self):
        return self._pvt_ptr[0].maxTexture2DGather
    @maxTexture2DGather.setter
    def maxTexture2DGather(self, maxTexture2DGather):
        self._pvt_ptr[0].maxTexture2DGather = maxTexture2DGather
    @property
    def maxTexture3D(self):
        return self._pvt_ptr[0].maxTexture3D
    @maxTexture3D.setter
    def maxTexture3D(self, maxTexture3D):
        self._pvt_ptr[0].maxTexture3D = maxTexture3D
    @property
    def maxTexture3DAlt(self):
        return self._pvt_ptr[0].maxTexture3DAlt
    @maxTexture3DAlt.setter
    def maxTexture3DAlt(self, maxTexture3DAlt):
        self._pvt_ptr[0].maxTexture3DAlt = maxTexture3DAlt
    @property
    def maxTextureCubemap(self):
        return self._pvt_ptr[0].maxTextureCubemap
    @maxTextureCubemap.setter
    def maxTextureCubemap(self, int maxTextureCubemap):
        self._pvt_ptr[0].maxTextureCubemap = maxTextureCubemap
    @property
    def maxTexture1DLayered(self):
        return self._pvt_ptr[0].maxTexture1DLayered
    @maxTexture1DLayered.setter
    def maxTexture1DLayered(self, maxTexture1DLayered):
        self._pvt_ptr[0].maxTexture1DLayered = maxTexture1DLayered
    @property
    def maxTexture2DLayered(self):
        return self._pvt_ptr[0].maxTexture2DLayered
    @maxTexture2DLayered.setter
    def maxTexture2DLayered(self, maxTexture2DLayered):
        self._pvt_ptr[0].maxTexture2DLayered = maxTexture2DLayered
    @property
    def maxTextureCubemapLayered(self):
        return self._pvt_ptr[0].maxTextureCubemapLayered
    @maxTextureCubemapLayered.setter
    def maxTextureCubemapLayered(self, maxTextureCubemapLayered):
        self._pvt_ptr[0].maxTextureCubemapLayered = maxTextureCubemapLayered
    @property
    def maxSurface1D(self):
        return self._pvt_ptr[0].maxSurface1D
    @maxSurface1D.setter
    def maxSurface1D(self, int maxSurface1D):
        self._pvt_ptr[0].maxSurface1D = maxSurface1D
    @property
    def maxSurface2D(self):
        return self._pvt_ptr[0].maxSurface2D
    @maxSurface2D.setter
    def maxSurface2D(self, maxSurface2D):
        self._pvt_ptr[0].maxSurface2D = maxSurface2D
    @property
    def maxSurface3D(self):
        return self._pvt_ptr[0].maxSurface3D
    @maxSurface3D.setter
    def maxSurface3D(self, maxSurface3D):
        self._pvt_ptr[0].maxSurface3D = maxSurface3D
    @property
    def maxSurface1DLayered(self):
        return self._pvt_ptr[0].maxSurface1DLayered
    @maxSurface1DLayered.setter
    def maxSurface1DLayered(self, maxSurface1DLayered):
        self._pvt_ptr[0].maxSurface1DLayered = maxSurface1DLayered
    @property
    def maxSurface2DLayered(self):
        return self._pvt_ptr[0].maxSurface2DLayered
    @maxSurface2DLayered.setter
    def maxSurface2DLayered(self, maxSurface2DLayered):
        self._pvt_ptr[0].maxSurface2DLayered = maxSurface2DLayered
    @property
    def maxSurfaceCubemap(self):
        return self._pvt_ptr[0].maxSurfaceCubemap
    @maxSurfaceCubemap.setter
    def maxSurfaceCubemap(self, int maxSurfaceCubemap):
        self._pvt_ptr[0].maxSurfaceCubemap = maxSurfaceCubemap
    @property
    def maxSurfaceCubemapLayered(self):
        return self._pvt_ptr[0].maxSurfaceCubemapLayered
    @maxSurfaceCubemapLayered.setter
    def maxSurfaceCubemapLayered(self, maxSurfaceCubemapLayered):
        self._pvt_ptr[0].maxSurfaceCubemapLayered = maxSurfaceCubemapLayered
    @property
    def surfaceAlignment(self):
        return self._pvt_ptr[0].surfaceAlignment
    @surfaceAlignment.setter
    def surfaceAlignment(self, size_t surfaceAlignment):
        self._pvt_ptr[0].surfaceAlignment = surfaceAlignment
    @property
    def concurrentKernels(self):
        return self._pvt_ptr[0].concurrentKernels
    @concurrentKernels.setter
    def concurrentKernels(self, int concurrentKernels):
        self._pvt_ptr[0].concurrentKernels = concurrentKernels
    @property
    def ECCEnabled(self):
        return self._pvt_ptr[0].ECCEnabled
    @ECCEnabled.setter
    def ECCEnabled(self, int ECCEnabled):
        self._pvt_ptr[0].ECCEnabled = ECCEnabled
    @property
    def pciBusID(self):
        return self._pvt_ptr[0].pciBusID
    @pciBusID.setter
    def pciBusID(self, int pciBusID):
        self._pvt_ptr[0].pciBusID = pciBusID
    @property
    def pciDeviceID(self):
        return self._pvt_ptr[0].pciDeviceID
    @pciDeviceID.setter
    def pciDeviceID(self, int pciDeviceID):
        self._pvt_ptr[0].pciDeviceID = pciDeviceID
    @property
    def pciDomainID(self):
        return self._pvt_ptr[0].pciDomainID
    @pciDomainID.setter
    def pciDomainID(self, int pciDomainID):
        self._pvt_ptr[0].pciDomainID = pciDomainID
    @property
    def tccDriver(self):
        return self._pvt_ptr[0].tccDriver
    @tccDriver.setter
    def tccDriver(self, int tccDriver):
        self._pvt_ptr[0].tccDriver = tccDriver
    @property
    def asyncEngineCount(self):
        return self._pvt_ptr[0].asyncEngineCount
    @asyncEngineCount.setter
    def asyncEngineCount(self, int asyncEngineCount):
        self._pvt_ptr[0].asyncEngineCount = asyncEngineCount
    @property
    def unifiedAddressing(self):
        return self._pvt_ptr[0].unifiedAddressing
    @unifiedAddressing.setter
    def unifiedAddressing(self, int unifiedAddressing):
        self._pvt_ptr[0].unifiedAddressing = unifiedAddressing
    @property
    def memoryBusWidth(self):
        return self._pvt_ptr[0].memoryBusWidth
    @memoryBusWidth.setter
    def memoryBusWidth(self, int memoryBusWidth):
        self._pvt_ptr[0].memoryBusWidth = memoryBusWidth
    @property
    def l2CacheSize(self):
        return self._pvt_ptr[0].l2CacheSize
    @l2CacheSize.setter
    def l2CacheSize(self, int l2CacheSize):
        self._pvt_ptr[0].l2CacheSize = l2CacheSize
    @property
    def persistingL2CacheMaxSize(self):
        return self._pvt_ptr[0].persistingL2CacheMaxSize
    @persistingL2CacheMaxSize.setter
    def persistingL2CacheMaxSize(self, int persistingL2CacheMaxSize):
        self._pvt_ptr[0].persistingL2CacheMaxSize = persistingL2CacheMaxSize
    @property
    def maxThreadsPerMultiProcessor(self):
        return self._pvt_ptr[0].maxThreadsPerMultiProcessor
    @maxThreadsPerMultiProcessor.setter
    def maxThreadsPerMultiProcessor(self, int maxThreadsPerMultiProcessor):
        self._pvt_ptr[0].maxThreadsPerMultiProcessor = maxThreadsPerMultiProcessor
    @property
    def streamPrioritiesSupported(self):
        return self._pvt_ptr[0].streamPrioritiesSupported
    @streamPrioritiesSupported.setter
    def streamPrioritiesSupported(self, int streamPrioritiesSupported):
        self._pvt_ptr[0].streamPrioritiesSupported = streamPrioritiesSupported
    @property
    def globalL1CacheSupported(self):
        return self._pvt_ptr[0].globalL1CacheSupported
    @globalL1CacheSupported.setter
    def globalL1CacheSupported(self, int globalL1CacheSupported):
        self._pvt_ptr[0].globalL1CacheSupported = globalL1CacheSupported
    @property
    def localL1CacheSupported(self):
        return self._pvt_ptr[0].localL1CacheSupported
    @localL1CacheSupported.setter
    def localL1CacheSupported(self, int localL1CacheSupported):
        self._pvt_ptr[0].localL1CacheSupported = localL1CacheSupported
    @property
    def sharedMemPerMultiprocessor(self):
        return self._pvt_ptr[0].sharedMemPerMultiprocessor
    @sharedMemPerMultiprocessor.setter
    def sharedMemPerMultiprocessor(self, size_t sharedMemPerMultiprocessor):
        self._pvt_ptr[0].sharedMemPerMultiprocessor = sharedMemPerMultiprocessor
    @property
    def regsPerMultiprocessor(self):
        return self._pvt_ptr[0].regsPerMultiprocessor
    @regsPerMultiprocessor.setter
    def regsPerMultiprocessor(self, int regsPerMultiprocessor):
        self._pvt_ptr[0].regsPerMultiprocessor = regsPerMultiprocessor
    @property
    def managedMemory(self):
        return self._pvt_ptr[0].managedMemory
    @managedMemory.setter
    def managedMemory(self, int managedMemory):
        self._pvt_ptr[0].managedMemory = managedMemory
    @property
    def isMultiGpuBoard(self):
        return self._pvt_ptr[0].isMultiGpuBoard
    @isMultiGpuBoard.setter
    def isMultiGpuBoard(self, int isMultiGpuBoard):
        self._pvt_ptr[0].isMultiGpuBoard = isMultiGpuBoard
    @property
    def multiGpuBoardGroupID(self):
        return self._pvt_ptr[0].multiGpuBoardGroupID
    @multiGpuBoardGroupID.setter
    def multiGpuBoardGroupID(self, int multiGpuBoardGroupID):
        self._pvt_ptr[0].multiGpuBoardGroupID = multiGpuBoardGroupID
    @property
    def hostNativeAtomicSupported(self):
        return self._pvt_ptr[0].hostNativeAtomicSupported
    @hostNativeAtomicSupported.setter
    def hostNativeAtomicSupported(self, int hostNativeAtomicSupported):
        self._pvt_ptr[0].hostNativeAtomicSupported = hostNativeAtomicSupported
    @property
    def pageableMemoryAccess(self):
        return self._pvt_ptr[0].pageableMemoryAccess
    @pageableMemoryAccess.setter
    def pageableMemoryAccess(self, int pageableMemoryAccess):
        self._pvt_ptr[0].pageableMemoryAccess = pageableMemoryAccess
    @property
    def concurrentManagedAccess(self):
        return self._pvt_ptr[0].concurrentManagedAccess
    @concurrentManagedAccess.setter
    def concurrentManagedAccess(self, int concurrentManagedAccess):
        self._pvt_ptr[0].concurrentManagedAccess = concurrentManagedAccess
    @property
    def computePreemptionSupported(self):
        return self._pvt_ptr[0].computePreemptionSupported
    @computePreemptionSupported.setter
    def computePreemptionSupported(self, int computePreemptionSupported):
        self._pvt_ptr[0].computePreemptionSupported = computePreemptionSupported
    @property
    def canUseHostPointerForRegisteredMem(self):
        return self._pvt_ptr[0].canUseHostPointerForRegisteredMem
    @canUseHostPointerForRegisteredMem.setter
    def canUseHostPointerForRegisteredMem(self, int canUseHostPointerForRegisteredMem):
        self._pvt_ptr[0].canUseHostPointerForRegisteredMem = canUseHostPointerForRegisteredMem
    @property
    def cooperativeLaunch(self):
        return self._pvt_ptr[0].cooperativeLaunch
    @cooperativeLaunch.setter
    def cooperativeLaunch(self, int cooperativeLaunch):
        self._pvt_ptr[0].cooperativeLaunch = cooperativeLaunch
    @property
    def sharedMemPerBlockOptin(self):
        return self._pvt_ptr[0].sharedMemPerBlockOptin
    @sharedMemPerBlockOptin.setter
    def sharedMemPerBlockOptin(self, size_t sharedMemPerBlockOptin):
        self._pvt_ptr[0].sharedMemPerBlockOptin = sharedMemPerBlockOptin
    @property
    def pageableMemoryAccessUsesHostPageTables(self):
        return self._pvt_ptr[0].pageableMemoryAccessUsesHostPageTables
    @pageableMemoryAccessUsesHostPageTables.setter
    def pageableMemoryAccessUsesHostPageTables(self, int pageableMemoryAccessUsesHostPageTables):
        self._pvt_ptr[0].pageableMemoryAccessUsesHostPageTables = pageableMemoryAccessUsesHostPageTables
    @property
    def directManagedMemAccessFromHost(self):
        return self._pvt_ptr[0].directManagedMemAccessFromHost
    @directManagedMemAccessFromHost.setter
    def directManagedMemAccessFromHost(self, int directManagedMemAccessFromHost):
        self._pvt_ptr[0].directManagedMemAccessFromHost = directManagedMemAccessFromHost
    @property
    def maxBlocksPerMultiProcessor(self):
        return self._pvt_ptr[0].maxBlocksPerMultiProcessor
    @maxBlocksPerMultiProcessor.setter
    def maxBlocksPerMultiProcessor(self, int maxBlocksPerMultiProcessor):
        self._pvt_ptr[0].maxBlocksPerMultiProcessor = maxBlocksPerMultiProcessor
    @property
    def accessPolicyMaxWindowSize(self):
        return self._pvt_ptr[0].accessPolicyMaxWindowSize
    @accessPolicyMaxWindowSize.setter
    def accessPolicyMaxWindowSize(self, int accessPolicyMaxWindowSize):
        self._pvt_ptr[0].accessPolicyMaxWindowSize = accessPolicyMaxWindowSize
    @property
    def reservedSharedMemPerBlock(self):
        return self._pvt_ptr[0].reservedSharedMemPerBlock
    @reservedSharedMemPerBlock.setter
    def reservedSharedMemPerBlock(self, size_t reservedSharedMemPerBlock):
        self._pvt_ptr[0].reservedSharedMemPerBlock = reservedSharedMemPerBlock
    @property
    def hostRegisterSupported(self):
        return self._pvt_ptr[0].hostRegisterSupported
    @hostRegisterSupported.setter
    def hostRegisterSupported(self, int hostRegisterSupported):
        self._pvt_ptr[0].hostRegisterSupported = hostRegisterSupported
    @property
    def sparseCudaArraySupported(self):
        return self._pvt_ptr[0].sparseCudaArraySupported
    @sparseCudaArraySupported.setter
    def sparseCudaArraySupported(self, int sparseCudaArraySupported):
        self._pvt_ptr[0].sparseCudaArraySupported = sparseCudaArraySupported
    @property
    def hostRegisterReadOnlySupported(self):
        return self._pvt_ptr[0].hostRegisterReadOnlySupported
    @hostRegisterReadOnlySupported.setter
    def hostRegisterReadOnlySupported(self, int hostRegisterReadOnlySupported):
        self._pvt_ptr[0].hostRegisterReadOnlySupported = hostRegisterReadOnlySupported
    @property
    def timelineSemaphoreInteropSupported(self):
        return self._pvt_ptr[0].timelineSemaphoreInteropSupported
    @timelineSemaphoreInteropSupported.setter
    def timelineSemaphoreInteropSupported(self, int timelineSemaphoreInteropSupported):
        self._pvt_ptr[0].timelineSemaphoreInteropSupported = timelineSemaphoreInteropSupported
    @property
    def memoryPoolsSupported(self):
        return self._pvt_ptr[0].memoryPoolsSupported
    @memoryPoolsSupported.setter
    def memoryPoolsSupported(self, int memoryPoolsSupported):
        self._pvt_ptr[0].memoryPoolsSupported = memoryPoolsSupported
    @property
    def gpuDirectRDMASupported(self):
        return self._pvt_ptr[0].gpuDirectRDMASupported
    @gpuDirectRDMASupported.setter
    def gpuDirectRDMASupported(self, int gpuDirectRDMASupported):
        self._pvt_ptr[0].gpuDirectRDMASupported = gpuDirectRDMASupported
    @property
    def gpuDirectRDMAFlushWritesOptions(self):
        return self._pvt_ptr[0].gpuDirectRDMAFlushWritesOptions
    @gpuDirectRDMAFlushWritesOptions.setter
    def gpuDirectRDMAFlushWritesOptions(self, unsigned int gpuDirectRDMAFlushWritesOptions):
        self._pvt_ptr[0].gpuDirectRDMAFlushWritesOptions = gpuDirectRDMAFlushWritesOptions
    @property
    def gpuDirectRDMAWritesOrdering(self):
        return self._pvt_ptr[0].gpuDirectRDMAWritesOrdering
    @gpuDirectRDMAWritesOrdering.setter
    def gpuDirectRDMAWritesOrdering(self, int gpuDirectRDMAWritesOrdering):
        self._pvt_ptr[0].gpuDirectRDMAWritesOrdering = gpuDirectRDMAWritesOrdering
    @property
    def memoryPoolSupportedHandleTypes(self):
        return self._pvt_ptr[0].memoryPoolSupportedHandleTypes
    @memoryPoolSupportedHandleTypes.setter
    def memoryPoolSupportedHandleTypes(self, unsigned int memoryPoolSupportedHandleTypes):
        self._pvt_ptr[0].memoryPoolSupportedHandleTypes = memoryPoolSupportedHandleTypes
    @property
    def deferredMappingCudaArraySupported(self):
        return self._pvt_ptr[0].deferredMappingCudaArraySupported
    @deferredMappingCudaArraySupported.setter
    def deferredMappingCudaArraySupported(self, int deferredMappingCudaArraySupported):
        self._pvt_ptr[0].deferredMappingCudaArraySupported = deferredMappingCudaArraySupported
    @property
    def ipcEventSupported(self):
        return self._pvt_ptr[0].ipcEventSupported
    @ipcEventSupported.setter
    def ipcEventSupported(self, int ipcEventSupported):
        self._pvt_ptr[0].ipcEventSupported = ipcEventSupported
    @property
    def clusterLaunch(self):
        return self._pvt_ptr[0].clusterLaunch
    @clusterLaunch.setter
    def clusterLaunch(self, int clusterLaunch):
        self._pvt_ptr[0].clusterLaunch = clusterLaunch
    @property
    def unifiedFunctionPointers(self):
        return self._pvt_ptr[0].unifiedFunctionPointers
    @unifiedFunctionPointers.setter
    def unifiedFunctionPointers(self, int unifiedFunctionPointers):
        self._pvt_ptr[0].unifiedFunctionPointers = unifiedFunctionPointers
    @property
    def deviceNumaConfig(self):
        return self._pvt_ptr[0].deviceNumaConfig
    @deviceNumaConfig.setter
    def deviceNumaConfig(self, int deviceNumaConfig):
        self._pvt_ptr[0].deviceNumaConfig = deviceNumaConfig
    @property
    def deviceNumaId(self):
        return self._pvt_ptr[0].deviceNumaId
    @deviceNumaId.setter
    def deviceNumaId(self, int deviceNumaId):
        self._pvt_ptr[0].deviceNumaId = deviceNumaId
    @property
    def mpsEnabled(self):
        return self._pvt_ptr[0].mpsEnabled
    @mpsEnabled.setter
    def mpsEnabled(self, int mpsEnabled):
        self._pvt_ptr[0].mpsEnabled = mpsEnabled
    @property
    def hostNumaId(self):
        return self._pvt_ptr[0].hostNumaId
    @hostNumaId.setter
    def hostNumaId(self, int hostNumaId):
        self._pvt_ptr[0].hostNumaId = hostNumaId
    @property
    def gpuPciDeviceID(self):
        return self._pvt_ptr[0].gpuPciDeviceID
    @gpuPciDeviceID.setter
    def gpuPciDeviceID(self, unsigned int gpuPciDeviceID):
        self._pvt_ptr[0].gpuPciDeviceID = gpuPciDeviceID
    @property
    def gpuPciSubsystemID(self):
        return self._pvt_ptr[0].gpuPciSubsystemID
    @gpuPciSubsystemID.setter
    def gpuPciSubsystemID(self, unsigned int gpuPciSubsystemID):
        self._pvt_ptr[0].gpuPciSubsystemID = gpuPciSubsystemID
    @property
    def hostNumaMultinodeIpcSupported(self):
        return self._pvt_ptr[0].hostNumaMultinodeIpcSupported
    @hostNumaMultinodeIpcSupported.setter
    def hostNumaMultinodeIpcSupported(self, int hostNumaMultinodeIpcSupported):
        self._pvt_ptr[0].hostNumaMultinodeIpcSupported = hostNumaMultinodeIpcSupported
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class cudaIpcEventHandle_st:
    """
    CUDA IPC event handle

    Attributes
    ----------
    reserved : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaIpcEventHandle_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(self._pvt_ptr[0].reserved, 64)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 64:
            raise ValueError("reserved length must be 64, is " + str(len(reserved)))
        if CHAR_MIN == 0:
            for i, b in enumerate(reserved):
                if b < 0 and b > -129:
                    b = b + 256
                self._pvt_ptr[0].reserved[i] = b
        else:
            for i, b in enumerate(reserved):
                if b > 127 and b < 256:
                    b = b - 256
                self._pvt_ptr[0].reserved[i] = b

cdef class cudaIpcMemHandle_st:
    """
    CUDA IPC memory handle

    Attributes
    ----------
    reserved : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaIpcMemHandle_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(self._pvt_ptr[0].reserved, 64)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 64:
            raise ValueError("reserved length must be 64, is " + str(len(reserved)))
        if CHAR_MIN == 0:
            for i, b in enumerate(reserved):
                if b < 0 and b > -129:
                    b = b + 256
                self._pvt_ptr[0].reserved[i] = b
        else:
            for i, b in enumerate(reserved):
                if b > 127 and b < 256:
                    b = b - 256
                self._pvt_ptr[0].reserved[i] = b

cdef class cudaMemFabricHandle_st:
    """
    Attributes
    ----------
    reserved : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaMemFabricHandle_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(self._pvt_ptr[0].reserved, 64)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 64:
            raise ValueError("reserved length must be 64, is " + str(len(reserved)))
        if CHAR_MIN == 0:
            for i, b in enumerate(reserved):
                if b < 0 and b > -129:
                    b = b + 256
                self._pvt_ptr[0].reserved[i] = b
        else:
            for i, b in enumerate(reserved):
                if b > 127 and b < 256:
                    b = b - 256
                self._pvt_ptr[0].reserved[i] = b

cdef class anon_struct8:
    """
    Attributes
    ----------
    handle : Any

    name : Any


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaExternalMemoryHandleDesc *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].handle.win32
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['handle : ' + hex(self.handle)]
            except ValueError:
                str_list += ['handle : <ValueError>']
            try:
                str_list += ['name : ' + hex(self.name)]
            except ValueError:
                str_list += ['name : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def handle(self):
        return <void_ptr>self._pvt_ptr[0].handle.win32.handle
    @handle.setter
    def handle(self, handle):
        _chandle = _HelperInputVoidPtr(handle)
        self._pvt_ptr[0].handle.win32.handle = <void*><void_ptr>_chandle.cptr
    @property
    def name(self):
        return <void_ptr>self._pvt_ptr[0].handle.win32.name
    @name.setter
    def name(self, name):
        _cname = _HelperInputVoidPtr(name)
        self._pvt_ptr[0].handle.win32.name = <void*><void_ptr>_cname.cptr

cdef class anon_union2:
    """
    Attributes
    ----------
    fd : int

    win32 : anon_struct8

    nvSciBufObject : Any


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaExternalMemoryHandleDesc *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._win32 = anon_struct8(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].handle
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fd : ' + str(self.fd)]
            except ValueError:
                str_list += ['fd : <ValueError>']
            try:
                str_list += ['win32 :\n' + '\n'.join(['    ' + line for line in str(self.win32).splitlines()])]
            except ValueError:
                str_list += ['win32 : <ValueError>']
            try:
                str_list += ['nvSciBufObject : ' + hex(self.nvSciBufObject)]
            except ValueError:
                str_list += ['nvSciBufObject : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fd(self):
        return self._pvt_ptr[0].handle.fd
    @fd.setter
    def fd(self, int fd):
        self._pvt_ptr[0].handle.fd = fd
    @property
    def win32(self):
        return self._win32
    @win32.setter
    def win32(self, win32 not None : anon_struct8):
        string.memcpy(&self._pvt_ptr[0].handle.win32, <cyruntime.anon_struct8*><void_ptr>win32.getPtr(), sizeof(self._pvt_ptr[0].handle.win32))
    @property
    def nvSciBufObject(self):
        return <void_ptr>self._pvt_ptr[0].handle.nvSciBufObject
    @nvSciBufObject.setter
    def nvSciBufObject(self, nvSciBufObject):
        _cnvSciBufObject = _HelperInputVoidPtr(nvSciBufObject)
        self._pvt_ptr[0].handle.nvSciBufObject = <void*><void_ptr>_cnvSciBufObject.cptr

cdef class cudaExternalMemoryHandleDesc:
    """
    External memory handle descriptor

    Attributes
    ----------
    type : cudaExternalMemoryHandleType
        Type of the handle
    handle : anon_union2

    size : unsigned long long
        Size of the memory allocation
    flags : unsigned int
        Flags must either be zero or cudaExternalMemoryDedicated
    reserved : list[unsigned int]
        Must be zero

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cyruntime.cudaExternalMemoryHandleDesc *>calloc(1, sizeof(cyruntime.cudaExternalMemoryHandleDesc))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cyruntime.cudaExternalMemoryHandleDesc *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._handle = anon_union2(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['handle :\n' + '\n'.join(['    ' + line for line in str(self.handle).splitlines()])]
            except ValueError:
                str_list += ['handle : <ValueError>']
            try:
                str_list += ['size : ' + str(self.size)]
            except ValueError:
                str_list += ['size : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_cudaExternalMemoryHandleType:
            return None
        return _dict_cudaExternalMemoryHandleType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : cudaExternalMemoryHandleType):
        self._pvt_ptr[0].type = type.value
    @property
    def handle(self):
        return self._handle
    @handle.setter
    def handle(self, handle not None : anon_union2):
        string.memcpy(&self._pvt_ptr[0].handle, <cyruntime.anon_union2*><void_ptr>handle.getPtr(), sizeof(self._pvt_ptr[0].handle))
    @property
    def size(self):
        return self._pvt_ptr[0].size
    @size.setter
    def size(self, unsigned long long size):
        self._pvt_ptr[0].size = size
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class cudaExternalMemoryBufferDesc:
    """
    External memory buffer descriptor

    Attributes
    ----------
    offset : unsigned long long
        Offset into the memory object where the buffer's base is
    size : unsigned long long
        Size of the buffer
    flags : unsigned int
        Flags reserved for future use. Must be zero.
    reserved : list[unsigned int]
        Must be zero

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaExternalMemoryBufferDesc *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['offset : ' + str(self.offset)]
            except ValueError:
                str_list += ['offset : <ValueError>']
            try:
                str_list += ['size : ' + str(self.size)]
            except ValueError:
                str_list += ['size : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def offset(self):
        return self._pvt_ptr[0].offset
    @offset.setter
    def offset(self, unsigned long long offset):
        self._pvt_ptr[0].offset = offset
    @property
    def size(self):
        return self._pvt_ptr[0].size
    @size.setter
    def size(self, unsigned long long size):
        self._pvt_ptr[0].size = size
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class cudaExternalMemoryMipmappedArrayDesc:
    """
    External memory mipmap descriptor

    Attributes
    ----------
    offset : unsigned long long
        Offset into the memory object where the base level of the mipmap
        chain is.
    formatDesc : cudaChannelFormatDesc
        Format of base level of the mipmap chain
    extent : cudaExtent
        Dimensions of base level of the mipmap chain
    flags : unsigned int
        Flags associated with CUDA mipmapped arrays. See
        cudaMallocMipmappedArray
    numLevels : unsigned int
        Total number of levels in the mipmap chain
    reserved : list[unsigned int]
        Must be zero

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaExternalMemoryMipmappedArrayDesc *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._formatDesc = cudaChannelFormatDesc(_ptr=<void_ptr>&self._pvt_ptr[0].formatDesc)
        self._extent = cudaExtent(_ptr=<void_ptr>&self._pvt_ptr[0].extent)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['offset : ' + str(self.offset)]
            except ValueError:
                str_list += ['offset : <ValueError>']
            try:
                str_list += ['formatDesc :\n' + '\n'.join(['    ' + line for line in str(self.formatDesc).splitlines()])]
            except ValueError:
                str_list += ['formatDesc : <ValueError>']
            try:
                str_list += ['extent :\n' + '\n'.join(['    ' + line for line in str(self.extent).splitlines()])]
            except ValueError:
                str_list += ['extent : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['numLevels : ' + str(self.numLevels)]
            except ValueError:
                str_list += ['numLevels : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def offset(self):
        return self._pvt_ptr[0].offset
    @offset.setter
    def offset(self, unsigned long long offset):
        self._pvt_ptr[0].offset = offset
    @property
    def formatDesc(self):
        return self._formatDesc
    @formatDesc.setter
    def formatDesc(self, formatDesc not None : cudaChannelFormatDesc):
        string.memcpy(&self._pvt_ptr[0].formatDesc, <cyruntime.cudaChannelFormatDesc*><void_ptr>formatDesc.getPtr(), sizeof(self._pvt_ptr[0].formatDesc))
    @property
    def extent(self):
        return self._extent
    @extent.setter
    def extent(self, extent not None : cudaExtent):
        string.memcpy(&self._pvt_ptr[0].extent, <cyruntime.cudaExtent*><void_ptr>extent.getPtr(), sizeof(self._pvt_ptr[0].extent))
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def numLevels(self):
        return self._pvt_ptr[0].numLevels
    @numLevels.setter
    def numLevels(self, unsigned int numLevels):
        self._pvt_ptr[0].numLevels = numLevels
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class anon_struct9:
    """
    Attributes
    ----------
    handle : Any

    name : Any


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaExternalSemaphoreHandleDesc *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].handle.win32
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['handle : ' + hex(self.handle)]
            except ValueError:
                str_list += ['handle : <ValueError>']
            try:
                str_list += ['name : ' + hex(self.name)]
            except ValueError:
                str_list += ['name : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def handle(self):
        return <void_ptr>self._pvt_ptr[0].handle.win32.handle
    @handle.setter
    def handle(self, handle):
        _chandle = _HelperInputVoidPtr(handle)
        self._pvt_ptr[0].handle.win32.handle = <void*><void_ptr>_chandle.cptr
    @property
    def name(self):
        return <void_ptr>self._pvt_ptr[0].handle.win32.name
    @name.setter
    def name(self, name):
        _cname = _HelperInputVoidPtr(name)
        self._pvt_ptr[0].handle.win32.name = <void*><void_ptr>_cname.cptr

cdef class anon_union3:
    """
    Attributes
    ----------
    fd : int

    win32 : anon_struct9

    nvSciSyncObj : Any


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaExternalSemaphoreHandleDesc *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._win32 = anon_struct9(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].handle
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fd : ' + str(self.fd)]
            except ValueError:
                str_list += ['fd : <ValueError>']
            try:
                str_list += ['win32 :\n' + '\n'.join(['    ' + line for line in str(self.win32).splitlines()])]
            except ValueError:
                str_list += ['win32 : <ValueError>']
            try:
                str_list += ['nvSciSyncObj : ' + hex(self.nvSciSyncObj)]
            except ValueError:
                str_list += ['nvSciSyncObj : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fd(self):
        return self._pvt_ptr[0].handle.fd
    @fd.setter
    def fd(self, int fd):
        self._pvt_ptr[0].handle.fd = fd
    @property
    def win32(self):
        return self._win32
    @win32.setter
    def win32(self, win32 not None : anon_struct9):
        string.memcpy(&self._pvt_ptr[0].handle.win32, <cyruntime.anon_struct9*><void_ptr>win32.getPtr(), sizeof(self._pvt_ptr[0].handle.win32))
    @property
    def nvSciSyncObj(self):
        return <void_ptr>self._pvt_ptr[0].handle.nvSciSyncObj
    @nvSciSyncObj.setter
    def nvSciSyncObj(self, nvSciSyncObj):
        _cnvSciSyncObj = _HelperInputVoidPtr(nvSciSyncObj)
        self._pvt_ptr[0].handle.nvSciSyncObj = <void*><void_ptr>_cnvSciSyncObj.cptr

cdef class cudaExternalSemaphoreHandleDesc:
    """
    External semaphore handle descriptor

    Attributes
    ----------
    type : cudaExternalSemaphoreHandleType
        Type of the handle
    handle : anon_union3

    flags : unsigned int
        Flags reserved for the future. Must be zero.
    reserved : list[unsigned int]
        Must be zero

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cyruntime.cudaExternalSemaphoreHandleDesc *>calloc(1, sizeof(cyruntime.cudaExternalSemaphoreHandleDesc))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cyruntime.cudaExternalSemaphoreHandleDesc *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._handle = anon_union3(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['handle :\n' + '\n'.join(['    ' + line for line in str(self.handle).splitlines()])]
            except ValueError:
                str_list += ['handle : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_cudaExternalSemaphoreHandleType:
            return None
        return _dict_cudaExternalSemaphoreHandleType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : cudaExternalSemaphoreHandleType):
        self._pvt_ptr[0].type = type.value
    @property
    def handle(self):
        return self._handle
    @handle.setter
    def handle(self, handle not None : anon_union3):
        string.memcpy(&self._pvt_ptr[0].handle, <cyruntime.anon_union3*><void_ptr>handle.getPtr(), sizeof(self._pvt_ptr[0].handle))
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class anon_struct10:
    """
    Attributes
    ----------
    value : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaExternalSemaphoreSignalParams *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params.fence
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['value : ' + str(self.value)]
            except ValueError:
                str_list += ['value : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def value(self):
        return self._pvt_ptr[0].params.fence.value
    @value.setter
    def value(self, unsigned long long value):
        self._pvt_ptr[0].params.fence.value = value

cdef class anon_union4:
    """
    Attributes
    ----------
    fence : Any

    reserved : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaExternalSemaphoreSignalParams *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params.nvSciSync
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fence : ' + hex(self.fence)]
            except ValueError:
                str_list += ['fence : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fence(self):
        return <void_ptr>self._pvt_ptr[0].params.nvSciSync.fence
    @fence.setter
    def fence(self, fence):
        _cfence = _HelperInputVoidPtr(fence)
        self._pvt_ptr[0].params.nvSciSync.fence = <void*><void_ptr>_cfence.cptr
    @property
    def reserved(self):
        return self._pvt_ptr[0].params.nvSciSync.reserved
    @reserved.setter
    def reserved(self, unsigned long long reserved):
        self._pvt_ptr[0].params.nvSciSync.reserved = reserved

cdef class anon_struct11:
    """
    Attributes
    ----------
    key : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaExternalSemaphoreSignalParams *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params.keyedMutex
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['key : ' + str(self.key)]
            except ValueError:
                str_list += ['key : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def key(self):
        return self._pvt_ptr[0].params.keyedMutex.key
    @key.setter
    def key(self, unsigned long long key):
        self._pvt_ptr[0].params.keyedMutex.key = key

cdef class anon_struct12:
    """
    Attributes
    ----------
    fence : anon_struct10

    nvSciSync : anon_union4

    keyedMutex : anon_struct11

    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaExternalSemaphoreSignalParams *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._fence = anon_struct10(_ptr=<void_ptr>self._pvt_ptr)
        self._nvSciSync = anon_union4(_ptr=<void_ptr>self._pvt_ptr)
        self._keyedMutex = anon_struct11(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fence :\n' + '\n'.join(['    ' + line for line in str(self.fence).splitlines()])]
            except ValueError:
                str_list += ['fence : <ValueError>']
            try:
                str_list += ['nvSciSync :\n' + '\n'.join(['    ' + line for line in str(self.nvSciSync).splitlines()])]
            except ValueError:
                str_list += ['nvSciSync : <ValueError>']
            try:
                str_list += ['keyedMutex :\n' + '\n'.join(['    ' + line for line in str(self.keyedMutex).splitlines()])]
            except ValueError:
                str_list += ['keyedMutex : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fence(self):
        return self._fence
    @fence.setter
    def fence(self, fence not None : anon_struct10):
        string.memcpy(&self._pvt_ptr[0].params.fence, <cyruntime.anon_struct10*><void_ptr>fence.getPtr(), sizeof(self._pvt_ptr[0].params.fence))
    @property
    def nvSciSync(self):
        return self._nvSciSync
    @nvSciSync.setter
    def nvSciSync(self, nvSciSync not None : anon_union4):
        string.memcpy(&self._pvt_ptr[0].params.nvSciSync, <cyruntime.anon_union4*><void_ptr>nvSciSync.getPtr(), sizeof(self._pvt_ptr[0].params.nvSciSync))
    @property
    def keyedMutex(self):
        return self._keyedMutex
    @keyedMutex.setter
    def keyedMutex(self, keyedMutex not None : anon_struct11):
        string.memcpy(&self._pvt_ptr[0].params.keyedMutex, <cyruntime.anon_struct11*><void_ptr>keyedMutex.getPtr(), sizeof(self._pvt_ptr[0].params.keyedMutex))
    @property
    def reserved(self):
        return self._pvt_ptr[0].params.reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].params.reserved = reserved

cdef class cudaExternalSemaphoreSignalParams:
    """
    External semaphore signal parameters, compatible with driver type

    Attributes
    ----------
    params : anon_struct12

    flags : unsigned int
        Only when cudaExternalSemaphoreSignalParams is used to signal a
        cudaExternalSemaphore_t of type
        cudaExternalSemaphoreHandleTypeNvSciSync, the valid flag is
        cudaExternalSemaphoreSignalSkipNvSciBufMemSync: which indicates
        that while signaling the cudaExternalSemaphore_t, no memory
        synchronization operations should be performed for any external
        memory object imported as cudaExternalMemoryHandleTypeNvSciBuf. For
        all other types of cudaExternalSemaphore_t, flags must be zero.
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaExternalSemaphoreSignalParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._params = anon_struct12(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['params :\n' + '\n'.join(['    ' + line for line in str(self.params).splitlines()])]
            except ValueError:
                str_list += ['params : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def params(self):
        return self._params
    @params.setter
    def params(self, params not None : anon_struct12):
        string.memcpy(&self._pvt_ptr[0].params, <cyruntime.anon_struct12*><void_ptr>params.getPtr(), sizeof(self._pvt_ptr[0].params))
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class anon_struct13:
    """
    Attributes
    ----------
    value : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaExternalSemaphoreWaitParams *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params.fence
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['value : ' + str(self.value)]
            except ValueError:
                str_list += ['value : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def value(self):
        return self._pvt_ptr[0].params.fence.value
    @value.setter
    def value(self, unsigned long long value):
        self._pvt_ptr[0].params.fence.value = value

cdef class anon_union5:
    """
    Attributes
    ----------
    fence : Any

    reserved : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaExternalSemaphoreWaitParams *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params.nvSciSync
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fence : ' + hex(self.fence)]
            except ValueError:
                str_list += ['fence : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fence(self):
        return <void_ptr>self._pvt_ptr[0].params.nvSciSync.fence
    @fence.setter
    def fence(self, fence):
        _cfence = _HelperInputVoidPtr(fence)
        self._pvt_ptr[0].params.nvSciSync.fence = <void*><void_ptr>_cfence.cptr
    @property
    def reserved(self):
        return self._pvt_ptr[0].params.nvSciSync.reserved
    @reserved.setter
    def reserved(self, unsigned long long reserved):
        self._pvt_ptr[0].params.nvSciSync.reserved = reserved

cdef class anon_struct14:
    """
    Attributes
    ----------
    key : unsigned long long

    timeoutMs : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaExternalSemaphoreWaitParams *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params.keyedMutex
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['key : ' + str(self.key)]
            except ValueError:
                str_list += ['key : <ValueError>']
            try:
                str_list += ['timeoutMs : ' + str(self.timeoutMs)]
            except ValueError:
                str_list += ['timeoutMs : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def key(self):
        return self._pvt_ptr[0].params.keyedMutex.key
    @key.setter
    def key(self, unsigned long long key):
        self._pvt_ptr[0].params.keyedMutex.key = key
    @property
    def timeoutMs(self):
        return self._pvt_ptr[0].params.keyedMutex.timeoutMs
    @timeoutMs.setter
    def timeoutMs(self, unsigned int timeoutMs):
        self._pvt_ptr[0].params.keyedMutex.timeoutMs = timeoutMs

cdef class anon_struct15:
    """
    Attributes
    ----------
    fence : anon_struct13

    nvSciSync : anon_union5

    keyedMutex : anon_struct14

    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaExternalSemaphoreWaitParams *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._fence = anon_struct13(_ptr=<void_ptr>self._pvt_ptr)
        self._nvSciSync = anon_union5(_ptr=<void_ptr>self._pvt_ptr)
        self._keyedMutex = anon_struct14(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].params
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['fence :\n' + '\n'.join(['    ' + line for line in str(self.fence).splitlines()])]
            except ValueError:
                str_list += ['fence : <ValueError>']
            try:
                str_list += ['nvSciSync :\n' + '\n'.join(['    ' + line for line in str(self.nvSciSync).splitlines()])]
            except ValueError:
                str_list += ['nvSciSync : <ValueError>']
            try:
                str_list += ['keyedMutex :\n' + '\n'.join(['    ' + line for line in str(self.keyedMutex).splitlines()])]
            except ValueError:
                str_list += ['keyedMutex : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def fence(self):
        return self._fence
    @fence.setter
    def fence(self, fence not None : anon_struct13):
        string.memcpy(&self._pvt_ptr[0].params.fence, <cyruntime.anon_struct13*><void_ptr>fence.getPtr(), sizeof(self._pvt_ptr[0].params.fence))
    @property
    def nvSciSync(self):
        return self._nvSciSync
    @nvSciSync.setter
    def nvSciSync(self, nvSciSync not None : anon_union5):
        string.memcpy(&self._pvt_ptr[0].params.nvSciSync, <cyruntime.anon_union5*><void_ptr>nvSciSync.getPtr(), sizeof(self._pvt_ptr[0].params.nvSciSync))
    @property
    def keyedMutex(self):
        return self._keyedMutex
    @keyedMutex.setter
    def keyedMutex(self, keyedMutex not None : anon_struct14):
        string.memcpy(&self._pvt_ptr[0].params.keyedMutex, <cyruntime.anon_struct14*><void_ptr>keyedMutex.getPtr(), sizeof(self._pvt_ptr[0].params.keyedMutex))
    @property
    def reserved(self):
        return self._pvt_ptr[0].params.reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].params.reserved = reserved

cdef class cudaExternalSemaphoreWaitParams:
    """
    External semaphore wait parameters, compatible with driver type

    Attributes
    ----------
    params : anon_struct15

    flags : unsigned int
        Only when cudaExternalSemaphoreSignalParams is used to signal a
        cudaExternalSemaphore_t of type
        cudaExternalSemaphoreHandleTypeNvSciSync, the valid flag is
        cudaExternalSemaphoreSignalSkipNvSciBufMemSync: which indicates
        that while waiting for the cudaExternalSemaphore_t, no memory
        synchronization operations should be performed for any external
        memory object imported as cudaExternalMemoryHandleTypeNvSciBuf. For
        all other types of cudaExternalSemaphore_t, flags must be zero.
    reserved : list[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaExternalSemaphoreWaitParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._params = anon_struct15(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['params :\n' + '\n'.join(['    ' + line for line in str(self.params).splitlines()])]
            except ValueError:
                str_list += ['params : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def params(self):
        return self._params
    @params.setter
    def params(self, params not None : anon_struct15):
        string.memcpy(&self._pvt_ptr[0].params, <cyruntime.anon_struct15*><void_ptr>params.getPtr(), sizeof(self._pvt_ptr[0].params))
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class cudaDevSmResource:
    """
    Data for SM-related resources All parameters in this structure are
    OUTPUT only. Do not write to any of the fields in this structure.

    Attributes
    ----------
    smCount : unsigned int
        The amount of streaming multiprocessors available in this resource.
    minSmPartitionSize : unsigned int
        The minimum number of streaming multiprocessors required to
        partition this resource.
    smCoscheduledAlignment : unsigned int
        The number of streaming multiprocessors in this resource that are
        guaranteed to be co-scheduled on the same GPU processing cluster.
        smCount will be a multiple of this value, unless the backfill flag
        is set.
    flags : unsigned int
        The flags set on this SM resource. For available flags see
        ::cudaDevSmResourceGroup_flags.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaDevSmResource *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['smCount : ' + str(self.smCount)]
            except ValueError:
                str_list += ['smCount : <ValueError>']
            try:
                str_list += ['minSmPartitionSize : ' + str(self.minSmPartitionSize)]
            except ValueError:
                str_list += ['minSmPartitionSize : <ValueError>']
            try:
                str_list += ['smCoscheduledAlignment : ' + str(self.smCoscheduledAlignment)]
            except ValueError:
                str_list += ['smCoscheduledAlignment : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def smCount(self):
        return self._pvt_ptr[0].smCount
    @smCount.setter
    def smCount(self, unsigned int smCount):
        self._pvt_ptr[0].smCount = smCount
    @property
    def minSmPartitionSize(self):
        return self._pvt_ptr[0].minSmPartitionSize
    @minSmPartitionSize.setter
    def minSmPartitionSize(self, unsigned int minSmPartitionSize):
        self._pvt_ptr[0].minSmPartitionSize = minSmPartitionSize
    @property
    def smCoscheduledAlignment(self):
        return self._pvt_ptr[0].smCoscheduledAlignment
    @smCoscheduledAlignment.setter
    def smCoscheduledAlignment(self, unsigned int smCoscheduledAlignment):
        self._pvt_ptr[0].smCoscheduledAlignment = smCoscheduledAlignment
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags

cdef class cudaDevWorkqueueConfigResource:
    """
    Data for workqueue configuration related resources

    Attributes
    ----------
    device : int
        The device on which the workqueue resources are available
    wqConcurrencyLimit : unsigned int
        The expected maximum number of concurrent stream-ordered workloads
    sharingScope : cudaDevWorkqueueConfigScope
        The sharing scope for the workqueue resources

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaDevWorkqueueConfigResource *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['device : ' + str(self.device)]
            except ValueError:
                str_list += ['device : <ValueError>']
            try:
                str_list += ['wqConcurrencyLimit : ' + str(self.wqConcurrencyLimit)]
            except ValueError:
                str_list += ['wqConcurrencyLimit : <ValueError>']
            try:
                str_list += ['sharingScope : ' + str(self.sharingScope)]
            except ValueError:
                str_list += ['sharingScope : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def device(self):
        return self._pvt_ptr[0].device
    @device.setter
    def device(self, int device):
        self._pvt_ptr[0].device = device
    @property
    def wqConcurrencyLimit(self):
        return self._pvt_ptr[0].wqConcurrencyLimit
    @wqConcurrencyLimit.setter
    def wqConcurrencyLimit(self, unsigned int wqConcurrencyLimit):
        self._pvt_ptr[0].wqConcurrencyLimit = wqConcurrencyLimit
    @property
    def sharingScope(self):
        if self._pvt_ptr[0].sharingScope not in _dict_cudaDevWorkqueueConfigScope:
            return None
        return _dict_cudaDevWorkqueueConfigScope[self._pvt_ptr[0].sharingScope]
    @sharingScope.setter
    def sharingScope(self, sharingScope not None : cudaDevWorkqueueConfigScope):
        self._pvt_ptr[0].sharingScope = sharingScope.value

cdef class cudaDevWorkqueueResource:
    """
    Handle to a pre-existing workqueue related resource

    Attributes
    ----------
    reserved : bytes
        Reserved for future use

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaDevWorkqueueResource *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0].reserved, 40)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 40:
            raise ValueError("reserved length must be 40, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            self._pvt_ptr[0].reserved[i] = b

cdef class cudaDevSmResourceGroupParams_st:
    """
    Input data for splitting SMs

    Attributes
    ----------
    smCount : unsigned int
        The amount of SMs available in this resource.
    coscheduledSmCount : unsigned int
        The amount of co-scheduled SMs grouped together for locality
        purposes.
    preferredCoscheduledSmCount : unsigned int
        When possible, combine co-scheduled groups together into larger
        groups of this size.
    flags : unsigned int
        Combination of `cudaDevSmResourceGroup_flags` values to indicate
        this this group is created.
    reserved : list[unsigned int]
        Reserved for future use - ensure this is is zero initialized.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaDevSmResourceGroupParams_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['smCount : ' + str(self.smCount)]
            except ValueError:
                str_list += ['smCount : <ValueError>']
            try:
                str_list += ['coscheduledSmCount : ' + str(self.coscheduledSmCount)]
            except ValueError:
                str_list += ['coscheduledSmCount : <ValueError>']
            try:
                str_list += ['preferredCoscheduledSmCount : ' + str(self.preferredCoscheduledSmCount)]
            except ValueError:
                str_list += ['preferredCoscheduledSmCount : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def smCount(self):
        return self._pvt_ptr[0].smCount
    @smCount.setter
    def smCount(self, unsigned int smCount):
        self._pvt_ptr[0].smCount = smCount
    @property
    def coscheduledSmCount(self):
        return self._pvt_ptr[0].coscheduledSmCount
    @coscheduledSmCount.setter
    def coscheduledSmCount(self, unsigned int coscheduledSmCount):
        self._pvt_ptr[0].coscheduledSmCount = coscheduledSmCount
    @property
    def preferredCoscheduledSmCount(self):
        return self._pvt_ptr[0].preferredCoscheduledSmCount
    @preferredCoscheduledSmCount.setter
    def preferredCoscheduledSmCount(self, unsigned int preferredCoscheduledSmCount):
        self._pvt_ptr[0].preferredCoscheduledSmCount = preferredCoscheduledSmCount
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        self._pvt_ptr[0].flags = flags
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class cudaDevResource_st:
    """
    A tagged union describing different resources identified by the
    type field. This structure should not be directly modified outside
    of the API that created it. struct enumcudaDevResourceTypetype;
    union structcudaDevSmResourcesm;
    structcudaDevWorkqueueConfigResourcewqConfig;
    structcudaDevWorkqueueResourcewq; ; ;  - If `typename` is
    `cudaDevResourceTypeInvalid`, this resoure is not valid and cannot
    be further accessed.    - If `typename` is `cudaDevResourceTypeSm`,
    the cudaDevSmResource structure `sm` is filled in. For example,
    `sm.smCount` will reflect the amount of streaming multiprocessors
    available in this resource.    - If `typename` is
    `cudaDevResourceTypeWorkqueueConfig`, the
    cudaDevWorkqueueConfigResource structure `wqConfig` is filled in.
    - If `typename` is `cudaDevResourceTypeWorkqueue`, the
    cudaDevWorkqueueResource structure `wq` is filled in.

    Attributes
    ----------
    type : cudaDevResourceType
        Type of resource, dictates which union field was last set
    _internal_padding : bytes

    sm : cudaDevSmResource
        Resource corresponding to cudaDevResourceTypeSm `typename`.
    wqConfig : cudaDevWorkqueueConfigResource
        Resource corresponding to cudaDevResourceTypeWorkqueueConfig
        `typename`.
    wq : cudaDevWorkqueueResource
        Resource corresponding to cudaDevResourceTypeWorkqueue `typename`.
    _oversize : bytes

    nextResource : cudaDevResource_st


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cyruntime.cudaDevResource_st *>calloc(1, sizeof(cyruntime.cudaDevResource_st))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cyruntime.cudaDevResource_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._sm = cudaDevSmResource(_ptr=<void_ptr>&self._pvt_ptr[0].sm)
        self._wqConfig = cudaDevWorkqueueConfigResource(_ptr=<void_ptr>&self._pvt_ptr[0].wqConfig)
        self._wq = cudaDevWorkqueueResource(_ptr=<void_ptr>&self._pvt_ptr[0].wq)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
        if self._nextResource is not NULL:
            free(self._nextResource)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['_internal_padding : ' + str(self._internal_padding)]
            except ValueError:
                str_list += ['_internal_padding : <ValueError>']
            try:
                str_list += ['sm :\n' + '\n'.join(['    ' + line for line in str(self.sm).splitlines()])]
            except ValueError:
                str_list += ['sm : <ValueError>']
            try:
                str_list += ['wqConfig :\n' + '\n'.join(['    ' + line for line in str(self.wqConfig).splitlines()])]
            except ValueError:
                str_list += ['wqConfig : <ValueError>']
            try:
                str_list += ['wq :\n' + '\n'.join(['    ' + line for line in str(self.wq).splitlines()])]
            except ValueError:
                str_list += ['wq : <ValueError>']
            try:
                str_list += ['_oversize : ' + str(self._oversize)]
            except ValueError:
                str_list += ['_oversize : <ValueError>']
            try:
                str_list += ['nextResource : ' + str(self.nextResource)]
            except ValueError:
                str_list += ['nextResource : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_cudaDevResourceType:
            return None
        return _dict_cudaDevResourceType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : cudaDevResourceType):
        self._pvt_ptr[0].type = type.value
    @property
    def _internal_padding(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0]._internal_padding, 92)
    @_internal_padding.setter
    def _internal_padding(self, _internal_padding):
        if len(_internal_padding) != 92:
            raise ValueError("_internal_padding length must be 92, is " + str(len(_internal_padding)))
        for i, b in enumerate(_internal_padding):
            self._pvt_ptr[0]._internal_padding[i] = b
    @property
    def sm(self):
        return self._sm
    @sm.setter
    def sm(self, sm not None : cudaDevSmResource):
        string.memcpy(&self._pvt_ptr[0].sm, <cyruntime.cudaDevSmResource*><void_ptr>sm.getPtr(), sizeof(self._pvt_ptr[0].sm))
    @property
    def wqConfig(self):
        return self._wqConfig
    @wqConfig.setter
    def wqConfig(self, wqConfig not None : cudaDevWorkqueueConfigResource):
        string.memcpy(&self._pvt_ptr[0].wqConfig, <cyruntime.cudaDevWorkqueueConfigResource*><void_ptr>wqConfig.getPtr(), sizeof(self._pvt_ptr[0].wqConfig))
    @property
    def wq(self):
        return self._wq
    @wq.setter
    def wq(self, wq not None : cudaDevWorkqueueResource):
        string.memcpy(&self._pvt_ptr[0].wq, <cyruntime.cudaDevWorkqueueResource*><void_ptr>wq.getPtr(), sizeof(self._pvt_ptr[0].wq))
    @property
    def _oversize(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0]._oversize, 40)
    @_oversize.setter
    def _oversize(self, _oversize):
        if len(_oversize) != 40:
            raise ValueError("_oversize length must be 40, is " + str(len(_oversize)))
        for i, b in enumerate(_oversize):
            self._pvt_ptr[0]._oversize[i] = b
    @property
    def nextResource(self):
        arrs = [<void_ptr>self._pvt_ptr[0].nextResource + x*sizeof(cyruntime.cudaDevResource_st) for x in range(self._nextResource_length)]
        return [cudaDevResource_st(_ptr=arr) for arr in arrs]
    @nextResource.setter
    def nextResource(self, val):
        if len(val) == 0:
            free(self._nextResource)
            self._nextResource_length = 0
            self._pvt_ptr[0].nextResource = NULL
        else:
            if self._nextResource_length != <size_t>len(val):
                free(self._nextResource)
                self._nextResource = <cyruntime.cudaDevResource_st*> calloc(len(val), sizeof(cyruntime.cudaDevResource_st))
                if self._nextResource is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cyruntime.cudaDevResource_st)))
                self._nextResource_length = <size_t>len(val)
                self._pvt_ptr[0].nextResource = self._nextResource
            for idx in range(len(val)):
                string.memcpy(&self._nextResource[idx], (<cudaDevResource_st>val[idx])._pvt_ptr, sizeof(cyruntime.cudaDevResource_st))


cdef class cudalibraryHostUniversalFunctionAndDataTable:
    """
    Attributes
    ----------
    functionTable : Any

    functionWindowSize : size_t

    dataTable : Any

    dataWindowSize : size_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudalibraryHostUniversalFunctionAndDataTable *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['functionTable : ' + hex(self.functionTable)]
            except ValueError:
                str_list += ['functionTable : <ValueError>']
            try:
                str_list += ['functionWindowSize : ' + str(self.functionWindowSize)]
            except ValueError:
                str_list += ['functionWindowSize : <ValueError>']
            try:
                str_list += ['dataTable : ' + hex(self.dataTable)]
            except ValueError:
                str_list += ['dataTable : <ValueError>']
            try:
                str_list += ['dataWindowSize : ' + str(self.dataWindowSize)]
            except ValueError:
                str_list += ['dataWindowSize : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def functionTable(self):
        return <void_ptr>self._pvt_ptr[0].functionTable
    @functionTable.setter
    def functionTable(self, functionTable):
        _cfunctionTable = _HelperInputVoidPtr(functionTable)
        self._pvt_ptr[0].functionTable = <void*><void_ptr>_cfunctionTable.cptr
    @property
    def functionWindowSize(self):
        return self._pvt_ptr[0].functionWindowSize
    @functionWindowSize.setter
    def functionWindowSize(self, size_t functionWindowSize):
        self._pvt_ptr[0].functionWindowSize = functionWindowSize
    @property
    def dataTable(self):
        return <void_ptr>self._pvt_ptr[0].dataTable
    @dataTable.setter
    def dataTable(self, dataTable):
        _cdataTable = _HelperInputVoidPtr(dataTable)
        self._pvt_ptr[0].dataTable = <void*><void_ptr>_cdataTable.cptr
    @property
    def dataWindowSize(self):
        return self._pvt_ptr[0].dataWindowSize
    @dataWindowSize.setter
    def dataWindowSize(self, size_t dataWindowSize):
        self._pvt_ptr[0].dataWindowSize = dataWindowSize

cdef class cudaKernelNodeParams:
    """
    CUDA GPU kernel node parameters

    Attributes
    ----------
    func : Any
        Kernel to launch
    gridDim : dim3
        Grid dimensions
    blockDim : dim3
        Block dimensions
    sharedMemBytes : unsigned int
        Dynamic shared-memory size per thread block in bytes
    kernelParams : Any
        Array of pointers to individual kernel arguments
    extra : Any
        Pointer to kernel arguments in the "extra" format

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaKernelNodeParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._gridDim = dim3(_ptr=<void_ptr>&self._pvt_ptr[0].gridDim)
        self._blockDim = dim3(_ptr=<void_ptr>&self._pvt_ptr[0].blockDim)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['func : ' + hex(self.func)]
            except ValueError:
                str_list += ['func : <ValueError>']
            try:
                str_list += ['gridDim :\n' + '\n'.join(['    ' + line for line in str(self.gridDim).splitlines()])]
            except ValueError:
                str_list += ['gridDim : <ValueError>']
            try:
                str_list += ['blockDim :\n' + '\n'.join(['    ' + line for line in str(self.blockDim).splitlines()])]
            except ValueError:
                str_list += ['blockDim : <ValueError>']
            try:
                str_list += ['sharedMemBytes : ' + str(self.sharedMemBytes)]
            except ValueError:
                str_list += ['sharedMemBytes : <ValueError>']
            try:
                str_list += ['kernelParams : ' + str(self.kernelParams)]
            except ValueError:
                str_list += ['kernelParams : <ValueError>']
            try:
                str_list += ['extra : ' + str(self.extra)]
            except ValueError:
                str_list += ['extra : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def func(self):
        return <void_ptr>self._pvt_ptr[0].func
    @func.setter
    def func(self, func):
        _cfunc = _HelperInputVoidPtr(func)
        self._pvt_ptr[0].func = <void*><void_ptr>_cfunc.cptr
    @property
    def gridDim(self):
        return self._gridDim
    @gridDim.setter
    def gridDim(self, gridDim not None : dim3):
        string.memcpy(&self._pvt_ptr[0].gridDim, <cyruntime.dim3*><void_ptr>gridDim.getPtr(), sizeof(self._pvt_ptr[0].gridDim))
    @property
    def blockDim(self):
        return self._blockDim
    @blockDim.setter
    def blockDim(self, blockDim not None : dim3):
        string.memcpy(&self._pvt_ptr[0].blockDim, <cyruntime.dim3*><void_ptr>blockDim.getPtr(), sizeof(self._pvt_ptr[0].blockDim))
    @property
    def sharedMemBytes(self):
        return self._pvt_ptr[0].sharedMemBytes
    @sharedMemBytes.setter
    def sharedMemBytes(self, unsigned int sharedMemBytes):
        self._pvt_ptr[0].sharedMemBytes = sharedMemBytes
    @property
    def kernelParams(self):
        return <void_ptr>self._pvt_ptr[0].kernelParams
    @kernelParams.setter
    def kernelParams(self, kernelParams):
        self._cykernelParams = _HelperKernelParams(kernelParams)
        self._pvt_ptr[0].kernelParams = <void**><void_ptr>self._cykernelParams.ckernelParams
    @property
    def extra(self):
        return <void_ptr>self._pvt_ptr[0].extra
    @extra.setter
    def extra(self, void_ptr extra):
        self._pvt_ptr[0].extra = <void**>extra

cdef class cudaKernelNodeParamsV2:
    """
    CUDA GPU kernel node parameters

    Attributes
    ----------
    func : Any
        Kernel to launch
    gridDim : dim3
        Grid dimensions
    blockDim : dim3
        Block dimensions
    sharedMemBytes : unsigned int
        Dynamic shared-memory size per thread block in bytes
    kernelParams : Any
        Array of pointers to individual kernel arguments
    extra : Any
        Pointer to kernel arguments in the "extra" format
    ctx : cudaExecutionContext_t
        Context in which to run the kernel. If NULL will try to use the
        current context.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaKernelNodeParamsV2 *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._gridDim = dim3(_ptr=<void_ptr>&self._pvt_ptr[0].gridDim)
        self._blockDim = dim3(_ptr=<void_ptr>&self._pvt_ptr[0].blockDim)
        self._ctx = cudaExecutionContext_t(_ptr=<void_ptr>&self._pvt_ptr[0].ctx)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['func : ' + hex(self.func)]
            except ValueError:
                str_list += ['func : <ValueError>']
            try:
                str_list += ['gridDim :\n' + '\n'.join(['    ' + line for line in str(self.gridDim).splitlines()])]
            except ValueError:
                str_list += ['gridDim : <ValueError>']
            try:
                str_list += ['blockDim :\n' + '\n'.join(['    ' + line for line in str(self.blockDim).splitlines()])]
            except ValueError:
                str_list += ['blockDim : <ValueError>']
            try:
                str_list += ['sharedMemBytes : ' + str(self.sharedMemBytes)]
            except ValueError:
                str_list += ['sharedMemBytes : <ValueError>']
            try:
                str_list += ['kernelParams : ' + str(self.kernelParams)]
            except ValueError:
                str_list += ['kernelParams : <ValueError>']
            try:
                str_list += ['extra : ' + str(self.extra)]
            except ValueError:
                str_list += ['extra : <ValueError>']
            try:
                str_list += ['ctx : ' + str(self.ctx)]
            except ValueError:
                str_list += ['ctx : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def func(self):
        return <void_ptr>self._pvt_ptr[0].func
    @func.setter
    def func(self, func):
        _cfunc = _HelperInputVoidPtr(func)
        self._pvt_ptr[0].func = <void*><void_ptr>_cfunc.cptr
    @property
    def gridDim(self):
        return self._gridDim
    @gridDim.setter
    def gridDim(self, gridDim not None : dim3):
        string.memcpy(&self._pvt_ptr[0].gridDim, <cyruntime.dim3*><void_ptr>gridDim.getPtr(), sizeof(self._pvt_ptr[0].gridDim))
    @property
    def blockDim(self):
        return self._blockDim
    @blockDim.setter
    def blockDim(self, blockDim not None : dim3):
        string.memcpy(&self._pvt_ptr[0].blockDim, <cyruntime.dim3*><void_ptr>blockDim.getPtr(), sizeof(self._pvt_ptr[0].blockDim))
    @property
    def sharedMemBytes(self):
        return self._pvt_ptr[0].sharedMemBytes
    @sharedMemBytes.setter
    def sharedMemBytes(self, unsigned int sharedMemBytes):
        self._pvt_ptr[0].sharedMemBytes = sharedMemBytes
    @property
    def kernelParams(self):
        return <void_ptr>self._pvt_ptr[0].kernelParams
    @kernelParams.setter
    def kernelParams(self, kernelParams):
        self._cykernelParams = _HelperKernelParams(kernelParams)
        self._pvt_ptr[0].kernelParams = <void**><void_ptr>self._cykernelParams.ckernelParams
    @property
    def extra(self):
        return <void_ptr>self._pvt_ptr[0].extra
    @extra.setter
    def extra(self, void_ptr extra):
        self._pvt_ptr[0].extra = <void**>extra
    @property
    def ctx(self):
        return self._ctx
    @ctx.setter
    def ctx(self, ctx):
        cdef cyruntime.cudaExecutionContext_t cyctx
        if ctx is None:
            cyctx = <cyruntime.cudaExecutionContext_t><void_ptr>0
        elif isinstance(ctx, (cudaExecutionContext_t,)):
            pctx = int(ctx)
            cyctx = <cyruntime.cudaExecutionContext_t><void_ptr>pctx
        else:
            pctx = int(cudaExecutionContext_t(ctx))
            cyctx = <cyruntime.cudaExecutionContext_t><void_ptr>pctx
        self._ctx._pvt_ptr[0] = cyctx

cdef class cudaExternalSemaphoreSignalNodeParams:
    """
    External semaphore signal node parameters

    Attributes
    ----------
    extSemArray : cudaExternalSemaphore_t
        Array of external semaphore handles.
    paramsArray : cudaExternalSemaphoreSignalParams
        Array of external semaphore signal parameters.
    numExtSems : unsigned int
        Number of handles and parameters supplied in extSemArray and
        paramsArray.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaExternalSemaphoreSignalNodeParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
        if self._extSemArray is not NULL:
            free(self._extSemArray)
        if self._paramsArray is not NULL:
            free(self._paramsArray)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['extSemArray : ' + str(self.extSemArray)]
            except ValueError:
                str_list += ['extSemArray : <ValueError>']
            try:
                str_list += ['paramsArray : ' + str(self.paramsArray)]
            except ValueError:
                str_list += ['paramsArray : <ValueError>']
            try:
                str_list += ['numExtSems : ' + str(self.numExtSems)]
            except ValueError:
                str_list += ['numExtSems : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def extSemArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].extSemArray + x*sizeof(cyruntime.cudaExternalSemaphore_t) for x in range(self._extSemArray_length)]
        return [cudaExternalSemaphore_t(_ptr=arr) for arr in arrs]
    @extSemArray.setter
    def extSemArray(self, val):
        if len(val) == 0:
            free(self._extSemArray)
            self._extSemArray_length = 0
            self._pvt_ptr[0].extSemArray = NULL
        else:
            if self._extSemArray_length != <size_t>len(val):
                free(self._extSemArray)
                self._extSemArray = <cyruntime.cudaExternalSemaphore_t*> calloc(len(val), sizeof(cyruntime.cudaExternalSemaphore_t))
                if self._extSemArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cyruntime.cudaExternalSemaphore_t)))
                self._extSemArray_length = <size_t>len(val)
                self._pvt_ptr[0].extSemArray = self._extSemArray
            for idx in range(len(val)):
                self._extSemArray[idx] = (<cudaExternalSemaphore_t>val[idx])._pvt_ptr[0]

    @property
    def paramsArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].paramsArray + x*sizeof(cyruntime.cudaExternalSemaphoreSignalParams) for x in range(self._paramsArray_length)]
        return [cudaExternalSemaphoreSignalParams(_ptr=arr) for arr in arrs]
    @paramsArray.setter
    def paramsArray(self, val):
        if len(val) == 0:
            free(self._paramsArray)
            self._paramsArray_length = 0
            self._pvt_ptr[0].paramsArray = NULL
        else:
            if self._paramsArray_length != <size_t>len(val):
                free(self._paramsArray)
                self._paramsArray = <cyruntime.cudaExternalSemaphoreSignalParams*> calloc(len(val), sizeof(cyruntime.cudaExternalSemaphoreSignalParams))
                if self._paramsArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cyruntime.cudaExternalSemaphoreSignalParams)))
                self._paramsArray_length = <size_t>len(val)
                self._pvt_ptr[0].paramsArray = self._paramsArray
            for idx in range(len(val)):
                string.memcpy(&self._paramsArray[idx], (<cudaExternalSemaphoreSignalParams>val[idx])._pvt_ptr, sizeof(cyruntime.cudaExternalSemaphoreSignalParams))

    @property
    def numExtSems(self):
        return self._pvt_ptr[0].numExtSems
    @numExtSems.setter
    def numExtSems(self, unsigned int numExtSems):
        self._pvt_ptr[0].numExtSems = numExtSems

cdef class cudaExternalSemaphoreSignalNodeParamsV2:
    """
    External semaphore signal node parameters

    Attributes
    ----------
    extSemArray : cudaExternalSemaphore_t
        Array of external semaphore handles.
    paramsArray : cudaExternalSemaphoreSignalParams
        Array of external semaphore signal parameters.
    numExtSems : unsigned int
        Number of handles and parameters supplied in extSemArray and
        paramsArray.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaExternalSemaphoreSignalNodeParamsV2 *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
        if self._extSemArray is not NULL:
            free(self._extSemArray)
        if self._paramsArray is not NULL:
            free(self._paramsArray)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['extSemArray : ' + str(self.extSemArray)]
            except ValueError:
                str_list += ['extSemArray : <ValueError>']
            try:
                str_list += ['paramsArray : ' + str(self.paramsArray)]
            except ValueError:
                str_list += ['paramsArray : <ValueError>']
            try:
                str_list += ['numExtSems : ' + str(self.numExtSems)]
            except ValueError:
                str_list += ['numExtSems : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def extSemArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].extSemArray + x*sizeof(cyruntime.cudaExternalSemaphore_t) for x in range(self._extSemArray_length)]
        return [cudaExternalSemaphore_t(_ptr=arr) for arr in arrs]
    @extSemArray.setter
    def extSemArray(self, val):
        if len(val) == 0:
            free(self._extSemArray)
            self._extSemArray_length = 0
            self._pvt_ptr[0].extSemArray = NULL
        else:
            if self._extSemArray_length != <size_t>len(val):
                free(self._extSemArray)
                self._extSemArray = <cyruntime.cudaExternalSemaphore_t*> calloc(len(val), sizeof(cyruntime.cudaExternalSemaphore_t))
                if self._extSemArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cyruntime.cudaExternalSemaphore_t)))
                self._extSemArray_length = <size_t>len(val)
                self._pvt_ptr[0].extSemArray = self._extSemArray
            for idx in range(len(val)):
                self._extSemArray[idx] = (<cudaExternalSemaphore_t>val[idx])._pvt_ptr[0]

    @property
    def paramsArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].paramsArray + x*sizeof(cyruntime.cudaExternalSemaphoreSignalParams) for x in range(self._paramsArray_length)]
        return [cudaExternalSemaphoreSignalParams(_ptr=arr) for arr in arrs]
    @paramsArray.setter
    def paramsArray(self, val):
        if len(val) == 0:
            free(self._paramsArray)
            self._paramsArray_length = 0
            self._pvt_ptr[0].paramsArray = NULL
        else:
            if self._paramsArray_length != <size_t>len(val):
                free(self._paramsArray)
                self._paramsArray = <cyruntime.cudaExternalSemaphoreSignalParams*> calloc(len(val), sizeof(cyruntime.cudaExternalSemaphoreSignalParams))
                if self._paramsArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cyruntime.cudaExternalSemaphoreSignalParams)))
                self._paramsArray_length = <size_t>len(val)
                self._pvt_ptr[0].paramsArray = self._paramsArray
            for idx in range(len(val)):
                string.memcpy(&self._paramsArray[idx], (<cudaExternalSemaphoreSignalParams>val[idx])._pvt_ptr, sizeof(cyruntime.cudaExternalSemaphoreSignalParams))

    @property
    def numExtSems(self):
        return self._pvt_ptr[0].numExtSems
    @numExtSems.setter
    def numExtSems(self, unsigned int numExtSems):
        self._pvt_ptr[0].numExtSems = numExtSems

cdef class cudaExternalSemaphoreWaitNodeParams:
    """
    External semaphore wait node parameters

    Attributes
    ----------
    extSemArray : cudaExternalSemaphore_t
        Array of external semaphore handles.
    paramsArray : cudaExternalSemaphoreWaitParams
        Array of external semaphore wait parameters.
    numExtSems : unsigned int
        Number of handles and parameters supplied in extSemArray and
        paramsArray.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaExternalSemaphoreWaitNodeParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
        if self._extSemArray is not NULL:
            free(self._extSemArray)
        if self._paramsArray is not NULL:
            free(self._paramsArray)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['extSemArray : ' + str(self.extSemArray)]
            except ValueError:
                str_list += ['extSemArray : <ValueError>']
            try:
                str_list += ['paramsArray : ' + str(self.paramsArray)]
            except ValueError:
                str_list += ['paramsArray : <ValueError>']
            try:
                str_list += ['numExtSems : ' + str(self.numExtSems)]
            except ValueError:
                str_list += ['numExtSems : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def extSemArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].extSemArray + x*sizeof(cyruntime.cudaExternalSemaphore_t) for x in range(self._extSemArray_length)]
        return [cudaExternalSemaphore_t(_ptr=arr) for arr in arrs]
    @extSemArray.setter
    def extSemArray(self, val):
        if len(val) == 0:
            free(self._extSemArray)
            self._extSemArray_length = 0
            self._pvt_ptr[0].extSemArray = NULL
        else:
            if self._extSemArray_length != <size_t>len(val):
                free(self._extSemArray)
                self._extSemArray = <cyruntime.cudaExternalSemaphore_t*> calloc(len(val), sizeof(cyruntime.cudaExternalSemaphore_t))
                if self._extSemArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cyruntime.cudaExternalSemaphore_t)))
                self._extSemArray_length = <size_t>len(val)
                self._pvt_ptr[0].extSemArray = self._extSemArray
            for idx in range(len(val)):
                self._extSemArray[idx] = (<cudaExternalSemaphore_t>val[idx])._pvt_ptr[0]

    @property
    def paramsArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].paramsArray + x*sizeof(cyruntime.cudaExternalSemaphoreWaitParams) for x in range(self._paramsArray_length)]
        return [cudaExternalSemaphoreWaitParams(_ptr=arr) for arr in arrs]
    @paramsArray.setter
    def paramsArray(self, val):
        if len(val) == 0:
            free(self._paramsArray)
            self._paramsArray_length = 0
            self._pvt_ptr[0].paramsArray = NULL
        else:
            if self._paramsArray_length != <size_t>len(val):
                free(self._paramsArray)
                self._paramsArray = <cyruntime.cudaExternalSemaphoreWaitParams*> calloc(len(val), sizeof(cyruntime.cudaExternalSemaphoreWaitParams))
                if self._paramsArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cyruntime.cudaExternalSemaphoreWaitParams)))
                self._paramsArray_length = <size_t>len(val)
                self._pvt_ptr[0].paramsArray = self._paramsArray
            for idx in range(len(val)):
                string.memcpy(&self._paramsArray[idx], (<cudaExternalSemaphoreWaitParams>val[idx])._pvt_ptr, sizeof(cyruntime.cudaExternalSemaphoreWaitParams))

    @property
    def numExtSems(self):
        return self._pvt_ptr[0].numExtSems
    @numExtSems.setter
    def numExtSems(self, unsigned int numExtSems):
        self._pvt_ptr[0].numExtSems = numExtSems

cdef class cudaExternalSemaphoreWaitNodeParamsV2:
    """
    External semaphore wait node parameters

    Attributes
    ----------
    extSemArray : cudaExternalSemaphore_t
        Array of external semaphore handles.
    paramsArray : cudaExternalSemaphoreWaitParams
        Array of external semaphore wait parameters.
    numExtSems : unsigned int
        Number of handles and parameters supplied in extSemArray and
        paramsArray.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaExternalSemaphoreWaitNodeParamsV2 *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
        if self._extSemArray is not NULL:
            free(self._extSemArray)
        if self._paramsArray is not NULL:
            free(self._paramsArray)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['extSemArray : ' + str(self.extSemArray)]
            except ValueError:
                str_list += ['extSemArray : <ValueError>']
            try:
                str_list += ['paramsArray : ' + str(self.paramsArray)]
            except ValueError:
                str_list += ['paramsArray : <ValueError>']
            try:
                str_list += ['numExtSems : ' + str(self.numExtSems)]
            except ValueError:
                str_list += ['numExtSems : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def extSemArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].extSemArray + x*sizeof(cyruntime.cudaExternalSemaphore_t) for x in range(self._extSemArray_length)]
        return [cudaExternalSemaphore_t(_ptr=arr) for arr in arrs]
    @extSemArray.setter
    def extSemArray(self, val):
        if len(val) == 0:
            free(self._extSemArray)
            self._extSemArray_length = 0
            self._pvt_ptr[0].extSemArray = NULL
        else:
            if self._extSemArray_length != <size_t>len(val):
                free(self._extSemArray)
                self._extSemArray = <cyruntime.cudaExternalSemaphore_t*> calloc(len(val), sizeof(cyruntime.cudaExternalSemaphore_t))
                if self._extSemArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cyruntime.cudaExternalSemaphore_t)))
                self._extSemArray_length = <size_t>len(val)
                self._pvt_ptr[0].extSemArray = self._extSemArray
            for idx in range(len(val)):
                self._extSemArray[idx] = (<cudaExternalSemaphore_t>val[idx])._pvt_ptr[0]

    @property
    def paramsArray(self):
        arrs = [<void_ptr>self._pvt_ptr[0].paramsArray + x*sizeof(cyruntime.cudaExternalSemaphoreWaitParams) for x in range(self._paramsArray_length)]
        return [cudaExternalSemaphoreWaitParams(_ptr=arr) for arr in arrs]
    @paramsArray.setter
    def paramsArray(self, val):
        if len(val) == 0:
            free(self._paramsArray)
            self._paramsArray_length = 0
            self._pvt_ptr[0].paramsArray = NULL
        else:
            if self._paramsArray_length != <size_t>len(val):
                free(self._paramsArray)
                self._paramsArray = <cyruntime.cudaExternalSemaphoreWaitParams*> calloc(len(val), sizeof(cyruntime.cudaExternalSemaphoreWaitParams))
                if self._paramsArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(cyruntime.cudaExternalSemaphoreWaitParams)))
                self._paramsArray_length = <size_t>len(val)
                self._pvt_ptr[0].paramsArray = self._paramsArray
            for idx in range(len(val)):
                string.memcpy(&self._paramsArray[idx], (<cudaExternalSemaphoreWaitParams>val[idx])._pvt_ptr, sizeof(cyruntime.cudaExternalSemaphoreWaitParams))

    @property
    def numExtSems(self):
        return self._pvt_ptr[0].numExtSems
    @numExtSems.setter
    def numExtSems(self, unsigned int numExtSems):
        self._pvt_ptr[0].numExtSems = numExtSems

cdef class cudaConditionalNodeParams:
    """
    CUDA conditional node parameters

    Attributes
    ----------
    handle : cudaGraphConditionalHandle
        Conditional node handle. Handles must be created in advance of
        creating the node using cudaGraphConditionalHandleCreate.
    type : cudaGraphConditionalNodeType
        Type of conditional node.
    size : unsigned int
        Size of graph output array. Allowed values are 1 for
        cudaGraphCondTypeWhile, 1 or 2 for cudaGraphCondTypeIf, or any
        value greater than zero for cudaGraphCondTypeSwitch.
    phGraph_out : cudaGraph_t
        CUDA-owned array populated with conditional node child graphs
        during creation of the node. Valid for the lifetime of the
        conditional node. The contents of the graph(s) are subject to the
        following constraints:   - Allowed node types are kernel nodes,
        empty nodes, child graphs, memsets, memcopies, and conditionals.
        This applies recursively to child graphs and conditional bodies.
        - All kernels, including kernels in nested conditionals or child
        graphs at any level, must belong to the same CUDA context.
        These graphs may be populated using graph node creation APIs or
        cudaStreamBeginCaptureToGraph. cudaGraphCondTypeIf: phGraph_out[0]
        is executed when the condition is non-zero. If `size` == 2,
        phGraph_out[1] will be executed when the condition is zero.
        cudaGraphCondTypeWhile: phGraph_out[0] is executed as long as the
        condition is non-zero. cudaGraphCondTypeSwitch: phGraph_out[n] is
        executed when the condition is equal to n. If the condition >=
        `size`, no body graph is executed.
    ctx : cudaExecutionContext_t
        CUDA Execution Context

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaConditionalNodeParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._handle = cudaGraphConditionalHandle(_ptr=<void_ptr>&self._pvt_ptr[0].handle)
        self._ctx = cudaExecutionContext_t(_ptr=<void_ptr>&self._pvt_ptr[0].ctx)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['handle : ' + str(self.handle)]
            except ValueError:
                str_list += ['handle : <ValueError>']
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['size : ' + str(self.size)]
            except ValueError:
                str_list += ['size : <ValueError>']
            try:
                str_list += ['phGraph_out : ' + str(self.phGraph_out)]
            except ValueError:
                str_list += ['phGraph_out : <ValueError>']
            try:
                str_list += ['ctx : ' + str(self.ctx)]
            except ValueError:
                str_list += ['ctx : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def handle(self):
        return self._handle
    @handle.setter
    def handle(self, handle):
        cdef cyruntime.cudaGraphConditionalHandle cyhandle
        if handle is None:
            cyhandle = <cyruntime.cudaGraphConditionalHandle><void_ptr>0
        elif isinstance(handle, (cudaGraphConditionalHandle)):
            phandle = int(handle)
            cyhandle = <cyruntime.cudaGraphConditionalHandle><void_ptr>phandle
        else:
            phandle = int(cudaGraphConditionalHandle(handle))
            cyhandle = <cyruntime.cudaGraphConditionalHandle><void_ptr>phandle
        self._handle._pvt_ptr[0] = cyhandle

    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_cudaGraphConditionalNodeType:
            return None
        return _dict_cudaGraphConditionalNodeType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : cudaGraphConditionalNodeType):
        self._pvt_ptr[0].type = type.value
    @property
    def size(self):
        return self._pvt_ptr[0].size
    @size.setter
    def size(self, unsigned int size):
        self._pvt_ptr[0].size = size
    @property
    def phGraph_out(self):
        arrs = [<void_ptr>self._pvt_ptr[0].phGraph_out + x*sizeof(cyruntime.cudaGraph_t) for x in range(self.size)]
        return [cudaGraph_t(_ptr=arr) for arr in arrs]
    @property
    def ctx(self):
        return self._ctx
    @ctx.setter
    def ctx(self, ctx):
        cdef cyruntime.cudaExecutionContext_t cyctx
        if ctx is None:
            cyctx = <cyruntime.cudaExecutionContext_t><void_ptr>0
        elif isinstance(ctx, (cudaExecutionContext_t,)):
            pctx = int(ctx)
            cyctx = <cyruntime.cudaExecutionContext_t><void_ptr>pctx
        else:
            pctx = int(cudaExecutionContext_t(ctx))
            cyctx = <cyruntime.cudaExecutionContext_t><void_ptr>pctx
        self._ctx._pvt_ptr[0] = cyctx

cdef class cudaChildGraphNodeParams:
    """
    Child graph node parameters

    Attributes
    ----------
    graph : cudaGraph_t
        The child graph to clone into the node for node creation, or a
        handle to the graph owned by the node for node query. The graph
        must not contain conditional nodes. Graphs containing memory
        allocation or memory free nodes must set the ownership to be moved
        to the parent.
    ownership : cudaGraphChildGraphNodeOwnership
        The ownership relationship of the child graph node.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaChildGraphNodeParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._graph = cudaGraph_t(_ptr=<void_ptr>&self._pvt_ptr[0].graph)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['graph : ' + str(self.graph)]
            except ValueError:
                str_list += ['graph : <ValueError>']
            try:
                str_list += ['ownership : ' + str(self.ownership)]
            except ValueError:
                str_list += ['ownership : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def graph(self):
        return self._graph
    @graph.setter
    def graph(self, graph):
        cdef cyruntime.cudaGraph_t cygraph
        if graph is None:
            cygraph = <cyruntime.cudaGraph_t><void_ptr>0
        elif isinstance(graph, (cudaGraph_t,driver.CUgraph)):
            pgraph = int(graph)
            cygraph = <cyruntime.cudaGraph_t><void_ptr>pgraph
        else:
            pgraph = int(cudaGraph_t(graph))
            cygraph = <cyruntime.cudaGraph_t><void_ptr>pgraph
        self._graph._pvt_ptr[0] = cygraph
    @property
    def ownership(self):
        if self._pvt_ptr[0].ownership not in _dict_cudaGraphChildGraphNodeOwnership:
            return None
        return _dict_cudaGraphChildGraphNodeOwnership[self._pvt_ptr[0].ownership]
    @ownership.setter
    def ownership(self, ownership not None : cudaGraphChildGraphNodeOwnership):
        self._pvt_ptr[0].ownership = ownership.value

cdef class cudaEventRecordNodeParams:
    """
    Event record node parameters

    Attributes
    ----------
    event : cudaEvent_t
        The event to record when the node executes

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaEventRecordNodeParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._event = cudaEvent_t(_ptr=<void_ptr>&self._pvt_ptr[0].event)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['event : ' + str(self.event)]
            except ValueError:
                str_list += ['event : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def event(self):
        return self._event
    @event.setter
    def event(self, event):
        cdef cyruntime.cudaEvent_t cyevent
        if event is None:
            cyevent = <cyruntime.cudaEvent_t><void_ptr>0
        elif isinstance(event, (cudaEvent_t,driver.CUevent)):
            pevent = int(event)
            cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
        else:
            pevent = int(cudaEvent_t(event))
            cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
        self._event._pvt_ptr[0] = cyevent

cdef class cudaEventWaitNodeParams:
    """
    Event wait node parameters

    Attributes
    ----------
    event : cudaEvent_t
        The event to wait on from the node

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaEventWaitNodeParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._event = cudaEvent_t(_ptr=<void_ptr>&self._pvt_ptr[0].event)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['event : ' + str(self.event)]
            except ValueError:
                str_list += ['event : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def event(self):
        return self._event
    @event.setter
    def event(self, event):
        cdef cyruntime.cudaEvent_t cyevent
        if event is None:
            cyevent = <cyruntime.cudaEvent_t><void_ptr>0
        elif isinstance(event, (cudaEvent_t,driver.CUevent)):
            pevent = int(event)
            cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
        else:
            pevent = int(cudaEvent_t(event))
            cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
        self._event._pvt_ptr[0] = cyevent

cdef class cudaGraphNodeParams:
    """
    Graph node parameters. See cudaGraphAddNode.

    Attributes
    ----------
    type : cudaGraphNodeType
        Type of the node
    reserved0 : list[int]
        Reserved. Must be zero.
    reserved1 : list[long long]
        Padding. Unused bytes must be zero.
    kernel : cudaKernelNodeParamsV2
        Kernel node parameters.
    memcpy : cudaMemcpyNodeParams
        Memcpy node parameters.
    memset : cudaMemsetParamsV2
        Memset node parameters.
    host : cudaHostNodeParamsV2
        Host node parameters.
    graph : cudaChildGraphNodeParams
        Child graph node parameters.
    eventWait : cudaEventWaitNodeParams
        Event wait node parameters.
    eventRecord : cudaEventRecordNodeParams
        Event record node parameters.
    extSemSignal : cudaExternalSemaphoreSignalNodeParamsV2
        External semaphore signal node parameters.
    extSemWait : cudaExternalSemaphoreWaitNodeParamsV2
        External semaphore wait node parameters.
    alloc : cudaMemAllocNodeParamsV2
        Memory allocation node parameters.
    free : cudaMemFreeNodeParams
        Memory free node parameters.
    conditional : cudaConditionalNodeParams
        Conditional node parameters.
    reserved2 : long long
        Reserved bytes. Must be zero.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cyruntime.cudaGraphNodeParams *>calloc(1, sizeof(cyruntime.cudaGraphNodeParams))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cyruntime.cudaGraphNodeParams *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._kernel = cudaKernelNodeParamsV2(_ptr=<void_ptr>&self._pvt_ptr[0].kernel)
        self._memcpy = cudaMemcpyNodeParams(_ptr=<void_ptr>&self._pvt_ptr[0].memcpy)
        self._memset = cudaMemsetParamsV2(_ptr=<void_ptr>&self._pvt_ptr[0].memset)
        self._host = cudaHostNodeParamsV2(_ptr=<void_ptr>&self._pvt_ptr[0].host)
        self._graph = cudaChildGraphNodeParams(_ptr=<void_ptr>&self._pvt_ptr[0].graph)
        self._eventWait = cudaEventWaitNodeParams(_ptr=<void_ptr>&self._pvt_ptr[0].eventWait)
        self._eventRecord = cudaEventRecordNodeParams(_ptr=<void_ptr>&self._pvt_ptr[0].eventRecord)
        self._extSemSignal = cudaExternalSemaphoreSignalNodeParamsV2(_ptr=<void_ptr>&self._pvt_ptr[0].extSemSignal)
        self._extSemWait = cudaExternalSemaphoreWaitNodeParamsV2(_ptr=<void_ptr>&self._pvt_ptr[0].extSemWait)
        self._alloc = cudaMemAllocNodeParamsV2(_ptr=<void_ptr>&self._pvt_ptr[0].alloc)
        self._free = cudaMemFreeNodeParams(_ptr=<void_ptr>&self._pvt_ptr[0].free)
        self._conditional = cudaConditionalNodeParams(_ptr=<void_ptr>&self._pvt_ptr[0].conditional)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['reserved0 : ' + str(self.reserved0)]
            except ValueError:
                str_list += ['reserved0 : <ValueError>']
            try:
                str_list += ['reserved1 : ' + str(self.reserved1)]
            except ValueError:
                str_list += ['reserved1 : <ValueError>']
            try:
                str_list += ['kernel :\n' + '\n'.join(['    ' + line for line in str(self.kernel).splitlines()])]
            except ValueError:
                str_list += ['kernel : <ValueError>']
            try:
                str_list += ['memcpy :\n' + '\n'.join(['    ' + line for line in str(self.memcpy).splitlines()])]
            except ValueError:
                str_list += ['memcpy : <ValueError>']
            try:
                str_list += ['memset :\n' + '\n'.join(['    ' + line for line in str(self.memset).splitlines()])]
            except ValueError:
                str_list += ['memset : <ValueError>']
            try:
                str_list += ['host :\n' + '\n'.join(['    ' + line for line in str(self.host).splitlines()])]
            except ValueError:
                str_list += ['host : <ValueError>']
            try:
                str_list += ['graph :\n' + '\n'.join(['    ' + line for line in str(self.graph).splitlines()])]
            except ValueError:
                str_list += ['graph : <ValueError>']
            try:
                str_list += ['eventWait :\n' + '\n'.join(['    ' + line for line in str(self.eventWait).splitlines()])]
            except ValueError:
                str_list += ['eventWait : <ValueError>']
            try:
                str_list += ['eventRecord :\n' + '\n'.join(['    ' + line for line in str(self.eventRecord).splitlines()])]
            except ValueError:
                str_list += ['eventRecord : <ValueError>']
            try:
                str_list += ['extSemSignal :\n' + '\n'.join(['    ' + line for line in str(self.extSemSignal).splitlines()])]
            except ValueError:
                str_list += ['extSemSignal : <ValueError>']
            try:
                str_list += ['extSemWait :\n' + '\n'.join(['    ' + line for line in str(self.extSemWait).splitlines()])]
            except ValueError:
                str_list += ['extSemWait : <ValueError>']
            try:
                str_list += ['alloc :\n' + '\n'.join(['    ' + line for line in str(self.alloc).splitlines()])]
            except ValueError:
                str_list += ['alloc : <ValueError>']
            try:
                str_list += ['free :\n' + '\n'.join(['    ' + line for line in str(self.free).splitlines()])]
            except ValueError:
                str_list += ['free : <ValueError>']
            try:
                str_list += ['conditional :\n' + '\n'.join(['    ' + line for line in str(self.conditional).splitlines()])]
            except ValueError:
                str_list += ['conditional : <ValueError>']
            try:
                str_list += ['reserved2 : ' + str(self.reserved2)]
            except ValueError:
                str_list += ['reserved2 : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_cudaGraphNodeType:
            return None
        return _dict_cudaGraphNodeType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : cudaGraphNodeType):
        self._pvt_ptr[0].type = type.value
    @property
    def reserved0(self):
        return self._pvt_ptr[0].reserved0
    @reserved0.setter
    def reserved0(self, reserved0):
        self._pvt_ptr[0].reserved0 = reserved0
    @property
    def reserved1(self):
        return self._pvt_ptr[0].reserved1
    @reserved1.setter
    def reserved1(self, reserved1):
        self._pvt_ptr[0].reserved1 = reserved1
    @property
    def kernel(self):
        return self._kernel
    @kernel.setter
    def kernel(self, kernel not None : cudaKernelNodeParamsV2):
        string.memcpy(&self._pvt_ptr[0].kernel, <cyruntime.cudaKernelNodeParamsV2*><void_ptr>kernel.getPtr(), sizeof(self._pvt_ptr[0].kernel))
    @property
    def memcpy(self):
        return self._memcpy
    @memcpy.setter
    def memcpy(self, memcpy not None : cudaMemcpyNodeParams):
        string.memcpy(&self._pvt_ptr[0].memcpy, <cyruntime.cudaMemcpyNodeParams*><void_ptr>memcpy.getPtr(), sizeof(self._pvt_ptr[0].memcpy))
    @property
    def memset(self):
        return self._memset
    @memset.setter
    def memset(self, memset not None : cudaMemsetParamsV2):
        string.memcpy(&self._pvt_ptr[0].memset, <cyruntime.cudaMemsetParamsV2*><void_ptr>memset.getPtr(), sizeof(self._pvt_ptr[0].memset))
    @property
    def host(self):
        return self._host
    @host.setter
    def host(self, host not None : cudaHostNodeParamsV2):
        string.memcpy(&self._pvt_ptr[0].host, <cyruntime.cudaHostNodeParamsV2*><void_ptr>host.getPtr(), sizeof(self._pvt_ptr[0].host))
    @property
    def graph(self):
        return self._graph
    @graph.setter
    def graph(self, graph not None : cudaChildGraphNodeParams):
        string.memcpy(&self._pvt_ptr[0].graph, <cyruntime.cudaChildGraphNodeParams*><void_ptr>graph.getPtr(), sizeof(self._pvt_ptr[0].graph))
    @property
    def eventWait(self):
        return self._eventWait
    @eventWait.setter
    def eventWait(self, eventWait not None : cudaEventWaitNodeParams):
        string.memcpy(&self._pvt_ptr[0].eventWait, <cyruntime.cudaEventWaitNodeParams*><void_ptr>eventWait.getPtr(), sizeof(self._pvt_ptr[0].eventWait))
    @property
    def eventRecord(self):
        return self._eventRecord
    @eventRecord.setter
    def eventRecord(self, eventRecord not None : cudaEventRecordNodeParams):
        string.memcpy(&self._pvt_ptr[0].eventRecord, <cyruntime.cudaEventRecordNodeParams*><void_ptr>eventRecord.getPtr(), sizeof(self._pvt_ptr[0].eventRecord))
    @property
    def extSemSignal(self):
        return self._extSemSignal
    @extSemSignal.setter
    def extSemSignal(self, extSemSignal not None : cudaExternalSemaphoreSignalNodeParamsV2):
        string.memcpy(&self._pvt_ptr[0].extSemSignal, <cyruntime.cudaExternalSemaphoreSignalNodeParamsV2*><void_ptr>extSemSignal.getPtr(), sizeof(self._pvt_ptr[0].extSemSignal))
    @property
    def extSemWait(self):
        return self._extSemWait
    @extSemWait.setter
    def extSemWait(self, extSemWait not None : cudaExternalSemaphoreWaitNodeParamsV2):
        string.memcpy(&self._pvt_ptr[0].extSemWait, <cyruntime.cudaExternalSemaphoreWaitNodeParamsV2*><void_ptr>extSemWait.getPtr(), sizeof(self._pvt_ptr[0].extSemWait))
    @property
    def alloc(self):
        return self._alloc
    @alloc.setter
    def alloc(self, alloc not None : cudaMemAllocNodeParamsV2):
        string.memcpy(&self._pvt_ptr[0].alloc, <cyruntime.cudaMemAllocNodeParamsV2*><void_ptr>alloc.getPtr(), sizeof(self._pvt_ptr[0].alloc))
    @property
    def free(self):
        return self._free
    @free.setter
    def free(self, free not None : cudaMemFreeNodeParams):
        string.memcpy(&self._pvt_ptr[0].free, <cyruntime.cudaMemFreeNodeParams*><void_ptr>free.getPtr(), sizeof(self._pvt_ptr[0].free))
    @property
    def conditional(self):
        return self._conditional
    @conditional.setter
    def conditional(self, conditional not None : cudaConditionalNodeParams):
        string.memcpy(&self._pvt_ptr[0].conditional, <cyruntime.cudaConditionalNodeParams*><void_ptr>conditional.getPtr(), sizeof(self._pvt_ptr[0].conditional))
    @property
    def reserved2(self):
        return self._pvt_ptr[0].reserved2
    @reserved2.setter
    def reserved2(self, long long reserved2):
        self._pvt_ptr[0].reserved2 = reserved2

cdef class cudaGraphEdgeData_st:
    """
    Optional annotation for edges in a CUDA graph. Note, all edges
    implicitly have annotations and default to a zero-initialized value
    if not specified. A zero-initialized struct indicates a standard
    full serialization of two nodes with memory visibility.

    Attributes
    ----------
    from_port : bytes
        This indicates when the dependency is triggered from the upstream
        node on the edge. The meaning is specfic to the node type. A value
        of 0 in all cases means full completion of the upstream node, with
        memory visibility to the downstream node or portion thereof
        (indicated by `to_port`).   Only kernel nodes define non-zero
        ports. A kernel node can use the following output port types:
        cudaGraphKernelNodePortDefault,
        cudaGraphKernelNodePortProgrammatic, or
        cudaGraphKernelNodePortLaunchCompletion.
    to_port : bytes
        This indicates what portion of the downstream node is dependent on
        the upstream node or portion thereof (indicated by `from_port`).
        The meaning is specific to the node type. A value of 0 in all cases
        means the entirety of the downstream node is dependent on the
        upstream work.   Currently no node types define non-zero ports.
        Accordingly, this field must be set to zero.
    type : bytes
        This should be populated with a value from
        ::cudaGraphDependencyType. (It is typed as char due to compiler-
        specific layout of bitfields.) See ::cudaGraphDependencyType.
    reserved : bytes
        These bytes are unused and must be zeroed. This ensures
        compatibility if additional fields are added in the future.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaGraphEdgeData_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['from_port : ' + str(self.from_port)]
            except ValueError:
                str_list += ['from_port : <ValueError>']
            try:
                str_list += ['to_port : ' + str(self.to_port)]
            except ValueError:
                str_list += ['to_port : <ValueError>']
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def from_port(self):
        return self._pvt_ptr[0].from_port
    @from_port.setter
    def from_port(self, unsigned char from_port):
        self._pvt_ptr[0].from_port = from_port
    @property
    def to_port(self):
        return self._pvt_ptr[0].to_port
    @to_port.setter
    def to_port(self, unsigned char to_port):
        self._pvt_ptr[0].to_port = to_port
    @property
    def type(self):
        return self._pvt_ptr[0].type
    @type.setter
    def type(self, unsigned char type):
        self._pvt_ptr[0].type = type
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(<char*>self._pvt_ptr[0].reserved, 5)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 5:
            raise ValueError("reserved length must be 5, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            self._pvt_ptr[0].reserved[i] = b

cdef class cudaGraphInstantiateParams_st:
    """
    Graph instantiation parameters

    Attributes
    ----------
    flags : unsigned long long
        Instantiation flags
    uploadStream : cudaStream_t
        Upload stream
    errNode_out : cudaGraphNode_t
        The node which caused instantiation to fail, if any
    result_out : cudaGraphInstantiateResult
        Whether instantiation was successful. If it failed, the reason why

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaGraphInstantiateParams_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._uploadStream = cudaStream_t(_ptr=<void_ptr>&self._pvt_ptr[0].uploadStream)
        self._errNode_out = cudaGraphNode_t(_ptr=<void_ptr>&self._pvt_ptr[0].errNode_out)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['uploadStream : ' + str(self.uploadStream)]
            except ValueError:
                str_list += ['uploadStream : <ValueError>']
            try:
                str_list += ['errNode_out : ' + str(self.errNode_out)]
            except ValueError:
                str_list += ['errNode_out : <ValueError>']
            try:
                str_list += ['result_out : ' + str(self.result_out)]
            except ValueError:
                str_list += ['result_out : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def flags(self):
        return self._pvt_ptr[0].flags
    @flags.setter
    def flags(self, unsigned long long flags):
        self._pvt_ptr[0].flags = flags
    @property
    def uploadStream(self):
        return self._uploadStream
    @uploadStream.setter
    def uploadStream(self, uploadStream):
        cdef cyruntime.cudaStream_t cyuploadStream
        if uploadStream is None:
            cyuploadStream = <cyruntime.cudaStream_t><void_ptr>0
        elif isinstance(uploadStream, (cudaStream_t,driver.CUstream)):
            puploadStream = int(uploadStream)
            cyuploadStream = <cyruntime.cudaStream_t><void_ptr>puploadStream
        else:
            puploadStream = int(cudaStream_t(uploadStream))
            cyuploadStream = <cyruntime.cudaStream_t><void_ptr>puploadStream
        self._uploadStream._pvt_ptr[0] = cyuploadStream
    @property
    def errNode_out(self):
        return self._errNode_out
    @errNode_out.setter
    def errNode_out(self, errNode_out):
        cdef cyruntime.cudaGraphNode_t cyerrNode_out
        if errNode_out is None:
            cyerrNode_out = <cyruntime.cudaGraphNode_t><void_ptr>0
        elif isinstance(errNode_out, (cudaGraphNode_t,driver.CUgraphNode)):
            perrNode_out = int(errNode_out)
            cyerrNode_out = <cyruntime.cudaGraphNode_t><void_ptr>perrNode_out
        else:
            perrNode_out = int(cudaGraphNode_t(errNode_out))
            cyerrNode_out = <cyruntime.cudaGraphNode_t><void_ptr>perrNode_out
        self._errNode_out._pvt_ptr[0] = cyerrNode_out
    @property
    def result_out(self):
        if self._pvt_ptr[0].result_out not in _dict_cudaGraphInstantiateResult:
            return None
        return _dict_cudaGraphInstantiateResult[self._pvt_ptr[0].result_out]
    @result_out.setter
    def result_out(self, result_out not None : cudaGraphInstantiateResult):
        self._pvt_ptr[0].result_out = result_out.value

cdef class cudaGraphExecUpdateResultInfo_st:
    """
    Result information returned by cudaGraphExecUpdate

    Attributes
    ----------
    result : cudaGraphExecUpdateResult
        Gives more specific detail when a cuda graph update fails.
    errorNode : cudaGraphNode_t
        The "to node" of the error edge when the topologies do not match.
        The error node when the error is associated with a specific node.
        NULL when the error is generic.
    errorFromNode : cudaGraphNode_t
        The from node of error edge when the topologies do not match.
        Otherwise NULL.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaGraphExecUpdateResultInfo_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._errorNode = cudaGraphNode_t(_ptr=<void_ptr>&self._pvt_ptr[0].errorNode)
        self._errorFromNode = cudaGraphNode_t(_ptr=<void_ptr>&self._pvt_ptr[0].errorFromNode)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['result : ' + str(self.result)]
            except ValueError:
                str_list += ['result : <ValueError>']
            try:
                str_list += ['errorNode : ' + str(self.errorNode)]
            except ValueError:
                str_list += ['errorNode : <ValueError>']
            try:
                str_list += ['errorFromNode : ' + str(self.errorFromNode)]
            except ValueError:
                str_list += ['errorFromNode : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def result(self):
        if self._pvt_ptr[0].result not in _dict_cudaGraphExecUpdateResult:
            return None
        return _dict_cudaGraphExecUpdateResult[self._pvt_ptr[0].result]
    @result.setter
    def result(self, result not None : cudaGraphExecUpdateResult):
        self._pvt_ptr[0].result = result.value
    @property
    def errorNode(self):
        return self._errorNode
    @errorNode.setter
    def errorNode(self, errorNode):
        cdef cyruntime.cudaGraphNode_t cyerrorNode
        if errorNode is None:
            cyerrorNode = <cyruntime.cudaGraphNode_t><void_ptr>0
        elif isinstance(errorNode, (cudaGraphNode_t,driver.CUgraphNode)):
            perrorNode = int(errorNode)
            cyerrorNode = <cyruntime.cudaGraphNode_t><void_ptr>perrorNode
        else:
            perrorNode = int(cudaGraphNode_t(errorNode))
            cyerrorNode = <cyruntime.cudaGraphNode_t><void_ptr>perrorNode
        self._errorNode._pvt_ptr[0] = cyerrorNode
    @property
    def errorFromNode(self):
        return self._errorFromNode
    @errorFromNode.setter
    def errorFromNode(self, errorFromNode):
        cdef cyruntime.cudaGraphNode_t cyerrorFromNode
        if errorFromNode is None:
            cyerrorFromNode = <cyruntime.cudaGraphNode_t><void_ptr>0
        elif isinstance(errorFromNode, (cudaGraphNode_t,driver.CUgraphNode)):
            perrorFromNode = int(errorFromNode)
            cyerrorFromNode = <cyruntime.cudaGraphNode_t><void_ptr>perrorFromNode
        else:
            perrorFromNode = int(cudaGraphNode_t(errorFromNode))
            cyerrorFromNode = <cyruntime.cudaGraphNode_t><void_ptr>perrorFromNode
        self._errorFromNode._pvt_ptr[0] = cyerrorFromNode

cdef class anon_struct16:
    """
    Attributes
    ----------
    pValue : Any

    offset : size_t

    size : size_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaGraphKernelNodeUpdate *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].updateData.param
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['pValue : ' + hex(self.pValue)]
            except ValueError:
                str_list += ['pValue : <ValueError>']
            try:
                str_list += ['offset : ' + str(self.offset)]
            except ValueError:
                str_list += ['offset : <ValueError>']
            try:
                str_list += ['size : ' + str(self.size)]
            except ValueError:
                str_list += ['size : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def pValue(self):
        return <void_ptr>self._pvt_ptr[0].updateData.param.pValue
    @pValue.setter
    def pValue(self, pValue):
        _cpValue = _HelperInputVoidPtr(pValue)
        self._pvt_ptr[0].updateData.param.pValue = <void*><void_ptr>_cpValue.cptr
    @property
    def offset(self):
        return self._pvt_ptr[0].updateData.param.offset
    @offset.setter
    def offset(self, size_t offset):
        self._pvt_ptr[0].updateData.param.offset = offset
    @property
    def size(self):
        return self._pvt_ptr[0].updateData.param.size
    @size.setter
    def size(self, size_t size):
        self._pvt_ptr[0].updateData.param.size = size

cdef class anon_union8:
    """
    Attributes
    ----------
    gridDim : dim3

    param : anon_struct16

    isEnabled : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaGraphKernelNodeUpdate *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._gridDim = dim3(_ptr=<void_ptr>&self._pvt_ptr[0].updateData.gridDim)
        self._param = anon_struct16(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].updateData
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['gridDim :\n' + '\n'.join(['    ' + line for line in str(self.gridDim).splitlines()])]
            except ValueError:
                str_list += ['gridDim : <ValueError>']
            try:
                str_list += ['param :\n' + '\n'.join(['    ' + line for line in str(self.param).splitlines()])]
            except ValueError:
                str_list += ['param : <ValueError>']
            try:
                str_list += ['isEnabled : ' + str(self.isEnabled)]
            except ValueError:
                str_list += ['isEnabled : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def gridDim(self):
        return self._gridDim
    @gridDim.setter
    def gridDim(self, gridDim not None : dim3):
        string.memcpy(&self._pvt_ptr[0].updateData.gridDim, <cyruntime.dim3*><void_ptr>gridDim.getPtr(), sizeof(self._pvt_ptr[0].updateData.gridDim))
    @property
    def param(self):
        return self._param
    @param.setter
    def param(self, param not None : anon_struct16):
        string.memcpy(&self._pvt_ptr[0].updateData.param, <cyruntime.anon_struct16*><void_ptr>param.getPtr(), sizeof(self._pvt_ptr[0].updateData.param))
    @property
    def isEnabled(self):
        return self._pvt_ptr[0].updateData.isEnabled
    @isEnabled.setter
    def isEnabled(self, unsigned int isEnabled):
        self._pvt_ptr[0].updateData.isEnabled = isEnabled

cdef class cudaGraphKernelNodeUpdate:
    """
    Struct to specify a single node update to pass as part of a larger
    array to ::cudaGraphKernelNodeUpdatesApply

    Attributes
    ----------
    node : cudaGraphDeviceNode_t
        Node to update
    field : cudaGraphKernelNodeField
        Which type of update to apply. Determines how updateData is
        interpreted
    updateData : anon_union8
        Update data to apply. Which field is used depends on field's value

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cyruntime.cudaGraphKernelNodeUpdate *>calloc(1, sizeof(cyruntime.cudaGraphKernelNodeUpdate))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cyruntime.cudaGraphKernelNodeUpdate *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._node = cudaGraphDeviceNode_t(_ptr=<void_ptr>&self._pvt_ptr[0].node)
        self._updateData = anon_union8(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['node : ' + str(self.node)]
            except ValueError:
                str_list += ['node : <ValueError>']
            try:
                str_list += ['field : ' + str(self.field)]
            except ValueError:
                str_list += ['field : <ValueError>']
            try:
                str_list += ['updateData :\n' + '\n'.join(['    ' + line for line in str(self.updateData).splitlines()])]
            except ValueError:
                str_list += ['updateData : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def node(self):
        return self._node
    @node.setter
    def node(self, node):
        cdef cyruntime.cudaGraphDeviceNode_t cynode
        if node is None:
            cynode = <cyruntime.cudaGraphDeviceNode_t><void_ptr>0
        elif isinstance(node, (cudaGraphDeviceNode_t,)):
            pnode = int(node)
            cynode = <cyruntime.cudaGraphDeviceNode_t><void_ptr>pnode
        else:
            pnode = int(cudaGraphDeviceNode_t(node))
            cynode = <cyruntime.cudaGraphDeviceNode_t><void_ptr>pnode
        self._node._pvt_ptr[0] = cynode
    @property
    def field(self):
        if self._pvt_ptr[0].field not in _dict_cudaGraphKernelNodeField:
            return None
        return _dict_cudaGraphKernelNodeField[self._pvt_ptr[0].field]
    @field.setter
    def field(self, field not None : cudaGraphKernelNodeField):
        self._pvt_ptr[0].field = field.value
    @property
    def updateData(self):
        return self._updateData
    @updateData.setter
    def updateData(self, updateData not None : anon_union8):
        string.memcpy(&self._pvt_ptr[0].updateData, <cyruntime.anon_union8*><void_ptr>updateData.getPtr(), sizeof(self._pvt_ptr[0].updateData))

cdef class cudaLaunchMemSyncDomainMap_st:
    """
    Memory Synchronization Domain map  See cudaLaunchMemSyncDomain.  By
    default, kernels are launched in domain 0. Kernel launched with
    cudaLaunchMemSyncDomainRemote will have a different domain ID. User
    may also alter the domain ID with ::cudaLaunchMemSyncDomainMap for
    a specific stream / graph node / kernel launch. See
    cudaLaunchAttributeMemSyncDomainMap.  Domain ID range is available
    through cudaDevAttrMemSyncDomainCount.

    Attributes
    ----------
    default_ : bytes
        The default domain ID to use for designated kernels
    remote : bytes
        The remote domain ID to use for designated kernels

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaLaunchMemSyncDomainMap_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['default_ : ' + str(self.default_)]
            except ValueError:
                str_list += ['default_ : <ValueError>']
            try:
                str_list += ['remote : ' + str(self.remote)]
            except ValueError:
                str_list += ['remote : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def default_(self):
        return self._pvt_ptr[0].default_
    @default_.setter
    def default_(self, unsigned char default_):
        self._pvt_ptr[0].default_ = default_
    @property
    def remote(self):
        return self._pvt_ptr[0].remote
    @remote.setter
    def remote(self, unsigned char remote):
        self._pvt_ptr[0].remote = remote

cdef class anon_struct17:
    """
    Attributes
    ----------
    x : unsigned int

    y : unsigned int

    z : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaLaunchAttributeValue *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].clusterDim
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['x : ' + str(self.x)]
            except ValueError:
                str_list += ['x : <ValueError>']
            try:
                str_list += ['y : ' + str(self.y)]
            except ValueError:
                str_list += ['y : <ValueError>']
            try:
                str_list += ['z : ' + str(self.z)]
            except ValueError:
                str_list += ['z : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def x(self):
        return self._pvt_ptr[0].clusterDim.x
    @x.setter
    def x(self, unsigned int x):
        self._pvt_ptr[0].clusterDim.x = x
    @property
    def y(self):
        return self._pvt_ptr[0].clusterDim.y
    @y.setter
    def y(self, unsigned int y):
        self._pvt_ptr[0].clusterDim.y = y
    @property
    def z(self):
        return self._pvt_ptr[0].clusterDim.z
    @z.setter
    def z(self, unsigned int z):
        self._pvt_ptr[0].clusterDim.z = z

cdef class anon_struct18:
    """
    Attributes
    ----------
    event : cudaEvent_t

    flags : int

    triggerAtBlockStart : int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaLaunchAttributeValue *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._event = cudaEvent_t(_ptr=<void_ptr>&self._pvt_ptr[0].programmaticEvent.event)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].programmaticEvent
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['event : ' + str(self.event)]
            except ValueError:
                str_list += ['event : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            try:
                str_list += ['triggerAtBlockStart : ' + str(self.triggerAtBlockStart)]
            except ValueError:
                str_list += ['triggerAtBlockStart : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def event(self):
        return self._event
    @event.setter
    def event(self, event):
        cdef cyruntime.cudaEvent_t cyevent
        if event is None:
            cyevent = <cyruntime.cudaEvent_t><void_ptr>0
        elif isinstance(event, (cudaEvent_t,driver.CUevent)):
            pevent = int(event)
            cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
        else:
            pevent = int(cudaEvent_t(event))
            cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
        self._event._pvt_ptr[0] = cyevent
    @property
    def flags(self):
        return self._pvt_ptr[0].programmaticEvent.flags
    @flags.setter
    def flags(self, int flags):
        self._pvt_ptr[0].programmaticEvent.flags = flags
    @property
    def triggerAtBlockStart(self):
        return self._pvt_ptr[0].programmaticEvent.triggerAtBlockStart
    @triggerAtBlockStart.setter
    def triggerAtBlockStart(self, int triggerAtBlockStart):
        self._pvt_ptr[0].programmaticEvent.triggerAtBlockStart = triggerAtBlockStart

cdef class anon_struct19:
    """
    Attributes
    ----------
    x : unsigned int

    y : unsigned int

    z : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaLaunchAttributeValue *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].preferredClusterDim
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['x : ' + str(self.x)]
            except ValueError:
                str_list += ['x : <ValueError>']
            try:
                str_list += ['y : ' + str(self.y)]
            except ValueError:
                str_list += ['y : <ValueError>']
            try:
                str_list += ['z : ' + str(self.z)]
            except ValueError:
                str_list += ['z : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def x(self):
        return self._pvt_ptr[0].preferredClusterDim.x
    @x.setter
    def x(self, unsigned int x):
        self._pvt_ptr[0].preferredClusterDim.x = x
    @property
    def y(self):
        return self._pvt_ptr[0].preferredClusterDim.y
    @y.setter
    def y(self, unsigned int y):
        self._pvt_ptr[0].preferredClusterDim.y = y
    @property
    def z(self):
        return self._pvt_ptr[0].preferredClusterDim.z
    @z.setter
    def z(self, unsigned int z):
        self._pvt_ptr[0].preferredClusterDim.z = z

cdef class anon_struct20:
    """
    Attributes
    ----------
    event : cudaEvent_t

    flags : int


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaLaunchAttributeValue *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._event = cudaEvent_t(_ptr=<void_ptr>&self._pvt_ptr[0].launchCompletionEvent.event)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].launchCompletionEvent
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['event : ' + str(self.event)]
            except ValueError:
                str_list += ['event : <ValueError>']
            try:
                str_list += ['flags : ' + str(self.flags)]
            except ValueError:
                str_list += ['flags : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def event(self):
        return self._event
    @event.setter
    def event(self, event):
        cdef cyruntime.cudaEvent_t cyevent
        if event is None:
            cyevent = <cyruntime.cudaEvent_t><void_ptr>0
        elif isinstance(event, (cudaEvent_t,driver.CUevent)):
            pevent = int(event)
            cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
        else:
            pevent = int(cudaEvent_t(event))
            cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
        self._event._pvt_ptr[0] = cyevent
    @property
    def flags(self):
        return self._pvt_ptr[0].launchCompletionEvent.flags
    @flags.setter
    def flags(self, int flags):
        self._pvt_ptr[0].launchCompletionEvent.flags = flags

cdef class anon_struct21:
    """
    Attributes
    ----------
    deviceUpdatable : int

    devNode : cudaGraphDeviceNode_t


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaLaunchAttributeValue *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._devNode = cudaGraphDeviceNode_t(_ptr=<void_ptr>&self._pvt_ptr[0].deviceUpdatableKernelNode.devNode)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].deviceUpdatableKernelNode
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['deviceUpdatable : ' + str(self.deviceUpdatable)]
            except ValueError:
                str_list += ['deviceUpdatable : <ValueError>']
            try:
                str_list += ['devNode : ' + str(self.devNode)]
            except ValueError:
                str_list += ['devNode : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def deviceUpdatable(self):
        return self._pvt_ptr[0].deviceUpdatableKernelNode.deviceUpdatable
    @deviceUpdatable.setter
    def deviceUpdatable(self, int deviceUpdatable):
        self._pvt_ptr[0].deviceUpdatableKernelNode.deviceUpdatable = deviceUpdatable
    @property
    def devNode(self):
        return self._devNode
    @devNode.setter
    def devNode(self, devNode):
        cdef cyruntime.cudaGraphDeviceNode_t cydevNode
        if devNode is None:
            cydevNode = <cyruntime.cudaGraphDeviceNode_t><void_ptr>0
        elif isinstance(devNode, (cudaGraphDeviceNode_t,)):
            pdevNode = int(devNode)
            cydevNode = <cyruntime.cudaGraphDeviceNode_t><void_ptr>pdevNode
        else:
            pdevNode = int(cudaGraphDeviceNode_t(devNode))
            cydevNode = <cyruntime.cudaGraphDeviceNode_t><void_ptr>pdevNode
        self._devNode._pvt_ptr[0] = cydevNode

cdef class cudaLaunchAttributeValue:
    """
    Launch attributes union; used as value field of
    ::cudaLaunchAttribute

    Attributes
    ----------
    pad : bytes

    accessPolicyWindow : cudaAccessPolicyWindow
        Value of launch attribute cudaLaunchAttributeAccessPolicyWindow.
    cooperative : int
        Value of launch attribute cudaLaunchAttributeCooperative. Nonzero
        indicates a cooperative kernel (see cudaLaunchCooperativeKernel).
    syncPolicy : cudaSynchronizationPolicy
        Value of launch attribute cudaLaunchAttributeSynchronizationPolicy.
        ::cudaSynchronizationPolicy for work queued up in this stream.
    clusterDim : anon_struct17
        Value of launch attribute cudaLaunchAttributeClusterDimension that
        represents the desired cluster dimensions for the kernel. Opaque
        type with the following fields: - `x` - The X dimension of the
        cluster, in blocks. Must be a divisor of the grid X dimension.    -
        `y` - The Y dimension of the cluster, in blocks. Must be a divisor
        of the grid Y dimension.    - `z` - The Z dimension of the cluster,
        in blocks. Must be a divisor of the grid Z dimension.
    clusterSchedulingPolicyPreference : cudaClusterSchedulingPolicy
        Value of launch attribute
        cudaLaunchAttributeClusterSchedulingPolicyPreference. Cluster
        scheduling policy preference for the kernel.
    programmaticStreamSerializationAllowed : int
        Value of launch attribute
        cudaLaunchAttributeProgrammaticStreamSerialization.
    programmaticEvent : anon_struct18
        Value of launch attribute cudaLaunchAttributeProgrammaticEvent with
        the following fields: - `cudaEvent_t` event - Event to fire when
        all blocks trigger it.    - `int` flags; - Event record flags, see
        cudaEventRecordWithFlags. Does not accept cudaEventRecordExternal.
        - `int` triggerAtBlockStart - If this is set to non-0, each block
        launch will automatically trigger the event.
    priority : int
        Value of launch attribute cudaLaunchAttributePriority. Execution
        priority of the kernel.
    memSyncDomainMap : cudaLaunchMemSyncDomainMap
        Value of launch attribute cudaLaunchAttributeMemSyncDomainMap. See
        ::cudaLaunchMemSyncDomainMap.
    memSyncDomain : cudaLaunchMemSyncDomain
        Value of launch attribute cudaLaunchAttributeMemSyncDomain. See
        cudaLaunchMemSyncDomain.
    preferredClusterDim : anon_struct19
        Value of launch attribute
        cudaLaunchAttributePreferredClusterDimension that represents the
        desired preferred cluster dimensions for the kernel. Opaque type
        with the following fields: - `x` - The X dimension of the preferred
        cluster, in blocks. Must be a divisor of the grid X dimension, and
        must be a multiple of the `x` field of
        cudaLaunchAttributeValue::clusterDim.    - `y` - The Y dimension of
        the preferred cluster, in blocks. Must be a divisor of the grid Y
        dimension, and must be a multiple of the `y` field of
        cudaLaunchAttributeValue::clusterDim.    - `z` - The Z dimension of
        the preferred cluster, in blocks. Must be equal to the `z` field of
        cudaLaunchAttributeValue::clusterDim.
    launchCompletionEvent : anon_struct20
        Value of launch attribute cudaLaunchAttributeLaunchCompletionEvent
        with the following fields: - `cudaEvent_t` event - Event to fire
        when the last block launches.    - `int` flags - Event record
        flags, see cudaEventRecordWithFlags. Does not accept
        cudaEventRecordExternal.
    deviceUpdatableKernelNode : anon_struct21
        Value of launch attribute
        cudaLaunchAttributeDeviceUpdatableKernelNode with the following
        fields: - `int` deviceUpdatable - Whether or not the resulting
        kernel node should be device-updatable.    -
        `cudaGraphDeviceNode_t` devNode - Returns a handle to pass to the
        various device-side update functions.
    sharedMemCarveout : unsigned int
        Value of launch attribute
        cudaLaunchAttributePreferredSharedMemoryCarveout.
    nvlinkUtilCentricScheduling : unsigned int
        Value of launch attribute
        cudaLaunchAttributeNvlinkUtilCentricScheduling.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaLaunchAttributeValue *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._accessPolicyWindow = cudaAccessPolicyWindow(_ptr=<void_ptr>&self._pvt_ptr[0].accessPolicyWindow)
        self._clusterDim = anon_struct17(_ptr=<void_ptr>self._pvt_ptr)
        self._programmaticEvent = anon_struct18(_ptr=<void_ptr>self._pvt_ptr)
        self._memSyncDomainMap = cudaLaunchMemSyncDomainMap(_ptr=<void_ptr>&self._pvt_ptr[0].memSyncDomainMap)
        self._preferredClusterDim = anon_struct19(_ptr=<void_ptr>self._pvt_ptr)
        self._launchCompletionEvent = anon_struct20(_ptr=<void_ptr>self._pvt_ptr)
        self._deviceUpdatableKernelNode = anon_struct21(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['pad : ' + str(self.pad)]
            except ValueError:
                str_list += ['pad : <ValueError>']
            try:
                str_list += ['accessPolicyWindow :\n' + '\n'.join(['    ' + line for line in str(self.accessPolicyWindow).splitlines()])]
            except ValueError:
                str_list += ['accessPolicyWindow : <ValueError>']
            try:
                str_list += ['cooperative : ' + str(self.cooperative)]
            except ValueError:
                str_list += ['cooperative : <ValueError>']
            try:
                str_list += ['syncPolicy : ' + str(self.syncPolicy)]
            except ValueError:
                str_list += ['syncPolicy : <ValueError>']
            try:
                str_list += ['clusterDim :\n' + '\n'.join(['    ' + line for line in str(self.clusterDim).splitlines()])]
            except ValueError:
                str_list += ['clusterDim : <ValueError>']
            try:
                str_list += ['clusterSchedulingPolicyPreference : ' + str(self.clusterSchedulingPolicyPreference)]
            except ValueError:
                str_list += ['clusterSchedulingPolicyPreference : <ValueError>']
            try:
                str_list += ['programmaticStreamSerializationAllowed : ' + str(self.programmaticStreamSerializationAllowed)]
            except ValueError:
                str_list += ['programmaticStreamSerializationAllowed : <ValueError>']
            try:
                str_list += ['programmaticEvent :\n' + '\n'.join(['    ' + line for line in str(self.programmaticEvent).splitlines()])]
            except ValueError:
                str_list += ['programmaticEvent : <ValueError>']
            try:
                str_list += ['priority : ' + str(self.priority)]
            except ValueError:
                str_list += ['priority : <ValueError>']
            try:
                str_list += ['memSyncDomainMap :\n' + '\n'.join(['    ' + line for line in str(self.memSyncDomainMap).splitlines()])]
            except ValueError:
                str_list += ['memSyncDomainMap : <ValueError>']
            try:
                str_list += ['memSyncDomain : ' + str(self.memSyncDomain)]
            except ValueError:
                str_list += ['memSyncDomain : <ValueError>']
            try:
                str_list += ['preferredClusterDim :\n' + '\n'.join(['    ' + line for line in str(self.preferredClusterDim).splitlines()])]
            except ValueError:
                str_list += ['preferredClusterDim : <ValueError>']
            try:
                str_list += ['launchCompletionEvent :\n' + '\n'.join(['    ' + line for line in str(self.launchCompletionEvent).splitlines()])]
            except ValueError:
                str_list += ['launchCompletionEvent : <ValueError>']
            try:
                str_list += ['deviceUpdatableKernelNode :\n' + '\n'.join(['    ' + line for line in str(self.deviceUpdatableKernelNode).splitlines()])]
            except ValueError:
                str_list += ['deviceUpdatableKernelNode : <ValueError>']
            try:
                str_list += ['sharedMemCarveout : ' + str(self.sharedMemCarveout)]
            except ValueError:
                str_list += ['sharedMemCarveout : <ValueError>']
            try:
                str_list += ['nvlinkUtilCentricScheduling : ' + str(self.nvlinkUtilCentricScheduling)]
            except ValueError:
                str_list += ['nvlinkUtilCentricScheduling : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def pad(self):
        return PyBytes_FromStringAndSize(self._pvt_ptr[0].pad, 64)
    @pad.setter
    def pad(self, pad):
        if len(pad) != 64:
            raise ValueError("pad length must be 64, is " + str(len(pad)))
        if CHAR_MIN == 0:
            for i, b in enumerate(pad):
                if b < 0 and b > -129:
                    b = b + 256
                self._pvt_ptr[0].pad[i] = b
        else:
            for i, b in enumerate(pad):
                if b > 127 and b < 256:
                    b = b - 256
                self._pvt_ptr[0].pad[i] = b
    @property
    def accessPolicyWindow(self):
        return self._accessPolicyWindow
    @accessPolicyWindow.setter
    def accessPolicyWindow(self, accessPolicyWindow not None : cudaAccessPolicyWindow):
        string.memcpy(&self._pvt_ptr[0].accessPolicyWindow, <cyruntime.cudaAccessPolicyWindow*><void_ptr>accessPolicyWindow.getPtr(), sizeof(self._pvt_ptr[0].accessPolicyWindow))
    @property
    def cooperative(self):
        return self._pvt_ptr[0].cooperative
    @cooperative.setter
    def cooperative(self, int cooperative):
        self._pvt_ptr[0].cooperative = cooperative
    @property
    def syncPolicy(self):
        if self._pvt_ptr[0].syncPolicy not in _dict_cudaSynchronizationPolicy:
            return None
        return _dict_cudaSynchronizationPolicy[self._pvt_ptr[0].syncPolicy]
    @syncPolicy.setter
    def syncPolicy(self, syncPolicy not None : cudaSynchronizationPolicy):
        self._pvt_ptr[0].syncPolicy = syncPolicy.value
    @property
    def clusterDim(self):
        return self._clusterDim
    @clusterDim.setter
    def clusterDim(self, clusterDim not None : anon_struct17):
        string.memcpy(&self._pvt_ptr[0].clusterDim, <cyruntime.anon_struct17*><void_ptr>clusterDim.getPtr(), sizeof(self._pvt_ptr[0].clusterDim))
    @property
    def clusterSchedulingPolicyPreference(self):
        if self._pvt_ptr[0].clusterSchedulingPolicyPreference not in _dict_cudaClusterSchedulingPolicy:
            return None
        return _dict_cudaClusterSchedulingPolicy[self._pvt_ptr[0].clusterSchedulingPolicyPreference]
    @clusterSchedulingPolicyPreference.setter
    def clusterSchedulingPolicyPreference(self, clusterSchedulingPolicyPreference not None : cudaClusterSchedulingPolicy):
        self._pvt_ptr[0].clusterSchedulingPolicyPreference = clusterSchedulingPolicyPreference.value
    @property
    def programmaticStreamSerializationAllowed(self):
        return self._pvt_ptr[0].programmaticStreamSerializationAllowed
    @programmaticStreamSerializationAllowed.setter
    def programmaticStreamSerializationAllowed(self, int programmaticStreamSerializationAllowed):
        self._pvt_ptr[0].programmaticStreamSerializationAllowed = programmaticStreamSerializationAllowed
    @property
    def programmaticEvent(self):
        return self._programmaticEvent
    @programmaticEvent.setter
    def programmaticEvent(self, programmaticEvent not None : anon_struct18):
        string.memcpy(&self._pvt_ptr[0].programmaticEvent, <cyruntime.anon_struct18*><void_ptr>programmaticEvent.getPtr(), sizeof(self._pvt_ptr[0].programmaticEvent))
    @property
    def priority(self):
        return self._pvt_ptr[0].priority
    @priority.setter
    def priority(self, int priority):
        self._pvt_ptr[0].priority = priority
    @property
    def memSyncDomainMap(self):
        return self._memSyncDomainMap
    @memSyncDomainMap.setter
    def memSyncDomainMap(self, memSyncDomainMap not None : cudaLaunchMemSyncDomainMap):
        string.memcpy(&self._pvt_ptr[0].memSyncDomainMap, <cyruntime.cudaLaunchMemSyncDomainMap*><void_ptr>memSyncDomainMap.getPtr(), sizeof(self._pvt_ptr[0].memSyncDomainMap))
    @property
    def memSyncDomain(self):
        if self._pvt_ptr[0].memSyncDomain not in _dict_cudaLaunchMemSyncDomain:
            return None
        return _dict_cudaLaunchMemSyncDomain[self._pvt_ptr[0].memSyncDomain]
    @memSyncDomain.setter
    def memSyncDomain(self, memSyncDomain not None : cudaLaunchMemSyncDomain):
        self._pvt_ptr[0].memSyncDomain = memSyncDomain.value
    @property
    def preferredClusterDim(self):
        return self._preferredClusterDim
    @preferredClusterDim.setter
    def preferredClusterDim(self, preferredClusterDim not None : anon_struct19):
        string.memcpy(&self._pvt_ptr[0].preferredClusterDim, <cyruntime.anon_struct19*><void_ptr>preferredClusterDim.getPtr(), sizeof(self._pvt_ptr[0].preferredClusterDim))
    @property
    def launchCompletionEvent(self):
        return self._launchCompletionEvent
    @launchCompletionEvent.setter
    def launchCompletionEvent(self, launchCompletionEvent not None : anon_struct20):
        string.memcpy(&self._pvt_ptr[0].launchCompletionEvent, <cyruntime.anon_struct20*><void_ptr>launchCompletionEvent.getPtr(), sizeof(self._pvt_ptr[0].launchCompletionEvent))
    @property
    def deviceUpdatableKernelNode(self):
        return self._deviceUpdatableKernelNode
    @deviceUpdatableKernelNode.setter
    def deviceUpdatableKernelNode(self, deviceUpdatableKernelNode not None : anon_struct21):
        string.memcpy(&self._pvt_ptr[0].deviceUpdatableKernelNode, <cyruntime.anon_struct21*><void_ptr>deviceUpdatableKernelNode.getPtr(), sizeof(self._pvt_ptr[0].deviceUpdatableKernelNode))
    @property
    def sharedMemCarveout(self):
        return self._pvt_ptr[0].sharedMemCarveout
    @sharedMemCarveout.setter
    def sharedMemCarveout(self, unsigned int sharedMemCarveout):
        self._pvt_ptr[0].sharedMemCarveout = sharedMemCarveout
    @property
    def nvlinkUtilCentricScheduling(self):
        return self._pvt_ptr[0].nvlinkUtilCentricScheduling
    @nvlinkUtilCentricScheduling.setter
    def nvlinkUtilCentricScheduling(self, unsigned int nvlinkUtilCentricScheduling):
        self._pvt_ptr[0].nvlinkUtilCentricScheduling = nvlinkUtilCentricScheduling

cdef class cudaLaunchAttribute_st:
    """
    Launch attribute

    Attributes
    ----------
    id : cudaLaunchAttributeID
        Attribute to set
    val : cudaLaunchAttributeValue
        Value of the attribute

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaLaunchAttribute_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._val = cudaLaunchAttributeValue(_ptr=<void_ptr>&self._pvt_ptr[0].val)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['id : ' + str(self.id)]
            except ValueError:
                str_list += ['id : <ValueError>']
            try:
                str_list += ['val :\n' + '\n'.join(['    ' + line for line in str(self.val).splitlines()])]
            except ValueError:
                str_list += ['val : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def id(self):
        if self._pvt_ptr[0].id not in _dict_cudaLaunchAttributeID:
            return None
        return _dict_cudaLaunchAttributeID[self._pvt_ptr[0].id]
    @id.setter
    def id(self, id not None : cudaLaunchAttributeID):
        self._pvt_ptr[0].id = id.value
    @property
    def val(self):
        return self._val
    @val.setter
    def val(self, val not None : cudaLaunchAttributeValue):
        string.memcpy(&self._pvt_ptr[0].val, <cyruntime.cudaLaunchAttributeValue*><void_ptr>val.getPtr(), sizeof(self._pvt_ptr[0].val))

cdef class anon_struct22:
    """
    Attributes
    ----------
    bytesOverBudget : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaAsyncNotificationInfo *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].info.overBudget
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['bytesOverBudget : ' + str(self.bytesOverBudget)]
            except ValueError:
                str_list += ['bytesOverBudget : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def bytesOverBudget(self):
        return self._pvt_ptr[0].info.overBudget.bytesOverBudget
    @bytesOverBudget.setter
    def bytesOverBudget(self, unsigned long long bytesOverBudget):
        self._pvt_ptr[0].info.overBudget.bytesOverBudget = bytesOverBudget

cdef class anon_union9:
    """
    Attributes
    ----------
    overBudget : anon_struct22


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaAsyncNotificationInfo *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
        self._overBudget = anon_struct22(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].info
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['overBudget :\n' + '\n'.join(['    ' + line for line in str(self.overBudget).splitlines()])]
            except ValueError:
                str_list += ['overBudget : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def overBudget(self):
        return self._overBudget
    @overBudget.setter
    def overBudget(self, overBudget not None : anon_struct22):
        string.memcpy(&self._pvt_ptr[0].info.overBudget, <cyruntime.anon_struct22*><void_ptr>overBudget.getPtr(), sizeof(self._pvt_ptr[0].info.overBudget))

cdef class cudaAsyncNotificationInfo:
    """
    Information describing an async notification event

    Attributes
    ----------
    type : cudaAsyncNotificationType
        The type of notification being sent
    info : anon_union9
        Information about the notification. `typename` must be checked in
        order to interpret this field.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cyruntime.cudaAsyncNotificationInfo *>calloc(1, sizeof(cyruntime.cudaAsyncNotificationInfo))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cyruntime.cudaAsyncNotificationInfo *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._info = anon_union9(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['type : ' + str(self.type)]
            except ValueError:
                str_list += ['type : <ValueError>']
            try:
                str_list += ['info :\n' + '\n'.join(['    ' + line for line in str(self.info).splitlines()])]
            except ValueError:
                str_list += ['info : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def type(self):
        if self._pvt_ptr[0].type not in _dict_cudaAsyncNotificationType:
            return None
        return _dict_cudaAsyncNotificationType[self._pvt_ptr[0].type]
    @type.setter
    def type(self, type not None : cudaAsyncNotificationType):
        self._pvt_ptr[0].type = type.value
    @property
    def info(self):
        return self._info
    @info.setter
    def info(self, info not None : anon_union9):
        string.memcpy(&self._pvt_ptr[0].info, <cyruntime.anon_union9*><void_ptr>info.getPtr(), sizeof(self._pvt_ptr[0].info))

cdef class cudaTextureDesc:
    """
    CUDA texture descriptor

    Attributes
    ----------
    addressMode : list[cudaTextureAddressMode]
        Texture address mode for up to 3 dimensions
    filterMode : cudaTextureFilterMode
        Texture filter mode
    readMode : cudaTextureReadMode
        Texture read mode
    sRGB : int
        Perform sRGB->linear conversion during texture read
    borderColor : list[float]
        Texture Border Color
    normalizedCoords : int
        Indicates whether texture reads are normalized or not
    maxAnisotropy : unsigned int
        Limit to the anisotropy ratio
    mipmapFilterMode : cudaTextureFilterMode
        Mipmap filter mode
    mipmapLevelBias : float
        Offset applied to the supplied mipmap level
    minMipmapLevelClamp : float
        Lower end of the mipmap level range to clamp access to
    maxMipmapLevelClamp : float
        Upper end of the mipmap level range to clamp access to
    disableTrilinearOptimization : int
        Disable any trilinear filtering optimizations.
    seamlessCubemap : int
        Enable seamless cube map filtering.

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaTextureDesc *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['addressMode : ' + str(self.addressMode)]
            except ValueError:
                str_list += ['addressMode : <ValueError>']
            try:
                str_list += ['filterMode : ' + str(self.filterMode)]
            except ValueError:
                str_list += ['filterMode : <ValueError>']
            try:
                str_list += ['readMode : ' + str(self.readMode)]
            except ValueError:
                str_list += ['readMode : <ValueError>']
            try:
                str_list += ['sRGB : ' + str(self.sRGB)]
            except ValueError:
                str_list += ['sRGB : <ValueError>']
            try:
                str_list += ['borderColor : ' + str(self.borderColor)]
            except ValueError:
                str_list += ['borderColor : <ValueError>']
            try:
                str_list += ['normalizedCoords : ' + str(self.normalizedCoords)]
            except ValueError:
                str_list += ['normalizedCoords : <ValueError>']
            try:
                str_list += ['maxAnisotropy : ' + str(self.maxAnisotropy)]
            except ValueError:
                str_list += ['maxAnisotropy : <ValueError>']
            try:
                str_list += ['mipmapFilterMode : ' + str(self.mipmapFilterMode)]
            except ValueError:
                str_list += ['mipmapFilterMode : <ValueError>']
            try:
                str_list += ['mipmapLevelBias : ' + str(self.mipmapLevelBias)]
            except ValueError:
                str_list += ['mipmapLevelBias : <ValueError>']
            try:
                str_list += ['minMipmapLevelClamp : ' + str(self.minMipmapLevelClamp)]
            except ValueError:
                str_list += ['minMipmapLevelClamp : <ValueError>']
            try:
                str_list += ['maxMipmapLevelClamp : ' + str(self.maxMipmapLevelClamp)]
            except ValueError:
                str_list += ['maxMipmapLevelClamp : <ValueError>']
            try:
                str_list += ['disableTrilinearOptimization : ' + str(self.disableTrilinearOptimization)]
            except ValueError:
                str_list += ['disableTrilinearOptimization : <ValueError>']
            try:
                str_list += ['seamlessCubemap : ' + str(self.seamlessCubemap)]
            except ValueError:
                str_list += ['seamlessCubemap : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def addressMode(self):
        return [_dict_cudaTextureAddressMode[_x] if _x in _dict_cudaTextureAddressMode else None for _x in list(self._pvt_ptr[0].addressMode)]
    @addressMode.setter
    def addressMode(self, addressMode):
        self._pvt_ptr[0].addressMode = [_x.value for _x in addressMode]
    @property
    def filterMode(self):
        if self._pvt_ptr[0].filterMode not in _dict_cudaTextureFilterMode:
            return None
        return _dict_cudaTextureFilterMode[self._pvt_ptr[0].filterMode]
    @filterMode.setter
    def filterMode(self, filterMode not None : cudaTextureFilterMode):
        self._pvt_ptr[0].filterMode = filterMode.value
    @property
    def readMode(self):
        if self._pvt_ptr[0].readMode not in _dict_cudaTextureReadMode:
            return None
        return _dict_cudaTextureReadMode[self._pvt_ptr[0].readMode]
    @readMode.setter
    def readMode(self, readMode not None : cudaTextureReadMode):
        self._pvt_ptr[0].readMode = readMode.value
    @property
    def sRGB(self):
        return self._pvt_ptr[0].sRGB
    @sRGB.setter
    def sRGB(self, int sRGB):
        self._pvt_ptr[0].sRGB = sRGB
    @property
    def borderColor(self):
        return self._pvt_ptr[0].borderColor
    @borderColor.setter
    def borderColor(self, borderColor):
        self._pvt_ptr[0].borderColor = borderColor
    @property
    def normalizedCoords(self):
        return self._pvt_ptr[0].normalizedCoords
    @normalizedCoords.setter
    def normalizedCoords(self, int normalizedCoords):
        self._pvt_ptr[0].normalizedCoords = normalizedCoords
    @property
    def maxAnisotropy(self):
        return self._pvt_ptr[0].maxAnisotropy
    @maxAnisotropy.setter
    def maxAnisotropy(self, unsigned int maxAnisotropy):
        self._pvt_ptr[0].maxAnisotropy = maxAnisotropy
    @property
    def mipmapFilterMode(self):
        if self._pvt_ptr[0].mipmapFilterMode not in _dict_cudaTextureFilterMode:
            return None
        return _dict_cudaTextureFilterMode[self._pvt_ptr[0].mipmapFilterMode]
    @mipmapFilterMode.setter
    def mipmapFilterMode(self, mipmapFilterMode not None : cudaTextureFilterMode):
        self._pvt_ptr[0].mipmapFilterMode = mipmapFilterMode.value
    @property
    def mipmapLevelBias(self):
        return self._pvt_ptr[0].mipmapLevelBias
    @mipmapLevelBias.setter
    def mipmapLevelBias(self, float mipmapLevelBias):
        self._pvt_ptr[0].mipmapLevelBias = mipmapLevelBias
    @property
    def minMipmapLevelClamp(self):
        return self._pvt_ptr[0].minMipmapLevelClamp
    @minMipmapLevelClamp.setter
    def minMipmapLevelClamp(self, float minMipmapLevelClamp):
        self._pvt_ptr[0].minMipmapLevelClamp = minMipmapLevelClamp
    @property
    def maxMipmapLevelClamp(self):
        return self._pvt_ptr[0].maxMipmapLevelClamp
    @maxMipmapLevelClamp.setter
    def maxMipmapLevelClamp(self, float maxMipmapLevelClamp):
        self._pvt_ptr[0].maxMipmapLevelClamp = maxMipmapLevelClamp
    @property
    def disableTrilinearOptimization(self):
        return self._pvt_ptr[0].disableTrilinearOptimization
    @disableTrilinearOptimization.setter
    def disableTrilinearOptimization(self, int disableTrilinearOptimization):
        self._pvt_ptr[0].disableTrilinearOptimization = disableTrilinearOptimization
    @property
    def seamlessCubemap(self):
        return self._pvt_ptr[0].seamlessCubemap
    @seamlessCubemap.setter
    def seamlessCubemap(self, int seamlessCubemap):
        self._pvt_ptr[0].seamlessCubemap = seamlessCubemap

cdef class cudaEglPlaneDesc_st:
    """
    CUDA EGL Plane Descriptor - structure defining each plane of a CUDA
    EGLFrame

    Attributes
    ----------
    width : unsigned int
        Width of plane
    height : unsigned int
        Height of plane
    depth : unsigned int
        Depth of plane
    pitch : unsigned int
        Pitch of plane
    numChannels : unsigned int
        Number of channels for the plane
    channelDesc : cudaChannelFormatDesc
        Channel Format Descriptor
    reserved : list[unsigned int]
        Reserved for future use

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaEglPlaneDesc_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._channelDesc = cudaChannelFormatDesc(_ptr=<void_ptr>&self._pvt_ptr[0].channelDesc)
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['width : ' + str(self.width)]
            except ValueError:
                str_list += ['width : <ValueError>']
            try:
                str_list += ['height : ' + str(self.height)]
            except ValueError:
                str_list += ['height : <ValueError>']
            try:
                str_list += ['depth : ' + str(self.depth)]
            except ValueError:
                str_list += ['depth : <ValueError>']
            try:
                str_list += ['pitch : ' + str(self.pitch)]
            except ValueError:
                str_list += ['pitch : <ValueError>']
            try:
                str_list += ['numChannels : ' + str(self.numChannels)]
            except ValueError:
                str_list += ['numChannels : <ValueError>']
            try:
                str_list += ['channelDesc :\n' + '\n'.join(['    ' + line for line in str(self.channelDesc).splitlines()])]
            except ValueError:
                str_list += ['channelDesc : <ValueError>']
            try:
                str_list += ['reserved : ' + str(self.reserved)]
            except ValueError:
                str_list += ['reserved : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def width(self):
        return self._pvt_ptr[0].width
    @width.setter
    def width(self, unsigned int width):
        self._pvt_ptr[0].width = width
    @property
    def height(self):
        return self._pvt_ptr[0].height
    @height.setter
    def height(self, unsigned int height):
        self._pvt_ptr[0].height = height
    @property
    def depth(self):
        return self._pvt_ptr[0].depth
    @depth.setter
    def depth(self, unsigned int depth):
        self._pvt_ptr[0].depth = depth
    @property
    def pitch(self):
        return self._pvt_ptr[0].pitch
    @pitch.setter
    def pitch(self, unsigned int pitch):
        self._pvt_ptr[0].pitch = pitch
    @property
    def numChannels(self):
        return self._pvt_ptr[0].numChannels
    @numChannels.setter
    def numChannels(self, unsigned int numChannels):
        self._pvt_ptr[0].numChannels = numChannels
    @property
    def channelDesc(self):
        return self._channelDesc
    @channelDesc.setter
    def channelDesc(self, channelDesc not None : cudaChannelFormatDesc):
        string.memcpy(&self._pvt_ptr[0].channelDesc, <cyruntime.cudaChannelFormatDesc*><void_ptr>channelDesc.getPtr(), sizeof(self._pvt_ptr[0].channelDesc))
    @property
    def reserved(self):
        return self._pvt_ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        self._pvt_ptr[0].reserved = reserved

cdef class anon_union10:
    """
    Attributes
    ----------
    pArray : list[cudaArray_t]

    pPitch : list[cudaPitchedPtr]


    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr):
        self._pvt_ptr = <cyruntime.cudaEglFrame_st *>_ptr

    def __init__(self, void_ptr _ptr):
        pass
    def __dealloc__(self):
        pass
    def getPtr(self):
        return <void_ptr>&self._pvt_ptr[0].frame
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['pArray : ' + str(self.pArray)]
            except ValueError:
                str_list += ['pArray : <ValueError>']
            try:
                str_list += ['pPitch :\n' + '\n'.join(['    ' + line for line in str(self.pPitch).splitlines()])]
            except ValueError:
                str_list += ['pPitch : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def pArray(self):
        return [cudaArray_t(init_value=<void_ptr>_pArray) for _pArray in self._pvt_ptr[0].frame.pArray]
    @pArray.setter
    def pArray(self, pArray : list[cudaArray_t]):
        if len(pArray) != 3:
            raise IndexError('not enough values found during array assignment, expected 3, got', len(pArray))
        pArray = [int(_pArray) for _pArray in pArray]
        for _idx, _pArray in enumerate(pArray):
            self._pvt_ptr[0].frame.pArray[_idx] = <cyruntime.cudaArray_t><void_ptr>_pArray

    @property
    def pPitch(self):
        out_pPitch = [cudaPitchedPtr() for _pPitch in self._pvt_ptr[0].frame.pPitch]
        for _idx in range(len(out_pPitch)):
            string.memcpy(<cyruntime.cudaPitchedPtr*><void_ptr>out_pPitch[_idx].getPtr(), &self._pvt_ptr[0].frame.pPitch[_idx], sizeof(cyruntime.cudaPitchedPtr))
        return out_pPitch
    @pPitch.setter
    def pPitch(self, pPitch : list[cudaPitchedPtr]):
        if len(pPitch) != 3:
            raise IndexError('not enough values found during array assignment, expected 3, got', len(pPitch))
        for _idx in range(len(pPitch)):
            string.memcpy(&self._pvt_ptr[0].frame.pPitch[_idx], <cyruntime.cudaPitchedPtr*><void_ptr>pPitch[_idx].getPtr(), sizeof(cyruntime.cudaPitchedPtr))


cdef class cudaEglFrame_st:
    """
    CUDA EGLFrame Descriptor - structure defining one frame of EGL.
    Each frame may contain one or more planes depending on whether the
    surface is Multiplanar or not. Each plane of EGLFrame is
    represented by cudaEglPlaneDesc which is defined as:
    typedefstructcudaEglPlaneDesc_st unsignedintwidth;
    unsignedintheight; unsignedintdepth; unsignedintpitch;
    unsignedintnumChannels; structcudaChannelFormatDescchannelDesc;
    unsignedintreserved[4]; cudaEglPlaneDesc;

    Attributes
    ----------
    frame : anon_union10

    planeDesc : list[cudaEglPlaneDesc]
        CUDA EGL Plane Descriptor cudaEglPlaneDesc
    planeCount : unsigned int
        Number of planes
    frameType : cudaEglFrameType
        Array or Pitch
    eglColorFormat : cudaEglColorFormat
        CUDA EGL Color Format

    Methods
    -------
    getPtr()
        Get memory address of class instance
    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._val_ptr = <cyruntime.cudaEglFrame_st *>calloc(1, sizeof(cyruntime.cudaEglFrame_st))
            self._pvt_ptr = self._val_ptr
        else:
            self._pvt_ptr = <cyruntime.cudaEglFrame_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
        self._frame = anon_union10(_ptr=<void_ptr>self._pvt_ptr)
    def __dealloc__(self):
        if self._val_ptr is not NULL:
            free(self._val_ptr)
    def getPtr(self):
        return <void_ptr>self._pvt_ptr
    def __repr__(self):
        if self._pvt_ptr is not NULL:
            str_list = []
            try:
                str_list += ['frame :\n' + '\n'.join(['    ' + line for line in str(self.frame).splitlines()])]
            except ValueError:
                str_list += ['frame : <ValueError>']
            try:
                str_list += ['planeDesc :\n' + '\n'.join(['    ' + line for line in str(self.planeDesc).splitlines()])]
            except ValueError:
                str_list += ['planeDesc : <ValueError>']
            try:
                str_list += ['planeCount : ' + str(self.planeCount)]
            except ValueError:
                str_list += ['planeCount : <ValueError>']
            try:
                str_list += ['frameType : ' + str(self.frameType)]
            except ValueError:
                str_list += ['frameType : <ValueError>']
            try:
                str_list += ['eglColorFormat : ' + str(self.eglColorFormat)]
            except ValueError:
                str_list += ['eglColorFormat : <ValueError>']
            return '\n'.join(str_list)
        else:
            return ''
    @property
    def frame(self):
        return self._frame
    @frame.setter
    def frame(self, frame not None : anon_union10):
        string.memcpy(&self._pvt_ptr[0].frame, <cyruntime.anon_union10*><void_ptr>frame.getPtr(), sizeof(self._pvt_ptr[0].frame))
    @property
    def planeDesc(self):
        out_planeDesc = [cudaEglPlaneDesc() for _planeDesc in self._pvt_ptr[0].planeDesc]
        for _idx in range(len(out_planeDesc)):
            string.memcpy(<cyruntime.cudaEglPlaneDesc*><void_ptr>out_planeDesc[_idx].getPtr(), &self._pvt_ptr[0].planeDesc[_idx], sizeof(cyruntime.cudaEglPlaneDesc))
        return out_planeDesc
    @planeDesc.setter
    def planeDesc(self, planeDesc : list[cudaEglPlaneDesc]):
        if len(planeDesc) != 3:
            raise IndexError('not enough values found during array assignment, expected 3, got', len(planeDesc))
        for _idx in range(len(planeDesc)):
            string.memcpy(&self._pvt_ptr[0].planeDesc[_idx], <cyruntime.cudaEglPlaneDesc*><void_ptr>planeDesc[_idx].getPtr(), sizeof(cyruntime.cudaEglPlaneDesc))

    @property
    def planeCount(self):
        return self._pvt_ptr[0].planeCount
    @planeCount.setter
    def planeCount(self, unsigned int planeCount):
        self._pvt_ptr[0].planeCount = planeCount
    @property
    def frameType(self):
        if self._pvt_ptr[0].frameType not in _dict_cudaEglFrameType:
            return None
        return _dict_cudaEglFrameType[self._pvt_ptr[0].frameType]
    @frameType.setter
    def frameType(self, frameType not None : cudaEglFrameType):
        self._pvt_ptr[0].frameType = frameType.value
    @property
    def eglColorFormat(self):
        if self._pvt_ptr[0].eglColorFormat not in _dict_cudaEglColorFormat:
            return None
        return _dict_cudaEglColorFormat[self._pvt_ptr[0].eglColorFormat]
    @eglColorFormat.setter
    def eglColorFormat(self, eglColorFormat not None : cudaEglColorFormat):
        self._pvt_ptr[0].eglColorFormat = eglColorFormat.value

cdef class cudaGraphConditionalHandle:
    """

    CUDA handle for conditional graph nodes

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaGraphConditionalHandle *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<cudaGraphConditionalHandle ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaLogIterator:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaLogIterator *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<cudaLogIterator ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned int>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaSurfaceObject_t:
    """

    An opaque value that represents a CUDA Surface object

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaSurfaceObject_t *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<cudaSurfaceObject_t ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class cudaTextureObject_t:
    """

    An opaque value that represents a CUDA texture object

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.cudaTextureObject_t *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<cudaTextureObject_t ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class GLenum:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.GLenum *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<GLenum ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned int>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class GLuint:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.GLuint *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<GLuint ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned int>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class EGLint:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.EGLint *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<EGLint ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned int>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class VdpDevice:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint32_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.VdpDevice *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<VdpDevice ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint32_t>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class VdpGetProcAddress:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.VdpGetProcAddress *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<VdpGetProcAddress ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class VdpVideoSurface:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint32_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.VdpVideoSurface *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<VdpVideoSurface ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint32_t>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

cdef class VdpOutputSurface:
    """

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint32_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._pvt_ptr = &self._pvt_val
        else:
            self._pvt_ptr = <cyruntime.VdpOutputSurface *>_ptr
        if init_value:
            self._pvt_ptr[0] = init_value
    def __dealloc__(self):
        pass
    def __repr__(self):
        return '<VdpOutputSurface ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint32_t>self._pvt_ptr[0]
    def getPtr(self):
        return <void_ptr>self._pvt_ptr

@cython.embedsignature(True)
def cudaDeviceReset():
    """ Destroy all allocations and reset all state on the current device in the current process.

    Explicitly destroys and cleans up all resources associated with the
    current device in the current process. It is the caller's
    responsibility to ensure that the resources are not accessed or passed
    in subsequent API calls and doing so will result in undefined behavior.
    These resources include CUDA types :py:obj:`~.cudaStream_t`,
    :py:obj:`~.cudaEvent_t`, :py:obj:`~.cudaArray_t`,
    :py:obj:`~.cudaMipmappedArray_t`, :py:obj:`~.cudaPitchedPtr`,
    :py:obj:`~.cudaTextureObject_t`, :py:obj:`~.cudaSurfaceObject_t`,
    :py:obj:`~.textureReference`, :py:obj:`~.surfaceReference`,
    :py:obj:`~.cudaExternalMemory_t`, :py:obj:`~.cudaExternalSemaphore_t`
    and :py:obj:`~.cudaGraphicsResource_t`. These resources also include
    memory allocations by :py:obj:`~.cudaMalloc`,
    :py:obj:`~.cudaMallocHost`, :py:obj:`~.cudaMallocManaged` and
    :py:obj:`~.cudaMallocPitch`. Any subsequent API call to this device
    will reinitialize the device.

    Note that this function will reset the device immediately. It is the
    caller's responsibility to ensure that the device is not being accessed
    by any other host threads from the process when this function is
    called.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`

    See Also
    --------
    :py:obj:`~.cudaDeviceSynchronize`

    Notes
    -----
    :py:obj:`~.cudaDeviceReset()` will not destroy memory allocations by :py:obj:`~.cudaMallocAsync()` and :py:obj:`~.cudaMallocFromPoolAsync()`. These memory allocations need to be destroyed explicitly.

    If a non-primary :py:obj:`~.CUcontext` is current to the thread, :py:obj:`~.cudaDeviceReset()` will destroy only the internal CUDA RT state for that :py:obj:`~.CUcontext`.
    """
    with nogil:
        err = cyruntime.cudaDeviceReset()
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaDeviceSynchronize():
    """ Wait for compute device to finish.

    Blocks until the device has completed all preceding requested tasks.
    :py:obj:`~.cudaDeviceSynchronize()` returns an error if one of the
    preceding tasks has failed. If the
    :py:obj:`~.cudaDeviceScheduleBlockingSync` flag was set for this
    device, the host thread will block until the device has finished its
    work.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorStreamCaptureUnsupported`

    See Also
    --------
    :py:obj:`~.cudaDeviceReset`, :py:obj:`~.cuCtxSynchronize`
    """
    with nogil:
        err = cyruntime.cudaDeviceSynchronize()
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaDeviceSetLimit(limit not None : cudaLimit, size_t value):
    """ Set resource limits.

    Setting `limit` to `value` is a request by the application to update
    the current limit maintained by the device. The driver is free to
    modify the requested value to meet h/w requirements (this could be
    clamping to minimum or maximum values, rounding up to nearest element
    size, etc). The application can use :py:obj:`~.cudaDeviceGetLimit()` to
    find out exactly what the limit has been set to.

    Setting each :py:obj:`~.cudaLimit` has its own specific restrictions,
    so each is discussed here.

    - :py:obj:`~.cudaLimitStackSize` controls the stack size in bytes of
      each GPU thread.

    - :py:obj:`~.cudaLimitPrintfFifoSize` controls the size in bytes of the
      shared FIFO used by the :py:obj:`~.printf()` device system call.
      Setting :py:obj:`~.cudaLimitPrintfFifoSize` must not be performed
      after launching any kernel that uses the :py:obj:`~.printf()` device
      system call - in such case :py:obj:`~.cudaErrorInvalidValue` will be
      returned.

    - :py:obj:`~.cudaLimitMallocHeapSize` controls the size in bytes of the
      heap used by the :py:obj:`~.malloc()` and :py:obj:`~.free()` device
      system calls. Setting :py:obj:`~.cudaLimitMallocHeapSize` must not be
      performed after launching any kernel that uses the
      :py:obj:`~.malloc()` or :py:obj:`~.free()` device system calls - in
      such case :py:obj:`~.cudaErrorInvalidValue` will be returned.

    - :py:obj:`~.cudaLimitDevRuntimeSyncDepth` controls the maximum nesting
      depth of a grid at which a thread can safely call
      :py:obj:`~.cudaDeviceSynchronize()`. Setting this limit must be
      performed before any launch of a kernel that uses the device runtime
      and calls :py:obj:`~.cudaDeviceSynchronize()` above the default sync
      depth, two levels of grids. Calls to
      :py:obj:`~.cudaDeviceSynchronize()` will fail with error code
      :py:obj:`~.cudaErrorSyncDepthExceeded` if the limitation is violated.
      This limit can be set smaller than the default or up the maximum
      launch depth of 24. When setting this limit, keep in mind that
      additional levels of sync depth require the runtime to reserve large
      amounts of device memory which can no longer be used for user
      allocations. If these reservations of device memory fail,
      :py:obj:`~.cudaDeviceSetLimit` will return
      :py:obj:`~.cudaErrorMemoryAllocation`, and the limit can be reset to
      a lower value. This limit is only applicable to devices of compute
      capability < 9.0. Attempting to set this limit on devices of other
      compute capability will results in error
      :py:obj:`~.cudaErrorUnsupportedLimit` being returned.

    - :py:obj:`~.cudaLimitDevRuntimePendingLaunchCount` controls the
      maximum number of outstanding device runtime launches that can be
      made from the current device. A grid is outstanding from the point of
      launch up until the grid is known to have been completed. Device
      runtime launches which violate this limitation fail and return
      :py:obj:`~.cudaErrorLaunchPendingCountExceeded` when
      :py:obj:`~.cudaGetLastError()` is called after launch. If more
      pending launches than the default (2048 launches) are needed for a
      module using the device runtime, this limit can be increased. Keep in
      mind that being able to sustain additional pending launches will
      require the runtime to reserve larger amounts of device memory
      upfront which can no longer be used for allocations. If these
      reservations fail, :py:obj:`~.cudaDeviceSetLimit` will return
      :py:obj:`~.cudaErrorMemoryAllocation`, and the limit can be reset to
      a lower value. This limit is only applicable to devices of compute
      capability 3.5 and higher. Attempting to set this limit on devices of
      compute capability less than 3.5 will result in the error
      :py:obj:`~.cudaErrorUnsupportedLimit` being returned.

    - :py:obj:`~.cudaLimitMaxL2FetchGranularity` controls the L2 cache
      fetch granularity. Values can range from 0B to 128B. This is purely a
      performance hint and it can be ignored or clamped depending on the
      platform.

    - :py:obj:`~.cudaLimitPersistingL2CacheSize` controls size in bytes
      available for persisting L2 cache. This is purely a performance hint
      and it can be ignored or clamped depending on the platform.

    Parameters
    ----------
    limit : :py:obj:`~.cudaLimit`
        Limit to set
    value : size_t
        Size of limit

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorUnsupportedLimit`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorMemoryAllocation`

    See Also
    --------
    :py:obj:`~.cudaDeviceGetLimit`, :py:obj:`~.cuCtxSetLimit`
    """
    cdef cyruntime.cudaLimit cylimit = limit.value
    with nogil:
        err = cyruntime.cudaDeviceSetLimit(cylimit, value)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaDeviceGetLimit(limit not None : cudaLimit):
    """ Return resource limits.

    Returns in `*pValue` the current size of `limit`. The following
    :py:obj:`~.cudaLimit` values are supported.

    - :py:obj:`~.cudaLimitStackSize` is the stack size in bytes of each GPU
      thread.

    - :py:obj:`~.cudaLimitPrintfFifoSize` is the size in bytes of the
      shared FIFO used by the :py:obj:`~.printf()` device system call.

    - :py:obj:`~.cudaLimitMallocHeapSize` is the size in bytes of the heap
      used by the :py:obj:`~.malloc()` and :py:obj:`~.free()` device system
      calls.

    - :py:obj:`~.cudaLimitDevRuntimeSyncDepth` is the maximum grid depth at
      which a thread can isssue the device runtime call
      :py:obj:`~.cudaDeviceSynchronize()` to wait on child grid launches to
      complete. This functionality is removed for devices of compute
      capability >= 9.0, and hence will return error
      :py:obj:`~.cudaErrorUnsupportedLimit` on such devices.

    - :py:obj:`~.cudaLimitDevRuntimePendingLaunchCount` is the maximum
      number of outstanding device runtime launches.

    - :py:obj:`~.cudaLimitMaxL2FetchGranularity` is the L2 cache fetch
      granularity.

    - :py:obj:`~.cudaLimitPersistingL2CacheSize` is the persisting L2 cache
      size in bytes.

    Parameters
    ----------
    limit : :py:obj:`~.cudaLimit`
        Limit to query

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorUnsupportedLimit`, :py:obj:`~.cudaErrorInvalidValue`
    pValue : int
        Returned size of the limit

    See Also
    --------
    :py:obj:`~.cudaDeviceSetLimit`, :py:obj:`~.cuCtxGetLimit`
    """
    cdef size_t pValue = 0
    cdef cyruntime.cudaLimit cylimit = limit.value
    with nogil:
        err = cyruntime.cudaDeviceGetLimit(&pValue, cylimit)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pValue)

@cython.embedsignature(True)
def cudaDeviceGetTexture1DLinearMaxWidth(fmtDesc : Optional[cudaChannelFormatDesc], int device):
    """ Returns the maximum number of elements allocatable in a 1D linear texture for a given element size.

    Returns in `maxWidthInElements` the maximum number of elements
    allocatable in a 1D linear texture for given format descriptor
    `fmtDesc`.

    Parameters
    ----------
    fmtDesc : :py:obj:`~.cudaChannelFormatDesc`
        Texture format description.
    None : int
        None

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorUnsupportedLimit`, :py:obj:`~.cudaErrorInvalidValue`
    maxWidthInElements : int
        Returns maximum number of texture elements allocatable for given
        `fmtDesc`.

    See Also
    --------
    :py:obj:`~.cuDeviceGetTexture1DLinearMaxWidth`
    """
    cdef size_t maxWidthInElements = 0
    cdef cyruntime.cudaChannelFormatDesc* cyfmtDesc_ptr = fmtDesc._pvt_ptr if fmtDesc is not None else NULL
    with nogil:
        err = cyruntime.cudaDeviceGetTexture1DLinearMaxWidth(&maxWidthInElements, cyfmtDesc_ptr, device)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], maxWidthInElements)

@cython.embedsignature(True)
def cudaDeviceGetCacheConfig():
    """ Returns the preferred cache configuration for the current device.

    On devices where the L1 cache and shared memory use the same hardware
    resources, this returns through `pCacheConfig` the preferred cache
    configuration for the current device. This is only a preference. The
    runtime will use the requested configuration if possible, but it is
    free to choose a different configuration if required to execute
    functions.

    This will return a `pCacheConfig` of
    :py:obj:`~.cudaFuncCachePreferNone` on devices where the size of the L1
    cache and shared memory are fixed.

    The supported cache configurations are:

    - :py:obj:`~.cudaFuncCachePreferNone`: no preference for shared memory
      or L1 (default)

    - :py:obj:`~.cudaFuncCachePreferShared`: prefer larger shared memory
      and smaller L1 cache

    - :py:obj:`~.cudaFuncCachePreferL1`: prefer larger L1 cache and smaller
      shared memory

    - :py:obj:`~.cudaFuncCachePreferEqual`: prefer equal size L1 cache and
      shared memory

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`
    pCacheConfig : :py:obj:`~.cudaFuncCache`
        Returned cache configuration

    See Also
    --------
    :py:obj:`~.cudaDeviceSetCacheConfig`, :py:obj:`~.cudaFuncSetCacheConfig (C API)`, cudaFuncSetCacheConfig (C++ API), :py:obj:`~.cuCtxGetCacheConfig`
    """
    cdef cyruntime.cudaFuncCache pCacheConfig
    with nogil:
        err = cyruntime.cudaDeviceGetCacheConfig(&pCacheConfig)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], cudaFuncCache(pCacheConfig))

@cython.embedsignature(True)
def cudaDeviceGetStreamPriorityRange():
    """ Returns numerical values that correspond to the least and greatest stream priorities.

    Returns in `*leastPriority` and `*greatestPriority` the numerical
    values that correspond to the least and greatest stream priorities
    respectively. Stream priorities follow a convention where lower numbers
    imply greater priorities. The range of meaningful stream priorities is
    given by [`*greatestPriority`, `*leastPriority`]. If the user attempts
    to create a stream with a priority value that is outside the the
    meaningful range as specified by this API, the priority is
    automatically clamped down or up to either `*leastPriority` or
    `*greatestPriority` respectively. See
    :py:obj:`~.cudaStreamCreateWithPriority` for details on creating a
    priority stream. A NULL may be passed in for `*leastPriority` or
    `*greatestPriority` if the value is not desired.

    This function will return '0' in both `*leastPriority` and
    `*greatestPriority` if the current context's device does not support
    stream priorities (see :py:obj:`~.cudaDeviceGetAttribute`).

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`
    leastPriority : int
        Pointer to an int in which the numerical value for least stream
        priority is returned
    greatestPriority : int
        Pointer to an int in which the numerical value for greatest stream
        priority is returned

    See Also
    --------
    :py:obj:`~.cudaStreamCreateWithPriority`, :py:obj:`~.cudaStreamGetPriority`, :py:obj:`~.cuCtxGetStreamPriorityRange`
    """
    cdef int leastPriority = 0
    cdef int greatestPriority = 0
    with nogil:
        err = cyruntime.cudaDeviceGetStreamPriorityRange(&leastPriority, &greatestPriority)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None, None)
    return (_dict_cudaError_t[err], leastPriority, greatestPriority)

@cython.embedsignature(True)
def cudaDeviceSetCacheConfig(cacheConfig not None : cudaFuncCache):
    """ Sets the preferred cache configuration for the current device.

    On devices where the L1 cache and shared memory use the same hardware
    resources, this sets through `cacheConfig` the preferred cache
    configuration for the current device. This is only a preference. The
    runtime will use the requested configuration if possible, but it is
    free to choose a different configuration if required to execute the
    function. Any function preference set via
    :py:obj:`~.cudaFuncSetCacheConfig (C API)` or cudaFuncSetCacheConfig
    (C++ API) will be preferred over this device-wide setting. Setting the
    device-wide cache configuration to :py:obj:`~.cudaFuncCachePreferNone`
    will cause subsequent kernel launches to prefer to not change the cache
    configuration unless required to launch the kernel.

    This setting does nothing on devices where the size of the L1 cache and
    shared memory are fixed.

    Launching a kernel with a different preference than the most recent
    preference setting may insert a device-side synchronization point.

    The supported cache configurations are:

    - :py:obj:`~.cudaFuncCachePreferNone`: no preference for shared memory
      or L1 (default)

    - :py:obj:`~.cudaFuncCachePreferShared`: prefer larger shared memory
      and smaller L1 cache

    - :py:obj:`~.cudaFuncCachePreferL1`: prefer larger L1 cache and smaller
      shared memory

    - :py:obj:`~.cudaFuncCachePreferEqual`: prefer equal size L1 cache and
      shared memory

    Parameters
    ----------
    cacheConfig : :py:obj:`~.cudaFuncCache`
        Requested cache configuration

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`

    See Also
    --------
    :py:obj:`~.cudaDeviceGetCacheConfig`, :py:obj:`~.cudaFuncSetCacheConfig (C API)`, cudaFuncSetCacheConfig (C++ API), :py:obj:`~.cuCtxSetCacheConfig`
    """
    cdef cyruntime.cudaFuncCache cycacheConfig = cacheConfig.value
    with nogil:
        err = cyruntime.cudaDeviceSetCacheConfig(cycacheConfig)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaDeviceGetByPCIBusId(char* pciBusId):
    """ Returns a handle to a compute device.

    Returns in `*device` a device ordinal given a PCI bus ID string.

    where `domain`, `bus`, `device`, and `function` are all hexadecimal
    values

    Parameters
    ----------
    pciBusId : bytes
        String in one of the following forms:

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidDevice`
    device : int
        Returned device ordinal

    See Also
    --------
    :py:obj:`~.cudaDeviceGetPCIBusId`, :py:obj:`~.cuDeviceGetByPCIBusId`
    """
    cdef int device = 0
    with nogil:
        err = cyruntime.cudaDeviceGetByPCIBusId(&device, pciBusId)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], device)

@cython.embedsignature(True)
def cudaDeviceGetPCIBusId(int length, int device):
    """ Returns a PCI Bus Id string for the device.

    Returns an ASCII string identifying the device `dev` in the NULL-
    terminated string pointed to by `pciBusId`. `length` specifies the
    maximum length of the string that may be returned.

    where `domain`, `bus`, `device`, and `function` are all hexadecimal
    values. pciBusId should be large enough to store 13 characters
    including the NULL-terminator.

    Parameters
    ----------
    length : int
        Maximum length of string to store in `name`
    device : int
        Device to get identifier string for

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidDevice`
    pciBusId : bytes
        Returned identifier string for the device in the following format

    See Also
    --------
    :py:obj:`~.cudaDeviceGetByPCIBusId`, :py:obj:`~.cuDeviceGetPCIBusId`
    """
    pypciBusId = b" " * length
    cdef char* pciBusId = pypciBusId
    with nogil:
        err = cyruntime.cudaDeviceGetPCIBusId(pciBusId, length, device)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pypciBusId)

@cython.embedsignature(True)
def cudaIpcGetEventHandle(event):
    """ Gets an interprocess handle for a previously allocated event.

    Takes as input a previously allocated event. This event must have been
    created with the :py:obj:`~.cudaEventInterprocess` and
    :py:obj:`~.cudaEventDisableTiming` flags set. This opaque handle may be
    copied into other processes and opened with
    :py:obj:`~.cudaIpcOpenEventHandle` to allow efficient hardware
    synchronization between GPU work in different processes.

    After the event has been been opened in the importing process,
    :py:obj:`~.cudaEventRecord`, :py:obj:`~.cudaEventSynchronize`,
    :py:obj:`~.cudaStreamWaitEvent` and :py:obj:`~.cudaEventQuery` may be
    used in either process. Performing operations on the imported event
    after the exported event has been freed with
    :py:obj:`~.cudaEventDestroy` will result in undefined behavior.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is supported for compatibility purposes but not recommended as
    it comes with performance cost. Users can test their device for IPC
    functionality by calling :py:obj:`~.cudaDeviceGetAttribute` with
    :py:obj:`~.cudaDevAttrIpcEventSupport`

    Parameters
    ----------
    event : :py:obj:`~.CUevent` or :py:obj:`~.cudaEvent_t`
        Event allocated with :py:obj:`~.cudaEventInterprocess` and
        :py:obj:`~.cudaEventDisableTiming` flags.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorMemoryAllocation`, :py:obj:`~.cudaErrorMapBufferObjectFailed`, :py:obj:`~.cudaErrorNotSupported`, :py:obj:`~.cudaErrorInvalidValue`
    handle : :py:obj:`~.cudaIpcEventHandle_t`
        Pointer to a user allocated cudaIpcEventHandle in which to return
        the opaque event handle

    See Also
    --------
    :py:obj:`~.cudaEventCreate`, :py:obj:`~.cudaEventDestroy`, :py:obj:`~.cudaEventSynchronize`, :py:obj:`~.cudaEventQuery`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaIpcOpenEventHandle`, :py:obj:`~.cudaIpcGetMemHandle`, :py:obj:`~.cudaIpcOpenMemHandle`, :py:obj:`~.cudaIpcCloseMemHandle`, :py:obj:`~.cuIpcGetEventHandle`
    """
    cdef cyruntime.cudaEvent_t cyevent
    if event is None:
        pevent = 0
    elif isinstance(event, (cudaEvent_t,driver.CUevent)):
        pevent = int(event)
    else:
        pevent = int(cudaEvent_t(event))
    cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
    cdef cudaIpcEventHandle_t handle = cudaIpcEventHandle_t()
    with nogil:
        err = cyruntime.cudaIpcGetEventHandle(<cyruntime.cudaIpcEventHandle_t*>handle._pvt_ptr, cyevent)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], handle)

@cython.embedsignature(True)
def cudaIpcOpenEventHandle(handle not None : cudaIpcEventHandle_t):
    """ Opens an interprocess event handle for use in the current process.

    Opens an interprocess event handle exported from another process with
    :py:obj:`~.cudaIpcGetEventHandle`. This function returns a
    :py:obj:`~.cudaEvent_t` that behaves like a locally created event with
    the :py:obj:`~.cudaEventDisableTiming` flag specified. This event must
    be freed with :py:obj:`~.cudaEventDestroy`.

    Performing operations on the imported event after the exported event
    has been freed with :py:obj:`~.cudaEventDestroy` will result in
    undefined behavior.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is supported for compatibility purposes but not recommended as
    it comes with performance cost. Users can test their device for IPC
    functionality by calling :py:obj:`~.cudaDeviceGetAttribute` with
    :py:obj:`~.cudaDevAttrIpcEventSupport`

    Parameters
    ----------
    handle : :py:obj:`~.cudaIpcEventHandle_t`
        Interprocess handle to open

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorMapBufferObjectFailed`, :py:obj:`~.cudaErrorNotSupported`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorDeviceUninitialized`
    event : :py:obj:`~.cudaEvent_t`
        Returns the imported event

    See Also
    --------
    :py:obj:`~.cudaEventCreate`, :py:obj:`~.cudaEventDestroy`, :py:obj:`~.cudaEventSynchronize`, :py:obj:`~.cudaEventQuery`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaIpcGetEventHandle`, :py:obj:`~.cudaIpcGetMemHandle`, :py:obj:`~.cudaIpcOpenMemHandle`, :py:obj:`~.cudaIpcCloseMemHandle`, :py:obj:`~.cuIpcOpenEventHandle`
    """
    cdef cudaEvent_t event = cudaEvent_t()
    with nogil:
        err = cyruntime.cudaIpcOpenEventHandle(<cyruntime.cudaEvent_t*>event._pvt_ptr, handle._pvt_ptr[0])
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], event)

@cython.embedsignature(True)
def cudaIpcGetMemHandle(devPtr):
    """ Gets an interprocess memory handle for an existing device memory allocation.

    Takes a pointer to the base of an existing device memory allocation
    created with :py:obj:`~.cudaMalloc` and exports it for use in another
    process. This is a lightweight operation and may be called multiple
    times on an allocation without adverse effects.

    If a region of memory is freed with :py:obj:`~.cudaFree` and a
    subsequent call to :py:obj:`~.cudaMalloc` returns memory with the same
    device address, :py:obj:`~.cudaIpcGetMemHandle` will return a unique
    handle for the new memory.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is supported for compatibility purposes but not recommended as
    it comes with performance cost. Users can test their device for IPC
    functionality by calling :py:obj:`~.cudaDeviceGetAttribute` with
    :py:obj:`~.cudaDevAttrIpcEventSupport`

    Parameters
    ----------
    devPtr : Any
        Base pointer to previously allocated device memory

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorMemoryAllocation`, :py:obj:`~.cudaErrorMapBufferObjectFailed`, :py:obj:`~.cudaErrorNotSupported`, :py:obj:`~.cudaErrorInvalidValue`
    handle : :py:obj:`~.cudaIpcMemHandle_t`
        Pointer to user allocated :py:obj:`~.cudaIpcMemHandle` to return
        the handle in.

    See Also
    --------
    :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaIpcGetEventHandle`, :py:obj:`~.cudaIpcOpenEventHandle`, :py:obj:`~.cudaIpcOpenMemHandle`, :py:obj:`~.cudaIpcCloseMemHandle`, :py:obj:`~.cuIpcGetMemHandle`
    """
    cdef cudaIpcMemHandle_t handle = cudaIpcMemHandle_t()
    cydevPtr = _HelperInputVoidPtr(devPtr)
    cdef void* cydevPtr_ptr = <void*><void_ptr>cydevPtr.cptr
    with nogil:
        err = cyruntime.cudaIpcGetMemHandle(<cyruntime.cudaIpcMemHandle_t*>handle._pvt_ptr, cydevPtr_ptr)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], handle)

@cython.embedsignature(True)
def cudaIpcOpenMemHandle(handle not None : cudaIpcMemHandle_t, unsigned int flags):
    """ Opens an interprocess memory handle exported from another process and returns a device pointer usable in the local process.

    Maps memory exported from another process with
    :py:obj:`~.cudaIpcGetMemHandle` into the current device address space.
    For contexts on different devices :py:obj:`~.cudaIpcOpenMemHandle` can
    attempt to enable peer access between the devices as if the user called
    :py:obj:`~.cudaDeviceEnablePeerAccess`. This behavior is controlled by
    the :py:obj:`~.cudaIpcMemLazyEnablePeerAccess` flag.
    :py:obj:`~.cudaDeviceCanAccessPeer` can determine if a mapping is
    possible.

    :py:obj:`~.cudaIpcOpenMemHandle` can open handles to devices that may
    not be visible in the process calling the API.

    Contexts that may open :py:obj:`~.cudaIpcMemHandles` are restricted in
    the following way. :py:obj:`~.cudaIpcMemHandles` from each device in a
    given process may only be opened by one context per device per other
    process.

    If the memory handle has already been opened by the current context,
    the reference count on the handle is incremented by 1 and the existing
    device pointer is returned.

    Memory returned from :py:obj:`~.cudaIpcOpenMemHandle` must be freed
    with :py:obj:`~.cudaIpcCloseMemHandle`.

    Calling :py:obj:`~.cudaFree` on an exported memory region before
    calling :py:obj:`~.cudaIpcCloseMemHandle` in the importing context will
    result in undefined behavior.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is supported for compatibility purposes but not recommended as
    it comes with performance cost. Users can test their device for IPC
    functionality by calling :py:obj:`~.cudaDeviceGetAttribute` with
    :py:obj:`~.cudaDevAttrIpcEventSupport`

    Parameters
    ----------
    handle : :py:obj:`~.cudaIpcMemHandle_t`
        :py:obj:`~.cudaIpcMemHandle` to open
    flags : unsigned int
        Flags for this operation. Must be specified as
        :py:obj:`~.cudaIpcMemLazyEnablePeerAccess`

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorMapBufferObjectFailed`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorDeviceUninitialized`, :py:obj:`~.cudaErrorTooManyPeers`, :py:obj:`~.cudaErrorNotSupported`, :py:obj:`~.cudaErrorInvalidValue`
    devPtr : Any
        Returned device pointer

    See Also
    --------
    :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaIpcGetEventHandle`, :py:obj:`~.cudaIpcOpenEventHandle`, :py:obj:`~.cudaIpcGetMemHandle`, :py:obj:`~.cudaIpcCloseMemHandle`, :py:obj:`~.cudaDeviceEnablePeerAccess`, :py:obj:`~.cudaDeviceCanAccessPeer`, :py:obj:`~.cuIpcOpenMemHandle`

    Notes
    -----
    No guarantees are made about the address returned in `*devPtr`. 
     In particular, multiple processes may not receive the same address for the same `handle`.
    """
    cdef void_ptr devPtr = 0
    with nogil:
        err = cyruntime.cudaIpcOpenMemHandle(<void**>&devPtr, handle._pvt_ptr[0], flags)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], devPtr)

@cython.embedsignature(True)
def cudaIpcCloseMemHandle(devPtr):
    """ Attempts to close memory mapped with cudaIpcOpenMemHandle.

    Decrements the reference count of the memory returnd by
    :py:obj:`~.cudaIpcOpenMemHandle` by 1. When the reference count reaches
    0, this API unmaps the memory. The original allocation in the exporting
    process as well as imported mappings in other processes will be
    unaffected.

    Any resources used to enable peer access will be freed if this is the
    last mapping using them.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is supported for compatibility purposes but not recommended as
    it comes with performance cost. Users can test their device for IPC
    functionality by calling :py:obj:`~.cudaDeviceGetAttribute` with
    :py:obj:`~.cudaDevAttrIpcEventSupport`

    Parameters
    ----------
    devPtr : Any
        Device pointer returned by :py:obj:`~.cudaIpcOpenMemHandle`

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorMapBufferObjectFailed`, :py:obj:`~.cudaErrorNotSupported`, :py:obj:`~.cudaErrorInvalidValue`

    See Also
    --------
    :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaIpcGetEventHandle`, :py:obj:`~.cudaIpcOpenEventHandle`, :py:obj:`~.cudaIpcGetMemHandle`, :py:obj:`~.cudaIpcOpenMemHandle`, :py:obj:`~.cuIpcCloseMemHandle`
    """
    cydevPtr = _HelperInputVoidPtr(devPtr)
    cdef void* cydevPtr_ptr = <void*><void_ptr>cydevPtr.cptr
    with nogil:
        err = cyruntime.cudaIpcCloseMemHandle(cydevPtr_ptr)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaDeviceFlushGPUDirectRDMAWrites(target not None : cudaFlushGPUDirectRDMAWritesTarget, scope not None : cudaFlushGPUDirectRDMAWritesScope):
    """ Blocks until remote writes are visible to the specified scope.

    Blocks until remote writes to the target context via mappings created
    through GPUDirect RDMA APIs, like nvidia_p2p_get_pages (see
    https://docs.nvidia.com/cuda/gpudirect-rdma for more information), are
    visible to the specified scope.

    If the scope equals or lies within the scope indicated by
    :py:obj:`~.cudaDevAttrGPUDirectRDMAWritesOrdering`, the call will be a
    no-op and can be safely omitted for performance. This can be determined
    by comparing the numerical values between the two enums, with smaller
    scopes having smaller values.

    Users may query support for this API via
    :py:obj:`~.cudaDevAttrGPUDirectRDMAFlushWritesOptions`.

    Parameters
    ----------
    target : :py:obj:`~.cudaFlushGPUDirectRDMAWritesTarget`
        The target of the operation, see cudaFlushGPUDirectRDMAWritesTarget
    scope : :py:obj:`~.cudaFlushGPUDirectRDMAWritesScope`
        The scope of the operation, see cudaFlushGPUDirectRDMAWritesScope

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorNotSupported`,

    See Also
    --------
    :py:obj:`~.cuFlushGPUDirectRDMAWrites`
    """
    cdef cyruntime.cudaFlushGPUDirectRDMAWritesTarget cytarget = target.value
    cdef cyruntime.cudaFlushGPUDirectRDMAWritesScope cyscope = scope.value
    with nogil:
        err = cyruntime.cudaDeviceFlushGPUDirectRDMAWrites(cytarget, cyscope)
    return (_dict_cudaError_t[err],)

ctypedef struct cudaAsyncCallbackData_st:
    cyruntime.cudaAsyncCallback callback
    void *userData

ctypedef cudaAsyncCallbackData_st cudaAsyncCallbackData

@cython.show_performance_hints(False)
cdef void cudaAsyncNotificationCallbackWrapper(cyruntime.cudaAsyncNotificationInfo_t *info, void *data, cyruntime.cudaAsyncCallbackHandle_t handle) nogil:
    cdef cudaAsyncCallbackData *cbData = <cudaAsyncCallbackData *>data
    with gil:
        cbData.callback(info, cbData.userData, handle)

@cython.embedsignature(True)
def cudaDeviceRegisterAsyncNotification(int device, callbackFunc, userData):
    """ Registers a callback function to receive async notifications.

    Registers `callbackFunc` to receive async notifications.

    The `userData` parameter is passed to the callback function at async
    notification time. Likewise, `callback` is also passed to the callback
    function to distinguish between multiple registered callbacks.

    The callback function being registered should be designed to return
    quickly (~10ms). Any long running tasks should be queued for execution
    on an application thread.

    Callbacks may not call cudaDeviceRegisterAsyncNotification or
    cudaDeviceUnregisterAsyncNotification. Doing so will result in
    :py:obj:`~.cudaErrorNotPermitted`. Async notification callbacks execute
    in an undefined order and may be serialized.

    Returns in `*callback` a handle representing the registered callback
    instance.

    Parameters
    ----------
    device : int
        The device on which to register the callback
    callbackFunc : :py:obj:`~.cudaAsyncCallback`
        The function to register as a callback
    userData : Any
        A generic pointer to user data. This is passed into the callback
        function.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess` :py:obj:`~.cudaErrorNotSupported` :py:obj:`~.cudaErrorInvalidDevice` :py:obj:`~.cudaErrorInvalidValue` :py:obj:`~.cudaErrorNotPermitted` :py:obj:`~.cudaErrorUnknown`
    callback : :py:obj:`~.cudaAsyncCallbackHandle_t`
        A handle representing the registered callback instance

    See Also
    --------
    :py:obj:`~.cudaDeviceUnregisterAsyncNotification`
    """
    cdef cyruntime.cudaAsyncCallback cycallbackFunc
    if callbackFunc is None:
        pcallbackFunc = 0
    elif isinstance(callbackFunc, (cudaAsyncCallback,)):
        pcallbackFunc = int(callbackFunc)
    else:
        pcallbackFunc = int(cudaAsyncCallback(callbackFunc))
    cycallbackFunc = <cyruntime.cudaAsyncCallback><void_ptr>pcallbackFunc
    cyuserData = _HelperInputVoidPtr(userData)
    cdef void* cyuserData_ptr = <void*><void_ptr>cyuserData.cptr

    cdef cudaAsyncCallbackData *cbData = NULL
    cbData = <cudaAsyncCallbackData *>malloc(sizeof(cbData[0]))
    if cbData == NULL:
        return (cudaError_t.cudaErrorMemoryAllocation, None)
    cbData.callback = cycallbackFunc
    cbData.userData = cyuserData_ptr

    cdef cudaAsyncCallbackHandle_t callback = cudaAsyncCallbackHandle_t()
    with nogil:
        err = cyruntime.cudaDeviceRegisterAsyncNotification(device, <cyruntime.cudaAsyncCallback>cudaAsyncNotificationCallbackWrapper, <void *>cbData, <cyruntime.cudaAsyncCallbackHandle_t*>callback._pvt_ptr)
    if err != cyruntime.cudaSuccess:
        free(cbData)
    else:
        m_global._allocated[int(callback)] = cbData
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], callback)

@cython.embedsignature(True)
def cudaDeviceUnregisterAsyncNotification(int device, callback):
    """ Unregisters an async notification callback.

    Unregisters `callback` so that the corresponding callback function will
    stop receiving async notifications.

    Parameters
    ----------
    device : int
        The device from which to remove `callback`.
    callback : :py:obj:`~.cudaAsyncCallbackHandle_t`
        The callback instance to unregister from receiving async
        notifications.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess` :py:obj:`~.cudaErrorNotSupported` :py:obj:`~.cudaErrorInvalidDevice` :py:obj:`~.cudaErrorInvalidValue` :py:obj:`~.cudaErrorNotPermitted` :py:obj:`~.cudaErrorUnknown`

    See Also
    --------
    :py:obj:`~.cudaDeviceRegisterAsyncNotification`
    """
    cdef cyruntime.cudaAsyncCallbackHandle_t cycallback
    if callback is None:
        pcallback = 0
    elif isinstance(callback, (cudaAsyncCallbackHandle_t,)):
        pcallback = int(callback)
    else:
        pcallback = int(cudaAsyncCallbackHandle_t(callback))
    cycallback = <cyruntime.cudaAsyncCallbackHandle_t><void_ptr>pcallback
    with nogil:
        err = cyruntime.cudaDeviceUnregisterAsyncNotification(device, cycallback)
    if err == cyruntime.cudaSuccess:
        free(m_global._allocated[pcallback])
        m_global._allocated.erase(<void_ptr>pcallback)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaDeviceGetSharedMemConfig():
    """ Returns the shared memory configuration for the current device.

    [Deprecated]

    This function will return in `pConfig` the current size of shared
    memory banks on the current device. On devices with configurable shared
    memory banks, :py:obj:`~.cudaDeviceSetSharedMemConfig` can be used to
    change this setting, so that all subsequent kernel launches will by
    default use the new bank size. When
    :py:obj:`~.cudaDeviceGetSharedMemConfig` is called on devices without
    configurable shared memory, it will return the fixed bank size of the
    hardware.

    The returned bank configurations can be either:

    - :py:obj:`~.cudaSharedMemBankSizeFourByte` - shared memory bank width
      is four bytes.

    - :py:obj:`~.cudaSharedMemBankSizeEightByte` - shared memory bank width
      is eight bytes.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`
    pConfig : :py:obj:`~.cudaSharedMemConfig`
        Returned cache configuration

    See Also
    --------
    :py:obj:`~.cudaDeviceSetCacheConfig`, :py:obj:`~.cudaDeviceGetCacheConfig`, :py:obj:`~.cudaDeviceSetSharedMemConfig`, :py:obj:`~.cudaFuncSetCacheConfig`, :py:obj:`~.cuCtxGetSharedMemConfig`
    """
    cdef cyruntime.cudaSharedMemConfig pConfig
    with nogil:
        err = cyruntime.cudaDeviceGetSharedMemConfig(&pConfig)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], cudaSharedMemConfig(pConfig))

@cython.embedsignature(True)
def cudaDeviceSetSharedMemConfig(config not None : cudaSharedMemConfig):
    """ Sets the shared memory configuration for the current device.

    [Deprecated]

    On devices with configurable shared memory banks, this function will
    set the shared memory bank size which is used for all subsequent kernel
    launches. Any per-function setting of shared memory set via
    :py:obj:`~.cudaFuncSetSharedMemConfig` will override the device wide
    setting.

    Changing the shared memory configuration between launches may introduce
    a device side synchronization point.

    Changing the shared memory bank size will not increase shared memory
    usage or affect occupancy of kernels, but may have major effects on
    performance. Larger bank sizes will allow for greater potential
    bandwidth to shared memory, but will change what kinds of accesses to
    shared memory will result in bank conflicts.

    This function will do nothing on devices with fixed shared memory bank
    size.

    The supported bank configurations are:

    - :py:obj:`~.cudaSharedMemBankSizeDefault`: set bank width the device
      default (currently, four bytes)

    - :py:obj:`~.cudaSharedMemBankSizeFourByte`: set shared memory bank
      width to be four bytes natively.

    - :py:obj:`~.cudaSharedMemBankSizeEightByte`: set shared memory bank
      width to be eight bytes natively.

    Parameters
    ----------
    config : :py:obj:`~.cudaSharedMemConfig`
        Requested cache configuration

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`

    See Also
    --------
    :py:obj:`~.cudaDeviceSetCacheConfig`, :py:obj:`~.cudaDeviceGetCacheConfig`, :py:obj:`~.cudaDeviceGetSharedMemConfig`, :py:obj:`~.cudaFuncSetCacheConfig`, :py:obj:`~.cuCtxSetSharedMemConfig`
    """
    cdef cyruntime.cudaSharedMemConfig cyconfig = config.value
    with nogil:
        err = cyruntime.cudaDeviceSetSharedMemConfig(cyconfig)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaGetLastError():
    """ Returns the last error from a runtime call.

    Returns the last error that has been produced by any of the runtime
    calls in the same instance of the CUDA Runtime library in the host
    thread and resets it to :py:obj:`~.cudaSuccess`.

    Note: Multiple instances of the CUDA Runtime library can be present in
    an application when using a library that statically links the CUDA
    Runtime.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorMissingConfiguration`, :py:obj:`~.cudaErrorMemoryAllocation`, :py:obj:`~.cudaErrorInitializationError`, :py:obj:`~.cudaErrorLaunchFailure`, :py:obj:`~.cudaErrorLaunchTimeout`, :py:obj:`~.cudaErrorLaunchOutOfResources`, :py:obj:`~.cudaErrorInvalidDeviceFunction`, :py:obj:`~.cudaErrorInvalidConfiguration`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidPitchValue`, :py:obj:`~.cudaErrorInvalidSymbol`, :py:obj:`~.cudaErrorUnmapBufferObjectFailed`, :py:obj:`~.cudaErrorInvalidDevicePointer`, :py:obj:`~.cudaErrorInvalidTexture`, :py:obj:`~.cudaErrorInvalidTextureBinding`, :py:obj:`~.cudaErrorInvalidChannelDescriptor`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`, :py:obj:`~.cudaErrorInvalidFilterSetting`, :py:obj:`~.cudaErrorInvalidNormSetting`, :py:obj:`~.cudaErrorUnknown`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorInsufficientDriver`, :py:obj:`~.cudaErrorNoDevice`, :py:obj:`~.cudaErrorSetOnActiveProcess`, :py:obj:`~.cudaErrorStartupFailure`, :py:obj:`~.cudaErrorInvalidPtx`, :py:obj:`~.cudaErrorUnsupportedPtxVersion`, :py:obj:`~.cudaErrorNoKernelImageForDevice`, :py:obj:`~.cudaErrorJitCompilerNotFound`, :py:obj:`~.cudaErrorJitCompilationDisabled`

    See Also
    --------
    :py:obj:`~.cudaPeekAtLastError`, :py:obj:`~.cudaGetErrorName`, :py:obj:`~.cudaGetErrorString`, :py:obj:`~.cudaError`
    """
    with nogil:
        err = cyruntime.cudaGetLastError()
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaPeekAtLastError():
    """ Returns the last error from a runtime call.

    Returns the last error that has been produced by any of the runtime
    calls in the same instance of the CUDA Runtime library in the host
    thread. This call does not reset the error to :py:obj:`~.cudaSuccess`
    like :py:obj:`~.cudaGetLastError()`.

    Note: Multiple instances of the CUDA Runtime library can be present in
    an application when using a library that statically links the CUDA
    Runtime.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorMissingConfiguration`, :py:obj:`~.cudaErrorMemoryAllocation`, :py:obj:`~.cudaErrorInitializationError`, :py:obj:`~.cudaErrorLaunchFailure`, :py:obj:`~.cudaErrorLaunchTimeout`, :py:obj:`~.cudaErrorLaunchOutOfResources`, :py:obj:`~.cudaErrorInvalidDeviceFunction`, :py:obj:`~.cudaErrorInvalidConfiguration`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidPitchValue`, :py:obj:`~.cudaErrorInvalidSymbol`, :py:obj:`~.cudaErrorUnmapBufferObjectFailed`, :py:obj:`~.cudaErrorInvalidDevicePointer`, :py:obj:`~.cudaErrorInvalidTexture`, :py:obj:`~.cudaErrorInvalidTextureBinding`, :py:obj:`~.cudaErrorInvalidChannelDescriptor`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`, :py:obj:`~.cudaErrorInvalidFilterSetting`, :py:obj:`~.cudaErrorInvalidNormSetting`, :py:obj:`~.cudaErrorUnknown`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorInsufficientDriver`, :py:obj:`~.cudaErrorNoDevice`, :py:obj:`~.cudaErrorSetOnActiveProcess`, :py:obj:`~.cudaErrorStartupFailure`, :py:obj:`~.cudaErrorInvalidPtx`, :py:obj:`~.cudaErrorUnsupportedPtxVersion`, :py:obj:`~.cudaErrorNoKernelImageForDevice`, :py:obj:`~.cudaErrorJitCompilerNotFound`, :py:obj:`~.cudaErrorJitCompilationDisabled`

    See Also
    --------
    :py:obj:`~.cudaGetLastError`, :py:obj:`~.cudaGetErrorName`, :py:obj:`~.cudaGetErrorString`, :py:obj:`~.cudaError`
    """
    with nogil:
        err = cyruntime.cudaPeekAtLastError()
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaGetErrorName(error not None : cudaError_t):
    """ Returns the string representation of an error code enum name.

    Returns a string containing the name of an error code in the enum. If
    the error code is not recognized, "unrecognized error code" is
    returned.

    Parameters
    ----------
    error : :py:obj:`~.cudaError_t`
        Error code to convert to string

    Returns
    -------
    cudaError_t.cudaSuccess
        cudaError_t.cudaSuccess
    bytes
        `char*` pointer to a NULL-terminated string

    See Also
    --------
    :py:obj:`~.cudaGetErrorString`, :py:obj:`~.cudaGetLastError`, :py:obj:`~.cudaPeekAtLastError`, :py:obj:`~.cudaError`, :py:obj:`~.cuGetErrorName`
    """
    cdef cyruntime.cudaError_t cyerror = error.value
    with nogil:
        err = cyruntime.cudaGetErrorName(cyerror)
    return (cudaError_t.cudaSuccess, err)

@cython.embedsignature(True)
def cudaGetErrorString(error not None : cudaError_t):
    """ Returns the description string for an error code.

    Returns the description string for an error code. If the error code is
    not recognized, "unrecognized error code" is returned.

    Parameters
    ----------
    error : :py:obj:`~.cudaError_t`
        Error code to convert to string

    Returns
    -------
    cudaError_t.cudaSuccess
        cudaError_t.cudaSuccess
    bytes
        `char*` pointer to a NULL-terminated string

    See Also
    --------
    :py:obj:`~.cudaGetErrorName`, :py:obj:`~.cudaGetLastError`, :py:obj:`~.cudaPeekAtLastError`, :py:obj:`~.cudaError`, :py:obj:`~.cuGetErrorString`
    """
    cdef cyruntime.cudaError_t cyerror = error.value
    with nogil:
        err = cyruntime.cudaGetErrorString(cyerror)
    return (cudaError_t.cudaSuccess, err)

@cython.embedsignature(True)
def cudaGetDeviceCount():
    """ Returns the number of compute-capable devices.

    Returns in `*count` the number of devices with compute capability
    greater or equal to 2.0 that are available for execution.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`
    count : int
        Returns the number of devices with compute capability greater or
        equal to 2.0

    See Also
    --------
    :py:obj:`~.cudaGetDevice`, :py:obj:`~.cudaSetDevice`, :py:obj:`~.cudaGetDeviceProperties`, :py:obj:`~.cudaChooseDevice`, :py:obj:`~.cudaInitDevice`, :py:obj:`~.cuDeviceGetCount`
    """
    cdef int count = 0
    with nogil:
        err = cyruntime.cudaGetDeviceCount(&count)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], count)

@cython.embedsignature(True)
def cudaGetDeviceProperties(int device):
    """ Returns information about the compute-device.

    Returns in `*prop` the properties of device `dev`.

    Parameters
    ----------
    device : int
        Device number to get properties for

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDevice`
    prop : :py:obj:`~.cudaDeviceProp`
        Properties for the specified device

    See Also
    --------
    :py:obj:`~.cudaGetDeviceCount`, :py:obj:`~.cudaGetDevice`, :py:obj:`~.cudaSetDevice`, :py:obj:`~.cudaChooseDevice`, :py:obj:`~.cudaDeviceGetAttribute`, :py:obj:`~.cudaInitDevice`, :py:obj:`~.cuDeviceGetAttribute`, :py:obj:`~.cuDeviceGetName`
    """
    cdef cudaDeviceProp prop = cudaDeviceProp()
    with nogil:
        err = cyruntime.cudaGetDeviceProperties(<cyruntime.cudaDeviceProp*>prop._pvt_ptr, device)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], prop)

@cython.embedsignature(True)
def cudaDeviceGetAttribute(attr not None : cudaDeviceAttr, int device):
    """ Returns information about the device.

    Returns in `*value` the integer value of the attribute `attr` on device
    `device`.

    Parameters
    ----------
    attr : :py:obj:`~.cudaDeviceAttr`
        Device attribute to query
    device : int
        Device number to query

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorInvalidValue`
    value : int
        Returned device attribute value

    See Also
    --------
    :py:obj:`~.cudaGetDeviceCount`, :py:obj:`~.cudaGetDevice`, :py:obj:`~.cudaSetDevice`, :py:obj:`~.cudaChooseDevice`, :py:obj:`~.cudaGetDeviceProperties`, :py:obj:`~.cudaInitDevice`, :py:obj:`~.cuDeviceGetAttribute`
    """
    cdef int value = 0
    cdef cyruntime.cudaDeviceAttr cyattr = attr.value
    with nogil:
        err = cyruntime.cudaDeviceGetAttribute(&value, cyattr, device)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], value)

@cython.embedsignature(True)
def cudaDeviceGetHostAtomicCapabilities(operations : Optional[tuple[cudaAtomicOperation] | list[cudaAtomicOperation]], unsigned int count, int device):
    """ Queries details about atomic operations supported between the device and host.

    Returns in `*capabilities` the details about requested atomic
    `*operations` over the the link between `dev` and the host. The
    allocated size of `*operations` and `*capabilities` must be `count`.

    For each :py:obj:`~.cudaAtomicOperation` in `*operations`, the
    corresponding result in `*capabilities` will be a bitmask indicating
    which of :py:obj:`~.cudaAtomicOperationCapability` the link supports
    natively.

    Returns :py:obj:`~.cudaErrorInvalidDevice` if `dev` is not valid.

    Returns :py:obj:`~.cudaErrorInvalidValue` if `*capabilities` or
    `*operations` is NULL, if `count` is 0, or if any of `*operations` is
    not valid.

    Parameters
    ----------
    operations : list[:py:obj:`~.cudaAtomicOperation`]
        Requested operations
    count : unsigned int
        Count of requested operations and size of capabilities
    dev : int
        Device handle

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorInvalidValue`
    capabilities : list[unsigned int]
        Returned capability details of each requested operation

    See Also
    --------
    :py:obj:`~.cudaDeviceGetAttribute`, :py:obj:`~.cudaDeviceGetP2PAtomicCapabilities`, :py:obj:`~.cuDeviceGeHostAtomicCapabilities`
    """
    operations = [] if operations is None else operations
    if not all(isinstance(_x, (cudaAtomicOperation)) for _x in operations):
        raise TypeError("Argument 'operations' is not instance of type (expected tuple[cyruntime.cudaAtomicOperation] or list[cyruntime.cudaAtomicOperation]")
    cdef unsigned int* cycapabilities = NULL
    pycapabilities = []
    if count != 0:
        cycapabilities = <unsigned int*>calloc(count, sizeof(unsigned int))
        if cycapabilities is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(count) + 'x' + str(sizeof(unsigned int)))
    cdef vector[cyruntime.cudaAtomicOperation] cyoperations = [pyoperations.value for pyoperations in (operations)]
    if count > len(operations): raise RuntimeError("List is too small: " + str(len(operations)) + " < " + str(count))
    with nogil:
        err = cyruntime.cudaDeviceGetHostAtomicCapabilities(cycapabilities, cyoperations.data(), count, device)
    if cudaError_t(err) == cudaError_t(0):
        pycapabilities = [<unsigned int>cycapabilities[idx] for idx in range(count)]
    if cycapabilities is not NULL:
        free(cycapabilities)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pycapabilities)

@cython.embedsignature(True)
def cudaDeviceGetDefaultMemPool(int device):
    """ Returns the default mempool of a device.

    The default mempool of a device contains device memory from that
    device.

    Parameters
    ----------
    device : int
        None

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorInvalidValue` :py:obj:`~.cudaErrorNotSupported`
    memPool : :py:obj:`~.cudaMemPool_t`
        None

    See Also
    --------
    :py:obj:`~.cuDeviceGetDefaultMemPool`, :py:obj:`~.cudaMallocAsync`, :py:obj:`~.cudaMemPoolTrimTo`, :py:obj:`~.cudaMemPoolGetAttribute`, :py:obj:`~.cudaDeviceSetMemPool`, :py:obj:`~.cudaMemPoolSetAttribute`, :py:obj:`~.cudaMemPoolSetAccess`
    """
    cdef cudaMemPool_t memPool = cudaMemPool_t()
    with nogil:
        err = cyruntime.cudaDeviceGetDefaultMemPool(<cyruntime.cudaMemPool_t*>memPool._pvt_ptr, device)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], memPool)

@cython.embedsignature(True)
def cudaDeviceSetMemPool(int device, memPool):
    """ Sets the current memory pool of a device.

    The memory pool must be local to the specified device. Unless a mempool
    is specified in the :py:obj:`~.cudaMallocAsync` call,
    :py:obj:`~.cudaMallocAsync` allocates from the current mempool of the
    provided stream's device. By default, a device's current memory pool is
    its default memory pool.

    Parameters
    ----------
    device : int
        None
    memPool : :py:obj:`~.CUmemoryPool` or :py:obj:`~.cudaMemPool_t`
        None

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue` :py:obj:`~.cudaErrorInvalidDevice` :py:obj:`~.cudaErrorNotSupported`

    See Also
    --------
    :py:obj:`~.cuDeviceSetMemPool`, :py:obj:`~.cudaDeviceGetMemPool`, :py:obj:`~.cudaDeviceGetDefaultMemPool`, :py:obj:`~.cudaMemPoolCreate`, :py:obj:`~.cudaMemPoolDestroy`, :py:obj:`~.cudaMallocFromPoolAsync`

    Notes
    -----
    Use :py:obj:`~.cudaMallocFromPoolAsync` to specify asynchronous allocations from a device different than the one the stream runs on.
    """
    cdef cyruntime.cudaMemPool_t cymemPool
    if memPool is None:
        pmemPool = 0
    elif isinstance(memPool, (cudaMemPool_t,driver.CUmemoryPool)):
        pmemPool = int(memPool)
    else:
        pmemPool = int(cudaMemPool_t(memPool))
    cymemPool = <cyruntime.cudaMemPool_t><void_ptr>pmemPool
    with nogil:
        err = cyruntime.cudaDeviceSetMemPool(device, cymemPool)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaDeviceGetMemPool(int device):
    """ Gets the current mempool for a device.

    Returns the last pool provided to :py:obj:`~.cudaDeviceSetMemPool` for
    this device or the device's default memory pool if
    :py:obj:`~.cudaDeviceSetMemPool` has never been called. By default the
    current mempool is the default mempool for a device, otherwise the
    returned pool must have been set with :py:obj:`~.cuDeviceSetMemPool` or
    :py:obj:`~.cudaDeviceSetMemPool`.

    Parameters
    ----------
    device : int
        None

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue` :py:obj:`~.cudaErrorNotSupported`
    memPool : :py:obj:`~.cudaMemPool_t`
        None

    See Also
    --------
    :py:obj:`~.cuDeviceGetMemPool`, :py:obj:`~.cudaDeviceGetDefaultMemPool`, :py:obj:`~.cudaDeviceSetMemPool`
    """
    cdef cudaMemPool_t memPool = cudaMemPool_t()
    with nogil:
        err = cyruntime.cudaDeviceGetMemPool(<cyruntime.cudaMemPool_t*>memPool._pvt_ptr, device)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], memPool)

@cython.embedsignature(True)
def cudaDeviceGetNvSciSyncAttributes(nvSciSyncAttrList, int device, int flags):
    """ Return NvSciSync attributes that this device can support.

    Returns in `nvSciSyncAttrList`, the properties of NvSciSync that this
    CUDA device, `dev` can support. The returned `nvSciSyncAttrList` can be
    used to create an NvSciSync that matches this device's capabilities.

    If NvSciSyncAttrKey_RequiredPerm field in `nvSciSyncAttrList` is
    already set this API will return :py:obj:`~.cudaErrorInvalidValue`.

    The applications should set `nvSciSyncAttrList` to a valid
    NvSciSyncAttrList failing which this API will return
    :py:obj:`~.cudaErrorInvalidHandle`.

    The `flags` controls how applications intends to use the NvSciSync
    created from the `nvSciSyncAttrList`. The valid flags are:

    - :py:obj:`~.cudaNvSciSyncAttrSignal`, specifies that the applications
      intends to signal an NvSciSync on this CUDA device.

    - :py:obj:`~.cudaNvSciSyncAttrWait`, specifies that the applications
      intends to wait on an NvSciSync on this CUDA device.

    At least one of these flags must be set, failing which the API returns
    :py:obj:`~.cudaErrorInvalidValue`. Both the flags are orthogonal to one
    another: a developer may set both these flags that allows to set both
    wait and signal specific attributes in the same `nvSciSyncAttrList`.

    Note that this API updates the input `nvSciSyncAttrList` with values
    equivalent to the following public attribute key-values:
    NvSciSyncAttrKey_RequiredPerm is set to

    - NvSciSyncAccessPerm_SignalOnly if :py:obj:`~.cudaNvSciSyncAttrSignal`
      is set in `flags`.

    - NvSciSyncAccessPerm_WaitOnly if :py:obj:`~.cudaNvSciSyncAttrWait` is
      set in `flags`.

    - NvSciSyncAccessPerm_WaitSignal if both
      :py:obj:`~.cudaNvSciSyncAttrWait` and
      :py:obj:`~.cudaNvSciSyncAttrSignal` are set in `flags`.
      NvSciSyncAttrKey_PrimitiveInfo is set to

    - NvSciSyncAttrValPrimitiveType_SysmemSemaphore on any valid `device`.

    - NvSciSyncAttrValPrimitiveType_Syncpoint if `device` is a Tegra
      device.

    - NvSciSyncAttrValPrimitiveType_SysmemSemaphorePayload64b if `device`
      is GA10X+. NvSciSyncAttrKey_GpuId is set to the same UUID that is
      returned in `None` from :py:obj:`~.cudaDeviceGetProperties` for this
      `device`.

    :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorDeviceUninitialized`,
    :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidHandle`,
    :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorNotSupported`,
    :py:obj:`~.cudaErrorMemoryAllocation`

    Parameters
    ----------
    nvSciSyncAttrList : Any
        Return NvSciSync attributes supported.
    device : int
        Valid Cuda Device to get NvSciSync attributes for.
    flags : int
        flags describing NvSciSync usage.

    Returns
    -------
    cudaError_t


    See Also
    --------
    :py:obj:`~.cudaImportExternalSemaphore`, :py:obj:`~.cudaDestroyExternalSemaphore`, :py:obj:`~.cudaSignalExternalSemaphoresAsync`, :py:obj:`~.cudaWaitExternalSemaphoresAsync`
    """
    cynvSciSyncAttrList = _HelperInputVoidPtr(nvSciSyncAttrList)
    cdef void* cynvSciSyncAttrList_ptr = <void*><void_ptr>cynvSciSyncAttrList.cptr
    with nogil:
        err = cyruntime.cudaDeviceGetNvSciSyncAttributes(cynvSciSyncAttrList_ptr, device, flags)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaDeviceGetP2PAttribute(attr not None : cudaDeviceP2PAttr, int srcDevice, int dstDevice):
    """ Queries attributes of the link between two devices.

    Returns in `*value` the value of the requested attribute `attrib` of
    the link between `srcDevice` and `dstDevice`. The supported attributes
    are:

    - :py:obj:`~.cudaDevP2PAttrPerformanceRank`: A relative value
      indicating the performance of the link between two devices. Lower
      value means better performance (0 being the value used for most
      performant link).

    - :py:obj:`~.cudaDevP2PAttrAccessSupported`: 1 if peer access is
      enabled.

    - :py:obj:`~.cudaDevP2PAttrNativeAtomicSupported`: 1 if all native
      atomic operations over the link are supported.

    - :py:obj:`~.cudaDevP2PAttrCudaArrayAccessSupported`: 1 if accessing
      CUDA arrays over the link is supported.

    - :py:obj:`~.cudaDevP2PAttrOnlyPartialNativeAtomicSupported`: 1 if some
      CUDA-valid atomic operations over the link are supported. Information
      about specific operations can be retrieved with
      :py:obj:`~.cudaDeviceGetP2PAtomicCapabilities`.

    Returns :py:obj:`~.cudaErrorInvalidDevice` if `srcDevice` or
    `dstDevice` are not valid or if they represent the same device.

    Returns :py:obj:`~.cudaErrorInvalidValue` if `attrib` is not valid or
    if `value` is a null pointer.

    Parameters
    ----------
    attrib : :py:obj:`~.cudaDeviceP2PAttr`
        The requested attribute of the link between `srcDevice` and
        `dstDevice`.
    srcDevice : int
        The source device of the target link.
    dstDevice : int
        The destination device of the target link.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorInvalidValue`
    value : int
        Returned value of the requested attribute

    See Also
    --------
    :py:obj:`~.cudaDeviceEnablePeerAccess`, :py:obj:`~.cudaDeviceDisablePeerAccess`, :py:obj:`~.cudaDeviceCanAccessPeer`, :py:obj:`~.cuDeviceGetP2PAttribute` :py:obj:`~.cudaDeviceGetP2PAtomicCapabilities`
    """
    cdef int value = 0
    cdef cyruntime.cudaDeviceP2PAttr cyattr = attr.value
    with nogil:
        err = cyruntime.cudaDeviceGetP2PAttribute(&value, cyattr, srcDevice, dstDevice)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], value)

@cython.embedsignature(True)
def cudaDeviceGetP2PAtomicCapabilities(operations : Optional[tuple[cudaAtomicOperation] | list[cudaAtomicOperation]], unsigned int count, int srcDevice, int dstDevice):
    """ Queries details about atomic operations supported between two devices.

    Returns in `*capabilities` the details about requested atomic
    `*operations` over the the link between `srcDevice` and `dstDevice`.
    The allocated size of `*operations` and `*capabilities` must be
    `count`.

    For each :py:obj:`~.cudaAtomicOperation` in `*operations`, the
    corresponding result in `*capabilities` will be a bitmask indicating
    which of :py:obj:`~.cudaAtomicOperationCapability` the link supports
    natively.

    Returns :py:obj:`~.cudaErrorInvalidDevice` if `srcDevice` or
    `dstDevice` are not valid or if they represent the same device.

    Returns :py:obj:`~.cudaErrorInvalidValue` if `*capabilities` or
    `*operations` is NULL, if `count` is 0, or if any of `*operations` is
    not valid.

    Parameters
    ----------
    operations : list[:py:obj:`~.cudaAtomicOperation`]
        Requested operations
    count : unsigned int
        Count of requested operations and size of capabilities
    srcDevice : int
        The source device of the target link
    dstDevice : int
        The destination device of the target link

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorInvalidValue`
    capabilities : list[unsigned int]
        Returned capability details of each requested operation

    See Also
    --------
    :py:obj:`~.cudaDeviceGetP2PAttribute`, :py:obj:`~.cuDeviceGetP2PAttribute`, :py:obj:`~.cuDeviceGetP2PAtomicCapabilities`
    """
    operations = [] if operations is None else operations
    if not all(isinstance(_x, (cudaAtomicOperation)) for _x in operations):
        raise TypeError("Argument 'operations' is not instance of type (expected tuple[cyruntime.cudaAtomicOperation] or list[cyruntime.cudaAtomicOperation]")
    cdef unsigned int* cycapabilities = NULL
    pycapabilities = []
    if count != 0:
        cycapabilities = <unsigned int*>calloc(count, sizeof(unsigned int))
        if cycapabilities is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(count) + 'x' + str(sizeof(unsigned int)))
    cdef vector[cyruntime.cudaAtomicOperation] cyoperations = [pyoperations.value for pyoperations in (operations)]
    if count > len(operations): raise RuntimeError("List is too small: " + str(len(operations)) + " < " + str(count))
    with nogil:
        err = cyruntime.cudaDeviceGetP2PAtomicCapabilities(cycapabilities, cyoperations.data(), count, srcDevice, dstDevice)
    if cudaError_t(err) == cudaError_t(0):
        pycapabilities = [<unsigned int>cycapabilities[idx] for idx in range(count)]
    if cycapabilities is not NULL:
        free(cycapabilities)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pycapabilities)

@cython.embedsignature(True)
def cudaChooseDevice(prop : Optional[cudaDeviceProp]):
    """ Select compute-device which best matches criteria.

    Returns in `*device` the device which has properties that best match
    `*prop`.

    Parameters
    ----------
    prop : :py:obj:`~.cudaDeviceProp`
        Desired device properties

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`
    device : int
        Device with best match

    See Also
    --------
    :py:obj:`~.cudaGetDeviceCount`, :py:obj:`~.cudaGetDevice`, :py:obj:`~.cudaSetDevice`, :py:obj:`~.cudaGetDeviceProperties`, :py:obj:`~.cudaInitDevice`
    """
    cdef int device = 0
    cdef cyruntime.cudaDeviceProp* cyprop_ptr = prop._pvt_ptr if prop is not None else NULL
    with nogil:
        err = cyruntime.cudaChooseDevice(&device, cyprop_ptr)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], device)

@cython.embedsignature(True)
def cudaInitDevice(int device, unsigned int deviceFlags, unsigned int flags):
    """ Initialize device to be used for GPU executions.

    This function will initialize the CUDA Runtime structures and primary
    context on `device` when called, but the context will not be made
    current to `device`.

    When :py:obj:`~.cudaInitDeviceFlagsAreValid` is set in `flags`,
    deviceFlags are applied to the requested device. The values of
    deviceFlags match those of the flags parameters in
    :py:obj:`~.cudaSetDeviceFlags`. The effect may be verified by
    :py:obj:`~.cudaGetDeviceFlags`.

    This function will return an error if the device is in
    :py:obj:`~.cudaComputeModeExclusiveProcess` and is occupied by another
    process or if the device is in :py:obj:`~.cudaComputeModeProhibited`.

    Parameters
    ----------
    device : int
        Device on which the runtime will initialize itself.
    deviceFlags : unsigned int
        Parameters for device operation.
    flags : unsigned int
        Flags for controlling the device initialization.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDevice`,

    See Also
    --------
    :py:obj:`~.cudaGetDeviceCount`, :py:obj:`~.cudaGetDevice`, :py:obj:`~.cudaGetDeviceProperties`, :py:obj:`~.cudaChooseDevice`, :py:obj:`~.cudaSetDevice` :py:obj:`~.cuCtxSetCurrent`
    """
    with nogil:
        err = cyruntime.cudaInitDevice(device, deviceFlags, flags)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaSetDevice(int device):
    """ Set device to be used for GPU executions.

    Sets `device` as the current device for the calling host thread. Valid
    device id's are 0 to (:py:obj:`~.cudaGetDeviceCount()` - 1).

    Any device memory subsequently allocated from this host thread using
    :py:obj:`~.cudaMalloc()`, :py:obj:`~.cudaMallocPitch()` or
    :py:obj:`~.cudaMallocArray()` will be physically resident on `device`.
    Any host memory allocated from this host thread using
    :py:obj:`~.cudaMallocHost()` or :py:obj:`~.cudaHostAlloc()` or
    :py:obj:`~.cudaHostRegister()` will have its lifetime associated with
    `device`. Any streams or events created from this host thread will be
    associated with `device`. Any kernels launched from this host thread
    using the <<<>>> operator or :py:obj:`~.cudaLaunchKernel()` will be
    executed on `device`.

    This call may be made from any host thread, to any device, and at any
    time. This function will do no synchronization with the previous or new
    device, and should only take significant time when it initializes the
    runtime's context state. This call will bind the primary context of the
    specified device to the calling thread and all the subsequent memory
    allocations, stream and event creations, and kernel launches will be
    associated with the primary context. This function will also
    immediately initialize the runtime state on the primary context, and
    the context will be current on `device` immediately. This function will
    return an error if the device is in
    :py:obj:`~.cudaComputeModeExclusiveProcess` and is occupied by another
    process or if the device is in :py:obj:`~.cudaComputeModeProhibited`.

    It is not required to call :py:obj:`~.cudaInitDevice` before using this
    function.

    Parameters
    ----------
    device : int
        Device on which the active host thread should execute the device
        code.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorDeviceUnavailable`,

    See Also
    --------
    :py:obj:`~.cudaGetDeviceCount`, :py:obj:`~.cudaGetDevice`, :py:obj:`~.cudaGetDeviceProperties`, :py:obj:`~.cudaChooseDevice`, :py:obj:`~.cudaInitDevice`, :py:obj:`~.cuCtxSetCurrent`
    """
    with nogil:
        err = cyruntime.cudaSetDevice(device)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaGetDevice():
    """ Returns which device is currently being used.

    Returns in `*device` the current device for the calling host thread.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorDeviceUnavailable`,
    device : int
        Returns the device on which the active host thread executes the
        device code.

    See Also
    --------
    :py:obj:`~.cudaGetDeviceCount`, :py:obj:`~.cudaSetDevice`, :py:obj:`~.cudaGetDeviceProperties`, :py:obj:`~.cudaChooseDevice`, :py:obj:`~.cuCtxGetCurrent`
    """
    cdef int device = 0
    with nogil:
        err = cyruntime.cudaGetDevice(&device)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], device)

@cython.embedsignature(True)
def cudaSetDeviceFlags(unsigned int flags):
    """ Sets flags to be used for device executions.

    Records `flags` as the flags for the current device. If the current
    device has been set and that device has already been initialized, the
    previous flags are overwritten. If the current device has not been
    initialized, it is initialized with the provided flags. If no device
    has been made current to the calling thread, a default device is
    selected and initialized with the provided flags.

    The three LSBs of the `flags` parameter can be used to control how the
    CPU thread interacts with the OS scheduler when waiting for results
    from the device.

    - :py:obj:`~.cudaDeviceScheduleAuto`: The default value if the `flags`
      parameter is zero, uses a heuristic based on the number of active
      CUDA contexts in the process `C` and the number of logical processors
      in the system `P`. If `C` > `P`, then CUDA will yield to other OS
      threads when waiting for the device, otherwise CUDA will not yield
      while waiting for results and actively spin on the processor.
      Additionally, on Tegra devices, :py:obj:`~.cudaDeviceScheduleAuto`
      uses a heuristic based on the power profile of the platform and may
      choose :py:obj:`~.cudaDeviceScheduleBlockingSync` for low-powered
      devices.

    - :py:obj:`~.cudaDeviceScheduleSpin`: Instruct CUDA to actively spin
      when waiting for results from the device. This can decrease latency
      when waiting for the device, but may lower the performance of CPU
      threads if they are performing work in parallel with the CUDA thread.

    - :py:obj:`~.cudaDeviceScheduleYield`: Instruct CUDA to yield its
      thread when waiting for results from the device. This can increase
      latency when waiting for the device, but can increase the performance
      of CPU threads performing work in parallel with the device.

    - :py:obj:`~.cudaDeviceScheduleBlockingSync`: Instruct CUDA to block
      the CPU thread on a synchronization primitive when waiting for the
      device to finish work.

    - :py:obj:`~.cudaDeviceBlockingSync`: Instruct CUDA to block the CPU
      thread on a synchronization primitive when waiting for the device to
      finish work.   :py:obj:`~.Deprecated:` This flag was deprecated as of
      CUDA 4.0 and replaced with
      :py:obj:`~.cudaDeviceScheduleBlockingSync`.

    - :py:obj:`~.cudaDeviceMapHost`: This flag enables allocating pinned
      host memory that is accessible to the device. It is implicit for the
      runtime but may be absent if a context is created using the driver
      API. If this flag is not set, :py:obj:`~.cudaHostGetDevicePointer()`
      will always return a failure code.

    - :py:obj:`~.cudaDeviceLmemResizeToMax`: Instruct CUDA to not reduce
      local memory after resizing local memory for a kernel. This can
      prevent thrashing by local memory allocations when launching many
      kernels with high local memory usage at the cost of potentially
      increased memory usage.   :py:obj:`~.Deprecated:` This flag is
      deprecated and the behavior enabled by this flag is now the default
      and cannot be disabled.

    - :py:obj:`~.cudaDeviceSyncMemops`: Ensures that synchronous memory
      operations initiated on this context will always synchronize. See
      further documentation in the section titled "API Synchronization
      behavior" to learn more about cases when synchronous memory
      operations can exhibit asynchronous behavior.

    Parameters
    ----------
    flags : unsigned int
        Parameters for device operation

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`

    See Also
    --------
    :py:obj:`~.cudaGetDeviceFlags`, :py:obj:`~.cudaGetDeviceCount`, :py:obj:`~.cudaGetDevice`, :py:obj:`~.cudaGetDeviceProperties`, :py:obj:`~.cudaSetDevice`, :py:obj:`~.cudaSetValidDevices`, :py:obj:`~.cudaInitDevice`, :py:obj:`~.cudaChooseDevice`, :py:obj:`~.cuDevicePrimaryCtxSetFlags`
    """
    with nogil:
        err = cyruntime.cudaSetDeviceFlags(flags)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaGetDeviceFlags():
    """ Gets the flags for the current device.

    Returns in `flags` the flags for the current device. If there is a
    current device for the calling thread, the flags for the device are
    returned. If there is no current device, the flags for the first device
    are returned, which may be the default flags. Compare to the behavior
    of :py:obj:`~.cudaSetDeviceFlags`.

    Typically, the flags returned should match the behavior that will be
    seen if the calling thread uses a device after this call, without any
    change to the flags or current device inbetween by this or another
    thread. Note that if the device is not initialized, it is possible for
    another thread to change the flags for the current device before it is
    initialized. Additionally, when using exclusive mode, if this thread
    has not requested a specific device, it may use a device other than the
    first device, contrary to the assumption made by this function.

    If a context has been created via the driver API and is current to the
    calling thread, the flags for that context are always returned.

    Flags returned by this function may specifically include
    :py:obj:`~.cudaDeviceMapHost` even though it is not accepted by
    :py:obj:`~.cudaSetDeviceFlags` because it is implicit in runtime API
    flags. The reason for this is that the current context may have been
    created via the driver API in which case the flag is not implicit and
    may be unset.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDevice`
    flags : unsigned int
        Pointer to store the device flags

    See Also
    --------
    :py:obj:`~.cudaGetDevice`, :py:obj:`~.cudaGetDeviceProperties`, :py:obj:`~.cudaSetDevice`, :py:obj:`~.cudaSetDeviceFlags`, :py:obj:`~.cudaInitDevice`, :py:obj:`~.cuCtxGetFlags`, :py:obj:`~.cuDevicePrimaryCtxGetState`
    """
    cdef unsigned int flags = 0
    with nogil:
        err = cyruntime.cudaGetDeviceFlags(&flags)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], flags)

@cython.embedsignature(True)
def cudaStreamCreate():
    """ Create an asynchronous stream.

    Creates a new asynchronous stream on the context that is current to the
    calling host thread. If no context is current to the calling host
    thread, then the primary context for a device is selected, made current
    to the calling thread, and initialized before creating a stream on it.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`
    pStream : :py:obj:`~.cudaStream_t`
        Pointer to new stream identifier

    See Also
    --------
    :py:obj:`~.cudaStreamCreateWithPriority`, :py:obj:`~.cudaStreamCreateWithFlags`, :py:obj:`~.cudaStreamGetPriority`, :py:obj:`~.cudaStreamGetFlags`, :py:obj:`~.cudaStreamGetDevice`, :py:obj:`~.cudaStreamGetDevResource`, :py:obj:`~.cudaStreamQuery`, :py:obj:`~.cudaStreamSynchronize`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaStreamAddCallback`, :py:obj:`~.cudaSetDevice`, :py:obj:`~.cudaStreamDestroy`, :py:obj:`~.cuStreamCreate`
    """
    cdef cudaStream_t pStream = cudaStream_t()
    with nogil:
        err = cyruntime.cudaStreamCreate(<cyruntime.cudaStream_t*>pStream._pvt_ptr)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pStream)

@cython.embedsignature(True)
def cudaStreamCreateWithFlags(unsigned int flags):
    """ Create an asynchronous stream.

    Creates a new asynchronous stream on the context that is current to the
    calling host thread. If no context is current to the calling host
    thread, then the primary context for a device is selected, made current
    to the calling thread, and initialized before creating a stream on it.
    The `flags` argument determines the behaviors of the stream. Valid
    values for `flags` are

    - :py:obj:`~.cudaStreamDefault`: Default stream creation flag.

    - :py:obj:`~.cudaStreamNonBlocking`: Specifies that work running in the
      created stream may run concurrently with work in stream 0 (the NULL
      stream), and that the created stream should perform no implicit
      synchronization with stream 0.

    Parameters
    ----------
    flags : unsigned int
        Parameters for stream creation

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`
    pStream : :py:obj:`~.cudaStream_t`
        Pointer to new stream identifier

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamCreateWithPriority`, :py:obj:`~.cudaStreamGetFlags`, :py:obj:`~.cudaStreamGetDevice`, :py:obj:`~.cudaStreamGetDevResource`, :py:obj:`~.cudaStreamQuery`, :py:obj:`~.cudaStreamSynchronize`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaStreamAddCallback`, :py:obj:`~.cudaSetDevice`, :py:obj:`~.cudaStreamDestroy`, :py:obj:`~.cuStreamCreate`
    """
    cdef cudaStream_t pStream = cudaStream_t()
    with nogil:
        err = cyruntime.cudaStreamCreateWithFlags(<cyruntime.cudaStream_t*>pStream._pvt_ptr, flags)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pStream)

@cython.embedsignature(True)
def cudaStreamCreateWithPriority(unsigned int flags, int priority):
    """ Create an asynchronous stream with the specified priority.

    Creates a stream with the specified priority and returns a handle in
    `pStream`. The stream is created on the context that is current to the
    calling host thread. If no context is current to the calling host
    thread, then the primary context for a device is selected, made current
    to the calling thread, and initialized before creating a stream on it.
    This affects the scheduling priority of work in the stream. Priorities
    provide a hint to preferentially run work with higher priority when
    possible, but do not preempt already-running work or provide any other
    functional guarantee on execution order.

    `priority` follows a convention where lower numbers represent higher
    priorities. '0' represents default priority. The range of meaningful
    numerical priorities can be queried using
    :py:obj:`~.cudaDeviceGetStreamPriorityRange`. If the specified priority
    is outside the numerical range returned by
    :py:obj:`~.cudaDeviceGetStreamPriorityRange`, it will automatically be
    clamped to the lowest or the highest number in the range.

    Parameters
    ----------
    flags : unsigned int
        Flags for stream creation. See
        :py:obj:`~.cudaStreamCreateWithFlags` for a list of valid flags
        that can be passed
    priority : int
        Priority of the stream. Lower numbers represent higher priorities.
        See :py:obj:`~.cudaDeviceGetStreamPriorityRange` for more
        information about the meaningful stream priorities that can be
        passed.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`
    pStream : :py:obj:`~.cudaStream_t`
        Pointer to new stream identifier

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamCreateWithFlags`, :py:obj:`~.cudaDeviceGetStreamPriorityRange`, :py:obj:`~.cudaStreamGetPriority`, :py:obj:`~.cudaStreamQuery`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaStreamAddCallback`, :py:obj:`~.cudaStreamSynchronize`, :py:obj:`~.cudaSetDevice`, :py:obj:`~.cudaStreamDestroy`, :py:obj:`~.cuStreamCreateWithPriority`

    Notes
    -----
    Stream priorities are supported only on GPUs with compute capability 3.5 or higher.

    In the current implementation, only compute kernels launched in priority streams are affected by the stream's priority. Stream priorities have no effect on host-to-device and device-to-host memory operations.
    """
    cdef cudaStream_t pStream = cudaStream_t()
    with nogil:
        err = cyruntime.cudaStreamCreateWithPriority(<cyruntime.cudaStream_t*>pStream._pvt_ptr, flags, priority)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pStream)

@cython.embedsignature(True)
def cudaStreamGetPriority(hStream):
    """ Query the priority of a stream.

    Query the priority of a stream. The priority is returned in in
    `priority`. Note that if the stream was created with a priority outside
    the meaningful numerical range returned by
    :py:obj:`~.cudaDeviceGetStreamPriorityRange`, this function returns the
    clamped priority. See :py:obj:`~.cudaStreamCreateWithPriority` for
    details about priority clamping.

    Parameters
    ----------
    hStream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Handle to the stream to be queried

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`
    priority : int
        Pointer to a signed integer in which the stream's priority is
        returned

    See Also
    --------
    :py:obj:`~.cudaStreamCreateWithPriority`, :py:obj:`~.cudaDeviceGetStreamPriorityRange`, :py:obj:`~.cudaStreamGetFlags`, :py:obj:`~.cudaStreamGetDevice`, :py:obj:`~.cudaStreamGetDevResource`, :py:obj:`~.cuStreamGetPriority`
    """
    cdef cyruntime.cudaStream_t cyhStream
    if hStream is None:
        phStream = 0
    elif isinstance(hStream, (cudaStream_t,driver.CUstream)):
        phStream = int(hStream)
    else:
        phStream = int(cudaStream_t(hStream))
    cyhStream = <cyruntime.cudaStream_t><void_ptr>phStream
    cdef int priority = 0
    with nogil:
        err = cyruntime.cudaStreamGetPriority(cyhStream, &priority)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], priority)

@cython.embedsignature(True)
def cudaStreamGetFlags(hStream):
    """ Query the flags of a stream.

    Query the flags of a stream. The flags are returned in `flags`. See
    :py:obj:`~.cudaStreamCreateWithFlags` for a list of valid flags.

    Parameters
    ----------
    hStream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Handle to the stream to be queried

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`
    flags : unsigned int
        Pointer to an unsigned integer in which the stream's flags are
        returned

    See Also
    --------
    :py:obj:`~.cudaStreamCreateWithPriority`, :py:obj:`~.cudaStreamCreateWithFlags`, :py:obj:`~.cudaStreamGetPriority`, :py:obj:`~.cudaStreamGetDevice`, :py:obj:`~.cuStreamGetFlags`
    """
    cdef cyruntime.cudaStream_t cyhStream
    if hStream is None:
        phStream = 0
    elif isinstance(hStream, (cudaStream_t,driver.CUstream)):
        phStream = int(hStream)
    else:
        phStream = int(cudaStream_t(hStream))
    cyhStream = <cyruntime.cudaStream_t><void_ptr>phStream
    cdef unsigned int flags = 0
    with nogil:
        err = cyruntime.cudaStreamGetFlags(cyhStream, &flags)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], flags)

@cython.embedsignature(True)
def cudaStreamGetId(hStream):
    """ Query the Id of a stream.

    Query the Id of a stream. The Id is returned in `streamId`. The Id is
    unique for the life of the program.

    The stream handle `hStream` can refer to any of the following:

    - a stream created via any of the CUDA runtime APIs such as
      :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamCreateWithFlags`
      and :py:obj:`~.cudaStreamCreateWithPriority`, or their driver API
      equivalents such as :py:obj:`~.cuStreamCreate` or
      :py:obj:`~.cuStreamCreateWithPriority`. Passing an invalid handle
      will result in undefined behavior.

    - any of the special streams such as the NULL stream,
      :py:obj:`~.cudaStreamLegacy` and :py:obj:`~.cudaStreamPerThread`
      respectively. The driver API equivalents of these are also accepted
      which are NULL, :py:obj:`~.CU_STREAM_LEGACY` and
      :py:obj:`~.CU_STREAM_PER_THREAD`.

    Parameters
    ----------
    hStream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Handle to the stream to be queried

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`
    streamId : unsigned long long
        Pointer to an unsigned long long in which the stream Id is returned

    See Also
    --------
    :py:obj:`~.cudaStreamCreateWithPriority`, :py:obj:`~.cudaStreamCreateWithFlags`, :py:obj:`~.cudaStreamGetPriority`, :py:obj:`~.cudaStreamGetFlags`, :py:obj:`~.cuStreamGetId`
    """
    cdef cyruntime.cudaStream_t cyhStream
    if hStream is None:
        phStream = 0
    elif isinstance(hStream, (cudaStream_t,driver.CUstream)):
        phStream = int(hStream)
    else:
        phStream = int(cudaStream_t(hStream))
    cyhStream = <cyruntime.cudaStream_t><void_ptr>phStream
    cdef unsigned long long streamId = 0
    with nogil:
        err = cyruntime.cudaStreamGetId(cyhStream, &streamId)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], streamId)

@cython.embedsignature(True)
def cudaStreamGetDevice(hStream):
    """ Query the device of a stream.

    Returns in `*device` the device of the stream.

    Parameters
    ----------
    hStream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Handle to the stream to be queried

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorDeviceUnavailable`,
    device : int
        Returns the device to which the stream belongs

    See Also
    --------
    :py:obj:`~.cudaSetDevice`, :py:obj:`~.cudaGetDevice`, :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamGetPriority`, :py:obj:`~.cudaStreamGetFlags`, :py:obj:`~.cuStreamGetId`
    """
    cdef cyruntime.cudaStream_t cyhStream
    if hStream is None:
        phStream = 0
    elif isinstance(hStream, (cudaStream_t,driver.CUstream)):
        phStream = int(hStream)
    else:
        phStream = int(cudaStream_t(hStream))
    cyhStream = <cyruntime.cudaStream_t><void_ptr>phStream
    cdef int device = 0
    with nogil:
        err = cyruntime.cudaStreamGetDevice(cyhStream, &device)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], device)

@cython.embedsignature(True)
def cudaCtxResetPersistingL2Cache():
    """ Resets all persisting lines in cache to normal status.

    Resets all persisting lines in cache to normal status. Takes effect on
    function return.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`,

    See Also
    --------
    :py:obj:`~.cudaAccessPolicyWindow`
    """
    with nogil:
        err = cyruntime.cudaCtxResetPersistingL2Cache()
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaStreamCopyAttributes(dst, src):
    """ Copies attributes from source stream to destination stream.

    Copies attributes from source stream `src` to destination stream `dst`.
    Both streams must have the same context.

    Parameters
    ----------
    dst : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Destination stream
    src : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Source stream For attributes see :py:obj:`~.cudaStreamAttrID`

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorNotSupported`

    See Also
    --------
    :py:obj:`~.cudaAccessPolicyWindow`
    """
    cdef cyruntime.cudaStream_t cysrc
    if src is None:
        psrc = 0
    elif isinstance(src, (cudaStream_t,driver.CUstream)):
        psrc = int(src)
    else:
        psrc = int(cudaStream_t(src))
    cysrc = <cyruntime.cudaStream_t><void_ptr>psrc
    cdef cyruntime.cudaStream_t cydst
    if dst is None:
        pdst = 0
    elif isinstance(dst, (cudaStream_t,driver.CUstream)):
        pdst = int(dst)
    else:
        pdst = int(cudaStream_t(dst))
    cydst = <cyruntime.cudaStream_t><void_ptr>pdst
    with nogil:
        err = cyruntime.cudaStreamCopyAttributes(cydst, cysrc)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaStreamGetAttribute(hStream, attr not None : cudaStreamAttrID):
    """ Queries stream attribute.

    Queries attribute `attr` from `hStream` and stores it in corresponding
    member of `value_out`.

    Parameters
    ----------
    hStream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`

    attr : :py:obj:`~.cudaStreamAttrID`


    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`
    value_out : :py:obj:`~.cudaStreamAttrValue`


    See Also
    --------
    :py:obj:`~.cudaAccessPolicyWindow`
    """
    cdef cyruntime.cudaStream_t cyhStream
    if hStream is None:
        phStream = 0
    elif isinstance(hStream, (cudaStream_t,driver.CUstream)):
        phStream = int(hStream)
    else:
        phStream = int(cudaStream_t(hStream))
    cyhStream = <cyruntime.cudaStream_t><void_ptr>phStream
    cdef cyruntime.cudaStreamAttrID cyattr = attr.value
    cdef cudaStreamAttrValue value_out = cudaStreamAttrValue()
    with nogil:
        err = cyruntime.cudaStreamGetAttribute(cyhStream, cyattr, <cyruntime.cudaStreamAttrValue*>value_out._pvt_ptr)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], value_out)

@cython.embedsignature(True)
def cudaStreamSetAttribute(hStream, attr not None : cudaStreamAttrID, value : Optional[cudaStreamAttrValue]):
    """ Sets stream attribute.

    Sets attribute `attr` on `hStream` from corresponding attribute of
    `value`. The updated attribute will be applied to subsequent work
    submitted to the stream. It will not affect previously submitted work.

    Parameters
    ----------
    hStream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`

    attr : :py:obj:`~.cudaStreamAttrID`

    value : :py:obj:`~.cudaStreamAttrValue`


    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`

    See Also
    --------
    :py:obj:`~.cudaAccessPolicyWindow`
    """
    cdef cyruntime.cudaStream_t cyhStream
    if hStream is None:
        phStream = 0
    elif isinstance(hStream, (cudaStream_t,driver.CUstream)):
        phStream = int(hStream)
    else:
        phStream = int(cudaStream_t(hStream))
    cyhStream = <cyruntime.cudaStream_t><void_ptr>phStream
    cdef cyruntime.cudaStreamAttrID cyattr = attr.value
    cdef cyruntime.cudaStreamAttrValue* cyvalue_ptr = value._pvt_ptr if value is not None else NULL
    with nogil:
        err = cyruntime.cudaStreamSetAttribute(cyhStream, cyattr, cyvalue_ptr)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaStreamDestroy(stream):
    """ Destroys and cleans up an asynchronous stream.

    Destroys and cleans up the asynchronous stream specified by `stream`.

    In case the device is still doing work in the stream `stream` when
    :py:obj:`~.cudaStreamDestroy()` is called, the function will return
    immediately and the resources associated with `stream` will be released
    automatically once the device has completed all work in `stream`.

    Parameters
    ----------
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamCreateWithFlags`, :py:obj:`~.cudaStreamQuery`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaStreamSynchronize`, :py:obj:`~.cudaStreamAddCallback`, :py:obj:`~.cuStreamDestroy`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    with nogil:
        err = cyruntime.cudaStreamDestroy(cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaStreamWaitEvent(stream, event, unsigned int flags):
    """ Make a compute stream wait on an event.

    Makes all future work submitted to `stream` wait for all work captured
    in `event`. See :py:obj:`~.cudaEventRecord()` for details on what is
    captured by an event. The synchronization will be performed efficiently
    on the device when applicable. `event` may be from a different device
    than `stream`.

    flags include:

    - :py:obj:`~.cudaEventWaitDefault`: Default event creation flag.

    - :py:obj:`~.cudaEventWaitExternal`: Event is captured in the graph as
      an external event node when performing stream capture.

    Parameters
    ----------
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream to wait
    event : :py:obj:`~.CUevent` or :py:obj:`~.cudaEvent_t`
        Event to wait on
    flags : unsigned int
        Parameters for the operation(See above)

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamCreateWithFlags`, :py:obj:`~.cudaStreamQuery`, :py:obj:`~.cudaStreamSynchronize`, :py:obj:`~.cudaStreamAddCallback`, :py:obj:`~.cudaStreamDestroy`, :py:obj:`~.cuStreamWaitEvent`
    """
    cdef cyruntime.cudaEvent_t cyevent
    if event is None:
        pevent = 0
    elif isinstance(event, (cudaEvent_t,driver.CUevent)):
        pevent = int(event)
    else:
        pevent = int(cudaEvent_t(event))
    cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    with nogil:
        err = cyruntime.cudaStreamWaitEvent(cystream, cyevent, flags)
    return (_dict_cudaError_t[err],)

ctypedef struct cudaStreamCallbackData_st:
    cyruntime.cudaStreamCallback_t callback
    void *userData

ctypedef cudaStreamCallbackData_st cudaStreamCallbackData

@cython.show_performance_hints(False)
cdef void cudaStreamRtCallbackWrapper(cyruntime.cudaStream_t stream, cyruntime.cudaError_t status, void *data) nogil:
    cdef cudaStreamCallbackData *cbData = <cudaStreamCallbackData *>data
    with gil:
        cbData.callback(stream, status, cbData.userData)
    free(cbData)

@cython.embedsignature(True)
def cudaStreamAddCallback(stream, callback, userData, unsigned int flags):
    """ Add a callback to a compute stream.

    Adds a callback to be called on the host after all currently enqueued
    items in the stream have completed. For each cudaStreamAddCallback
    call, a callback will be executed exactly once. The callback will block
    later work in the stream until it is finished.

    The callback may be passed :py:obj:`~.cudaSuccess` or an error code. In
    the event of a device error, all subsequently executed callbacks will
    receive an appropriate :py:obj:`~.cudaError_t`.

    Callbacks must not make any CUDA API calls. Attempting to use CUDA APIs
    may result in :py:obj:`~.cudaErrorNotPermitted`. Callbacks must not
    perform any synchronization that may depend on outstanding device work
    or other callbacks that are not mandated to run earlier. Callbacks
    without a mandated order (in independent streams) execute in undefined
    order and may be serialized.

    For the purposes of Unified Memory, callback execution makes a number
    of guarantees:

    - The callback stream is considered idle for the duration of the
      callback. Thus, for example, a callback may always use memory
      attached to the callback stream.

    - The start of execution of a callback has the same effect as
      synchronizing an event recorded in the same stream immediately prior
      to the callback. It thus synchronizes streams which have been
      "joined" prior to the callback.

    - Adding device work to any stream does not have the effect of making
      the stream active until all preceding callbacks have executed. Thus,
      for example, a callback might use global attached memory even if work
      has been added to another stream, if it has been properly ordered
      with an event.

    - Completion of a callback does not cause a stream to become active
      except as described above. The callback stream will remain idle if no
      device work follows the callback, and will remain idle across
      consecutive callbacks without device work in between. Thus, for
      example, stream synchronization can be done by signaling from a
      callback at the end of the stream.

    Parameters
    ----------
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream to add callback to
    callback : :py:obj:`~.cudaStreamCallback_t`
        The function to call once preceding stream operations are complete
    userData : Any
        User specified data to be passed to the callback function
    flags : unsigned int
        Reserved for future use, must be 0

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorNotSupported`

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamCreateWithFlags`, :py:obj:`~.cudaStreamQuery`, :py:obj:`~.cudaStreamSynchronize`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaStreamDestroy`, :py:obj:`~.cudaMallocManaged`, :py:obj:`~.cudaStreamAttachMemAsync`, :py:obj:`~.cudaLaunchHostFunc`, :py:obj:`~.cuStreamAddCallback`

    Notes
    -----
    This function is slated for eventual deprecation and removal. If you do not require the callback to execute in case of a device error, consider using :py:obj:`~.cudaLaunchHostFunc`. Additionally, this function is not supported with :py:obj:`~.cudaStreamBeginCapture` and :py:obj:`~.cudaStreamEndCapture`, unlike :py:obj:`~.cudaLaunchHostFunc`.
    """
    cdef cyruntime.cudaStreamCallback_t cycallback
    if callback is None:
        pcallback = 0
    elif isinstance(callback, (cudaStreamCallback_t,)):
        pcallback = int(callback)
    else:
        pcallback = int(cudaStreamCallback_t(callback))
    cycallback = <cyruntime.cudaStreamCallback_t><void_ptr>pcallback
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cyuserData = _HelperInputVoidPtr(userData)
    cdef void* cyuserData_ptr = <void*><void_ptr>cyuserData.cptr

    cdef cudaStreamCallbackData *cbData = NULL
    cbData = <cudaStreamCallbackData *>malloc(sizeof(cbData[0]))
    if cbData == NULL:
        return (cudaError_t.cudaErrorMemoryAllocation,)
    cbData.callback = cycallback
    cbData.userData = cyuserData_ptr

    with nogil:
        err = cyruntime.cudaStreamAddCallback(cystream, <cyruntime.cudaStreamCallback_t>cudaStreamRtCallbackWrapper, <void *>cbData, flags)
    if err != cyruntime.cudaSuccess:
        free(cbData)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaStreamSynchronize(stream):
    """ Waits for stream tasks to complete.

    Blocks until `stream` has completed all operations. If the
    :py:obj:`~.cudaDeviceScheduleBlockingSync` flag was set for this
    device, the host thread will block until the stream is finished with
    all of its tasks.

    Parameters
    ----------
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidResourceHandle`

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamCreateWithFlags`, :py:obj:`~.cudaStreamQuery`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaStreamAddCallback`, :py:obj:`~.cudaStreamDestroy`, :py:obj:`~.cuStreamSynchronize`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    with nogil:
        err = cyruntime.cudaStreamSynchronize(cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaStreamQuery(stream):
    """ Queries an asynchronous stream for completion status.

    Returns :py:obj:`~.cudaSuccess` if all operations in `stream` have
    completed, or :py:obj:`~.cudaErrorNotReady` if not.

    For the purposes of Unified Memory, a return value of
    :py:obj:`~.cudaSuccess` is equivalent to having called
    :py:obj:`~.cudaStreamSynchronize()`.

    Parameters
    ----------
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorNotReady`, :py:obj:`~.cudaErrorInvalidResourceHandle`

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamCreateWithFlags`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaStreamSynchronize`, :py:obj:`~.cudaStreamAddCallback`, :py:obj:`~.cudaStreamDestroy`, :py:obj:`~.cuStreamQuery`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    with nogil:
        err = cyruntime.cudaStreamQuery(cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaStreamAttachMemAsync(stream, devPtr, size_t length, unsigned int flags):
    """ Attach memory to a stream asynchronously.

    Enqueues an operation in `stream` to specify stream association of
    `length` bytes of memory starting from `devPtr`. This function is a
    stream-ordered operation, meaning that it is dependent on, and will
    only take effect when, previous work in stream has completed. Any
    previous association is automatically replaced.

    `devPtr` must point to an one of the following types of memories:

    - managed memory declared using the managed keyword or allocated with
      :py:obj:`~.cudaMallocManaged`.

    - a valid host-accessible region of system-allocated pageable memory.
      This type of memory may only be specified if the device associated
      with the stream reports a non-zero value for the device attribute
      :py:obj:`~.cudaDevAttrPageableMemoryAccess`.

    For managed allocations, `length` must be either zero or the entire
    allocation's size. Both indicate that the entire allocation's stream
    association is being changed. Currently, it is not possible to change
    stream association for a portion of a managed allocation.

    For pageable allocations, `length` must be non-zero.

    The stream association is specified using `flags` which must be one of
    :py:obj:`~.cudaMemAttachGlobal`, :py:obj:`~.cudaMemAttachHost` or
    :py:obj:`~.cudaMemAttachSingle`. The default value for `flags` is
    :py:obj:`~.cudaMemAttachSingle` If the :py:obj:`~.cudaMemAttachGlobal`
    flag is specified, the memory can be accessed by any stream on any
    device. If the :py:obj:`~.cudaMemAttachHost` flag is specified, the
    program makes a guarantee that it won't access the memory on the device
    from any stream on a device that has a zero value for the device
    attribute :py:obj:`~.cudaDevAttrConcurrentManagedAccess`. If the
    :py:obj:`~.cudaMemAttachSingle` flag is specified and `stream` is
    associated with a device that has a zero value for the device attribute
    :py:obj:`~.cudaDevAttrConcurrentManagedAccess`, the program makes a
    guarantee that it will only access the memory on the device from
    `stream`. It is illegal to attach singly to the NULL stream, because
    the NULL stream is a virtual global stream and not a specific stream.
    An error will be returned in this case.

    When memory is associated with a single stream, the Unified Memory
    system will allow CPU access to this memory region so long as all
    operations in `stream` have completed, regardless of whether other
    streams are active. In effect, this constrains exclusive ownership of
    the managed memory region by an active GPU to per-stream activity
    instead of whole-GPU activity.

    Accessing memory on the device from streams that are not associated
    with it will produce undefined results. No error checking is performed
    by the Unified Memory system to ensure that kernels launched into other
    streams do not access this region.

    It is a program's responsibility to order calls to
    :py:obj:`~.cudaStreamAttachMemAsync` via events, synchronization or
    other means to ensure legal access to memory at all times. Data
    visibility and coherency will be changed appropriately for all kernels
    which follow a stream-association change.

    If `stream` is destroyed while data is associated with it, the
    association is removed and the association reverts to the default
    visibility of the allocation as specified at
    :py:obj:`~.cudaMallocManaged`. For managed variables, the default
    association is always :py:obj:`~.cudaMemAttachGlobal`. Note that
    destroying a stream is an asynchronous operation, and as a result, the
    change to default association won't happen until all work in the stream
    has completed.

    Parameters
    ----------
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream in which to enqueue the attach operation
    devPtr : Any
        Pointer to memory (must be a pointer to managed memory or to a
        valid host-accessible region of system-allocated memory)
    length : size_t
        Length of memory (defaults to zero)
    flags : unsigned int
        Must be one of :py:obj:`~.cudaMemAttachGlobal`,
        :py:obj:`~.cudaMemAttachHost` or :py:obj:`~.cudaMemAttachSingle`
        (defaults to :py:obj:`~.cudaMemAttachSingle`)

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorNotReady`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamCreateWithFlags`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaStreamSynchronize`, :py:obj:`~.cudaStreamAddCallback`, :py:obj:`~.cudaStreamDestroy`, :py:obj:`~.cudaMallocManaged`, :py:obj:`~.cuStreamAttachMemAsync`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cydevPtr = _HelperInputVoidPtr(devPtr)
    cdef void* cydevPtr_ptr = <void*><void_ptr>cydevPtr.cptr
    with nogil:
        err = cyruntime.cudaStreamAttachMemAsync(cystream, cydevPtr_ptr, length, flags)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaStreamBeginCapture(stream, mode not None : cudaStreamCaptureMode):
    """ Begins graph capture on a stream.

    Begin graph capture on `stream`. When a stream is in capture mode, all
    operations pushed into the stream will not be executed, but will
    instead be captured into a graph, which will be returned via
    :py:obj:`~.cudaStreamEndCapture`. Capture may not be initiated if
    `stream` is :py:obj:`~.cudaStreamLegacy`. Capture must be ended on the
    same stream in which it was initiated, and it may only be initiated if
    the stream is not already in capture mode. The capture mode may be
    queried via :py:obj:`~.cudaStreamIsCapturing`. A unique id representing
    the capture sequence may be queried via
    :py:obj:`~.cudaStreamGetCaptureInfo`.

    If `mode` is not :py:obj:`~.cudaStreamCaptureModeRelaxed`,
    :py:obj:`~.cudaStreamEndCapture` must be called on this stream from the
    same thread.

    Parameters
    ----------
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream in which to initiate capture
    mode : :py:obj:`~.cudaStreamCaptureMode`
        Controls the interaction of this capture sequence with other API
        calls that are potentially unsafe. For more details see
        :py:obj:`~.cudaThreadExchangeStreamCaptureMode`.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamIsCapturing`, :py:obj:`~.cudaStreamEndCapture`, :py:obj:`~.cudaThreadExchangeStreamCaptureMode`

    Notes
    -----
    Kernels captured using this API must not use texture and surface references. Reading or writing through any texture or surface reference is undefined behavior. This restriction does not apply to texture and surface objects.
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cdef cyruntime.cudaStreamCaptureMode cymode = mode.value
    with nogil:
        err = cyruntime.cudaStreamBeginCapture(cystream, cymode)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaStreamBeginCaptureToGraph(stream, graph, dependencies : Optional[tuple[cudaGraphNode_t] | list[cudaGraphNode_t]], dependencyData : Optional[tuple[cudaGraphEdgeData] | list[cudaGraphEdgeData]], size_t numDependencies, mode not None : cudaStreamCaptureMode):
    """ Begins graph capture on a stream to an existing graph.

    Begin graph capture on `stream`. When a stream is in capture mode, all
    operations pushed into the stream will not be executed, but will
    instead be captured into `graph`, which will be returned via
    :py:obj:`~.cudaStreamEndCapture`.

    Capture may not be initiated if `stream` is
    :py:obj:`~.cudaStreamLegacy`. Capture must be ended on the same stream
    in which it was initiated, and it may only be initiated if the stream
    is not already in capture mode. The capture mode may be queried via
    :py:obj:`~.cudaStreamIsCapturing`. A unique id representing the capture
    sequence may be queried via :py:obj:`~.cudaStreamGetCaptureInfo`.

    If `mode` is not :py:obj:`~.cudaStreamCaptureModeRelaxed`,
    :py:obj:`~.cudaStreamEndCapture` must be called on this stream from the
    same thread.

    Parameters
    ----------
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream in which to initiate capture.
    graph : :py:obj:`~.CUgraph` or :py:obj:`~.cudaGraph_t`
        Graph to capture into.
    dependencies : list[:py:obj:`~.cudaGraphNode_t`]
        Dependencies of the first node captured in the stream. Can be NULL
        if numDependencies is 0.
    dependencyData : list[:py:obj:`~.cudaGraphEdgeData`]
        Optional array of data associated with each dependency.
    numDependencies : size_t
        Number of dependencies.
    mode : :py:obj:`~.cudaStreamCaptureMode`
        Controls the interaction of this capture sequence with other API
        calls that are potentially unsafe. For more details see
        :py:obj:`~.cudaThreadExchangeStreamCaptureMode`.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamIsCapturing`, :py:obj:`~.cudaStreamEndCapture`, :py:obj:`~.cudaThreadExchangeStreamCaptureMode`

    Notes
    -----
    Kernels captured using this API must not use texture and surface references. Reading or writing through any texture or surface reference is undefined behavior. This restriction does not apply to texture and surface objects.
    """
    dependencyData = [] if dependencyData is None else dependencyData
    if not all(isinstance(_x, (cudaGraphEdgeData,)) for _x in dependencyData):
        raise TypeError("Argument 'dependencyData' is not instance of type (expected tuple[cyruntime.cudaGraphEdgeData,] or list[cyruntime.cudaGraphEdgeData,]")
    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (cudaGraphNode_t,driver.CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected tuple[cyruntime.cudaGraphNode_t,driver.CUgraphNode] or list[cyruntime.cudaGraphNode_t,driver.CUgraphNode]")
    cdef cyruntime.cudaGraph_t cygraph
    if graph is None:
        pgraph = 0
    elif isinstance(graph, (cudaGraph_t,driver.CUgraph)):
        pgraph = int(graph)
    else:
        pgraph = int(cudaGraph_t(graph))
    cygraph = <cyruntime.cudaGraph_t><void_ptr>pgraph
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cdef cyruntime.cudaGraphNode_t* cydependencies = NULL
    if len(dependencies) > 1:
        cydependencies = <cyruntime.cudaGraphNode_t*> calloc(len(dependencies), sizeof(cyruntime.cudaGraphNode_t))
        if cydependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(cyruntime.cudaGraphNode_t)))
        else:
            for idx in range(len(dependencies)):
                cydependencies[idx] = <cyruntime.cudaGraphNode_t>(<cudaGraphNode_t>dependencies[idx])._pvt_ptr[0]
    elif len(dependencies) == 1:
        cydependencies = <cyruntime.cudaGraphNode_t*>(<cudaGraphNode_t>dependencies[0])._pvt_ptr
    cdef cyruntime.cudaGraphEdgeData* cydependencyData = NULL
    if len(dependencyData) > 1:
        cydependencyData = <cyruntime.cudaGraphEdgeData*> calloc(len(dependencyData), sizeof(cyruntime.cudaGraphEdgeData))
        if cydependencyData is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencyData)) + 'x' + str(sizeof(cyruntime.cudaGraphEdgeData)))
        for idx in range(len(dependencyData)):
            string.memcpy(&cydependencyData[idx], (<cudaGraphEdgeData>dependencyData[idx])._pvt_ptr, sizeof(cyruntime.cudaGraphEdgeData))
    elif len(dependencyData) == 1:
        cydependencyData = (<cudaGraphEdgeData>dependencyData[0])._pvt_ptr
    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    cdef cyruntime.cudaStreamCaptureMode cymode = mode.value
    with nogil:
        err = cyruntime.cudaStreamBeginCaptureToGraph(cystream, cygraph, cydependencies, cydependencyData, numDependencies, cymode)
    if len(dependencies) > 1 and cydependencies is not NULL:
        free(cydependencies)
    if len(dependencyData) > 1 and cydependencyData is not NULL:
        free(cydependencyData)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaThreadExchangeStreamCaptureMode(mode not None : cudaStreamCaptureMode):
    """ Swaps the stream capture interaction mode for a thread.

    Sets the calling thread's stream capture interaction mode to the value
    contained in `*mode`, and overwrites `*mode` with the previous mode for
    the thread. To facilitate deterministic behavior across function or
    module boundaries, callers are encouraged to use this API in a push-pop
    fashion:

    **View CUDA Toolkit Documentation for a C++ code example**

    During stream capture (see :py:obj:`~.cudaStreamBeginCapture`), some
    actions, such as a call to :py:obj:`~.cudaMalloc`, may be unsafe. In
    the case of :py:obj:`~.cudaMalloc`, the operation is not enqueued
    asynchronously to a stream, and is not observed by stream capture.
    Therefore, if the sequence of operations captured via
    :py:obj:`~.cudaStreamBeginCapture` depended on the allocation being
    replayed whenever the graph is launched, the captured graph would be
    invalid.

    Therefore, stream capture places restrictions on API calls that can be
    made within or concurrently to a
    :py:obj:`~.cudaStreamBeginCapture`-:py:obj:`~.cudaStreamEndCapture`
    sequence. This behavior can be controlled via this API and flags to
    :py:obj:`~.cudaStreamBeginCapture`.

    A thread's mode is one of the following:

    - `cudaStreamCaptureModeGlobal:` This is the default mode. If the local
      thread has an ongoing capture sequence that was not initiated with
      `cudaStreamCaptureModeRelaxed` at `cuStreamBeginCapture`, or if any
      other thread has a concurrent capture sequence initiated with
      `cudaStreamCaptureModeGlobal`, this thread is prohibited from
      potentially unsafe API calls.

    - `cudaStreamCaptureModeThreadLocal:` If the local thread has an
      ongoing capture sequence not initiated with
      `cudaStreamCaptureModeRelaxed`, it is prohibited from potentially
      unsafe API calls. Concurrent capture sequences in other threads are
      ignored.

    - `cudaStreamCaptureModeRelaxed:` The local thread is not prohibited
      from potentially unsafe API calls. Note that the thread is still
      prohibited from API calls which necessarily conflict with stream
      capture, for example, attempting :py:obj:`~.cudaEventQuery` on an
      event that was last recorded inside a capture sequence.

    Parameters
    ----------
    mode : :py:obj:`~.cudaStreamCaptureMode`
        Pointer to mode value to swap with the current mode

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`
    mode : :py:obj:`~.cudaStreamCaptureMode`
        Pointer to mode value to swap with the current mode

    See Also
    --------
    :py:obj:`~.cudaStreamBeginCapture`
    """
    cdef cyruntime.cudaStreamCaptureMode cymode = mode.value
    with nogil:
        err = cyruntime.cudaThreadExchangeStreamCaptureMode(&cymode)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], cudaStreamCaptureMode(cymode))

@cython.embedsignature(True)
def cudaStreamEndCapture(stream):
    """ Ends capture on a stream, returning the captured graph.

    End capture on `stream`, returning the captured graph via `pGraph`.
    Capture must have been initiated on `stream` via a call to
    :py:obj:`~.cudaStreamBeginCapture`. If capture was invalidated, due to
    a violation of the rules of stream capture, then a NULL graph will be
    returned.

    If the `mode` argument to :py:obj:`~.cudaStreamBeginCapture` was not
    :py:obj:`~.cudaStreamCaptureModeRelaxed`, this call must be from the
    same thread as :py:obj:`~.cudaStreamBeginCapture`.

    Parameters
    ----------
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream to query

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorStreamCaptureWrongThread`
    pGraph : :py:obj:`~.cudaGraph_t`
        The captured graph

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamBeginCapture`, :py:obj:`~.cudaStreamIsCapturing`, :py:obj:`~.cudaGraphDestroy`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cdef cudaGraph_t pGraph = cudaGraph_t()
    with nogil:
        err = cyruntime.cudaStreamEndCapture(cystream, <cyruntime.cudaGraph_t*>pGraph._pvt_ptr)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pGraph)

@cython.embedsignature(True)
def cudaStreamIsCapturing(stream):
    """ Returns a stream's capture status.

    Return the capture status of `stream` via `pCaptureStatus`. After a
    successful call, `*pCaptureStatus` will contain one of the following:

    - :py:obj:`~.cudaStreamCaptureStatusNone`: The stream is not capturing.

    - :py:obj:`~.cudaStreamCaptureStatusActive`: The stream is capturing.

    - :py:obj:`~.cudaStreamCaptureStatusInvalidated`: The stream was
      capturing but an error has invalidated the capture sequence. The
      capture sequence must be terminated with
      :py:obj:`~.cudaStreamEndCapture` on the stream where it was initiated
      in order to continue using `stream`.

    Note that, if this is called on :py:obj:`~.cudaStreamLegacy` (the "null
    stream") while a blocking stream on the same device is capturing, it
    will return :py:obj:`~.cudaErrorStreamCaptureImplicit` and
    `*pCaptureStatus` is unspecified after the call. The blocking stream
    capture is not invalidated.

    When a blocking stream is capturing, the legacy stream is in an
    unusable state until the blocking stream capture is terminated. The
    legacy stream is not supported for stream capture, but attempted use
    would have an implicit dependency on the capturing stream(s).

    Parameters
    ----------
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream to query

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorStreamCaptureImplicit`
    pCaptureStatus : :py:obj:`~.cudaStreamCaptureStatus`
        Returns the stream's capture status

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamBeginCapture`, :py:obj:`~.cudaStreamEndCapture`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cdef cyruntime.cudaStreamCaptureStatus pCaptureStatus
    with nogil:
        err = cyruntime.cudaStreamIsCapturing(cystream, &pCaptureStatus)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], cudaStreamCaptureStatus(pCaptureStatus))

@cython.embedsignature(True)
def cudaStreamGetCaptureInfo(stream):
    """ Query a stream's capture state.

    Query stream state related to stream capture.

    If called on :py:obj:`~.cudaStreamLegacy` (the "null stream") while a
    stream not created with :py:obj:`~.cudaStreamNonBlocking` is capturing,
    returns :py:obj:`~.cudaErrorStreamCaptureImplicit`.

    Valid data (other than capture status) is returned only if both of the
    following are true:

    - the call returns cudaSuccess

    - the returned capture status is
      :py:obj:`~.cudaStreamCaptureStatusActive`

    If `edgeData_out` is non-NULL then `dependencies_out` must be as well.
    If `dependencies_out` is non-NULL and `edgeData_out` is NULL, but there
    is non-zero edge data for one or more of the current stream
    dependencies, the call will return :py:obj:`~.cudaErrorLossyQuery`.

    Parameters
    ----------
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        The stream to query

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorStreamCaptureImplicit`, :py:obj:`~.cudaErrorLossyQuery`
    captureStatus_out : :py:obj:`~.cudaStreamCaptureStatus`
        Location to return the capture status of the stream; required
    id_out : unsigned long long
        Optional location to return an id for the capture sequence, which
        is unique over the lifetime of the process
    graph_out : :py:obj:`~.cudaGraph_t`
        Optional location to return the graph being captured into. All
        operations other than destroy and node removal are permitted on the
        graph while the capture sequence is in progress. This API does not
        transfer ownership of the graph, which is transferred or destroyed
        at :py:obj:`~.cudaStreamEndCapture`. Note that the graph handle may
        be invalidated before end of capture for certain errors. Nodes that
        are or become unreachable from the original stream at
        :py:obj:`~.cudaStreamEndCapture` due to direct actions on the graph
        do not trigger :py:obj:`~.cudaErrorStreamCaptureUnjoined`.
    dependencies_out : list[:py:obj:`~.cudaGraphNode_t`]
        Optional location to store a pointer to an array of nodes. The next
        node to be captured in the stream will depend on this set of nodes,
        absent operations such as event wait which modify this set. The
        array pointer is valid until the next API call which operates on
        the stream or until the capture is terminated. The node handles may
        be copied out and are valid until they or the graph is destroyed.
        The driver-owned array may also be passed directly to APIs that
        operate on the graph (not the stream) without copying.
    edgeData_out : list[:py:obj:`~.cudaGraphEdgeData`]
        Optional location to store a pointer to an array of graph edge
        data. This array parallels `dependencies_out`; the next node to be
        added has an edge to `dependencies_out`[i] with annotation
        `edgeData_out`[i] for each `i`. The array pointer is valid until
        the next API call which operates on the stream or until the capture
        is terminated.
    numDependencies_out : int
        Optional location to store the size of the array returned in
        dependencies_out.

    See Also
    --------
    :py:obj:`~.cudaStreamBeginCapture`, :py:obj:`~.cudaStreamIsCapturing`, :py:obj:`~.cudaStreamUpdateCaptureDependencies`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cdef cyruntime.cudaStreamCaptureStatus captureStatus_out
    cdef unsigned long long id_out = 0
    cdef cudaGraph_t graph_out = cudaGraph_t()
    cdef const cyruntime.cudaGraphNode_t* cydependencies_out = NULL
    pydependencies_out = []
    cdef const cyruntime.cudaGraphEdgeData* cyedgeData_out = NULL
    pyedgeData_out = []
    cdef size_t numDependencies_out = 0
    with nogil:
        err = cyruntime.cudaStreamGetCaptureInfo(cystream, &captureStatus_out, &id_out, <cyruntime.cudaGraph_t*>graph_out._pvt_ptr, &cydependencies_out, &cyedgeData_out, &numDependencies_out)
    if cudaError_t(err) == cudaError_t(0):
        pydependencies_out = [cudaGraphNode_t(init_value=<void_ptr>cydependencies_out[idx]) for idx in range(numDependencies_out)]
    if cudaError_t(err) == cudaError_t(0):
        pyedgeData_out = [cudaGraphEdgeData(_ptr=<void_ptr>&cyedgeData_out[idx]) for idx in range(numDependencies_out)]
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None, None, None, None, None, None)
    return (_dict_cudaError_t[err], cudaStreamCaptureStatus(captureStatus_out), id_out, graph_out, pydependencies_out, pyedgeData_out, numDependencies_out)

@cython.embedsignature(True)
def cudaStreamUpdateCaptureDependencies(stream, dependencies : Optional[tuple[cudaGraphNode_t] | list[cudaGraphNode_t]], dependencyData : Optional[tuple[cudaGraphEdgeData] | list[cudaGraphEdgeData]], size_t numDependencies, unsigned int flags):
    """ Update the set of dependencies in a capturing stream.

    Modifies the dependency set of a capturing stream. The dependency set
    is the set of nodes that the next captured node in the stream will
    depend on.

    Valid flags are :py:obj:`~.cudaStreamAddCaptureDependencies` and
    :py:obj:`~.cudaStreamSetCaptureDependencies`. These control whether the
    set passed to the API is added to the existing set or replaces it. A
    flags value of 0 defaults to
    :py:obj:`~.cudaStreamAddCaptureDependencies`.

    Nodes that are removed from the dependency set via this API do not
    result in :py:obj:`~.cudaErrorStreamCaptureUnjoined` if they are
    unreachable from the stream at :py:obj:`~.cudaStreamEndCapture`.

    Returns :py:obj:`~.cudaErrorIllegalState` if the stream is not
    capturing.

    Parameters
    ----------
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        The stream to update
    dependencies : list[:py:obj:`~.cudaGraphNode_t`]
        The set of dependencies to add
    dependencyData : list[:py:obj:`~.cudaGraphEdgeData`]
        Optional array of data associated with each dependency.
    numDependencies : size_t
        The size of the dependencies array
    flags : unsigned int
        See above

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorIllegalState`

    See Also
    --------
    :py:obj:`~.cudaStreamBeginCapture`, :py:obj:`~.cudaStreamGetCaptureInfo`,
    """
    dependencyData = [] if dependencyData is None else dependencyData
    if not all(isinstance(_x, (cudaGraphEdgeData,)) for _x in dependencyData):
        raise TypeError("Argument 'dependencyData' is not instance of type (expected tuple[cyruntime.cudaGraphEdgeData,] or list[cyruntime.cudaGraphEdgeData,]")
    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (cudaGraphNode_t,driver.CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected tuple[cyruntime.cudaGraphNode_t,driver.CUgraphNode] or list[cyruntime.cudaGraphNode_t,driver.CUgraphNode]")
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cdef cyruntime.cudaGraphNode_t* cydependencies = NULL
    if len(dependencies) > 1:
        cydependencies = <cyruntime.cudaGraphNode_t*> calloc(len(dependencies), sizeof(cyruntime.cudaGraphNode_t))
        if cydependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(cyruntime.cudaGraphNode_t)))
        else:
            for idx in range(len(dependencies)):
                cydependencies[idx] = <cyruntime.cudaGraphNode_t>(<cudaGraphNode_t>dependencies[idx])._pvt_ptr[0]
    elif len(dependencies) == 1:
        cydependencies = <cyruntime.cudaGraphNode_t*>(<cudaGraphNode_t>dependencies[0])._pvt_ptr
    cdef cyruntime.cudaGraphEdgeData* cydependencyData = NULL
    if len(dependencyData) > 1:
        cydependencyData = <cyruntime.cudaGraphEdgeData*> calloc(len(dependencyData), sizeof(cyruntime.cudaGraphEdgeData))
        if cydependencyData is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencyData)) + 'x' + str(sizeof(cyruntime.cudaGraphEdgeData)))
        for idx in range(len(dependencyData)):
            string.memcpy(&cydependencyData[idx], (<cudaGraphEdgeData>dependencyData[idx])._pvt_ptr, sizeof(cyruntime.cudaGraphEdgeData))
    elif len(dependencyData) == 1:
        cydependencyData = (<cudaGraphEdgeData>dependencyData[0])._pvt_ptr
    with nogil:
        err = cyruntime.cudaStreamUpdateCaptureDependencies(cystream, cydependencies, cydependencyData, numDependencies, flags)
    if len(dependencies) > 1 and cydependencies is not NULL:
        free(cydependencies)
    if len(dependencyData) > 1 and cydependencyData is not NULL:
        free(cydependencyData)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaEventCreate():
    """ Creates an event object.

    Creates an event object for the current device using
    :py:obj:`~.cudaEventDefault`.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorLaunchFailure`, :py:obj:`~.cudaErrorMemoryAllocation`
    event : :py:obj:`~.cudaEvent_t`
        Newly created event

    See Also
    --------
    cudaEventCreate (C++ API), :py:obj:`~.cudaEventCreateWithFlags`, :py:obj:`~.cudaEventRecord`, :py:obj:`~.cudaEventQuery`, :py:obj:`~.cudaEventSynchronize`, :py:obj:`~.cudaEventDestroy`, :py:obj:`~.cudaEventElapsedTime`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cuEventCreate`
    """
    cdef cudaEvent_t event = cudaEvent_t()
    with nogil:
        err = cyruntime.cudaEventCreate(<cyruntime.cudaEvent_t*>event._pvt_ptr)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], event)

@cython.embedsignature(True)
def cudaEventCreateWithFlags(unsigned int flags):
    """ Creates an event object with the specified flags.

    Creates an event object for the current device with the specified
    flags. Valid flags include:

    - :py:obj:`~.cudaEventDefault`: Default event creation flag.

    - :py:obj:`~.cudaEventBlockingSync`: Specifies that event should use
      blocking synchronization. A host thread that uses
      :py:obj:`~.cudaEventSynchronize()` to wait on an event created with
      this flag will block until the event actually completes.

    - :py:obj:`~.cudaEventDisableTiming`: Specifies that the created event
      does not need to record timing data. Events created with this flag
      specified and the :py:obj:`~.cudaEventBlockingSync` flag not
      specified will provide the best performance when used with
      :py:obj:`~.cudaStreamWaitEvent()` and :py:obj:`~.cudaEventQuery()`.

    - :py:obj:`~.cudaEventInterprocess`: Specifies that the created event
      may be used as an interprocess event by
      :py:obj:`~.cudaIpcGetEventHandle()`.
      :py:obj:`~.cudaEventInterprocess` must be specified along with
      :py:obj:`~.cudaEventDisableTiming`.

    Parameters
    ----------
    flags : unsigned int
        Flags for new event

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorLaunchFailure`, :py:obj:`~.cudaErrorMemoryAllocation`
    event : :py:obj:`~.cudaEvent_t`
        Newly created event

    See Also
    --------
    :py:obj:`~.cudaEventCreate (C API)`, :py:obj:`~.cudaEventSynchronize`, :py:obj:`~.cudaEventDestroy`, :py:obj:`~.cudaEventElapsedTime`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cuEventCreate`
    """
    cdef cudaEvent_t event = cudaEvent_t()
    with nogil:
        err = cyruntime.cudaEventCreateWithFlags(<cyruntime.cudaEvent_t*>event._pvt_ptr, flags)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], event)

@cython.embedsignature(True)
def cudaEventRecord(event, stream):
    """ Records an event.

    Captures in `event` the contents of `stream` at the time of this call.
    `event` and `stream` must be on the same CUDA context. Calls such as
    :py:obj:`~.cudaEventQuery()` or :py:obj:`~.cudaStreamWaitEvent()` will
    then examine or wait for completion of the work that was captured. Uses
    of `stream` after this call do not modify `event`. See note on default
    stream behavior for what is captured in the default case.

    :py:obj:`~.cudaEventRecord()` can be called multiple times on the same
    event and will overwrite the previously captured state. Other APIs such
    as :py:obj:`~.cudaStreamWaitEvent()` use the most recently captured
    state at the time of the API call, and are not affected by later calls
    to :py:obj:`~.cudaEventRecord()`. Before the first call to
    :py:obj:`~.cudaEventRecord()`, an event represents an empty set of
    work, so for example :py:obj:`~.cudaEventQuery()` would return
    :py:obj:`~.cudaSuccess`.

    Parameters
    ----------
    event : :py:obj:`~.CUevent` or :py:obj:`~.cudaEvent_t`
        Event to record
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream in which to record event

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorLaunchFailure`

    See Also
    --------
    :py:obj:`~.cudaEventCreate (C API)`, :py:obj:`~.cudaEventCreateWithFlags`, :py:obj:`~.cudaEventQuery`, :py:obj:`~.cudaEventSynchronize`, :py:obj:`~.cudaEventDestroy`, :py:obj:`~.cudaEventElapsedTime`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaEventRecordWithFlags`, :py:obj:`~.cuEventRecord`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cdef cyruntime.cudaEvent_t cyevent
    if event is None:
        pevent = 0
    elif isinstance(event, (cudaEvent_t,driver.CUevent)):
        pevent = int(event)
    else:
        pevent = int(cudaEvent_t(event))
    cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
    with nogil:
        err = cyruntime.cudaEventRecord(cyevent, cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaEventRecordWithFlags(event, stream, unsigned int flags):
    """ Records an event.

    Captures in `event` the contents of `stream` at the time of this call.
    `event` and `stream` must be on the same CUDA context. Calls such as
    :py:obj:`~.cudaEventQuery()` or :py:obj:`~.cudaStreamWaitEvent()` will
    then examine or wait for completion of the work that was captured. Uses
    of `stream` after this call do not modify `event`. See note on default
    stream behavior for what is captured in the default case.

    :py:obj:`~.cudaEventRecordWithFlags()` can be called multiple times on
    the same event and will overwrite the previously captured state. Other
    APIs such as :py:obj:`~.cudaStreamWaitEvent()` use the most recently
    captured state at the time of the API call, and are not affected by
    later calls to :py:obj:`~.cudaEventRecordWithFlags()`. Before the first
    call to :py:obj:`~.cudaEventRecordWithFlags()`, an event represents an
    empty set of work, so for example :py:obj:`~.cudaEventQuery()` would
    return :py:obj:`~.cudaSuccess`.

    flags include:

    - :py:obj:`~.cudaEventRecordDefault`: Default event creation flag.

    - :py:obj:`~.cudaEventRecordExternal`: Event is captured in the graph
      as an external event node when performing stream capture.

    Parameters
    ----------
    event : :py:obj:`~.CUevent` or :py:obj:`~.cudaEvent_t`
        Event to record
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream in which to record event
    flags : unsigned int
        Parameters for the operation(See above)

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorLaunchFailure`

    See Also
    --------
    :py:obj:`~.cudaEventCreate (C API)`, :py:obj:`~.cudaEventCreateWithFlags`, :py:obj:`~.cudaEventQuery`, :py:obj:`~.cudaEventSynchronize`, :py:obj:`~.cudaEventDestroy`, :py:obj:`~.cudaEventElapsedTime`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaEventRecord`, :py:obj:`~.cuEventRecord`,
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cdef cyruntime.cudaEvent_t cyevent
    if event is None:
        pevent = 0
    elif isinstance(event, (cudaEvent_t,driver.CUevent)):
        pevent = int(event)
    else:
        pevent = int(cudaEvent_t(event))
    cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
    with nogil:
        err = cyruntime.cudaEventRecordWithFlags(cyevent, cystream, flags)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaEventQuery(event):
    """ Queries an event's status.

    Queries the status of all work currently captured by `event`. See
    :py:obj:`~.cudaEventRecord()` for details on what is captured by an
    event.

    Returns :py:obj:`~.cudaSuccess` if all captured work has been
    completed, or :py:obj:`~.cudaErrorNotReady` if any captured work is
    incomplete.

    For the purposes of Unified Memory, a return value of
    :py:obj:`~.cudaSuccess` is equivalent to having called
    :py:obj:`~.cudaEventSynchronize()`.

    Parameters
    ----------
    event : :py:obj:`~.CUevent` or :py:obj:`~.cudaEvent_t`
        Event to query

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorNotReady`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorLaunchFailure`

    See Also
    --------
    :py:obj:`~.cudaEventCreate (C API)`, :py:obj:`~.cudaEventCreateWithFlags`, :py:obj:`~.cudaEventRecord`, :py:obj:`~.cudaEventSynchronize`, :py:obj:`~.cudaEventDestroy`, :py:obj:`~.cudaEventElapsedTime`, :py:obj:`~.cuEventQuery`
    """
    cdef cyruntime.cudaEvent_t cyevent
    if event is None:
        pevent = 0
    elif isinstance(event, (cudaEvent_t,driver.CUevent)):
        pevent = int(event)
    else:
        pevent = int(cudaEvent_t(event))
    cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
    with nogil:
        err = cyruntime.cudaEventQuery(cyevent)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaEventSynchronize(event):
    """ Waits for an event to complete.

    Waits until the completion of all work currently captured in `event`.
    See :py:obj:`~.cudaEventRecord()` for details on what is captured by an
    event.

    Waiting for an event that was created with the
    :py:obj:`~.cudaEventBlockingSync` flag will cause the calling CPU
    thread to block until the event has been completed by the device. If
    the :py:obj:`~.cudaEventBlockingSync` flag has not been set, then the
    CPU thread will busy-wait until the event has been completed by the
    device.

    Parameters
    ----------
    event : :py:obj:`~.CUevent` or :py:obj:`~.cudaEvent_t`
        Event to wait for

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorLaunchFailure`

    See Also
    --------
    :py:obj:`~.cudaEventCreate (C API)`, :py:obj:`~.cudaEventCreateWithFlags`, :py:obj:`~.cudaEventRecord`, :py:obj:`~.cudaEventQuery`, :py:obj:`~.cudaEventDestroy`, :py:obj:`~.cudaEventElapsedTime`, :py:obj:`~.cuEventSynchronize`
    """
    cdef cyruntime.cudaEvent_t cyevent
    if event is None:
        pevent = 0
    elif isinstance(event, (cudaEvent_t,driver.CUevent)):
        pevent = int(event)
    else:
        pevent = int(cudaEvent_t(event))
    cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
    with nogil:
        err = cyruntime.cudaEventSynchronize(cyevent)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaEventDestroy(event):
    """ Destroys an event object.

    Destroys the event specified by `event`.

    An event may be destroyed before it is complete (i.e., while
    :py:obj:`~.cudaEventQuery()` would return
    :py:obj:`~.cudaErrorNotReady`). In this case, the call does not block
    on completion of the event, and any associated resources will
    automatically be released asynchronously at completion.

    Parameters
    ----------
    event : :py:obj:`~.CUevent` or :py:obj:`~.cudaEvent_t`
        Event to destroy

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorLaunchFailure`

    See Also
    --------
    :py:obj:`~.cudaEventCreate (C API)`, :py:obj:`~.cudaEventCreateWithFlags`, :py:obj:`~.cudaEventQuery`, :py:obj:`~.cudaEventSynchronize`, :py:obj:`~.cudaEventRecord`, :py:obj:`~.cudaEventElapsedTime`, :py:obj:`~.cuEventDestroy`
    """
    cdef cyruntime.cudaEvent_t cyevent
    if event is None:
        pevent = 0
    elif isinstance(event, (cudaEvent_t,driver.CUevent)):
        pevent = int(event)
    else:
        pevent = int(cudaEvent_t(event))
    cyevent = <cyruntime.cudaEvent_t><void_ptr>pevent
    with nogil:
        err = cyruntime.cudaEventDestroy(cyevent)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaEventElapsedTime(start, end):
    """ Computes the elapsed time between events.

    Computes the elapsed time between two events (in milliseconds with a
    resolution of around 0.5 microseconds). Note this API is not guaranteed
    to return the latest errors for pending work. As such this API is
    intended to serve as a elapsed time calculation only and polling for
    completion on the events to be compared should be done with
    :py:obj:`~.cudaEventQuery` instead.

    If either event was last recorded in a non-NULL stream, the resulting
    time may be greater than expected (even if both used the same stream
    handle). This happens because the :py:obj:`~.cudaEventRecord()`
    operation takes place asynchronously and there is no guarantee that the
    measured latency is actually just between the two events. Any number of
    other different stream operations could execute in between the two
    measured events, thus altering the timing in a significant way.

    If :py:obj:`~.cudaEventRecord()` has not been called on either event,
    then :py:obj:`~.cudaErrorInvalidResourceHandle` is returned. If
    :py:obj:`~.cudaEventRecord()` has been called on both events but one or
    both of them has not yet been completed (that is,
    :py:obj:`~.cudaEventQuery()` would return :py:obj:`~.cudaErrorNotReady`
    on at least one of the events), :py:obj:`~.cudaErrorNotReady` is
    returned. If either event was created with the
    :py:obj:`~.cudaEventDisableTiming` flag, then this function will return
    :py:obj:`~.cudaErrorInvalidResourceHandle`.

    Parameters
    ----------
    start : :py:obj:`~.CUevent` or :py:obj:`~.cudaEvent_t`
        Starting event
    end : :py:obj:`~.CUevent` or :py:obj:`~.cudaEvent_t`
        Ending event

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorNotReady`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorLaunchFailure`, :py:obj:`~.cudaErrorUnknown`
    ms : float
        Time between `start` and `end` in ms

    See Also
    --------
    :py:obj:`~.cudaEventCreate (C API)`, :py:obj:`~.cudaEventCreateWithFlags`, :py:obj:`~.cudaEventQuery`, :py:obj:`~.cudaEventSynchronize`, :py:obj:`~.cudaEventDestroy`, :py:obj:`~.cudaEventRecord`, :py:obj:`~.cuEventElapsedTime`
    """
    cdef cyruntime.cudaEvent_t cyend
    if end is None:
        pend = 0
    elif isinstance(end, (cudaEvent_t,driver.CUevent)):
        pend = int(end)
    else:
        pend = int(cudaEvent_t(end))
    cyend = <cyruntime.cudaEvent_t><void_ptr>pend
    cdef cyruntime.cudaEvent_t cystart
    if start is None:
        pstart = 0
    elif isinstance(start, (cudaEvent_t,driver.CUevent)):
        pstart = int(start)
    else:
        pstart = int(cudaEvent_t(start))
    cystart = <cyruntime.cudaEvent_t><void_ptr>pstart
    cdef float ms = 0
    with nogil:
        err = cyruntime.cudaEventElapsedTime(&ms, cystart, cyend)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], ms)

@cython.embedsignature(True)
def cudaImportExternalMemory(memHandleDesc : Optional[cudaExternalMemoryHandleDesc]):
    """ Imports an external memory object.

    Imports an externally allocated memory object and returns a handle to
    that in `extMem_out`.

    The properties of the handle being imported must be described in
    `memHandleDesc`. The :py:obj:`~.cudaExternalMemoryHandleDesc` structure
    is defined as follows:

    **View CUDA Toolkit Documentation for a C++ code example**

    where :py:obj:`~.cudaExternalMemoryHandleDesc.type` specifies the type
    of handle being imported. :py:obj:`~.cudaExternalMemoryHandleType` is
    defined as:

    **View CUDA Toolkit Documentation for a C++ code example**

    If :py:obj:`~.cudaExternalMemoryHandleDesc.type` is
    :py:obj:`~.cudaExternalMemoryHandleTypeOpaqueFd`, then
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::fd must be a valid
    file descriptor referencing a memory object. Ownership of the file
    descriptor is transferred to the CUDA driver when the handle is
    imported successfully. Performing any operations on the file descriptor
    after it is imported results in undefined behavior.

    If :py:obj:`~.cudaExternalMemoryHandleDesc.type` is
    :py:obj:`~.cudaExternalMemoryHandleTypeOpaqueWin32`, then exactly one
    of :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::handle and
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::name must not
    be NULL. If
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::handle is not
    NULL, then it must represent a valid shared NT handle that references a
    memory object. Ownership of this handle is not transferred to CUDA
    after the import operation, so the application must release the handle
    using the appropriate system call. If
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::name is not
    NULL, then it must point to a NULL-terminated array of UTF-16
    characters that refers to a memory object.

    If :py:obj:`~.cudaExternalMemoryHandleDesc.type` is
    :py:obj:`~.cudaExternalMemoryHandleTypeOpaqueWin32Kmt`, then
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::handle must be
    non-NULL and
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::name must be
    NULL. The handle specified must be a globally shared KMT handle. This
    handle does not hold a reference to the underlying object, and thus
    will be invalid when all references to the memory object are destroyed.

    If :py:obj:`~.cudaExternalMemoryHandleDesc.type` is
    :py:obj:`~.cudaExternalMemoryHandleTypeD3D12Heap`, then exactly one of
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::handle and
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::name must not
    be NULL. If
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::handle is not
    NULL, then it must represent a valid shared NT handle that is returned
    by ID3D12Device::CreateSharedHandle when referring to a ID3D12Heap
    object. This handle holds a reference to the underlying object. If
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::name is not
    NULL, then it must point to a NULL-terminated array of UTF-16
    characters that refers to a ID3D12Heap object.

    If :py:obj:`~.cudaExternalMemoryHandleDesc.type` is
    :py:obj:`~.cudaExternalMemoryHandleTypeD3D12Resource`, then exactly one
    of :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::handle and
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::name must not
    be NULL. If
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::handle is not
    NULL, then it must represent a valid shared NT handle that is returned
    by ID3D12Device::CreateSharedHandle when referring to a ID3D12Resource
    object. This handle holds a reference to the underlying object. If
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::name is not
    NULL, then it must point to a NULL-terminated array of UTF-16
    characters that refers to a ID3D12Resource object.

    If :py:obj:`~.cudaExternalMemoryHandleDesc.type` is
    :py:obj:`~.cudaExternalMemoryHandleTypeD3D11Resource`,then exactly one
    of :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::handle and
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::name must not
    be NULL. If
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::handle is
    not NULL, then it must represent a valid shared NT handle that is
    returned by IDXGIResource1::CreateSharedHandle when referring to a
    ID3D11Resource object. If
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::name is not
    NULL, then it must point to a NULL-terminated array of UTF-16
    characters that refers to a ID3D11Resource object.

    If :py:obj:`~.cudaExternalMemoryHandleDesc.type` is
    :py:obj:`~.cudaExternalMemoryHandleTypeD3D11ResourceKmt`, then
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::handle must be
    non-NULL and
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::win32::name must be
    NULL. The handle specified must be a valid shared KMT handle that is
    returned by IDXGIResource::GetSharedHandle when referring to a
    ID3D11Resource object.

    If :py:obj:`~.cudaExternalMemoryHandleDesc.type` is
    :py:obj:`~.cudaExternalMemoryHandleTypeNvSciBuf`, then
    :py:obj:`~.cudaExternalMemoryHandleDesc`::handle::nvSciBufObject must
    be NON-NULL and reference a valid NvSciBuf object. If the NvSciBuf
    object imported into CUDA is also mapped by other drivers, then the
    application must use :py:obj:`~.cudaWaitExternalSemaphoresAsync` or
    :py:obj:`~.cudaSignalExternalSemaphoresAsync` as approprriate barriers
    to maintain coherence between CUDA and the other drivers. See
    :py:obj:`~.cudaExternalSemaphoreWaitSkipNvSciBufMemSync` and
    :py:obj:`~.cudaExternalSemaphoreSignalSkipNvSciBufMemSync` for memory
    synchronization.

    The size of the memory object must be specified in
    :py:obj:`~.cudaExternalMemoryHandleDesc.size`.

    Specifying the flag :py:obj:`~.cudaExternalMemoryDedicated` in
    :py:obj:`~.cudaExternalMemoryHandleDesc.flags` indicates that the
    resource is a dedicated resource. The definition of what a dedicated
    resource is outside the scope of this extension. This flag must be set
    if :py:obj:`~.cudaExternalMemoryHandleDesc.type` is one of the
    following: :py:obj:`~.cudaExternalMemoryHandleTypeD3D12Resource`
    :py:obj:`~.cudaExternalMemoryHandleTypeD3D11Resource`
    :py:obj:`~.cudaExternalMemoryHandleTypeD3D11ResourceKmt`

    Parameters
    ----------
    memHandleDesc : :py:obj:`~.cudaExternalMemoryHandleDesc`
        Memory import handle descriptor

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorOperatingSystem`
    extMem_out : :py:obj:`~.cudaExternalMemory_t`
        Returned handle to an external memory object

    See Also
    --------
    :py:obj:`~.cudaDestroyExternalMemory`, :py:obj:`~.cudaExternalMemoryGetMappedBuffer`, :py:obj:`~.cudaExternalMemoryGetMappedMipmappedArray`

    Notes
    -----
    If the Vulkan memory imported into CUDA is mapped on the CPU then the application must use vkInvalidateMappedMemoryRanges/vkFlushMappedMemoryRanges as well as appropriate Vulkan pipeline barriers to maintain coherence between CPU and GPU. For more information on these APIs, please refer to "Synchronization
    and Cache Control" chapter from Vulkan specification.
    """
    cdef cudaExternalMemory_t extMem_out = cudaExternalMemory_t()
    cdef cyruntime.cudaExternalMemoryHandleDesc* cymemHandleDesc_ptr = memHandleDesc._pvt_ptr if memHandleDesc is not None else NULL
    with nogil:
        err = cyruntime.cudaImportExternalMemory(<cyruntime.cudaExternalMemory_t*>extMem_out._pvt_ptr, cymemHandleDesc_ptr)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], extMem_out)

@cython.embedsignature(True)
def cudaExternalMemoryGetMappedBuffer(extMem, bufferDesc : Optional[cudaExternalMemoryBufferDesc]):
    """ Maps a buffer onto an imported memory object.

    Maps a buffer onto an imported memory object and returns a device
    pointer in `devPtr`.

    The properties of the buffer being mapped must be described in
    `bufferDesc`. The :py:obj:`~.cudaExternalMemoryBufferDesc` structure is
    defined as follows:

    **View CUDA Toolkit Documentation for a C++ code example**

    where :py:obj:`~.cudaExternalMemoryBufferDesc.offset` is the offset in
    the memory object where the buffer's base address is.
    :py:obj:`~.cudaExternalMemoryBufferDesc.size` is the size of the
    buffer. :py:obj:`~.cudaExternalMemoryBufferDesc.flags` must be zero.

    The offset and size have to be suitably aligned to match the
    requirements of the external API. Mapping two buffers whose ranges
    overlap may or may not result in the same virtual address being
    returned for the overlapped portion. In such cases, the application
    must ensure that all accesses to that region from the GPU are volatile.
    Otherwise writes made via one address are not guaranteed to be visible
    via the other address, even if they're issued by the same thread. It is
    recommended that applications map the combined range instead of mapping
    separate buffers and then apply the appropriate offsets to the returned
    pointer to derive the individual buffers.

    The returned pointer `devPtr` must be freed using :py:obj:`~.cudaFree`.

    Parameters
    ----------
    extMem : :py:obj:`~.cudaExternalMemory_t`
        Handle to external memory object
    bufferDesc : :py:obj:`~.cudaExternalMemoryBufferDesc`
        Buffer descriptor

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`
    devPtr : Any
        Returned device pointer to buffer

    See Also
    --------
    :py:obj:`~.cudaImportExternalMemory`, :py:obj:`~.cudaDestroyExternalMemory`, :py:obj:`~.cudaExternalMemoryGetMappedMipmappedArray`
    """
    cdef cyruntime.cudaExternalMemory_t cyextMem
    if extMem is None:
        pextMem = 0
    elif isinstance(extMem, (cudaExternalMemory_t,)):
        pextMem = int(extMem)
    else:
        pextMem = int(cudaExternalMemory_t(extMem))
    cyextMem = <cyruntime.cudaExternalMemory_t><void_ptr>pextMem
    cdef void_ptr devPtr = 0
    cdef cyruntime.cudaExternalMemoryBufferDesc* cybufferDesc_ptr = bufferDesc._pvt_ptr if bufferDesc is not None else NULL
    with nogil:
        err = cyruntime.cudaExternalMemoryGetMappedBuffer(<void**>&devPtr, cyextMem, cybufferDesc_ptr)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], devPtr)

@cython.embedsignature(True)
def cudaExternalMemoryGetMappedMipmappedArray(extMem, mipmapDesc : Optional[cudaExternalMemoryMipmappedArrayDesc]):
    """ Maps a CUDA mipmapped array onto an external memory object.

    Maps a CUDA mipmapped array onto an external object and returns a
    handle to it in `mipmap`.

    The properties of the CUDA mipmapped array being mapped must be
    described in `mipmapDesc`. The structure
    :py:obj:`~.cudaExternalMemoryMipmappedArrayDesc` is defined as follows:

    **View CUDA Toolkit Documentation for a C++ code example**

    where :py:obj:`~.cudaExternalMemoryMipmappedArrayDesc.offset` is the
    offset in the memory object where the base level of the mipmap chain
    is. :py:obj:`~.cudaExternalMemoryMipmappedArrayDesc.formatDesc`
    describes the format of the data.
    :py:obj:`~.cudaExternalMemoryMipmappedArrayDesc.extent` specifies the
    dimensions of the base level of the mipmap chain.
    :py:obj:`~.cudaExternalMemoryMipmappedArrayDesc.flags` are flags
    associated with CUDA mipmapped arrays. For further details, please
    refer to the documentation for :py:obj:`~.cudaMalloc3DArray`. Note that
    if the mipmapped array is bound as a color target in the graphics API,
    then the flag :py:obj:`~.cudaArrayColorAttachment` must be specified in
    :py:obj:`~.cudaExternalMemoryMipmappedArrayDesc.flags`.
    :py:obj:`~.cudaExternalMemoryMipmappedArrayDesc.numLevels` specifies
    the total number of levels in the mipmap chain.

    The returned CUDA mipmapped array must be freed using
    :py:obj:`~.cudaFreeMipmappedArray`.

    Parameters
    ----------
    extMem : :py:obj:`~.cudaExternalMemory_t`
        Handle to external memory object
    mipmapDesc : :py:obj:`~.cudaExternalMemoryMipmappedArrayDesc`
        CUDA array descriptor

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidResourceHandle`
    mipmap : :py:obj:`~.cudaMipmappedArray_t`
        Returned CUDA mipmapped array

    See Also
    --------
    :py:obj:`~.cudaImportExternalMemory`, :py:obj:`~.cudaDestroyExternalMemory`, :py:obj:`~.cudaExternalMemoryGetMappedBuffer`

    Notes
    -----
    If :py:obj:`~.cudaExternalMemoryHandleDesc.type` is :py:obj:`~.cudaExternalMemoryHandleTypeNvSciBuf`, then :py:obj:`~.cudaExternalMemoryMipmappedArrayDesc.numLevels` must not be greater than 1.
    """
    cdef cyruntime.cudaExternalMemory_t cyextMem
    if extMem is None:
        pextMem = 0
    elif isinstance(extMem, (cudaExternalMemory_t,)):
        pextMem = int(extMem)
    else:
        pextMem = int(cudaExternalMemory_t(extMem))
    cyextMem = <cyruntime.cudaExternalMemory_t><void_ptr>pextMem
    cdef cudaMipmappedArray_t mipmap = cudaMipmappedArray_t()
    cdef cyruntime.cudaExternalMemoryMipmappedArrayDesc* cymipmapDesc_ptr = mipmapDesc._pvt_ptr if mipmapDesc is not None else NULL
    with nogil:
        err = cyruntime.cudaExternalMemoryGetMappedMipmappedArray(<cyruntime.cudaMipmappedArray_t*>mipmap._pvt_ptr, cyextMem, cymipmapDesc_ptr)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], mipmap)

@cython.embedsignature(True)
def cudaDestroyExternalMemory(extMem):
    """ Destroys an external memory object.

    Destroys the specified external memory object. Any existing buffers and
    CUDA mipmapped arrays mapped onto this object must no longer be used
    and must be explicitly freed using :py:obj:`~.cudaFree` and
    :py:obj:`~.cudaFreeMipmappedArray` respectively.

    Parameters
    ----------
    extMem : :py:obj:`~.cudaExternalMemory_t`
        External memory object to be destroyed

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidResourceHandle`

    See Also
    --------
    :py:obj:`~.cudaImportExternalMemory`, :py:obj:`~.cudaExternalMemoryGetMappedBuffer`, :py:obj:`~.cudaExternalMemoryGetMappedMipmappedArray`
    """
    cdef cyruntime.cudaExternalMemory_t cyextMem
    if extMem is None:
        pextMem = 0
    elif isinstance(extMem, (cudaExternalMemory_t,)):
        pextMem = int(extMem)
    else:
        pextMem = int(cudaExternalMemory_t(extMem))
    cyextMem = <cyruntime.cudaExternalMemory_t><void_ptr>pextMem
    with nogil:
        err = cyruntime.cudaDestroyExternalMemory(cyextMem)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaImportExternalSemaphore(semHandleDesc : Optional[cudaExternalSemaphoreHandleDesc]):
    """ Imports an external semaphore.

    Imports an externally allocated synchronization object and returns a
    handle to that in `extSem_out`.

    The properties of the handle being imported must be described in
    `semHandleDesc`. The :py:obj:`~.cudaExternalSemaphoreHandleDesc` is
    defined as follows:

    **View CUDA Toolkit Documentation for a C++ code example**

    where :py:obj:`~.cudaExternalSemaphoreHandleDesc.type` specifies the
    type of handle being imported.
    :py:obj:`~.cudaExternalSemaphoreHandleType` is defined as:

    **View CUDA Toolkit Documentation for a C++ code example**

    If :py:obj:`~.cudaExternalSemaphoreHandleDesc.type` is
    :py:obj:`~.cudaExternalSemaphoreHandleTypeOpaqueFd`, then
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::fd must be a valid
    file descriptor referencing a synchronization object. Ownership of the
    file descriptor is transferred to the CUDA driver when the handle is
    imported successfully. Performing any operations on the file descriptor
    after it is imported results in undefined behavior.

    If :py:obj:`~.cudaExternalSemaphoreHandleDesc.type` is
    :py:obj:`~.cudaExternalSemaphoreHandleTypeOpaqueWin32`, then exactly
    one of
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::handle and
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::name must
    not be NULL. If
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::handle is
    not NULL, then it must represent a valid shared NT handle that
    references a synchronization object. Ownership of this handle is not
    transferred to CUDA after the import operation, so the application must
    release the handle using the appropriate system call. If
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::name is not
    NULL, then it must name a valid synchronization object.

    If :py:obj:`~.cudaExternalSemaphoreHandleDesc.type` is
    :py:obj:`~.cudaExternalSemaphoreHandleTypeOpaqueWin32Kmt`, then
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::handle must
    be non-NULL and
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::name must
    be NULL. The handle specified must be a globally shared KMT handle.
    This handle does not hold a reference to the underlying object, and
    thus will be invalid when all references to the synchronization object
    are destroyed.

    If :py:obj:`~.cudaExternalSemaphoreHandleDesc.type` is
    :py:obj:`~.cudaExternalSemaphoreHandleTypeD3D12Fence`, then exactly one
    of :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::handle
    and :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::name
    must not be NULL. If
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::handle is
    not NULL, then it must represent a valid shared NT handle that is
    returned by ID3D12Device::CreateSharedHandle when referring to a
    ID3D12Fence object. This handle holds a reference to the underlying
    object. If
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::name is not
    NULL, then it must name a valid synchronization object that refers to a
    valid ID3D12Fence object.

    If :py:obj:`~.cudaExternalSemaphoreHandleDesc.type` is
    :py:obj:`~.cudaExternalSemaphoreHandleTypeD3D11Fence`, then exactly one
    of :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::handle
    and :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::name
    must not be NULL. If
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::handle is
    not NULL, then it must represent a valid shared NT handle that is
    returned by ID3D11Fence::CreateSharedHandle. If
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::name is not
    NULL, then it must name a valid synchronization object that refers to a
    valid ID3D11Fence object.

    If :py:obj:`~.cudaExternalSemaphoreHandleDesc.type` is
    :py:obj:`~.cudaExternalSemaphoreHandleTypeNvSciSync`, then
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::nvSciSyncObj
    represents a valid NvSciSyncObj.

    :py:obj:`~.cudaExternalSemaphoreHandleTypeKeyedMutex`, then exactly one
    of :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::handle
    and :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::name
    must not be NULL. If
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::handle is
    not NULL, then it represent a valid shared NT handle that is returned
    by IDXGIResource1::CreateSharedHandle when referring to a
    IDXGIKeyedMutex object.

    If :py:obj:`~.cudaExternalSemaphoreHandleDesc.type` is
    :py:obj:`~.cudaExternalSemaphoreHandleTypeKeyedMutexKmt`, then
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::handle must
    be non-NULL and
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::name must
    be NULL. The handle specified must represent a valid KMT handle that is
    returned by IDXGIResource::GetSharedHandle when referring to a
    IDXGIKeyedMutex object.

    If :py:obj:`~.cudaExternalSemaphoreHandleDesc.type` is
    :py:obj:`~.cudaExternalSemaphoreHandleTypeTimelineSemaphoreFd`, then
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::fd must be a valid
    file descriptor referencing a synchronization object. Ownership of the
    file descriptor is transferred to the CUDA driver when the handle is
    imported successfully. Performing any operations on the file descriptor
    after it is imported results in undefined behavior.

    If :py:obj:`~.cudaExternalSemaphoreHandleDesc.type` is
    :py:obj:`~.cudaExternalSemaphoreHandleTypeTimelineSemaphoreWin32`, then
    exactly one of
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::handle and
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::name must
    not be NULL. If
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::handle is
    not NULL, then it must represent a valid shared NT handle that
    references a synchronization object. Ownership of this handle is not
    transferred to CUDA after the import operation, so the application must
    release the handle using the appropriate system call. If
    :py:obj:`~.cudaExternalSemaphoreHandleDesc`::handle::win32::name is not
    NULL, then it must name a valid synchronization object.

    Parameters
    ----------
    semHandleDesc : :py:obj:`~.cudaExternalSemaphoreHandleDesc`
        Semaphore import handle descriptor

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorOperatingSystem`
    extSem_out : :py:obj:`~.cudaExternalSemaphore_t`
        Returned handle to an external semaphore

    See Also
    --------
    :py:obj:`~.cudaDestroyExternalSemaphore`, :py:obj:`~.cudaSignalExternalSemaphoresAsync`, :py:obj:`~.cudaWaitExternalSemaphoresAsync`
    """
    cdef cudaExternalSemaphore_t extSem_out = cudaExternalSemaphore_t()
    cdef cyruntime.cudaExternalSemaphoreHandleDesc* cysemHandleDesc_ptr = semHandleDesc._pvt_ptr if semHandleDesc is not None else NULL
    with nogil:
        err = cyruntime.cudaImportExternalSemaphore(<cyruntime.cudaExternalSemaphore_t*>extSem_out._pvt_ptr, cysemHandleDesc_ptr)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], extSem_out)

@cython.embedsignature(True)
def cudaSignalExternalSemaphoresAsync(extSemArray : Optional[tuple[cudaExternalSemaphore_t] | list[cudaExternalSemaphore_t]], paramsArray : Optional[tuple[cudaExternalSemaphoreSignalParams] | list[cudaExternalSemaphoreSignalParams]], unsigned int numExtSems, stream):
    """ Signals a set of external semaphore objects.

    Enqueues a signal operation on a set of externally allocated semaphore
    object in the specified stream. The operations will be executed when
    all prior operations in the stream complete.

    The exact semantics of signaling a semaphore depends on the type of the
    object.

    If the semaphore object is any one of the following types:
    :py:obj:`~.cudaExternalSemaphoreHandleTypeOpaqueFd`,
    :py:obj:`~.cudaExternalSemaphoreHandleTypeOpaqueWin32`,
    :py:obj:`~.cudaExternalSemaphoreHandleTypeOpaqueWin32Kmt` then
    signaling the semaphore will set it to the signaled state.

    If the semaphore object is any one of the following types:
    :py:obj:`~.cudaExternalSemaphoreHandleTypeD3D12Fence`,
    :py:obj:`~.cudaExternalSemaphoreHandleTypeD3D11Fence`,
    :py:obj:`~.cudaExternalSemaphoreHandleTypeTimelineSemaphoreFd`,
    :py:obj:`~.cudaExternalSemaphoreHandleTypeTimelineSemaphoreWin32` then
    the semaphore will be set to the value specified in
    :py:obj:`~.cudaExternalSemaphoreSignalParams`::params::fence::value.

    If the semaphore object is of the type
    :py:obj:`~.cudaExternalSemaphoreHandleTypeNvSciSync` this API sets
    :py:obj:`~.cudaExternalSemaphoreSignalParams`::params::nvSciSync::fence
    to a value that can be used by subsequent waiters of the same NvSciSync
    object to order operations with those currently submitted in `stream`.
    Such an update will overwrite previous contents of
    :py:obj:`~.cudaExternalSemaphoreSignalParams`::params::nvSciSync::fence.
    By default, signaling such an external semaphore object causes
    appropriate memory synchronization operations to be performed over all
    the external memory objects that are imported as
    :py:obj:`~.cudaExternalMemoryHandleTypeNvSciBuf`. This ensures that any
    subsequent accesses made by other importers of the same set of NvSciBuf
    memory object(s) are coherent. These operations can be skipped by
    specifying the flag
    :py:obj:`~.cudaExternalSemaphoreSignalSkipNvSciBufMemSync`, which can
    be used as a performance optimization when data coherency is not
    required. But specifying this flag in scenarios where data coherency is
    required results in undefined behavior. Also, for semaphore object of
    the type :py:obj:`~.cudaExternalSemaphoreHandleTypeNvSciSync`, if the
    NvSciSyncAttrList used to create the NvSciSyncObj had not set the flags
    in :py:obj:`~.cudaDeviceGetNvSciSyncAttributes` to
    cudaNvSciSyncAttrSignal, this API will return cudaErrorNotSupported.

    :py:obj:`~.cudaExternalSemaphoreSignalParams`::params::nvSciSync::fence
    associated with semaphore object of the type
    :py:obj:`~.cudaExternalSemaphoreHandleTypeNvSciSync` can be
    deterministic. For this the NvSciSyncAttrList used to create the
    semaphore object must have value of
    NvSciSyncAttrKey_RequireDeterministicFences key set to true.
    Deterministic fences allow users to enqueue a wait over the semaphore
    object even before corresponding signal is enqueued. For such a
    semaphore object, CUDA guarantees that each signal operation will
    increment the fence value by '1'. Users are expected to track count of
    signals enqueued on the semaphore object and insert waits accordingly.
    When such a semaphore object is signaled from multiple streams, due to
    concurrent stream execution, it is possible that the order in which the
    semaphore gets signaled is indeterministic. This could lead to waiters
    of the semaphore getting unblocked incorrectly. Users are expected to
    handle such situations, either by not using the same semaphore object
    with deterministic fence support enabled in different streams or by
    adding explicit dependency amongst such streams so that the semaphore
    is signaled in order.
    :py:obj:`~.cudaExternalSemaphoreSignalParams`::params::nvSciSync::fence
    associated with semaphore object of the type
    :py:obj:`~.cudaExternalSemaphoreHandleTypeNvSciSync` can be timestamp
    enabled. For this the NvSciSyncAttrList used to create the object must
    have the value of NvSciSyncAttrKey_WaiterRequireTimestamps key set to
    true. Timestamps are emitted asynchronously by the GPU and CUDA saves
    the GPU timestamp in the corresponding NvSciSyncFence at the time of
    signal on GPU. Users are expected to convert GPU clocks to CPU clocks
    using appropriate scaling functions. Users are expected to wait for the
    completion of the fence before extracting timestamp using appropriate
    NvSciSync APIs. Users are expected to ensure that there is only one
    outstanding timestamp enabled fence per Cuda-NvSciSync object at any
    point of time, failing which leads to undefined behavior. Extracting
    the timestamp before the corresponding fence is signalled could lead to
    undefined behaviour. Timestamp extracted via appropriate NvSciSync API
    would be in microseconds.

    If the semaphore object is any one of the following types:
    :py:obj:`~.cudaExternalSemaphoreHandleTypeKeyedMutex`,
    :py:obj:`~.cudaExternalSemaphoreHandleTypeKeyedMutexKmt`, then the
    keyed mutex will be released with the key specified in
    :py:obj:`~.cudaExternalSemaphoreSignalParams`::params::keyedmutex::key.

    Parameters
    ----------
    extSemArray : list[:py:obj:`~.cudaExternalSemaphore_t`]
        Set of external semaphores to be signaled
    paramsArray : list[:py:obj:`~.cudaExternalSemaphoreSignalParams`]
        Array of semaphore parameters
    numExtSems : unsigned int
        Number of semaphores to signal
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream to enqueue the signal operations in

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidResourceHandle`

    See Also
    --------
    :py:obj:`~.cudaImportExternalSemaphore`, :py:obj:`~.cudaDestroyExternalSemaphore`, :py:obj:`~.cudaWaitExternalSemaphoresAsync`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    paramsArray = [] if paramsArray is None else paramsArray
    if not all(isinstance(_x, (cudaExternalSemaphoreSignalParams,)) for _x in paramsArray):
        raise TypeError("Argument 'paramsArray' is not instance of type (expected tuple[cyruntime.cudaExternalSemaphoreSignalParams,] or list[cyruntime.cudaExternalSemaphoreSignalParams,]")
    extSemArray = [] if extSemArray is None else extSemArray
    if not all(isinstance(_x, (cudaExternalSemaphore_t,)) for _x in extSemArray):
        raise TypeError("Argument 'extSemArray' is not instance of type (expected tuple[cyruntime.cudaExternalSemaphore_t,] or list[cyruntime.cudaExternalSemaphore_t,]")
    cdef cyruntime.cudaExternalSemaphore_t* cyextSemArray = NULL
    if len(extSemArray) > 1:
        cyextSemArray = <cyruntime.cudaExternalSemaphore_t*> calloc(len(extSemArray), sizeof(cyruntime.cudaExternalSemaphore_t))
        if cyextSemArray is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(extSemArray)) + 'x' + str(sizeof(cyruntime.cudaExternalSemaphore_t)))
        else:
            for idx in range(len(extSemArray)):
                cyextSemArray[idx] = <cyruntime.cudaExternalSemaphore_t>(<cudaExternalSemaphore_t>extSemArray[idx])._pvt_ptr[0]
    elif len(extSemArray) == 1:
        cyextSemArray = <cyruntime.cudaExternalSemaphore_t*>(<cudaExternalSemaphore_t>extSemArray[0])._pvt_ptr
    cdef cyruntime.cudaExternalSemaphoreSignalParams* cyparamsArray = NULL
    if len(paramsArray) > 1:
        cyparamsArray = <cyruntime.cudaExternalSemaphoreSignalParams*> calloc(len(paramsArray), sizeof(cyruntime.cudaExternalSemaphoreSignalParams))
        if cyparamsArray is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(paramsArray)) + 'x' + str(sizeof(cyruntime.cudaExternalSemaphoreSignalParams)))
        for idx in range(len(paramsArray)):
            string.memcpy(&cyparamsArray[idx], (<cudaExternalSemaphoreSignalParams>paramsArray[idx])._pvt_ptr, sizeof(cyruntime.cudaExternalSemaphoreSignalParams))
    elif len(paramsArray) == 1:
        cyparamsArray = (<cudaExternalSemaphoreSignalParams>paramsArray[0])._pvt_ptr
    if numExtSems > len(extSemArray): raise RuntimeError("List is too small: " + str(len(extSemArray)) + " < " + str(numExtSems))
    if numExtSems > len(paramsArray): raise RuntimeError("List is too small: " + str(len(paramsArray)) + " < " + str(numExtSems))
    with nogil:
        err = cyruntime.cudaSignalExternalSemaphoresAsync(cyextSemArray, cyparamsArray, numExtSems, cystream)
    if len(extSemArray) > 1 and cyextSemArray is not NULL:
        free(cyextSemArray)
    if len(paramsArray) > 1 and cyparamsArray is not NULL:
        free(cyparamsArray)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaWaitExternalSemaphoresAsync(extSemArray : Optional[tuple[cudaExternalSemaphore_t] | list[cudaExternalSemaphore_t]], paramsArray : Optional[tuple[cudaExternalSemaphoreWaitParams] | list[cudaExternalSemaphoreWaitParams]], unsigned int numExtSems, stream):
    """ Waits on a set of external semaphore objects.

    Enqueues a wait operation on a set of externally allocated semaphore
    object in the specified stream. The operations will be executed when
    all prior operations in the stream complete.

    The exact semantics of waiting on a semaphore depends on the type of
    the object.

    If the semaphore object is any one of the following types:
    :py:obj:`~.cudaExternalSemaphoreHandleTypeOpaqueFd`,
    :py:obj:`~.cudaExternalSemaphoreHandleTypeOpaqueWin32`,
    :py:obj:`~.cudaExternalSemaphoreHandleTypeOpaqueWin32Kmt` then waiting
    on the semaphore will wait until the semaphore reaches the signaled
    state. The semaphore will then be reset to the unsignaled state.
    Therefore for every signal operation, there can only be one wait
    operation.

    If the semaphore object is any one of the following types:
    :py:obj:`~.cudaExternalSemaphoreHandleTypeD3D12Fence`,
    :py:obj:`~.cudaExternalSemaphoreHandleTypeD3D11Fence`,
    :py:obj:`~.cudaExternalSemaphoreHandleTypeTimelineSemaphoreFd`,
    :py:obj:`~.cudaExternalSemaphoreHandleTypeTimelineSemaphoreWin32` then
    waiting on the semaphore will wait until the value of the semaphore is
    greater than or equal to
    :py:obj:`~.cudaExternalSemaphoreWaitParams`::params::fence::value.

    If the semaphore object is of the type
    :py:obj:`~.cudaExternalSemaphoreHandleTypeNvSciSync` then, waiting on
    the semaphore will wait until the
    :py:obj:`~.cudaExternalSemaphoreSignalParams`::params::nvSciSync::fence
    is signaled by the signaler of the NvSciSyncObj that was associated
    with this semaphore object. By default, waiting on such an external
    semaphore object causes appropriate memory synchronization operations
    to be performed over all external memory objects that are imported as
    :py:obj:`~.cudaExternalMemoryHandleTypeNvSciBuf`. This ensures that any
    subsequent accesses made by other importers of the same set of NvSciBuf
    memory object(s) are coherent. These operations can be skipped by
    specifying the flag
    :py:obj:`~.cudaExternalSemaphoreWaitSkipNvSciBufMemSync`, which can be
    used as a performance optimization when data coherency is not required.
    But specifying this flag in scenarios where data coherency is required
    results in undefined behavior. Also, for semaphore object of the type
    :py:obj:`~.cudaExternalSemaphoreHandleTypeNvSciSync`, if the
    NvSciSyncAttrList used to create the NvSciSyncObj had not set the flags
    in :py:obj:`~.cudaDeviceGetNvSciSyncAttributes` to
    cudaNvSciSyncAttrWait, this API will return cudaErrorNotSupported.

    If the semaphore object is any one of the following types:
    :py:obj:`~.cudaExternalSemaphoreHandleTypeKeyedMutex`,
    :py:obj:`~.cudaExternalSemaphoreHandleTypeKeyedMutexKmt`, then the
    keyed mutex will be acquired when it is released with the key specified
    in
    :py:obj:`~.cudaExternalSemaphoreSignalParams`::params::keyedmutex::key
    or until the timeout specified by
    :py:obj:`~.cudaExternalSemaphoreSignalParams`::params::keyedmutex::timeoutMs
    has lapsed. The timeout interval can either be a finite value specified
    in milliseconds or an infinite value. In case an infinite value is
    specified the timeout never elapses. The windows INFINITE macro must be
    used to specify infinite timeout

    Parameters
    ----------
    extSemArray : list[:py:obj:`~.cudaExternalSemaphore_t`]
        External semaphores to be waited on
    paramsArray : list[:py:obj:`~.cudaExternalSemaphoreWaitParams`]
        Array of semaphore parameters
    numExtSems : unsigned int
        Number of semaphores to wait on
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream to enqueue the wait operations in

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidResourceHandle` :py:obj:`~.cudaErrorTimeout`

    See Also
    --------
    :py:obj:`~.cudaImportExternalSemaphore`, :py:obj:`~.cudaDestroyExternalSemaphore`, :py:obj:`~.cudaSignalExternalSemaphoresAsync`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    paramsArray = [] if paramsArray is None else paramsArray
    if not all(isinstance(_x, (cudaExternalSemaphoreWaitParams,)) for _x in paramsArray):
        raise TypeError("Argument 'paramsArray' is not instance of type (expected tuple[cyruntime.cudaExternalSemaphoreWaitParams,] or list[cyruntime.cudaExternalSemaphoreWaitParams,]")
    extSemArray = [] if extSemArray is None else extSemArray
    if not all(isinstance(_x, (cudaExternalSemaphore_t,)) for _x in extSemArray):
        raise TypeError("Argument 'extSemArray' is not instance of type (expected tuple[cyruntime.cudaExternalSemaphore_t,] or list[cyruntime.cudaExternalSemaphore_t,]")
    cdef cyruntime.cudaExternalSemaphore_t* cyextSemArray = NULL
    if len(extSemArray) > 1:
        cyextSemArray = <cyruntime.cudaExternalSemaphore_t*> calloc(len(extSemArray), sizeof(cyruntime.cudaExternalSemaphore_t))
        if cyextSemArray is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(extSemArray)) + 'x' + str(sizeof(cyruntime.cudaExternalSemaphore_t)))
        else:
            for idx in range(len(extSemArray)):
                cyextSemArray[idx] = <cyruntime.cudaExternalSemaphore_t>(<cudaExternalSemaphore_t>extSemArray[idx])._pvt_ptr[0]
    elif len(extSemArray) == 1:
        cyextSemArray = <cyruntime.cudaExternalSemaphore_t*>(<cudaExternalSemaphore_t>extSemArray[0])._pvt_ptr
    cdef cyruntime.cudaExternalSemaphoreWaitParams* cyparamsArray = NULL
    if len(paramsArray) > 1:
        cyparamsArray = <cyruntime.cudaExternalSemaphoreWaitParams*> calloc(len(paramsArray), sizeof(cyruntime.cudaExternalSemaphoreWaitParams))
        if cyparamsArray is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(paramsArray)) + 'x' + str(sizeof(cyruntime.cudaExternalSemaphoreWaitParams)))
        for idx in range(len(paramsArray)):
            string.memcpy(&cyparamsArray[idx], (<cudaExternalSemaphoreWaitParams>paramsArray[idx])._pvt_ptr, sizeof(cyruntime.cudaExternalSemaphoreWaitParams))
    elif len(paramsArray) == 1:
        cyparamsArray = (<cudaExternalSemaphoreWaitParams>paramsArray[0])._pvt_ptr
    if numExtSems > len(extSemArray): raise RuntimeError("List is too small: " + str(len(extSemArray)) + " < " + str(numExtSems))
    if numExtSems > len(paramsArray): raise RuntimeError("List is too small: " + str(len(paramsArray)) + " < " + str(numExtSems))
    with nogil:
        err = cyruntime.cudaWaitExternalSemaphoresAsync(cyextSemArray, cyparamsArray, numExtSems, cystream)
    if len(extSemArray) > 1 and cyextSemArray is not NULL:
        free(cyextSemArray)
    if len(paramsArray) > 1 and cyparamsArray is not NULL:
        free(cyparamsArray)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaDestroyExternalSemaphore(extSem):
    """ Destroys an external semaphore.

    Destroys an external semaphore object and releases any references to
    the underlying resource. Any outstanding signals or waits must have
    completed before the semaphore is destroyed.

    Parameters
    ----------
    extSem : :py:obj:`~.cudaExternalSemaphore_t`
        External semaphore to be destroyed

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidResourceHandle`

    See Also
    --------
    :py:obj:`~.cudaImportExternalSemaphore`, :py:obj:`~.cudaSignalExternalSemaphoresAsync`, :py:obj:`~.cudaWaitExternalSemaphoresAsync`
    """
    cdef cyruntime.cudaExternalSemaphore_t cyextSem
    if extSem is None:
        pextSem = 0
    elif isinstance(extSem, (cudaExternalSemaphore_t,)):
        pextSem = int(extSem)
    else:
        pextSem = int(cudaExternalSemaphore_t(extSem))
    cyextSem = <cyruntime.cudaExternalSemaphore_t><void_ptr>pextSem
    with nogil:
        err = cyruntime.cudaDestroyExternalSemaphore(cyextSem)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaFuncSetCacheConfig(func, cacheConfig not None : cudaFuncCache):
    """ Sets the preferred cache configuration for a device function.

    On devices where the L1 cache and shared memory use the same hardware
    resources, this sets through `cacheConfig` the preferred cache
    configuration for the function specified via `func`. This is only a
    preference. The runtime will use the requested configuration if
    possible, but it is free to choose a different configuration if
    required to execute `func`.

    `func` is a device function symbol and must be declared as a `None`
    function. If the specified function does not exist, then
    :py:obj:`~.cudaErrorInvalidDeviceFunction` is returned. For templated
    functions, pass the function symbol as follows:
    func_name<template_arg_0,...,template_arg_N>

    This setting does nothing on devices where the size of the L1 cache and
    shared memory are fixed.

    Launching a kernel with a different preference than the most recent
    preference setting may insert a device-side synchronization point.

    The supported cache configurations are:

    - :py:obj:`~.cudaFuncCachePreferNone`: no preference for shared memory
      or L1 (default)

    - :py:obj:`~.cudaFuncCachePreferShared`: prefer larger shared memory
      and smaller L1 cache

    - :py:obj:`~.cudaFuncCachePreferL1`: prefer larger L1 cache and smaller
      shared memory

    - :py:obj:`~.cudaFuncCachePreferEqual`: prefer equal size L1 cache and
      shared memory

    Parameters
    ----------
    func : Any
        Device function symbol
    cacheConfig : :py:obj:`~.cudaFuncCache`
        Requested cache configuration

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDeviceFunction`2

    See Also
    --------
    cudaFuncSetCacheConfig (C++ API), :py:obj:`~.cudaFuncGetAttributes (C API)`, :py:obj:`~.cudaLaunchKernel (C API)`, :py:obj:`~.cuFuncSetCacheConfig`

    Notes
    -----
    This API does not accept a :py:obj:`~.cudaKernel_t` casted as void*. If cache config modification is required for a :py:obj:`~.cudaKernel_t` (or a global function), it can be replaced with a call to :py:obj:`~.cudaFuncSetAttributes` with the attribute :py:obj:`~.cudaFuncAttributePreferredSharedMemoryCarveout` to specify a more granular L1 cache and shared memory split configuration.
    """
    cyfunc = _HelperInputVoidPtr(func)
    cdef void* cyfunc_ptr = <void*><void_ptr>cyfunc.cptr
    cdef cyruntime.cudaFuncCache cycacheConfig = cacheConfig.value
    with nogil:
        err = cyruntime.cudaFuncSetCacheConfig(cyfunc_ptr, cycacheConfig)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaFuncGetAttributes(func):
    """ Find out attributes for a given function.

    This function obtains the attributes of a function specified via
    `func`. `func` is a device function symbol and must be declared as a
    `None` function. The fetched attributes are placed in `attr`. If the
    specified function does not exist, then it is assumed to be a
    :py:obj:`~.cudaKernel_t` and used as is. For templated functions, pass
    the function symbol as follows:
    func_name<template_arg_0,...,template_arg_N>

    Note that some function attributes such as
    :py:obj:`~.maxThreadsPerBlock` may vary based on the device that is
    currently being used.

    Parameters
    ----------
    func : Any
        Device function symbol

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDeviceFunction`2
    attr : :py:obj:`~.cudaFuncAttributes`
        Return pointer to function's attributes

    See Also
    --------
    :py:obj:`~.cudaFuncSetCacheConfig (C API)`, cudaFuncGetAttributes (C++ API), :py:obj:`~.cudaLaunchKernel (C API)`, :py:obj:`~.cuFuncGetAttribute`
    """
    cdef cudaFuncAttributes attr = cudaFuncAttributes()
    cyfunc = _HelperInputVoidPtr(func)
    cdef void* cyfunc_ptr = <void*><void_ptr>cyfunc.cptr
    with nogil:
        err = cyruntime.cudaFuncGetAttributes(<cyruntime.cudaFuncAttributes*>attr._pvt_ptr, cyfunc_ptr)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], attr)

@cython.embedsignature(True)
def cudaFuncSetAttribute(func, attr not None : cudaFuncAttribute, int value):
    """ Set attributes for a given function.

    This function sets the attributes of a function specified via `func`.
    The parameter `func` must be a pointer to a function that executes on
    the device. The parameter specified by `func` must be declared as a
    `None` function. The enumeration defined by `attr` is set to the value
    defined by `value`. If the specified function does not exist, then it
    is assumed to be a :py:obj:`~.cudaKernel_t` and used as is. If the
    specified attribute cannot be written, or if the value is incorrect,
    then :py:obj:`~.cudaErrorInvalidValue` is returned.

    Valid values for `attr` are:

    - :py:obj:`~.cudaFuncAttributeMaxDynamicSharedMemorySize` - The
      requested maximum size in bytes of dynamically-allocated shared
      memory. The sum of this value and the function attribute
      :py:obj:`~.sharedSizeBytes` cannot exceed the device attribute
      :py:obj:`~.cudaDevAttrMaxSharedMemoryPerBlockOptin`. The maximal size
      of requestable dynamic shared memory may differ by GPU architecture.

    - :py:obj:`~.cudaFuncAttributePreferredSharedMemoryCarveout` - On
      devices where the L1 cache and shared memory use the same hardware
      resources, this sets the shared memory carveout preference, in
      percent of the total shared memory. See
      :py:obj:`~.cudaDevAttrMaxSharedMemoryPerMultiprocessor`. This is only
      a hint, and the driver can choose a different ratio if required to
      execute the function.

    - :py:obj:`~.cudaFuncAttributeRequiredClusterWidth`: The required
      cluster width in blocks. The width, height, and depth values must
      either all be 0 or all be positive. The validity of the cluster
      dimensions is checked at launch time. If the value is set during
      compile time, it cannot be set at runtime. Setting it at runtime will
      return cudaErrorNotPermitted.

    - :py:obj:`~.cudaFuncAttributeRequiredClusterHeight`: The required
      cluster height in blocks. The width, height, and depth values must
      either all be 0 or all be positive. The validity of the cluster
      dimensions is checked at launch time. If the value is set during
      compile time, it cannot be set at runtime. Setting it at runtime will
      return cudaErrorNotPermitted.

    - :py:obj:`~.cudaFuncAttributeRequiredClusterDepth`: The required
      cluster depth in blocks. The width, height, and depth values must
      either all be 0 or all be positive. The validity of the cluster
      dimensions is checked at launch time. If the value is set during
      compile time, it cannot be set at runtime. Setting it at runtime will
      return cudaErrorNotPermitted.

    - :py:obj:`~.cudaFuncAttributeNonPortableClusterSizeAllowed`: Indicates
      whether the function can be launched with non-portable cluster size.
      1 is allowed, 0 is disallowed.

    - :py:obj:`~.cudaFuncAttributeClusterSchedulingPolicyPreference`: The
      block scheduling policy of a function. The value type is
      cudaClusterSchedulingPolicy.

    cudaLaunchKernel (C++ API), cudaFuncSetCacheConfig (C++ API),
    :py:obj:`~.cudaFuncGetAttributes (C API)`,

    Parameters
    ----------
    func : Any
        Function to get attributes of
    attr : :py:obj:`~.cudaFuncAttribute`
        Attribute to set
    value : int
        Value to set

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDeviceFunction`, :py:obj:`~.cudaErrorInvalidValue`
    """
    cyfunc = _HelperInputVoidPtr(func)
    cdef void* cyfunc_ptr = <void*><void_ptr>cyfunc.cptr
    cdef cyruntime.cudaFuncAttribute cyattr = attr.value
    with nogil:
        err = cyruntime.cudaFuncSetAttribute(cyfunc_ptr, cyattr, value)
    return (_dict_cudaError_t[err],)

ctypedef struct cudaStreamHostCallbackData_st:
    cyruntime.cudaHostFn_t callback
    void *userData

ctypedef cudaStreamHostCallbackData_st cudaStreamHostCallbackData

@cython.show_performance_hints(False)
cdef void cudaStreamRtHostCallbackWrapper(void *data) nogil:
    cdef cudaStreamHostCallbackData *cbData = <cudaStreamHostCallbackData *>data
    with gil:
        cbData.callback(cbData.userData)
    free(cbData)

@cython.embedsignature(True)
def cudaLaunchHostFunc(stream, fn, userData):
    """ Enqueues a host function call in a stream.

    Enqueues a host function to run in a stream. The function will be
    called after currently enqueued work and will block work added after
    it.

    The host function must not make any CUDA API calls. Attempting to use a
    CUDA API may result in :py:obj:`~.cudaErrorNotPermitted`, but this is
    not required. The host function must not perform any synchronization
    that may depend on outstanding CUDA work not mandated to run earlier.
    Host functions without a mandated order (such as in independent
    streams) execute in undefined order and may be serialized.

    For the purposes of Unified Memory, execution makes a number of
    guarantees:

    - The stream is considered idle for the duration of the function's
      execution. Thus, for example, the function may always use memory
      attached to the stream it was enqueued in.

    - The start of execution of the function has the same effect as
      synchronizing an event recorded in the same stream immediately prior
      to the function. It thus synchronizes streams which have been
      "joined" prior to the function.

    - Adding device work to any stream does not have the effect of making
      the stream active until all preceding host functions and stream
      callbacks have executed. Thus, for example, a function might use
      global attached memory even if work has been added to another stream,
      if the work has been ordered behind the function call with an event.

    - Completion of the function does not cause a stream to become active
      except as described above. The stream will remain idle if no device
      work follows the function, and will remain idle across consecutive
      host functions or stream callbacks without device work in between.
      Thus, for example, stream synchronization can be done by signaling
      from a host function at the end of the stream.

    Note that, in constrast to :py:obj:`~.cuStreamAddCallback`, the
    function will not be called in the event of an error in the CUDA
    context.

    Parameters
    ----------
    hStream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream to enqueue function call in
    fn : :py:obj:`~.cudaHostFn_t`
        The function to call once preceding stream operations are complete
    userData : Any
        User-specified data to be passed to the function

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidResourceHandle`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorNotSupported`

    See Also
    --------
    :py:obj:`~.cudaStreamCreate`, :py:obj:`~.cudaStreamQuery`, :py:obj:`~.cudaStreamSynchronize`, :py:obj:`~.cudaStreamWaitEvent`, :py:obj:`~.cudaStreamDestroy`, :py:obj:`~.cudaMallocManaged`, :py:obj:`~.cudaStreamAttachMemAsync`, :py:obj:`~.cudaStreamAddCallback`, :py:obj:`~.cuLaunchHostFunc`
    """
    cdef cyruntime.cudaHostFn_t cyfn
    if fn is None:
        pfn = 0
    elif isinstance(fn, (cudaHostFn_t,)):
        pfn = int(fn)
    else:
        pfn = int(cudaHostFn_t(fn))
    cyfn = <cyruntime.cudaHostFn_t><void_ptr>pfn
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cyuserData = _HelperInputVoidPtr(userData)
    cdef void* cyuserData_ptr = <void*><void_ptr>cyuserData.cptr

    cdef cudaStreamHostCallbackData *cbData = NULL
    cbData = <cudaStreamHostCallbackData *>malloc(sizeof(cbData[0]))
    if cbData == NULL:
        return (cudaError_t.cudaErrorMemoryAllocation,)
    cbData.callback = cyfn
    cbData.userData = cyuserData_ptr

    with nogil:
        err = cyruntime.cudaLaunchHostFunc(cystream, <cyruntime.cudaHostFn_t>cudaStreamRtHostCallbackWrapper, <void *>cbData)
    if err != cyruntime.cudaSuccess:
        free(cbData)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaFuncSetSharedMemConfig(func, config not None : cudaSharedMemConfig):
    """ Sets the shared memory configuration for a device function.

    [Deprecated]

    On devices with configurable shared memory banks, this function will
    force all subsequent launches of the specified device function to have
    the given shared memory bank size configuration. On any given launch of
    the function, the shared memory configuration of the device will be
    temporarily changed if needed to suit the function's preferred
    configuration. Changes in shared memory configuration between
    subsequent launches of functions, may introduce a device side
    synchronization point.

    Any per-function setting of shared memory bank size set via
    :py:obj:`~.cudaFuncSetSharedMemConfig` will override the device wide
    setting set by :py:obj:`~.cudaDeviceSetSharedMemConfig`.

    Changing the shared memory bank size will not increase shared memory
    usage or affect occupancy of kernels, but may have major effects on
    performance. Larger bank sizes will allow for greater potential
    bandwidth to shared memory, but will change what kinds of accesses to
    shared memory will result in bank conflicts.

    This function will do nothing on devices with fixed shared memory bank
    size.

    For templated functions, pass the function symbol as follows:
    func_name<template_arg_0,...,template_arg_N>

    The supported bank configurations are:

    - :py:obj:`~.cudaSharedMemBankSizeDefault`: use the device's shared
      memory configuration when launching this function.

    - :py:obj:`~.cudaSharedMemBankSizeFourByte`: set shared memory bank
      width to be four bytes natively when launching this function.

    - :py:obj:`~.cudaSharedMemBankSizeEightByte`: set shared memory bank
      width to be eight bytes natively when launching this function.

    Parameters
    ----------
    func : Any
        Device function symbol
    config : :py:obj:`~.cudaSharedMemConfig`
        Requested shared memory configuration

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDeviceFunction`, :py:obj:`~.cudaErrorInvalidValue`,2

    See Also
    --------
    :py:obj:`~.cudaDeviceSetSharedMemConfig`, :py:obj:`~.cudaDeviceGetSharedMemConfig`, :py:obj:`~.cudaDeviceSetCacheConfig`, :py:obj:`~.cudaDeviceGetCacheConfig`, :py:obj:`~.cudaFuncSetCacheConfig`, :py:obj:`~.cuFuncSetSharedMemConfig`
    """
    cyfunc = _HelperInputVoidPtr(func)
    cdef void* cyfunc_ptr = <void*><void_ptr>cyfunc.cptr
    cdef cyruntime.cudaSharedMemConfig cyconfig = config.value
    with nogil:
        err = cyruntime.cudaFuncSetSharedMemConfig(cyfunc_ptr, cyconfig)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaOccupancyMaxActiveBlocksPerMultiprocessor(func, int blockSize, size_t dynamicSMemSize):
    """ Returns occupancy for a device function.

    Returns in `*numBlocks` the maximum number of active blocks per
    streaming multiprocessor for the device function.

    Parameters
    ----------
    func : Any
        Kernel function for which occupancy is calculated
    blockSize : int
        Block size the kernel is intended to be launched with
    dynamicSMemSize : size_t
        Per-block dynamic shared memory usage intended, in bytes

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorInvalidDeviceFunction`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorUnknown`,
    numBlocks : int
        Returned occupancy

    See Also
    --------
    :py:obj:`~.cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags`, cudaOccupancyMaxPotentialBlockSize (C++ API), cudaOccupancyMaxPotentialBlockSizeWithFlags (C++ API), cudaOccupancyMaxPotentialBlockSizeVariableSMem (C++ API), cudaOccupancyMaxPotentialBlockSizeVariableSMemWithFlags (C++ API), cudaOccupancyAvailableDynamicSMemPerBlock (C++ API), :py:obj:`~.cuOccupancyMaxActiveBlocksPerMultiprocessor`
    """
    cdef int numBlocks = 0
    cyfunc = _HelperInputVoidPtr(func)
    cdef void* cyfunc_ptr = <void*><void_ptr>cyfunc.cptr
    with nogil:
        err = cyruntime.cudaOccupancyMaxActiveBlocksPerMultiprocessor(&numBlocks, cyfunc_ptr, blockSize, dynamicSMemSize)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], numBlocks)

@cython.embedsignature(True)
def cudaOccupancyAvailableDynamicSMemPerBlock(func, int numBlocks, int blockSize):
    """ Returns dynamic shared memory available per block when launching `numBlocks` blocks on SM.

    Returns in `*dynamicSmemSize` the maximum size of dynamic shared memory
    to allow `numBlocks` blocks per SM.

    Parameters
    ----------
    func : Any
        Kernel function for which occupancy is calculated
    numBlocks : int
        Number of blocks to fit on SM
    blockSize : int
        Size of the block

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorInvalidDeviceFunction`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorUnknown`,
    dynamicSmemSize : int
        Returned maximum dynamic shared memory

    See Also
    --------
    :py:obj:`~.cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags`, cudaOccupancyMaxPotentialBlockSize (C++ API), cudaOccupancyMaxPotentialBlockSizeWithFlags (C++ API), cudaOccupancyMaxPotentialBlockSizeVariableSMem (C++ API), cudaOccupancyMaxPotentialBlockSizeVariableSMemWithFlags (C++ API), :py:obj:`~.cudaOccupancyAvailableDynamicSMemPerBlock`
    """
    cdef size_t dynamicSmemSize = 0
    cyfunc = _HelperInputVoidPtr(func)
    cdef void* cyfunc_ptr = <void*><void_ptr>cyfunc.cptr
    with nogil:
        err = cyruntime.cudaOccupancyAvailableDynamicSMemPerBlock(&dynamicSmemSize, cyfunc_ptr, numBlocks, blockSize)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], dynamicSmemSize)

@cython.embedsignature(True)
def cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags(func, int blockSize, size_t dynamicSMemSize, unsigned int flags):
    """ Returns occupancy for a device function with the specified flags.

    Returns in `*numBlocks` the maximum number of active blocks per
    streaming multiprocessor for the device function.

    The `flags` parameter controls how special cases are handled. Valid
    flags include:

    - :py:obj:`~.cudaOccupancyDefault`: keeps the default behavior as
      :py:obj:`~.cudaOccupancyMaxActiveBlocksPerMultiprocessor`

    - :py:obj:`~.cudaOccupancyDisableCachingOverride`: This flag suppresses
      the default behavior on platform where global caching affects
      occupancy. On such platforms, if caching is enabled, but per-block SM
      resource usage would result in zero occupancy, the occupancy
      calculator will calculate the occupancy as if caching is disabled.
      Setting this flag makes the occupancy calculator to return 0 in such
      cases. More information can be found about this feature in the
      "Unified L1/Texture Cache" section of the Maxwell tuning guide.

    Parameters
    ----------
    func : Any
        Kernel function for which occupancy is calculated
    blockSize : int
        Block size the kernel is intended to be launched with
    dynamicSMemSize : size_t
        Per-block dynamic shared memory usage intended, in bytes
    flags : unsigned int
        Requested behavior for the occupancy calculator

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorInvalidDeviceFunction`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorUnknown`,
    numBlocks : int
        Returned occupancy

    See Also
    --------
    :py:obj:`~.cudaOccupancyMaxActiveBlocksPerMultiprocessor`, cudaOccupancyMaxPotentialBlockSize (C++ API), cudaOccupancyMaxPotentialBlockSizeWithFlags (C++ API), cudaOccupancyMaxPotentialBlockSizeVariableSMem (C++ API), cudaOccupancyMaxPotentialBlockSizeVariableSMemWithFlags (C++ API), cudaOccupancyAvailableDynamicSMemPerBlock (C++ API), :py:obj:`~.cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags`
    """
    cdef int numBlocks = 0
    cyfunc = _HelperInputVoidPtr(func)
    cdef void* cyfunc_ptr = <void*><void_ptr>cyfunc.cptr
    with nogil:
        err = cyruntime.cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags(&numBlocks, cyfunc_ptr, blockSize, dynamicSMemSize, flags)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], numBlocks)

@cython.embedsignature(True)
def cudaMallocManaged(size_t size, unsigned int flags):
    """ Allocates memory that will be automatically managed by the Unified Memory system.

    Allocates `size` bytes of managed memory on the device and returns in
    `*devPtr` a pointer to the allocated memory. If the device doesn't
    support allocating managed memory, :py:obj:`~.cudaErrorNotSupported` is
    returned. Support for managed memory can be queried using the device
    attribute :py:obj:`~.cudaDevAttrManagedMemory`. The allocated memory is
    suitably aligned for any kind of variable. The memory is not cleared.
    If `size` is 0, :py:obj:`~.cudaMallocManaged` returns
    :py:obj:`~.cudaErrorInvalidValue`. The pointer is valid on the CPU and
    on all GPUs in the system that support managed memory. All accesses to
    this pointer must obey the Unified Memory programming model.

    `flags` specifies the default stream association for this allocation.
    `flags` must be one of :py:obj:`~.cudaMemAttachGlobal` or
    :py:obj:`~.cudaMemAttachHost`. The default value for `flags` is
    :py:obj:`~.cudaMemAttachGlobal`. If :py:obj:`~.cudaMemAttachGlobal` is
    specified, then this memory is accessible from any stream on any
    device. If :py:obj:`~.cudaMemAttachHost` is specified, then the
    allocation should not be accessed from devices that have a zero value
    for the device attribute
    :py:obj:`~.cudaDevAttrConcurrentManagedAccess`; an explicit call to
    :py:obj:`~.cudaStreamAttachMemAsync` will be required to enable access
    on such devices.

    If the association is later changed via
    :py:obj:`~.cudaStreamAttachMemAsync` to a single stream, the default
    association, as specifed during :py:obj:`~.cudaMallocManaged`, is
    restored when that stream is destroyed. For managed variables, the
    default association is always :py:obj:`~.cudaMemAttachGlobal`. Note
    that destroying a stream is an asynchronous operation, and as a result,
    the change to default association won't happen until all work in the
    stream has completed.

    Memory allocated with :py:obj:`~.cudaMallocManaged` should be released
    with :py:obj:`~.cudaFree`.

    Device memory oversubscription is possible for GPUs that have a non-
    zero value for the device attribute
    :py:obj:`~.cudaDevAttrConcurrentManagedAccess`. Managed memory on such
    GPUs may be evicted from device memory to host memory at any time by
    the Unified Memory driver in order to make room for other allocations.

    In a system where all GPUs have a non-zero value for the device
    attribute :py:obj:`~.cudaDevAttrConcurrentManagedAccess`, managed
    memory may not be populated when this API returns and instead may be
    populated on access. In such systems, managed memory can migrate to any
    processor's memory at any time. The Unified Memory driver will employ
    heuristics to maintain data locality and prevent excessive page faults
    to the extent possible. The application can also guide the driver about
    memory usage patterns via :py:obj:`~.cudaMemAdvise`. The application
    can also explicitly migrate memory to a desired processor's memory via
    :py:obj:`~.cudaMemPrefetchAsync`.

    In a multi-GPU system where all of the GPUs have a zero value for the
    device attribute :py:obj:`~.cudaDevAttrConcurrentManagedAccess` and all
    the GPUs have peer-to-peer support with each other, the physical
    storage for managed memory is created on the GPU which is active at the
    time :py:obj:`~.cudaMallocManaged` is called. All other GPUs will
    reference the data at reduced bandwidth via peer mappings over the PCIe
    bus. The Unified Memory driver does not migrate memory among such GPUs.

    In a multi-GPU system where not all GPUs have peer-to-peer support with
    each other and where the value of the device attribute
    :py:obj:`~.cudaDevAttrConcurrentManagedAccess` is zero for at least one
    of those GPUs, the location chosen for physical storage of managed
    memory is system-dependent.

    - On Linux, the location chosen will be device memory as long as the
      current set of active contexts are on devices that either have peer-
      to-peer support with each other or have a non-zero value for the
      device attribute :py:obj:`~.cudaDevAttrConcurrentManagedAccess`. If
      there is an active context on a GPU that does not have a non-zero
      value for that device attribute and it does not have peer-to-peer
      support with the other devices that have active contexts on them,
      then the location for physical storage will be 'zero-copy' or host
      memory. Note that this means that managed memory that is located in
      device memory is migrated to host memory if a new context is created
      on a GPU that doesn't have a non-zero value for the device attribute
      and does not support peer-to-peer with at least one of the other
      devices that has an active context. This in turn implies that context
      creation may fail if there is insufficient host memory to migrate all
      managed allocations.

    - On Windows, the physical storage is always created in 'zero-copy' or
      host memory. All GPUs will reference the data at reduced bandwidth
      over the PCIe bus. In these circumstances, use of the environment
      variable CUDA_VISIBLE_DEVICES is recommended to restrict CUDA to only
      use those GPUs that have peer-to-peer support. Alternatively, users
      can also set CUDA_MANAGED_FORCE_DEVICE_ALLOC to a non-zero value to
      force the driver to always use device memory for physical storage.
      When this environment variable is set to a non-zero value, all
      devices used in that process that support managed memory have to be
      peer-to-peer compatible with each other. The error
      :py:obj:`~.cudaErrorInvalidDevice` will be returned if a device that
      supports managed memory is used and it is not peer-to-peer compatible
      with any of the other managed memory supporting devices that were
      previously used in that process, even if :py:obj:`~.cudaDeviceReset`
      has been called on those devices. These environment variables are
      described in the CUDA programming guide under the "CUDA environment
      variables" section.

    Parameters
    ----------
    size : size_t
        Requested allocation size in bytes
    flags : unsigned int
        Must be either :py:obj:`~.cudaMemAttachGlobal` or
        :py:obj:`~.cudaMemAttachHost` (defaults to
        :py:obj:`~.cudaMemAttachGlobal`)

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorMemoryAllocation`, :py:obj:`~.cudaErrorNotSupported`, :py:obj:`~.cudaErrorInvalidValue`
    devPtr : Any
        Pointer to allocated device memory

    See Also
    --------
    :py:obj:`~.cudaMallocPitch`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaMallocArray`, :py:obj:`~.cudaFreeArray`, :py:obj:`~.cudaMalloc3D`, :py:obj:`~.cudaMalloc3DArray`, :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.cudaDeviceGetAttribute`, :py:obj:`~.cudaStreamAttachMemAsync`, :py:obj:`~.cuMemAllocManaged`
    """
    cdef void_ptr devPtr = 0
    with nogil:
        err = cyruntime.cudaMallocManaged(<void**>&devPtr, size, flags)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], devPtr)

@cython.embedsignature(True)
def cudaMalloc(size_t size):
    """ Allocate memory on the device.

    Allocates `size` bytes of linear memory on the device and returns in
    `*devPtr` a pointer to the allocated memory. The allocated memory is
    suitably aligned for any kind of variable. The memory is not cleared.
    :py:obj:`~.cudaMalloc()` returns :py:obj:`~.cudaErrorMemoryAllocation`
    in case of failure.

    The device version of :py:obj:`~.cudaFree` cannot be used with a
    `*devPtr` allocated using the host API, and vice versa.

    Parameters
    ----------
    size : size_t
        Requested allocation size in bytes

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorMemoryAllocation`
    devPtr : Any
        Pointer to allocated device memory

    See Also
    --------
    :py:obj:`~.cudaMallocPitch`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaMallocArray`, :py:obj:`~.cudaFreeArray`, :py:obj:`~.cudaMalloc3D`, :py:obj:`~.cudaMalloc3DArray`, :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.cuMemAlloc`
    """
    cdef void_ptr devPtr = 0
    with nogil:
        err = cyruntime.cudaMalloc(<void**>&devPtr, size)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], devPtr)

@cython.embedsignature(True)
def cudaMallocHost(size_t size):
    """ Allocates page-locked memory on the host.

    Allocates `size` bytes of host memory that is page-locked and
    accessible to the device. The driver tracks the virtual memory ranges
    allocated with this function and automatically accelerates calls to
    functions such as :py:obj:`~.cudaMemcpy`*(). Since the memory can be
    accessed directly by the device, it can be read or written with much
    higher bandwidth than pageable memory obtained with functions such as
    :py:obj:`~.malloc()`.

    On systems where :py:obj:`~.pageableMemoryAccessUsesHostPageTables` is
    true, :py:obj:`~.cudaMallocHost` may not page-lock the allocated
    memory.

    Page-locking excessive amounts of memory with
    :py:obj:`~.cudaMallocHost()` may degrade system performance, since it
    reduces the amount of memory available to the system for paging. As a
    result, this function is best used sparingly to allocate staging areas
    for data exchange between host and device.

    Parameters
    ----------
    size : size_t
        Requested allocation size in bytes

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorMemoryAllocation`
    ptr : Any
        Pointer to allocated host memory

    See Also
    --------
    :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaMallocPitch`, :py:obj:`~.cudaMallocArray`, :py:obj:`~.cudaMalloc3D`, :py:obj:`~.cudaMalloc3DArray`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaFreeArray`, cudaMallocHost (C++ API), :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.cuMemAllocHost`
    """
    cdef void_ptr ptr = 0
    with nogil:
        err = cyruntime.cudaMallocHost(<void**>&ptr, size)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], ptr)

@cython.embedsignature(True)
def cudaMallocPitch(size_t width, size_t height):
    """ Allocates pitched memory on the device.

    Allocates at least `width` (in bytes) * `height` bytes of linear memory
    on the device and returns in `*devPtr` a pointer to the allocated
    memory. The function may pad the allocation to ensure that
    corresponding pointers in any given row will continue to meet the
    alignment requirements for coalescing as the address is updated from
    row to row. The pitch returned in `*pitch` by
    :py:obj:`~.cudaMallocPitch()` is the width in bytes of the allocation.
    The intended usage of `pitch` is as a separate parameter of the
    allocation, used to compute addresses within the 2D array. Given the
    row and column of an array element of type `T`, the address is computed
    as:

    **View CUDA Toolkit Documentation for a C++ code example**

    For allocations of 2D arrays, it is recommended that programmers
    consider performing pitch allocations using
    :py:obj:`~.cudaMallocPitch()`. Due to pitch alignment restrictions in
    the hardware, this is especially true if the application will be
    performing 2D memory copies between different regions of device memory
    (whether linear memory or CUDA arrays).

    Parameters
    ----------
    width : size_t
        Requested pitched allocation width (in bytes)
    height : size_t
        Requested pitched allocation height

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorMemoryAllocation`
    devPtr : Any
        Pointer to allocated pitched device memory
    pitch : int
        Pitch for allocation

    See Also
    --------
    :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaMallocArray`, :py:obj:`~.cudaFreeArray`, :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaMalloc3D`, :py:obj:`~.cudaMalloc3DArray`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.cuMemAllocPitch`
    """
    cdef void_ptr devPtr = 0
    cdef size_t pitch = 0
    with nogil:
        err = cyruntime.cudaMallocPitch(<void**>&devPtr, &pitch, width, height)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None, None)
    return (_dict_cudaError_t[err], devPtr, pitch)

@cython.embedsignature(True)
def cudaMallocArray(desc : Optional[cudaChannelFormatDesc], size_t width, size_t height, unsigned int flags):
    """ Allocate an array on the device.

    Allocates a CUDA array according to the
    :py:obj:`~.cudaChannelFormatDesc` structure `desc` and returns a handle
    to the new CUDA array in `*array`.

    The :py:obj:`~.cudaChannelFormatDesc` is defined as:

    **View CUDA Toolkit Documentation for a C++ code example**

    where :py:obj:`~.cudaChannelFormatKind` is one of
    :py:obj:`~.cudaChannelFormatKindSigned`,
    :py:obj:`~.cudaChannelFormatKindUnsigned`, or
    :py:obj:`~.cudaChannelFormatKindFloat`.

    The `flags` parameter enables different options to be specified that
    affect the allocation, as follows.

    - :py:obj:`~.cudaArrayDefault`: This flag's value is defined to be 0
      and provides default array allocation

    - :py:obj:`~.cudaArraySurfaceLoadStore`: Allocates an array that can be
      read from or written to using a surface reference

    - :py:obj:`~.cudaArrayTextureGather`: This flag indicates that texture
      gather operations will be performed on the array.

    - :py:obj:`~.cudaArraySparse`: Allocates a CUDA array without physical
      backing memory. The subregions within this sparse array can later be
      mapped onto a physical memory allocation by calling
      :py:obj:`~.cuMemMapArrayAsync`. The physical backing memory must be
      allocated via :py:obj:`~.cuMemCreate`.

    - :py:obj:`~.cudaArrayDeferredMapping`: Allocates a CUDA array without
      physical backing memory. The entire array can later be mapped onto a
      physical memory allocation by calling :py:obj:`~.cuMemMapArrayAsync`.
      The physical backing memory must be allocated via
      :py:obj:`~.cuMemCreate`.

    `width` and `height` must meet certain size requirements. See
    :py:obj:`~.cudaMalloc3DArray()` for more details.

    Parameters
    ----------
    desc : :py:obj:`~.cudaChannelFormatDesc`
        Requested channel format
    width : size_t
        Requested array allocation width
    height : size_t
        Requested array allocation height
    flags : unsigned int
        Requested properties of allocated array

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorMemoryAllocation`
    array : :py:obj:`~.cudaArray_t`
        Pointer to allocated array in device memory

    See Also
    --------
    :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaMallocPitch`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaFreeArray`, :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaMalloc3D`, :py:obj:`~.cudaMalloc3DArray`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.cuArrayCreate`
    """
    cdef cudaArray_t array = cudaArray_t()
    cdef cyruntime.cudaChannelFormatDesc* cydesc_ptr = desc._pvt_ptr if desc is not None else NULL
    with nogil:
        err = cyruntime.cudaMallocArray(<cyruntime.cudaArray_t*>array._pvt_ptr, cydesc_ptr, width, height, flags)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], array)

@cython.embedsignature(True)
def cudaFree(devPtr):
    """ Frees memory on the device.

    Frees the memory space pointed to by `devPtr`, which must have been
    returned by a previous call to one of the following memory allocation
    APIs - :py:obj:`~.cudaMalloc()`, :py:obj:`~.cudaMallocPitch()`,
    :py:obj:`~.cudaMallocManaged()`, :py:obj:`~.cudaMallocAsync()`,
    :py:obj:`~.cudaMallocFromPoolAsync()`.

    Note - This API will not perform any implicit synchronization when the
    pointer was allocated with :py:obj:`~.cudaMallocAsync` or
    :py:obj:`~.cudaMallocFromPoolAsync`. Callers must ensure that all
    accesses to these pointer have completed before invoking
    :py:obj:`~.cudaFree`. For best performance and memory reuse, users
    should use :py:obj:`~.cudaFreeAsync` to free memory allocated via the
    stream ordered memory allocator. For all other pointers, this API may
    perform implicit synchronization.

    If :py:obj:`~.cudaFree`(`devPtr`) has already been called before, an
    error is returned. If `devPtr` is 0, no operation is performed.
    :py:obj:`~.cudaFree()` returns :py:obj:`~.cudaErrorValue` in case of
    failure.

    The device version of :py:obj:`~.cudaFree` cannot be used with a
    `*devPtr` allocated using the host API, and vice versa.

    Parameters
    ----------
    devPtr : Any
        Device pointer to memory to free

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`

    See Also
    --------
    :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaMallocPitch`, :py:obj:`~.cudaMallocManaged`, :py:obj:`~.cudaMallocArray`, :py:obj:`~.cudaFreeArray`, :py:obj:`~.cudaMallocAsync`, :py:obj:`~.cudaMallocFromPoolAsync` :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaMalloc3D`, :py:obj:`~.cudaMalloc3DArray`, :py:obj:`~.cudaFreeAsync` :py:obj:`~.cudaHostAlloc`, :py:obj:`~.cuMemFree`
    """
    cydevPtr = _HelperInputVoidPtr(devPtr)
    cdef void* cydevPtr_ptr = <void*><void_ptr>cydevPtr.cptr
    with nogil:
        err = cyruntime.cudaFree(cydevPtr_ptr)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaFreeHost(ptr):
    """ Frees page-locked memory.

    Frees the memory space pointed to by `hostPtr`, which must have been
    returned by a previous call to :py:obj:`~.cudaMallocHost()` or
    :py:obj:`~.cudaHostAlloc()`.

    Parameters
    ----------
    ptr : Any
        Pointer to memory to free

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`

    See Also
    --------
    :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaMallocPitch`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaMallocArray`, :py:obj:`~.cudaFreeArray`, :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaMalloc3D`, :py:obj:`~.cudaMalloc3DArray`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.cuMemFreeHost`
    """
    cyptr = _HelperInputVoidPtr(ptr)
    cdef void* cyptr_ptr = <void*><void_ptr>cyptr.cptr
    with nogil:
        err = cyruntime.cudaFreeHost(cyptr_ptr)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaFreeArray(array):
    """ Frees an array on the device.

    Frees the CUDA array `array`, which must have been returned by a
    previous call to :py:obj:`~.cudaMallocArray()`. If `devPtr` is 0, no
    operation is performed.

    Parameters
    ----------
    array : :py:obj:`~.cudaArray_t`
        Pointer to array to free

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`

    See Also
    --------
    :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaMallocPitch`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaMallocArray`, :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.cuArrayDestroy`
    """
    cdef cyruntime.cudaArray_t cyarray
    if array is None:
        parray = 0
    elif isinstance(array, (cudaArray_t,)):
        parray = int(array)
    else:
        parray = int(cudaArray_t(array))
    cyarray = <cyruntime.cudaArray_t><void_ptr>parray
    with nogil:
        err = cyruntime.cudaFreeArray(cyarray)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaFreeMipmappedArray(mipmappedArray):
    """ Frees a mipmapped array on the device.

    Frees the CUDA mipmapped array `mipmappedArray`, which must have been
    returned by a previous call to :py:obj:`~.cudaMallocMipmappedArray()`.
    If `devPtr` is 0, no operation is performed.

    Parameters
    ----------
    mipmappedArray : :py:obj:`~.cudaMipmappedArray_t`
        Pointer to mipmapped array to free

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`

    See Also
    --------
    :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaMallocPitch`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaMallocArray`, :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.cuMipmappedArrayDestroy`
    """
    cdef cyruntime.cudaMipmappedArray_t cymipmappedArray
    if mipmappedArray is None:
        pmipmappedArray = 0
    elif isinstance(mipmappedArray, (cudaMipmappedArray_t,)):
        pmipmappedArray = int(mipmappedArray)
    else:
        pmipmappedArray = int(cudaMipmappedArray_t(mipmappedArray))
    cymipmappedArray = <cyruntime.cudaMipmappedArray_t><void_ptr>pmipmappedArray
    with nogil:
        err = cyruntime.cudaFreeMipmappedArray(cymipmappedArray)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaHostAlloc(size_t size, unsigned int flags):
    """ Allocates page-locked memory on the host.

    Allocates `size` bytes of host memory that is page-locked and
    accessible to the device. The driver tracks the virtual memory ranges
    allocated with this function and automatically accelerates calls to
    functions such as :py:obj:`~.cudaMemcpy()`. Since the memory can be
    accessed directly by the device, it can be read or written with much
    higher bandwidth than pageable memory obtained with functions such as
    :py:obj:`~.malloc()`. Allocating excessive amounts of pinned memory may
    degrade system performance, since it reduces the amount of memory
    available to the system for paging. As a result, this function is best
    used sparingly to allocate staging areas for data exchange between host
    and device.

    The `flags` parameter enables different options to be specified that
    affect the allocation, as follows.

    - :py:obj:`~.cudaHostAllocDefault`: This flag's value is defined to be
      0 and causes :py:obj:`~.cudaHostAlloc()` to emulate
      :py:obj:`~.cudaMallocHost()`.

    - :py:obj:`~.cudaHostAllocPortable`: The memory returned by this call
      will be considered as pinned memory by all CUDA contexts, not just
      the one that performed the allocation.

    - :py:obj:`~.cudaHostAllocMapped`: Maps the allocation into the CUDA
      address space. The device pointer to the memory may be obtained by
      calling :py:obj:`~.cudaHostGetDevicePointer()`.

    - :py:obj:`~.cudaHostAllocWriteCombined`: Allocates the memory as
      write-combined (WC). WC memory can be transferred across the PCI
      Express bus more quickly on some system configurations, but cannot be
      read efficiently by most CPUs. WC memory is a good option for buffers
      that will be written by the CPU and read by the device via mapped
      pinned memory or host->device transfers.

    All of these flags are orthogonal to one another: a developer may
    allocate memory that is portable, mapped and/or write-combined with no
    restrictions.

    In order for the :py:obj:`~.cudaHostAllocMapped` flag to have any
    effect, the CUDA context must support the :py:obj:`~.cudaDeviceMapHost`
    flag, which can be checked via :py:obj:`~.cudaGetDeviceFlags()`. The
    :py:obj:`~.cudaDeviceMapHost` flag is implicitly set for contexts
    created via the runtime API.

    The :py:obj:`~.cudaHostAllocMapped` flag may be specified on CUDA
    contexts for devices that do not support mapped pinned memory. The
    failure is deferred to :py:obj:`~.cudaHostGetDevicePointer()` because
    the memory may be mapped into other CUDA contexts via the
    :py:obj:`~.cudaHostAllocPortable` flag.

    Memory allocated by this function must be freed with
    :py:obj:`~.cudaFreeHost()`.

    Parameters
    ----------
    size : size_t
        Requested allocation size in bytes
    flags : unsigned int
        Requested properties of allocated memory

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorMemoryAllocation`
    pHost : Any
        Device pointer to allocated memory

    See Also
    --------
    :py:obj:`~.cudaSetDeviceFlags`, :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaGetDeviceFlags`, :py:obj:`~.cuMemHostAlloc`
    """
    cdef void_ptr pHost = 0
    with nogil:
        err = cyruntime.cudaHostAlloc(<void**>&pHost, size, flags)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pHost)

@cython.embedsignature(True)
def cudaHostRegister(ptr, size_t size, unsigned int flags):
    """ Registers an existing host memory range for use by CUDA.

    Page-locks the memory range specified by `ptr` and `size` and maps it
    for the device(s) as specified by `flags`. This memory range also is
    added to the same tracking mechanism as :py:obj:`~.cudaHostAlloc()` to
    automatically accelerate calls to functions such as
    :py:obj:`~.cudaMemcpy()`. Since the memory can be accessed directly by
    the device, it can be read or written with much higher bandwidth than
    pageable memory that has not been registered. Page-locking excessive
    amounts of memory may degrade system performance, since it reduces the
    amount of memory available to the system for paging. As a result, this
    function is best used sparingly to register staging areas for data
    exchange between host and device.

    On systems where :py:obj:`~.pageableMemoryAccessUsesHostPageTables` is
    true, :py:obj:`~.cudaHostRegister` will not page-lock the memory range
    specified by `ptr` but only populate unpopulated pages.

    :py:obj:`~.cudaHostRegister` is supported only on I/O coherent devices
    that have a non-zero value for the device attribute
    :py:obj:`~.cudaDevAttrHostRegisterSupported`.

    The `flags` parameter enables different options to be specified that
    affect the allocation, as follows.

    - :py:obj:`~.cudaHostRegisterDefault`: On a system with unified virtual
      addressing, the memory will be both mapped and portable. On a system
      with no unified virtual addressing, the memory will be neither mapped
      nor portable.

    - :py:obj:`~.cudaHostRegisterPortable`: The memory returned by this
      call will be considered as pinned memory by all CUDA contexts, not
      just the one that performed the allocation.

    - :py:obj:`~.cudaHostRegisterMapped`: Maps the allocation into the CUDA
      address space. The device pointer to the memory may be obtained by
      calling :py:obj:`~.cudaHostGetDevicePointer()`.

    - :py:obj:`~.cudaHostRegisterIoMemory`: The passed memory pointer is
      treated as pointing to some memory-mapped I/O space, e.g. belonging
      to a third-party PCIe device, and it will marked as non cache-
      coherent and contiguous.

    - :py:obj:`~.cudaHostRegisterReadOnly`: The passed memory pointer is
      treated as pointing to memory that is considered read-only by the
      device. On platforms without
      :py:obj:`~.cudaDevAttrPageableMemoryAccessUsesHostPageTables`, this
      flag is required in order to register memory mapped to the CPU as
      read-only. Support for the use of this flag can be queried from the
      device attribute
      :py:obj:`~.cudaDevAttrHostRegisterReadOnlySupported`. Using this flag
      with a current context associated with a device that does not have
      this attribute set will cause :py:obj:`~.cudaHostRegister` to error
      with cudaErrorNotSupported.

    All of these flags are orthogonal to one another: a developer may page-
    lock memory that is portable or mapped with no restrictions.

    The CUDA context must have been created with the
    :py:obj:`~.cudaMapHost` flag in order for the
    :py:obj:`~.cudaHostRegisterMapped` flag to have any effect.

    The :py:obj:`~.cudaHostRegisterMapped` flag may be specified on CUDA
    contexts for devices that do not support mapped pinned memory. The
    failure is deferred to :py:obj:`~.cudaHostGetDevicePointer()` because
    the memory may be mapped into other CUDA contexts via the
    :py:obj:`~.cudaHostRegisterPortable` flag.

    For devices that have a non-zero value for the device attribute
    :py:obj:`~.cudaDevAttrCanUseHostPointerForRegisteredMem`, the memory
    can also be accessed from the device using the host pointer `ptr`. The
    device pointer returned by :py:obj:`~.cudaHostGetDevicePointer()` may
    or may not match the original host pointer `ptr` and depends on the
    devices visible to the application. If all devices visible to the
    application have a non-zero value for the device attribute, the device
    pointer returned by :py:obj:`~.cudaHostGetDevicePointer()` will match
    the original pointer `ptr`. If any device visible to the application
    has a zero value for the device attribute, the device pointer returned
    by :py:obj:`~.cudaHostGetDevicePointer()` will not match the original
    host pointer `ptr`, but it will be suitable for use on all devices
    provided Unified Virtual Addressing is enabled. In such systems, it is
    valid to access the memory using either pointer on devices that have a
    non-zero value for the device attribute. Note however that such devices
    should access the memory using only of the two pointers and not both.

    The memory page-locked by this function must be unregistered with
    :py:obj:`~.cudaHostUnregister()`.

    Parameters
    ----------
    ptr : Any
        Host pointer to memory to page-lock
    size : size_t
        Size in bytes of the address range to page-lock in bytes
    flags : unsigned int
        Flags for allocation request

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorMemoryAllocation`, :py:obj:`~.cudaErrorHostMemoryAlreadyRegistered`, :py:obj:`~.cudaErrorNotSupported`

    See Also
    --------
    :py:obj:`~.cudaHostUnregister`, :py:obj:`~.cudaHostGetFlags`, :py:obj:`~.cudaHostGetDevicePointer`, :py:obj:`~.cuMemHostRegister`
    """
    cyptr = _HelperInputVoidPtr(ptr)
    cdef void* cyptr_ptr = <void*><void_ptr>cyptr.cptr
    with nogil:
        err = cyruntime.cudaHostRegister(cyptr_ptr, size, flags)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaHostUnregister(ptr):
    """ Unregisters a memory range that was registered with cudaHostRegister.

    Unmaps the memory range whose base address is specified by `ptr`, and
    makes it pageable again.

    The base address must be the same one specified to
    :py:obj:`~.cudaHostRegister()`.

    Parameters
    ----------
    ptr : Any
        Host pointer to memory to unregister

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorHostMemoryNotRegistered`

    See Also
    --------
    :py:obj:`~.cudaHostUnregister`, :py:obj:`~.cuMemHostUnregister`
    """
    cyptr = _HelperInputVoidPtr(ptr)
    cdef void* cyptr_ptr = <void*><void_ptr>cyptr.cptr
    with nogil:
        err = cyruntime.cudaHostUnregister(cyptr_ptr)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaHostGetDevicePointer(pHost, unsigned int flags):
    """ Passes back device pointer of mapped host memory allocated by cudaHostAlloc or registered by cudaHostRegister.

    Passes back the device pointer corresponding to the mapped, pinned host
    buffer allocated by :py:obj:`~.cudaHostAlloc()` or registered by
    :py:obj:`~.cudaHostRegister()`.

    :py:obj:`~.cudaHostGetDevicePointer()` will fail if the
    :py:obj:`~.cudaDeviceMapHost` flag was not specified before deferred
    context creation occurred, or if called on a device that does not
    support mapped, pinned memory.

    For devices that have a non-zero value for the device attribute
    :py:obj:`~.cudaDevAttrCanUseHostPointerForRegisteredMem`, the memory
    can also be accessed from the device using the host pointer `pHost`.
    The device pointer returned by :py:obj:`~.cudaHostGetDevicePointer()`
    may or may not match the original host pointer `pHost` and depends on
    the devices visible to the application. If all devices visible to the
    application have a non-zero value for the device attribute, the device
    pointer returned by :py:obj:`~.cudaHostGetDevicePointer()` will match
    the original pointer `pHost`. If any device visible to the application
    has a zero value for the device attribute, the device pointer returned
    by :py:obj:`~.cudaHostGetDevicePointer()` will not match the original
    host pointer `pHost`, but it will be suitable for use on all devices
    provided Unified Virtual Addressing is enabled. In such systems, it is
    valid to access the memory using either pointer on devices that have a
    non-zero value for the device attribute. Note however that such devices
    should access the memory using only of the two pointers and not both.

    `flags` provides for future releases. For now, it must be set to 0.

    Parameters
    ----------
    pHost : Any
        Requested host pointer mapping
    flags : unsigned int
        Flags for extensions (must be 0 for now)

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorMemoryAllocation`
    pDevice : Any
        Returned device pointer for mapped memory

    See Also
    --------
    :py:obj:`~.cudaSetDeviceFlags`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.cuMemHostGetDevicePointer`
    """
    cdef void_ptr pDevice = 0
    cypHost = _HelperInputVoidPtr(pHost)
    cdef void* cypHost_ptr = <void*><void_ptr>cypHost.cptr
    with nogil:
        err = cyruntime.cudaHostGetDevicePointer(<void**>&pDevice, cypHost_ptr, flags)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pDevice)

@cython.embedsignature(True)
def cudaHostGetFlags(pHost):
    """ Passes back flags used to allocate pinned host memory allocated by cudaHostAlloc.

    :py:obj:`~.cudaHostGetFlags()` will fail if the input pointer does not
    reside in an address range allocated by :py:obj:`~.cudaHostAlloc()`.

    Parameters
    ----------
    pHost : Any
        Host pointer

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`
    pFlags : unsigned int
        Returned flags word

    See Also
    --------
    :py:obj:`~.cudaHostAlloc`, :py:obj:`~.cuMemHostGetFlags`
    """
    cdef unsigned int pFlags = 0
    cypHost = _HelperInputVoidPtr(pHost)
    cdef void* cypHost_ptr = <void*><void_ptr>cypHost.cptr
    with nogil:
        err = cyruntime.cudaHostGetFlags(&pFlags, cypHost_ptr)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pFlags)

@cython.embedsignature(True)
def cudaMalloc3D(extent not None : cudaExtent):
    """ Allocates logical 1D, 2D, or 3D memory objects on the device.

    Allocates at least `width` * `height` * `depth` bytes of linear memory
    on the device and returns a :py:obj:`~.cudaPitchedPtr` in which `ptr`
    is a pointer to the allocated memory. The function may pad the
    allocation to ensure hardware alignment requirements are met. The pitch
    returned in the `pitch` field of `pitchedDevPtr` is the width in bytes
    of the allocation.

    The returned :py:obj:`~.cudaPitchedPtr` contains additional fields
    `xsize` and `ysize`, the logical width and height of the allocation,
    which are equivalent to the `width` and `height` `extent` parameters
    provided by the programmer during allocation.

    For allocations of 2D and 3D objects, it is highly recommended that
    programmers perform allocations using :py:obj:`~.cudaMalloc3D()` or
    :py:obj:`~.cudaMallocPitch()`. Due to alignment restrictions in the
    hardware, this is especially true if the application will be performing
    memory copies involving 2D or 3D objects (whether linear memory or CUDA
    arrays).

    Parameters
    ----------
    extent : :py:obj:`~.cudaExtent`
        Requested allocation size (`width` field in bytes)

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorMemoryAllocation`
    pitchedDevPtr : :py:obj:`~.cudaPitchedPtr`
        Pointer to allocated pitched device memory

    See Also
    --------
    :py:obj:`~.cudaMallocPitch`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaMemcpy3D`, :py:obj:`~.cudaMemset3D`, :py:obj:`~.cudaMalloc3DArray`, :py:obj:`~.cudaMallocArray`, :py:obj:`~.cudaFreeArray`, :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.make_cudaPitchedPtr`, :py:obj:`~.make_cudaExtent`, :py:obj:`~.cuMemAllocPitch`
    """
    cdef cudaPitchedPtr pitchedDevPtr = cudaPitchedPtr()
    with nogil:
        err = cyruntime.cudaMalloc3D(<cyruntime.cudaPitchedPtr*>pitchedDevPtr._pvt_ptr, extent._pvt_ptr[0])
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pitchedDevPtr)

@cython.embedsignature(True)
def cudaMalloc3DArray(desc : Optional[cudaChannelFormatDesc], extent not None : cudaExtent, unsigned int flags):
    """ Allocate an array on the device.

    Allocates a CUDA array according to the
    :py:obj:`~.cudaChannelFormatDesc` structure `desc` and returns a handle
    to the new CUDA array in `*array`.

    The :py:obj:`~.cudaChannelFormatDesc` is defined as:

    **View CUDA Toolkit Documentation for a C++ code example**

    where :py:obj:`~.cudaChannelFormatKind` is one of
    :py:obj:`~.cudaChannelFormatKindSigned`,
    :py:obj:`~.cudaChannelFormatKindUnsigned`, or
    :py:obj:`~.cudaChannelFormatKindFloat`.

    :py:obj:`~.cudaMalloc3DArray()` can allocate the following:

    - A 1D array is allocated if the height and depth extents are both
      zero.

    - A 2D array is allocated if only the depth extent is zero.

    - A 3D array is allocated if all three extents are non-zero.

    - A 1D layered CUDA array is allocated if only the height extent is
      zero and the cudaArrayLayered flag is set. Each layer is a 1D array.
      The number of layers is determined by the depth extent.

    - A 2D layered CUDA array is allocated if all three extents are non-
      zero and the cudaArrayLayered flag is set. Each layer is a 2D array.
      The number of layers is determined by the depth extent.

    - A cubemap CUDA array is allocated if all three extents are non-zero
      and the cudaArrayCubemap flag is set. Width must be equal to height,
      and depth must be six. A cubemap is a special type of 2D layered CUDA
      array, where the six layers represent the six faces of a cube. The
      order of the six layers in memory is the same as that listed in
      :py:obj:`~.cudaGraphicsCubeFace`.

    - A cubemap layered CUDA array is allocated if all three extents are
      non-zero, and both, cudaArrayCubemap and cudaArrayLayered flags are
      set. Width must be equal to height, and depth must be a multiple of
      six. A cubemap layered CUDA array is a special type of 2D layered
      CUDA array that consists of a collection of cubemaps. The first six
      layers represent the first cubemap, the next six layers form the
      second cubemap, and so on.

    The `flags` parameter enables different options to be specified that
    affect the allocation, as follows.

    - :py:obj:`~.cudaArrayDefault`: This flag's value is defined to be 0
      and provides default array allocation

    - :py:obj:`~.cudaArrayLayered`: Allocates a layered CUDA array, with
      the depth extent indicating the number of layers

    - :py:obj:`~.cudaArrayCubemap`: Allocates a cubemap CUDA array. Width
      must be equal to height, and depth must be six. If the
      cudaArrayLayered flag is also set, depth must be a multiple of six.

    - :py:obj:`~.cudaArraySurfaceLoadStore`: Allocates a CUDA array that
      could be read from or written to using a surface reference.

    - :py:obj:`~.cudaArrayTextureGather`: This flag indicates that texture
      gather operations will be performed on the CUDA array. Texture gather
      can only be performed on 2D CUDA arrays.

    - :py:obj:`~.cudaArraySparse`: Allocates a CUDA array without physical
      backing memory. The subregions within this sparse array can later be
      mapped onto a physical memory allocation by calling
      :py:obj:`~.cuMemMapArrayAsync`. This flag can only be used for
      creating 2D, 3D or 2D layered sparse CUDA arrays. The physical
      backing memory must be allocated via :py:obj:`~.cuMemCreate`.

    - :py:obj:`~.cudaArrayDeferredMapping`: Allocates a CUDA array without
      physical backing memory. The entire array can later be mapped onto a
      physical memory allocation by calling :py:obj:`~.cuMemMapArrayAsync`.
      The physical backing memory must be allocated via
      :py:obj:`~.cuMemCreate`.

    The width, height and depth extents must meet certain size requirements
    as listed in the following table. All values are specified in elements.

    Note that 2D CUDA arrays have different size requirements if the
    :py:obj:`~.cudaArrayTextureGather` flag is set. In that case, the valid
    range for (width, height, depth) is ((1,maxTexture2DGather[0]),
    (1,maxTexture2DGather[1]), 0).

    **View CUDA Toolkit Documentation for a table example**

    Parameters
    ----------
    desc : :py:obj:`~.cudaChannelFormatDesc`
        Requested channel format
    extent : :py:obj:`~.cudaExtent`
        Requested allocation size (`width` field in elements)
    flags : unsigned int
        Flags for extensions

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorMemoryAllocation`
    array : :py:obj:`~.cudaArray_t`
        Pointer to allocated array in device memory

    See Also
    --------
    :py:obj:`~.cudaMalloc3D`, :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaMallocPitch`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaFreeArray`, :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.make_cudaExtent`, :py:obj:`~.cuArray3DCreate`
    """
    cdef cudaArray_t array = cudaArray_t()
    cdef cyruntime.cudaChannelFormatDesc* cydesc_ptr = desc._pvt_ptr if desc is not None else NULL
    with nogil:
        err = cyruntime.cudaMalloc3DArray(<cyruntime.cudaArray_t*>array._pvt_ptr, cydesc_ptr, extent._pvt_ptr[0], flags)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], array)

@cython.embedsignature(True)
def cudaMallocMipmappedArray(desc : Optional[cudaChannelFormatDesc], extent not None : cudaExtent, unsigned int numLevels, unsigned int flags):
    """ Allocate a mipmapped array on the device.

    Allocates a CUDA mipmapped array according to the
    :py:obj:`~.cudaChannelFormatDesc` structure `desc` and returns a handle
    to the new CUDA mipmapped array in `*mipmappedArray`. `numLevels`
    specifies the number of mipmap levels to be allocated. This value is
    clamped to the range [1, 1 + floor(log2(max(width, height, depth)))].

    The :py:obj:`~.cudaChannelFormatDesc` is defined as:

    **View CUDA Toolkit Documentation for a C++ code example**

    where :py:obj:`~.cudaChannelFormatKind` is one of
    :py:obj:`~.cudaChannelFormatKindSigned`,
    :py:obj:`~.cudaChannelFormatKindUnsigned`, or
    :py:obj:`~.cudaChannelFormatKindFloat`.

    :py:obj:`~.cudaMallocMipmappedArray()` can allocate the following:

    - A 1D mipmapped array is allocated if the height and depth extents are
      both zero.

    - A 2D mipmapped array is allocated if only the depth extent is zero.

    - A 3D mipmapped array is allocated if all three extents are non-zero.

    - A 1D layered CUDA mipmapped array is allocated if only the height
      extent is zero and the cudaArrayLayered flag is set. Each layer is a
      1D mipmapped array. The number of layers is determined by the depth
      extent.

    - A 2D layered CUDA mipmapped array is allocated if all three extents
      are non-zero and the cudaArrayLayered flag is set. Each layer is a 2D
      mipmapped array. The number of layers is determined by the depth
      extent.

    - A cubemap CUDA mipmapped array is allocated if all three extents are
      non-zero and the cudaArrayCubemap flag is set. Width must be equal to
      height, and depth must be six. The order of the six layers in memory
      is the same as that listed in :py:obj:`~.cudaGraphicsCubeFace`.

    - A cubemap layered CUDA mipmapped array is allocated if all three
      extents are non-zero, and both, cudaArrayCubemap and cudaArrayLayered
      flags are set. Width must be equal to height, and depth must be a
      multiple of six. A cubemap layered CUDA mipmapped array is a special
      type of 2D layered CUDA mipmapped array that consists of a collection
      of cubemap mipmapped arrays. The first six layers represent the first
      cubemap mipmapped array, the next six layers form the second cubemap
      mipmapped array, and so on.

    The `flags` parameter enables different options to be specified that
    affect the allocation, as follows.

    - :py:obj:`~.cudaArrayDefault`: This flag's value is defined to be 0
      and provides default mipmapped array allocation

    - :py:obj:`~.cudaArrayLayered`: Allocates a layered CUDA mipmapped
      array, with the depth extent indicating the number of layers

    - :py:obj:`~.cudaArrayCubemap`: Allocates a cubemap CUDA mipmapped
      array. Width must be equal to height, and depth must be six. If the
      cudaArrayLayered flag is also set, depth must be a multiple of six.

    - :py:obj:`~.cudaArraySurfaceLoadStore`: This flag indicates that
      individual mipmap levels of the CUDA mipmapped array will be read
      from or written to using a surface reference.

    - :py:obj:`~.cudaArrayTextureGather`: This flag indicates that texture
      gather operations will be performed on the CUDA array. Texture gather
      can only be performed on 2D CUDA mipmapped arrays, and the gather
      operations are performed only on the most detailed mipmap level.

    - :py:obj:`~.cudaArraySparse`: Allocates a CUDA mipmapped array without
      physical backing memory. The subregions within this sparse array can
      later be mapped onto a physical memory allocation by calling
      :py:obj:`~.cuMemMapArrayAsync`. This flag can only be used for
      creating 2D, 3D or 2D layered sparse CUDA mipmapped arrays. The
      physical backing memory must be allocated via
      :py:obj:`~.cuMemCreate`.

    - :py:obj:`~.cudaArrayDeferredMapping`: Allocates a CUDA mipmapped
      array without physical backing memory. The entire array can later be
      mapped onto a physical memory allocation by calling
      :py:obj:`~.cuMemMapArrayAsync`. The physical backing memory must be
      allocated via :py:obj:`~.cuMemCreate`.

    The width, height and depth extents must meet certain size requirements
    as listed in the following table. All values are specified in elements.

    **View CUDA Toolkit Documentation for a table example**

    Parameters
    ----------
    desc : :py:obj:`~.cudaChannelFormatDesc`
        Requested channel format
    extent : :py:obj:`~.cudaExtent`
        Requested allocation size (`width` field in elements)
    numLevels : unsigned int
        Number of mipmap levels to allocate
    flags : unsigned int
        Flags for extensions

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorMemoryAllocation`
    mipmappedArray : :py:obj:`~.cudaMipmappedArray_t`
        Pointer to allocated mipmapped array in device memory

    See Also
    --------
    :py:obj:`~.cudaMalloc3D`, :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaMallocPitch`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaFreeArray`, :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.make_cudaExtent`, :py:obj:`~.cuMipmappedArrayCreate`
    """
    cdef cudaMipmappedArray_t mipmappedArray = cudaMipmappedArray_t()
    cdef cyruntime.cudaChannelFormatDesc* cydesc_ptr = desc._pvt_ptr if desc is not None else NULL
    with nogil:
        err = cyruntime.cudaMallocMipmappedArray(<cyruntime.cudaMipmappedArray_t*>mipmappedArray._pvt_ptr, cydesc_ptr, extent._pvt_ptr[0], numLevels, flags)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], mipmappedArray)

@cython.embedsignature(True)
def cudaGetMipmappedArrayLevel(mipmappedArray, unsigned int level):
    """ Gets a mipmap level of a CUDA mipmapped array.

    Returns in `*levelArray` a CUDA array that represents a single mipmap
    level of the CUDA mipmapped array `mipmappedArray`.

    If `level` is greater than the maximum number of levels in this
    mipmapped array, :py:obj:`~.cudaErrorInvalidValue` is returned.

    If `mipmappedArray` is NULL, :py:obj:`~.cudaErrorInvalidResourceHandle`
    is returned.

    Parameters
    ----------
    mipmappedArray : :py:obj:`~.cudaMipmappedArray_const_t`
        CUDA mipmapped array
    level : unsigned int
        Mipmap level

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue` :py:obj:`~.cudaErrorInvalidResourceHandle`
    levelArray : :py:obj:`~.cudaArray_t`
        Returned mipmap level CUDA array

    See Also
    --------
    :py:obj:`~.cudaMalloc3D`, :py:obj:`~.cudaMalloc`, :py:obj:`~.cudaMallocPitch`, :py:obj:`~.cudaFree`, :py:obj:`~.cudaFreeArray`, :py:obj:`~.cudaMallocHost (C API)`, :py:obj:`~.cudaFreeHost`, :py:obj:`~.cudaHostAlloc`, :py:obj:`~.make_cudaExtent`, :py:obj:`~.cuMipmappedArrayGetLevel`
    """
    cdef cyruntime.cudaMipmappedArray_const_t cymipmappedArray
    if mipmappedArray is None:
        pmipmappedArray = 0
    elif isinstance(mipmappedArray, (cudaMipmappedArray_const_t,)):
        pmipmappedArray = int(mipmappedArray)
    else:
        pmipmappedArray = int(cudaMipmappedArray_const_t(mipmappedArray))
    cymipmappedArray = <cyruntime.cudaMipmappedArray_const_t><void_ptr>pmipmappedArray
    cdef cudaArray_t levelArray = cudaArray_t()
    with nogil:
        err = cyruntime.cudaGetMipmappedArrayLevel(<cyruntime.cudaArray_t*>levelArray._pvt_ptr, cymipmappedArray, level)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], levelArray)

@cython.embedsignature(True)
def cudaMemcpy3D(p : Optional[cudaMemcpy3DParms]):
    """ Copies data between 3D objects.

    **View CUDA Toolkit Documentation for a C++ code example**

    :py:obj:`~.cudaMemcpy3D()` copies data betwen two 3D objects. The
    source and destination objects may be in either host memory, device
    memory, or a CUDA array. The source, destination, extent, and kind of
    copy performed is specified by the :py:obj:`~.cudaMemcpy3DParms` struct
    which should be initialized to zero before use:

    **View CUDA Toolkit Documentation for a C++ code example**

    The struct passed to :py:obj:`~.cudaMemcpy3D()` must specify one of
    `srcArray` or `srcPtr` and one of `dstArray` or `dstPtr`. Passing more
    than one non-zero source or destination will cause
    :py:obj:`~.cudaMemcpy3D()` to return an error.

    The `srcPos` and `dstPos` fields are optional offsets into the source
    and destination objects and are defined in units of each object's
    elements. The element for a host or device pointer is assumed to be
    unsigned char.

    The `extent` field defines the dimensions of the transferred area in
    elements. If a CUDA array is participating in the copy, the extent is
    defined in terms of that array's elements. If no CUDA array is
    participating in the copy then the extents are defined in elements of
    unsigned char.

    The `kind` field defines the direction of the copy. It must be one of
    :py:obj:`~.cudaMemcpyHostToHost`, :py:obj:`~.cudaMemcpyHostToDevice`,
    :py:obj:`~.cudaMemcpyDeviceToHost`,
    :py:obj:`~.cudaMemcpyDeviceToDevice`, or :py:obj:`~.cudaMemcpyDefault`.
    Passing :py:obj:`~.cudaMemcpyDefault` is recommended, in which case the
    type of transfer is inferred from the pointer values. However,
    :py:obj:`~.cudaMemcpyDefault` is only allowed on systems that support
    unified virtual addressing. For :py:obj:`~.cudaMemcpyHostToHost` or
    :py:obj:`~.cudaMemcpyHostToDevice` or
    :py:obj:`~.cudaMemcpyDeviceToHost` passed as kind and cudaArray type
    passed as source or destination, if the kind implies cudaArray type to
    be present on the host, :py:obj:`~.cudaMemcpy3D()` will disregard that
    implication and silently correct the kind based on the fact that
    cudaArray type can only be present on the device.

    If the source and destination are both arrays,
    :py:obj:`~.cudaMemcpy3D()` will return an error if they do not have the
    same element size.

    The source and destination object may not overlap. If overlapping
    source and destination objects are specified, undefined behavior will
    result.

    The source object must entirely contain the region defined by `srcPos`
    and `extent`. The destination object must entirely contain the region
    defined by `dstPos` and `extent`.

    :py:obj:`~.cudaMemcpy3D()` returns an error if the pitch of `srcPtr` or
    `dstPtr` exceeds the maximum allowed. The pitch of a
    :py:obj:`~.cudaPitchedPtr` allocated with :py:obj:`~.cudaMalloc3D()`
    will always be valid.

    Parameters
    ----------
    p : :py:obj:`~.cudaMemcpy3DParms`
        3D memory copy parameters

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidPitchValue`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`

    See Also
    --------
    :py:obj:`~.cudaMalloc3D`, :py:obj:`~.cudaMalloc3DArray`, :py:obj:`~.cudaMemset3D`, :py:obj:`~.cudaMemcpy3DAsync`, :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpy2D`, :py:obj:`~.cudaMemcpy2DToArray`, :py:obj:`~.cudaMemcpy2DFromArray`, :py:obj:`~.cudaMemcpy2DArrayToArray`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy2DAsync`, :py:obj:`~.cudaMemcpy2DToArrayAsync`, :py:obj:`~.cudaMemcpy2DFromArrayAsync`, :py:obj:`~.cudaMemcpyToSymbolAsync`, :py:obj:`~.cudaMemcpyFromSymbolAsync`, :py:obj:`~.make_cudaExtent`, :py:obj:`~.make_cudaPos`, :py:obj:`~.cuMemcpy3D`
    """
    cdef cyruntime.cudaMemcpy3DParms* cyp_ptr = p._pvt_ptr if p is not None else NULL
    with nogil:
        err = cyruntime.cudaMemcpy3D(cyp_ptr)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpy3DPeer(p : Optional[cudaMemcpy3DPeerParms]):
    """ Copies memory between devices.

    Perform a 3D memory copy according to the parameters specified in `p`.
    See the definition of the :py:obj:`~.cudaMemcpy3DPeerParms` structure
    for documentation of its parameters.

    Note that this function is synchronous with respect to the host only if
    the source or destination of the transfer is host memory. Note also
    that this copy is serialized with respect to all pending and future
    asynchronous work in to the current device, the copy's source device,
    and the copy's destination device (use
    :py:obj:`~.cudaMemcpy3DPeerAsync` to avoid this synchronization).

    Parameters
    ----------
    p : :py:obj:`~.cudaMemcpy3DPeerParms`
        Parameters for the memory copy

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorInvalidPitchValue`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpyPeer`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpyPeerAsync`, :py:obj:`~.cudaMemcpy3DPeerAsync`, :py:obj:`~.cuMemcpy3DPeer`
    """
    cdef cyruntime.cudaMemcpy3DPeerParms* cyp_ptr = p._pvt_ptr if p is not None else NULL
    with nogil:
        err = cyruntime.cudaMemcpy3DPeer(cyp_ptr)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpy3DAsync(p : Optional[cudaMemcpy3DParms], stream):
    """ Copies data between 3D objects.

    **View CUDA Toolkit Documentation for a C++ code example**

    :py:obj:`~.cudaMemcpy3DAsync()` copies data betwen two 3D objects. The
    source and destination objects may be in either host memory, device
    memory, or a CUDA array. The source, destination, extent, and kind of
    copy performed is specified by the :py:obj:`~.cudaMemcpy3DParms` struct
    which should be initialized to zero before use:

    **View CUDA Toolkit Documentation for a C++ code example**

    The struct passed to :py:obj:`~.cudaMemcpy3DAsync()` must specify one
    of `srcArray` or `srcPtr` and one of `dstArray` or `dstPtr`. Passing
    more than one non-zero source or destination will cause
    :py:obj:`~.cudaMemcpy3DAsync()` to return an error.

    The `srcPos` and `dstPos` fields are optional offsets into the source
    and destination objects and are defined in units of each object's
    elements. The element for a host or device pointer is assumed to be
    unsigned char. For CUDA arrays, positions must be in the range [0,
    2048) for any dimension.

    The `extent` field defines the dimensions of the transferred area in
    elements. If a CUDA array is participating in the copy, the extent is
    defined in terms of that array's elements. If no CUDA array is
    participating in the copy then the extents are defined in elements of
    unsigned char.

    The `kind` field defines the direction of the copy. It must be one of
    :py:obj:`~.cudaMemcpyHostToHost`, :py:obj:`~.cudaMemcpyHostToDevice`,
    :py:obj:`~.cudaMemcpyDeviceToHost`,
    :py:obj:`~.cudaMemcpyDeviceToDevice`, or :py:obj:`~.cudaMemcpyDefault`.
    Passing :py:obj:`~.cudaMemcpyDefault` is recommended, in which case the
    type of transfer is inferred from the pointer values. However,
    :py:obj:`~.cudaMemcpyDefault` is only allowed on systems that support
    unified virtual addressing. For :py:obj:`~.cudaMemcpyHostToHost` or
    :py:obj:`~.cudaMemcpyHostToDevice` or
    :py:obj:`~.cudaMemcpyDeviceToHost` passed as kind and cudaArray type
    passed as source or destination, if the kind implies cudaArray type to
    be present on the host, :py:obj:`~.cudaMemcpy3DAsync()` will disregard
    that implication and silently correct the kind based on the fact that
    cudaArray type can only be present on the device.

    If the source and destination are both arrays,
    :py:obj:`~.cudaMemcpy3DAsync()` will return an error if they do not
    have the same element size.

    The source and destination object may not overlap. If overlapping
    source and destination objects are specified, undefined behavior will
    result.

    The source object must lie entirely within the region defined by
    `srcPos` and `extent`. The destination object must lie entirely within
    the region defined by `dstPos` and `extent`.

    :py:obj:`~.cudaMemcpy3DAsync()` returns an error if the pitch of
    `srcPtr` or `dstPtr` exceeds the maximum allowed. The pitch of a
    :py:obj:`~.cudaPitchedPtr` allocated with :py:obj:`~.cudaMalloc3D()`
    will always be valid.

    :py:obj:`~.cudaMemcpy3DAsync()` is asynchronous with respect to the
    host, so the call may return before the copy is complete. The copy can
    optionally be associated to a stream by passing a non-zero `stream`
    argument. If `kind` is :py:obj:`~.cudaMemcpyHostToDevice` or
    :py:obj:`~.cudaMemcpyDeviceToHost` and `stream` is non-zero, the copy
    may overlap with operations in other streams.

    The device version of this function only handles device to device
    copies and cannot be given local or shared pointers.

    Parameters
    ----------
    p : :py:obj:`~.cudaMemcpy3DParms`
        3D memory copy parameters
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidPitchValue`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`

    See Also
    --------
    :py:obj:`~.cudaMalloc3D`, :py:obj:`~.cudaMalloc3DArray`, :py:obj:`~.cudaMemset3D`, :py:obj:`~.cudaMemcpy3D`, :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpy2D`, :py:obj:`~.cudaMemcpy2DToArray`, ::::py:obj:`~.cudaMemcpy2DFromArray`, :py:obj:`~.cudaMemcpy2DArrayToArray`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy2DAsync`, :py:obj:`~.cudaMemcpy2DToArrayAsync`, :py:obj:`~.cudaMemcpy2DFromArrayAsync`, :py:obj:`~.cudaMemcpyToSymbolAsync`, :py:obj:`~.cudaMemcpyFromSymbolAsync`, :py:obj:`~.make_cudaExtent`, :py:obj:`~.make_cudaPos`, :py:obj:`~.cuMemcpy3DAsync`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cdef cyruntime.cudaMemcpy3DParms* cyp_ptr = p._pvt_ptr if p is not None else NULL
    with nogil:
        err = cyruntime.cudaMemcpy3DAsync(cyp_ptr, cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpy3DPeerAsync(p : Optional[cudaMemcpy3DPeerParms], stream):
    """ Copies memory between devices asynchronously.

    Perform a 3D memory copy according to the parameters specified in `p`.
    See the definition of the :py:obj:`~.cudaMemcpy3DPeerParms` structure
    for documentation of its parameters.

    Parameters
    ----------
    p : :py:obj:`~.cudaMemcpy3DPeerParms`
        Parameters for the memory copy
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidDevice`, :py:obj:`~.cudaErrorInvalidPitchValue`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpyPeer`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpyPeerAsync`, :py:obj:`~.cudaMemcpy3DPeerAsync`, :py:obj:`~.cuMemcpy3DPeerAsync`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cdef cyruntime.cudaMemcpy3DPeerParms* cyp_ptr = p._pvt_ptr if p is not None else NULL
    with nogil:
        err = cyruntime.cudaMemcpy3DPeerAsync(cyp_ptr, cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemGetInfo():
    """ Gets free and total device memory.

    Returns in `*total` the total amount of memory available to the the
    current context. Returns in `*free` the amount of memory on the device
    that is free according to the OS. CUDA is not guaranteed to be able to
    allocate all of the memory that the OS reports as free. In a multi-
    tenet situation, free estimate returned is prone to race condition
    where a new allocation/free done by a different process or a different
    thread in the same process between the time when free memory was
    estimated and reported, will result in deviation in free value reported
    and actual free memory.

    The integrated GPU on Tegra shares memory with CPU and other component
    of the SoC. The free and total values returned by the API excludes the
    SWAP memory space maintained by the OS on some platforms. The OS may
    move some of the memory pages into swap area as the GPU or CPU allocate
    or access memory. See Tegra app note on how to calculate total and free
    memory on Tegra.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorLaunchFailure`
    free : int
        Returned free memory in bytes
    total : int
        Returned total memory in bytes

    See Also
    --------
    :py:obj:`~.cuMemGetInfo`
    """
    cdef size_t free = 0
    cdef size_t total = 0
    with nogil:
        err = cyruntime.cudaMemGetInfo(&free, &total)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None, None)
    return (_dict_cudaError_t[err], free, total)

@cython.embedsignature(True)
def cudaArrayGetInfo(array):
    """ Gets info about the specified cudaArray.

    Returns in `*desc`, `*extent` and `*flags` respectively, the type,
    shape and flags of `array`.

    Any of `*desc`, `*extent` and `*flags` may be specified as NULL.

    Parameters
    ----------
    array : :py:obj:`~.cudaArray_t`
        The :py:obj:`~.cudaArray` to get info for

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`
    desc : :py:obj:`~.cudaChannelFormatDesc`
        Returned array type
    extent : :py:obj:`~.cudaExtent`
        Returned array shape. 2D arrays will have depth of zero
    flags : unsigned int
        Returned array flags

    See Also
    --------
    :py:obj:`~.cuArrayGetDescriptor`, :py:obj:`~.cuArray3DGetDescriptor`
    """
    cdef cyruntime.cudaArray_t cyarray
    if array is None:
        parray = 0
    elif isinstance(array, (cudaArray_t,)):
        parray = int(array)
    else:
        parray = int(cudaArray_t(array))
    cyarray = <cyruntime.cudaArray_t><void_ptr>parray
    cdef cudaChannelFormatDesc desc = cudaChannelFormatDesc()
    cdef cudaExtent extent = cudaExtent()
    cdef unsigned int flags = 0
    with nogil:
        err = cyruntime.cudaArrayGetInfo(<cyruntime.cudaChannelFormatDesc*>desc._pvt_ptr, <cyruntime.cudaExtent*>extent._pvt_ptr, &flags, cyarray)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None, None, None)
    return (_dict_cudaError_t[err], desc, extent, flags)

@cython.embedsignature(True)
def cudaArrayGetPlane(hArray, unsigned int planeIdx):
    """ Gets a CUDA array plane from a CUDA array.

    Returns in `pPlaneArray` a CUDA array that represents a single format
    plane of the CUDA array `hArray`.

    If `planeIdx` is greater than the maximum number of planes in this
    array or if the array does not have a multi-planar format e.g:
    :py:obj:`~.cudaChannelFormatKindNV12`, then
    :py:obj:`~.cudaErrorInvalidValue` is returned.

    Note that if the `hArray` has format
    :py:obj:`~.cudaChannelFormatKindNV12`, then passing in 0 for `planeIdx`
    returns a CUDA array of the same size as `hArray` but with one 8-bit
    channel and :py:obj:`~.cudaChannelFormatKindUnsigned` as its format
    kind. If 1 is passed for `planeIdx`, then the returned CUDA array has
    half the height and width of `hArray` with two 8-bit channels and
    :py:obj:`~.cudaChannelFormatKindUnsigned` as its format kind.

    Parameters
    ----------
    hArray : :py:obj:`~.cudaArray_t`
        CUDA array
    planeIdx : unsigned int
        Plane index

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue` :py:obj:`~.cudaErrorInvalidResourceHandle`
    pPlaneArray : :py:obj:`~.cudaArray_t`
        Returned CUDA array referenced by the `planeIdx`

    See Also
    --------
    :py:obj:`~.cuArrayGetPlane`
    """
    cdef cyruntime.cudaArray_t cyhArray
    if hArray is None:
        phArray = 0
    elif isinstance(hArray, (cudaArray_t,)):
        phArray = int(hArray)
    else:
        phArray = int(cudaArray_t(hArray))
    cyhArray = <cyruntime.cudaArray_t><void_ptr>phArray
    cdef cudaArray_t pPlaneArray = cudaArray_t()
    with nogil:
        err = cyruntime.cudaArrayGetPlane(<cyruntime.cudaArray_t*>pPlaneArray._pvt_ptr, cyhArray, planeIdx)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], pPlaneArray)

@cython.embedsignature(True)
def cudaArrayGetMemoryRequirements(array, int device):
    """ Returns the memory requirements of a CUDA array.

    Returns the memory requirements of a CUDA array in `memoryRequirements`
    If the CUDA array is not allocated with flag
    :py:obj:`~.cudaArrayDeferredMapping` :py:obj:`~.cudaErrorInvalidValue`
    will be returned.

    The returned value in :py:obj:`~.cudaArrayMemoryRequirements.size`
    represents the total size of the CUDA array. The returned value in
    :py:obj:`~.cudaArrayMemoryRequirements.alignment` represents the
    alignment necessary for mapping the CUDA array.

    Parameters
    ----------
    array : :py:obj:`~.cudaArray_t`
        CUDA array to get the memory requirements of
    device : int
        Device to get the memory requirements for

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess` :py:obj:`~.cudaErrorInvalidValue`
    memoryRequirements : :py:obj:`~.cudaArrayMemoryRequirements`
        Pointer to :py:obj:`~.cudaArrayMemoryRequirements`

    See Also
    --------
    :py:obj:`~.cudaMipmappedArrayGetMemoryRequirements`
    """
    cdef cyruntime.cudaArray_t cyarray
    if array is None:
        parray = 0
    elif isinstance(array, (cudaArray_t,)):
        parray = int(array)
    else:
        parray = int(cudaArray_t(array))
    cyarray = <cyruntime.cudaArray_t><void_ptr>parray
    cdef cudaArrayMemoryRequirements memoryRequirements = cudaArrayMemoryRequirements()
    with nogil:
        err = cyruntime.cudaArrayGetMemoryRequirements(<cyruntime.cudaArrayMemoryRequirements*>memoryRequirements._pvt_ptr, cyarray, device)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], memoryRequirements)

@cython.embedsignature(True)
def cudaMipmappedArrayGetMemoryRequirements(mipmap, int device):
    """ Returns the memory requirements of a CUDA mipmapped array.

    Returns the memory requirements of a CUDA mipmapped array in
    `memoryRequirements` If the CUDA mipmapped array is not allocated with
    flag :py:obj:`~.cudaArrayDeferredMapping`
    :py:obj:`~.cudaErrorInvalidValue` will be returned.

    The returned value in :py:obj:`~.cudaArrayMemoryRequirements.size`
    represents the total size of the CUDA mipmapped array. The returned
    value in :py:obj:`~.cudaArrayMemoryRequirements.alignment` represents
    the alignment necessary for mapping the CUDA mipmapped array.

    Parameters
    ----------
    mipmap : :py:obj:`~.cudaMipmappedArray_t`
        CUDA mipmapped array to get the memory requirements of
    device : int
        Device to get the memory requirements for

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess` :py:obj:`~.cudaErrorInvalidValue`
    memoryRequirements : :py:obj:`~.cudaArrayMemoryRequirements`
        Pointer to :py:obj:`~.cudaArrayMemoryRequirements`

    See Also
    --------
    :py:obj:`~.cudaArrayGetMemoryRequirements`
    """
    cdef cyruntime.cudaMipmappedArray_t cymipmap
    if mipmap is None:
        pmipmap = 0
    elif isinstance(mipmap, (cudaMipmappedArray_t,)):
        pmipmap = int(mipmap)
    else:
        pmipmap = int(cudaMipmappedArray_t(mipmap))
    cymipmap = <cyruntime.cudaMipmappedArray_t><void_ptr>pmipmap
    cdef cudaArrayMemoryRequirements memoryRequirements = cudaArrayMemoryRequirements()
    with nogil:
        err = cyruntime.cudaMipmappedArrayGetMemoryRequirements(<cyruntime.cudaArrayMemoryRequirements*>memoryRequirements._pvt_ptr, cymipmap, device)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], memoryRequirements)

@cython.embedsignature(True)
def cudaArrayGetSparseProperties(array):
    """ Returns the layout properties of a sparse CUDA array.

    Returns the layout properties of a sparse CUDA array in
    `sparseProperties`. If the CUDA array is not allocated with flag
    :py:obj:`~.cudaArraySparse` :py:obj:`~.cudaErrorInvalidValue` will be
    returned.

    If the returned value in :py:obj:`~.cudaArraySparseProperties.flags`
    contains :py:obj:`~.cudaArraySparsePropertiesSingleMipTail`, then
    :py:obj:`~.cudaArraySparseProperties.miptailSize` represents the total
    size of the array. Otherwise, it will be zero. Also, the returned value
    in :py:obj:`~.cudaArraySparseProperties.miptailFirstLevel` is always
    zero. Note that the `array` must have been allocated using
    :py:obj:`~.cudaMallocArray` or :py:obj:`~.cudaMalloc3DArray`. For CUDA
    arrays obtained using :py:obj:`~.cudaMipmappedArrayGetLevel`,
    :py:obj:`~.cudaErrorInvalidValue` will be returned. Instead,
    :py:obj:`~.cudaMipmappedArrayGetSparseProperties` must be used to
    obtain the sparse properties of the entire CUDA mipmapped array to
    which `array` belongs to.

    Parameters
    ----------
    array : :py:obj:`~.cudaArray_t`
        The CUDA array to get the sparse properties of

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess` :py:obj:`~.cudaErrorInvalidValue`
    sparseProperties : :py:obj:`~.cudaArraySparseProperties`
        Pointer to return the :py:obj:`~.cudaArraySparseProperties`

    See Also
    --------
    :py:obj:`~.cudaMipmappedArrayGetSparseProperties`, :py:obj:`~.cuMemMapArrayAsync`
    """
    cdef cyruntime.cudaArray_t cyarray
    if array is None:
        parray = 0
    elif isinstance(array, (cudaArray_t,)):
        parray = int(array)
    else:
        parray = int(cudaArray_t(array))
    cyarray = <cyruntime.cudaArray_t><void_ptr>parray
    cdef cudaArraySparseProperties sparseProperties = cudaArraySparseProperties()
    with nogil:
        err = cyruntime.cudaArrayGetSparseProperties(<cyruntime.cudaArraySparseProperties*>sparseProperties._pvt_ptr, cyarray)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], sparseProperties)

@cython.embedsignature(True)
def cudaMipmappedArrayGetSparseProperties(mipmap):
    """ Returns the layout properties of a sparse CUDA mipmapped array.

    Returns the sparse array layout properties in `sparseProperties`. If
    the CUDA mipmapped array is not allocated with flag
    :py:obj:`~.cudaArraySparse` :py:obj:`~.cudaErrorInvalidValue` will be
    returned.

    For non-layered CUDA mipmapped arrays,
    :py:obj:`~.cudaArraySparseProperties.miptailSize` returns the size of
    the mip tail region. The mip tail region includes all mip levels whose
    width, height or depth is less than that of the tile. For layered CUDA
    mipmapped arrays, if :py:obj:`~.cudaArraySparseProperties.flags`
    contains :py:obj:`~.cudaArraySparsePropertiesSingleMipTail`, then
    :py:obj:`~.cudaArraySparseProperties.miptailSize` specifies the size of
    the mip tail of all layers combined. Otherwise,
    :py:obj:`~.cudaArraySparseProperties.miptailSize` specifies mip tail
    size per layer. The returned value of
    :py:obj:`~.cudaArraySparseProperties.miptailFirstLevel` is valid only
    if :py:obj:`~.cudaArraySparseProperties.miptailSize` is non-zero.

    Parameters
    ----------
    mipmap : :py:obj:`~.cudaMipmappedArray_t`
        The CUDA mipmapped array to get the sparse properties of

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess` :py:obj:`~.cudaErrorInvalidValue`
    sparseProperties : :py:obj:`~.cudaArraySparseProperties`
        Pointer to return :py:obj:`~.cudaArraySparseProperties`

    See Also
    --------
    :py:obj:`~.cudaArrayGetSparseProperties`, :py:obj:`~.cuMemMapArrayAsync`
    """
    cdef cyruntime.cudaMipmappedArray_t cymipmap
    if mipmap is None:
        pmipmap = 0
    elif isinstance(mipmap, (cudaMipmappedArray_t,)):
        pmipmap = int(mipmap)
    else:
        pmipmap = int(cudaMipmappedArray_t(mipmap))
    cymipmap = <cyruntime.cudaMipmappedArray_t><void_ptr>pmipmap
    cdef cudaArraySparseProperties sparseProperties = cudaArraySparseProperties()
    with nogil:
        err = cyruntime.cudaMipmappedArrayGetSparseProperties(<cyruntime.cudaArraySparseProperties*>sparseProperties._pvt_ptr, cymipmap)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], sparseProperties)

@cython.embedsignature(True)
def cudaMemcpy(dst, src, size_t count, kind not None : cudaMemcpyKind):
    """ Copies data between host and device.

    Copies `count` bytes from the memory area pointed to by `src` to the
    memory area pointed to by `dst`, where `kind` specifies the direction
    of the copy, and must be one of :py:obj:`~.cudaMemcpyHostToHost`,
    :py:obj:`~.cudaMemcpyHostToDevice`, :py:obj:`~.cudaMemcpyDeviceToHost`,
    :py:obj:`~.cudaMemcpyDeviceToDevice`, or :py:obj:`~.cudaMemcpyDefault`.
    Passing :py:obj:`~.cudaMemcpyDefault` is recommended, in which case the
    type of transfer is inferred from the pointer values. However,
    :py:obj:`~.cudaMemcpyDefault` is only allowed on systems that support
    unified virtual addressing. Calling :py:obj:`~.cudaMemcpy()` with dst
    and src pointers that do not match the direction of the copy results in
    an undefined behavior.

    \note_sync

    Parameters
    ----------
    dst : Any
        Destination memory address
    src : Any
        Source memory address
    count : size_t
        Size in bytes to copy
    kind : :py:obj:`~.cudaMemcpyKind`
        Type of transfer

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`

    See Also
    --------
    :py:obj:`~.cudaMemcpy2D`, :py:obj:`~.cudaMemcpy2DToArray`, :py:obj:`~.cudaMemcpy2DFromArray`, :py:obj:`~.cudaMemcpy2DArrayToArray`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy2DAsync`, :py:obj:`~.cudaMemcpy2DToArrayAsync`, :py:obj:`~.cudaMemcpy2DFromArrayAsync`, :py:obj:`~.cudaMemcpyToSymbolAsync`, :py:obj:`~.cudaMemcpyFromSymbolAsync`, :py:obj:`~.cuMemcpyDtoH`, :py:obj:`~.cuMemcpyHtoD`, :py:obj:`~.cuMemcpyDtoD`, :py:obj:`~.cuMemcpy`
    """
    cydst = _HelperInputVoidPtr(dst)
    cdef void* cydst_ptr = <void*><void_ptr>cydst.cptr
    cysrc = _HelperInputVoidPtr(src)
    cdef void* cysrc_ptr = <void*><void_ptr>cysrc.cptr
    cdef cyruntime.cudaMemcpyKind cykind = kind.value
    with nogil:
        err = cyruntime.cudaMemcpy(cydst_ptr, cysrc_ptr, count, cykind)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpyPeer(dst, int dstDevice, src, int srcDevice, size_t count):
    """ Copies memory between two devices.

    Copies memory from one device to memory on another device. `dst` is the
    base device pointer of the destination memory and `dstDevice` is the
    destination device. `src` is the base device pointer of the source
    memory and `srcDevice` is the source device. `count` specifies the
    number of bytes to copy.

    Note that this function is asynchronous with respect to the host, but
    serialized with respect all pending and future asynchronous work in to
    the current device, `srcDevice`, and `dstDevice` (use
    :py:obj:`~.cudaMemcpyPeerAsync` to avoid this synchronization).

    Parameters
    ----------
    dst : Any
        Destination device pointer
    dstDevice : int
        Destination device
    src : Any
        Source device pointer
    srcDevice : int
        Source device
    count : size_t
        Size of memory copy in bytes

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidDevice`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpyPeerAsync`, :py:obj:`~.cudaMemcpy3DPeerAsync`, :py:obj:`~.cuMemcpyPeer`
    """
    cydst = _HelperInputVoidPtr(dst)
    cdef void* cydst_ptr = <void*><void_ptr>cydst.cptr
    cysrc = _HelperInputVoidPtr(src)
    cdef void* cysrc_ptr = <void*><void_ptr>cysrc.cptr
    with nogil:
        err = cyruntime.cudaMemcpyPeer(cydst_ptr, dstDevice, cysrc_ptr, srcDevice, count)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpy2D(dst, size_t dpitch, src, size_t spitch, size_t width, size_t height, kind not None : cudaMemcpyKind):
    """ Copies data between host and device.

    Copies a matrix (`height` rows of `width` bytes each) from the memory
    area pointed to by `src` to the memory area pointed to by `dst`, where
    `kind` specifies the direction of the copy, and must be one of
    :py:obj:`~.cudaMemcpyHostToHost`, :py:obj:`~.cudaMemcpyHostToDevice`,
    :py:obj:`~.cudaMemcpyDeviceToHost`,
    :py:obj:`~.cudaMemcpyDeviceToDevice`, or :py:obj:`~.cudaMemcpyDefault`.
    Passing :py:obj:`~.cudaMemcpyDefault` is recommended, in which case the
    type of transfer is inferred from the pointer values. However,
    :py:obj:`~.cudaMemcpyDefault` is only allowed on systems that support
    unified virtual addressing. `dpitch` and `spitch` are the widths in
    memory in bytes of the 2D arrays pointed to by `dst` and `src`,
    including any padding added to the end of each row. The memory areas
    may not overlap. `width` must not exceed either `dpitch` or `spitch`.
    Calling :py:obj:`~.cudaMemcpy2D()` with `dst` and `src` pointers that
    do not match the direction of the copy results in an undefined
    behavior. :py:obj:`~.cudaMemcpy2D()` returns an error if `dpitch` or
    `spitch` exceeds the maximum allowed.

    Parameters
    ----------
    dst : Any
        Destination memory address
    dpitch : size_t
        Pitch of destination memory
    src : Any
        Source memory address
    spitch : size_t
        Pitch of source memory
    width : size_t
        Width of matrix transfer (columns in bytes)
    height : size_t
        Height of matrix transfer (rows)
    kind : :py:obj:`~.cudaMemcpyKind`
        Type of transfer

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidPitchValue`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpy2DToArray`, :py:obj:`~.cudaMemcpy2DFromArray`, :py:obj:`~.cudaMemcpy2DArrayToArray`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy2DAsync`, :py:obj:`~.cudaMemcpy2DToArrayAsync`, :py:obj:`~.cudaMemcpy2DFromArrayAsync`, :py:obj:`~.cudaMemcpyToSymbolAsync`, :py:obj:`~.cudaMemcpyFromSymbolAsync`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DUnaligned`
    """
    cydst = _HelperInputVoidPtr(dst)
    cdef void* cydst_ptr = <void*><void_ptr>cydst.cptr
    cysrc = _HelperInputVoidPtr(src)
    cdef void* cysrc_ptr = <void*><void_ptr>cysrc.cptr
    cdef cyruntime.cudaMemcpyKind cykind = kind.value
    with nogil:
        err = cyruntime.cudaMemcpy2D(cydst_ptr, dpitch, cysrc_ptr, spitch, width, height, cykind)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpy2DToArray(dst, size_t wOffset, size_t hOffset, src, size_t spitch, size_t width, size_t height, kind not None : cudaMemcpyKind):
    """ Copies data between host and device.

    Copies a matrix (`height` rows of `width` bytes each) from the memory
    area pointed to by `src` to the CUDA array `dst` starting at `hOffset`
    rows and `wOffset` bytes from the upper left corner, where `kind`
    specifies the direction of the copy, and must be one of
    :py:obj:`~.cudaMemcpyHostToHost`, :py:obj:`~.cudaMemcpyHostToDevice`,
    :py:obj:`~.cudaMemcpyDeviceToHost`,
    :py:obj:`~.cudaMemcpyDeviceToDevice`, or :py:obj:`~.cudaMemcpyDefault`.
    Passing :py:obj:`~.cudaMemcpyDefault` is recommended, in which case the
    type of transfer is inferred from the pointer values. However,
    :py:obj:`~.cudaMemcpyDefault` is only allowed on systems that support
    unified virtual addressing. `spitch` is the width in memory in bytes of
    the 2D array pointed to by `src`, including any padding added to the
    end of each row. `wOffset` + `width` must not exceed the width of the
    CUDA array `dst`. `width` must not exceed `spitch`.
    :py:obj:`~.cudaMemcpy2DToArray()` returns an error if `spitch` exceeds
    the maximum allowed.

    Parameters
    ----------
    dst : :py:obj:`~.cudaArray_t`
        Destination memory address
    wOffset : size_t
        Destination starting X offset (columns in bytes)
    hOffset : size_t
        Destination starting Y offset (rows)
    src : Any
        Source memory address
    spitch : size_t
        Pitch of source memory
    width : size_t
        Width of matrix transfer (columns in bytes)
    height : size_t
        Height of matrix transfer (rows)
    kind : :py:obj:`~.cudaMemcpyKind`
        Type of transfer

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidPitchValue`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpy2D`, :py:obj:`~.cudaMemcpy2DFromArray`, :py:obj:`~.cudaMemcpy2DArrayToArray`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy2DAsync`, :py:obj:`~.cudaMemcpy2DToArrayAsync`, :py:obj:`~.cudaMemcpy2DFromArrayAsync`, :py:obj:`~.cudaMemcpyToSymbolAsync`, :py:obj:`~.cudaMemcpyFromSymbolAsync`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DUnaligned`
    """
    cdef cyruntime.cudaArray_t cydst
    if dst is None:
        pdst = 0
    elif isinstance(dst, (cudaArray_t,)):
        pdst = int(dst)
    else:
        pdst = int(cudaArray_t(dst))
    cydst = <cyruntime.cudaArray_t><void_ptr>pdst
    cysrc = _HelperInputVoidPtr(src)
    cdef void* cysrc_ptr = <void*><void_ptr>cysrc.cptr
    cdef cyruntime.cudaMemcpyKind cykind = kind.value
    with nogil:
        err = cyruntime.cudaMemcpy2DToArray(cydst, wOffset, hOffset, cysrc_ptr, spitch, width, height, cykind)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpy2DFromArray(dst, size_t dpitch, src, size_t wOffset, size_t hOffset, size_t width, size_t height, kind not None : cudaMemcpyKind):
    """ Copies data between host and device.

    Copies a matrix (`height` rows of `width` bytes each) from the CUDA
    array `src` starting at `hOffset` rows and `wOffset` bytes from the
    upper left corner to the memory area pointed to by `dst`, where `kind`
    specifies the direction of the copy, and must be one of
    :py:obj:`~.cudaMemcpyHostToHost`, :py:obj:`~.cudaMemcpyHostToDevice`,
    :py:obj:`~.cudaMemcpyDeviceToHost`,
    :py:obj:`~.cudaMemcpyDeviceToDevice`, or :py:obj:`~.cudaMemcpyDefault`.
    Passing :py:obj:`~.cudaMemcpyDefault` is recommended, in which case the
    type of transfer is inferred from the pointer values. However,
    :py:obj:`~.cudaMemcpyDefault` is only allowed on systems that support
    unified virtual addressing. `dpitch` is the width in memory in bytes of
    the 2D array pointed to by `dst`, including any padding added to the
    end of each row. `wOffset` + `width` must not exceed the width of the
    CUDA array `src`. `width` must not exceed `dpitch`.
    :py:obj:`~.cudaMemcpy2DFromArray()` returns an error if `dpitch`
    exceeds the maximum allowed.

    Parameters
    ----------
    dst : Any
        Destination memory address
    dpitch : size_t
        Pitch of destination memory
    src : :py:obj:`~.cudaArray_const_t`
        Source memory address
    wOffset : size_t
        Source starting X offset (columns in bytes)
    hOffset : size_t
        Source starting Y offset (rows)
    width : size_t
        Width of matrix transfer (columns in bytes)
    height : size_t
        Height of matrix transfer (rows)
    kind : :py:obj:`~.cudaMemcpyKind`
        Type of transfer

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidPitchValue`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpy2D`, :py:obj:`~.cudaMemcpy2DToArray`, :py:obj:`~.cudaMemcpy2DArrayToArray`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy2DAsync`, :py:obj:`~.cudaMemcpy2DToArrayAsync`, :py:obj:`~.cudaMemcpy2DFromArrayAsync`, :py:obj:`~.cudaMemcpyToSymbolAsync`, :py:obj:`~.cudaMemcpyFromSymbolAsync`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DUnaligned`
    """
    cdef cyruntime.cudaArray_const_t cysrc
    if src is None:
        psrc = 0
    elif isinstance(src, (cudaArray_const_t,)):
        psrc = int(src)
    else:
        psrc = int(cudaArray_const_t(src))
    cysrc = <cyruntime.cudaArray_const_t><void_ptr>psrc
    cydst = _HelperInputVoidPtr(dst)
    cdef void* cydst_ptr = <void*><void_ptr>cydst.cptr
    cdef cyruntime.cudaMemcpyKind cykind = kind.value
    with nogil:
        err = cyruntime.cudaMemcpy2DFromArray(cydst_ptr, dpitch, cysrc, wOffset, hOffset, width, height, cykind)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpy2DArrayToArray(dst, size_t wOffsetDst, size_t hOffsetDst, src, size_t wOffsetSrc, size_t hOffsetSrc, size_t width, size_t height, kind not None : cudaMemcpyKind):
    """ Copies data between host and device.

    Copies a matrix (`height` rows of `width` bytes each) from the CUDA
    array `src` starting at `hOffsetSrc` rows and `wOffsetSrc` bytes from
    the upper left corner to the CUDA array `dst` starting at `hOffsetDst`
    rows and `wOffsetDst` bytes from the upper left corner, where `kind`
    specifies the direction of the copy, and must be one of
    :py:obj:`~.cudaMemcpyHostToHost`, :py:obj:`~.cudaMemcpyHostToDevice`,
    :py:obj:`~.cudaMemcpyDeviceToHost`,
    :py:obj:`~.cudaMemcpyDeviceToDevice`, or :py:obj:`~.cudaMemcpyDefault`.
    Passing :py:obj:`~.cudaMemcpyDefault` is recommended, in which case the
    type of transfer is inferred from the pointer values. However,
    :py:obj:`~.cudaMemcpyDefault` is only allowed on systems that support
    unified virtual addressing. `wOffsetDst` + `width` must not exceed the
    width of the CUDA array `dst`. `wOffsetSrc` + `width` must not exceed
    the width of the CUDA array `src`.

    Parameters
    ----------
    dst : :py:obj:`~.cudaArray_t`
        Destination memory address
    wOffsetDst : size_t
        Destination starting X offset (columns in bytes)
    hOffsetDst : size_t
        Destination starting Y offset (rows)
    src : :py:obj:`~.cudaArray_const_t`
        Source memory address
    wOffsetSrc : size_t
        Source starting X offset (columns in bytes)
    hOffsetSrc : size_t
        Source starting Y offset (rows)
    width : size_t
        Width of matrix transfer (columns in bytes)
    height : size_t
        Height of matrix transfer (rows)
    kind : :py:obj:`~.cudaMemcpyKind`
        Type of transfer

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpy2D`, :py:obj:`~.cudaMemcpy2DToArray`, :py:obj:`~.cudaMemcpy2DFromArray`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy2DAsync`, :py:obj:`~.cudaMemcpy2DToArrayAsync`, :py:obj:`~.cudaMemcpy2DFromArrayAsync`, :py:obj:`~.cudaMemcpyToSymbolAsync`, :py:obj:`~.cudaMemcpyFromSymbolAsync`, :py:obj:`~.cuMemcpy2D`, :py:obj:`~.cuMemcpy2DUnaligned`
    """
    cdef cyruntime.cudaArray_const_t cysrc
    if src is None:
        psrc = 0
    elif isinstance(src, (cudaArray_const_t,)):
        psrc = int(src)
    else:
        psrc = int(cudaArray_const_t(src))
    cysrc = <cyruntime.cudaArray_const_t><void_ptr>psrc
    cdef cyruntime.cudaArray_t cydst
    if dst is None:
        pdst = 0
    elif isinstance(dst, (cudaArray_t,)):
        pdst = int(dst)
    else:
        pdst = int(cudaArray_t(dst))
    cydst = <cyruntime.cudaArray_t><void_ptr>pdst
    cdef cyruntime.cudaMemcpyKind cykind = kind.value
    with nogil:
        err = cyruntime.cudaMemcpy2DArrayToArray(cydst, wOffsetDst, hOffsetDst, cysrc, wOffsetSrc, hOffsetSrc, width, height, cykind)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpyAsync(dst, src, size_t count, kind not None : cudaMemcpyKind, stream):
    """ Copies data between host and device.

    Copies `count` bytes from the memory area pointed to by `src` to the
    memory area pointed to by `dst`, where `kind` specifies the direction
    of the copy, and must be one of :py:obj:`~.cudaMemcpyHostToHost`,
    :py:obj:`~.cudaMemcpyHostToDevice`, :py:obj:`~.cudaMemcpyDeviceToHost`,
    :py:obj:`~.cudaMemcpyDeviceToDevice`, or :py:obj:`~.cudaMemcpyDefault`.
    Passing :py:obj:`~.cudaMemcpyDefault` is recommended, in which case the
    type of transfer is inferred from the pointer values. However,
    :py:obj:`~.cudaMemcpyDefault` is only allowed on systems that support
    unified virtual addressing.

    The memory areas may not overlap. Calling :py:obj:`~.cudaMemcpyAsync()`
    with `dst` and `src` pointers that do not match the direction of the
    copy results in an undefined behavior.

    :py:obj:`~.cudaMemcpyAsync()` is asynchronous with respect to the host,
    so the call may return before the copy is complete. The copy can
    optionally be associated to a stream by passing a non-zero `stream`
    argument. If `kind` is :py:obj:`~.cudaMemcpyHostToDevice` or
    :py:obj:`~.cudaMemcpyDeviceToHost` and the `stream` is non-zero, the
    copy may overlap with operations in other streams.

    The device version of this function only handles device to device
    copies and cannot be given local or shared pointers.

    Parameters
    ----------
    dst : Any
        Destination memory address
    src : Any
        Source memory address
    count : size_t
        Size in bytes to copy
    kind : :py:obj:`~.cudaMemcpyKind`
        Type of transfer
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpy2D`, :py:obj:`~.cudaMemcpy2DToArray`, :py:obj:`~.cudaMemcpy2DFromArray`, :py:obj:`~.cudaMemcpy2DArrayToArray`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`, :py:obj:`~.cudaMemcpy2DAsync`, :py:obj:`~.cudaMemcpy2DToArrayAsync`, :py:obj:`~.cudaMemcpy2DFromArrayAsync`, :py:obj:`~.cudaMemcpyToSymbolAsync`, :py:obj:`~.cudaMemcpyFromSymbolAsync`, :py:obj:`~.cuMemcpyAsync`, :py:obj:`~.cuMemcpyDtoHAsync`, :py:obj:`~.cuMemcpyHtoDAsync`, :py:obj:`~.cuMemcpyDtoDAsync`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cydst = _HelperInputVoidPtr(dst)
    cdef void* cydst_ptr = <void*><void_ptr>cydst.cptr
    cysrc = _HelperInputVoidPtr(src)
    cdef void* cysrc_ptr = <void*><void_ptr>cysrc.cptr
    cdef cyruntime.cudaMemcpyKind cykind = kind.value
    with nogil:
        err = cyruntime.cudaMemcpyAsync(cydst_ptr, cysrc_ptr, count, cykind, cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpyPeerAsync(dst, int dstDevice, src, int srcDevice, size_t count, stream):
    """ Copies memory between two devices asynchronously.

    Copies memory from one device to memory on another device. `dst` is the
    base device pointer of the destination memory and `dstDevice` is the
    destination device. `src` is the base device pointer of the source
    memory and `srcDevice` is the source device. `count` specifies the
    number of bytes to copy.

    Note that this function is asynchronous with respect to the host and
    all work on other devices.

    Parameters
    ----------
    dst : Any
        Destination device pointer
    dstDevice : int
        Destination device
    src : Any
        Source device pointer
    srcDevice : int
        Source device
    count : size_t
        Size of memory copy in bytes
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidDevice`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpyPeer`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy3DPeerAsync`, :py:obj:`~.cuMemcpyPeerAsync`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cydst = _HelperInputVoidPtr(dst)
    cdef void* cydst_ptr = <void*><void_ptr>cydst.cptr
    cysrc = _HelperInputVoidPtr(src)
    cdef void* cysrc_ptr = <void*><void_ptr>cysrc.cptr
    with nogil:
        err = cyruntime.cudaMemcpyPeerAsync(cydst_ptr, dstDevice, cysrc_ptr, srcDevice, count, cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpyBatchAsync(dsts : Optional[tuple[Any] | list[Any]], srcs : Optional[tuple[Any] | list[Any]], sizes : tuple[int] | list[int], size_t count, attrs : Optional[tuple[cudaMemcpyAttributes] | list[cudaMemcpyAttributes]], attrsIdxs : tuple[int] | list[int], size_t numAttrs, stream):
    """ Performs a batch of memory copies asynchronously.

    Performs a batch of memory copies. The batch as a whole executes in
    stream order but copies within a batch are not guaranteed to execute in
    any specific order. This API only supports pointer-to-pointer copies.
    For copies involving CUDA arrays, please see
    :py:obj:`~.cudaMemcpy3DBatchAsync`.

    Performs memory copies from source buffers specified in `srcs` to
    destination buffers specified in `dsts`. The size of each copy is
    specified in `sizes`. All three arrays must be of the same length as
    specified by `count`. Since there are no ordering guarantees for copies
    within a batch, specifying any dependent copies within a batch will
    result in undefined behavior.

    Every copy in the batch has to be associated with a set of attributes
    specified in the `attrs` array. Each entry in this array can apply to
    more than one copy. This can be done by specifying in the `attrsIdxs`
    array, the index of the first copy that the corresponding entry in the
    `attrs` array applies to. Both `attrs` and `attrsIdxs` must be of the
    same length as specified by `numAttrs`. For example, if a batch has 10
    copies listed in dst/src/sizes, the first 6 of which have one set of
    attributes and the remaining 4 another, then `numAttrs` will be 2,
    `attrsIdxs` will be {0, 6} and `attrs` will contains the two sets of
    attributes. Note that the first entry in `attrsIdxs` must always be 0.
    Also, each entry must be greater than the previous entry and the last
    entry should be less than `count`. Furthermore, `numAttrs` must be
    lesser than or equal to `count`.

    The :py:obj:`~.cudaMemcpyAttributes.srcAccessOrder` indicates the
    source access ordering to be observed for copies associated with the
    attribute. If the source access order is set to
    :py:obj:`~.cudaMemcpySrcAccessOrderStream`, then the source will be
    accessed in stream order. If the source access order is set to
    :py:obj:`~.cudaMemcpySrcAccessOrderDuringApiCall` then it indicates
    that access to the source pointer can be out of stream order and all
    accesses must be complete before the API call returns. This flag is
    suited for ephemeral sources (ex., stack variables) when it's known
    that no prior operations in the stream can be accessing the memory and
    also that the lifetime of the memory is limited to the scope that the
    source variable was declared in. Specifying this flag allows the driver
    to optimize the copy and removes the need for the user to synchronize
    the stream after the API call. If the source access order is set to
    :py:obj:`~.cudaMemcpySrcAccessOrderAny` then it indicates that access
    to the source pointer can be out of stream order and the accesses can
    happen even after the API call returns. This flag is suited for host
    pointers allocated outside CUDA (ex., via malloc) when it's known that
    no prior operations in the stream can be accessing the memory.
    Specifying this flag allows the driver to optimize the copy on certain
    platforms. Each memcpy operation in the batch must have a valid
    :py:obj:`~.cudaMemcpyAttributes` corresponding to it including the
    appropriate srcAccessOrder setting, otherwise the API will return
    :py:obj:`~.cudaErrorInvalidValue`.

    The :py:obj:`~.cudaMemcpyAttributes.srcLocHint` and
    :py:obj:`~.cudaMemcpyAttributes.dstLocHint` allows applications to
    specify hint locations for operands of a copy when the operand doesn't
    have a fixed location. That is, these hints are only applicable for
    managed memory pointers on devices where
    :py:obj:`~.cudaDevAttrConcurrentManagedAccess` is true or system-
    allocated pageable memory on devices where
    :py:obj:`~.cudaDevAttrPageableMemoryAccess` is true. For other cases,
    these hints are ignored.

    The :py:obj:`~.cudaMemcpyAttributes.flags` field can be used to specify
    certain flags for copies. Setting the
    :py:obj:`~.cudaMemcpyFlagPreferOverlapWithCompute` flag indicates that
    the associated copies should preferably overlap with any compute work.
    Note that this flag is a hint and can be ignored depending on the
    platform and other parameters of the copy.

    Parameters
    ----------
    dsts : list[Any]
        Array of destination pointers.
    srcs : list[Any]
        Array of memcpy source pointers.
    sizes : list[int]
        Array of sizes for memcpy operations.
    count : size_t
        Size of `dsts`, `srcs` and `sizes` arrays
    attrs : list[:py:obj:`~.cudaMemcpyAttributes`]
        Array of memcpy attributes.
    attrsIdxs : list[int]
        Array of indices to specify which copies each entry in the `attrs`
        array applies to. The attributes specified in attrs[k] will be
        applied to copies starting from attrsIdxs[k] through attrsIdxs[k+1]
        - 1. Also attrs[numAttrs-1] will apply to copies starting from
        attrsIdxs[numAttrs-1] through count - 1.
    numAttrs : size_t
        Size of `attrs` and `attrsIdxs` arrays.
    hStream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        The stream to enqueue the operations in. Must not be legacy NULL
        stream.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess` :py:obj:`~.cudaErrorInvalidValue`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    if not all(isinstance(_x, (int)) for _x in attrsIdxs):
        raise TypeError("Argument 'attrsIdxs' is not instance of type (expected tuple[int] or list[int]")
    attrs = [] if attrs is None else attrs
    if not all(isinstance(_x, (cudaMemcpyAttributes,)) for _x in attrs):
        raise TypeError("Argument 'attrs' is not instance of type (expected tuple[cyruntime.cudaMemcpyAttributes,] or list[cyruntime.cudaMemcpyAttributes,]")
    if not all(isinstance(_x, (int)) for _x in sizes):
        raise TypeError("Argument 'sizes' is not instance of type (expected tuple[int] or list[int]")
    srcs = [] if srcs is None else srcs
    dsts = [] if dsts is None else dsts
    pylist = [_HelperInputVoidPtr(pydsts) for pydsts in dsts]
    cdef _InputVoidPtrPtrHelper voidStarHelperdsts = _InputVoidPtrPtrHelper(pylist)
    cdef const void** cydsts_ptr = <const void**><void_ptr>voidStarHelperdsts.cptr
    pylist = [_HelperInputVoidPtr(pysrcs) for pysrcs in srcs]
    cdef _InputVoidPtrPtrHelper voidStarHelpersrcs = _InputVoidPtrPtrHelper(pylist)
    cdef const void** cysrcs_ptr = <const void**><void_ptr>voidStarHelpersrcs.cptr
    cdef vector[size_t] cysizes = sizes
    if count > <size_t>len(dsts): raise RuntimeError("List is too small: " + str(len(dsts)) + " < " + str(count))
    if count > <size_t>len(srcs): raise RuntimeError("List is too small: " + str(len(srcs)) + " < " + str(count))
    if count > <size_t>len(sizes): raise RuntimeError("List is too small: " + str(len(sizes)) + " < " + str(count))
    cdef cyruntime.cudaMemcpyAttributes* cyattrs = NULL
    if len(attrs) > 1:
        cyattrs = <cyruntime.cudaMemcpyAttributes*> calloc(len(attrs), sizeof(cyruntime.cudaMemcpyAttributes))
        if cyattrs is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(attrs)) + 'x' + str(sizeof(cyruntime.cudaMemcpyAttributes)))
        for idx in range(len(attrs)):
            string.memcpy(&cyattrs[idx], (<cudaMemcpyAttributes>attrs[idx])._pvt_ptr, sizeof(cyruntime.cudaMemcpyAttributes))
    elif len(attrs) == 1:
        cyattrs = (<cudaMemcpyAttributes>attrs[0])._pvt_ptr
    cdef vector[size_t] cyattrsIdxs = attrsIdxs
    if numAttrs > <size_t>len(attrs): raise RuntimeError("List is too small: " + str(len(attrs)) + " < " + str(numAttrs))
    if numAttrs > <size_t>len(attrsIdxs): raise RuntimeError("List is too small: " + str(len(attrsIdxs)) + " < " + str(numAttrs))
    with nogil:
        err = cyruntime.cudaMemcpyBatchAsync(cydsts_ptr, cysrcs_ptr, cysizes.data(), count, cyattrs, cyattrsIdxs.data(), numAttrs, cystream)
    if len(attrs) > 1 and cyattrs is not NULL:
        free(cyattrs)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpy3DBatchAsync(size_t numOps, opList : Optional[tuple[cudaMemcpy3DBatchOp] | list[cudaMemcpy3DBatchOp]], unsigned long long flags, stream):
    """ Performs a batch of 3D memory copies asynchronously.

    Performs a batch of memory copies. The batch as a whole executes in
    stream order but copies within a batch are not guaranteed to execute in
    any specific order. Note that this means specifying any dependent
    copies within a batch will result in undefined behavior.

    Performs memory copies as specified in the `opList` array. The length
    of this array is specified in `numOps`. Each entry in this array
    describes a copy operation. This includes among other things, the
    source and destination operands for the copy as specified in
    :py:obj:`~.cudaMemcpy3DBatchOp.src` and
    :py:obj:`~.cudaMemcpy3DBatchOp.dst` respectively. The source and
    destination operands of a copy can either be a pointer or a CUDA array.
    The width, height and depth of a copy is specified in
    :py:obj:`~.cudaMemcpy3DBatchOp.extent`. The width, height and depth of
    a copy are specified in elements and must not be zero. For pointer-to-
    pointer copies, the element size is considered to be 1. For pointer to
    CUDA array or vice versa copies, the element size is determined by the
    CUDA array. For CUDA array to CUDA array copies, the element size of
    the two CUDA arrays must match.

    For a given operand, if :py:obj:`~.cudaMemcpy3DOperand`::type is
    specified as :py:obj:`~.cudaMemcpyOperandTypePointer`, then
    :py:obj:`~.cudaMemcpy3DOperand`::op::ptr will be used. The
    :py:obj:`~.cudaMemcpy3DOperand`::op::ptr::ptr field must contain the
    pointer where the copy should begin. The
    :py:obj:`~.cudaMemcpy3DOperand`::op::ptr::rowLength field specifies the
    length of each row in elements and must either be zero or be greater
    than or equal to the width of the copy specified in
    :py:obj:`~.cudaMemcpy3DBatchOp`::extent::width. The
    :py:obj:`~.cudaMemcpy3DOperand`::op::ptr::layerHeight field specifies
    the height of each layer and must either be zero or be greater than or
    equal to the height of the copy specified in
    :py:obj:`~.cudaMemcpy3DBatchOp`::extent::height. When either of these
    values is zero, that aspect of the operand is considered to be tightly
    packed according to the copy extent. For managed memory pointers on
    devices where :py:obj:`~.cudaDevAttrConcurrentManagedAccess` is true or
    system-allocated pageable memory on devices where
    :py:obj:`~.cudaDevAttrPageableMemoryAccess` is true, the
    :py:obj:`~.cudaMemcpy3DOperand`::op::ptr::locHint field can be used to
    hint the location of the operand.

    If an operand's type is specified as
    :py:obj:`~.cudaMemcpyOperandTypeArray`, then
    :py:obj:`~.cudaMemcpy3DOperand`::op::array will be used. The
    :py:obj:`~.cudaMemcpy3DOperand`::op::array::array field specifies the
    CUDA array and :py:obj:`~.cudaMemcpy3DOperand`::op::array::offset
    specifies the 3D offset into that array where the copy begins.

    The :py:obj:`~.cudaMemcpyAttributes.srcAccessOrder` indicates the
    source access ordering to be observed for copies associated with the
    attribute. If the source access order is set to
    :py:obj:`~.cudaMemcpySrcAccessOrderStream`, then the source will be
    accessed in stream order. If the source access order is set to
    :py:obj:`~.cudaMemcpySrcAccessOrderDuringApiCall` then it indicates
    that access to the source pointer can be out of stream order and all
    accesses must be complete before the API call returns. This flag is
    suited for ephemeral sources (ex., stack variables) when it's known
    that no prior operations in the stream can be accessing the memory and
    also that the lifetime of the memory is limited to the scope that the
    source variable was declared in. Specifying this flag allows the driver
    to optimize the copy and removes the need for the user to synchronize
    the stream after the API call. If the source access order is set to
    :py:obj:`~.cudaMemcpySrcAccessOrderAny` then it indicates that access
    to the source pointer can be out of stream order and the accesses can
    happen even after the API call returns. This flag is suited for host
    pointers allocated outside CUDA (ex., via malloc) when it's known that
    no prior operations in the stream can be accessing the memory.
    Specifying this flag allows the driver to optimize the copy on certain
    platforms. Each memcopy operation in `opList` must have a valid
    srcAccessOrder setting, otherwise this API will return
    :py:obj:`~.cudaErrorInvalidValue`.

    The :py:obj:`~.cudaMemcpyAttributes.flags` field can be used to specify
    certain flags for copies. Setting the
    :py:obj:`~.cudaMemcpyFlagPreferOverlapWithCompute` flag indicates that
    the associated copies should preferably overlap with any compute work.
    Note that this flag is a hint and can be ignored depending on the
    platform and other parameters of the copy.

    Parameters
    ----------
    numOps : size_t
        Total number of memcpy operations.
    opList : list[:py:obj:`~.cudaMemcpy3DBatchOp`]
        Array of size `numOps` containing the actual memcpy operations.
    flags : unsigned long long
        Flags for future use, must be zero now.
    hStream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        The stream to enqueue the operations in. Must not be default NULL
        stream.

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess` :py:obj:`~.cudaErrorInvalidValue`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    opList = [] if opList is None else opList
    if not all(isinstance(_x, (cudaMemcpy3DBatchOp,)) for _x in opList):
        raise TypeError("Argument 'opList' is not instance of type (expected tuple[cyruntime.cudaMemcpy3DBatchOp,] or list[cyruntime.cudaMemcpy3DBatchOp,]")
    if numOps > <size_t>len(opList): raise RuntimeError("List is too small: " + str(len(opList)) + " < " + str(numOps))
    cdef cyruntime.cudaMemcpy3DBatchOp* cyopList = NULL
    if len(opList) > 1:
        cyopList = <cyruntime.cudaMemcpy3DBatchOp*> calloc(len(opList), sizeof(cyruntime.cudaMemcpy3DBatchOp))
        if cyopList is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(opList)) + 'x' + str(sizeof(cyruntime.cudaMemcpy3DBatchOp)))
        for idx in range(len(opList)):
            string.memcpy(&cyopList[idx], (<cudaMemcpy3DBatchOp>opList[idx])._pvt_ptr, sizeof(cyruntime.cudaMemcpy3DBatchOp))
    elif len(opList) == 1:
        cyopList = (<cudaMemcpy3DBatchOp>opList[0])._pvt_ptr
    with nogil:
        err = cyruntime.cudaMemcpy3DBatchAsync(numOps, cyopList, flags, cystream)
    if len(opList) > 1 and cyopList is not NULL:
        free(cyopList)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpy2DAsync(dst, size_t dpitch, src, size_t spitch, size_t width, size_t height, kind not None : cudaMemcpyKind, stream):
    """ Copies data between host and device.

    Copies a matrix (`height` rows of `width` bytes each) from the memory
    area pointed to by `src` to the memory area pointed to by `dst`, where
    `kind` specifies the direction of the copy, and must be one of
    :py:obj:`~.cudaMemcpyHostToHost`, :py:obj:`~.cudaMemcpyHostToDevice`,
    :py:obj:`~.cudaMemcpyDeviceToHost`,
    :py:obj:`~.cudaMemcpyDeviceToDevice`, or :py:obj:`~.cudaMemcpyDefault`.
    Passing :py:obj:`~.cudaMemcpyDefault` is recommended, in which case the
    type of transfer is inferred from the pointer values. However,
    :py:obj:`~.cudaMemcpyDefault` is only allowed on systems that support
    unified virtual addressing. `dpitch` and `spitch` are the widths in
    memory in bytes of the 2D arrays pointed to by `dst` and `src`,
    including any padding added to the end of each row. The memory areas
    may not overlap. `width` must not exceed either `dpitch` or `spitch`.

    Calling :py:obj:`~.cudaMemcpy2DAsync()` with `dst` and `src` pointers
    that do not match the direction of the copy results in an undefined
    behavior. :py:obj:`~.cudaMemcpy2DAsync()` returns an error if `dpitch`
    or `spitch` is greater than the maximum allowed.

    :py:obj:`~.cudaMemcpy2DAsync()` is asynchronous with respect to the
    host, so the call may return before the copy is complete. The copy can
    optionally be associated to a stream by passing a non-zero `stream`
    argument. If `kind` is :py:obj:`~.cudaMemcpyHostToDevice` or
    :py:obj:`~.cudaMemcpyDeviceToHost` and `stream` is non-zero, the copy
    may overlap with operations in other streams.

    The device version of this function only handles device to device
    copies and cannot be given local or shared pointers.

    Parameters
    ----------
    dst : Any
        Destination memory address
    dpitch : size_t
        Pitch of destination memory
    src : Any
        Source memory address
    spitch : size_t
        Pitch of source memory
    width : size_t
        Width of matrix transfer (columns in bytes)
    height : size_t
        Height of matrix transfer (rows)
    kind : :py:obj:`~.cudaMemcpyKind`
        Type of transfer
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidPitchValue`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpy2D`, :py:obj:`~.cudaMemcpy2DToArray`, :py:obj:`~.cudaMemcpy2DFromArray`, :py:obj:`~.cudaMemcpy2DArrayToArray`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy2DToArrayAsync`, :py:obj:`~.cudaMemcpy2DFromArrayAsync`, :py:obj:`~.cudaMemcpyToSymbolAsync`, :py:obj:`~.cudaMemcpyFromSymbolAsync`, :py:obj:`~.cuMemcpy2DAsync`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cydst = _HelperInputVoidPtr(dst)
    cdef void* cydst_ptr = <void*><void_ptr>cydst.cptr
    cysrc = _HelperInputVoidPtr(src)
    cdef void* cysrc_ptr = <void*><void_ptr>cysrc.cptr
    cdef cyruntime.cudaMemcpyKind cykind = kind.value
    with nogil:
        err = cyruntime.cudaMemcpy2DAsync(cydst_ptr, dpitch, cysrc_ptr, spitch, width, height, cykind, cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpy2DToArrayAsync(dst, size_t wOffset, size_t hOffset, src, size_t spitch, size_t width, size_t height, kind not None : cudaMemcpyKind, stream):
    """ Copies data between host and device.

    Copies a matrix (`height` rows of `width` bytes each) from the memory
    area pointed to by `src` to the CUDA array `dst` starting at `hOffset`
    rows and `wOffset` bytes from the upper left corner, where `kind`
    specifies the direction of the copy, and must be one of
    :py:obj:`~.cudaMemcpyHostToHost`, :py:obj:`~.cudaMemcpyHostToDevice`,
    :py:obj:`~.cudaMemcpyDeviceToHost`,
    :py:obj:`~.cudaMemcpyDeviceToDevice`, or :py:obj:`~.cudaMemcpyDefault`.
    Passing :py:obj:`~.cudaMemcpyDefault` is recommended, in which case the
    type of transfer is inferred from the pointer values. However,
    :py:obj:`~.cudaMemcpyDefault` is only allowed on systems that support
    unified virtual addressing. `spitch` is the width in memory in bytes of
    the 2D array pointed to by `src`, including any padding added to the
    end of each row. `wOffset` + `width` must not exceed the width of the
    CUDA array `dst`. `width` must not exceed `spitch`.
    :py:obj:`~.cudaMemcpy2DToArrayAsync()` returns an error if `spitch`
    exceeds the maximum allowed.

    :py:obj:`~.cudaMemcpy2DToArrayAsync()` is asynchronous with respect to
    the host, so the call may return before the copy is complete. The copy
    can optionally be associated to a stream by passing a non-zero `stream`
    argument. If `kind` is :py:obj:`~.cudaMemcpyHostToDevice` or
    :py:obj:`~.cudaMemcpyDeviceToHost` and `stream` is non-zero, the copy
    may overlap with operations in other streams.

    :py:obj:`~.cudaMemcpy2DFromArrayAsync`,
    :py:obj:`~.cudaMemcpyToSymbolAsync`,
    :py:obj:`~.cudaMemcpyFromSymbolAsync`, :py:obj:`~.cuMemcpy2DAsync`

    Parameters
    ----------
    dst : :py:obj:`~.cudaArray_t`
        Destination memory address
    wOffset : size_t
        Destination starting X offset (columns in bytes)
    hOffset : size_t
        Destination starting Y offset (rows)
    src : Any
        Source memory address
    spitch : size_t
        Pitch of source memory
    width : size_t
        Width of matrix transfer (columns in bytes)
    height : size_t
        Height of matrix transfer (rows)
    kind : :py:obj:`~.cudaMemcpyKind`
        Type of transfer
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidPitchValue`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpy2D`, :py:obj:`~.cudaMemcpy2DToArray`, :py:obj:`~.cudaMemcpy2DFromArray`, :py:obj:`~.cudaMemcpy2DArrayToArray`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy2DAsync`,
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cdef cyruntime.cudaArray_t cydst
    if dst is None:
        pdst = 0
    elif isinstance(dst, (cudaArray_t,)):
        pdst = int(dst)
    else:
        pdst = int(cudaArray_t(dst))
    cydst = <cyruntime.cudaArray_t><void_ptr>pdst
    cysrc = _HelperInputVoidPtr(src)
    cdef void* cysrc_ptr = <void*><void_ptr>cysrc.cptr
    cdef cyruntime.cudaMemcpyKind cykind = kind.value
    with nogil:
        err = cyruntime.cudaMemcpy2DToArrayAsync(cydst, wOffset, hOffset, cysrc_ptr, spitch, width, height, cykind, cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemcpy2DFromArrayAsync(dst, size_t dpitch, src, size_t wOffset, size_t hOffset, size_t width, size_t height, kind not None : cudaMemcpyKind, stream):
    """ Copies data between host and device.

    Copies a matrix (`height` rows of `width` bytes each) from the CUDA
    array `src` starting at `hOffset` rows and `wOffset` bytes from the
    upper left corner to the memory area pointed to by `dst`, where `kind`
    specifies the direction of the copy, and must be one of
    :py:obj:`~.cudaMemcpyHostToHost`, :py:obj:`~.cudaMemcpyHostToDevice`,
    :py:obj:`~.cudaMemcpyDeviceToHost`,
    :py:obj:`~.cudaMemcpyDeviceToDevice`, or :py:obj:`~.cudaMemcpyDefault`.
    Passing :py:obj:`~.cudaMemcpyDefault` is recommended, in which case the
    type of transfer is inferred from the pointer values. However,
    :py:obj:`~.cudaMemcpyDefault` is only allowed on systems that support
    unified virtual addressing. `dpitch` is the width in memory in bytes of
    the 2D array pointed to by `dst`, including any padding added to the
    end of each row. `wOffset` + `width` must not exceed the width of the
    CUDA array `src`. `width` must not exceed `dpitch`.
    :py:obj:`~.cudaMemcpy2DFromArrayAsync()` returns an error if `dpitch`
    exceeds the maximum allowed.

    :py:obj:`~.cudaMemcpy2DFromArrayAsync()` is asynchronous with respect
    to the host, so the call may return before the copy is complete. The
    copy can optionally be associated to a stream by passing a non-zero
    `stream` argument. If `kind` is :py:obj:`~.cudaMemcpyHostToDevice` or
    :py:obj:`~.cudaMemcpyDeviceToHost` and `stream` is non-zero, the copy
    may overlap with operations in other streams.

    :py:obj:`~.cudaMemcpyToSymbolAsync`,
    :py:obj:`~.cudaMemcpyFromSymbolAsync`, :py:obj:`~.cuMemcpy2DAsync`

    Parameters
    ----------
    dst : Any
        Destination memory address
    dpitch : size_t
        Pitch of destination memory
    src : :py:obj:`~.cudaArray_const_t`
        Source memory address
    wOffset : size_t
        Source starting X offset (columns in bytes)
    hOffset : size_t
        Source starting Y offset (rows)
    width : size_t
        Width of matrix transfer (columns in bytes)
    height : size_t
        Height of matrix transfer (rows)
    kind : :py:obj:`~.cudaMemcpyKind`
        Type of transfer
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidPitchValue`, :py:obj:`~.cudaErrorInvalidMemcpyDirection`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpy2D`, :py:obj:`~.cudaMemcpy2DToArray`, :py:obj:`~.cudaMemcpy2DFromArray`, :py:obj:`~.cudaMemcpy2DArrayToArray`, :py:obj:`~.cudaMemcpyToSymbol`, :py:obj:`~.cudaMemcpyFromSymbol`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy2DAsync`, :py:obj:`~.cudaMemcpy2DToArrayAsync`,
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cdef cyruntime.cudaArray_const_t cysrc
    if src is None:
        psrc = 0
    elif isinstance(src, (cudaArray_const_t,)):
        psrc = int(src)
    else:
        psrc = int(cudaArray_const_t(src))
    cysrc = <cyruntime.cudaArray_const_t><void_ptr>psrc
    cydst = _HelperInputVoidPtr(dst)
    cdef void* cydst_ptr = <void*><void_ptr>cydst.cptr
    cdef cyruntime.cudaMemcpyKind cykind = kind.value
    with nogil:
        err = cyruntime.cudaMemcpy2DFromArrayAsync(cydst_ptr, dpitch, cysrc, wOffset, hOffset, width, height, cykind, cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemset(devPtr, int value, size_t count):
    """ Initializes or sets device memory to a value.

    Fills the first `count` bytes of the memory area pointed to by `devPtr`
    with the constant byte value `value`.

    Note that this function is asynchronous with respect to the host unless
    `devPtr` refers to pinned host memory.

    Parameters
    ----------
    devPtr : Any
        Pointer to device memory
    value : int
        Value to set for each byte of specified memory
    count : size_t
        Size in bytes to set

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`,

    See Also
    --------
    :py:obj:`~.cuMemsetD8`, :py:obj:`~.cuMemsetD16`, :py:obj:`~.cuMemsetD32`
    """
    cydevPtr = _HelperInputVoidPtr(devPtr)
    cdef void* cydevPtr_ptr = <void*><void_ptr>cydevPtr.cptr
    with nogil:
        err = cyruntime.cudaMemset(cydevPtr_ptr, value, count)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemset2D(devPtr, size_t pitch, int value, size_t width, size_t height):
    """ Initializes or sets device memory to a value.

    Sets to the specified value `value` a matrix (`height` rows of `width`
    bytes each) pointed to by `dstPtr`. `pitch` is the width in bytes of
    the 2D array pointed to by `dstPtr`, including any padding added to the
    end of each row. This function performs fastest when the pitch is one
    that has been passed back by :py:obj:`~.cudaMallocPitch()`.

    Note that this function is asynchronous with respect to the host unless
    `devPtr` refers to pinned host memory.

    Parameters
    ----------
    devPtr : Any
        Pointer to 2D device memory
    pitch : size_t
        Pitch in bytes of 2D device memory(Unused if `height` is 1)
    value : int
        Value to set for each byte of specified memory
    width : size_t
        Width of matrix set (columns in bytes)
    height : size_t
        Height of matrix set (rows)

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`,

    See Also
    --------
    :py:obj:`~.cudaMemset`, :py:obj:`~.cudaMemset3D`, :py:obj:`~.cudaMemsetAsync`, :py:obj:`~.cudaMemset2DAsync`, :py:obj:`~.cudaMemset3DAsync`, :py:obj:`~.cuMemsetD2D8`, :py:obj:`~.cuMemsetD2D16`, :py:obj:`~.cuMemsetD2D32`
    """
    cydevPtr = _HelperInputVoidPtr(devPtr)
    cdef void* cydevPtr_ptr = <void*><void_ptr>cydevPtr.cptr
    with nogil:
        err = cyruntime.cudaMemset2D(cydevPtr_ptr, pitch, value, width, height)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemset3D(pitchedDevPtr not None : cudaPitchedPtr, int value, extent not None : cudaExtent):
    """ Initializes or sets device memory to a value.

    Initializes each element of a 3D array to the specified value `value`.
    The object to initialize is defined by `pitchedDevPtr`. The `pitch`
    field of `pitchedDevPtr` is the width in memory in bytes of the 3D
    array pointed to by `pitchedDevPtr`, including any padding added to the
    end of each row. The `xsize` field specifies the logical width of each
    row in bytes, while the `ysize` field specifies the height of each 2D
    slice in rows. The `pitch` field of `pitchedDevPtr` is ignored when
    `height` and `depth` are both equal to 1.

    The extents of the initialized region are specified as a `width` in
    bytes, a `height` in rows, and a `depth` in slices.

    Extents with `width` greater than or equal to the `xsize` of
    `pitchedDevPtr` may perform significantly faster than extents narrower
    than the `xsize`. Secondarily, extents with `height` equal to the
    `ysize` of `pitchedDevPtr` will perform faster than when the `height`
    is shorter than the `ysize`.

    This function performs fastest when the `pitchedDevPtr` has been
    allocated by :py:obj:`~.cudaMalloc3D()`.

    Note that this function is asynchronous with respect to the host unless
    `pitchedDevPtr` refers to pinned host memory.

    Parameters
    ----------
    pitchedDevPtr : :py:obj:`~.cudaPitchedPtr`
        Pointer to pitched device memory
    value : int
        Value to set for each byte of specified memory
    extent : :py:obj:`~.cudaExtent`
        Size parameters for where to set device memory (`width` field in
        bytes)

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`,

    See Also
    --------
    :py:obj:`~.cudaMemset`, :py:obj:`~.cudaMemset2D`, :py:obj:`~.cudaMemsetAsync`, :py:obj:`~.cudaMemset2DAsync`, :py:obj:`~.cudaMemset3DAsync`, :py:obj:`~.cudaMalloc3D`, :py:obj:`~.make_cudaPitchedPtr`, :py:obj:`~.make_cudaExtent`
    """
    with nogil:
        err = cyruntime.cudaMemset3D(pitchedDevPtr._pvt_ptr[0], value, extent._pvt_ptr[0])
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemsetAsync(devPtr, int value, size_t count, stream):
    """ Initializes or sets device memory to a value.

    Fills the first `count` bytes of the memory area pointed to by `devPtr`
    with the constant byte value `value`.

    :py:obj:`~.cudaMemsetAsync()` is asynchronous with respect to the host,
    so the call may return before the memset is complete. The operation can
    optionally be associated to a stream by passing a non-zero `stream`
    argument. If `stream` is non-zero, the operation may overlap with
    operations in other streams.

    The device version of this function only handles device to device
    copies and cannot be given local or shared pointers.

    Parameters
    ----------
    devPtr : Any
        Pointer to device memory
    value : int
        Value to set for each byte of specified memory
    count : size_t
        Size in bytes to set
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`,

    See Also
    --------
    :py:obj:`~.cudaMemset`, :py:obj:`~.cudaMemset2D`, :py:obj:`~.cudaMemset3D`, :py:obj:`~.cudaMemset2DAsync`, :py:obj:`~.cudaMemset3DAsync`, :py:obj:`~.cuMemsetD8Async`, :py:obj:`~.cuMemsetD16Async`, :py:obj:`~.cuMemsetD32Async`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cydevPtr = _HelperInputVoidPtr(devPtr)
    cdef void* cydevPtr_ptr = <void*><void_ptr>cydevPtr.cptr
    with nogil:
        err = cyruntime.cudaMemsetAsync(cydevPtr_ptr, value, count, cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemset2DAsync(devPtr, size_t pitch, int value, size_t width, size_t height, stream):
    """ Initializes or sets device memory to a value.

    Sets to the specified value `value` a matrix (`height` rows of `width`
    bytes each) pointed to by `dstPtr`. `pitch` is the width in bytes of
    the 2D array pointed to by `dstPtr`, including any padding added to the
    end of each row. This function performs fastest when the pitch is one
    that has been passed back by :py:obj:`~.cudaMallocPitch()`.

    :py:obj:`~.cudaMemset2DAsync()` is asynchronous with respect to the
    host, so the call may return before the memset is complete. The
    operation can optionally be associated to a stream by passing a non-
    zero `stream` argument. If `stream` is non-zero, the operation may
    overlap with operations in other streams.

    The device version of this function only handles device to device
    copies and cannot be given local or shared pointers.

    Parameters
    ----------
    devPtr : Any
        Pointer to 2D device memory
    pitch : size_t
        Pitch in bytes of 2D device memory(Unused if `height` is 1)
    value : int
        Value to set for each byte of specified memory
    width : size_t
        Width of matrix set (columns in bytes)
    height : size_t
        Height of matrix set (rows)
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`,

    See Also
    --------
    :py:obj:`~.cudaMemset`, :py:obj:`~.cudaMemset2D`, :py:obj:`~.cudaMemset3D`, :py:obj:`~.cudaMemsetAsync`, :py:obj:`~.cudaMemset3DAsync`, :py:obj:`~.cuMemsetD2D8Async`, :py:obj:`~.cuMemsetD2D16Async`, :py:obj:`~.cuMemsetD2D32Async`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cydevPtr = _HelperInputVoidPtr(devPtr)
    cdef void* cydevPtr_ptr = <void*><void_ptr>cydevPtr.cptr
    with nogil:
        err = cyruntime.cudaMemset2DAsync(cydevPtr_ptr, pitch, value, width, height, cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemset3DAsync(pitchedDevPtr not None : cudaPitchedPtr, int value, extent not None : cudaExtent, stream):
    """ Initializes or sets device memory to a value.

    Initializes each element of a 3D array to the specified value `value`.
    The object to initialize is defined by `pitchedDevPtr`. The `pitch`
    field of `pitchedDevPtr` is the width in memory in bytes of the 3D
    array pointed to by `pitchedDevPtr`, including any padding added to the
    end of each row. The `xsize` field specifies the logical width of each
    row in bytes, while the `ysize` field specifies the height of each 2D
    slice in rows. The `pitch` field of `pitchedDevPtr` is ignored when
    `height` and `depth` are both equal to 1.

    The extents of the initialized region are specified as a `width` in
    bytes, a `height` in rows, and a `depth` in slices.

    Extents with `width` greater than or equal to the `xsize` of
    `pitchedDevPtr` may perform significantly faster than extents narrower
    than the `xsize`. Secondarily, extents with `height` equal to the
    `ysize` of `pitchedDevPtr` will perform faster than when the `height`
    is shorter than the `ysize`.

    This function performs fastest when the `pitchedDevPtr` has been
    allocated by :py:obj:`~.cudaMalloc3D()`.

    :py:obj:`~.cudaMemset3DAsync()` is asynchronous with respect to the
    host, so the call may return before the memset is complete. The
    operation can optionally be associated to a stream by passing a non-
    zero `stream` argument. If `stream` is non-zero, the operation may
    overlap with operations in other streams.

    The device version of this function only handles device to device
    copies and cannot be given local or shared pointers.

    Parameters
    ----------
    pitchedDevPtr : :py:obj:`~.cudaPitchedPtr`
        Pointer to pitched device memory
    value : int
        Value to set for each byte of specified memory
    extent : :py:obj:`~.cudaExtent`
        Size parameters for where to set device memory (`width` field in
        bytes)
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream identifier

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`,

    See Also
    --------
    :py:obj:`~.cudaMemset`, :py:obj:`~.cudaMemset2D`, :py:obj:`~.cudaMemset3D`, :py:obj:`~.cudaMemsetAsync`, :py:obj:`~.cudaMemset2DAsync`, :py:obj:`~.cudaMalloc3D`, :py:obj:`~.make_cudaPitchedPtr`, :py:obj:`~.make_cudaExtent`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    with nogil:
        err = cyruntime.cudaMemset3DAsync(pitchedDevPtr._pvt_ptr[0], value, extent._pvt_ptr[0], cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemPrefetchAsync(devPtr, size_t count, location not None : cudaMemLocation, unsigned int flags, stream):
    """ Prefetches memory to the specified destination location.

    Prefetches memory to the specified destination location. `devPtr` is
    the base device pointer of the memory to be prefetched and `location`
    specifies the destination location. `count` specifies the number of
    bytes to copy. `stream` is the stream in which the operation is
    enqueued. The memory range must refer to managed memory allocated via
    :py:obj:`~.cudaMallocManaged` or declared via managed variables, or it
    may also refer to memory allocated from a managed memory pool, or it
    may also refer to system-allocated memory on systems with non-zero
    cudaDevAttrPageableMemoryAccess.

    Specifying :py:obj:`~.cudaMemLocationTypeDevice` for
    :py:obj:`~.cudaMemLocation.type` will prefetch memory to GPU specified
    by device ordinal :py:obj:`~.cudaMemLocation.id` which must have non-
    zero value for the device attribute
    :py:obj:`~.concurrentManagedAccess`. Additionally, `stream` must be
    associated with a device that has a non-zero value for the device
    attribute :py:obj:`~.concurrentManagedAccess`. Specifying
    :py:obj:`~.cudaMemLocationTypeHost` as :py:obj:`~.cudaMemLocation.type`
    will prefetch data to host memory. Applications can request prefetching
    memory to a specific host NUMA node by specifying
    :py:obj:`~.cudaMemLocationTypeHostNuma` for
    :py:obj:`~.cudaMemLocation.type` and a valid host NUMA node id in
    :py:obj:`~.cudaMemLocation.id` Users can also request prefetching
    memory to the host NUMA node closest to the current thread's CPU by
    specifying :py:obj:`~.cudaMemLocationTypeHostNumaCurrent` for
    :py:obj:`~.cudaMemLocation.type`. Note when
    :py:obj:`~.cudaMemLocation.type` is etiher
    :py:obj:`~.cudaMemLocationTypeHost` OR
    :py:obj:`~.cudaMemLocationTypeHostNumaCurrent`,
    :py:obj:`~.cudaMemLocation.id` will be ignored.

    The start address and end address of the memory range will be rounded
    down and rounded up respectively to be aligned to CPU page size before
    the prefetch operation is enqueued in the stream.

    If no physical memory has been allocated for this region, then this
    memory region will be populated and mapped on the destination device.
    If there's insufficient memory to prefetch the desired region, the
    Unified Memory driver may evict pages from other
    :py:obj:`~.cudaMallocManaged` allocations to host memory in order to
    make room. Device memory allocated using :py:obj:`~.cudaMalloc` or
    :py:obj:`~.cudaMallocArray` will not be evicted.

    By default, any mappings to the previous location of the migrated pages
    are removed and mappings for the new location are only setup on the
    destination location. The exact behavior however also depends on the
    settings applied to this memory range via :py:obj:`~.cuMemAdvise` as
    described below:

    If :py:obj:`~.cudaMemAdviseSetReadMostly` was set on any subset of this
    memory range, then that subset will create a read-only copy of the
    pages on destination location. If however the destination location is a
    host NUMA node, then any pages of that subset that are already in
    another host NUMA node will be transferred to the destination.

    If :py:obj:`~.cudaMemAdviseSetPreferredLocation` was called on any
    subset of this memory range, then the pages will be migrated to
    `location` even if `location` is not the preferred location of any
    pages in the memory range.

    If :py:obj:`~.cudaMemAdviseSetAccessedBy` was called on any subset of
    this memory range, then mappings to those pages from all the
    appropriate processors are updated to refer to the new location if
    establishing such a mapping is possible. Otherwise, those mappings are
    cleared.

    Note that this API is not required for functionality and only serves to
    improve performance by allowing the application to migrate data to a
    suitable location before it is accessed. Memory accesses to this range
    are always coherent and are allowed even when the data is actively
    being migrated.

    Note that this function is asynchronous with respect to the host and
    all work on other devices.

    Parameters
    ----------
    devPtr : Any
        Pointer to be prefetched
    count : size_t
        Size in bytes
    location : :py:obj:`~.cudaMemLocation`
        location to prefetch to
    flags : unsigned int
        flags for future use, must be zero now.
    stream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        Stream to enqueue prefetch operation

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidDevice`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpyPeer`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy3DPeerAsync`, :py:obj:`~.cudaMemAdvise`, :py:obj:`~.cuMemPrefetchAsync`
    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    cydevPtr = _HelperInputVoidPtr(devPtr)
    cdef void* cydevPtr_ptr = <void*><void_ptr>cydevPtr.cptr
    with nogil:
        err = cyruntime.cudaMemPrefetchAsync(cydevPtr_ptr, count, location._pvt_ptr[0], flags, cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemPrefetchBatchAsync(dptrs : Optional[tuple[Any] | list[Any]], sizes : tuple[int] | list[int], size_t count, prefetchLocs : Optional[tuple[cudaMemLocation] | list[cudaMemLocation]], prefetchLocIdxs : tuple[int] | list[int], size_t numPrefetchLocs, unsigned long long flags, stream):
    """ Performs a batch of memory prefetches asynchronously.

    Performs a batch of memory prefetches. The batch as a whole executes in
    stream order but operations within a batch are not guaranteed to
    execute in any specific order. All devices in the system must have a
    non-zero value for the device attribute
    :py:obj:`~.cudaDevAttrConcurrentManagedAccess` otherwise the API will
    return an error.

    The semantics of the individual prefetch operations are as described in
    :py:obj:`~.cudaMemPrefetchAsync`.

    Performs memory prefetch on address ranges specified in `dptrs` and
    `sizes`. Both arrays must be of the same length as specified by
    `count`. Each memory range specified must refer to managed memory
    allocated via :py:obj:`~.cudaMallocManaged` or declared via managed
    variables or it may also refer to system-allocated memory when all
    devices have a non-zero value for
    :py:obj:`~.cudaDevAttrPageableMemoryAccess`. The prefetch location for
    every operation in the batch is specified in the `prefetchLocs` array.
    Each entry in this array can apply to more than one operation. This can
    be done by specifying in the `prefetchLocIdxs` array, the index of the
    first prefetch operation that the corresponding entry in the
    `prefetchLocs` array applies to. Both `prefetchLocs` and
    `prefetchLocIdxs` must be of the same length as specified by
    `numPrefetchLocs`. For example, if a batch has 10 prefetches listed in
    dptrs/sizes, the first 4 of which are to be prefetched to one location
    and the remaining 6 are to be prefetched to another, then
    `numPrefetchLocs` will be 2, `prefetchLocIdxs` will be {0, 4} and
    `prefetchLocs` will contain the two locations. Note the first entry in
    `prefetchLocIdxs` must always be 0. Also, each entry must be greater
    than the previous entry and the last entry should be less than `count`.
    Furthermore, `numPrefetchLocs` must be lesser than or equal to `count`.

    Parameters
    ----------
    dptrs : list[Any]
        Array of pointers to be prefetched
    sizes : list[int]
        Array of sizes for memory prefetch operations.
    count : size_t
        Size of `dptrs` and `sizes` arrays.
    prefetchLocs : list[:py:obj:`~.cudaMemLocation`]
        Array of locations to prefetch to.
    prefetchLocIdxs : list[int]
        Array of indices to specify which operands each entry in the
        `prefetchLocs` array applies to. The locations specified in
        prefetchLocs[k] will be applied to copies starting from
        prefetchLocIdxs[k] through prefetchLocIdxs[k+1] - 1. Also
        prefetchLocs[numPrefetchLocs - 1] will apply to prefetches starting
        from prefetchLocIdxs[numPrefetchLocs - 1] through count - 1.
    numPrefetchLocs : size_t
        Size of `prefetchLocs` and `prefetchLocIdxs` arrays.
    flags : unsigned long long
        Flags reserved for future use. Must be zero.
    hStream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        The stream to enqueue the operations in. Must not be legacy NULL
        stream.

    Returns
    -------
    cudaError_t

    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    if not all(isinstance(_x, (int)) for _x in prefetchLocIdxs):
        raise TypeError("Argument 'prefetchLocIdxs' is not instance of type (expected tuple[int] or list[int]")
    prefetchLocs = [] if prefetchLocs is None else prefetchLocs
    if not all(isinstance(_x, (cudaMemLocation,)) for _x in prefetchLocs):
        raise TypeError("Argument 'prefetchLocs' is not instance of type (expected tuple[cyruntime.cudaMemLocation,] or list[cyruntime.cudaMemLocation,]")
    if not all(isinstance(_x, (int)) for _x in sizes):
        raise TypeError("Argument 'sizes' is not instance of type (expected tuple[int] or list[int]")
    dptrs = [] if dptrs is None else dptrs
    pylist = [_HelperInputVoidPtr(pydptrs) for pydptrs in dptrs]
    cdef _InputVoidPtrPtrHelper voidStarHelperdptrs = _InputVoidPtrPtrHelper(pylist)
    cdef void** cydptrs_ptr = <void**><void_ptr>voidStarHelperdptrs.cptr
    cdef vector[size_t] cysizes = sizes
    if count > <size_t>len(dptrs): raise RuntimeError("List is too small: " + str(len(dptrs)) + " < " + str(count))
    if count > <size_t>len(sizes): raise RuntimeError("List is too small: " + str(len(sizes)) + " < " + str(count))
    cdef cyruntime.cudaMemLocation* cyprefetchLocs = NULL
    if len(prefetchLocs) > 1:
        cyprefetchLocs = <cyruntime.cudaMemLocation*> calloc(len(prefetchLocs), sizeof(cyruntime.cudaMemLocation))
        if cyprefetchLocs is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(prefetchLocs)) + 'x' + str(sizeof(cyruntime.cudaMemLocation)))
        for idx in range(len(prefetchLocs)):
            string.memcpy(&cyprefetchLocs[idx], (<cudaMemLocation>prefetchLocs[idx])._pvt_ptr, sizeof(cyruntime.cudaMemLocation))
    elif len(prefetchLocs) == 1:
        cyprefetchLocs = (<cudaMemLocation>prefetchLocs[0])._pvt_ptr
    cdef vector[size_t] cyprefetchLocIdxs = prefetchLocIdxs
    if numPrefetchLocs > <size_t>len(prefetchLocs): raise RuntimeError("List is too small: " + str(len(prefetchLocs)) + " < " + str(numPrefetchLocs))
    if numPrefetchLocs > <size_t>len(prefetchLocIdxs): raise RuntimeError("List is too small: " + str(len(prefetchLocIdxs)) + " < " + str(numPrefetchLocs))
    with nogil:
        err = cyruntime.cudaMemPrefetchBatchAsync(cydptrs_ptr, cysizes.data(), count, cyprefetchLocs, cyprefetchLocIdxs.data(), numPrefetchLocs, flags, cystream)
    if len(prefetchLocs) > 1 and cyprefetchLocs is not NULL:
        free(cyprefetchLocs)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemDiscardBatchAsync(dptrs : Optional[tuple[Any] | list[Any]], sizes : tuple[int] | list[int], size_t count, unsigned long long flags, stream):
    """ Performs a batch of memory discards asynchronously.

    Performs a batch of memory discards. The batch as a whole executes in
    stream order but operations within a batch are not guaranteed to
    execute in any specific order. All devices in the system must have a
    non-zero value for the device attribute
    :py:obj:`~.cudaDevAttrConcurrentManagedAccess` otherwise the API will
    return an error.

    Discarding a memory range informs the driver that the contents of that
    range are no longer useful. Discarding memory ranges allows the driver
    to optimize certain data migrations and can also help reduce memory
    pressure. This operation can be undone on any part of the range by
    either writing to it or prefetching it via
    :py:obj:`~.cudaMemPrefetchAsync` or
    :py:obj:`~.cudaMemPrefetchBatchAsync`. Reading from a discarded range,
    without a subsequent write or prefetch to that part of the range, will
    return an indeterminate value. Note that any reads, writes or
    prefetches to any part of the memory range that occur simultaneously
    with the discard operation result in undefined behavior.

    Performs memory discard on address ranges specified in `dptrs` and
    `sizes`. Both arrays must be of the same length as specified by
    `count`. Each memory range specified must refer to managed memory
    allocated via :py:obj:`~.cudaMallocManaged` or declared via managed
    variables or it may also refer to system-allocated memory when all
    devices have a non-zero value for
    :py:obj:`~.cudaDevAttrPageableMemoryAccess`.

    Parameters
    ----------
    dptrs : list[Any]
        Array of pointers to be discarded
    sizes : list[int]
        Array of sizes for memory discard operations.
    count : size_t
        Size of `dptrs` and `sizes` arrays.
    flags : unsigned long long
        Flags reserved for future use. Must be zero.
    hStream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        The stream to enqueue the operations in. Must not be legacy NULL
        stream.

    Returns
    -------
    cudaError_t

    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    if not all(isinstance(_x, (int)) for _x in sizes):
        raise TypeError("Argument 'sizes' is not instance of type (expected tuple[int] or list[int]")
    dptrs = [] if dptrs is None else dptrs
    pylist = [_HelperInputVoidPtr(pydptrs) for pydptrs in dptrs]
    cdef _InputVoidPtrPtrHelper voidStarHelperdptrs = _InputVoidPtrPtrHelper(pylist)
    cdef void** cydptrs_ptr = <void**><void_ptr>voidStarHelperdptrs.cptr
    cdef vector[size_t] cysizes = sizes
    if count > <size_t>len(dptrs): raise RuntimeError("List is too small: " + str(len(dptrs)) + " < " + str(count))
    if count > <size_t>len(sizes): raise RuntimeError("List is too small: " + str(len(sizes)) + " < " + str(count))
    with nogil:
        err = cyruntime.cudaMemDiscardBatchAsync(cydptrs_ptr, cysizes.data(), count, flags, cystream)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemDiscardAndPrefetchBatchAsync(dptrs : Optional[tuple[Any] | list[Any]], sizes : tuple[int] | list[int], size_t count, prefetchLocs : Optional[tuple[cudaMemLocation] | list[cudaMemLocation]], prefetchLocIdxs : tuple[int] | list[int], size_t numPrefetchLocs, unsigned long long flags, stream):
    """ Performs a batch of memory discards and prefetches asynchronously.

    Performs a batch of memory discards followed by prefetches. The batch
    as a whole executes in stream order but operations within a batch are
    not guaranteed to execute in any specific order. All devices in the
    system must have a non-zero value for the device attribute
    :py:obj:`~.cudaDevAttrConcurrentManagedAccess` otherwise the API will
    return an error.

    Calling :py:obj:`~.cudaMemDiscardAndPrefetchBatchAsync` is semantically
    equivalent to calling :py:obj:`~.cudaMemDiscardBatchAsync` followed by
    :py:obj:`~.cudaMemPrefetchBatchAsync`, but is more optimal. For more
    details on what discarding and prefetching imply, please refer to
    :py:obj:`~.cudaMemDiscardBatchAsync` and
    :py:obj:`~.cudaMemPrefetchBatchAsync` respectively. Note that any
    reads, writes or prefetches to any part of the memory range that occur
    simultaneously with this combined discard+prefetch operation result in
    undefined behavior.

    Performs memory discard and prefetch on address ranges specified in
    `dptrs` and `sizes`. Both arrays must be of the same length as
    specified by `count`. Each memory range specified must refer to managed
    memory allocated via :py:obj:`~.cudaMallocManaged` or declared via
    managed variables or it may also refer to system-allocated memory when
    all devices have a non-zero value for
    :py:obj:`~.cudaDevAttrPageableMemoryAccess`. Every operation in the
    batch has to be associated with a valid location to prefetch the
    address range to and specified in the `prefetchLocs` array. Each entry
    in this array can apply to more than one operation. This can be done by
    specifying in the `prefetchLocIdxs` array, the index of the first
    operation that the corresponding entry in the `prefetchLocs` array
    applies to. Both `prefetchLocs` and `prefetchLocIdxs` must be of the
    same length as specified by `numPrefetchLocs`. For example, if a batch
    has 10 operations listed in dptrs/sizes, the first 6 of which are to be
    prefetched to one location and the remaining 4 are to be prefetched to
    another, then `numPrefetchLocs` will be 2, `prefetchLocIdxs` will be
    {0, 6} and `prefetchLocs` will contain the two set of locations. Note
    the first entry in `prefetchLocIdxs` must always be 0. Also, each entry
    must be greater than the previous entry and the last entry should be
    less than `count`. Furthermore, `numPrefetchLocs` must be lesser than
    or equal to `count`.

    Parameters
    ----------
    dptrs : list[Any]
        Array of pointers to be discarded
    sizes : list[int]
        Array of sizes for memory discard operations.
    count : size_t
        Size of `dptrs` and `sizes` arrays.
    prefetchLocs : list[:py:obj:`~.cudaMemLocation`]
        Array of locations to prefetch to.
    prefetchLocIdxs : list[int]
        Array of indices to specify which operands each entry in the
        `prefetchLocs` array applies to. The locations specified in
        prefetchLocs[k] will be applied to operations starting from
        prefetchLocIdxs[k] through prefetchLocIdxs[k+1] - 1. Also
        prefetchLocs[numPrefetchLocs - 1] will apply to copies starting
        from prefetchLocIdxs[numPrefetchLocs - 1] through count - 1.
    numPrefetchLocs : size_t
        Size of `prefetchLocs` and `prefetchLocIdxs` arrays.
    flags : unsigned long long
        Flags reserved for future use. Must be zero.
    hStream : :py:obj:`~.CUstream` or :py:obj:`~.cudaStream_t`
        The stream to enqueue the operations in. Must not be legacy NULL
        stream.

    Returns
    -------
    cudaError_t

    """
    cdef cyruntime.cudaStream_t cystream
    if stream is None:
        pstream = 0
    elif isinstance(stream, (cudaStream_t,driver.CUstream)):
        pstream = int(stream)
    else:
        pstream = int(cudaStream_t(stream))
    cystream = <cyruntime.cudaStream_t><void_ptr>pstream
    if not all(isinstance(_x, (int)) for _x in prefetchLocIdxs):
        raise TypeError("Argument 'prefetchLocIdxs' is not instance of type (expected tuple[int] or list[int]")
    prefetchLocs = [] if prefetchLocs is None else prefetchLocs
    if not all(isinstance(_x, (cudaMemLocation,)) for _x in prefetchLocs):
        raise TypeError("Argument 'prefetchLocs' is not instance of type (expected tuple[cyruntime.cudaMemLocation,] or list[cyruntime.cudaMemLocation,]")
    if not all(isinstance(_x, (int)) for _x in sizes):
        raise TypeError("Argument 'sizes' is not instance of type (expected tuple[int] or list[int]")
    dptrs = [] if dptrs is None else dptrs
    pylist = [_HelperInputVoidPtr(pydptrs) for pydptrs in dptrs]
    cdef _InputVoidPtrPtrHelper voidStarHelperdptrs = _InputVoidPtrPtrHelper(pylist)
    cdef void** cydptrs_ptr = <void**><void_ptr>voidStarHelperdptrs.cptr
    cdef vector[size_t] cysizes = sizes
    if count > <size_t>len(dptrs): raise RuntimeError("List is too small: " + str(len(dptrs)) + " < " + str(count))
    if count > <size_t>len(sizes): raise RuntimeError("List is too small: " + str(len(sizes)) + " < " + str(count))
    cdef cyruntime.cudaMemLocation* cyprefetchLocs = NULL
    if len(prefetchLocs) > 1:
        cyprefetchLocs = <cyruntime.cudaMemLocation*> calloc(len(prefetchLocs), sizeof(cyruntime.cudaMemLocation))
        if cyprefetchLocs is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(prefetchLocs)) + 'x' + str(sizeof(cyruntime.cudaMemLocation)))
        for idx in range(len(prefetchLocs)):
            string.memcpy(&cyprefetchLocs[idx], (<cudaMemLocation>prefetchLocs[idx])._pvt_ptr, sizeof(cyruntime.cudaMemLocation))
    elif len(prefetchLocs) == 1:
        cyprefetchLocs = (<cudaMemLocation>prefetchLocs[0])._pvt_ptr
    cdef vector[size_t] cyprefetchLocIdxs = prefetchLocIdxs
    if numPrefetchLocs > <size_t>len(prefetchLocs): raise RuntimeError("List is too small: " + str(len(prefetchLocs)) + " < " + str(numPrefetchLocs))
    if numPrefetchLocs > <size_t>len(prefetchLocIdxs): raise RuntimeError("List is too small: " + str(len(prefetchLocIdxs)) + " < " + str(numPrefetchLocs))
    with nogil:
        err = cyruntime.cudaMemDiscardAndPrefetchBatchAsync(cydptrs_ptr, cysizes.data(), count, cyprefetchLocs, cyprefetchLocIdxs.data(), numPrefetchLocs, flags, cystream)
    if len(prefetchLocs) > 1 and cyprefetchLocs is not NULL:
        free(cyprefetchLocs)
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemAdvise(devPtr, size_t count, advice not None : cudaMemoryAdvise, location not None : cudaMemLocation):
    """ Advise about the usage of a given memory range.

    Advise the Unified Memory subsystem about the usage pattern for the
    memory range starting at `devPtr` with a size of `count` bytes. The
    start address and end address of the memory range will be rounded down
    and rounded up respectively to be aligned to CPU page size before the
    advice is applied. The memory range must refer to managed memory
    allocated via :py:obj:`~.cudaMallocManaged` or declared via managed
    variables. The memory range could also refer to system-allocated
    pageable memory provided it represents a valid, host-accessible region
    of memory and all additional constraints imposed by `advice` as
    outlined below are also satisfied. Specifying an invalid system-
    allocated pageable memory range results in an error being returned.

    The `advice` parameter can take the following values:

    - :py:obj:`~.cudaMemAdviseSetReadMostly`: This implies that the data is
      mostly going to be read from and only occasionally written to. Any
      read accesses from any processor to this region will create a read-
      only copy of at least the accessed pages in that processor's memory.
      Additionally, if :py:obj:`~.cudaMemPrefetchAsync` or
      :py:obj:`~.cudaMemPrefetchAsync` is called on this region, it will
      create a read-only copy of the data on the destination processor. If
      the target location for :py:obj:`~.cudaMemPrefetchAsync` is a host
      NUMA node and a read-only copy already exists on another host NUMA
      node, that copy will be migrated to the targeted host NUMA node. If
      any processor writes to this region, all copies of the corresponding
      page will be invalidated except for the one where the write occurred.
      If the writing processor is the CPU and the preferred location of the
      page is a host NUMA node, then the page will also be migrated to that
      host NUMA node. The `location` argument is ignored for this advice.
      Note that for a page to be read-duplicated, the accessing processor
      must either be the CPU or a GPU that has a non-zero value for the
      device attribute :py:obj:`~.cudaDevAttrConcurrentManagedAccess`.
      Also, if a context is created on a device that does not have the
      device attribute :py:obj:`~.cudaDevAttrConcurrentManagedAccess` set,
      then read-duplication will not occur until all such contexts are
      destroyed. If the memory region refers to valid system-allocated
      pageable memory, then the accessing device must have a non-zero value
      for the device attribute :py:obj:`~.cudaDevAttrPageableMemoryAccess`
      for a read-only copy to be created on that device. Note however that
      if the accessing device also has a non-zero value for the device
      attribute
      :py:obj:`~.cudaDevAttrPageableMemoryAccessUsesHostPageTables`, then
      setting this advice will not create a read-only copy when that device
      accesses this memory region.

    - :py:obj:`~.cudaMemAdviceUnsetReadMostly`: Undoes the effect of
      :py:obj:`~.cudaMemAdviseSetReadMostly` and also prevents the Unified
      Memory driver from attempting heuristic read-duplication on the
      memory range. Any read-duplicated copies of the data will be
      collapsed into a single copy. The location for the collapsed copy
      will be the preferred location if the page has a preferred location
      and one of the read-duplicated copies was resident at that location.
      Otherwise, the location chosen is arbitrary. Note: The `location`
      argument is ignored for this advice.

    - :py:obj:`~.cudaMemAdviseSetPreferredLocation`: This advice sets the
      preferred location for the data to be the memory belonging to
      `location`. When :py:obj:`~.cudaMemLocation.type` is
      :py:obj:`~.cudaMemLocationTypeHost`, :py:obj:`~.cudaMemLocation.id`
      is ignored and the preferred location is set to be host memory. To
      set the preferred location to a specific host NUMA node, applications
      must set :py:obj:`~.cudaMemLocation.type` to
      :py:obj:`~.cudaMemLocationTypeHostNuma` and
      :py:obj:`~.cudaMemLocation.id` must specify the NUMA ID of the host
      NUMA node. If :py:obj:`~.cudaMemLocation.type` is set to
      :py:obj:`~.cudaMemLocationTypeHostNumaCurrent`,
      :py:obj:`~.cudaMemLocation.id` will be ignored and the host NUMA node
      closest to the calling thread's CPU will be used as the preferred
      location. If :py:obj:`~.cudaMemLocation.type` is a
      :py:obj:`~.cudaMemLocationTypeDevice`, then
      :py:obj:`~.cudaMemLocation.id` must be a valid device ordinal and the
      device must have a non-zero value for the device attribute
      :py:obj:`~.cudaDevAttrConcurrentManagedAccess`. Setting the preferred
      location does not cause data to migrate to that location immediately.
      Instead, it guides the migration policy when a fault occurs on that
      memory region. If the data is already in its preferred location and
      the faulting processor can establish a mapping without requiring the
      data to be migrated, then data migration will be avoided. On the
      other hand, if the data is not in its preferred location or if a
      direct mapping cannot be established, then it will be migrated to the
      processor accessing it. It is important to note that setting the
      preferred location does not prevent data prefetching done using
      :py:obj:`~.cudaMemPrefetchAsync`. Having a preferred location can
      override the page thrash detection and resolution logic in the
      Unified Memory driver. Normally, if a page is detected to be
      constantly thrashing between for example host and device memory, the
      page may eventually be pinned to host memory by the Unified Memory
      driver. But if the preferred location is set as device memory, then
      the page will continue to thrash indefinitely. If
      :py:obj:`~.cudaMemAdviseSetReadMostly` is also set on this memory
      region or any subset of it, then the policies associated with that
      advice will override the policies of this advice, unless read
      accesses from `location` will not result in a read-only copy being
      created on that procesor as outlined in description for the advice
      :py:obj:`~.cudaMemAdviseSetReadMostly`. If the memory region refers
      to valid system-allocated pageable memory, and
      :py:obj:`~.cudaMemLocation.type` is
      :py:obj:`~.cudaMemLocationTypeDevice` then
      :py:obj:`~.cudaMemLocation.id` must be a valid device that has a non-
      zero alue for the device attribute
      :py:obj:`~.cudaDevAttrPageableMemoryAccess`.

    - :py:obj:`~.cudaMemAdviseUnsetPreferredLocation`: Undoes the effect of
      :py:obj:`~.cudaMemAdviseSetPreferredLocation` and changes the
      preferred location to none. The `location` argument is ignored for
      this advice.

    - :py:obj:`~.cudaMemAdviseSetAccessedBy`: This advice implies that the
      data will be accessed by processor `location`. The
      :py:obj:`~.cudaMemLocation.type` must be either
      :py:obj:`~.cudaMemLocationTypeDevice` with
      :py:obj:`~.cudaMemLocation.id` representing a valid device ordinal or
      :py:obj:`~.cudaMemLocationTypeHost` and
      :py:obj:`~.cudaMemLocation.id` will be ignored. All other location
      types are invalid. If :py:obj:`~.cudaMemLocation.id` is a GPU, then
      the device attribute :py:obj:`~.cudaDevAttrConcurrentManagedAccess`
      must be non-zero. This advice does not cause data migration and has
      no impact on the location of the data per se. Instead, it causes the
      data to always be mapped in the specified processor's page tables, as
      long as the location of the data permits a mapping to be established.
      If the data gets migrated for any reason, the mappings are updated
      accordingly. This advice is recommended in scenarios where data
      locality is not important, but avoiding faults is. Consider for
      example a system containing multiple GPUs with peer-to-peer access
      enabled, where the data located on one GPU is occasionally accessed
      by peer GPUs. In such scenarios, migrating data over to the other
      GPUs is not as important because the accesses are infrequent and the
      overhead of migration may be too high. But preventing faults can
      still help improve performance, and so having a mapping set up in
      advance is useful. Note that on CPU access of this data, the data may
      be migrated to host memory because the CPU typically cannot access
      device memory directly. Any GPU that had the
      :py:obj:`~.cudaMemAdviseSetAccessedBy` flag set for this data will
      now have its mapping updated to point to the page in host memory. If
      :py:obj:`~.cudaMemAdviseSetReadMostly` is also set on this memory
      region or any subset of it, then the policies associated with that
      advice will override the policies of this advice. Additionally, if
      the preferred location of this memory region or any subset of it is
      also `location`, then the policies associated with
      :py:obj:`~.CU_MEM_ADVISE_SET_PREFERRED_LOCATION` will override the
      policies of this advice. If the memory region refers to valid system-
      allocated pageable memory, and :py:obj:`~.cudaMemLocation.type` is
      :py:obj:`~.cudaMemLocationTypeDevice` then device in
      :py:obj:`~.cudaMemLocation.id` must have a non-zero value for the
      device attribute :py:obj:`~.cudaDevAttrPageableMemoryAccess`.
      Additionally, if :py:obj:`~.cudaMemLocation.id` has a non-zero value
      for the device attribute
      :py:obj:`~.cudaDevAttrPageableMemoryAccessUsesHostPageTables`, then
      this call has no effect.

    - :py:obj:`~.CU_MEM_ADVISE_UNSET_ACCESSED_BY`: Undoes the effect of
      :py:obj:`~.cudaMemAdviseSetAccessedBy`. Any mappings to the data from
      `location` may be removed at any time causing accesses to result in
      non-fatal page faults. If the memory region refers to valid system-
      allocated pageable memory, and :py:obj:`~.cudaMemLocation.type` is
      :py:obj:`~.cudaMemLocationTypeDevice` then device in
      :py:obj:`~.cudaMemLocation.id` must have a non-zero value for the
      device attribute :py:obj:`~.cudaDevAttrPageableMemoryAccess`.
      Additionally, if :py:obj:`~.cudaMemLocation.id` has a non-zero value
      for the device attribute
      :py:obj:`~.cudaDevAttrPageableMemoryAccessUsesHostPageTables`, then
      this call has no effect.

    Parameters
    ----------
    devPtr : Any
        Pointer to memory to set the advice for
    count : size_t
        Size in bytes of the memory range
    advice : :py:obj:`~.cudaMemoryAdvise`
        Advice to be applied for the specified memory range
    location : :py:obj:`~.cudaMemLocation`
        location to apply the advice for

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`, :py:obj:`~.cudaErrorInvalidDevice`

    See Also
    --------
    :py:obj:`~.cudaMemcpy`, :py:obj:`~.cudaMemcpyPeer`, :py:obj:`~.cudaMemcpyAsync`, :py:obj:`~.cudaMemcpy3DPeerAsync`, :py:obj:`~.cudaMemPrefetchAsync`, :py:obj:`~.cuMemAdvise`
    """
    cydevPtr = _HelperInputVoidPtr(devPtr)
    cdef void* cydevPtr_ptr = <void*><void_ptr>cydevPtr.cptr
    cdef cyruntime.cudaMemoryAdvise cyadvice = advice.value
    with nogil:
        err = cyruntime.cudaMemAdvise(cydevPtr_ptr, count, cyadvice, location._pvt_ptr[0])
    return (_dict_cudaError_t[err],)

@cython.embedsignature(True)
def cudaMemRangeGetAttribute(size_t dataSize, attribute not None : cudaMemRangeAttribute, devPtr, size_t count):
    """ Query an attribute of a given memory range.

    Query an attribute about the memory range starting at `devPtr` with a
    size of `count` bytes. The memory range must refer to managed memory
    allocated via :py:obj:`~.cudaMallocManaged` or declared via managed
    variables.

    The `attribute` parameter can take the following values:

    - :py:obj:`~.cudaMemRangeAttributeReadMostly`: If this attribute is
      specified, `data` will be interpreted as a 32-bit integer, and
      `dataSize` must be 4. The result returned will be 1 if all pages in
      the given memory range have read-duplication enabled, or 0 otherwise.

    - :py:obj:`~.cudaMemRangeAttributePreferredLocation`: If this attribute
      is specified, `data` will be interpreted as a 32-bit integer, and
      `dataSize` must be 4. The result returned will be a GPU device id if
      all pages in the memory range have that GPU as their preferred
      location, or it will be cudaCpuDeviceId if all pages in the memory
      range have the CPU as their preferred location, or it will be
      cudaInvalidDeviceId if either all the pages don't have the same
      preferred location or some of the pages don't have a preferred
      location at all. Note that the actual location of the pages in the
      memory range at the time of the query may be different from the
      preferred location.

    - :py:obj:`~.cudaMemRangeAttributeAccessedBy`: If this attribute is
      specified, `data` will be interpreted as an array of 32-bit integers,
      and `dataSize` must be a non-zero multiple of 4. The result returned
      will be a list of device ids that had
      :py:obj:`~.cudaMemAdviceSetAccessedBy` set for that entire memory
      range. If any device does not have that advice set for the entire
      memory range, that device will not be included. If `data` is larger
      than the number of devices that have that advice set for that memory
      range, cudaInvalidDeviceId will be returned in all the extra space
      provided. For ex., if `dataSize` is 12 (i.e. `data` has 3 elements)
      and only device 0 has the advice set, then the result returned will
      be { 0, cudaInvalidDeviceId, cudaInvalidDeviceId }. If `data` is
      smaller than the number of devices that have that advice set, then
      only as many devices will be returned as can fit in the array. There
      is no guarantee on which specific devices will be returned, however.

    - :py:obj:`~.cudaMemRangeAttributeLastPrefetchLocation`: If this
      attribute is specified, `data` will be interpreted as a 32-bit
      integer, and `dataSize` must be 4. The result returned will be the
      last location to which all pages in the memory range were prefetched
      explicitly via :py:obj:`~.cudaMemPrefetchAsync`. This will either be
      a GPU id or cudaCpuDeviceId depending on whether the last location
      for prefetch was a GPU or the CPU respectively. If any page in the
      memory range was never explicitly prefetched or if all pages were not
      prefetched to the same location, cudaInvalidDeviceId will be
      returned. Note that this simply returns the last location that the
      applicaton requested to prefetch the memory range to. It gives no
      indication as to whether the prefetch operation to that location has
      completed or even begun.

    - :py:obj:`~.cudaMemRangeAttributePreferredLocationType`: If this
      attribute is specified, `data` will be interpreted as a
      :py:obj:`~.cudaMemLocationType`, and `dataSize` must be
      sizeof(cudaMemLocationType). The :py:obj:`~.cudaMemLocationType`
      returned will be :py:obj:`~.cudaMemLocationTypeDevice` if all pages
      in the memory range have the same GPU as their preferred location, or
      :py:obj:`~.cudaMemLocationType` will be
      :py:obj:`~.cudaMemLocationTypeHost` if all pages in the memory range
      have the CPU as their preferred location, or or it will be
      :py:obj:`~.cudaMemLocationTypeHostNuma` if all the pages in the
      memory range have the same host NUMA node ID as their preferred
      location or it will be :py:obj:`~.cudaMemLocationTypeInvalid` if
      either all the pages don't have the same preferred location or some
      of the pages don't have a preferred location at all. Note that the
      actual location type of the pages in the memory range at the time of
      the query may be different from the preferred location type.

      - :py:obj:`~.cudaMemRangeAttributePreferredLocationId`: If this
        attribute is specified, `data` will be interpreted as a 32-bit
        integer, and `dataSize` must be 4. If the
        :py:obj:`~.cudaMemRangeAttributePreferredLocationType` query for
        the same address range returns
        :py:obj:`~.cudaMemLocationTypeDevice`, it will be a valid device
        ordinal or if it returns :py:obj:`~.cudaMemLocationTypeHostNuma`,
        it will be a valid host NUMA node ID or if it returns any other
        location type, the id should be ignored.

    - :py:obj:`~.cudaMemRangeAttributeLastPrefetchLocationType`: If this
      attribute is specified, `data` will be interpreted as a
      :py:obj:`~.cudaMemLocationType`, and `dataSize` must be
      sizeof(cudaMemLocationType). The result returned will be the last
      location type to which all pages in the memory range were prefetched
      explicitly via :py:obj:`~.cuMemPrefetchAsync`. The
      :py:obj:`~.cudaMemLocationType` returned will be
      :py:obj:`~.cudaMemLocationTypeDevice` if the last prefetch location
      was the GPU or :py:obj:`~.cudaMemLocationTypeHost` if it was the CPU
      or :py:obj:`~.cudaMemLocationTypeHostNuma` if the last prefetch
      location was a specific host NUMA node. If any page in the memory
      range was never explicitly prefetched or if all pages were not
      prefetched to the same location, :py:obj:`~.CUmemLocationType` will
      be :py:obj:`~.cudaMemLocationTypeInvalid`. Note that this simply
      returns the last location type that the application requested to
      prefetch the memory range to. It gives no indication as to whether
      the prefetch operation to that location has completed or even begun.

      - :py:obj:`~.cudaMemRangeAttributeLastPrefetchLocationId`: If this
        attribute is specified, `data` will be interpreted as a 32-bit
        integer, and `dataSize` must be 4. If the
        :py:obj:`~.cudaMemRangeAttributeLastPrefetchLocationType` query for
        the same address range returns
        :py:obj:`~.cudaMemLocationTypeDevice`, it will be a valid device
        ordinal or if it returns :py:obj:`~.cudaMemLocationTypeHostNuma`,
        it will be a valid host NUMA node ID or if it returns any other
        location type, the id should be ignored.

    Parameters
    ----------
    dataSize : size_t
        Array containing the size of data
    attribute : :py:obj:`~.cudaMemRangeAttribute`
        The attribute to query
    devPtr : Any
        Start of the range to query
    count : size_t
        Size of the range to query

    Returns
    -------
    cudaError_t
        :py:obj:`~.cudaSuccess`, :py:obj:`~.cudaErrorInvalidValue`
    data : Any
        A pointers to a memory location where the result of each attribute
        query will be written to.

    See Also
    --------
    :py:obj:`~.cudaMemRangeGetAttributes`, :py:obj:`~.cudaMemPrefetchAsync`, :py:obj:`~.cudaMemAdvise`, :py:obj:`~.cuMemRangeGetAttribute`
    """
    cdef _HelperCUmem_range_attribute cydata = _HelperCUmem_range_attribute(attribute, dataSize)
    cdef void* cydata_ptr = <void*><void_ptr>cydata.cptr
    cdef cyruntime.cudaMemRangeAttribute cyattribute = attribute.value
    cydevPtr = _HelperInputVoidPtr(devPtr)
    cdef void* cydevPtr_ptr = <void*><void_ptr>cydevPtr.cptr
    with nogil:
        err = cyruntime.cudaMemRangeGetAttribute(cydata_ptr, dataSize, cyattribute, cydevPtr_ptr, count)
    if err != cyruntime.cudaSuccess:
        return (_dict_cudaError_t[err], None)
    return (_dict_cudaError_t[err], cydata.pyObj())

@cython.embedsignature(True)
def cudaMemRangeGetAttributes(dataSizes : tuple[int] | list[int], attributes : Optional[tuple[cudaMemRangeAttribute] | list[cudaMemRangeAttribute]], size_t numAttributes, devPtr, size_t count):
    """ Query attributes of a given memory range.

    Query attributes of the memory range starting at `devPtr` with a size
    of `count` bytes. The memory range must refer to managed memory
    allocated via :py:obj:`~.cudaMallocManaged` or declared via managed
    variables. The `attributes` array will be interpreted to have
    `numAttributes` entries. The `dataSizes` array will also be interpreted
    to have `numAttributes` entries. The results of the query will be
    stored in `data`.

    The list of supported attributes are given below. Please refer to
    :py:obj:`~.cudaMemRangeGetAttribute` for attribute descriptions and
    restrictions.

    - :py:obj:`~.cudaMemRangeAttributeReadMostly`

    - :py:obj:`~.cudaMemRangeAttributePreferredLocation`

    - :py:obj:`~.cudaMemRangeAttributeAccessedBy`

    - :py:obj:`~.cudaMemRangeAttributeLastPrefetchLocation`

    - :: cudaMemRangeAttributePreferredLocationType

    - :: cudaMemRangeAttributePreferredLocationId

    - :: cudaMemRangeAttributeLastPrefetchLocationType

    - :: cudaMemRangeAttributeLastPrefetchLocationId

    Parameters
    ----------
    dataSizes : list[int]
        Array containing the sizes of each result
    attributes : list[:py:obj:`~.cudaMemRangeAttribute